/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAccountCreationRequest
extends APINode {
    @SerializedName(value="ad_accounts_currency")
    private String mAdAccountsCurrency = null;
    @SerializedName(value="ad_accounts_info")
    private List<Object> mAdAccountsInfo = null;
    @SerializedName(value="additional_comment")
    private String mAdditionalComment = null;
    @SerializedName(value="address_in_chinese")
    private String mAddressInChinese = null;
    @SerializedName(value="address_in_english")
    private Object mAddressInEnglish = null;
    @SerializedName(value="address_in_local_language")
    private String mAddressInLocalLanguage = null;
    @SerializedName(value="advertiser_business")
    private Business mAdvertiserBusiness = null;
    @SerializedName(value="appeal_reason")
    private Object mAppealReason = null;
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="business_registration_id")
    private String mBusinessRegistrationId = null;
    @SerializedName(value="chinese_legal_entity_name")
    private String mChineseLegalEntityName = null;
    @SerializedName(value="contact")
    private Object mContact = null;
    @SerializedName(value="creator")
    private User mCreator = null;
    @SerializedName(value="credit_card_id")
    private String mCreditCardId = null;
    @SerializedName(value="disapproval_reasons")
    private List<Object> mDisapprovalReasons = null;
    @SerializedName(value="english_legal_entity_name")
    private String mEnglishLegalEntityName = null;
    @SerializedName(value="extended_credit_id")
    private String mExtendedCreditId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_smb")
    private Boolean mIsSmb = null;
    @SerializedName(value="is_test")
    private Boolean mIsTest = null;
    @SerializedName(value="is_under_authorization")
    private Boolean mIsUnderAuthorization = null;
    @SerializedName(value="legal_entity_name_in_local_language")
    private String mLegalEntityNameInLocalLanguage = null;
    @SerializedName(value="oe_request_id")
    private String mOeRequestId = null;
    @SerializedName(value="official_website_url")
    private String mOfficialWebsiteUrl = null;
    @SerializedName(value="planning_agency_business")
    private Business mPlanningAgencyBusiness = null;
    @SerializedName(value="planning_agency_business_id")
    private String mPlanningAgencyBusinessId = null;
    @SerializedName(value="promotable_app_ids")
    private List<String> mPromotableAppIds = null;
    @SerializedName(value="promotable_page_ids")
    private List<String> mPromotablePageIds = null;
    @SerializedName(value="promotable_urls")
    private List<String> mPromotableUrls = null;
    @SerializedName(value="request_change_reasons")
    private List<Object> mRequestChangeReasons = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="subvertical")
    private String mSubvertical = null;
    @SerializedName(value="time_created")
    private String mTimeCreated = null;
    @SerializedName(value="vertical")
    private String mVertical = null;
    protected static Gson gson = null;

    AdAccountCreationRequest() {
    }

    public AdAccountCreationRequest(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdAccountCreationRequest(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdAccountCreationRequest fetch() throws APIException {
        AdAccountCreationRequest newInstance = AdAccountCreationRequest.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdAccountCreationRequest fetchById(Long id, APIContext context) throws APIException {
        return AdAccountCreationRequest.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdAccountCreationRequest> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdAccountCreationRequest.fetchByIdAsync(id.toString(), context);
    }

    public static AdAccountCreationRequest fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdAccountCreationRequest> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdAccountCreationRequest> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdAccountCreationRequest>(context, "", "/", "GET", AdAccountCreationRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdAccountCreationRequest>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdAccountCreationRequest>(context, "", "/", "GET", AdAccountCreationRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAccountCreationRequest loadJSON(String json, APIContext context, String header) {
        AdAccountCreationRequest adAccountCreationRequest = (AdAccountCreationRequest)AdAccountCreationRequest.getGson().fromJson(json, AdAccountCreationRequest.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAccountCreationRequest.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAccountCreationRequest.context = context;
        adAccountCreationRequest.rawValue = json;
        adAccountCreationRequest.header = header;
        return adAccountCreationRequest;
    }

    public static APINodeList<AdAccountCreationRequest> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAccountCreationRequest> adAccountCreationRequests = new APINodeList<AdAccountCreationRequest>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAccountCreationRequests.add(AdAccountCreationRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adAccountCreationRequests;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAccountCreationRequests.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAccountCreationRequests.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAccountCreationRequests.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAccountCreationRequests.add(AdAccountCreationRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAccountCreationRequests.add(AdAccountCreationRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAccountCreationRequests.add(AdAccountCreationRequest.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adAccountCreationRequests;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAccountCreationRequests.add(AdAccountCreationRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adAccountCreationRequests;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAccountCreationRequests.add(AdAccountCreationRequest.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAccountCreationRequests;
                }
                adAccountCreationRequests.clear();
                adAccountCreationRequests.add(AdAccountCreationRequest.loadJSON(json, context, header));
                return adAccountCreationRequests;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAccountCreationRequest.getGson().toJson((Object)this);
    }

    public APIRequestGetAdAccounts getAdAccounts() {
        return new APIRequestGetAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateVietnam createVietnam() {
        return new APIRequestCreateVietnam(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAdAccountsCurrency() {
        return this.mAdAccountsCurrency;
    }

    public List<Object> getFieldAdAccountsInfo() {
        return this.mAdAccountsInfo;
    }

    public String getFieldAdditionalComment() {
        return this.mAdditionalComment;
    }

    public String getFieldAddressInChinese() {
        return this.mAddressInChinese;
    }

    public Object getFieldAddressInEnglish() {
        return this.mAddressInEnglish;
    }

    public String getFieldAddressInLocalLanguage() {
        return this.mAddressInLocalLanguage;
    }

    public Business getFieldAdvertiserBusiness() {
        if (this.mAdvertiserBusiness != null) {
            this.mAdvertiserBusiness.context = this.getContext();
        }
        return this.mAdvertiserBusiness;
    }

    public Object getFieldAppealReason() {
        return this.mAppealReason;
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public String getFieldBusinessRegistrationId() {
        return this.mBusinessRegistrationId;
    }

    public String getFieldChineseLegalEntityName() {
        return this.mChineseLegalEntityName;
    }

    public Object getFieldContact() {
        return this.mContact;
    }

    public User getFieldCreator() {
        if (this.mCreator != null) {
            this.mCreator.context = this.getContext();
        }
        return this.mCreator;
    }

    public String getFieldCreditCardId() {
        return this.mCreditCardId;
    }

    public List<Object> getFieldDisapprovalReasons() {
        return this.mDisapprovalReasons;
    }

    public String getFieldEnglishLegalEntityName() {
        return this.mEnglishLegalEntityName;
    }

    public String getFieldExtendedCreditId() {
        return this.mExtendedCreditId;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsSmb() {
        return this.mIsSmb;
    }

    public Boolean getFieldIsTest() {
        return this.mIsTest;
    }

    public Boolean getFieldIsUnderAuthorization() {
        return this.mIsUnderAuthorization;
    }

    public String getFieldLegalEntityNameInLocalLanguage() {
        return this.mLegalEntityNameInLocalLanguage;
    }

    public String getFieldOeRequestId() {
        return this.mOeRequestId;
    }

    public String getFieldOfficialWebsiteUrl() {
        return this.mOfficialWebsiteUrl;
    }

    public Business getFieldPlanningAgencyBusiness() {
        if (this.mPlanningAgencyBusiness != null) {
            this.mPlanningAgencyBusiness.context = this.getContext();
        }
        return this.mPlanningAgencyBusiness;
    }

    public String getFieldPlanningAgencyBusinessId() {
        return this.mPlanningAgencyBusinessId;
    }

    public List<String> getFieldPromotableAppIds() {
        return this.mPromotableAppIds;
    }

    public List<String> getFieldPromotablePageIds() {
        return this.mPromotablePageIds;
    }

    public List<String> getFieldPromotableUrls() {
        return this.mPromotableUrls;
    }

    public List<Object> getFieldRequestChangeReasons() {
        return this.mRequestChangeReasons;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldSubvertical() {
        return this.mSubvertical;
    }

    public String getFieldTimeCreated() {
        return this.mTimeCreated;
    }

    public String getFieldVertical() {
        return this.mVertical;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAccountCreationRequest copyFrom(AdAccountCreationRequest instance) {
        this.mAdAccountsCurrency = instance.mAdAccountsCurrency;
        this.mAdAccountsInfo = instance.mAdAccountsInfo;
        this.mAdditionalComment = instance.mAdditionalComment;
        this.mAddressInChinese = instance.mAddressInChinese;
        this.mAddressInEnglish = instance.mAddressInEnglish;
        this.mAddressInLocalLanguage = instance.mAddressInLocalLanguage;
        this.mAdvertiserBusiness = instance.mAdvertiserBusiness;
        this.mAppealReason = instance.mAppealReason;
        this.mBusiness = instance.mBusiness;
        this.mBusinessRegistrationId = instance.mBusinessRegistrationId;
        this.mChineseLegalEntityName = instance.mChineseLegalEntityName;
        this.mContact = instance.mContact;
        this.mCreator = instance.mCreator;
        this.mCreditCardId = instance.mCreditCardId;
        this.mDisapprovalReasons = instance.mDisapprovalReasons;
        this.mEnglishLegalEntityName = instance.mEnglishLegalEntityName;
        this.mExtendedCreditId = instance.mExtendedCreditId;
        this.mId = instance.mId;
        this.mIsSmb = instance.mIsSmb;
        this.mIsTest = instance.mIsTest;
        this.mIsUnderAuthorization = instance.mIsUnderAuthorization;
        this.mLegalEntityNameInLocalLanguage = instance.mLegalEntityNameInLocalLanguage;
        this.mOeRequestId = instance.mOeRequestId;
        this.mOfficialWebsiteUrl = instance.mOfficialWebsiteUrl;
        this.mPlanningAgencyBusiness = instance.mPlanningAgencyBusiness;
        this.mPlanningAgencyBusinessId = instance.mPlanningAgencyBusinessId;
        this.mPromotableAppIds = instance.mPromotableAppIds;
        this.mPromotablePageIds = instance.mPromotablePageIds;
        this.mPromotableUrls = instance.mPromotableUrls;
        this.mRequestChangeReasons = instance.mRequestChangeReasons;
        this.mStatus = instance.mStatus;
        this.mSubvertical = instance.mSubvertical;
        this.mTimeCreated = instance.mTimeCreated;
        this.mVertical = instance.mVertical;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAccountCreationRequest> getParser() {
        return new APIRequest.ResponseParser<AdAccountCreationRequest>(){

            @Override
            public APINodeList<AdAccountCreationRequest> parseResponse(String response, APIContext context, APIRequest<AdAccountCreationRequest> request, String header) throws APIException.MalformedResponseException {
                return AdAccountCreationRequest.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumVertical {
        VALUE_ADVERTISING_AND_MARKETING("ADVERTISING_AND_MARKETING"),
        VALUE_AUTOMOTIVE("AUTOMOTIVE"),
        VALUE_AUTO_AGENCY("AUTO_AGENCY"),
        VALUE_CONSUMER_PACKAGED_GOODS("CONSUMER_PACKAGED_GOODS"),
        VALUE_CPG_AND_BEVERAGE("CPG_AND_BEVERAGE"),
        VALUE_ECOMMERCE("ECOMMERCE"),
        VALUE_EDUCATION("EDUCATION"),
        VALUE_ENERGY_AND_UTILITIES("ENERGY_AND_UTILITIES"),
        VALUE_ENTERTAINMENT_AND_MEDIA("ENTERTAINMENT_AND_MEDIA"),
        VALUE_FINANCIAL_SERVICES("FINANCIAL_SERVICES"),
        VALUE_GAMING("GAMING"),
        VALUE_GOVERMENT_AND_POLITICS("GOVERMENT_AND_POLITICS"),
        VALUE_MOTORCYCLES("MOTORCYCLES"),
        VALUE_ORGANIZATIONS_AND_ASSOCIATIONS("ORGANIZATIONS_AND_ASSOCIATIONS"),
        VALUE_OTHER("OTHER"),
        VALUE_PROFESSIONAL_SERVICES("PROFESSIONAL_SERVICES"),
        VALUE_RETAIL("RETAIL"),
        VALUE_TECHNOLOGY("TECHNOLOGY"),
        VALUE_TELECOM("TELECOM"),
        VALUE_TRAVEL("TRAVEL");

        private String value;

        private EnumVertical(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumSubvertical {
        VALUE_ACCOUNTING_AND_TAXES_AND_LEGAL("ACCOUNTING_AND_TAXES_AND_LEGAL"),
        VALUE_AGRICULTURE_AND_FARMING("AGRICULTURE_AND_FARMING"),
        VALUE_AIR("AIR"),
        VALUE_AIR_FREIGHT_OR_PACKAGE("AIR_FREIGHT_OR_PACKAGE"),
        VALUE_APPAREL_AND_ACCESSORIES("APPAREL_AND_ACCESSORIES"),
        VALUE_ARTS("ARTS"),
        VALUE_AUCTIONS("AUCTIONS"),
        VALUE_AUTOMOTIVE_MANUFACTURER("AUTOMOTIVE_MANUFACTURER"),
        VALUE_AUTO_AGENCY("AUTO_AGENCY"),
        VALUE_AUTO_RENTAL("AUTO_RENTAL"),
        VALUE_B2B("B2B"),
        VALUE_B2B_MANUFACTURING("B2B_MANUFACTURING"),
        VALUE_BEAUTY_AND_PERSONAL_CARE("BEAUTY_AND_PERSONAL_CARE"),
        VALUE_BEER_AND_WINE_AND_LIQUOR("BEER_AND_WINE_AND_LIQUOR"),
        VALUE_BOOKSTORES("BOOKSTORES"),
        VALUE_BUSINESS_SUPPORT_SERVICES("BUSINESS_SUPPORT_SERVICES"),
        VALUE_BUS_AND_TAXI_AND_AUTO_RETAL("BUS_AND_TAXI_AND_AUTO_RETAL"),
        VALUE_CABLE_AND_SATELLITE("CABLE_AND_SATELLITE"),
        VALUE_CAREER("CAREER"),
        VALUE_COMPUTING_AND_PERIPHERALS("COMPUTING_AND_PERIPHERALS"),
        VALUE_CONSOLE_DEVELOPER("CONSOLE_DEVELOPER"),
        VALUE_CONSOLE_DEVICE("CONSOLE_DEVICE"),
        VALUE_CONSTRUCTION_AND_MINING("CONSTRUCTION_AND_MINING"),
        VALUE_CONSULTING("CONSULTING"),
        VALUE_CONSUMER_ELECTRONICS("CONSUMER_ELECTRONICS"),
        VALUE_CONSUMER_TECH("CONSUMER_TECH"),
        VALUE_CREDIT_AND_FINANCING_AND_MORTAGES("CREDIT_AND_FINANCING_AND_MORTAGES"),
        VALUE_CRUISES_AND_MARINE("CRUISES_AND_MARINE"),
        VALUE_CVB_CONVENTION_AND_VISITORS_BUREAU("CVB_CONVENTION_AND_VISITORS_BUREAU"),
        VALUE_DAILYDEALS("DAILYDEALS"),
        VALUE_DATING("DATING"),
        VALUE_DEALERSHIP("DEALERSHIP"),
        VALUE_DEPARTMENT_STORE("DEPARTMENT_STORE"),
        VALUE_DESKTOP_SOFTWARE("DESKTOP_SOFTWARE"),
        VALUE_DIGITAL_ADVERTISING_AND_MARKETING_OR_UNTAGGED_AGENCIES("DIGITAL_ADVERTISING_AND_MARKETING_OR_UNTAGGED_AGENCIES"),
        VALUE_ECATALOG("ECATALOG"),
        VALUE_ECOMMERCE_AGRICULTURE_AND_FARMING("ECOMMERCE_AGRICULTURE_AND_FARMING"),
        VALUE_EDUCATION_RESOURCES("EDUCATION_RESOURCES"),
        VALUE_ED_TECH("ED_TECH"),
        VALUE_ELEARNING_AND_MASSIVE_ONLINE_OPEN_COURSES("ELEARNING_AND_MASSIVE_ONLINE_OPEN_COURSES"),
        VALUE_ENGINEERING_AND_DESIGN("ENGINEERING_AND_DESIGN"),
        VALUE_EVENTS("EVENTS"),
        VALUE_FAMILY_AND_HEALTH("FAMILY_AND_HEALTH"),
        VALUE_FITNESS("FITNESS"),
        VALUE_FOOD("FOOD"),
        VALUE_FOOTWEAR("FOOTWEAR"),
        VALUE_FOR_PROFIT_COLLEGES_AND_UNIVERSITIES("FOR_PROFIT_COLLEGES_AND_UNIVERSITIES"),
        VALUE_GAMBLING("GAMBLING"),
        VALUE_GOVERNMENT("GOVERNMENT"),
        VALUE_GROCERY_AND_DRUG_AND_CONVENIENCE("GROCERY_AND_DRUG_AND_CONVENIENCE"),
        VALUE_HIGHWAYS("HIGHWAYS"),
        VALUE_HOME_AND_OFFICE("HOME_AND_OFFICE"),
        VALUE_HOME_IMPROVEMENT("HOME_IMPROVEMENT"),
        VALUE_HOME_SERVICE("HOME_SERVICE"),
        VALUE_HOTEL_AND_ACCOMODATION("HOTEL_AND_ACCOMODATION"),
        VALUE_HOUSEHOLD_GOODS("HOUSEHOLD_GOODS"),
        VALUE_INDUSTRIAL_AND_FARM_VEHICLE("INDUSTRIAL_AND_FARM_VEHICLE"),
        VALUE_INSURANCE("INSURANCE"),
        VALUE_INVESTMENT_BANK_AND_BROKERAGE("INVESTMENT_BANK_AND_BROKERAGE"),
        VALUE_MEDIA("MEDIA"),
        VALUE_MOBILE_AND_SOCIAL("MOBILE_AND_SOCIAL"),
        VALUE_MOBILE_APPS("MOBILE_APPS"),
        VALUE_MOTORCYCLES("MOTORCYCLES"),
        VALUE_MOVIES("MOVIES"),
        VALUE_MUSEUMS_AND_PARKS_AND_LIBRARIES("MUSEUMS_AND_PARKS_AND_LIBRARIES"),
        VALUE_MUSIC_AND_RADIO("MUSIC_AND_RADIO"),
        VALUE_NON_PROFIT("NON_PROFIT"),
        VALUE_NOT_FOR_PROFIT_COLLEGES_AND_UNIVERSITIES("NOT_FOR_PROFIT_COLLEGES_AND_UNIVERSITIES"),
        VALUE_OFFICE("OFFICE"),
        VALUE_OIL_AND_GAS_AND_CONSUMABLE_FUEL("OIL_AND_GAS_AND_CONSUMABLE_FUEL"),
        VALUE_ONLINE_OR_SOFTWARE("ONLINE_OR_SOFTWARE"),
        VALUE_OTHER_WIRELINE_SERVICES("OTHER_WIRELINE_SERVICES"),
        VALUE_PARTS_AND_SERVICE("PARTS_AND_SERVICE"),
        VALUE_PET("PET"),
        VALUE_PET_RETAIL("PET_RETAIL"),
        VALUE_PHARMACEUTICAL_OR_HEALTH("PHARMACEUTICAL_OR_HEALTH"),
        VALUE_PHOTOGRAPHY_AND_FILMING_SERVICES("PHOTOGRAPHY_AND_FILMING_SERVICES"),
        VALUE_POLITICAL("POLITICAL"),
        VALUE_PR("PR"),
        VALUE_PUBLISHING_INTERNET("PUBLISHING_INTERNET"),
        VALUE_RAILROADS("RAILROADS"),
        VALUE_REAL_ESTATE("REAL_ESTATE"),
        VALUE_REAL_MONEY_OR_SKILLED_GAMING("REAL_MONEY_OR_SKILLED_GAMING"),
        VALUE_RECREATIONAL("RECREATIONAL"),
        VALUE_RELIGIOUS("RELIGIOUS"),
        VALUE_RESTAURANT("RESTAURANT"),
        VALUE_RETAIL_AND_CREDIT_UNION_AND_COMMERCIAL_BANK("RETAIL_AND_CREDIT_UNION_AND_COMMERCIAL_BANK"),
        VALUE_SCHOOL_AND_EARLY_CHILDREN_EDCATION("SCHOOL_AND_EARLY_CHILDREN_EDCATION"),
        VALUE_SEASONAL_POLITICAL_SPENDERS("SEASONAL_POLITICAL_SPENDERS"),
        VALUE_SMB_AGENTS_AND_PROMOTERS("SMB_AGENTS_AND_PROMOTERS"),
        VALUE_SMB_ARTISTS_AND_PERFORMERS("SMB_ARTISTS_AND_PERFORMERS"),
        VALUE_SMB_CANVAS("SMB_CANVAS"),
        VALUE_SMB_CATALOG("SMB_CATALOG"),
        VALUE_SMB_CONSUMER_MOBILE_DEVICE("SMB_CONSUMER_MOBILE_DEVICE"),
        VALUE_SMB_CROSS_PLATFORM("SMB_CROSS_PLATFORM"),
        VALUE_SMB_ELECTRONICS_AND_APPLIANCES("SMB_ELECTRONICS_AND_APPLIANCES"),
        VALUE_SMB_ENERGY("SMB_ENERGY"),
        VALUE_SMB_GAME_AND_TOY("SMB_GAME_AND_TOY"),
        VALUE_SMB_INFORMATION("SMB_INFORMATION"),
        VALUE_SMB_NAVIGATION_AND_MEASUREMENT("SMB_NAVIGATION_AND_MEASUREMENT"),
        VALUE_SMB_OPERATIONS_AND_OTHER("SMB_OPERATIONS_AND_OTHER"),
        VALUE_SMB_OTHER("SMB_OTHER"),
        VALUE_SMB_PERSONAL_CARE("SMB_PERSONAL_CARE"),
        VALUE_SMB_RELIGIOUS("SMB_RELIGIOUS"),
        VALUE_SMB_RENTALS("SMB_RENTALS"),
        VALUE_SMB_REPAIR_AND_MAINTENANCE("SMB_REPAIR_AND_MAINTENANCE"),
        VALUE_SOFTWARE("SOFTWARE"),
        VALUE_SPORTING("SPORTING"),
        VALUE_SPORTS("SPORTS"),
        VALUE_STREAMING("STREAMING"),
        VALUE_TELEVISION("TELEVISION"),
        VALUE_TOBACCO("TOBACCO"),
        VALUE_TOY_AND_HOBBY("TOY_AND_HOBBY"),
        VALUE_TRADE_SCHOOL("TRADE_SCHOOL"),
        VALUE_TRANSPORTATION_EQUIPMENT("TRANSPORTATION_EQUIPMENT"),
        VALUE_TRAVAL_AGENCY("TRAVAL_AGENCY"),
        VALUE_TRUCK_AND_MOVING("TRUCK_AND_MOVING"),
        VALUE_UTILITIES_AND_ENERGY_EQUIPMENT_AND_SERVICES("UTILITIES_AND_ENERGY_EQUIPMENT_AND_SERVICES"),
        VALUE_WATER_AND_SOFT_DRINK_AND_BAVERAGE("WATER_AND_SOFT_DRINK_AND_BAVERAGE"),
        VALUE_WIRELESS_SERVICES("WIRELESS_SERVICES");

        private String value;

        private EnumSubvertical(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdAccountCreationRequest> {
        AdAccountCreationRequest lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_accounts_currency", "ad_accounts_info", "additional_comment", "address_in_chinese", "address_in_english", "address_in_local_language", "advertiser_business", "appeal_reason", "business", "business_registration_id", "chinese_legal_entity_name", "contact", "creator", "credit_card_id", "disapproval_reasons", "english_legal_entity_name", "extended_credit_id", "id", "is_smb", "is_test", "is_under_authorization", "legal_entity_name_in_local_language", "oe_request_id", "official_website_url", "planning_agency_business", "planning_agency_business_id", "promotable_app_ids", "promotable_page_ids", "promotable_urls", "request_change_reasons", "status", "subvertical", "time_created", "vertical"};

        @Override
        public AdAccountCreationRequest getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccountCreationRequest parseResponse(String response, String header) throws APIException {
            return AdAccountCreationRequest.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdAccountCreationRequest execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccountCreationRequest execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdAccountCreationRequest> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccountCreationRequest> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdAccountCreationRequest>(){

                public AdAccountCreationRequest apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdAccountsCurrencyField() {
            return this.requestAdAccountsCurrencyField(true);
        }

        public APIRequestGet requestAdAccountsCurrencyField(boolean value) {
            this.requestField("ad_accounts_currency", value);
            return this;
        }

        public APIRequestGet requestAdAccountsInfoField() {
            return this.requestAdAccountsInfoField(true);
        }

        public APIRequestGet requestAdAccountsInfoField(boolean value) {
            this.requestField("ad_accounts_info", value);
            return this;
        }

        public APIRequestGet requestAdditionalCommentField() {
            return this.requestAdditionalCommentField(true);
        }

        public APIRequestGet requestAdditionalCommentField(boolean value) {
            this.requestField("additional_comment", value);
            return this;
        }

        public APIRequestGet requestAddressInChineseField() {
            return this.requestAddressInChineseField(true);
        }

        public APIRequestGet requestAddressInChineseField(boolean value) {
            this.requestField("address_in_chinese", value);
            return this;
        }

        public APIRequestGet requestAddressInEnglishField() {
            return this.requestAddressInEnglishField(true);
        }

        public APIRequestGet requestAddressInEnglishField(boolean value) {
            this.requestField("address_in_english", value);
            return this;
        }

        public APIRequestGet requestAddressInLocalLanguageField() {
            return this.requestAddressInLocalLanguageField(true);
        }

        public APIRequestGet requestAddressInLocalLanguageField(boolean value) {
            this.requestField("address_in_local_language", value);
            return this;
        }

        public APIRequestGet requestAdvertiserBusinessField() {
            return this.requestAdvertiserBusinessField(true);
        }

        public APIRequestGet requestAdvertiserBusinessField(boolean value) {
            this.requestField("advertiser_business", value);
            return this;
        }

        public APIRequestGet requestAppealReasonField() {
            return this.requestAppealReasonField(true);
        }

        public APIRequestGet requestAppealReasonField(boolean value) {
            this.requestField("appeal_reason", value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestBusinessRegistrationIdField() {
            return this.requestBusinessRegistrationIdField(true);
        }

        public APIRequestGet requestBusinessRegistrationIdField(boolean value) {
            this.requestField("business_registration_id", value);
            return this;
        }

        public APIRequestGet requestChineseLegalEntityNameField() {
            return this.requestChineseLegalEntityNameField(true);
        }

        public APIRequestGet requestChineseLegalEntityNameField(boolean value) {
            this.requestField("chinese_legal_entity_name", value);
            return this;
        }

        public APIRequestGet requestContactField() {
            return this.requestContactField(true);
        }

        public APIRequestGet requestContactField(boolean value) {
            this.requestField("contact", value);
            return this;
        }

        public APIRequestGet requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGet requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGet requestCreditCardIdField() {
            return this.requestCreditCardIdField(true);
        }

        public APIRequestGet requestCreditCardIdField(boolean value) {
            this.requestField("credit_card_id", value);
            return this;
        }

        public APIRequestGet requestDisapprovalReasonsField() {
            return this.requestDisapprovalReasonsField(true);
        }

        public APIRequestGet requestDisapprovalReasonsField(boolean value) {
            this.requestField("disapproval_reasons", value);
            return this;
        }

        public APIRequestGet requestEnglishLegalEntityNameField() {
            return this.requestEnglishLegalEntityNameField(true);
        }

        public APIRequestGet requestEnglishLegalEntityNameField(boolean value) {
            this.requestField("english_legal_entity_name", value);
            return this;
        }

        public APIRequestGet requestExtendedCreditIdField() {
            return this.requestExtendedCreditIdField(true);
        }

        public APIRequestGet requestExtendedCreditIdField(boolean value) {
            this.requestField("extended_credit_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsSmbField() {
            return this.requestIsSmbField(true);
        }

        public APIRequestGet requestIsSmbField(boolean value) {
            this.requestField("is_smb", value);
            return this;
        }

        public APIRequestGet requestIsTestField() {
            return this.requestIsTestField(true);
        }

        public APIRequestGet requestIsTestField(boolean value) {
            this.requestField("is_test", value);
            return this;
        }

        public APIRequestGet requestIsUnderAuthorizationField() {
            return this.requestIsUnderAuthorizationField(true);
        }

        public APIRequestGet requestIsUnderAuthorizationField(boolean value) {
            this.requestField("is_under_authorization", value);
            return this;
        }

        public APIRequestGet requestLegalEntityNameInLocalLanguageField() {
            return this.requestLegalEntityNameInLocalLanguageField(true);
        }

        public APIRequestGet requestLegalEntityNameInLocalLanguageField(boolean value) {
            this.requestField("legal_entity_name_in_local_language", value);
            return this;
        }

        public APIRequestGet requestOeRequestIdField() {
            return this.requestOeRequestIdField(true);
        }

        public APIRequestGet requestOeRequestIdField(boolean value) {
            this.requestField("oe_request_id", value);
            return this;
        }

        public APIRequestGet requestOfficialWebsiteUrlField() {
            return this.requestOfficialWebsiteUrlField(true);
        }

        public APIRequestGet requestOfficialWebsiteUrlField(boolean value) {
            this.requestField("official_website_url", value);
            return this;
        }

        public APIRequestGet requestPlanningAgencyBusinessField() {
            return this.requestPlanningAgencyBusinessField(true);
        }

        public APIRequestGet requestPlanningAgencyBusinessField(boolean value) {
            this.requestField("planning_agency_business", value);
            return this;
        }

        public APIRequestGet requestPlanningAgencyBusinessIdField() {
            return this.requestPlanningAgencyBusinessIdField(true);
        }

        public APIRequestGet requestPlanningAgencyBusinessIdField(boolean value) {
            this.requestField("planning_agency_business_id", value);
            return this;
        }

        public APIRequestGet requestPromotableAppIdsField() {
            return this.requestPromotableAppIdsField(true);
        }

        public APIRequestGet requestPromotableAppIdsField(boolean value) {
            this.requestField("promotable_app_ids", value);
            return this;
        }

        public APIRequestGet requestPromotablePageIdsField() {
            return this.requestPromotablePageIdsField(true);
        }

        public APIRequestGet requestPromotablePageIdsField(boolean value) {
            this.requestField("promotable_page_ids", value);
            return this;
        }

        public APIRequestGet requestPromotableUrlsField() {
            return this.requestPromotableUrlsField(true);
        }

        public APIRequestGet requestPromotableUrlsField(boolean value) {
            this.requestField("promotable_urls", value);
            return this;
        }

        public APIRequestGet requestRequestChangeReasonsField() {
            return this.requestRequestChangeReasonsField(true);
        }

        public APIRequestGet requestRequestChangeReasonsField(boolean value) {
            this.requestField("request_change_reasons", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestSubverticalField() {
            return this.requestSubverticalField(true);
        }

        public APIRequestGet requestSubverticalField(boolean value) {
            this.requestField("subvertical", value);
            return this;
        }

        public APIRequestGet requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGet requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGet requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGet requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateVietnam
    extends APIRequest<AdAccountCreationRequest> {
        AdAccountCreationRequest lastResponse = null;
        public static final String[] PARAMS = new String[]{"ad_accounts_info", "additional_comment", "address_in_english", "address_in_local_language", "advertiser_business_id", "business_registration", "business_registration_id", "contact", "english_legal_entity_name", "legal_entity_name_in_local_language", "official_website_url", "planning_agency_business_id", "promotable_app_ids", "promotable_page_ids", "promotable_page_urls", "promotable_urls", "subvertical", "vertical"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdAccountCreationRequest getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccountCreationRequest parseResponse(String response, String header) throws APIException {
            return AdAccountCreationRequest.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdAccountCreationRequest execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccountCreationRequest execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdAccountCreationRequest> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccountCreationRequest> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdAccountCreationRequest>(){

                public AdAccountCreationRequest apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateVietnam.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateVietnam(String nodeId, APIContext context) {
            super(context, nodeId, "/vietnam", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateVietnam setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateVietnam setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateVietnam setAdAccountsInfo(List<Object> adAccountsInfo) {
            this.setParam("ad_accounts_info", adAccountsInfo);
            return this;
        }

        public APIRequestCreateVietnam setAdAccountsInfo(String adAccountsInfo) {
            this.setParam("ad_accounts_info", adAccountsInfo);
            return this;
        }

        public APIRequestCreateVietnam setAdditionalComment(String additionalComment) {
            this.setParam("additional_comment", additionalComment);
            return this;
        }

        public APIRequestCreateVietnam setAddressInEnglish(Object addressInEnglish) {
            this.setParam("address_in_english", addressInEnglish);
            return this;
        }

        public APIRequestCreateVietnam setAddressInEnglish(String addressInEnglish) {
            this.setParam("address_in_english", addressInEnglish);
            return this;
        }

        public APIRequestCreateVietnam setAddressInLocalLanguage(String addressInLocalLanguage) {
            this.setParam("address_in_local_language", addressInLocalLanguage);
            return this;
        }

        public APIRequestCreateVietnam setAdvertiserBusinessId(String advertiserBusinessId) {
            this.setParam("advertiser_business_id", advertiserBusinessId);
            return this;
        }

        public APIRequestCreateVietnam setBusinessRegistration(File businessRegistration) {
            this.setParam("business_registration", businessRegistration);
            return this;
        }

        public APIRequestCreateVietnam setBusinessRegistration(String businessRegistration) {
            this.setParam("business_registration", businessRegistration);
            return this;
        }

        public APIRequestCreateVietnam setBusinessRegistrationId(String businessRegistrationId) {
            this.setParam("business_registration_id", businessRegistrationId);
            return this;
        }

        public APIRequestCreateVietnam setContact(Object contact) {
            this.setParam("contact", contact);
            return this;
        }

        public APIRequestCreateVietnam setContact(String contact) {
            this.setParam("contact", contact);
            return this;
        }

        public APIRequestCreateVietnam setEnglishLegalEntityName(String englishLegalEntityName) {
            this.setParam("english_legal_entity_name", englishLegalEntityName);
            return this;
        }

        public APIRequestCreateVietnam setLegalEntityNameInLocalLanguage(String legalEntityNameInLocalLanguage) {
            this.setParam("legal_entity_name_in_local_language", legalEntityNameInLocalLanguage);
            return this;
        }

        public APIRequestCreateVietnam setOfficialWebsiteUrl(String officialWebsiteUrl) {
            this.setParam("official_website_url", officialWebsiteUrl);
            return this;
        }

        public APIRequestCreateVietnam setPlanningAgencyBusinessId(String planningAgencyBusinessId) {
            this.setParam("planning_agency_business_id", planningAgencyBusinessId);
            return this;
        }

        public APIRequestCreateVietnam setPromotableAppIds(List<String> promotableAppIds) {
            this.setParam("promotable_app_ids", promotableAppIds);
            return this;
        }

        public APIRequestCreateVietnam setPromotableAppIds(String promotableAppIds) {
            this.setParam("promotable_app_ids", promotableAppIds);
            return this;
        }

        public APIRequestCreateVietnam setPromotablePageIds(List<Long> promotablePageIds) {
            this.setParam("promotable_page_ids", promotablePageIds);
            return this;
        }

        public APIRequestCreateVietnam setPromotablePageIds(String promotablePageIds) {
            this.setParam("promotable_page_ids", promotablePageIds);
            return this;
        }

        public APIRequestCreateVietnam setPromotablePageUrls(List<String> promotablePageUrls) {
            this.setParam("promotable_page_urls", promotablePageUrls);
            return this;
        }

        public APIRequestCreateVietnam setPromotablePageUrls(String promotablePageUrls) {
            this.setParam("promotable_page_urls", promotablePageUrls);
            return this;
        }

        public APIRequestCreateVietnam setPromotableUrls(List<String> promotableUrls) {
            this.setParam("promotable_urls", promotableUrls);
            return this;
        }

        public APIRequestCreateVietnam setPromotableUrls(String promotableUrls) {
            this.setParam("promotable_urls", promotableUrls);
            return this;
        }

        public APIRequestCreateVietnam setSubvertical(EnumSubvertical subvertical) {
            this.setParam("subvertical", (Object)subvertical);
            return this;
        }

        public APIRequestCreateVietnam setSubvertical(String subvertical) {
            this.setParam("subvertical", subvertical);
            return this;
        }

        public APIRequestCreateVietnam setVertical(EnumVertical vertical) {
            this.setParam("vertical", (Object)vertical);
            return this;
        }

        public APIRequestCreateVietnam setVertical(String vertical) {
            this.setParam("vertical", vertical);
            return this;
        }

        public APIRequestCreateVietnam requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateVietnam requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateVietnam requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateVietnam requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateVietnam requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateVietnam requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdAccounts
    extends APIRequest<AdAccount> {
        APINodeList<AdAccount> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "account_status", "ad_account_creation_request", "ad_account_promotable_objects", "age", "agency_client_declaration", "amount_spent", "attribution_spec", "balance", "business", "business_city", "business_country_code", "business_name", "business_state", "business_street", "business_street2", "business_zip", "capabilities", "created_time", "currency", "disable_reason", "end_advertiser", "end_advertiser_name", "extended_credit_invoice_group", "failed_delivery_checks", "fb_entity", "funding_source", "funding_source_details", "has_migrated_permissions", "has_page_authorized_adaccount", "id", "io_number", "is_attribution_spec_system_default", "is_direct_deals_enabled", "is_in_3ds_authorization_enabled_market", "is_in_middle_of_local_entity_migration", "is_notifications_enabled", "is_personal", "is_prepay_account", "is_tax_id_required", "line_numbers", "media_agency", "min_campaign_group_spend_cap", "min_daily_budget", "name", "offsite_pixels_tos_accepted", "owner", "partner", "rf_spec", "show_checkout_experience", "spend_cap", "tax_id", "tax_id_status", "tax_id_type", "timezone_id", "timezone_name", "timezone_offset_hours_utc", "tos_accepted", "user_tasks", "user_tos_accepted"};

        @Override
        public APINodeList<AdAccount> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccount> parseResponse(String response, String header) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdAccount> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccount> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdAccount>>(){

                public APINodeList<AdAccount> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetAdAccounts.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/adaccounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdAccounts requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetAdAccounts requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAccountStatusField() {
            return this.requestAccountStatusField(true);
        }

        public APIRequestGetAdAccounts requestAccountStatusField(boolean value) {
            this.requestField("account_status", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAdAccountCreationRequestField() {
            return this.requestAdAccountCreationRequestField(true);
        }

        public APIRequestGetAdAccounts requestAdAccountCreationRequestField(boolean value) {
            this.requestField("ad_account_creation_request", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAdAccountPromotableObjectsField() {
            return this.requestAdAccountPromotableObjectsField(true);
        }

        public APIRequestGetAdAccounts requestAdAccountPromotableObjectsField(boolean value) {
            this.requestField("ad_account_promotable_objects", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGetAdAccounts requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAgencyClientDeclarationField() {
            return this.requestAgencyClientDeclarationField(true);
        }

        public APIRequestGetAdAccounts requestAgencyClientDeclarationField(boolean value) {
            this.requestField("agency_client_declaration", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAmountSpentField() {
            return this.requestAmountSpentField(true);
        }

        public APIRequestGetAdAccounts requestAmountSpentField(boolean value) {
            this.requestField("amount_spent", value);
            return this;
        }

        public APIRequestGetAdAccounts requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetAdAccounts requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGetAdAccounts requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAdAccounts requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessCityField() {
            return this.requestBusinessCityField(true);
        }

        public APIRequestGetAdAccounts requestBusinessCityField(boolean value) {
            this.requestField("business_city", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessCountryCodeField() {
            return this.requestBusinessCountryCodeField(true);
        }

        public APIRequestGetAdAccounts requestBusinessCountryCodeField(boolean value) {
            this.requestField("business_country_code", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessNameField() {
            return this.requestBusinessNameField(true);
        }

        public APIRequestGetAdAccounts requestBusinessNameField(boolean value) {
            this.requestField("business_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStateField() {
            return this.requestBusinessStateField(true);
        }

        public APIRequestGetAdAccounts requestBusinessStateField(boolean value) {
            this.requestField("business_state", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStreetField() {
            return this.requestBusinessStreetField(true);
        }

        public APIRequestGetAdAccounts requestBusinessStreetField(boolean value) {
            this.requestField("business_street", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessStreet2Field() {
            return this.requestBusinessStreet2Field(true);
        }

        public APIRequestGetAdAccounts requestBusinessStreet2Field(boolean value) {
            this.requestField("business_street2", value);
            return this;
        }

        public APIRequestGetAdAccounts requestBusinessZipField() {
            return this.requestBusinessZipField(true);
        }

        public APIRequestGetAdAccounts requestBusinessZipField(boolean value) {
            this.requestField("business_zip", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCapabilitiesField() {
            return this.requestCapabilitiesField(true);
        }

        public APIRequestGetAdAccounts requestCapabilitiesField(boolean value) {
            this.requestField("capabilities", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetAdAccounts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetAdAccounts requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetAdAccounts requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetAdAccounts requestDisableReasonField() {
            return this.requestDisableReasonField(true);
        }

        public APIRequestGetAdAccounts requestDisableReasonField(boolean value) {
            this.requestField("disable_reason", value);
            return this;
        }

        public APIRequestGetAdAccounts requestEndAdvertiserField() {
            return this.requestEndAdvertiserField(true);
        }

        public APIRequestGetAdAccounts requestEndAdvertiserField(boolean value) {
            this.requestField("end_advertiser", value);
            return this;
        }

        public APIRequestGetAdAccounts requestEndAdvertiserNameField() {
            return this.requestEndAdvertiserNameField(true);
        }

        public APIRequestGetAdAccounts requestEndAdvertiserNameField(boolean value) {
            this.requestField("end_advertiser_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestExtendedCreditInvoiceGroupField() {
            return this.requestExtendedCreditInvoiceGroupField(true);
        }

        public APIRequestGetAdAccounts requestExtendedCreditInvoiceGroupField(boolean value) {
            this.requestField("extended_credit_invoice_group", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGetAdAccounts requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFbEntityField() {
            return this.requestFbEntityField(true);
        }

        public APIRequestGetAdAccounts requestFbEntityField(boolean value) {
            this.requestField("fb_entity", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFundingSourceField() {
            return this.requestFundingSourceField(true);
        }

        public APIRequestGetAdAccounts requestFundingSourceField(boolean value) {
            this.requestField("funding_source", value);
            return this;
        }

        public APIRequestGetAdAccounts requestFundingSourceDetailsField() {
            return this.requestFundingSourceDetailsField(true);
        }

        public APIRequestGetAdAccounts requestFundingSourceDetailsField(boolean value) {
            this.requestField("funding_source_details", value);
            return this;
        }

        public APIRequestGetAdAccounts requestHasMigratedPermissionsField() {
            return this.requestHasMigratedPermissionsField(true);
        }

        public APIRequestGetAdAccounts requestHasMigratedPermissionsField(boolean value) {
            this.requestField("has_migrated_permissions", value);
            return this;
        }

        public APIRequestGetAdAccounts requestHasPageAuthorizedAdaccountField() {
            return this.requestHasPageAuthorizedAdaccountField(true);
        }

        public APIRequestGetAdAccounts requestHasPageAuthorizedAdaccountField(boolean value) {
            this.requestField("has_page_authorized_adaccount", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetAdAccounts requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsAttributionSpecSystemDefaultField() {
            return this.requestIsAttributionSpecSystemDefaultField(true);
        }

        public APIRequestGetAdAccounts requestIsAttributionSpecSystemDefaultField(boolean value) {
            this.requestField("is_attribution_spec_system_default", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsDirectDealsEnabledField() {
            return this.requestIsDirectDealsEnabledField(true);
        }

        public APIRequestGetAdAccounts requestIsDirectDealsEnabledField(boolean value) {
            this.requestField("is_direct_deals_enabled", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsIn3dsAuthorizationEnabledMarketField() {
            return this.requestIsIn3dsAuthorizationEnabledMarketField(true);
        }

        public APIRequestGetAdAccounts requestIsIn3dsAuthorizationEnabledMarketField(boolean value) {
            this.requestField("is_in_3ds_authorization_enabled_market", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsInMiddleOfLocalEntityMigrationField() {
            return this.requestIsInMiddleOfLocalEntityMigrationField(true);
        }

        public APIRequestGetAdAccounts requestIsInMiddleOfLocalEntityMigrationField(boolean value) {
            this.requestField("is_in_middle_of_local_entity_migration", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsNotificationsEnabledField() {
            return this.requestIsNotificationsEnabledField(true);
        }

        public APIRequestGetAdAccounts requestIsNotificationsEnabledField(boolean value) {
            this.requestField("is_notifications_enabled", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsPersonalField() {
            return this.requestIsPersonalField(true);
        }

        public APIRequestGetAdAccounts requestIsPersonalField(boolean value) {
            this.requestField("is_personal", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsPrepayAccountField() {
            return this.requestIsPrepayAccountField(true);
        }

        public APIRequestGetAdAccounts requestIsPrepayAccountField(boolean value) {
            this.requestField("is_prepay_account", value);
            return this;
        }

        public APIRequestGetAdAccounts requestIsTaxIdRequiredField() {
            return this.requestIsTaxIdRequiredField(true);
        }

        public APIRequestGetAdAccounts requestIsTaxIdRequiredField(boolean value) {
            this.requestField("is_tax_id_required", value);
            return this;
        }

        public APIRequestGetAdAccounts requestLineNumbersField() {
            return this.requestLineNumbersField(true);
        }

        public APIRequestGetAdAccounts requestLineNumbersField(boolean value) {
            this.requestField("line_numbers", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMediaAgencyField() {
            return this.requestMediaAgencyField(true);
        }

        public APIRequestGetAdAccounts requestMediaAgencyField(boolean value) {
            this.requestField("media_agency", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMinCampaignGroupSpendCapField() {
            return this.requestMinCampaignGroupSpendCapField(true);
        }

        public APIRequestGetAdAccounts requestMinCampaignGroupSpendCapField(boolean value) {
            this.requestField("min_campaign_group_spend_cap", value);
            return this;
        }

        public APIRequestGetAdAccounts requestMinDailyBudgetField() {
            return this.requestMinDailyBudgetField(true);
        }

        public APIRequestGetAdAccounts requestMinDailyBudgetField(boolean value) {
            this.requestField("min_daily_budget", value);
            return this;
        }

        public APIRequestGetAdAccounts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAdAccounts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOffsitePixelsTosAcceptedField() {
            return this.requestOffsitePixelsTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestOffsitePixelsTosAcceptedField(boolean value) {
            this.requestField("offsite_pixels_tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetAdAccounts requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetAdAccounts requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetAdAccounts requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetAdAccounts requestRfSpecField() {
            return this.requestRfSpecField(true);
        }

        public APIRequestGetAdAccounts requestRfSpecField(boolean value) {
            this.requestField("rf_spec", value);
            return this;
        }

        public APIRequestGetAdAccounts requestShowCheckoutExperienceField() {
            return this.requestShowCheckoutExperienceField(true);
        }

        public APIRequestGetAdAccounts requestShowCheckoutExperienceField(boolean value) {
            this.requestField("show_checkout_experience", value);
            return this;
        }

        public APIRequestGetAdAccounts requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetAdAccounts requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdStatusField() {
            return this.requestTaxIdStatusField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdStatusField(boolean value) {
            this.requestField("tax_id_status", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTaxIdTypeField() {
            return this.requestTaxIdTypeField(true);
        }

        public APIRequestGetAdAccounts requestTaxIdTypeField(boolean value) {
            this.requestField("tax_id_type", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTimezoneOffsetHoursUtcField() {
            return this.requestTimezoneOffsetHoursUtcField(true);
        }

        public APIRequestGetAdAccounts requestTimezoneOffsetHoursUtcField(boolean value) {
            this.requestField("timezone_offset_hours_utc", value);
            return this;
        }

        public APIRequestGetAdAccounts requestTosAcceptedField() {
            return this.requestTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestTosAcceptedField(boolean value) {
            this.requestField("tos_accepted", value);
            return this;
        }

        public APIRequestGetAdAccounts requestUserTasksField() {
            return this.requestUserTasksField(true);
        }

        public APIRequestGetAdAccounts requestUserTasksField(boolean value) {
            this.requestField("user_tasks", value);
            return this;
        }

        public APIRequestGetAdAccounts requestUserTosAcceptedField() {
            return this.requestUserTosAcceptedField(true);
        }

        public APIRequestGetAdAccounts requestUserTosAcceptedField(boolean value) {
            this.requestField("user_tos_accepted", value);
            return this;
        }
    }
}

