/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.BilledAmountDetails;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvoiceCampaign
extends APINode {
    @SerializedName(value="ad_account_id")
    private String mAdAccountId = null;
    @SerializedName(value="billed_amount_details")
    private BilledAmountDetails mBilledAmountDetails = null;
    @SerializedName(value="campaign_id")
    private String mCampaignId = null;
    @SerializedName(value="campaign_name")
    private String mCampaignName = null;
    @SerializedName(value="clicks")
    private Long mClicks = null;
    @SerializedName(value="conversions")
    private Long mConversions = null;
    @SerializedName(value="impressions")
    private Long mImpressions = null;
    @SerializedName(value="tags")
    private List<String> mTags = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static InvoiceCampaign loadJSON(String json, APIContext context, String header) {
        InvoiceCampaign invoiceCampaign = (InvoiceCampaign)InvoiceCampaign.getGson().fromJson(json, InvoiceCampaign.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(invoiceCampaign.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        invoiceCampaign.context = context;
        invoiceCampaign.rawValue = json;
        invoiceCampaign.header = header;
        return invoiceCampaign;
    }

    public static APINodeList<InvoiceCampaign> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<InvoiceCampaign> invoiceCampaigns = new APINodeList<InvoiceCampaign>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        invoiceCampaigns.add(InvoiceCampaign.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return invoiceCampaigns;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            invoiceCampaigns.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        invoiceCampaigns.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            invoiceCampaigns.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            invoiceCampaigns.add(InvoiceCampaign.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                invoiceCampaigns.add(InvoiceCampaign.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            invoiceCampaigns.add(InvoiceCampaign.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return invoiceCampaigns;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        invoiceCampaigns.add(InvoiceCampaign.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return invoiceCampaigns;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        invoiceCampaigns.add(InvoiceCampaign.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return invoiceCampaigns;
                }
                invoiceCampaigns.clear();
                invoiceCampaigns.add(InvoiceCampaign.loadJSON(json, context, header));
                return invoiceCampaigns;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return InvoiceCampaign.getGson().toJson((Object)this);
    }

    public String getFieldAdAccountId() {
        return this.mAdAccountId;
    }

    public InvoiceCampaign setFieldAdAccountId(String value) {
        this.mAdAccountId = value;
        return this;
    }

    public BilledAmountDetails getFieldBilledAmountDetails() {
        return this.mBilledAmountDetails;
    }

    public InvoiceCampaign setFieldBilledAmountDetails(BilledAmountDetails value) {
        this.mBilledAmountDetails = value;
        return this;
    }

    public InvoiceCampaign setFieldBilledAmountDetails(String value) {
        Type type = new TypeToken<BilledAmountDetails>(){}.getType();
        this.mBilledAmountDetails = (BilledAmountDetails)BilledAmountDetails.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldCampaignId() {
        return this.mCampaignId;
    }

    public InvoiceCampaign setFieldCampaignId(String value) {
        this.mCampaignId = value;
        return this;
    }

    public String getFieldCampaignName() {
        return this.mCampaignName;
    }

    public InvoiceCampaign setFieldCampaignName(String value) {
        this.mCampaignName = value;
        return this;
    }

    public Long getFieldClicks() {
        return this.mClicks;
    }

    public InvoiceCampaign setFieldClicks(Long value) {
        this.mClicks = value;
        return this;
    }

    public Long getFieldConversions() {
        return this.mConversions;
    }

    public InvoiceCampaign setFieldConversions(Long value) {
        this.mConversions = value;
        return this;
    }

    public Long getFieldImpressions() {
        return this.mImpressions;
    }

    public InvoiceCampaign setFieldImpressions(Long value) {
        this.mImpressions = value;
        return this;
    }

    public List<String> getFieldTags() {
        return this.mTags;
    }

    public InvoiceCampaign setFieldTags(List<String> value) {
        this.mTags = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public InvoiceCampaign copyFrom(InvoiceCampaign instance) {
        this.mAdAccountId = instance.mAdAccountId;
        this.mBilledAmountDetails = instance.mBilledAmountDetails;
        this.mCampaignId = instance.mCampaignId;
        this.mCampaignName = instance.mCampaignName;
        this.mClicks = instance.mClicks;
        this.mConversions = instance.mConversions;
        this.mImpressions = instance.mImpressions;
        this.mTags = instance.mTags;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<InvoiceCampaign> getParser() {
        return new APIRequest.ResponseParser<InvoiceCampaign>(){

            @Override
            public APINodeList<InvoiceCampaign> parseResponse(String response, APIContext context, APIRequest<InvoiceCampaign> request, String header) throws APIException.MalformedResponseException {
                return InvoiceCampaign.parseResponse(response, context, request, header);
            }
        };
    }
}

