/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudienceInsightsRule
extends APINode {
    @SerializedName(value="archived")
    private Boolean mArchived = null;
    @SerializedName(value="can_be_updated")
    private Boolean mCanBeUpdated = null;
    @SerializedName(value="created_by")
    private User mCreatedBy = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="studies")
    private List<Object> mStudies = null;
    protected static Gson gson = null;

    AudienceInsightsRule() {
    }

    public AudienceInsightsRule(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AudienceInsightsRule(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AudienceInsightsRule fetch() throws APIException {
        AudienceInsightsRule newInstance = AudienceInsightsRule.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AudienceInsightsRule fetchById(Long id, APIContext context) throws APIException {
        return AudienceInsightsRule.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AudienceInsightsRule> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AudienceInsightsRule.fetchByIdAsync(id.toString(), context);
    }

    public static AudienceInsightsRule fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AudienceInsightsRule> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AudienceInsightsRule> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AudienceInsightsRule>(context, "", "/", "GET", AudienceInsightsRule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AudienceInsightsRule>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AudienceInsightsRule>(context, "", "/", "GET", AudienceInsightsRule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AudienceInsightsRule loadJSON(String json, APIContext context, String header) {
        AudienceInsightsRule audienceInsightsRule = (AudienceInsightsRule)AudienceInsightsRule.getGson().fromJson(json, AudienceInsightsRule.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(audienceInsightsRule.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        audienceInsightsRule.context = context;
        audienceInsightsRule.rawValue = json;
        audienceInsightsRule.header = header;
        return audienceInsightsRule;
    }

    public static APINodeList<AudienceInsightsRule> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AudienceInsightsRule> audienceInsightsRules = new APINodeList<AudienceInsightsRule>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        audienceInsightsRules.add(AudienceInsightsRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return audienceInsightsRules;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            audienceInsightsRules.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        audienceInsightsRules.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            audienceInsightsRules.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            audienceInsightsRules.add(AudienceInsightsRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                audienceInsightsRules.add(AudienceInsightsRule.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            audienceInsightsRules.add(AudienceInsightsRule.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return audienceInsightsRules;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        audienceInsightsRules.add(AudienceInsightsRule.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return audienceInsightsRules;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        audienceInsightsRules.add(AudienceInsightsRule.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return audienceInsightsRules;
                }
                audienceInsightsRules.clear();
                audienceInsightsRules.add(AudienceInsightsRule.loadJSON(json, context, header));
                return audienceInsightsRules;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AudienceInsightsRule.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldArchived() {
        return this.mArchived;
    }

    public Boolean getFieldCanBeUpdated() {
        return this.mCanBeUpdated;
    }

    public User getFieldCreatedBy() {
        if (this.mCreatedBy != null) {
            this.mCreatedBy.context = this.getContext();
        }
        return this.mCreatedBy;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public List<Object> getFieldStudies() {
        return this.mStudies;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AudienceInsightsRule copyFrom(AudienceInsightsRule instance) {
        this.mArchived = instance.mArchived;
        this.mCanBeUpdated = instance.mCanBeUpdated;
        this.mCreatedBy = instance.mCreatedBy;
        this.mCreationTime = instance.mCreationTime;
        this.mDescription = instance.mDescription;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mStudies = instance.mStudies;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AudienceInsightsRule> getParser() {
        return new APIRequest.ResponseParser<AudienceInsightsRule>(){

            @Override
            public APINodeList<AudienceInsightsRule> parseResponse(String response, APIContext context, APIRequest<AudienceInsightsRule> request, String header) throws APIException.MalformedResponseException {
                return AudienceInsightsRule.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AudienceInsightsRule> {
        AudienceInsightsRule lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"archived", "can_be_updated", "created_by", "creation_time", "description", "id", "name", "studies"};

        @Override
        public AudienceInsightsRule getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AudienceInsightsRule parseResponse(String response, String header) throws APIException {
            return AudienceInsightsRule.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AudienceInsightsRule execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AudienceInsightsRule execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AudienceInsightsRule> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AudienceInsightsRule> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AudienceInsightsRule>(){

                public AudienceInsightsRule apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestArchivedField() {
            return this.requestArchivedField(true);
        }

        public APIRequestGet requestArchivedField(boolean value) {
            this.requestField("archived", value);
            return this;
        }

        public APIRequestGet requestCanBeUpdatedField() {
            return this.requestCanBeUpdatedField(true);
        }

        public APIRequestGet requestCanBeUpdatedField(boolean value) {
            this.requestField("can_be_updated", value);
            return this;
        }

        public APIRequestGet requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGet requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestStudiesField() {
            return this.requestStudiesField(true);
        }

        public APIRequestGet requestStudiesField(boolean value) {
            this.requestField("studies", value);
            return this;
        }
    }
}

