/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomAudienceSession
extends APINode {
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="num_invalid_entries")
    private String mNumInvalidEntries = null;
    @SerializedName(value="num_matched")
    private String mNumMatched = null;
    @SerializedName(value="num_received")
    private String mNumReceived = null;
    @SerializedName(value="progress")
    private String mProgress = null;
    @SerializedName(value="session_id")
    private String mSessionId = null;
    @SerializedName(value="stage")
    private String mStage = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static CustomAudienceSession loadJSON(String json, APIContext context, String header) {
        CustomAudienceSession customAudienceSession = (CustomAudienceSession)CustomAudienceSession.getGson().fromJson(json, CustomAudienceSession.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(customAudienceSession.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        customAudienceSession.context = context;
        customAudienceSession.rawValue = json;
        customAudienceSession.header = header;
        return customAudienceSession;
    }

    public static APINodeList<CustomAudienceSession> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CustomAudienceSession> customAudienceSessions = new APINodeList<CustomAudienceSession>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        customAudienceSessions.add(CustomAudienceSession.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return customAudienceSessions;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            customAudienceSessions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        customAudienceSessions.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            customAudienceSessions.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            customAudienceSessions.add(CustomAudienceSession.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                customAudienceSessions.add(CustomAudienceSession.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            customAudienceSessions.add(CustomAudienceSession.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return customAudienceSessions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        customAudienceSessions.add(CustomAudienceSession.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return customAudienceSessions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        customAudienceSessions.add(CustomAudienceSession.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return customAudienceSessions;
                }
                customAudienceSessions.clear();
                customAudienceSessions.add(CustomAudienceSession.loadJSON(json, context, header));
                return customAudienceSessions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CustomAudienceSession.getGson().toJson((Object)this);
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public CustomAudienceSession setFieldEndTime(String value) {
        this.mEndTime = value;
        return this;
    }

    public String getFieldNumInvalidEntries() {
        return this.mNumInvalidEntries;
    }

    public CustomAudienceSession setFieldNumInvalidEntries(String value) {
        this.mNumInvalidEntries = value;
        return this;
    }

    public String getFieldNumMatched() {
        return this.mNumMatched;
    }

    public CustomAudienceSession setFieldNumMatched(String value) {
        this.mNumMatched = value;
        return this;
    }

    public String getFieldNumReceived() {
        return this.mNumReceived;
    }

    public CustomAudienceSession setFieldNumReceived(String value) {
        this.mNumReceived = value;
        return this;
    }

    public String getFieldProgress() {
        return this.mProgress;
    }

    public CustomAudienceSession setFieldProgress(String value) {
        this.mProgress = value;
        return this;
    }

    public String getFieldSessionId() {
        return this.mSessionId;
    }

    public CustomAudienceSession setFieldSessionId(String value) {
        this.mSessionId = value;
        return this;
    }

    public String getFieldStage() {
        return this.mStage;
    }

    public CustomAudienceSession setFieldStage(String value) {
        this.mStage = value;
        return this;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public CustomAudienceSession setFieldStartTime(String value) {
        this.mStartTime = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CustomAudienceSession copyFrom(CustomAudienceSession instance) {
        this.mEndTime = instance.mEndTime;
        this.mNumInvalidEntries = instance.mNumInvalidEntries;
        this.mNumMatched = instance.mNumMatched;
        this.mNumReceived = instance.mNumReceived;
        this.mProgress = instance.mProgress;
        this.mSessionId = instance.mSessionId;
        this.mStage = instance.mStage;
        this.mStartTime = instance.mStartTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CustomAudienceSession> getParser() {
        return new APIRequest.ResponseParser<CustomAudienceSession>(){

            @Override
            public APINodeList<CustomAudienceSession> parseResponse(String response, APIContext context, APIRequest<CustomAudienceSession> request, String header) throws APIException.MalformedResponseException {
                return CustomAudienceSession.parseResponse(response, context, request, header);
            }
        };
    }
}

