/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReachFrequencyActivity
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="campaign_active")
    private Boolean mCampaignActive = null;
    @SerializedName(value="campaign_started")
    private Boolean mCampaignStarted = null;
    @SerializedName(value="creative_uploaded")
    private Boolean mCreativeUploaded = null;
    @SerializedName(value="delivered_budget")
    private Long mDeliveredBudget = null;
    @SerializedName(value="delivered_daily_grp")
    private List<Double> mDeliveredDailyGrp = null;
    @SerializedName(value="delivered_daily_impression")
    private List<Double> mDeliveredDailyImpression = null;
    @SerializedName(value="delivered_impression")
    private Long mDeliveredImpression = null;
    @SerializedName(value="delivered_reach")
    private Long mDeliveredReach = null;
    @SerializedName(value="delivered_total_impression")
    private Long mDeliveredTotalImpression = null;
    @SerializedName(value="io_approved")
    private Boolean mIoApproved = null;
    @SerializedName(value="sf_link")
    private String mSfLink = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ReachFrequencyActivity loadJSON(String json, APIContext context, String header) {
        ReachFrequencyActivity reachFrequencyActivity = (ReachFrequencyActivity)ReachFrequencyActivity.getGson().fromJson(json, ReachFrequencyActivity.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(reachFrequencyActivity.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        reachFrequencyActivity.context = context;
        reachFrequencyActivity.rawValue = json;
        reachFrequencyActivity.header = header;
        return reachFrequencyActivity;
    }

    public static APINodeList<ReachFrequencyActivity> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ReachFrequencyActivity> reachFrequencyActivitys = new APINodeList<ReachFrequencyActivity>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        reachFrequencyActivitys.add(ReachFrequencyActivity.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return reachFrequencyActivitys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            reachFrequencyActivitys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        reachFrequencyActivitys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            reachFrequencyActivitys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            reachFrequencyActivitys.add(ReachFrequencyActivity.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                reachFrequencyActivitys.add(ReachFrequencyActivity.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            reachFrequencyActivitys.add(ReachFrequencyActivity.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return reachFrequencyActivitys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        reachFrequencyActivitys.add(ReachFrequencyActivity.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return reachFrequencyActivitys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        reachFrequencyActivitys.add(ReachFrequencyActivity.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return reachFrequencyActivitys;
                }
                reachFrequencyActivitys.clear();
                reachFrequencyActivitys.add(ReachFrequencyActivity.loadJSON(json, context, header));
                return reachFrequencyActivitys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ReachFrequencyActivity.getGson().toJson((Object)this);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public ReachFrequencyActivity setFieldAccountId(String value) {
        this.mAccountId = value;
        return this;
    }

    public Boolean getFieldCampaignActive() {
        return this.mCampaignActive;
    }

    public ReachFrequencyActivity setFieldCampaignActive(Boolean value) {
        this.mCampaignActive = value;
        return this;
    }

    public Boolean getFieldCampaignStarted() {
        return this.mCampaignStarted;
    }

    public ReachFrequencyActivity setFieldCampaignStarted(Boolean value) {
        this.mCampaignStarted = value;
        return this;
    }

    public Boolean getFieldCreativeUploaded() {
        return this.mCreativeUploaded;
    }

    public ReachFrequencyActivity setFieldCreativeUploaded(Boolean value) {
        this.mCreativeUploaded = value;
        return this;
    }

    public Long getFieldDeliveredBudget() {
        return this.mDeliveredBudget;
    }

    public ReachFrequencyActivity setFieldDeliveredBudget(Long value) {
        this.mDeliveredBudget = value;
        return this;
    }

    public List<Double> getFieldDeliveredDailyGrp() {
        return this.mDeliveredDailyGrp;
    }

    public ReachFrequencyActivity setFieldDeliveredDailyGrp(List<Double> value) {
        this.mDeliveredDailyGrp = value;
        return this;
    }

    public List<Double> getFieldDeliveredDailyImpression() {
        return this.mDeliveredDailyImpression;
    }

    public ReachFrequencyActivity setFieldDeliveredDailyImpression(List<Double> value) {
        this.mDeliveredDailyImpression = value;
        return this;
    }

    public Long getFieldDeliveredImpression() {
        return this.mDeliveredImpression;
    }

    public ReachFrequencyActivity setFieldDeliveredImpression(Long value) {
        this.mDeliveredImpression = value;
        return this;
    }

    public Long getFieldDeliveredReach() {
        return this.mDeliveredReach;
    }

    public ReachFrequencyActivity setFieldDeliveredReach(Long value) {
        this.mDeliveredReach = value;
        return this;
    }

    public Long getFieldDeliveredTotalImpression() {
        return this.mDeliveredTotalImpression;
    }

    public ReachFrequencyActivity setFieldDeliveredTotalImpression(Long value) {
        this.mDeliveredTotalImpression = value;
        return this;
    }

    public Boolean getFieldIoApproved() {
        return this.mIoApproved;
    }

    public ReachFrequencyActivity setFieldIoApproved(Boolean value) {
        this.mIoApproved = value;
        return this;
    }

    public String getFieldSfLink() {
        return this.mSfLink;
    }

    public ReachFrequencyActivity setFieldSfLink(String value) {
        this.mSfLink = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ReachFrequencyActivity copyFrom(ReachFrequencyActivity instance) {
        this.mAccountId = instance.mAccountId;
        this.mCampaignActive = instance.mCampaignActive;
        this.mCampaignStarted = instance.mCampaignStarted;
        this.mCreativeUploaded = instance.mCreativeUploaded;
        this.mDeliveredBudget = instance.mDeliveredBudget;
        this.mDeliveredDailyGrp = instance.mDeliveredDailyGrp;
        this.mDeliveredDailyImpression = instance.mDeliveredDailyImpression;
        this.mDeliveredImpression = instance.mDeliveredImpression;
        this.mDeliveredReach = instance.mDeliveredReach;
        this.mDeliveredTotalImpression = instance.mDeliveredTotalImpression;
        this.mIoApproved = instance.mIoApproved;
        this.mSfLink = instance.mSfLink;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ReachFrequencyActivity> getParser() {
        return new APIRequest.ResponseParser<ReachFrequencyActivity>(){

            @Override
            public APINodeList<ReachFrequencyActivity> parseResponse(String response, APIContext context, APIRequest<ReachFrequencyActivity> request, String header) throws APIException.MalformedResponseException {
                return ReachFrequencyActivity.parseResponse(response, context, request, header);
            }
        };
    }
}

