/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartnerCouponOffer
extends APINode {
    @SerializedName(value="claim_by")
    private String mClaimBy = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="expiration_days")
    private Long mExpirationDays = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="minimum_spend")
    private Long mMinimumSpend = null;
    @SerializedName(value="offer_amount")
    private Long mOfferAmount = null;
    protected static Gson gson = null;

    PartnerCouponOffer() {
    }

    public PartnerCouponOffer(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PartnerCouponOffer(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PartnerCouponOffer fetch() throws APIException {
        PartnerCouponOffer newInstance = PartnerCouponOffer.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PartnerCouponOffer fetchById(Long id, APIContext context) throws APIException {
        return PartnerCouponOffer.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PartnerCouponOffer> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PartnerCouponOffer.fetchByIdAsync(id.toString(), context);
    }

    public static PartnerCouponOffer fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PartnerCouponOffer> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PartnerCouponOffer> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PartnerCouponOffer>(context, "", "/", "GET", PartnerCouponOffer.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PartnerCouponOffer>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PartnerCouponOffer>(context, "", "/", "GET", PartnerCouponOffer.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PartnerCouponOffer loadJSON(String json, APIContext context, String header) {
        PartnerCouponOffer partnerCouponOffer = (PartnerCouponOffer)PartnerCouponOffer.getGson().fromJson(json, PartnerCouponOffer.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(partnerCouponOffer.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        partnerCouponOffer.context = context;
        partnerCouponOffer.rawValue = json;
        partnerCouponOffer.header = header;
        return partnerCouponOffer;
    }

    public static APINodeList<PartnerCouponOffer> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PartnerCouponOffer> partnerCouponOffers = new APINodeList<PartnerCouponOffer>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        partnerCouponOffers.add(PartnerCouponOffer.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return partnerCouponOffers;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            partnerCouponOffers.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        partnerCouponOffers.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            partnerCouponOffers.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            partnerCouponOffers.add(PartnerCouponOffer.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                partnerCouponOffers.add(PartnerCouponOffer.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            partnerCouponOffers.add(PartnerCouponOffer.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return partnerCouponOffers;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        partnerCouponOffers.add(PartnerCouponOffer.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return partnerCouponOffers;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        partnerCouponOffers.add(PartnerCouponOffer.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return partnerCouponOffers;
                }
                partnerCouponOffers.clear();
                partnerCouponOffers.add(PartnerCouponOffer.loadJSON(json, context, header));
                return partnerCouponOffers;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PartnerCouponOffer.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldClaimBy() {
        return this.mClaimBy;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public Long getFieldExpirationDays() {
        return this.mExpirationDays;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Long getFieldMinimumSpend() {
        return this.mMinimumSpend;
    }

    public Long getFieldOfferAmount() {
        return this.mOfferAmount;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PartnerCouponOffer copyFrom(PartnerCouponOffer instance) {
        this.mClaimBy = instance.mClaimBy;
        this.mCurrency = instance.mCurrency;
        this.mExpirationDays = instance.mExpirationDays;
        this.mId = instance.mId;
        this.mMinimumSpend = instance.mMinimumSpend;
        this.mOfferAmount = instance.mOfferAmount;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PartnerCouponOffer> getParser() {
        return new APIRequest.ResponseParser<PartnerCouponOffer>(){

            @Override
            public APINodeList<PartnerCouponOffer> parseResponse(String response, APIContext context, APIRequest<PartnerCouponOffer> request, String header) throws APIException.MalformedResponseException {
                return PartnerCouponOffer.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PartnerCouponOffer> {
        PartnerCouponOffer lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"claim_by", "currency", "expiration_days", "id", "minimum_spend", "offer_amount"};

        @Override
        public PartnerCouponOffer getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PartnerCouponOffer parseResponse(String response, String header) throws APIException {
            return PartnerCouponOffer.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PartnerCouponOffer execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PartnerCouponOffer execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PartnerCouponOffer> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PartnerCouponOffer> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PartnerCouponOffer>(){

                public PartnerCouponOffer apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestClaimByField() {
            return this.requestClaimByField(true);
        }

        public APIRequestGet requestClaimByField(boolean value) {
            this.requestField("claim_by", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestExpirationDaysField() {
            return this.requestExpirationDaysField(true);
        }

        public APIRequestGet requestExpirationDaysField(boolean value) {
            this.requestField("expiration_days", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestMinimumSpendField() {
            return this.requestMinimumSpendField(true);
        }

        public APIRequestGet requestMinimumSpendField(boolean value) {
            this.requestField("minimum_spend", value);
            return this;
        }

        public APIRequestGet requestOfferAmountField() {
            return this.requestOfferAmountField(true);
        }

        public APIRequestGet requestOfferAmountField(boolean value) {
            this.requestField("offer_amount", value);
            return this;
        }
    }
}

