/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoThumbnail
extends APINode {
    @SerializedName(value="height")
    private Long mHeight = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_preferred")
    private Boolean mIsPreferred = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="scale")
    private Double mScale = null;
    @SerializedName(value="uri")
    private String mUri = null;
    @SerializedName(value="width")
    private Long mWidth = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static VideoThumbnail loadJSON(String json, APIContext context, String header) {
        VideoThumbnail videoThumbnail = (VideoThumbnail)VideoThumbnail.getGson().fromJson(json, VideoThumbnail.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(videoThumbnail.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        videoThumbnail.context = context;
        videoThumbnail.rawValue = json;
        videoThumbnail.header = header;
        return videoThumbnail;
    }

    public static APINodeList<VideoThumbnail> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<VideoThumbnail> videoThumbnails = new APINodeList<VideoThumbnail>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        videoThumbnails.add(VideoThumbnail.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return videoThumbnails;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            videoThumbnails.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        videoThumbnails.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            videoThumbnails.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            videoThumbnails.add(VideoThumbnail.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                videoThumbnails.add(VideoThumbnail.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            videoThumbnails.add(VideoThumbnail.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return videoThumbnails;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        videoThumbnails.add(VideoThumbnail.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return videoThumbnails;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        videoThumbnails.add(VideoThumbnail.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return videoThumbnails;
                }
                videoThumbnails.clear();
                videoThumbnails.add(VideoThumbnail.loadJSON(json, context, header));
                return videoThumbnails;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return VideoThumbnail.getGson().toJson((Object)this);
    }

    public Long getFieldHeight() {
        return this.mHeight;
    }

    public VideoThumbnail setFieldHeight(Long value) {
        this.mHeight = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public VideoThumbnail setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public Boolean getFieldIsPreferred() {
        return this.mIsPreferred;
    }

    public VideoThumbnail setFieldIsPreferred(Boolean value) {
        this.mIsPreferred = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public VideoThumbnail setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public Double getFieldScale() {
        return this.mScale;
    }

    public VideoThumbnail setFieldScale(Double value) {
        this.mScale = value;
        return this;
    }

    public String getFieldUri() {
        return this.mUri;
    }

    public VideoThumbnail setFieldUri(String value) {
        this.mUri = value;
        return this;
    }

    public Long getFieldWidth() {
        return this.mWidth;
    }

    public VideoThumbnail setFieldWidth(Long value) {
        this.mWidth = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public VideoThumbnail copyFrom(VideoThumbnail instance) {
        this.mHeight = instance.mHeight;
        this.mId = instance.mId;
        this.mIsPreferred = instance.mIsPreferred;
        this.mName = instance.mName;
        this.mScale = instance.mScale;
        this.mUri = instance.mUri;
        this.mWidth = instance.mWidth;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<VideoThumbnail> getParser() {
        return new APIRequest.ResponseParser<VideoThumbnail>(){

            @Override
            public APINodeList<VideoThumbnail> parseResponse(String response, APIContext context, APIRequest<VideoThumbnail> request, String header) throws APIException.MalformedResponseException {
                return VideoThumbnail.parseResponse(response, context, request, header);
            }
        };
    }
}

