/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Photo;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageAboutStory
extends APINode {
    @SerializedName(value="composed_text")
    private List<Object> mComposedText = null;
    @SerializedName(value="cover_photo")
    private Photo mCoverPhoto = null;
    @SerializedName(value="entity_map")
    private List<Object> mEntityMap = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_published")
    private Boolean mIsPublished = null;
    @SerializedName(value="page_id")
    private String mPageId = null;
    @SerializedName(value="title")
    private String mTitle = null;
    protected static Gson gson = null;

    PageAboutStory() {
    }

    public PageAboutStory(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PageAboutStory(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PageAboutStory fetch() throws APIException {
        PageAboutStory newInstance = PageAboutStory.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PageAboutStory fetchById(Long id, APIContext context) throws APIException {
        return PageAboutStory.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PageAboutStory> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PageAboutStory.fetchByIdAsync(id.toString(), context);
    }

    public static PageAboutStory fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PageAboutStory> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PageAboutStory> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PageAboutStory>(context, "", "/", "GET", PageAboutStory.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PageAboutStory>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PageAboutStory>(context, "", "/", "GET", PageAboutStory.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PageAboutStory loadJSON(String json, APIContext context, String header) {
        PageAboutStory pageAboutStory = (PageAboutStory)PageAboutStory.getGson().fromJson(json, PageAboutStory.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pageAboutStory.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pageAboutStory.context = context;
        pageAboutStory.rawValue = json;
        pageAboutStory.header = header;
        return pageAboutStory;
    }

    public static APINodeList<PageAboutStory> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PageAboutStory> pageAboutStorys = new APINodeList<PageAboutStory>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pageAboutStorys.add(PageAboutStory.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return pageAboutStorys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pageAboutStorys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pageAboutStorys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pageAboutStorys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pageAboutStorys.add(PageAboutStory.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pageAboutStorys.add(PageAboutStory.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pageAboutStorys.add(PageAboutStory.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return pageAboutStorys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pageAboutStorys.add(PageAboutStory.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return pageAboutStorys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pageAboutStorys.add(PageAboutStory.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pageAboutStorys;
                }
                pageAboutStorys.clear();
                pageAboutStorys.add(PageAboutStory.loadJSON(json, context, header));
                return pageAboutStorys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PageAboutStory.getGson().toJson((Object)this);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public List<Object> getFieldComposedText() {
        return this.mComposedText;
    }

    public Photo getFieldCoverPhoto() {
        if (this.mCoverPhoto != null) {
            this.mCoverPhoto.context = this.getContext();
        }
        return this.mCoverPhoto;
    }

    public List<Object> getFieldEntityMap() {
        return this.mEntityMap;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsPublished() {
        return this.mIsPublished;
    }

    public String getFieldPageId() {
        return this.mPageId;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PageAboutStory copyFrom(PageAboutStory instance) {
        this.mComposedText = instance.mComposedText;
        this.mCoverPhoto = instance.mCoverPhoto;
        this.mEntityMap = instance.mEntityMap;
        this.mId = instance.mId;
        this.mIsPublished = instance.mIsPublished;
        this.mPageId = instance.mPageId;
        this.mTitle = instance.mTitle;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PageAboutStory> getParser() {
        return new APIRequest.ResponseParser<PageAboutStory>(){

            @Override
            public APINodeList<PageAboutStory> parseResponse(String response, APIContext context, APIRequest<PageAboutStory> request, String header) throws APIException.MalformedResponseException {
                return PageAboutStory.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<PageAboutStory> {
        PageAboutStory lastResponse = null;
        public static final String[] PARAMS = new String[]{"composed_text", "cover_photo", "entity_map", "is_published", "title"};
        public static final String[] FIELDS = new String[0];

        @Override
        public PageAboutStory getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PageAboutStory parseResponse(String response, String header) throws APIException {
            return PageAboutStory.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PageAboutStory execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PageAboutStory execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PageAboutStory> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PageAboutStory> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PageAboutStory>(){

                public PageAboutStory apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setComposedText(List<Map<String, String>> composedText) {
            this.setParam("composed_text", composedText);
            return this;
        }

        public APIRequestUpdate setComposedText(String composedText) {
            this.setParam("composed_text", composedText);
            return this;
        }

        public APIRequestUpdate setCoverPhoto(Map<String, String> coverPhoto) {
            this.setParam("cover_photo", coverPhoto);
            return this;
        }

        public APIRequestUpdate setCoverPhoto(String coverPhoto) {
            this.setParam("cover_photo", coverPhoto);
            return this;
        }

        public APIRequestUpdate setEntityMap(List<Map<String, String>> entityMap) {
            this.setParam("entity_map", entityMap);
            return this;
        }

        public APIRequestUpdate setEntityMap(String entityMap) {
            this.setParam("entity_map", entityMap);
            return this;
        }

        public APIRequestUpdate setIsPublished(Boolean isPublished) {
            this.setParam("is_published", isPublished);
            return this;
        }

        public APIRequestUpdate setIsPublished(String isPublished) {
            this.setParam("is_published", isPublished);
            return this;
        }

        public APIRequestUpdate setTitle(String title) {
            this.setParam("title", title);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PageAboutStory> {
        PageAboutStory lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"composed_text", "cover_photo", "entity_map", "id", "is_published", "page_id", "title"};

        @Override
        public PageAboutStory getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PageAboutStory parseResponse(String response, String header) throws APIException {
            return PageAboutStory.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PageAboutStory execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PageAboutStory execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PageAboutStory> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PageAboutStory> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PageAboutStory>(){

                public PageAboutStory apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestComposedTextField() {
            return this.requestComposedTextField(true);
        }

        public APIRequestGet requestComposedTextField(boolean value) {
            this.requestField("composed_text", value);
            return this;
        }

        public APIRequestGet requestCoverPhotoField() {
            return this.requestCoverPhotoField(true);
        }

        public APIRequestGet requestCoverPhotoField(boolean value) {
            this.requestField("cover_photo", value);
            return this;
        }

        public APIRequestGet requestEntityMapField() {
            return this.requestEntityMapField(true);
        }

        public APIRequestGet requestEntityMapField(boolean value) {
            this.requestField("entity_map", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGet requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGet requestPageIdField() {
            return this.requestPageIdField(true);
        }

        public APIRequestGet requestPageIdField(boolean value) {
            this.requestField("page_id", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

