/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncRequest
extends APINode {
    @SerializedName(value="id")
    private Long mId = null;
    @SerializedName(value="result")
    private String mResult = null;
    @SerializedName(value="status")
    private Long mStatus = null;
    @SerializedName(value="type")
    private Long mType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AsyncRequest loadJSON(String json, APIContext context, String header) {
        AsyncRequest asyncRequest = (AsyncRequest)AsyncRequest.getGson().fromJson(json, AsyncRequest.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(asyncRequest.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        asyncRequest.context = context;
        asyncRequest.rawValue = json;
        asyncRequest.header = header;
        return asyncRequest;
    }

    public static APINodeList<AsyncRequest> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AsyncRequest> asyncRequests = new APINodeList<AsyncRequest>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        asyncRequests.add(AsyncRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return asyncRequests;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            asyncRequests.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        asyncRequests.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            asyncRequests.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            asyncRequests.add(AsyncRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                asyncRequests.add(AsyncRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            asyncRequests.add(AsyncRequest.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return asyncRequests;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        asyncRequests.add(AsyncRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return asyncRequests;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        asyncRequests.add(AsyncRequest.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return asyncRequests;
                }
                asyncRequests.clear();
                asyncRequests.add(AsyncRequest.loadJSON(json, context, header));
                return asyncRequests;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AsyncRequest.getGson().toJson((Object)this);
    }

    public Long getFieldId() {
        return this.mId;
    }

    public AsyncRequest setFieldId(Long value) {
        this.mId = value;
        return this;
    }

    public String getFieldResult() {
        return this.mResult;
    }

    public AsyncRequest setFieldResult(String value) {
        this.mResult = value;
        return this;
    }

    public Long getFieldStatus() {
        return this.mStatus;
    }

    public AsyncRequest setFieldStatus(Long value) {
        this.mStatus = value;
        return this;
    }

    public Long getFieldType() {
        return this.mType;
    }

    public AsyncRequest setFieldType(Long value) {
        this.mType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AsyncRequest copyFrom(AsyncRequest instance) {
        this.mId = instance.mId;
        this.mResult = instance.mResult;
        this.mStatus = instance.mStatus;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AsyncRequest> getParser() {
        return new APIRequest.ResponseParser<AsyncRequest>(){

            @Override
            public APINodeList<AsyncRequest> parseResponse(String response, APIContext context, APIRequest<AsyncRequest> request, String header) throws APIException.MalformedResponseException {
                return AsyncRequest.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_ASYNC_ADGROUP_CREATION("ASYNC_ADGROUP_CREATION"),
        VALUE_BATCH_API("BATCH_API"),
        VALUE_DRAFTS("DRAFTS"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStatus {
        VALUE_ERROR("ERROR"),
        VALUE_EXECUTING("EXECUTING"),
        VALUE_FINISHED("FINISHED"),
        VALUE_INITIALIZED("INITIALIZED"),
        NULL(null);

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

