/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestHistory
extends APINode {
    @SerializedName(value="api_version")
    private String mApiVersion = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="error_code")
    private Long mErrorCode = null;
    @SerializedName(value="graph_path")
    private String mGraphPath = null;
    @SerializedName(value="http_method")
    private EnumHttpMethod mHttpMethod = null;
    @SerializedName(value="post_params")
    private Map<String, String> mPostParams = null;
    @SerializedName(value="query_params")
    private Map<String, String> mQueryParams = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static RequestHistory loadJSON(String json, APIContext context, String header) {
        RequestHistory requestHistory = (RequestHistory)RequestHistory.getGson().fromJson(json, RequestHistory.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(requestHistory.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        requestHistory.context = context;
        requestHistory.rawValue = json;
        requestHistory.header = header;
        return requestHistory;
    }

    public static APINodeList<RequestHistory> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<RequestHistory> requestHistorys = new APINodeList<RequestHistory>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        requestHistorys.add(RequestHistory.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return requestHistorys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            requestHistorys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        requestHistorys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            requestHistorys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            requestHistorys.add(RequestHistory.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                requestHistorys.add(RequestHistory.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            requestHistorys.add(RequestHistory.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return requestHistorys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        requestHistorys.add(RequestHistory.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return requestHistorys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        requestHistorys.add(RequestHistory.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return requestHistorys;
                }
                requestHistorys.clear();
                requestHistorys.add(RequestHistory.loadJSON(json, context, header));
                return requestHistorys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return RequestHistory.getGson().toJson((Object)this);
    }

    public String getFieldApiVersion() {
        return this.mApiVersion;
    }

    public RequestHistory setFieldApiVersion(String value) {
        this.mApiVersion = value;
        return this;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public RequestHistory setFieldCreatedTime(String value) {
        this.mCreatedTime = value;
        return this;
    }

    public Long getFieldErrorCode() {
        return this.mErrorCode;
    }

    public RequestHistory setFieldErrorCode(Long value) {
        this.mErrorCode = value;
        return this;
    }

    public String getFieldGraphPath() {
        return this.mGraphPath;
    }

    public RequestHistory setFieldGraphPath(String value) {
        this.mGraphPath = value;
        return this;
    }

    public EnumHttpMethod getFieldHttpMethod() {
        return this.mHttpMethod;
    }

    public RequestHistory setFieldHttpMethod(EnumHttpMethod value) {
        this.mHttpMethod = value;
        return this;
    }

    public Map<String, String> getFieldPostParams() {
        return this.mPostParams;
    }

    public RequestHistory setFieldPostParams(Map<String, String> value) {
        this.mPostParams = value;
        return this;
    }

    public Map<String, String> getFieldQueryParams() {
        return this.mQueryParams;
    }

    public RequestHistory setFieldQueryParams(Map<String, String> value) {
        this.mQueryParams = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public RequestHistory copyFrom(RequestHistory instance) {
        this.mApiVersion = instance.mApiVersion;
        this.mCreatedTime = instance.mCreatedTime;
        this.mErrorCode = instance.mErrorCode;
        this.mGraphPath = instance.mGraphPath;
        this.mHttpMethod = instance.mHttpMethod;
        this.mPostParams = instance.mPostParams;
        this.mQueryParams = instance.mQueryParams;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<RequestHistory> getParser() {
        return new APIRequest.ResponseParser<RequestHistory>(){

            @Override
            public APINodeList<RequestHistory> parseResponse(String response, APIContext context, APIRequest<RequestHistory> request, String header) throws APIException.MalformedResponseException {
                return RequestHistory.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumHttpMethod {
        VALUE_DELETE("DELETE"),
        VALUE_GET("GET"),
        VALUE_POST("POST"),
        NULL(null);

        private String value;

        private EnumHttpMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

