/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Album;
import com.facebook.ads.sdk.Comment;
import com.facebook.ads.sdk.EntityAtTextRange;
import com.facebook.ads.sdk.Event;
import com.facebook.ads.sdk.InsightsResult;
import com.facebook.ads.sdk.Place;
import com.facebook.ads.sdk.PlatformImageSource;
import com.facebook.ads.sdk.Post;
import com.facebook.ads.sdk.Profile;
import com.facebook.ads.sdk.TaggableSubject;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Photo
extends APINode {
    @SerializedName(value="album")
    private Album mAlbum = null;
    @SerializedName(value="alt_text")
    private String mAltText = null;
    @SerializedName(value="alt_text_custom")
    private String mAltTextCustom = null;
    @SerializedName(value="backdated_time")
    private String mBackdatedTime = null;
    @SerializedName(value="backdated_time_granularity")
    private String mBackdatedTimeGranularity = null;
    @SerializedName(value="can_backdate")
    private Boolean mCanBackdate = null;
    @SerializedName(value="can_delete")
    private Boolean mCanDelete = null;
    @SerializedName(value="can_tag")
    private Boolean mCanTag = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="event")
    private Event mEvent = null;
    @SerializedName(value="from")
    private Object mFrom = null;
    @SerializedName(value="height")
    private Long mHeight = null;
    @SerializedName(value="icon")
    private String mIcon = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="images")
    private List<PlatformImageSource> mImages = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="name_tags")
    private List<EntityAtTextRange> mNameTags = null;
    @SerializedName(value="page_story_id")
    private String mPageStoryId = null;
    @SerializedName(value="picture")
    private String mPicture = null;
    @SerializedName(value="place")
    private Place mPlace = null;
    @SerializedName(value="position")
    private Long mPosition = null;
    @SerializedName(value="source")
    private String mSource = null;
    @SerializedName(value="target")
    private Profile mTarget = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="webp_images")
    private List<PlatformImageSource> mWebpImages = null;
    @SerializedName(value="width")
    private Long mWidth = null;
    protected static Gson gson = null;

    Photo() {
    }

    public Photo(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Photo(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Photo fetch() throws APIException {
        Photo newInstance = Photo.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Photo fetchById(Long id, APIContext context) throws APIException {
        return Photo.fetchById(id.toString(), context);
    }

    public static ListenableFuture<Photo> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return Photo.fetchByIdAsync(id.toString(), context);
    }

    public static Photo fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<Photo> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<Photo> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Photo>(context, "", "/", "GET", Photo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<Photo>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<Photo>(context, "", "/", "GET", Photo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Photo loadJSON(String json, APIContext context, String header) {
        Photo photo = (Photo)Photo.getGson().fromJson(json, Photo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(photo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        photo.context = context;
        photo.rawValue = json;
        photo.header = header;
        return photo;
    }

    public static APINodeList<Photo> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Photo> photos = new APINodeList<Photo>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        photos.add(Photo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return photos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            photos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        photos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            photos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            photos.add(Photo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                photos.add(Photo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            photos.add(Photo.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return photos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        photos.add(Photo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return photos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        photos.add(Photo.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return photos;
                }
                photos.clear();
                photos.add(Photo.loadJSON(json, context, header));
                return photos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Photo.getGson().toJson((Object)this);
    }

    public APIRequestGetComments getComments() {
        return new APIRequestGetComments(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateComment createComment() {
        return new APIRequestCreateComment(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetInsights getInsights() {
        return new APIRequestGetInsights(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetLikes getLikes() {
        return new APIRequestGetLikes(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateLike createLike() {
        return new APIRequestCreateLike(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetReactions getReactions() {
        return new APIRequestGetReactions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetSharedPosts getSharedPosts() {
        return new APIRequestGetSharedPosts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTags getTags() {
        return new APIRequestGetTags(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Album getFieldAlbum() {
        if (this.mAlbum != null) {
            this.mAlbum.context = this.getContext();
        }
        return this.mAlbum;
    }

    public String getFieldAltText() {
        return this.mAltText;
    }

    public String getFieldAltTextCustom() {
        return this.mAltTextCustom;
    }

    public String getFieldBackdatedTime() {
        return this.mBackdatedTime;
    }

    public String getFieldBackdatedTimeGranularity() {
        return this.mBackdatedTimeGranularity;
    }

    public Boolean getFieldCanBackdate() {
        return this.mCanBackdate;
    }

    public Boolean getFieldCanDelete() {
        return this.mCanDelete;
    }

    public Boolean getFieldCanTag() {
        return this.mCanTag;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public Event getFieldEvent() {
        if (this.mEvent != null) {
            this.mEvent.context = this.getContext();
        }
        return this.mEvent;
    }

    public Object getFieldFrom() {
        return this.mFrom;
    }

    public Long getFieldHeight() {
        return this.mHeight;
    }

    public String getFieldIcon() {
        return this.mIcon;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<PlatformImageSource> getFieldImages() {
        return this.mImages;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public String getFieldName() {
        return this.mName;
    }

    public List<EntityAtTextRange> getFieldNameTags() {
        return this.mNameTags;
    }

    public String getFieldPageStoryId() {
        return this.mPageStoryId;
    }

    public String getFieldPicture() {
        return this.mPicture;
    }

    public Place getFieldPlace() {
        if (this.mPlace != null) {
            this.mPlace.context = this.getContext();
        }
        return this.mPlace;
    }

    public Long getFieldPosition() {
        return this.mPosition;
    }

    public String getFieldSource() {
        return this.mSource;
    }

    public Profile getFieldTarget() {
        if (this.mTarget != null) {
            this.mTarget.context = this.getContext();
        }
        return this.mTarget;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public List<PlatformImageSource> getFieldWebpImages() {
        return this.mWebpImages;
    }

    public Long getFieldWidth() {
        return this.mWidth;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Photo copyFrom(Photo instance) {
        this.mAlbum = instance.mAlbum;
        this.mAltText = instance.mAltText;
        this.mAltTextCustom = instance.mAltTextCustom;
        this.mBackdatedTime = instance.mBackdatedTime;
        this.mBackdatedTimeGranularity = instance.mBackdatedTimeGranularity;
        this.mCanBackdate = instance.mCanBackdate;
        this.mCanDelete = instance.mCanDelete;
        this.mCanTag = instance.mCanTag;
        this.mCreatedTime = instance.mCreatedTime;
        this.mEvent = instance.mEvent;
        this.mFrom = instance.mFrom;
        this.mHeight = instance.mHeight;
        this.mIcon = instance.mIcon;
        this.mId = instance.mId;
        this.mImages = instance.mImages;
        this.mLink = instance.mLink;
        this.mName = instance.mName;
        this.mNameTags = instance.mNameTags;
        this.mPageStoryId = instance.mPageStoryId;
        this.mPicture = instance.mPicture;
        this.mPlace = instance.mPlace;
        this.mPosition = instance.mPosition;
        this.mSource = instance.mSource;
        this.mTarget = instance.mTarget;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mWebpImages = instance.mWebpImages;
        this.mWidth = instance.mWidth;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Photo> getParser() {
        return new APIRequest.ResponseParser<Photo>(){

            @Override
            public APINodeList<Photo> parseResponse(String response, APIContext context, APIRequest<Photo> request, String header) throws APIException.MalformedResponseException {
                return Photo.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_PROFILE("profile"),
        VALUE_TAGGED("tagged"),
        VALUE_UPLOADED("uploaded"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumUnpublishedContentType {
        VALUE_ADS_POST("ADS_POST"),
        VALUE_DRAFT("DRAFT"),
        VALUE_INLINE_CREATED("INLINE_CREATED"),
        VALUE_PUBLISHED("PUBLISHED"),
        VALUE_SCHEDULED("SCHEDULED"),
        NULL(null);

        private String value;

        private EnumUnpublishedContentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBackdatedTimeGranularity {
        VALUE_DAY("day"),
        VALUE_HOUR("hour"),
        VALUE_MIN("min"),
        VALUE_MONTH("month"),
        VALUE_NONE("none"),
        VALUE_YEAR("year"),
        NULL(null);

        private String value;

        private EnumBackdatedTimeGranularity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<Photo> {
        Photo lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"album", "alt_text", "alt_text_custom", "backdated_time", "backdated_time_granularity", "can_backdate", "can_delete", "can_tag", "created_time", "event", "from", "height", "icon", "id", "images", "link", "name", "name_tags", "page_story_id", "picture", "place", "position", "source", "target", "updated_time", "webp_images", "width"};

        @Override
        public Photo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Photo parseResponse(String response, String header) throws APIException {
            return Photo.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Photo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Photo execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Photo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Photo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Photo>(){

                public Photo apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAlbumField() {
            return this.requestAlbumField(true);
        }

        public APIRequestGet requestAlbumField(boolean value) {
            this.requestField("album", value);
            return this;
        }

        public APIRequestGet requestAltTextField() {
            return this.requestAltTextField(true);
        }

        public APIRequestGet requestAltTextField(boolean value) {
            this.requestField("alt_text", value);
            return this;
        }

        public APIRequestGet requestAltTextCustomField() {
            return this.requestAltTextCustomField(true);
        }

        public APIRequestGet requestAltTextCustomField(boolean value) {
            this.requestField("alt_text_custom", value);
            return this;
        }

        public APIRequestGet requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGet requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGet requestBackdatedTimeGranularityField() {
            return this.requestBackdatedTimeGranularityField(true);
        }

        public APIRequestGet requestBackdatedTimeGranularityField(boolean value) {
            this.requestField("backdated_time_granularity", value);
            return this;
        }

        public APIRequestGet requestCanBackdateField() {
            return this.requestCanBackdateField(true);
        }

        public APIRequestGet requestCanBackdateField(boolean value) {
            this.requestField("can_backdate", value);
            return this;
        }

        public APIRequestGet requestCanDeleteField() {
            return this.requestCanDeleteField(true);
        }

        public APIRequestGet requestCanDeleteField(boolean value) {
            this.requestField("can_delete", value);
            return this;
        }

        public APIRequestGet requestCanTagField() {
            return this.requestCanTagField(true);
        }

        public APIRequestGet requestCanTagField(boolean value) {
            this.requestField("can_tag", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGet requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGet requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGet requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGet requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGet requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGet requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGet requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGet requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGet requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGet requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestNameTagsField() {
            return this.requestNameTagsField(true);
        }

        public APIRequestGet requestNameTagsField(boolean value) {
            this.requestField("name_tags", value);
            return this;
        }

        public APIRequestGet requestPageStoryIdField() {
            return this.requestPageStoryIdField(true);
        }

        public APIRequestGet requestPageStoryIdField(boolean value) {
            this.requestField("page_story_id", value);
            return this;
        }

        public APIRequestGet requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGet requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGet requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGet requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGet requestPositionField() {
            return this.requestPositionField(true);
        }

        public APIRequestGet requestPositionField(boolean value) {
            this.requestField("position", value);
            return this;
        }

        public APIRequestGet requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGet requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGet requestTargetField() {
            return this.requestTargetField(true);
        }

        public APIRequestGet requestTargetField(boolean value) {
            this.requestField("target", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGet requestWebpImagesField() {
            return this.requestWebpImagesField(true);
        }

        public APIRequestGet requestWebpImagesField(boolean value) {
            this.requestField("webp_images", value);
            return this;
        }

        public APIRequestGet requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGet requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"pid"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete setPid(String pid) {
            this.setParam("pid", pid);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetTags
    extends APIRequest<TaggableSubject> {
        APINodeList<TaggableSubject> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "name"};

        @Override
        public APINodeList<TaggableSubject> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<TaggableSubject> parseResponse(String response, String header) throws APIException {
            return TaggableSubject.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<TaggableSubject> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<TaggableSubject> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<TaggableSubject>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<TaggableSubject>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<TaggableSubject>>(){

                public APINodeList<TaggableSubject> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetTags.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetTags(String nodeId, APIContext context) {
            super(context, nodeId, "/tags", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTags setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTags setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTags requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTags requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTags requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTags requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTags requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTags requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetTags requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetTags requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetTags requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetTags requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetSharedPosts
    extends APIRequest<Post> {
        APINodeList<Post> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"actions", "admin_creator", "allowed_advertising_objectives", "application", "backdated_time", "call_to_action", "caption", "child_attachments", "comments_mirroring_domain", "coordinates", "created_time", "description", "event", "expanded_height", "expanded_width", "feed_targeting", "from", "full_picture", "height", "icon", "id", "instagram_eligibility", "is_app_share", "is_eligible_for_promotion", "is_expired", "is_hidden", "is_instagram_eligible", "is_popular", "is_published", "is_spherical", "link", "message", "message_tags", "multi_share_end_card", "multi_share_optimized", "name", "object_id", "parent_id", "permalink_url", "picture", "place", "privacy", "promotable_id", "promotion_status", "properties", "scheduled_publish_time", "shares", "source", "status_type", "story", "story_tags", "subscribed", "target", "targeting", "timeline_visibility", "type", "updated_time", "via", "video_buying_eligibility", "width"};

        @Override
        public APINodeList<Post> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Post> parseResponse(String response, String header) throws APIException {
            return Post.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Post> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Post> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Post>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Post>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Post>>(){

                public APINodeList<Post> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetSharedPosts.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetSharedPosts(String nodeId, APIContext context) {
            super(context, nodeId, "/sharedposts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSharedPosts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSharedPosts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSharedPosts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSharedPosts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSharedPosts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSharedPosts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSharedPosts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSharedPosts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetSharedPosts requestActionsField() {
            return this.requestActionsField(true);
        }

        public APIRequestGetSharedPosts requestActionsField(boolean value) {
            this.requestField("actions", value);
            return this;
        }

        public APIRequestGetSharedPosts requestAdminCreatorField() {
            return this.requestAdminCreatorField(true);
        }

        public APIRequestGetSharedPosts requestAdminCreatorField(boolean value) {
            this.requestField("admin_creator", value);
            return this;
        }

        public APIRequestGetSharedPosts requestAllowedAdvertisingObjectivesField() {
            return this.requestAllowedAdvertisingObjectivesField(true);
        }

        public APIRequestGetSharedPosts requestAllowedAdvertisingObjectivesField(boolean value) {
            this.requestField("allowed_advertising_objectives", value);
            return this;
        }

        public APIRequestGetSharedPosts requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGetSharedPosts requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGetSharedPosts requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGetSharedPosts requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGetSharedPosts requestCallToActionField() {
            return this.requestCallToActionField(true);
        }

        public APIRequestGetSharedPosts requestCallToActionField(boolean value) {
            this.requestField("call_to_action", value);
            return this;
        }

        public APIRequestGetSharedPosts requestCaptionField() {
            return this.requestCaptionField(true);
        }

        public APIRequestGetSharedPosts requestCaptionField(boolean value) {
            this.requestField("caption", value);
            return this;
        }

        public APIRequestGetSharedPosts requestChildAttachmentsField() {
            return this.requestChildAttachmentsField(true);
        }

        public APIRequestGetSharedPosts requestChildAttachmentsField(boolean value) {
            this.requestField("child_attachments", value);
            return this;
        }

        public APIRequestGetSharedPosts requestCommentsMirroringDomainField() {
            return this.requestCommentsMirroringDomainField(true);
        }

        public APIRequestGetSharedPosts requestCommentsMirroringDomainField(boolean value) {
            this.requestField("comments_mirroring_domain", value);
            return this;
        }

        public APIRequestGetSharedPosts requestCoordinatesField() {
            return this.requestCoordinatesField(true);
        }

        public APIRequestGetSharedPosts requestCoordinatesField(boolean value) {
            this.requestField("coordinates", value);
            return this;
        }

        public APIRequestGetSharedPosts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetSharedPosts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetSharedPosts requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetSharedPosts requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetSharedPosts requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGetSharedPosts requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGetSharedPosts requestExpandedHeightField() {
            return this.requestExpandedHeightField(true);
        }

        public APIRequestGetSharedPosts requestExpandedHeightField(boolean value) {
            this.requestField("expanded_height", value);
            return this;
        }

        public APIRequestGetSharedPosts requestExpandedWidthField() {
            return this.requestExpandedWidthField(true);
        }

        public APIRequestGetSharedPosts requestExpandedWidthField(boolean value) {
            this.requestField("expanded_width", value);
            return this;
        }

        public APIRequestGetSharedPosts requestFeedTargetingField() {
            return this.requestFeedTargetingField(true);
        }

        public APIRequestGetSharedPosts requestFeedTargetingField(boolean value) {
            this.requestField("feed_targeting", value);
            return this;
        }

        public APIRequestGetSharedPosts requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetSharedPosts requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetSharedPosts requestFullPictureField() {
            return this.requestFullPictureField(true);
        }

        public APIRequestGetSharedPosts requestFullPictureField(boolean value) {
            this.requestField("full_picture", value);
            return this;
        }

        public APIRequestGetSharedPosts requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGetSharedPosts requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGetSharedPosts requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetSharedPosts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetSharedPosts requestInstagramEligibilityField() {
            return this.requestInstagramEligibilityField(true);
        }

        public APIRequestGetSharedPosts requestInstagramEligibilityField(boolean value) {
            this.requestField("instagram_eligibility", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsAppShareField() {
            return this.requestIsAppShareField(true);
        }

        public APIRequestGetSharedPosts requestIsAppShareField(boolean value) {
            this.requestField("is_app_share", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsEligibleForPromotionField() {
            return this.requestIsEligibleForPromotionField(true);
        }

        public APIRequestGetSharedPosts requestIsEligibleForPromotionField(boolean value) {
            this.requestField("is_eligible_for_promotion", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsExpiredField() {
            return this.requestIsExpiredField(true);
        }

        public APIRequestGetSharedPosts requestIsExpiredField(boolean value) {
            this.requestField("is_expired", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetSharedPosts requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsInstagramEligibleField() {
            return this.requestIsInstagramEligibleField(true);
        }

        public APIRequestGetSharedPosts requestIsInstagramEligibleField(boolean value) {
            this.requestField("is_instagram_eligible", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsPopularField() {
            return this.requestIsPopularField(true);
        }

        public APIRequestGetSharedPosts requestIsPopularField(boolean value) {
            this.requestField("is_popular", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetSharedPosts requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetSharedPosts requestIsSphericalField() {
            return this.requestIsSphericalField(true);
        }

        public APIRequestGetSharedPosts requestIsSphericalField(boolean value) {
            this.requestField("is_spherical", value);
            return this;
        }

        public APIRequestGetSharedPosts requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetSharedPosts requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetSharedPosts requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGetSharedPosts requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGetSharedPosts requestMessageTagsField() {
            return this.requestMessageTagsField(true);
        }

        public APIRequestGetSharedPosts requestMessageTagsField(boolean value) {
            this.requestField("message_tags", value);
            return this;
        }

        public APIRequestGetSharedPosts requestMultiShareEndCardField() {
            return this.requestMultiShareEndCardField(true);
        }

        public APIRequestGetSharedPosts requestMultiShareEndCardField(boolean value) {
            this.requestField("multi_share_end_card", value);
            return this;
        }

        public APIRequestGetSharedPosts requestMultiShareOptimizedField() {
            return this.requestMultiShareOptimizedField(true);
        }

        public APIRequestGetSharedPosts requestMultiShareOptimizedField(boolean value) {
            this.requestField("multi_share_optimized", value);
            return this;
        }

        public APIRequestGetSharedPosts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetSharedPosts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetSharedPosts requestObjectIdField() {
            return this.requestObjectIdField(true);
        }

        public APIRequestGetSharedPosts requestObjectIdField(boolean value) {
            this.requestField("object_id", value);
            return this;
        }

        public APIRequestGetSharedPosts requestParentIdField() {
            return this.requestParentIdField(true);
        }

        public APIRequestGetSharedPosts requestParentIdField(boolean value) {
            this.requestField("parent_id", value);
            return this;
        }

        public APIRequestGetSharedPosts requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGetSharedPosts requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGetSharedPosts requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGetSharedPosts requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGetSharedPosts requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGetSharedPosts requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGetSharedPosts requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGetSharedPosts requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGetSharedPosts requestPromotableIdField() {
            return this.requestPromotableIdField(true);
        }

        public APIRequestGetSharedPosts requestPromotableIdField(boolean value) {
            this.requestField("promotable_id", value);
            return this;
        }

        public APIRequestGetSharedPosts requestPromotionStatusField() {
            return this.requestPromotionStatusField(true);
        }

        public APIRequestGetSharedPosts requestPromotionStatusField(boolean value) {
            this.requestField("promotion_status", value);
            return this;
        }

        public APIRequestGetSharedPosts requestPropertiesField() {
            return this.requestPropertiesField(true);
        }

        public APIRequestGetSharedPosts requestPropertiesField(boolean value) {
            this.requestField("properties", value);
            return this;
        }

        public APIRequestGetSharedPosts requestScheduledPublishTimeField() {
            return this.requestScheduledPublishTimeField(true);
        }

        public APIRequestGetSharedPosts requestScheduledPublishTimeField(boolean value) {
            this.requestField("scheduled_publish_time", value);
            return this;
        }

        public APIRequestGetSharedPosts requestSharesField() {
            return this.requestSharesField(true);
        }

        public APIRequestGetSharedPosts requestSharesField(boolean value) {
            this.requestField("shares", value);
            return this;
        }

        public APIRequestGetSharedPosts requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetSharedPosts requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetSharedPosts requestStatusTypeField() {
            return this.requestStatusTypeField(true);
        }

        public APIRequestGetSharedPosts requestStatusTypeField(boolean value) {
            this.requestField("status_type", value);
            return this;
        }

        public APIRequestGetSharedPosts requestStoryField() {
            return this.requestStoryField(true);
        }

        public APIRequestGetSharedPosts requestStoryField(boolean value) {
            this.requestField("story", value);
            return this;
        }

        public APIRequestGetSharedPosts requestStoryTagsField() {
            return this.requestStoryTagsField(true);
        }

        public APIRequestGetSharedPosts requestStoryTagsField(boolean value) {
            this.requestField("story_tags", value);
            return this;
        }

        public APIRequestGetSharedPosts requestSubscribedField() {
            return this.requestSubscribedField(true);
        }

        public APIRequestGetSharedPosts requestSubscribedField(boolean value) {
            this.requestField("subscribed", value);
            return this;
        }

        public APIRequestGetSharedPosts requestTargetField() {
            return this.requestTargetField(true);
        }

        public APIRequestGetSharedPosts requestTargetField(boolean value) {
            this.requestField("target", value);
            return this;
        }

        public APIRequestGetSharedPosts requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetSharedPosts requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetSharedPosts requestTimelineVisibilityField() {
            return this.requestTimelineVisibilityField(true);
        }

        public APIRequestGetSharedPosts requestTimelineVisibilityField(boolean value) {
            this.requestField("timeline_visibility", value);
            return this;
        }

        public APIRequestGetSharedPosts requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetSharedPosts requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetSharedPosts requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetSharedPosts requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetSharedPosts requestViaField() {
            return this.requestViaField(true);
        }

        public APIRequestGetSharedPosts requestViaField(boolean value) {
            this.requestField("via", value);
            return this;
        }

        public APIRequestGetSharedPosts requestVideoBuyingEligibilityField() {
            return this.requestVideoBuyingEligibilityField(true);
        }

        public APIRequestGetSharedPosts requestVideoBuyingEligibilityField(boolean value) {
            this.requestField("video_buying_eligibility", value);
            return this;
        }

        public APIRequestGetSharedPosts requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGetSharedPosts requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetReactions
    extends APIRequest<Profile> {
        APINodeList<Profile> lastResponse = null;
        public static final String[] PARAMS = new String[]{"type"};
        public static final String[] FIELDS = new String[]{"can_post", "id", "link", "name", "pic", "pic_crop", "pic_large", "pic_small", "pic_square", "profile_type", "username"};

        @Override
        public APINodeList<Profile> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Profile> parseResponse(String response, String header) throws APIException {
            return Profile.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Profile> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Profile> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Profile>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Profile>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Profile>>(){

                public APINodeList<Profile> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetReactions.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetReactions(String nodeId, APIContext context) {
            super(context, nodeId, "/reactions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetReactions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetReactions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetReactions setType(Profile.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetReactions setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetReactions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetReactions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReactions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetReactions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetReactions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetReactions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetReactions requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetReactions requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetReactions requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetReactions requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetReactions requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetReactions requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetReactions requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetReactions requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetReactions requestPicField() {
            return this.requestPicField(true);
        }

        public APIRequestGetReactions requestPicField(boolean value) {
            this.requestField("pic", value);
            return this;
        }

        public APIRequestGetReactions requestPicCropField() {
            return this.requestPicCropField(true);
        }

        public APIRequestGetReactions requestPicCropField(boolean value) {
            this.requestField("pic_crop", value);
            return this;
        }

        public APIRequestGetReactions requestPicLargeField() {
            return this.requestPicLargeField(true);
        }

        public APIRequestGetReactions requestPicLargeField(boolean value) {
            this.requestField("pic_large", value);
            return this;
        }

        public APIRequestGetReactions requestPicSmallField() {
            return this.requestPicSmallField(true);
        }

        public APIRequestGetReactions requestPicSmallField(boolean value) {
            this.requestField("pic_small", value);
            return this;
        }

        public APIRequestGetReactions requestPicSquareField() {
            return this.requestPicSquareField(true);
        }

        public APIRequestGetReactions requestPicSquareField(boolean value) {
            this.requestField("pic_square", value);
            return this;
        }

        public APIRequestGetReactions requestProfileTypeField() {
            return this.requestProfileTypeField(true);
        }

        public APIRequestGetReactions requestProfileTypeField(boolean value) {
            this.requestField("profile_type", value);
            return this;
        }

        public APIRequestGetReactions requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetReactions requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateLike
    extends APIRequest<Photo> {
        Photo lastResponse = null;
        public static final String[] PARAMS = new String[]{"feedback_source", "nectar_module", "notify", "tracking"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Photo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Photo parseResponse(String response, String header) throws APIException {
            return Photo.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Photo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Photo execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Photo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Photo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Photo>(){

                public Photo apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateLike.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateLike(String nodeId, APIContext context) {
            super(context, nodeId, "/likes", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateLike setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateLike setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateLike setFeedbackSource(String feedbackSource) {
            this.setParam("feedback_source", feedbackSource);
            return this;
        }

        public APIRequestCreateLike setNectarModule(String nectarModule) {
            this.setParam("nectar_module", nectarModule);
            return this;
        }

        public APIRequestCreateLike setNotify(Boolean notify) {
            this.setParam("notify", notify);
            return this;
        }

        public APIRequestCreateLike setNotify(String notify) {
            this.setParam("notify", notify);
            return this;
        }

        public APIRequestCreateLike setTracking(String tracking) {
            this.setParam("tracking", tracking);
            return this;
        }

        public APIRequestCreateLike requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateLike requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLike requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateLike requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLike requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateLike requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetLikes
    extends APIRequest<Profile> {
        APINodeList<Profile> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"can_post", "id", "link", "name", "pic", "pic_crop", "pic_large", "pic_small", "pic_square", "profile_type", "username"};

        @Override
        public APINodeList<Profile> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Profile> parseResponse(String response, String header) throws APIException {
            return Profile.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Profile> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Profile> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Profile>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Profile>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Profile>>(){

                public APINodeList<Profile> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetLikes.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetLikes(String nodeId, APIContext context) {
            super(context, nodeId, "/likes", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetLikes setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetLikes setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetLikes requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetLikes requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLikes requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetLikes requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLikes requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetLikes requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetLikes requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetLikes requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetLikes requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetLikes requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetLikes requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetLikes requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetLikes requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetLikes requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetLikes requestPicField() {
            return this.requestPicField(true);
        }

        public APIRequestGetLikes requestPicField(boolean value) {
            this.requestField("pic", value);
            return this;
        }

        public APIRequestGetLikes requestPicCropField() {
            return this.requestPicCropField(true);
        }

        public APIRequestGetLikes requestPicCropField(boolean value) {
            this.requestField("pic_crop", value);
            return this;
        }

        public APIRequestGetLikes requestPicLargeField() {
            return this.requestPicLargeField(true);
        }

        public APIRequestGetLikes requestPicLargeField(boolean value) {
            this.requestField("pic_large", value);
            return this;
        }

        public APIRequestGetLikes requestPicSmallField() {
            return this.requestPicSmallField(true);
        }

        public APIRequestGetLikes requestPicSmallField(boolean value) {
            this.requestField("pic_small", value);
            return this;
        }

        public APIRequestGetLikes requestPicSquareField() {
            return this.requestPicSquareField(true);
        }

        public APIRequestGetLikes requestPicSquareField(boolean value) {
            this.requestField("pic_square", value);
            return this;
        }

        public APIRequestGetLikes requestProfileTypeField() {
            return this.requestProfileTypeField(true);
        }

        public APIRequestGetLikes requestProfileTypeField(boolean value) {
            this.requestField("profile_type", value);
            return this;
        }

        public APIRequestGetLikes requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetLikes requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetInsights
    extends APIRequest<InsightsResult> {
        APINodeList<InsightsResult> lastResponse = null;
        public static final String[] PARAMS = new String[]{"date_preset", "metric", "period", "since", "until"};
        public static final String[] FIELDS = new String[]{"description", "description_from_api_doc", "id", "name", "period", "title", "values"};

        @Override
        public APINodeList<InsightsResult> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<InsightsResult> parseResponse(String response, String header) throws APIException {
            return InsightsResult.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<InsightsResult> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<InsightsResult> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<InsightsResult>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<InsightsResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<InsightsResult>>(){

                public APINodeList<InsightsResult> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetInsights.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetInsights(String nodeId, APIContext context) {
            super(context, nodeId, "/insights", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetInsights setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInsights setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInsights setDatePreset(InsightsResult.EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGetInsights setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGetInsights setMetric(List<Object> metric) {
            this.setParam("metric", metric);
            return this;
        }

        public APIRequestGetInsights setMetric(String metric) {
            this.setParam("metric", metric);
            return this;
        }

        public APIRequestGetInsights setPeriod(InsightsResult.EnumPeriod period) {
            this.setParam("period", (Object)period);
            return this;
        }

        public APIRequestGetInsights setPeriod(String period) {
            this.setParam("period", period);
            return this;
        }

        public APIRequestGetInsights setSince(String since) {
            this.setParam("since", since);
            return this;
        }

        public APIRequestGetInsights setUntil(String until) {
            this.setParam("until", until);
            return this;
        }

        public APIRequestGetInsights requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInsights requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetInsights requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetInsights requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetInsights requestDescriptionFromApiDocField() {
            return this.requestDescriptionFromApiDocField(true);
        }

        public APIRequestGetInsights requestDescriptionFromApiDocField(boolean value) {
            this.requestField("description_from_api_doc", value);
            return this;
        }

        public APIRequestGetInsights requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetInsights requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetInsights requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetInsights requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetInsights requestPeriodField() {
            return this.requestPeriodField(true);
        }

        public APIRequestGetInsights requestPeriodField(boolean value) {
            this.requestField("period", value);
            return this;
        }

        public APIRequestGetInsights requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetInsights requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetInsights requestValuesField() {
            return this.requestValuesField(true);
        }

        public APIRequestGetInsights requestValuesField(boolean value) {
            this.requestField("values", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateComment
    extends APIRequest<Comment> {
        Comment lastResponse = null;
        public static final String[] PARAMS = new String[]{"attachment_id", "attachment_share_url", "attachment_url", "comment_privacy_value", "facepile_mentioned_ids", "feedback_source", "is_offline", "message", "nectar_module", "object_id", "parent_comment_id", "text", "tracking"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Comment getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Comment parseResponse(String response, String header) throws APIException {
            return Comment.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Comment execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Comment execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Comment> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Comment> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Comment>(){

                public Comment apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateComment.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateComment(String nodeId, APIContext context) {
            super(context, nodeId, "/comments", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateComment setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateComment setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateComment setAttachmentId(String attachmentId) {
            this.setParam("attachment_id", attachmentId);
            return this;
        }

        public APIRequestCreateComment setAttachmentShareUrl(String attachmentShareUrl) {
            this.setParam("attachment_share_url", attachmentShareUrl);
            return this;
        }

        public APIRequestCreateComment setAttachmentUrl(String attachmentUrl) {
            this.setParam("attachment_url", attachmentUrl);
            return this;
        }

        public APIRequestCreateComment setCommentPrivacyValue(Comment.EnumCommentPrivacyValue commentPrivacyValue) {
            this.setParam("comment_privacy_value", (Object)commentPrivacyValue);
            return this;
        }

        public APIRequestCreateComment setCommentPrivacyValue(String commentPrivacyValue) {
            this.setParam("comment_privacy_value", commentPrivacyValue);
            return this;
        }

        public APIRequestCreateComment setFacepileMentionedIds(List<String> facepileMentionedIds) {
            this.setParam("facepile_mentioned_ids", facepileMentionedIds);
            return this;
        }

        public APIRequestCreateComment setFacepileMentionedIds(String facepileMentionedIds) {
            this.setParam("facepile_mentioned_ids", facepileMentionedIds);
            return this;
        }

        public APIRequestCreateComment setFeedbackSource(String feedbackSource) {
            this.setParam("feedback_source", feedbackSource);
            return this;
        }

        public APIRequestCreateComment setIsOffline(Boolean isOffline) {
            this.setParam("is_offline", isOffline);
            return this;
        }

        public APIRequestCreateComment setIsOffline(String isOffline) {
            this.setParam("is_offline", isOffline);
            return this;
        }

        public APIRequestCreateComment setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateComment setNectarModule(String nectarModule) {
            this.setParam("nectar_module", nectarModule);
            return this;
        }

        public APIRequestCreateComment setObjectId(String objectId) {
            this.setParam("object_id", objectId);
            return this;
        }

        public APIRequestCreateComment setParentCommentId(Object parentCommentId) {
            this.setParam("parent_comment_id", parentCommentId);
            return this;
        }

        public APIRequestCreateComment setParentCommentId(String parentCommentId) {
            this.setParam("parent_comment_id", parentCommentId);
            return this;
        }

        public APIRequestCreateComment setText(String text) {
            this.setParam("text", text);
            return this;
        }

        public APIRequestCreateComment setTracking(String tracking) {
            this.setParam("tracking", tracking);
            return this;
        }

        public APIRequestCreateComment requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateComment requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateComment requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateComment requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateComment requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateComment requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetComments
    extends APIRequest<Comment> {
        APINodeList<Comment> lastResponse = null;
        public static final String[] PARAMS = new String[]{"filter", "live_filter", "order", "since"};
        public static final String[] FIELDS = new String[]{"admin_creator", "application", "attachment", "can_comment", "can_hide", "can_like", "can_remove", "comment_count", "created_time", "from", "id", "is_hidden", "is_private", "like_count", "live_broadcast_timestamp", "message", "message_tags", "object", "parent", "permalink_url", "user_likes"};

        @Override
        public APINodeList<Comment> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Comment> parseResponse(String response, String header) throws APIException {
            return Comment.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Comment> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Comment> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Comment>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Comment>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Comment>>(){

                public APINodeList<Comment> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetComments.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetComments(String nodeId, APIContext context) {
            super(context, nodeId, "/comments", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetComments setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetComments setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetComments setFilter(Comment.EnumFilter filter) {
            this.setParam("filter", (Object)filter);
            return this;
        }

        public APIRequestGetComments setFilter(String filter) {
            this.setParam("filter", filter);
            return this;
        }

        public APIRequestGetComments setLiveFilter(Comment.EnumLiveFilter liveFilter) {
            this.setParam("live_filter", (Object)liveFilter);
            return this;
        }

        public APIRequestGetComments setLiveFilter(String liveFilter) {
            this.setParam("live_filter", liveFilter);
            return this;
        }

        public APIRequestGetComments setOrder(Comment.EnumOrder order) {
            this.setParam("order", (Object)order);
            return this;
        }

        public APIRequestGetComments setOrder(String order) {
            this.setParam("order", order);
            return this;
        }

        public APIRequestGetComments setSince(String since) {
            this.setParam("since", since);
            return this;
        }

        public APIRequestGetComments requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetComments requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetComments requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetComments requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetComments requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetComments requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetComments requestAdminCreatorField() {
            return this.requestAdminCreatorField(true);
        }

        public APIRequestGetComments requestAdminCreatorField(boolean value) {
            this.requestField("admin_creator", value);
            return this;
        }

        public APIRequestGetComments requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGetComments requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGetComments requestAttachmentField() {
            return this.requestAttachmentField(true);
        }

        public APIRequestGetComments requestAttachmentField(boolean value) {
            this.requestField("attachment", value);
            return this;
        }

        public APIRequestGetComments requestCanCommentField() {
            return this.requestCanCommentField(true);
        }

        public APIRequestGetComments requestCanCommentField(boolean value) {
            this.requestField("can_comment", value);
            return this;
        }

        public APIRequestGetComments requestCanHideField() {
            return this.requestCanHideField(true);
        }

        public APIRequestGetComments requestCanHideField(boolean value) {
            this.requestField("can_hide", value);
            return this;
        }

        public APIRequestGetComments requestCanLikeField() {
            return this.requestCanLikeField(true);
        }

        public APIRequestGetComments requestCanLikeField(boolean value) {
            this.requestField("can_like", value);
            return this;
        }

        public APIRequestGetComments requestCanRemoveField() {
            return this.requestCanRemoveField(true);
        }

        public APIRequestGetComments requestCanRemoveField(boolean value) {
            this.requestField("can_remove", value);
            return this;
        }

        public APIRequestGetComments requestCommentCountField() {
            return this.requestCommentCountField(true);
        }

        public APIRequestGetComments requestCommentCountField(boolean value) {
            this.requestField("comment_count", value);
            return this;
        }

        public APIRequestGetComments requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetComments requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetComments requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetComments requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetComments requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetComments requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetComments requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetComments requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetComments requestIsPrivateField() {
            return this.requestIsPrivateField(true);
        }

        public APIRequestGetComments requestIsPrivateField(boolean value) {
            this.requestField("is_private", value);
            return this;
        }

        public APIRequestGetComments requestLikeCountField() {
            return this.requestLikeCountField(true);
        }

        public APIRequestGetComments requestLikeCountField(boolean value) {
            this.requestField("like_count", value);
            return this;
        }

        public APIRequestGetComments requestLiveBroadcastTimestampField() {
            return this.requestLiveBroadcastTimestampField(true);
        }

        public APIRequestGetComments requestLiveBroadcastTimestampField(boolean value) {
            this.requestField("live_broadcast_timestamp", value);
            return this;
        }

        public APIRequestGetComments requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGetComments requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGetComments requestMessageTagsField() {
            return this.requestMessageTagsField(true);
        }

        public APIRequestGetComments requestMessageTagsField(boolean value) {
            this.requestField("message_tags", value);
            return this;
        }

        public APIRequestGetComments requestObjectField() {
            return this.requestObjectField(true);
        }

        public APIRequestGetComments requestObjectField(boolean value) {
            this.requestField("object", value);
            return this;
        }

        public APIRequestGetComments requestParentField() {
            return this.requestParentField(true);
        }

        public APIRequestGetComments requestParentField(boolean value) {
            this.requestField("parent", value);
            return this;
        }

        public APIRequestGetComments requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGetComments requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGetComments requestUserLikesField() {
            return this.requestUserLikesField(true);
        }

        public APIRequestGetComments requestUserLikesField(boolean value) {
            this.requestField("user_likes", value);
            return this;
        }
    }
}

