/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessRoleRequest
extends APINode {
    @SerializedName(value="created_by")
    private Object mCreatedBy = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="email")
    private String mEmail = null;
    @SerializedName(value="expiration_time")
    private String mExpirationTime = null;
    @SerializedName(value="expiry_time")
    private String mExpiryTime = null;
    @SerializedName(value="finance_role")
    private String mFinanceRole = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="invite_link")
    private String mInviteLink = null;
    @SerializedName(value="ip_role")
    private String mIpRole = null;
    @SerializedName(value="owner")
    private Business mOwner = null;
    @SerializedName(value="role")
    private String mRole = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="updated_by")
    private Object mUpdatedBy = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    protected static Gson gson = null;

    BusinessRoleRequest() {
    }

    public BusinessRoleRequest(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BusinessRoleRequest(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BusinessRoleRequest fetch() throws APIException {
        BusinessRoleRequest newInstance = BusinessRoleRequest.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BusinessRoleRequest fetchById(Long id, APIContext context) throws APIException {
        return BusinessRoleRequest.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BusinessRoleRequest> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BusinessRoleRequest.fetchByIdAsync(id.toString(), context);
    }

    public static BusinessRoleRequest fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BusinessRoleRequest> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BusinessRoleRequest> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BusinessRoleRequest>(context, "", "/", "GET", BusinessRoleRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BusinessRoleRequest>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BusinessRoleRequest>(context, "", "/", "GET", BusinessRoleRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BusinessRoleRequest loadJSON(String json, APIContext context, String header) {
        BusinessRoleRequest businessRoleRequest = (BusinessRoleRequest)BusinessRoleRequest.getGson().fromJson(json, BusinessRoleRequest.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(businessRoleRequest.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        businessRoleRequest.context = context;
        businessRoleRequest.rawValue = json;
        businessRoleRequest.header = header;
        return businessRoleRequest;
    }

    public static APINodeList<BusinessRoleRequest> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BusinessRoleRequest> businessRoleRequests = new APINodeList<BusinessRoleRequest>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        businessRoleRequests.add(BusinessRoleRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return businessRoleRequests;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            businessRoleRequests.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        businessRoleRequests.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            businessRoleRequests.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            businessRoleRequests.add(BusinessRoleRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                businessRoleRequests.add(BusinessRoleRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            businessRoleRequests.add(BusinessRoleRequest.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return businessRoleRequests;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        businessRoleRequests.add(BusinessRoleRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return businessRoleRequests;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        businessRoleRequests.add(BusinessRoleRequest.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return businessRoleRequests;
                }
                businessRoleRequests.clear();
                businessRoleRequests.add(BusinessRoleRequest.loadJSON(json, context, header));
                return businessRoleRequests;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BusinessRoleRequest.getGson().toJson((Object)this);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Object getFieldCreatedBy() {
        return this.mCreatedBy;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldEmail() {
        return this.mEmail;
    }

    public String getFieldExpirationTime() {
        return this.mExpirationTime;
    }

    public String getFieldExpiryTime() {
        return this.mExpiryTime;
    }

    public String getFieldFinanceRole() {
        return this.mFinanceRole;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldInviteLink() {
        return this.mInviteLink;
    }

    public String getFieldIpRole() {
        return this.mIpRole;
    }

    public Business getFieldOwner() {
        if (this.mOwner != null) {
            this.mOwner.context = this.getContext();
        }
        return this.mOwner;
    }

    public String getFieldRole() {
        return this.mRole;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public Object getFieldUpdatedBy() {
        return this.mUpdatedBy;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BusinessRoleRequest copyFrom(BusinessRoleRequest instance) {
        this.mCreatedBy = instance.mCreatedBy;
        this.mCreatedTime = instance.mCreatedTime;
        this.mEmail = instance.mEmail;
        this.mExpirationTime = instance.mExpirationTime;
        this.mExpiryTime = instance.mExpiryTime;
        this.mFinanceRole = instance.mFinanceRole;
        this.mId = instance.mId;
        this.mInviteLink = instance.mInviteLink;
        this.mIpRole = instance.mIpRole;
        this.mOwner = instance.mOwner;
        this.mRole = instance.mRole;
        this.mStatus = instance.mStatus;
        this.mUpdatedBy = instance.mUpdatedBy;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BusinessRoleRequest> getParser() {
        return new APIRequest.ResponseParser<BusinessRoleRequest>(){

            @Override
            public APINodeList<BusinessRoleRequest> parseResponse(String response, APIContext context, APIRequest<BusinessRoleRequest> request, String header) throws APIException.MalformedResponseException {
                return BusinessRoleRequest.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumRole {
        VALUE_ADMIN("ADMIN"),
        VALUE_ADS_RIGHTS_REVIEWER("ADS_RIGHTS_REVIEWER"),
        VALUE_EMPLOYEE("EMPLOYEE"),
        VALUE_FINANCE_ANALYST("FINANCE_ANALYST"),
        VALUE_FINANCE_EDITOR("FINANCE_EDITOR"),
        NULL(null);

        private String value;

        private EnumRole(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<BusinessRoleRequest> {
        BusinessRoleRequest lastResponse = null;
        public static final String[] PARAMS = new String[]{"role"};
        public static final String[] FIELDS = new String[0];

        @Override
        public BusinessRoleRequest getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessRoleRequest parseResponse(String response, String header) throws APIException {
            return BusinessRoleRequest.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessRoleRequest execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessRoleRequest execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessRoleRequest> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessRoleRequest> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessRoleRequest>(){

                public BusinessRoleRequest apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setRole(EnumRole role) {
            this.setParam("role", (Object)role);
            return this;
        }

        public APIRequestUpdate setRole(String role) {
            this.setParam("role", role);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<BusinessRoleRequest> {
        BusinessRoleRequest lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"created_by", "created_time", "email", "expiration_time", "expiry_time", "finance_role", "id", "invite_link", "ip_role", "owner", "role", "status", "updated_by", "updated_time"};

        @Override
        public BusinessRoleRequest getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BusinessRoleRequest parseResponse(String response, String header) throws APIException {
            return BusinessRoleRequest.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public BusinessRoleRequest execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BusinessRoleRequest execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<BusinessRoleRequest> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BusinessRoleRequest> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, BusinessRoleRequest>(){

                public BusinessRoleRequest apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGet requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGet requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGet requestExpirationTimeField() {
            return this.requestExpirationTimeField(true);
        }

        public APIRequestGet requestExpirationTimeField(boolean value) {
            this.requestField("expiration_time", value);
            return this;
        }

        public APIRequestGet requestExpiryTimeField() {
            return this.requestExpiryTimeField(true);
        }

        public APIRequestGet requestExpiryTimeField(boolean value) {
            this.requestField("expiry_time", value);
            return this;
        }

        public APIRequestGet requestFinanceRoleField() {
            return this.requestFinanceRoleField(true);
        }

        public APIRequestGet requestFinanceRoleField(boolean value) {
            this.requestField("finance_role", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInviteLinkField() {
            return this.requestInviteLinkField(true);
        }

        public APIRequestGet requestInviteLinkField(boolean value) {
            this.requestField("invite_link", value);
            return this;
        }

        public APIRequestGet requestIpRoleField() {
            return this.requestIpRoleField(true);
        }

        public APIRequestGet requestIpRoleField(boolean value) {
            this.requestField("ip_role", value);
            return this;
        }

        public APIRequestGet requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGet requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGet requestRoleField() {
            return this.requestRoleField(true);
        }

        public APIRequestGet requestRoleField(boolean value) {
            this.requestField("role", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGet requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

