/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.LiveVideo;
import com.facebook.ads.sdk.LiveVideoInputStream;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveEncoder
extends APINode {
    @SerializedName(value="brand")
    private String mBrand = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="current_broadcast")
    private LiveVideo mCurrentBroadcast = null;
    @SerializedName(value="current_input_stream")
    private LiveVideoInputStream mCurrentInputStream = null;
    @SerializedName(value="device_id")
    private String mDeviceId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="last_heartbeat_time")
    private String mLastHeartbeatTime = null;
    @SerializedName(value="model")
    private String mModel = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="version")
    private String mVersion = null;
    protected static Gson gson = null;

    LiveEncoder() {
    }

    public LiveEncoder(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public LiveEncoder(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public LiveEncoder fetch() throws APIException {
        LiveEncoder newInstance = LiveEncoder.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static LiveEncoder fetchById(Long id, APIContext context) throws APIException {
        return LiveEncoder.fetchById(id.toString(), context);
    }

    public static ListenableFuture<LiveEncoder> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return LiveEncoder.fetchByIdAsync(id.toString(), context);
    }

    public static LiveEncoder fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<LiveEncoder> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<LiveEncoder> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<LiveEncoder>(context, "", "/", "GET", LiveEncoder.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<LiveEncoder>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<LiveEncoder>(context, "", "/", "GET", LiveEncoder.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static LiveEncoder loadJSON(String json, APIContext context, String header) {
        LiveEncoder liveEncoder = (LiveEncoder)LiveEncoder.getGson().fromJson(json, LiveEncoder.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(liveEncoder.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        liveEncoder.context = context;
        liveEncoder.rawValue = json;
        liveEncoder.header = header;
        return liveEncoder;
    }

    public static APINodeList<LiveEncoder> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LiveEncoder> liveEncoders = new APINodeList<LiveEncoder>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        liveEncoders.add(LiveEncoder.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return liveEncoders;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            liveEncoders.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        liveEncoders.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            liveEncoders.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            liveEncoders.add(LiveEncoder.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                liveEncoders.add(LiveEncoder.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            liveEncoders.add(LiveEncoder.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return liveEncoders;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        liveEncoders.add(LiveEncoder.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return liveEncoders;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        liveEncoders.add(LiveEncoder.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return liveEncoders;
                }
                liveEncoders.clear();
                liveEncoders.add(LiveEncoder.loadJSON(json, context, header));
                return liveEncoders;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LiveEncoder.getGson().toJson((Object)this);
    }

    public APIRequestCreateTelemetry createTelemetry() {
        return new APIRequestCreateTelemetry(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBrand() {
        return this.mBrand;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public LiveVideo getFieldCurrentBroadcast() {
        if (this.mCurrentBroadcast != null) {
            this.mCurrentBroadcast.context = this.getContext();
        }
        return this.mCurrentBroadcast;
    }

    public LiveVideoInputStream getFieldCurrentInputStream() {
        if (this.mCurrentInputStream != null) {
            this.mCurrentInputStream.context = this.getContext();
        }
        return this.mCurrentInputStream;
    }

    public String getFieldDeviceId() {
        return this.mDeviceId;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldLastHeartbeatTime() {
        return this.mLastHeartbeatTime;
    }

    public String getFieldModel() {
        return this.mModel;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldVersion() {
        return this.mVersion;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LiveEncoder copyFrom(LiveEncoder instance) {
        this.mBrand = instance.mBrand;
        this.mCreationTime = instance.mCreationTime;
        this.mCurrentBroadcast = instance.mCurrentBroadcast;
        this.mCurrentInputStream = instance.mCurrentInputStream;
        this.mDeviceId = instance.mDeviceId;
        this.mId = instance.mId;
        this.mLastHeartbeatTime = instance.mLastHeartbeatTime;
        this.mModel = instance.mModel;
        this.mName = instance.mName;
        this.mStatus = instance.mStatus;
        this.mVersion = instance.mVersion;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LiveEncoder> getParser() {
        return new APIRequest.ResponseParser<LiveEncoder>(){

            @Override
            public APINodeList<LiveEncoder> parseResponse(String response, APIContext context, APIRequest<LiveEncoder> request, String header) throws APIException.MalformedResponseException {
                return LiveEncoder.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStatus {
        VALUE_CAPTURE("CAPTURE"),
        VALUE_LIVE("LIVE"),
        VALUE_NONE("NONE"),
        VALUE_PREVIEW("PREVIEW"),
        VALUE_READY("READY"),
        VALUE_REGISTER("REGISTER"),
        NULL(null);

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<LiveEncoder> {
        LiveEncoder lastResponse = null;
        public static final String[] PARAMS = new String[]{"broadcast_id", "cap_audio_codecs", "cap_streaming_protocols", "cap_video_codecs", "error_code", "error_msg", "input_audio_channels", "input_audio_samplerate", "input_video_framerate", "input_video_gop_num_b_frames", "input_video_gop_size", "input_video_height", "input_video_interlace_mode", "input_video_width", "name", "status", "version"};
        public static final String[] FIELDS = new String[0];

        @Override
        public LiveEncoder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LiveEncoder parseResponse(String response, String header) throws APIException {
            return LiveEncoder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public LiveEncoder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LiveEncoder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<LiveEncoder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LiveEncoder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, LiveEncoder>(){

                public LiveEncoder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setBroadcastId(String broadcastId) {
            this.setParam("broadcast_id", broadcastId);
            return this;
        }

        public APIRequestUpdate setCapAudioCodecs(Object capAudioCodecs) {
            this.setParam("cap_audio_codecs", capAudioCodecs);
            return this;
        }

        public APIRequestUpdate setCapAudioCodecs(String capAudioCodecs) {
            this.setParam("cap_audio_codecs", capAudioCodecs);
            return this;
        }

        public APIRequestUpdate setCapStreamingProtocols(Object capStreamingProtocols) {
            this.setParam("cap_streaming_protocols", capStreamingProtocols);
            return this;
        }

        public APIRequestUpdate setCapStreamingProtocols(String capStreamingProtocols) {
            this.setParam("cap_streaming_protocols", capStreamingProtocols);
            return this;
        }

        public APIRequestUpdate setCapVideoCodecs(Object capVideoCodecs) {
            this.setParam("cap_video_codecs", capVideoCodecs);
            return this;
        }

        public APIRequestUpdate setCapVideoCodecs(String capVideoCodecs) {
            this.setParam("cap_video_codecs", capVideoCodecs);
            return this;
        }

        public APIRequestUpdate setErrorCode(Long errorCode) {
            this.setParam("error_code", errorCode);
            return this;
        }

        public APIRequestUpdate setErrorCode(String errorCode) {
            this.setParam("error_code", errorCode);
            return this;
        }

        public APIRequestUpdate setErrorMsg(String errorMsg) {
            this.setParam("error_msg", errorMsg);
            return this;
        }

        public APIRequestUpdate setInputAudioChannels(Long inputAudioChannels) {
            this.setParam("input_audio_channels", inputAudioChannels);
            return this;
        }

        public APIRequestUpdate setInputAudioChannels(String inputAudioChannels) {
            this.setParam("input_audio_channels", inputAudioChannels);
            return this;
        }

        public APIRequestUpdate setInputAudioSamplerate(Long inputAudioSamplerate) {
            this.setParam("input_audio_samplerate", inputAudioSamplerate);
            return this;
        }

        public APIRequestUpdate setInputAudioSamplerate(String inputAudioSamplerate) {
            this.setParam("input_audio_samplerate", inputAudioSamplerate);
            return this;
        }

        public APIRequestUpdate setInputVideoFramerate(String inputVideoFramerate) {
            this.setParam("input_video_framerate", inputVideoFramerate);
            return this;
        }

        public APIRequestUpdate setInputVideoGopNumBFrames(Long inputVideoGopNumBFrames) {
            this.setParam("input_video_gop_num_b_frames", inputVideoGopNumBFrames);
            return this;
        }

        public APIRequestUpdate setInputVideoGopNumBFrames(String inputVideoGopNumBFrames) {
            this.setParam("input_video_gop_num_b_frames", inputVideoGopNumBFrames);
            return this;
        }

        public APIRequestUpdate setInputVideoGopSize(Long inputVideoGopSize) {
            this.setParam("input_video_gop_size", inputVideoGopSize);
            return this;
        }

        public APIRequestUpdate setInputVideoGopSize(String inputVideoGopSize) {
            this.setParam("input_video_gop_size", inputVideoGopSize);
            return this;
        }

        public APIRequestUpdate setInputVideoHeight(Long inputVideoHeight) {
            this.setParam("input_video_height", inputVideoHeight);
            return this;
        }

        public APIRequestUpdate setInputVideoHeight(String inputVideoHeight) {
            this.setParam("input_video_height", inputVideoHeight);
            return this;
        }

        public APIRequestUpdate setInputVideoInterlaceMode(String inputVideoInterlaceMode) {
            this.setParam("input_video_interlace_mode", inputVideoInterlaceMode);
            return this;
        }

        public APIRequestUpdate setInputVideoWidth(Long inputVideoWidth) {
            this.setParam("input_video_width", inputVideoWidth);
            return this;
        }

        public APIRequestUpdate setInputVideoWidth(String inputVideoWidth) {
            this.setParam("input_video_width", inputVideoWidth);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setStatus(EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestUpdate setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestUpdate setVersion(String version) {
            this.setParam("version", version);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<LiveEncoder> {
        LiveEncoder lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"brand", "creation_time", "current_broadcast", "current_input_stream", "device_id", "id", "last_heartbeat_time", "model", "name", "status", "version"};

        @Override
        public LiveEncoder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LiveEncoder parseResponse(String response, String header) throws APIException {
            return LiveEncoder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public LiveEncoder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LiveEncoder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<LiveEncoder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LiveEncoder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, LiveEncoder>(){

                public LiveEncoder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBrandField() {
            return this.requestBrandField(true);
        }

        public APIRequestGet requestBrandField(boolean value) {
            this.requestField("brand", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCurrentBroadcastField() {
            return this.requestCurrentBroadcastField(true);
        }

        public APIRequestGet requestCurrentBroadcastField(boolean value) {
            this.requestField("current_broadcast", value);
            return this;
        }

        public APIRequestGet requestCurrentInputStreamField() {
            return this.requestCurrentInputStreamField(true);
        }

        public APIRequestGet requestCurrentInputStreamField(boolean value) {
            this.requestField("current_input_stream", value);
            return this;
        }

        public APIRequestGet requestDeviceIdField() {
            return this.requestDeviceIdField(true);
        }

        public APIRequestGet requestDeviceIdField(boolean value) {
            this.requestField("device_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLastHeartbeatTimeField() {
            return this.requestLastHeartbeatTimeField(true);
        }

        public APIRequestGet requestLastHeartbeatTimeField(boolean value) {
            this.requestField("last_heartbeat_time", value);
            return this;
        }

        public APIRequestGet requestModelField() {
            return this.requestModelField(true);
        }

        public APIRequestGet requestModelField(boolean value) {
            this.requestField("model", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestVersionField() {
            return this.requestVersionField(true);
        }

        public APIRequestGet requestVersionField(boolean value) {
            this.requestField("version", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateTelemetry
    extends APIRequest<LiveEncoder> {
        LiveEncoder lastResponse = null;
        public static final String[] PARAMS = new String[]{"bitrate", "broadcast_id", "cpu_load_15m", "cpu_load_1m", "cpu_load_5m", "cpu_temperature", "cpu_usage", "framerate", "frames_dropped", "gpu_temperature", "gpu_usage", "last_audio_timecode", "last_video_keyframe_timecode", "last_video_timecode", "memory_usage", "network_latency", "network_rx_bandwidth", "network_rx_packets_dropped", "network_rx_packets_errors", "network_tx_bandwidth", "network_tx_packets_dropped", "network_tx_packets_errors", "process_uptime", "status", "timestamp", "total_audio_frames_sent", "total_video_frames_sent", "total_video_keyframes_sent", "uptime"};
        public static final String[] FIELDS = new String[0];

        @Override
        public LiveEncoder getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LiveEncoder parseResponse(String response, String header) throws APIException {
            return LiveEncoder.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public LiveEncoder execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LiveEncoder execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<LiveEncoder> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LiveEncoder> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, LiveEncoder>(){

                public LiveEncoder apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateTelemetry.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateTelemetry(String nodeId, APIContext context) {
            super(context, nodeId, "/telemetry", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateTelemetry setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateTelemetry setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateTelemetry setBitrate(Long bitrate) {
            this.setParam("bitrate", bitrate);
            return this;
        }

        public APIRequestCreateTelemetry setBitrate(String bitrate) {
            this.setParam("bitrate", bitrate);
            return this;
        }

        public APIRequestCreateTelemetry setBroadcastId(String broadcastId) {
            this.setParam("broadcast_id", broadcastId);
            return this;
        }

        public APIRequestCreateTelemetry setCpuLoad15m(Double cpuLoad15m) {
            this.setParam("cpu_load_15m", cpuLoad15m);
            return this;
        }

        public APIRequestCreateTelemetry setCpuLoad15m(String cpuLoad15m) {
            this.setParam("cpu_load_15m", cpuLoad15m);
            return this;
        }

        public APIRequestCreateTelemetry setCpuLoad1m(Double cpuLoad1m) {
            this.setParam("cpu_load_1m", cpuLoad1m);
            return this;
        }

        public APIRequestCreateTelemetry setCpuLoad1m(String cpuLoad1m) {
            this.setParam("cpu_load_1m", cpuLoad1m);
            return this;
        }

        public APIRequestCreateTelemetry setCpuLoad5m(Double cpuLoad5m) {
            this.setParam("cpu_load_5m", cpuLoad5m);
            return this;
        }

        public APIRequestCreateTelemetry setCpuLoad5m(String cpuLoad5m) {
            this.setParam("cpu_load_5m", cpuLoad5m);
            return this;
        }

        public APIRequestCreateTelemetry setCpuTemperature(Long cpuTemperature) {
            this.setParam("cpu_temperature", cpuTemperature);
            return this;
        }

        public APIRequestCreateTelemetry setCpuTemperature(String cpuTemperature) {
            this.setParam("cpu_temperature", cpuTemperature);
            return this;
        }

        public APIRequestCreateTelemetry setCpuUsage(Double cpuUsage) {
            this.setParam("cpu_usage", cpuUsage);
            return this;
        }

        public APIRequestCreateTelemetry setCpuUsage(String cpuUsage) {
            this.setParam("cpu_usage", cpuUsage);
            return this;
        }

        public APIRequestCreateTelemetry setFramerate(Double framerate) {
            this.setParam("framerate", framerate);
            return this;
        }

        public APIRequestCreateTelemetry setFramerate(String framerate) {
            this.setParam("framerate", framerate);
            return this;
        }

        public APIRequestCreateTelemetry setFramesDropped(Double framesDropped) {
            this.setParam("frames_dropped", framesDropped);
            return this;
        }

        public APIRequestCreateTelemetry setFramesDropped(String framesDropped) {
            this.setParam("frames_dropped", framesDropped);
            return this;
        }

        public APIRequestCreateTelemetry setGpuTemperature(Long gpuTemperature) {
            this.setParam("gpu_temperature", gpuTemperature);
            return this;
        }

        public APIRequestCreateTelemetry setGpuTemperature(String gpuTemperature) {
            this.setParam("gpu_temperature", gpuTemperature);
            return this;
        }

        public APIRequestCreateTelemetry setGpuUsage(Double gpuUsage) {
            this.setParam("gpu_usage", gpuUsage);
            return this;
        }

        public APIRequestCreateTelemetry setGpuUsage(String gpuUsage) {
            this.setParam("gpu_usage", gpuUsage);
            return this;
        }

        public APIRequestCreateTelemetry setLastAudioTimecode(Long lastAudioTimecode) {
            this.setParam("last_audio_timecode", lastAudioTimecode);
            return this;
        }

        public APIRequestCreateTelemetry setLastAudioTimecode(String lastAudioTimecode) {
            this.setParam("last_audio_timecode", lastAudioTimecode);
            return this;
        }

        public APIRequestCreateTelemetry setLastVideoKeyframeTimecode(Long lastVideoKeyframeTimecode) {
            this.setParam("last_video_keyframe_timecode", lastVideoKeyframeTimecode);
            return this;
        }

        public APIRequestCreateTelemetry setLastVideoKeyframeTimecode(String lastVideoKeyframeTimecode) {
            this.setParam("last_video_keyframe_timecode", lastVideoKeyframeTimecode);
            return this;
        }

        public APIRequestCreateTelemetry setLastVideoTimecode(Long lastVideoTimecode) {
            this.setParam("last_video_timecode", lastVideoTimecode);
            return this;
        }

        public APIRequestCreateTelemetry setLastVideoTimecode(String lastVideoTimecode) {
            this.setParam("last_video_timecode", lastVideoTimecode);
            return this;
        }

        public APIRequestCreateTelemetry setMemoryUsage(Double memoryUsage) {
            this.setParam("memory_usage", memoryUsage);
            return this;
        }

        public APIRequestCreateTelemetry setMemoryUsage(String memoryUsage) {
            this.setParam("memory_usage", memoryUsage);
            return this;
        }

        public APIRequestCreateTelemetry setNetworkLatency(Double networkLatency) {
            this.setParam("network_latency", networkLatency);
            return this;
        }

        public APIRequestCreateTelemetry setNetworkLatency(String networkLatency) {
            this.setParam("network_latency", networkLatency);
            return this;
        }

        public APIRequestCreateTelemetry setNetworkRxBandwidth(Long networkRxBandwidth) {
            this.setParam("network_rx_bandwidth", networkRxBandwidth);
            return this;
        }

        public APIRequestCreateTelemetry setNetworkRxBandwidth(String networkRxBandwidth) {
            this.setParam("network_rx_bandwidth", networkRxBandwidth);
            return this;
        }

        public APIRequestCreateTelemetry setNetworkRxPacketsDropped(Double networkRxPacketsDropped) {
            this.setParam("network_rx_packets_dropped", networkRxPacketsDropped);
            return this;
        }

        public APIRequestCreateTelemetry setNetworkRxPacketsDropped(String networkRxPacketsDropped) {
            this.setParam("network_rx_packets_dropped", networkRxPacketsDropped);
            return this;
        }

        public APIRequestCreateTelemetry setNetworkRxPacketsErrors(Double networkRxPacketsErrors) {
            this.setParam("network_rx_packets_errors", networkRxPacketsErrors);
            return this;
        }

        public APIRequestCreateTelemetry setNetworkRxPacketsErrors(String networkRxPacketsErrors) {
            this.setParam("network_rx_packets_errors", networkRxPacketsErrors);
            return this;
        }

        public APIRequestCreateTelemetry setNetworkTxBandwidth(Long networkTxBandwidth) {
            this.setParam("network_tx_bandwidth", networkTxBandwidth);
            return this;
        }

        public APIRequestCreateTelemetry setNetworkTxBandwidth(String networkTxBandwidth) {
            this.setParam("network_tx_bandwidth", networkTxBandwidth);
            return this;
        }

        public APIRequestCreateTelemetry setNetworkTxPacketsDropped(Double networkTxPacketsDropped) {
            this.setParam("network_tx_packets_dropped", networkTxPacketsDropped);
            return this;
        }

        public APIRequestCreateTelemetry setNetworkTxPacketsDropped(String networkTxPacketsDropped) {
            this.setParam("network_tx_packets_dropped", networkTxPacketsDropped);
            return this;
        }

        public APIRequestCreateTelemetry setNetworkTxPacketsErrors(Double networkTxPacketsErrors) {
            this.setParam("network_tx_packets_errors", networkTxPacketsErrors);
            return this;
        }

        public APIRequestCreateTelemetry setNetworkTxPacketsErrors(String networkTxPacketsErrors) {
            this.setParam("network_tx_packets_errors", networkTxPacketsErrors);
            return this;
        }

        public APIRequestCreateTelemetry setProcessUptime(Long processUptime) {
            this.setParam("process_uptime", processUptime);
            return this;
        }

        public APIRequestCreateTelemetry setProcessUptime(String processUptime) {
            this.setParam("process_uptime", processUptime);
            return this;
        }

        public APIRequestCreateTelemetry setStatus(EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestCreateTelemetry setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestCreateTelemetry setTimestamp(Long timestamp) {
            this.setParam("timestamp", timestamp);
            return this;
        }

        public APIRequestCreateTelemetry setTimestamp(String timestamp) {
            this.setParam("timestamp", timestamp);
            return this;
        }

        public APIRequestCreateTelemetry setTotalAudioFramesSent(Long totalAudioFramesSent) {
            this.setParam("total_audio_frames_sent", totalAudioFramesSent);
            return this;
        }

        public APIRequestCreateTelemetry setTotalAudioFramesSent(String totalAudioFramesSent) {
            this.setParam("total_audio_frames_sent", totalAudioFramesSent);
            return this;
        }

        public APIRequestCreateTelemetry setTotalVideoFramesSent(Long totalVideoFramesSent) {
            this.setParam("total_video_frames_sent", totalVideoFramesSent);
            return this;
        }

        public APIRequestCreateTelemetry setTotalVideoFramesSent(String totalVideoFramesSent) {
            this.setParam("total_video_frames_sent", totalVideoFramesSent);
            return this;
        }

        public APIRequestCreateTelemetry setTotalVideoKeyframesSent(Long totalVideoKeyframesSent) {
            this.setParam("total_video_keyframes_sent", totalVideoKeyframesSent);
            return this;
        }

        public APIRequestCreateTelemetry setTotalVideoKeyframesSent(String totalVideoKeyframesSent) {
            this.setParam("total_video_keyframes_sent", totalVideoKeyframesSent);
            return this;
        }

        public APIRequestCreateTelemetry setUptime(Long uptime) {
            this.setParam("uptime", uptime);
            return this;
        }

        public APIRequestCreateTelemetry setUptime(String uptime) {
            this.setParam("uptime", uptime);
            return this;
        }

        public APIRequestCreateTelemetry requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateTelemetry requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateTelemetry requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateTelemetry requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateTelemetry requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateTelemetry requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

