/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.CopyrightReferenceContainer;
import com.facebook.ads.sdk.User;
import com.facebook.ads.sdk.VideoCopyrightGeoGate;
import com.facebook.ads.sdk.VideoCopyrightRule;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoCopyright
extends APINode {
    @SerializedName(value="content_category")
    private String mContentCategory = null;
    @SerializedName(value="copyright_content_id")
    private String mCopyrightContentId = null;
    @SerializedName(value="creator")
    private User mCreator = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="in_conflict")
    private Boolean mInConflict = null;
    @SerializedName(value="monitoring_status")
    private String mMonitoringStatus = null;
    @SerializedName(value="monitoring_type")
    private String mMonitoringType = null;
    @SerializedName(value="ownership_countries")
    private VideoCopyrightGeoGate mOwnershipCountries = null;
    @SerializedName(value="reference_file")
    private CopyrightReferenceContainer mReferenceFile = null;
    @SerializedName(value="reference_file_disabled")
    private Boolean mReferenceFileDisabled = null;
    @SerializedName(value="reference_file_disabled_by_ops")
    private Boolean mReferenceFileDisabledByOps = null;
    @SerializedName(value="reference_file_expired")
    private Boolean mReferenceFileExpired = null;
    @SerializedName(value="reference_owner_id")
    private String mReferenceOwnerId = null;
    @SerializedName(value="rule_ids")
    private List<VideoCopyrightRule> mRuleIds = null;
    @SerializedName(value="whitelisted_ids")
    private List<String> mWhitelistedIds = null;
    protected static Gson gson = null;

    VideoCopyright() {
    }

    public VideoCopyright(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public VideoCopyright(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public VideoCopyright fetch() throws APIException {
        VideoCopyright newInstance = VideoCopyright.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static VideoCopyright fetchById(Long id, APIContext context) throws APIException {
        return VideoCopyright.fetchById(id.toString(), context);
    }

    public static ListenableFuture<VideoCopyright> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return VideoCopyright.fetchByIdAsync(id.toString(), context);
    }

    public static VideoCopyright fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<VideoCopyright> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<VideoCopyright> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<VideoCopyright>(context, "", "/", "GET", VideoCopyright.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<VideoCopyright>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<VideoCopyright>(context, "", "/", "GET", VideoCopyright.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static VideoCopyright loadJSON(String json, APIContext context, String header) {
        VideoCopyright videoCopyright = (VideoCopyright)VideoCopyright.getGson().fromJson(json, VideoCopyright.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(videoCopyright.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        videoCopyright.context = context;
        videoCopyright.rawValue = json;
        videoCopyright.header = header;
        return videoCopyright;
    }

    public static APINodeList<VideoCopyright> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<VideoCopyright> videoCopyrights = new APINodeList<VideoCopyright>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        videoCopyrights.add(VideoCopyright.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return videoCopyrights;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            videoCopyrights.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        videoCopyrights.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            videoCopyrights.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            videoCopyrights.add(VideoCopyright.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                videoCopyrights.add(VideoCopyright.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            videoCopyrights.add(VideoCopyright.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return videoCopyrights;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        videoCopyrights.add(VideoCopyright.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return videoCopyrights;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        videoCopyrights.add(VideoCopyright.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return videoCopyrights;
                }
                videoCopyrights.clear();
                videoCopyrights.add(VideoCopyright.loadJSON(json, context, header));
                return videoCopyrights;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return VideoCopyright.getGson().toJson((Object)this);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldContentCategory() {
        return this.mContentCategory;
    }

    public String getFieldCopyrightContentId() {
        return this.mCopyrightContentId;
    }

    public User getFieldCreator() {
        if (this.mCreator != null) {
            this.mCreator.context = this.getContext();
        }
        return this.mCreator;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldInConflict() {
        return this.mInConflict;
    }

    public String getFieldMonitoringStatus() {
        return this.mMonitoringStatus;
    }

    public String getFieldMonitoringType() {
        return this.mMonitoringType;
    }

    public VideoCopyrightGeoGate getFieldOwnershipCountries() {
        return this.mOwnershipCountries;
    }

    public CopyrightReferenceContainer getFieldReferenceFile() {
        return this.mReferenceFile;
    }

    public Boolean getFieldReferenceFileDisabled() {
        return this.mReferenceFileDisabled;
    }

    public Boolean getFieldReferenceFileDisabledByOps() {
        return this.mReferenceFileDisabledByOps;
    }

    public Boolean getFieldReferenceFileExpired() {
        return this.mReferenceFileExpired;
    }

    public String getFieldReferenceOwnerId() {
        return this.mReferenceOwnerId;
    }

    public List<VideoCopyrightRule> getFieldRuleIds() {
        return this.mRuleIds;
    }

    public List<String> getFieldWhitelistedIds() {
        return this.mWhitelistedIds;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public VideoCopyright copyFrom(VideoCopyright instance) {
        this.mContentCategory = instance.mContentCategory;
        this.mCopyrightContentId = instance.mCopyrightContentId;
        this.mCreator = instance.mCreator;
        this.mId = instance.mId;
        this.mInConflict = instance.mInConflict;
        this.mMonitoringStatus = instance.mMonitoringStatus;
        this.mMonitoringType = instance.mMonitoringType;
        this.mOwnershipCountries = instance.mOwnershipCountries;
        this.mReferenceFile = instance.mReferenceFile;
        this.mReferenceFileDisabled = instance.mReferenceFileDisabled;
        this.mReferenceFileDisabledByOps = instance.mReferenceFileDisabledByOps;
        this.mReferenceFileExpired = instance.mReferenceFileExpired;
        this.mReferenceOwnerId = instance.mReferenceOwnerId;
        this.mRuleIds = instance.mRuleIds;
        this.mWhitelistedIds = instance.mWhitelistedIds;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<VideoCopyright> getParser() {
        return new APIRequest.ResponseParser<VideoCopyright>(){

            @Override
            public APINodeList<VideoCopyright> parseResponse(String response, APIContext context, APIRequest<VideoCopyright> request, String header) throws APIException.MalformedResponseException {
                return VideoCopyright.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumMonitoringType {
        VALUE_AUDIO_ONLY("AUDIO_ONLY"),
        VALUE_VIDEO_AND_AUDIO("VIDEO_AND_AUDIO"),
        VALUE_VIDEO_ONLY("VIDEO_ONLY"),
        NULL(null);

        private String value;

        private EnumMonitoringType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumContentCategory {
        VALUE_EPISODE("episode"),
        VALUE_MOVIE("movie"),
        VALUE_WEB("web"),
        NULL(null);

        private String value;

        private EnumContentCategory(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<VideoCopyright> {
        VideoCopyright lastResponse = null;
        public static final String[] PARAMS = new String[]{"monitoring_type", "rule_id", "whitelisted_ids", "whitelisted_ig_user_ids", "ownership_countries", "excluded_ownership_countries", "excluded_ownership_segments", "is_reference_disabled", "content_category", "attribution_id", "append_excluded_ownership_segments"};
        public static final String[] FIELDS = new String[0];

        @Override
        public VideoCopyright getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public VideoCopyright parseResponse(String response, String header) throws APIException {
            return VideoCopyright.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public VideoCopyright execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public VideoCopyright execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<VideoCopyright> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<VideoCopyright> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, VideoCopyright>(){

                public VideoCopyright apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setMonitoringType(EnumMonitoringType monitoringType) {
            this.setParam("monitoring_type", (Object)monitoringType);
            return this;
        }

        public APIRequestUpdate setMonitoringType(String monitoringType) {
            this.setParam("monitoring_type", monitoringType);
            return this;
        }

        public APIRequestUpdate setRuleId(String ruleId) {
            this.setParam("rule_id", ruleId);
            return this;
        }

        public APIRequestUpdate setWhitelistedIds(List<String> whitelistedIds) {
            this.setParam("whitelisted_ids", whitelistedIds);
            return this;
        }

        public APIRequestUpdate setWhitelistedIds(String whitelistedIds) {
            this.setParam("whitelisted_ids", whitelistedIds);
            return this;
        }

        public APIRequestUpdate setWhitelistedIgUserIds(List<String> whitelistedIgUserIds) {
            this.setParam("whitelisted_ig_user_ids", whitelistedIgUserIds);
            return this;
        }

        public APIRequestUpdate setWhitelistedIgUserIds(String whitelistedIgUserIds) {
            this.setParam("whitelisted_ig_user_ids", whitelistedIgUserIds);
            return this;
        }

        public APIRequestUpdate setOwnershipCountries(List<String> ownershipCountries) {
            this.setParam("ownership_countries", ownershipCountries);
            return this;
        }

        public APIRequestUpdate setOwnershipCountries(String ownershipCountries) {
            this.setParam("ownership_countries", ownershipCountries);
            return this;
        }

        public APIRequestUpdate setExcludedOwnershipCountries(List<String> excludedOwnershipCountries) {
            this.setParam("excluded_ownership_countries", excludedOwnershipCountries);
            return this;
        }

        public APIRequestUpdate setExcludedOwnershipCountries(String excludedOwnershipCountries) {
            this.setParam("excluded_ownership_countries", excludedOwnershipCountries);
            return this;
        }

        public APIRequestUpdate setExcludedOwnershipSegments(List<Object> excludedOwnershipSegments) {
            this.setParam("excluded_ownership_segments", excludedOwnershipSegments);
            return this;
        }

        public APIRequestUpdate setExcludedOwnershipSegments(String excludedOwnershipSegments) {
            this.setParam("excluded_ownership_segments", excludedOwnershipSegments);
            return this;
        }

        public APIRequestUpdate setIsReferenceDisabled(Boolean isReferenceDisabled) {
            this.setParam("is_reference_disabled", isReferenceDisabled);
            return this;
        }

        public APIRequestUpdate setIsReferenceDisabled(String isReferenceDisabled) {
            this.setParam("is_reference_disabled", isReferenceDisabled);
            return this;
        }

        public APIRequestUpdate setContentCategory(EnumContentCategory contentCategory) {
            this.setParam("content_category", (Object)contentCategory);
            return this;
        }

        public APIRequestUpdate setContentCategory(String contentCategory) {
            this.setParam("content_category", contentCategory);
            return this;
        }

        public APIRequestUpdate setAttributionId(String attributionId) {
            this.setParam("attribution_id", attributionId);
            return this;
        }

        public APIRequestUpdate setAppendExcludedOwnershipSegments(Boolean appendExcludedOwnershipSegments) {
            this.setParam("append_excluded_ownership_segments", appendExcludedOwnershipSegments);
            return this;
        }

        public APIRequestUpdate setAppendExcludedOwnershipSegments(String appendExcludedOwnershipSegments) {
            this.setParam("append_excluded_ownership_segments", appendExcludedOwnershipSegments);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<VideoCopyright> {
        VideoCopyright lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"content_category", "copyright_content_id", "creator", "id", "in_conflict", "monitoring_status", "monitoring_type", "ownership_countries", "reference_file", "reference_file_disabled", "reference_file_disabled_by_ops", "reference_file_expired", "reference_owner_id", "rule_ids", "whitelisted_ids"};

        @Override
        public VideoCopyright getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public VideoCopyright parseResponse(String response, String header) throws APIException {
            return VideoCopyright.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public VideoCopyright execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public VideoCopyright execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<VideoCopyright> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<VideoCopyright> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, VideoCopyright>(){

                public VideoCopyright apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestContentCategoryField() {
            return this.requestContentCategoryField(true);
        }

        public APIRequestGet requestContentCategoryField(boolean value) {
            this.requestField("content_category", value);
            return this;
        }

        public APIRequestGet requestCopyrightContentIdField() {
            return this.requestCopyrightContentIdField(true);
        }

        public APIRequestGet requestCopyrightContentIdField(boolean value) {
            this.requestField("copyright_content_id", value);
            return this;
        }

        public APIRequestGet requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGet requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInConflictField() {
            return this.requestInConflictField(true);
        }

        public APIRequestGet requestInConflictField(boolean value) {
            this.requestField("in_conflict", value);
            return this;
        }

        public APIRequestGet requestMonitoringStatusField() {
            return this.requestMonitoringStatusField(true);
        }

        public APIRequestGet requestMonitoringStatusField(boolean value) {
            this.requestField("monitoring_status", value);
            return this;
        }

        public APIRequestGet requestMonitoringTypeField() {
            return this.requestMonitoringTypeField(true);
        }

        public APIRequestGet requestMonitoringTypeField(boolean value) {
            this.requestField("monitoring_type", value);
            return this;
        }

        public APIRequestGet requestOwnershipCountriesField() {
            return this.requestOwnershipCountriesField(true);
        }

        public APIRequestGet requestOwnershipCountriesField(boolean value) {
            this.requestField("ownership_countries", value);
            return this;
        }

        public APIRequestGet requestReferenceFileField() {
            return this.requestReferenceFileField(true);
        }

        public APIRequestGet requestReferenceFileField(boolean value) {
            this.requestField("reference_file", value);
            return this;
        }

        public APIRequestGet requestReferenceFileDisabledField() {
            return this.requestReferenceFileDisabledField(true);
        }

        public APIRequestGet requestReferenceFileDisabledField(boolean value) {
            this.requestField("reference_file_disabled", value);
            return this;
        }

        public APIRequestGet requestReferenceFileDisabledByOpsField() {
            return this.requestReferenceFileDisabledByOpsField(true);
        }

        public APIRequestGet requestReferenceFileDisabledByOpsField(boolean value) {
            this.requestField("reference_file_disabled_by_ops", value);
            return this;
        }

        public APIRequestGet requestReferenceFileExpiredField() {
            return this.requestReferenceFileExpiredField(true);
        }

        public APIRequestGet requestReferenceFileExpiredField(boolean value) {
            this.requestField("reference_file_expired", value);
            return this;
        }

        public APIRequestGet requestReferenceOwnerIdField() {
            return this.requestReferenceOwnerIdField(true);
        }

        public APIRequestGet requestReferenceOwnerIdField(boolean value) {
            this.requestField("reference_owner_id", value);
            return this;
        }

        public APIRequestGet requestRuleIdsField() {
            return this.requestRuleIdsField(true);
        }

        public APIRequestGet requestRuleIdsField(boolean value) {
            this.requestField("rule_ids", value);
            return this;
        }

        public APIRequestGet requestWhitelistedIdsField() {
            return this.requestWhitelistedIdsField(true);
        }

        public APIRequestGet requestWhitelistedIdsField(boolean value) {
            this.requestField("whitelisted_ids", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

