/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomConversionStatsResult
extends APINode {
    @SerializedName(value="aggregation")
    private EnumAggregation mAggregation = null;
    @SerializedName(value="data")
    private List<Object> mData = null;
    @SerializedName(value="timestamp")
    private String mTimestamp = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CustomConversionStatsResult loadJSON(String json, APIContext context, String header) {
        CustomConversionStatsResult customConversionStatsResult = (CustomConversionStatsResult)CustomConversionStatsResult.getGson().fromJson(json, CustomConversionStatsResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(customConversionStatsResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        customConversionStatsResult.context = context;
        customConversionStatsResult.rawValue = json;
        customConversionStatsResult.header = header;
        return customConversionStatsResult;
    }

    public static APINodeList<CustomConversionStatsResult> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CustomConversionStatsResult> customConversionStatsResults = new APINodeList<CustomConversionStatsResult>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        customConversionStatsResults.add(CustomConversionStatsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return customConversionStatsResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            customConversionStatsResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        customConversionStatsResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            customConversionStatsResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            customConversionStatsResults.add(CustomConversionStatsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                customConversionStatsResults.add(CustomConversionStatsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            customConversionStatsResults.add(CustomConversionStatsResult.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return customConversionStatsResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        customConversionStatsResults.add(CustomConversionStatsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return customConversionStatsResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        customConversionStatsResults.add(CustomConversionStatsResult.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return customConversionStatsResults;
                }
                customConversionStatsResults.clear();
                customConversionStatsResults.add(CustomConversionStatsResult.loadJSON(json, context, header));
                return customConversionStatsResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CustomConversionStatsResult.getGson().toJson((Object)this);
    }

    public EnumAggregation getFieldAggregation() {
        return this.mAggregation;
    }

    public CustomConversionStatsResult setFieldAggregation(EnumAggregation value) {
        this.mAggregation = value;
        return this;
    }

    public List<Object> getFieldData() {
        return this.mData;
    }

    public CustomConversionStatsResult setFieldData(List<Object> value) {
        this.mData = value;
        return this;
    }

    public String getFieldTimestamp() {
        return this.mTimestamp;
    }

    public CustomConversionStatsResult setFieldTimestamp(String value) {
        this.mTimestamp = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public CustomConversionStatsResult setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CustomConversionStatsResult copyFrom(CustomConversionStatsResult instance) {
        this.mAggregation = instance.mAggregation;
        this.mData = instance.mData;
        this.mTimestamp = instance.mTimestamp;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CustomConversionStatsResult> getParser() {
        return new APIRequest.ResponseParser<CustomConversionStatsResult>(){

            @Override
            public APINodeList<CustomConversionStatsResult> parseResponse(String response, APIContext context, APIRequest<CustomConversionStatsResult> request, String header) throws APIException.MalformedResponseException {
                return CustomConversionStatsResult.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumAggregation {
        VALUE_COUNT("count"),
        VALUE_DEVICE_TYPE("device_type"),
        VALUE_HOST("host"),
        VALUE_PIXEL_FIRE("pixel_fire"),
        VALUE_UNMATCHED_COUNT("unmatched_count"),
        VALUE_UNMATCHED_USD_AMOUNT("unmatched_usd_amount"),
        VALUE_URL("url"),
        VALUE_USD_AMOUNT("usd_amount"),
        NULL(null);

        private String value;

        private EnumAggregation(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

