/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.OutcomePredictionPoint;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCampaignDeliveryEstimate
extends APINode {
    @SerializedName(value="daily_outcomes_curve")
    private List<OutcomePredictionPoint> mDailyOutcomesCurve = null;
    @SerializedName(value="estimate_dau")
    private Long mEstimateDau = null;
    @SerializedName(value="estimate_mau")
    private Long mEstimateMau = null;
    @SerializedName(value="estimate_ready")
    private Boolean mEstimateReady = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCampaignDeliveryEstimate loadJSON(String json, APIContext context, String header) {
        AdCampaignDeliveryEstimate adCampaignDeliveryEstimate = (AdCampaignDeliveryEstimate)AdCampaignDeliveryEstimate.getGson().fromJson(json, AdCampaignDeliveryEstimate.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCampaignDeliveryEstimate.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCampaignDeliveryEstimate.context = context;
        adCampaignDeliveryEstimate.rawValue = json;
        adCampaignDeliveryEstimate.header = header;
        return adCampaignDeliveryEstimate;
    }

    public static APINodeList<AdCampaignDeliveryEstimate> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCampaignDeliveryEstimate> adCampaignDeliveryEstimates = new APINodeList<AdCampaignDeliveryEstimate>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCampaignDeliveryEstimates.add(AdCampaignDeliveryEstimate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adCampaignDeliveryEstimates;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCampaignDeliveryEstimates.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCampaignDeliveryEstimates.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCampaignDeliveryEstimates.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCampaignDeliveryEstimates.add(AdCampaignDeliveryEstimate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCampaignDeliveryEstimates.add(AdCampaignDeliveryEstimate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCampaignDeliveryEstimates.add(AdCampaignDeliveryEstimate.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adCampaignDeliveryEstimates;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCampaignDeliveryEstimates.add(AdCampaignDeliveryEstimate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adCampaignDeliveryEstimates;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCampaignDeliveryEstimates.add(AdCampaignDeliveryEstimate.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCampaignDeliveryEstimates;
                }
                adCampaignDeliveryEstimates.clear();
                adCampaignDeliveryEstimates.add(AdCampaignDeliveryEstimate.loadJSON(json, context, header));
                return adCampaignDeliveryEstimates;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCampaignDeliveryEstimate.getGson().toJson((Object)this);
    }

    public List<OutcomePredictionPoint> getFieldDailyOutcomesCurve() {
        return this.mDailyOutcomesCurve;
    }

    public AdCampaignDeliveryEstimate setFieldDailyOutcomesCurve(List<OutcomePredictionPoint> value) {
        this.mDailyOutcomesCurve = value;
        return this;
    }

    public AdCampaignDeliveryEstimate setFieldDailyOutcomesCurve(String value) {
        Type type = new TypeToken<List<OutcomePredictionPoint>>(){}.getType();
        this.mDailyOutcomesCurve = (List)OutcomePredictionPoint.getGson().fromJson(value, type);
        return this;
    }

    public Long getFieldEstimateDau() {
        return this.mEstimateDau;
    }

    public AdCampaignDeliveryEstimate setFieldEstimateDau(Long value) {
        this.mEstimateDau = value;
        return this;
    }

    public Long getFieldEstimateMau() {
        return this.mEstimateMau;
    }

    public AdCampaignDeliveryEstimate setFieldEstimateMau(Long value) {
        this.mEstimateMau = value;
        return this;
    }

    public Boolean getFieldEstimateReady() {
        return this.mEstimateReady;
    }

    public AdCampaignDeliveryEstimate setFieldEstimateReady(Boolean value) {
        this.mEstimateReady = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdCampaignDeliveryEstimate setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCampaignDeliveryEstimate copyFrom(AdCampaignDeliveryEstimate instance) {
        this.mDailyOutcomesCurve = instance.mDailyOutcomesCurve;
        this.mEstimateDau = instance.mEstimateDau;
        this.mEstimateMau = instance.mEstimateMau;
        this.mEstimateReady = instance.mEstimateReady;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCampaignDeliveryEstimate> getParser() {
        return new APIRequest.ResponseParser<AdCampaignDeliveryEstimate>(){

            @Override
            public APINodeList<AdCampaignDeliveryEstimate> parseResponse(String response, APIContext context, APIRequest<AdCampaignDeliveryEstimate> request, String header) throws APIException.MalformedResponseException {
                return AdCampaignDeliveryEstimate.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOptimizationGoal {
        VALUE_AD_RECALL_LIFT("AD_RECALL_LIFT"),
        VALUE_APP_DOWNLOADS("APP_DOWNLOADS"),
        VALUE_APP_INSTALLS("APP_INSTALLS"),
        VALUE_BRAND_AWARENESS("BRAND_AWARENESS"),
        VALUE_CLICKS("CLICKS"),
        VALUE_DERIVED_EVENTS("DERIVED_EVENTS"),
        VALUE_ENGAGED_USERS("ENGAGED_USERS"),
        VALUE_EVENT_RESPONSES("EVENT_RESPONSES"),
        VALUE_IMPRESSIONS("IMPRESSIONS"),
        VALUE_LANDING_PAGE_VIEWS("LANDING_PAGE_VIEWS"),
        VALUE_LEAD_GENERATION("LEAD_GENERATION"),
        VALUE_LINK_CLICKS("LINK_CLICKS"),
        VALUE_NONE("NONE"),
        VALUE_OFFER_CLAIMS("OFFER_CLAIMS"),
        VALUE_OFFSITE_CONVERSIONS("OFFSITE_CONVERSIONS"),
        VALUE_PAGE_ENGAGEMENT("PAGE_ENGAGEMENT"),
        VALUE_PAGE_LIKES("PAGE_LIKES"),
        VALUE_POST_ENGAGEMENT("POST_ENGAGEMENT"),
        VALUE_REACH("REACH"),
        VALUE_REPLIES("REPLIES"),
        VALUE_SOCIAL_IMPRESSIONS("SOCIAL_IMPRESSIONS"),
        VALUE_THRUPLAY("THRUPLAY"),
        VALUE_TWO_SECOND_CONTINUOUS_VIDEO_VIEWS("TWO_SECOND_CONTINUOUS_VIDEO_VIEWS"),
        VALUE_VALUE("VALUE"),
        VALUE_VIDEO_VIEWS("VIDEO_VIEWS"),
        NULL(null);

        private String value;

        private EnumOptimizationGoal(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

