/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdTopline;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdToplineDetail
extends APINode {
    @SerializedName(value="active_status")
    private Long mActiveStatus = null;
    @SerializedName(value="ad_account_id")
    private String mAdAccountId = null;
    @SerializedName(value="flight_end_date")
    private String mFlightEndDate = null;
    @SerializedName(value="flight_start_date")
    private String mFlightStartDate = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="io_number")
    private Long mIoNumber = null;
    @SerializedName(value="line_number")
    private Long mLineNumber = null;
    @SerializedName(value="price")
    private Double mPrice = null;
    @SerializedName(value="quantity")
    private Double mQuantity = null;
    @SerializedName(value="sf_detail_line_id")
    private String mSfDetailLineId = null;
    @SerializedName(value="subline_id")
    private String mSublineId = null;
    @SerializedName(value="targets")
    private String mTargets = null;
    @SerializedName(value="time_created")
    private String mTimeCreated = null;
    @SerializedName(value="time_updated")
    private String mTimeUpdated = null;
    @SerializedName(value="topline_id")
    private AdTopline mToplineId = null;
    protected static Gson gson = null;

    AdToplineDetail() {
    }

    public AdToplineDetail(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdToplineDetail(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdToplineDetail fetch() throws APIException {
        AdToplineDetail newInstance = AdToplineDetail.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdToplineDetail fetchById(Long id, APIContext context) throws APIException {
        return AdToplineDetail.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdToplineDetail> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdToplineDetail.fetchByIdAsync(id.toString(), context);
    }

    public static AdToplineDetail fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdToplineDetail> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdToplineDetail> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdToplineDetail>(context, "", "/", "GET", AdToplineDetail.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdToplineDetail>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdToplineDetail>(context, "", "/", "GET", AdToplineDetail.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdToplineDetail loadJSON(String json, APIContext context, String header) {
        AdToplineDetail adToplineDetail = (AdToplineDetail)AdToplineDetail.getGson().fromJson(json, AdToplineDetail.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adToplineDetail.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adToplineDetail.context = context;
        adToplineDetail.rawValue = json;
        adToplineDetail.header = header;
        return adToplineDetail;
    }

    public static APINodeList<AdToplineDetail> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdToplineDetail> adToplineDetails = new APINodeList<AdToplineDetail>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adToplineDetails.add(AdToplineDetail.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adToplineDetails;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adToplineDetails.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adToplineDetails.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adToplineDetails.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adToplineDetails.add(AdToplineDetail.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adToplineDetails.add(AdToplineDetail.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adToplineDetails.add(AdToplineDetail.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adToplineDetails;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adToplineDetails.add(AdToplineDetail.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adToplineDetails;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adToplineDetails.add(AdToplineDetail.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adToplineDetails;
                }
                adToplineDetails.clear();
                adToplineDetails.add(AdToplineDetail.loadJSON(json, context, header));
                return adToplineDetails;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdToplineDetail.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldActiveStatus() {
        return this.mActiveStatus;
    }

    public String getFieldAdAccountId() {
        return this.mAdAccountId;
    }

    public String getFieldFlightEndDate() {
        return this.mFlightEndDate;
    }

    public String getFieldFlightStartDate() {
        return this.mFlightStartDate;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Long getFieldIoNumber() {
        return this.mIoNumber;
    }

    public Long getFieldLineNumber() {
        return this.mLineNumber;
    }

    public Double getFieldPrice() {
        return this.mPrice;
    }

    public Double getFieldQuantity() {
        return this.mQuantity;
    }

    public String getFieldSfDetailLineId() {
        return this.mSfDetailLineId;
    }

    public String getFieldSublineId() {
        return this.mSublineId;
    }

    public String getFieldTargets() {
        return this.mTargets;
    }

    public String getFieldTimeCreated() {
        return this.mTimeCreated;
    }

    public String getFieldTimeUpdated() {
        return this.mTimeUpdated;
    }

    public AdTopline getFieldToplineId() {
        if (this.mToplineId != null) {
            this.mToplineId.context = this.getContext();
        }
        return this.mToplineId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdToplineDetail copyFrom(AdToplineDetail instance) {
        this.mActiveStatus = instance.mActiveStatus;
        this.mAdAccountId = instance.mAdAccountId;
        this.mFlightEndDate = instance.mFlightEndDate;
        this.mFlightStartDate = instance.mFlightStartDate;
        this.mId = instance.mId;
        this.mIoNumber = instance.mIoNumber;
        this.mLineNumber = instance.mLineNumber;
        this.mPrice = instance.mPrice;
        this.mQuantity = instance.mQuantity;
        this.mSfDetailLineId = instance.mSfDetailLineId;
        this.mSublineId = instance.mSublineId;
        this.mTargets = instance.mTargets;
        this.mTimeCreated = instance.mTimeCreated;
        this.mTimeUpdated = instance.mTimeUpdated;
        this.mToplineId = instance.mToplineId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdToplineDetail> getParser() {
        return new APIRequest.ResponseParser<AdToplineDetail>(){

            @Override
            public APINodeList<AdToplineDetail> parseResponse(String response, APIContext context, APIRequest<AdToplineDetail> request, String header) throws APIException.MalformedResponseException {
                return AdToplineDetail.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdToplineDetail> {
        AdToplineDetail lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"active_status", "ad_account_id", "flight_end_date", "flight_start_date", "id", "io_number", "line_number", "price", "quantity", "sf_detail_line_id", "subline_id", "targets", "time_created", "time_updated", "topline_id"};

        @Override
        public AdToplineDetail getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdToplineDetail parseResponse(String response, String header) throws APIException {
            return AdToplineDetail.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdToplineDetail execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdToplineDetail execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdToplineDetail> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdToplineDetail> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdToplineDetail>(){

                public AdToplineDetail apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestActiveStatusField() {
            return this.requestActiveStatusField(true);
        }

        public APIRequestGet requestActiveStatusField(boolean value) {
            this.requestField("active_status", value);
            return this;
        }

        public APIRequestGet requestAdAccountIdField() {
            return this.requestAdAccountIdField(true);
        }

        public APIRequestGet requestAdAccountIdField(boolean value) {
            this.requestField("ad_account_id", value);
            return this;
        }

        public APIRequestGet requestFlightEndDateField() {
            return this.requestFlightEndDateField(true);
        }

        public APIRequestGet requestFlightEndDateField(boolean value) {
            this.requestField("flight_end_date", value);
            return this;
        }

        public APIRequestGet requestFlightStartDateField() {
            return this.requestFlightStartDateField(true);
        }

        public APIRequestGet requestFlightStartDateField(boolean value) {
            this.requestField("flight_start_date", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGet requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGet requestLineNumberField() {
            return this.requestLineNumberField(true);
        }

        public APIRequestGet requestLineNumberField(boolean value) {
            this.requestField("line_number", value);
            return this;
        }

        public APIRequestGet requestPriceField() {
            return this.requestPriceField(true);
        }

        public APIRequestGet requestPriceField(boolean value) {
            this.requestField("price", value);
            return this;
        }

        public APIRequestGet requestQuantityField() {
            return this.requestQuantityField(true);
        }

        public APIRequestGet requestQuantityField(boolean value) {
            this.requestField("quantity", value);
            return this;
        }

        public APIRequestGet requestSfDetailLineIdField() {
            return this.requestSfDetailLineIdField(true);
        }

        public APIRequestGet requestSfDetailLineIdField(boolean value) {
            this.requestField("sf_detail_line_id", value);
            return this;
        }

        public APIRequestGet requestSublineIdField() {
            return this.requestSublineIdField(true);
        }

        public APIRequestGet requestSublineIdField(boolean value) {
            this.requestField("subline_id", value);
            return this;
        }

        public APIRequestGet requestTargetsField() {
            return this.requestTargetsField(true);
        }

        public APIRequestGet requestTargetsField(boolean value) {
            this.requestField("targets", value);
            return this;
        }

        public APIRequestGet requestTimeCreatedField() {
            return this.requestTimeCreatedField(true);
        }

        public APIRequestGet requestTimeCreatedField(boolean value) {
            this.requestField("time_created", value);
            return this;
        }

        public APIRequestGet requestTimeUpdatedField() {
            return this.requestTimeUpdatedField(true);
        }

        public APIRequestGet requestTimeUpdatedField(boolean value) {
            this.requestField("time_updated", value);
            return this;
        }

        public APIRequestGet requestToplineIdField() {
            return this.requestToplineIdField(true);
        }

        public APIRequestGet requestToplineIdField(boolean value) {
            this.requestField("topline_id", value);
            return this;
        }
    }
}

