/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavoriteRequest
extends APINode {
    @SerializedName(value="api_version")
    private String mApiVersion = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="graph_path")
    private String mGraphPath = null;
    @SerializedName(value="hash")
    private String mHash = null;
    @SerializedName(value="http_method")
    private EnumHttpMethod mHttpMethod = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="post_params")
    private List<Object> mPostParams = null;
    @SerializedName(value="query_params")
    private List<Object> mQueryParams = null;
    protected static Gson gson = null;

    FavoriteRequest() {
    }

    public FavoriteRequest(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public FavoriteRequest(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public FavoriteRequest fetch() throws APIException {
        FavoriteRequest newInstance = FavoriteRequest.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static FavoriteRequest fetchById(Long id, APIContext context) throws APIException {
        return FavoriteRequest.fetchById(id.toString(), context);
    }

    public static ListenableFuture<FavoriteRequest> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return FavoriteRequest.fetchByIdAsync(id.toString(), context);
    }

    public static FavoriteRequest fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<FavoriteRequest> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<FavoriteRequest> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<FavoriteRequest>(context, "", "/", "GET", FavoriteRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<FavoriteRequest>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<FavoriteRequest>(context, "", "/", "GET", FavoriteRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static FavoriteRequest loadJSON(String json, APIContext context, String header) {
        FavoriteRequest favoriteRequest = (FavoriteRequest)FavoriteRequest.getGson().fromJson(json, FavoriteRequest.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(favoriteRequest.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        favoriteRequest.context = context;
        favoriteRequest.rawValue = json;
        favoriteRequest.header = header;
        return favoriteRequest;
    }

    public static APINodeList<FavoriteRequest> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<FavoriteRequest> favoriteRequests = new APINodeList<FavoriteRequest>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        favoriteRequests.add(FavoriteRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return favoriteRequests;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            favoriteRequests.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        favoriteRequests.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            favoriteRequests.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            favoriteRequests.add(FavoriteRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                favoriteRequests.add(FavoriteRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            favoriteRequests.add(FavoriteRequest.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return favoriteRequests;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        favoriteRequests.add(FavoriteRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return favoriteRequests;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        favoriteRequests.add(FavoriteRequest.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return favoriteRequests;
                }
                favoriteRequests.clear();
                favoriteRequests.add(FavoriteRequest.loadJSON(json, context, header));
                return favoriteRequests;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return FavoriteRequest.getGson().toJson((Object)this);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldApiVersion() {
        return this.mApiVersion;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldGraphPath() {
        return this.mGraphPath;
    }

    public String getFieldHash() {
        return this.mHash;
    }

    public EnumHttpMethod getFieldHttpMethod() {
        return this.mHttpMethod;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<Object> getFieldPostParams() {
        return this.mPostParams;
    }

    public List<Object> getFieldQueryParams() {
        return this.mQueryParams;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public FavoriteRequest copyFrom(FavoriteRequest instance) {
        this.mApiVersion = instance.mApiVersion;
        this.mDescription = instance.mDescription;
        this.mGraphPath = instance.mGraphPath;
        this.mHash = instance.mHash;
        this.mHttpMethod = instance.mHttpMethod;
        this.mId = instance.mId;
        this.mPostParams = instance.mPostParams;
        this.mQueryParams = instance.mQueryParams;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<FavoriteRequest> getParser() {
        return new APIRequest.ResponseParser<FavoriteRequest>(){

            @Override
            public APINodeList<FavoriteRequest> parseResponse(String response, APIContext context, APIRequest<FavoriteRequest> request, String header) throws APIException.MalformedResponseException {
                return FavoriteRequest.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumApiVersion {
        VALUE_UNVERSIONED("unversioned"),
        VALUE_V1_0("v1.0"),
        VALUE_V2_0("v2.0"),
        VALUE_V2_1("v2.1"),
        VALUE_V2_2("v2.2"),
        VALUE_V2_3("v2.3"),
        VALUE_V2_4("v2.4"),
        VALUE_V2_5("v2.5"),
        VALUE_V2_6("v2.6"),
        VALUE_V2_7("v2.7"),
        VALUE_V2_8("v2.8"),
        VALUE_V2_9("v2.9"),
        VALUE_V2_10("v2.10"),
        VALUE_V2_11("v2.11"),
        VALUE_V2_12("v2.12"),
        VALUE_V3_0("v3.0"),
        VALUE_V3_1("v3.1"),
        VALUE_V3_2("v3.2"),
        VALUE_V4_0("v4.0"),
        NULL(null);

        private String value;

        private EnumApiVersion(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumHttpMethod {
        VALUE_GET("GET"),
        VALUE_POST("POST"),
        VALUE_DELETE("DELETE"),
        NULL(null);

        private String value;

        private EnumHttpMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<FavoriteRequest> {
        FavoriteRequest lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"api_version", "description", "graph_path", "hash", "http_method", "id", "post_params", "query_params"};

        @Override
        public FavoriteRequest getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public FavoriteRequest parseResponse(String response, String header) throws APIException {
            return FavoriteRequest.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public FavoriteRequest execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public FavoriteRequest execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<FavoriteRequest> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<FavoriteRequest> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, FavoriteRequest>(){

                public FavoriteRequest apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestApiVersionField() {
            return this.requestApiVersionField(true);
        }

        public APIRequestGet requestApiVersionField(boolean value) {
            this.requestField("api_version", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestGraphPathField() {
            return this.requestGraphPathField(true);
        }

        public APIRequestGet requestGraphPathField(boolean value) {
            this.requestField("graph_path", value);
            return this;
        }

        public APIRequestGet requestHashField() {
            return this.requestHashField(true);
        }

        public APIRequestGet requestHashField(boolean value) {
            this.requestField("hash", value);
            return this;
        }

        public APIRequestGet requestHttpMethodField() {
            return this.requestHttpMethodField(true);
        }

        public APIRequestGet requestHttpMethodField(boolean value) {
            this.requestField("http_method", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestPostParamsField() {
            return this.requestPostParamsField(true);
        }

        public APIRequestGet requestPostParamsField(boolean value) {
            this.requestField("post_params", value);
            return this;
        }

        public APIRequestGet requestQueryParamsField() {
            return this.requestQueryParamsField(true);
        }

        public APIRequestGet requestQueryParamsField(boolean value) {
            this.requestField("query_params", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

