/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAssetFeedSpecAssetLabel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAssetFeedSpecLinkURL
extends APINode {
    @SerializedName(value="adlabels")
    private List<AdAssetFeedSpecAssetLabel> mAdlabels = null;
    @SerializedName(value="carousel_see_more_url")
    private String mCarouselSeeMoreUrl = null;
    @SerializedName(value="deeplink_url")
    private String mDeeplinkUrl = null;
    @SerializedName(value="display_url")
    private String mDisplayUrl = null;
    @SerializedName(value="url_tags")
    private String mUrlTags = null;
    @SerializedName(value="website_url")
    private String mWebsiteUrl = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAssetFeedSpecLinkURL loadJSON(String json, APIContext context, String header) {
        AdAssetFeedSpecLinkURL adAssetFeedSpecLinkURL = (AdAssetFeedSpecLinkURL)AdAssetFeedSpecLinkURL.getGson().fromJson(json, AdAssetFeedSpecLinkURL.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAssetFeedSpecLinkURL.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAssetFeedSpecLinkURL.context = context;
        adAssetFeedSpecLinkURL.rawValue = json;
        adAssetFeedSpecLinkURL.header = header;
        return adAssetFeedSpecLinkURL;
    }

    public static APINodeList<AdAssetFeedSpecLinkURL> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAssetFeedSpecLinkURL> adAssetFeedSpecLinkURLs = new APINodeList<AdAssetFeedSpecLinkURL>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAssetFeedSpecLinkURLs.add(AdAssetFeedSpecLinkURL.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adAssetFeedSpecLinkURLs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAssetFeedSpecLinkURLs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAssetFeedSpecLinkURLs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAssetFeedSpecLinkURLs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAssetFeedSpecLinkURLs.add(AdAssetFeedSpecLinkURL.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAssetFeedSpecLinkURLs.add(AdAssetFeedSpecLinkURL.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAssetFeedSpecLinkURLs.add(AdAssetFeedSpecLinkURL.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adAssetFeedSpecLinkURLs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAssetFeedSpecLinkURLs.add(AdAssetFeedSpecLinkURL.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adAssetFeedSpecLinkURLs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAssetFeedSpecLinkURLs.add(AdAssetFeedSpecLinkURL.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAssetFeedSpecLinkURLs;
                }
                adAssetFeedSpecLinkURLs.clear();
                adAssetFeedSpecLinkURLs.add(AdAssetFeedSpecLinkURL.loadJSON(json, context, header));
                return adAssetFeedSpecLinkURLs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAssetFeedSpecLinkURL.getGson().toJson((Object)this);
    }

    public List<AdAssetFeedSpecAssetLabel> getFieldAdlabels() {
        return this.mAdlabels;
    }

    public AdAssetFeedSpecLinkURL setFieldAdlabels(List<AdAssetFeedSpecAssetLabel> value) {
        this.mAdlabels = value;
        return this;
    }

    public AdAssetFeedSpecLinkURL setFieldAdlabels(String value) {
        Type type = new TypeToken<List<AdAssetFeedSpecAssetLabel>>(){}.getType();
        this.mAdlabels = (List)AdAssetFeedSpecAssetLabel.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldCarouselSeeMoreUrl() {
        return this.mCarouselSeeMoreUrl;
    }

    public AdAssetFeedSpecLinkURL setFieldCarouselSeeMoreUrl(String value) {
        this.mCarouselSeeMoreUrl = value;
        return this;
    }

    public String getFieldDeeplinkUrl() {
        return this.mDeeplinkUrl;
    }

    public AdAssetFeedSpecLinkURL setFieldDeeplinkUrl(String value) {
        this.mDeeplinkUrl = value;
        return this;
    }

    public String getFieldDisplayUrl() {
        return this.mDisplayUrl;
    }

    public AdAssetFeedSpecLinkURL setFieldDisplayUrl(String value) {
        this.mDisplayUrl = value;
        return this;
    }

    public String getFieldUrlTags() {
        return this.mUrlTags;
    }

    public AdAssetFeedSpecLinkURL setFieldUrlTags(String value) {
        this.mUrlTags = value;
        return this;
    }

    public String getFieldWebsiteUrl() {
        return this.mWebsiteUrl;
    }

    public AdAssetFeedSpecLinkURL setFieldWebsiteUrl(String value) {
        this.mWebsiteUrl = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdAssetFeedSpecLinkURL setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAssetFeedSpecLinkURL copyFrom(AdAssetFeedSpecLinkURL instance) {
        this.mAdlabels = instance.mAdlabels;
        this.mCarouselSeeMoreUrl = instance.mCarouselSeeMoreUrl;
        this.mDeeplinkUrl = instance.mDeeplinkUrl;
        this.mDisplayUrl = instance.mDisplayUrl;
        this.mUrlTags = instance.mUrlTags;
        this.mWebsiteUrl = instance.mWebsiteUrl;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAssetFeedSpecLinkURL> getParser() {
        return new APIRequest.ResponseParser<AdAssetFeedSpecLinkURL>(){

            @Override
            public APINodeList<AdAssetFeedSpecLinkURL> parseResponse(String response, APIContext context, APIRequest<AdAssetFeedSpecLinkURL> request, String header) throws APIException.MalformedResponseException {
                return AdAssetFeedSpecLinkURL.parseResponse(response, context, request, header);
            }
        };
    }
}

