/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveWithGuestSession
extends APINode {
    @SerializedName(value="conference_name")
    private String mConferenceName = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="participant_call_states")
    private List<Object> mParticipantCallStates = null;
    @SerializedName(value="server_sdp")
    private String mServerSdp = null;
    protected static Gson gson = null;

    LiveWithGuestSession() {
    }

    public LiveWithGuestSession(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public LiveWithGuestSession(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public LiveWithGuestSession fetch() throws APIException {
        LiveWithGuestSession newInstance = LiveWithGuestSession.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static LiveWithGuestSession fetchById(Long id, APIContext context) throws APIException {
        return LiveWithGuestSession.fetchById(id.toString(), context);
    }

    public static ListenableFuture<LiveWithGuestSession> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return LiveWithGuestSession.fetchByIdAsync(id.toString(), context);
    }

    public static LiveWithGuestSession fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<LiveWithGuestSession> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<LiveWithGuestSession> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<LiveWithGuestSession>(context, "", "/", "GET", LiveWithGuestSession.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<LiveWithGuestSession>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<LiveWithGuestSession>(context, "", "/", "GET", LiveWithGuestSession.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static LiveWithGuestSession loadJSON(String json, APIContext context, String header) {
        LiveWithGuestSession liveWithGuestSession = (LiveWithGuestSession)LiveWithGuestSession.getGson().fromJson(json, LiveWithGuestSession.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(liveWithGuestSession.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        liveWithGuestSession.context = context;
        liveWithGuestSession.rawValue = json;
        liveWithGuestSession.header = header;
        return liveWithGuestSession;
    }

    public static APINodeList<LiveWithGuestSession> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LiveWithGuestSession> liveWithGuestSessions = new APINodeList<LiveWithGuestSession>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        liveWithGuestSessions.add(LiveWithGuestSession.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return liveWithGuestSessions;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            liveWithGuestSessions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        liveWithGuestSessions.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            liveWithGuestSessions.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            liveWithGuestSessions.add(LiveWithGuestSession.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                liveWithGuestSessions.add(LiveWithGuestSession.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            liveWithGuestSessions.add(LiveWithGuestSession.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return liveWithGuestSessions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        liveWithGuestSessions.add(LiveWithGuestSession.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return liveWithGuestSessions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        liveWithGuestSessions.add(LiveWithGuestSession.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return liveWithGuestSessions;
                }
                liveWithGuestSessions.clear();
                liveWithGuestSessions.add(LiveWithGuestSession.loadJSON(json, context, header));
                return liveWithGuestSessions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LiveWithGuestSession.getGson().toJson((Object)this);
    }

    public APIRequestCreateHangup createHangup() {
        return new APIRequestCreateHangup(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateJoin createJoin() {
        return new APIRequestCreateJoin(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateRingUser createRingUser() {
        return new APIRequestCreateRingUser(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldConferenceName() {
        return this.mConferenceName;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<Object> getFieldParticipantCallStates() {
        return this.mParticipantCallStates;
    }

    public String getFieldServerSdp() {
        return this.mServerSdp;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LiveWithGuestSession copyFrom(LiveWithGuestSession instance) {
        this.mConferenceName = instance.mConferenceName;
        this.mId = instance.mId;
        this.mParticipantCallStates = instance.mParticipantCallStates;
        this.mServerSdp = instance.mServerSdp;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LiveWithGuestSession> getParser() {
        return new APIRequest.ResponseParser<LiveWithGuestSession>(){

            @Override
            public APINodeList<LiveWithGuestSession> parseResponse(String response, APIContext context, APIRequest<LiveWithGuestSession> request, String header) throws APIException.MalformedResponseException {
                return LiveWithGuestSession.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<LiveWithGuestSession> {
        LiveWithGuestSession lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"conference_name", "id", "participant_call_states", "server_sdp"};

        @Override
        public LiveWithGuestSession getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LiveWithGuestSession parseResponse(String response, String header) throws APIException {
            return LiveWithGuestSession.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public LiveWithGuestSession execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LiveWithGuestSession execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<LiveWithGuestSession> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LiveWithGuestSession> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, LiveWithGuestSession>(){

                public LiveWithGuestSession apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestConferenceNameField() {
            return this.requestConferenceNameField(true);
        }

        public APIRequestGet requestConferenceNameField(boolean value) {
            this.requestField("conference_name", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestParticipantCallStatesField() {
            return this.requestParticipantCallStatesField(true);
        }

        public APIRequestGet requestParticipantCallStatesField(boolean value) {
            this.requestField("participant_call_states", value);
            return this;
        }

        public APIRequestGet requestServerSdpField() {
            return this.requestServerSdpField(true);
        }

        public APIRequestGet requestServerSdpField(boolean value) {
            this.requestField("server_sdp", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateRingUser
    extends APIRequest<LiveWithGuestSession> {
        LiveWithGuestSession lastResponse = null;
        public static final String[] PARAMS = new String[]{"user_ids"};
        public static final String[] FIELDS = new String[0];

        @Override
        public LiveWithGuestSession getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LiveWithGuestSession parseResponse(String response, String header) throws APIException {
            return LiveWithGuestSession.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public LiveWithGuestSession execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LiveWithGuestSession execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<LiveWithGuestSession> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LiveWithGuestSession> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, LiveWithGuestSession>(){

                public LiveWithGuestSession apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateRingUser.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateRingUser(String nodeId, APIContext context) {
            super(context, nodeId, "/ring_users", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateRingUser setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateRingUser setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateRingUser setUserIds(List<Long> userIds) {
            this.setParam("user_ids", userIds);
            return this;
        }

        public APIRequestCreateRingUser setUserIds(String userIds) {
            this.setParam("user_ids", userIds);
            return this;
        }

        public APIRequestCreateRingUser requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateRingUser requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateRingUser requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateRingUser requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateRingUser requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateRingUser requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateJoin
    extends APIRequest<LiveWithGuestSession> {
        LiveWithGuestSession lastResponse = null;
        public static final String[] PARAMS = new String[]{"offer_sdp"};
        public static final String[] FIELDS = new String[0];

        @Override
        public LiveWithGuestSession getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LiveWithGuestSession parseResponse(String response, String header) throws APIException {
            return LiveWithGuestSession.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public LiveWithGuestSession execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LiveWithGuestSession execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<LiveWithGuestSession> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LiveWithGuestSession> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, LiveWithGuestSession>(){

                public LiveWithGuestSession apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateJoin.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateJoin(String nodeId, APIContext context) {
            super(context, nodeId, "/join", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateJoin setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateJoin setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateJoin setOfferSdp(String offerSdp) {
            this.setParam("offer_sdp", offerSdp);
            return this;
        }

        public APIRequestCreateJoin requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateJoin requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateJoin requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateJoin requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateJoin requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateJoin requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateHangup
    extends APIRequest<LiveWithGuestSession> {
        LiveWithGuestSession lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public LiveWithGuestSession getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LiveWithGuestSession parseResponse(String response, String header) throws APIException {
            return LiveWithGuestSession.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public LiveWithGuestSession execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LiveWithGuestSession execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<LiveWithGuestSession> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LiveWithGuestSession> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, LiveWithGuestSession>(){

                public LiveWithGuestSession apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateHangup.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateHangup(String nodeId, APIContext context) {
            super(context, nodeId, "/hangup", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateHangup setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateHangup setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateHangup requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateHangup requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateHangup requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateHangup requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateHangup requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateHangup requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

