/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Experience;
import com.facebook.ads.sdk.Page;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EducationExperience
extends APINode {
    @SerializedName(value="classes")
    private List<Experience> mClasses = null;
    @SerializedName(value="concentration")
    private List<Page> mConcentration = null;
    @SerializedName(value="degree")
    private Page mDegree = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="school")
    private Page mSchool = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="with")
    private List<User> mWith = null;
    @SerializedName(value="year")
    private Page mYear = null;
    protected static Gson gson = null;

    EducationExperience() {
    }

    public EducationExperience(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public EducationExperience(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public EducationExperience fetch() throws APIException {
        EducationExperience newInstance = EducationExperience.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static EducationExperience fetchById(Long id, APIContext context) throws APIException {
        return EducationExperience.fetchById(id.toString(), context);
    }

    public static ListenableFuture<EducationExperience> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return EducationExperience.fetchByIdAsync(id.toString(), context);
    }

    public static EducationExperience fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<EducationExperience> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<EducationExperience> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<EducationExperience>(context, "", "/", "GET", EducationExperience.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<EducationExperience>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<EducationExperience>(context, "", "/", "GET", EducationExperience.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static EducationExperience loadJSON(String json, APIContext context, String header) {
        EducationExperience educationExperience = (EducationExperience)EducationExperience.getGson().fromJson(json, EducationExperience.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(educationExperience.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        educationExperience.context = context;
        educationExperience.rawValue = json;
        educationExperience.header = header;
        return educationExperience;
    }

    public static APINodeList<EducationExperience> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<EducationExperience> educationExperiences = new APINodeList<EducationExperience>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        educationExperiences.add(EducationExperience.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return educationExperiences;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            educationExperiences.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        educationExperiences.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            educationExperiences.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            educationExperiences.add(EducationExperience.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                educationExperiences.add(EducationExperience.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            educationExperiences.add(EducationExperience.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return educationExperiences;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        educationExperiences.add(EducationExperience.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return educationExperiences;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        educationExperiences.add(EducationExperience.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return educationExperiences;
                }
                educationExperiences.clear();
                educationExperiences.add(EducationExperience.loadJSON(json, context, header));
                return educationExperiences;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return EducationExperience.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<Experience> getFieldClasses() {
        return this.mClasses;
    }

    public List<Page> getFieldConcentration() {
        return this.mConcentration;
    }

    public Page getFieldDegree() {
        if (this.mDegree != null) {
            this.mDegree.context = this.getContext();
        }
        return this.mDegree;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Page getFieldSchool() {
        if (this.mSchool != null) {
            this.mSchool.context = this.getContext();
        }
        return this.mSchool;
    }

    public String getFieldType() {
        return this.mType;
    }

    public List<User> getFieldWith() {
        return this.mWith;
    }

    public Page getFieldYear() {
        if (this.mYear != null) {
            this.mYear.context = this.getContext();
        }
        return this.mYear;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public EducationExperience copyFrom(EducationExperience instance) {
        this.mClasses = instance.mClasses;
        this.mConcentration = instance.mConcentration;
        this.mDegree = instance.mDegree;
        this.mId = instance.mId;
        this.mSchool = instance.mSchool;
        this.mType = instance.mType;
        this.mWith = instance.mWith;
        this.mYear = instance.mYear;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<EducationExperience> getParser() {
        return new APIRequest.ResponseParser<EducationExperience>(){

            @Override
            public APINodeList<EducationExperience> parseResponse(String response, APIContext context, APIRequest<EducationExperience> request, String header) throws APIException.MalformedResponseException {
                return EducationExperience.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<EducationExperience> {
        EducationExperience lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"classes", "concentration", "degree", "id", "school", "type", "with", "year"};

        @Override
        public EducationExperience getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public EducationExperience parseResponse(String response, String header) throws APIException {
            return EducationExperience.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public EducationExperience execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public EducationExperience execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<EducationExperience> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<EducationExperience> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, EducationExperience>(){

                public EducationExperience apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestClassesField() {
            return this.requestClassesField(true);
        }

        public APIRequestGet requestClassesField(boolean value) {
            this.requestField("classes", value);
            return this;
        }

        public APIRequestGet requestConcentrationField() {
            return this.requestConcentrationField(true);
        }

        public APIRequestGet requestConcentrationField(boolean value) {
            this.requestField("concentration", value);
            return this;
        }

        public APIRequestGet requestDegreeField() {
            return this.requestDegreeField(true);
        }

        public APIRequestGet requestDegreeField(boolean value) {
            this.requestField("degree", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestSchoolField() {
            return this.requestSchoolField(true);
        }

        public APIRequestGet requestSchoolField(boolean value) {
            this.requestField("school", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGet requestWithField() {
            return this.requestWithField(true);
        }

        public APIRequestGet requestWithField(boolean value) {
            this.requestField("with", value);
            return this;
        }

        public APIRequestGet requestYearField() {
            return this.requestYearField(true);
        }

        public APIRequestGet requestYearField(boolean value) {
            this.requestField("year", value);
            return this;
        }
    }
}

