/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalEventSourceDebugging
extends APINode {
    @SerializedName(value="app_version")
    private String mAppVersion = null;
    @SerializedName(value="content_url")
    private String mContentUrl = null;
    @SerializedName(value="device_os")
    private String mDeviceOs = null;
    @SerializedName(value="diagnostic")
    private String mDiagnostic = null;
    @SerializedName(value="event_name")
    private String mEventName = null;
    @SerializedName(value="event_time")
    private Long mEventTime = null;
    @SerializedName(value="missing_ids")
    private String mMissingIds = null;
    @SerializedName(value="severity")
    private String mSeverity = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ExternalEventSourceDebugging loadJSON(String json, APIContext context, String header) {
        ExternalEventSourceDebugging externalEventSourceDebugging = (ExternalEventSourceDebugging)ExternalEventSourceDebugging.getGson().fromJson(json, ExternalEventSourceDebugging.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(externalEventSourceDebugging.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        externalEventSourceDebugging.context = context;
        externalEventSourceDebugging.rawValue = json;
        externalEventSourceDebugging.header = header;
        return externalEventSourceDebugging;
    }

    public static APINodeList<ExternalEventSourceDebugging> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ExternalEventSourceDebugging> externalEventSourceDebuggings = new APINodeList<ExternalEventSourceDebugging>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        externalEventSourceDebuggings.add(ExternalEventSourceDebugging.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return externalEventSourceDebuggings;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            externalEventSourceDebuggings.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        externalEventSourceDebuggings.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            externalEventSourceDebuggings.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            externalEventSourceDebuggings.add(ExternalEventSourceDebugging.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                externalEventSourceDebuggings.add(ExternalEventSourceDebugging.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            externalEventSourceDebuggings.add(ExternalEventSourceDebugging.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return externalEventSourceDebuggings;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        externalEventSourceDebuggings.add(ExternalEventSourceDebugging.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return externalEventSourceDebuggings;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        externalEventSourceDebuggings.add(ExternalEventSourceDebugging.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return externalEventSourceDebuggings;
                }
                externalEventSourceDebuggings.clear();
                externalEventSourceDebuggings.add(ExternalEventSourceDebugging.loadJSON(json, context, header));
                return externalEventSourceDebuggings;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ExternalEventSourceDebugging.getGson().toJson((Object)this);
    }

    public String getFieldAppVersion() {
        return this.mAppVersion;
    }

    public ExternalEventSourceDebugging setFieldAppVersion(String value) {
        this.mAppVersion = value;
        return this;
    }

    public String getFieldContentUrl() {
        return this.mContentUrl;
    }

    public ExternalEventSourceDebugging setFieldContentUrl(String value) {
        this.mContentUrl = value;
        return this;
    }

    public String getFieldDeviceOs() {
        return this.mDeviceOs;
    }

    public ExternalEventSourceDebugging setFieldDeviceOs(String value) {
        this.mDeviceOs = value;
        return this;
    }

    public String getFieldDiagnostic() {
        return this.mDiagnostic;
    }

    public ExternalEventSourceDebugging setFieldDiagnostic(String value) {
        this.mDiagnostic = value;
        return this;
    }

    public String getFieldEventName() {
        return this.mEventName;
    }

    public ExternalEventSourceDebugging setFieldEventName(String value) {
        this.mEventName = value;
        return this;
    }

    public Long getFieldEventTime() {
        return this.mEventTime;
    }

    public ExternalEventSourceDebugging setFieldEventTime(Long value) {
        this.mEventTime = value;
        return this;
    }

    public String getFieldMissingIds() {
        return this.mMissingIds;
    }

    public ExternalEventSourceDebugging setFieldMissingIds(String value) {
        this.mMissingIds = value;
        return this;
    }

    public String getFieldSeverity() {
        return this.mSeverity;
    }

    public ExternalEventSourceDebugging setFieldSeverity(String value) {
        this.mSeverity = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public ExternalEventSourceDebugging setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ExternalEventSourceDebugging copyFrom(ExternalEventSourceDebugging instance) {
        this.mAppVersion = instance.mAppVersion;
        this.mContentUrl = instance.mContentUrl;
        this.mDeviceOs = instance.mDeviceOs;
        this.mDiagnostic = instance.mDiagnostic;
        this.mEventName = instance.mEventName;
        this.mEventTime = instance.mEventTime;
        this.mMissingIds = instance.mMissingIds;
        this.mSeverity = instance.mSeverity;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ExternalEventSourceDebugging> getParser() {
        return new APIRequest.ResponseParser<ExternalEventSourceDebugging>(){

            @Override
            public APINodeList<ExternalEventSourceDebugging> parseResponse(String response, APIContext context, APIRequest<ExternalEventSourceDebugging> request, String header) throws APIException.MalformedResponseException {
                return ExternalEventSourceDebugging.parseResponse(response, context, request, header);
            }
        };
    }
}

