/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalibratorExistingRule
extends APINode {
    @SerializedName(value="7d_volume")
    private Long m7dVolume = null;
    @SerializedName(value="creation_source")
    private String mCreationSource = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="creator")
    private String mCreator = null;
    @SerializedName(value="event_type")
    private String mEventType = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="rule")
    private String mRule = null;
    @SerializedName(value="rule_type")
    private String mRuleType = null;
    @SerializedName(value="sample_urls")
    private List<String> mSampleUrls = null;
    @SerializedName(value="status")
    private String mStatus = null;
    protected static Gson gson = null;

    CalibratorExistingRule() {
    }

    public CalibratorExistingRule(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CalibratorExistingRule(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CalibratorExistingRule fetch() throws APIException {
        CalibratorExistingRule newInstance = CalibratorExistingRule.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CalibratorExistingRule fetchById(Long id, APIContext context) throws APIException {
        return CalibratorExistingRule.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CalibratorExistingRule> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CalibratorExistingRule.fetchByIdAsync(id.toString(), context);
    }

    public static CalibratorExistingRule fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CalibratorExistingRule> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CalibratorExistingRule> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CalibratorExistingRule>(context, "", "/", "GET", CalibratorExistingRule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CalibratorExistingRule>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CalibratorExistingRule>(context, "", "/", "GET", CalibratorExistingRule.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CalibratorExistingRule loadJSON(String json, APIContext context, String header) {
        CalibratorExistingRule calibratorExistingRule = (CalibratorExistingRule)CalibratorExistingRule.getGson().fromJson(json, CalibratorExistingRule.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(calibratorExistingRule.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        calibratorExistingRule.context = context;
        calibratorExistingRule.rawValue = json;
        calibratorExistingRule.header = header;
        return calibratorExistingRule;
    }

    public static APINodeList<CalibratorExistingRule> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CalibratorExistingRule> calibratorExistingRules = new APINodeList<CalibratorExistingRule>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        calibratorExistingRules.add(CalibratorExistingRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return calibratorExistingRules;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            calibratorExistingRules.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        calibratorExistingRules.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            calibratorExistingRules.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            calibratorExistingRules.add(CalibratorExistingRule.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                calibratorExistingRules.add(CalibratorExistingRule.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            calibratorExistingRules.add(CalibratorExistingRule.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return calibratorExistingRules;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        calibratorExistingRules.add(CalibratorExistingRule.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return calibratorExistingRules;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        calibratorExistingRules.add(CalibratorExistingRule.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return calibratorExistingRules;
                }
                calibratorExistingRules.clear();
                calibratorExistingRules.add(CalibratorExistingRule.loadJSON(json, context, header));
                return calibratorExistingRules;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CalibratorExistingRule.getGson().toJson((Object)this);
    }

    public APIRequestGetActivities getActivities() {
        return new APIRequestGetActivities(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getField7dVolume() {
        return this.m7dVolume;
    }

    public String getFieldCreationSource() {
        return this.mCreationSource;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public String getFieldCreator() {
        return this.mCreator;
    }

    public String getFieldEventType() {
        return this.mEventType;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldRule() {
        return this.mRule;
    }

    public String getFieldRuleType() {
        return this.mRuleType;
    }

    public List<String> getFieldSampleUrls() {
        return this.mSampleUrls;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CalibratorExistingRule copyFrom(CalibratorExistingRule instance) {
        this.m7dVolume = instance.m7dVolume;
        this.mCreationSource = instance.mCreationSource;
        this.mCreationTime = instance.mCreationTime;
        this.mCreator = instance.mCreator;
        this.mEventType = instance.mEventType;
        this.mId = instance.mId;
        this.mRule = instance.mRule;
        this.mRuleType = instance.mRuleType;
        this.mSampleUrls = instance.mSampleUrls;
        this.mStatus = instance.mStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CalibratorExistingRule> getParser() {
        return new APIRequest.ResponseParser<CalibratorExistingRule>(){

            @Override
            public APINodeList<CalibratorExistingRule> parseResponse(String response, APIContext context, APIRequest<CalibratorExistingRule> request, String header) throws APIException.MalformedResponseException {
                return CalibratorExistingRule.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumEventType {
        VALUE_RULE_CREATE("RULE_CREATE"),
        VALUE_RULE_EVENT_REMAPPING("RULE_EVENT_REMAPPING"),
        VALUE_RULE_STATUS_UPDATE("RULE_STATUS_UPDATE"),
        NULL(null);

        private String value;

        private EnumEventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<CalibratorExistingRule> {
        CalibratorExistingRule lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"7d_volume", "creation_source", "creation_time", "creator", "event_type", "id", "rule", "rule_type", "sample_urls", "status"};

        @Override
        public CalibratorExistingRule getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CalibratorExistingRule parseResponse(String response, String header) throws APIException {
            return CalibratorExistingRule.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CalibratorExistingRule execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CalibratorExistingRule execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CalibratorExistingRule> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CalibratorExistingRule> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CalibratorExistingRule>(){

                public CalibratorExistingRule apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet request7dVolumeField() {
            return this.request7dVolumeField(true);
        }

        public APIRequestGet request7dVolumeField(boolean value) {
            this.requestField("7d_volume", value);
            return this;
        }

        public APIRequestGet requestCreationSourceField() {
            return this.requestCreationSourceField(true);
        }

        public APIRequestGet requestCreationSourceField(boolean value) {
            this.requestField("creation_source", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCreatorField() {
            return this.requestCreatorField(true);
        }

        public APIRequestGet requestCreatorField(boolean value) {
            this.requestField("creator", value);
            return this;
        }

        public APIRequestGet requestEventTypeField() {
            return this.requestEventTypeField(true);
        }

        public APIRequestGet requestEventTypeField(boolean value) {
            this.requestField("event_type", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestRuleField() {
            return this.requestRuleField(true);
        }

        public APIRequestGet requestRuleField(boolean value) {
            this.requestField("rule", value);
            return this;
        }

        public APIRequestGet requestRuleTypeField() {
            return this.requestRuleTypeField(true);
        }

        public APIRequestGet requestRuleTypeField(boolean value) {
            this.requestField("rule_type", value);
            return this;
        }

        public APIRequestGet requestSampleUrlsField() {
            return this.requestSampleUrlsField(true);
        }

        public APIRequestGet requestSampleUrlsField(boolean value) {
            this.requestField("sample_urls", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetActivities
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"start_time", "end_time", "event_type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestGetActivities.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetActivities(String nodeId, APIContext context) {
            super(context, nodeId, "/activities", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetActivities setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetActivities setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetActivities setStartTime(Object startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestGetActivities setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestGetActivities setEndTime(Object endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestGetActivities setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestGetActivities setEventType(EnumEventType eventType) {
            this.setParam("event_type", (Object)eventType);
            return this;
        }

        public APIRequestGetActivities setEventType(String eventType) {
            this.setParam("event_type", eventType);
            return this;
        }

        public APIRequestGetActivities requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetActivities requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetActivities requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetActivities requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetActivities requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetActivities requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

