/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdStudyAdsAssetUserPermissions;
import com.facebook.ads.sdk.AdStudyCell;
import com.facebook.ads.sdk.AdStudyObjective;
import com.facebook.ads.sdk.AdsTALHealthCheckError;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdStudy
extends APINode {
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="canceled_time")
    private String mCanceledTime = null;
    @SerializedName(value="cooldown_start_time")
    private String mCooldownStartTime = null;
    @SerializedName(value="created_by")
    private User mCreatedBy = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="observation_end_time")
    private String mObservationEndTime = null;
    @SerializedName(value="results_first_available_date")
    private String mResultsFirstAvailableDate = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="updated_by")
    private User mUpdatedBy = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    protected static Gson gson = null;

    AdStudy() {
    }

    public AdStudy(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdStudy(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdStudy fetch() throws APIException {
        AdStudy newInstance = AdStudy.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdStudy fetchById(Long id, APIContext context) throws APIException {
        return AdStudy.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdStudy> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdStudy.fetchByIdAsync(id.toString(), context);
    }

    public static AdStudy fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdStudy> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdStudy> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdStudy>(context, "", "/", "GET", AdStudy.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdStudy>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdStudy>(context, "", "/", "GET", AdStudy.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdStudy loadJSON(String json, APIContext context, String header) {
        AdStudy adStudy = (AdStudy)AdStudy.getGson().fromJson(json, AdStudy.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adStudy.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adStudy.context = context;
        adStudy.rawValue = json;
        adStudy.header = header;
        return adStudy;
    }

    public static APINodeList<AdStudy> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdStudy> adStudys = new APINodeList<AdStudy>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adStudys.add(AdStudy.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adStudys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adStudys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adStudys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adStudys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adStudys.add(AdStudy.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adStudys.add(AdStudy.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adStudys.add(AdStudy.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adStudys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adStudys.add(AdStudy.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adStudys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adStudys.add(AdStudy.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adStudys;
                }
                adStudys.clear();
                adStudys.add(AdStudy.loadJSON(json, context, header));
                return adStudys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdStudy.getGson().toJson((Object)this);
    }

    public APIRequestGetCells getCells() {
        return new APIRequestGetCells(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateCustomAudience createCustomAudience() {
        return new APIRequestCreateCustomAudience(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetHealthCheckErrors getHealthCheckErrors() {
        return new APIRequestGetHealthCheckErrors(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetObjectives getObjectives() {
        return new APIRequestGetObjectives(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateObjective createObjective() {
        return new APIRequestCreateObjective(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteUserPermissions deleteUserPermissions() {
        return new APIRequestDeleteUserPermissions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetUserPermissions getUserPermissions() {
        return new APIRequestGetUserPermissions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateUserPermission createUserPermission() {
        return new APIRequestCreateUserPermission(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetViewers getViewers() {
        return new APIRequestGetViewers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public String getFieldCanceledTime() {
        return this.mCanceledTime;
    }

    public String getFieldCooldownStartTime() {
        return this.mCooldownStartTime;
    }

    public User getFieldCreatedBy() {
        if (this.mCreatedBy != null) {
            this.mCreatedBy.context = this.getContext();
        }
        return this.mCreatedBy;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldObservationEndTime() {
        return this.mObservationEndTime;
    }

    public String getFieldResultsFirstAvailableDate() {
        return this.mResultsFirstAvailableDate;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public String getFieldType() {
        return this.mType;
    }

    public User getFieldUpdatedBy() {
        if (this.mUpdatedBy != null) {
            this.mUpdatedBy.context = this.getContext();
        }
        return this.mUpdatedBy;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdStudy copyFrom(AdStudy instance) {
        this.mBusiness = instance.mBusiness;
        this.mCanceledTime = instance.mCanceledTime;
        this.mCooldownStartTime = instance.mCooldownStartTime;
        this.mCreatedBy = instance.mCreatedBy;
        this.mCreatedTime = instance.mCreatedTime;
        this.mDescription = instance.mDescription;
        this.mEndTime = instance.mEndTime;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mObservationEndTime = instance.mObservationEndTime;
        this.mResultsFirstAvailableDate = instance.mResultsFirstAvailableDate;
        this.mStartTime = instance.mStartTime;
        this.mType = instance.mType;
        this.mUpdatedBy = instance.mUpdatedBy;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdStudy> getParser() {
        return new APIRequest.ResponseParser<AdStudy>(){

            @Override
            public APINodeList<AdStudy> parseResponse(String response, APIContext context, APIRequest<AdStudy> request, String header) throws APIException.MalformedResponseException {
                return AdStudy.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_LIFT("LIFT"),
        VALUE_SPLIT_TEST("SPLIT_TEST"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumRole {
        VALUE_ADMIN("ADMIN"),
        VALUE_ANALYST("ANALYST"),
        NULL(null);

        private String value;

        private EnumRole(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumAudienceType {
        VALUE_MOST_RESPONSIVE("MOST_RESPONSIVE"),
        VALUE_NOT_MOST_RESPONSIVE("NOT_MOST_RESPONSIVE"),
        NULL(null);

        private String value;

        private EnumAudienceType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<AdStudy> {
        AdStudy lastResponse = null;
        public static final String[] PARAMS = new String[]{"cells", "objectives", "end_time", "description", "name", "start_time", "viewers", "cooldown_start_time", "observation_end_time", "confidence_level", "client_business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdStudy getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudy parseResponse(String response, String header) throws APIException {
            return AdStudy.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdStudy execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudy execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdStudy> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdStudy> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdStudy>(){

                public AdStudy apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setCells(List<Object> cells) {
            this.setParam("cells", cells);
            return this;
        }

        public APIRequestUpdate setCells(String cells) {
            this.setParam("cells", cells);
            return this;
        }

        public APIRequestUpdate setObjectives(List<Object> objectives) {
            this.setParam("objectives", objectives);
            return this;
        }

        public APIRequestUpdate setObjectives(String objectives) {
            this.setParam("objectives", objectives);
            return this;
        }

        public APIRequestUpdate setEndTime(Long endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestUpdate setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestUpdate setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setStartTime(Long startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestUpdate setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestUpdate setViewers(List<Long> viewers) {
            this.setParam("viewers", viewers);
            return this;
        }

        public APIRequestUpdate setViewers(String viewers) {
            this.setParam("viewers", viewers);
            return this;
        }

        public APIRequestUpdate setCooldownStartTime(Long cooldownStartTime) {
            this.setParam("cooldown_start_time", cooldownStartTime);
            return this;
        }

        public APIRequestUpdate setCooldownStartTime(String cooldownStartTime) {
            this.setParam("cooldown_start_time", cooldownStartTime);
            return this;
        }

        public APIRequestUpdate setObservationEndTime(Long observationEndTime) {
            this.setParam("observation_end_time", observationEndTime);
            return this;
        }

        public APIRequestUpdate setObservationEndTime(String observationEndTime) {
            this.setParam("observation_end_time", observationEndTime);
            return this;
        }

        public APIRequestUpdate setConfidenceLevel(Double confidenceLevel) {
            this.setParam("confidence_level", confidenceLevel);
            return this;
        }

        public APIRequestUpdate setConfidenceLevel(String confidenceLevel) {
            this.setParam("confidence_level", confidenceLevel);
            return this;
        }

        public APIRequestUpdate setClientBusiness(String clientBusiness) {
            this.setParam("client_business", clientBusiness);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdStudy> {
        AdStudy lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "canceled_time", "cooldown_start_time", "created_by", "created_time", "description", "end_time", "id", "name", "observation_end_time", "results_first_available_date", "start_time", "type", "updated_by", "updated_time"};

        @Override
        public AdStudy getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudy parseResponse(String response, String header) throws APIException {
            return AdStudy.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdStudy execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudy execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdStudy> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdStudy> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdStudy>(){

                public AdStudy apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestCanceledTimeField() {
            return this.requestCanceledTimeField(true);
        }

        public APIRequestGet requestCanceledTimeField(boolean value) {
            this.requestField("canceled_time", value);
            return this;
        }

        public APIRequestGet requestCooldownStartTimeField() {
            return this.requestCooldownStartTimeField(true);
        }

        public APIRequestGet requestCooldownStartTimeField(boolean value) {
            this.requestField("cooldown_start_time", value);
            return this;
        }

        public APIRequestGet requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGet requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestObservationEndTimeField() {
            return this.requestObservationEndTimeField(true);
        }

        public APIRequestGet requestObservationEndTimeField(boolean value) {
            this.requestField("observation_end_time", value);
            return this;
        }

        public APIRequestGet requestResultsFirstAvailableDateField() {
            return this.requestResultsFirstAvailableDateField(true);
        }

        public APIRequestGet requestResultsFirstAvailableDateField(boolean value) {
            this.requestField("results_first_available_date", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGet requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGet requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetViewers
    extends APIRequest<User> {
        APINodeList<User> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"about", "address", "admin_notes", "age_range", "birthday", "can_review_measurement_request", "context", "cover", "currency", "devices", "education", "email", "employee_number", "favorite_athletes", "favorite_teams", "first_name", "gender", "hometown", "id", "inspirational_people", "install_type", "installed", "interested_in", "is_famedeeplinkinguser", "is_shared_login", "is_verified", "labels", "languages", "last_name", "link", "local_news_megaphone_dismiss_status", "local_news_subscription_status", "locale", "location", "meeting_for", "middle_name", "name", "name_format", "payment_pricepoints", "political", "profile_pic", "public_key", "quotes", "relationship_status", "religion", "security_settings", "shared_login_upgrade_required_by", "short_name", "significant_other", "sports", "test_group", "third_party_id", "timezone", "token_for_business", "updated_time", "verified", "video_upload_limits", "viewer_can_send_gift", "website", "work"};

        @Override
        public APINodeList<User> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<User> parseResponse(String response, String header) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<User> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<User> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<User>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<User>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<User>>(){

                public APINodeList<User> apply(String result) {
                    try {
                        return APIRequestGetViewers.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetViewers(String nodeId, APIContext context) {
            super(context, nodeId, "/viewers", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetViewers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetViewers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetViewers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetViewers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetViewers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetViewers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetViewers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetViewers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetViewers requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetViewers requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetViewers requestAddressField() {
            return this.requestAddressField(true);
        }

        public APIRequestGetViewers requestAddressField(boolean value) {
            this.requestField("address", value);
            return this;
        }

        public APIRequestGetViewers requestAdminNotesField() {
            return this.requestAdminNotesField(true);
        }

        public APIRequestGetViewers requestAdminNotesField(boolean value) {
            this.requestField("admin_notes", value);
            return this;
        }

        public APIRequestGetViewers requestAgeRangeField() {
            return this.requestAgeRangeField(true);
        }

        public APIRequestGetViewers requestAgeRangeField(boolean value) {
            this.requestField("age_range", value);
            return this;
        }

        public APIRequestGetViewers requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetViewers requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetViewers requestCanReviewMeasurementRequestField() {
            return this.requestCanReviewMeasurementRequestField(true);
        }

        public APIRequestGetViewers requestCanReviewMeasurementRequestField(boolean value) {
            this.requestField("can_review_measurement_request", value);
            return this;
        }

        public APIRequestGetViewers requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetViewers requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetViewers requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetViewers requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetViewers requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetViewers requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetViewers requestDevicesField() {
            return this.requestDevicesField(true);
        }

        public APIRequestGetViewers requestDevicesField(boolean value) {
            this.requestField("devices", value);
            return this;
        }

        public APIRequestGetViewers requestEducationField() {
            return this.requestEducationField(true);
        }

        public APIRequestGetViewers requestEducationField(boolean value) {
            this.requestField("education", value);
            return this;
        }

        public APIRequestGetViewers requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGetViewers requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGetViewers requestEmployeeNumberField() {
            return this.requestEmployeeNumberField(true);
        }

        public APIRequestGetViewers requestEmployeeNumberField(boolean value) {
            this.requestField("employee_number", value);
            return this;
        }

        public APIRequestGetViewers requestFavoriteAthletesField() {
            return this.requestFavoriteAthletesField(true);
        }

        public APIRequestGetViewers requestFavoriteAthletesField(boolean value) {
            this.requestField("favorite_athletes", value);
            return this;
        }

        public APIRequestGetViewers requestFavoriteTeamsField() {
            return this.requestFavoriteTeamsField(true);
        }

        public APIRequestGetViewers requestFavoriteTeamsField(boolean value) {
            this.requestField("favorite_teams", value);
            return this;
        }

        public APIRequestGetViewers requestFirstNameField() {
            return this.requestFirstNameField(true);
        }

        public APIRequestGetViewers requestFirstNameField(boolean value) {
            this.requestField("first_name", value);
            return this;
        }

        public APIRequestGetViewers requestGenderField() {
            return this.requestGenderField(true);
        }

        public APIRequestGetViewers requestGenderField(boolean value) {
            this.requestField("gender", value);
            return this;
        }

        public APIRequestGetViewers requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetViewers requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetViewers requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetViewers requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetViewers requestInspirationalPeopleField() {
            return this.requestInspirationalPeopleField(true);
        }

        public APIRequestGetViewers requestInspirationalPeopleField(boolean value) {
            this.requestField("inspirational_people", value);
            return this;
        }

        public APIRequestGetViewers requestInstallTypeField() {
            return this.requestInstallTypeField(true);
        }

        public APIRequestGetViewers requestInstallTypeField(boolean value) {
            this.requestField("install_type", value);
            return this;
        }

        public APIRequestGetViewers requestInstalledField() {
            return this.requestInstalledField(true);
        }

        public APIRequestGetViewers requestInstalledField(boolean value) {
            this.requestField("installed", value);
            return this;
        }

        public APIRequestGetViewers requestInterestedInField() {
            return this.requestInterestedInField(true);
        }

        public APIRequestGetViewers requestInterestedInField(boolean value) {
            this.requestField("interested_in", value);
            return this;
        }

        public APIRequestGetViewers requestIsFamedeeplinkinguserField() {
            return this.requestIsFamedeeplinkinguserField(true);
        }

        public APIRequestGetViewers requestIsFamedeeplinkinguserField(boolean value) {
            this.requestField("is_famedeeplinkinguser", value);
            return this;
        }

        public APIRequestGetViewers requestIsSharedLoginField() {
            return this.requestIsSharedLoginField(true);
        }

        public APIRequestGetViewers requestIsSharedLoginField(boolean value) {
            this.requestField("is_shared_login", value);
            return this;
        }

        public APIRequestGetViewers requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetViewers requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetViewers requestLabelsField() {
            return this.requestLabelsField(true);
        }

        public APIRequestGetViewers requestLabelsField(boolean value) {
            this.requestField("labels", value);
            return this;
        }

        public APIRequestGetViewers requestLanguagesField() {
            return this.requestLanguagesField(true);
        }

        public APIRequestGetViewers requestLanguagesField(boolean value) {
            this.requestField("languages", value);
            return this;
        }

        public APIRequestGetViewers requestLastNameField() {
            return this.requestLastNameField(true);
        }

        public APIRequestGetViewers requestLastNameField(boolean value) {
            this.requestField("last_name", value);
            return this;
        }

        public APIRequestGetViewers requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetViewers requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetViewers requestLocalNewsMegaphoneDismissStatusField() {
            return this.requestLocalNewsMegaphoneDismissStatusField(true);
        }

        public APIRequestGetViewers requestLocalNewsMegaphoneDismissStatusField(boolean value) {
            this.requestField("local_news_megaphone_dismiss_status", value);
            return this;
        }

        public APIRequestGetViewers requestLocalNewsSubscriptionStatusField() {
            return this.requestLocalNewsSubscriptionStatusField(true);
        }

        public APIRequestGetViewers requestLocalNewsSubscriptionStatusField(boolean value) {
            this.requestField("local_news_subscription_status", value);
            return this;
        }

        public APIRequestGetViewers requestLocaleField() {
            return this.requestLocaleField(true);
        }

        public APIRequestGetViewers requestLocaleField(boolean value) {
            this.requestField("locale", value);
            return this;
        }

        public APIRequestGetViewers requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetViewers requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetViewers requestMeetingForField() {
            return this.requestMeetingForField(true);
        }

        public APIRequestGetViewers requestMeetingForField(boolean value) {
            this.requestField("meeting_for", value);
            return this;
        }

        public APIRequestGetViewers requestMiddleNameField() {
            return this.requestMiddleNameField(true);
        }

        public APIRequestGetViewers requestMiddleNameField(boolean value) {
            this.requestField("middle_name", value);
            return this;
        }

        public APIRequestGetViewers requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetViewers requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetViewers requestNameFormatField() {
            return this.requestNameFormatField(true);
        }

        public APIRequestGetViewers requestNameFormatField(boolean value) {
            this.requestField("name_format", value);
            return this;
        }

        public APIRequestGetViewers requestPaymentPricepointsField() {
            return this.requestPaymentPricepointsField(true);
        }

        public APIRequestGetViewers requestPaymentPricepointsField(boolean value) {
            this.requestField("payment_pricepoints", value);
            return this;
        }

        public APIRequestGetViewers requestPoliticalField() {
            return this.requestPoliticalField(true);
        }

        public APIRequestGetViewers requestPoliticalField(boolean value) {
            this.requestField("political", value);
            return this;
        }

        public APIRequestGetViewers requestProfilePicField() {
            return this.requestProfilePicField(true);
        }

        public APIRequestGetViewers requestProfilePicField(boolean value) {
            this.requestField("profile_pic", value);
            return this;
        }

        public APIRequestGetViewers requestPublicKeyField() {
            return this.requestPublicKeyField(true);
        }

        public APIRequestGetViewers requestPublicKeyField(boolean value) {
            this.requestField("public_key", value);
            return this;
        }

        public APIRequestGetViewers requestQuotesField() {
            return this.requestQuotesField(true);
        }

        public APIRequestGetViewers requestQuotesField(boolean value) {
            this.requestField("quotes", value);
            return this;
        }

        public APIRequestGetViewers requestRelationshipStatusField() {
            return this.requestRelationshipStatusField(true);
        }

        public APIRequestGetViewers requestRelationshipStatusField(boolean value) {
            this.requestField("relationship_status", value);
            return this;
        }

        public APIRequestGetViewers requestReligionField() {
            return this.requestReligionField(true);
        }

        public APIRequestGetViewers requestReligionField(boolean value) {
            this.requestField("religion", value);
            return this;
        }

        public APIRequestGetViewers requestSecuritySettingsField() {
            return this.requestSecuritySettingsField(true);
        }

        public APIRequestGetViewers requestSecuritySettingsField(boolean value) {
            this.requestField("security_settings", value);
            return this;
        }

        public APIRequestGetViewers requestSharedLoginUpgradeRequiredByField() {
            return this.requestSharedLoginUpgradeRequiredByField(true);
        }

        public APIRequestGetViewers requestSharedLoginUpgradeRequiredByField(boolean value) {
            this.requestField("shared_login_upgrade_required_by", value);
            return this;
        }

        public APIRequestGetViewers requestShortNameField() {
            return this.requestShortNameField(true);
        }

        public APIRequestGetViewers requestShortNameField(boolean value) {
            this.requestField("short_name", value);
            return this;
        }

        public APIRequestGetViewers requestSignificantOtherField() {
            return this.requestSignificantOtherField(true);
        }

        public APIRequestGetViewers requestSignificantOtherField(boolean value) {
            this.requestField("significant_other", value);
            return this;
        }

        public APIRequestGetViewers requestSportsField() {
            return this.requestSportsField(true);
        }

        public APIRequestGetViewers requestSportsField(boolean value) {
            this.requestField("sports", value);
            return this;
        }

        public APIRequestGetViewers requestTestGroupField() {
            return this.requestTestGroupField(true);
        }

        public APIRequestGetViewers requestTestGroupField(boolean value) {
            this.requestField("test_group", value);
            return this;
        }

        public APIRequestGetViewers requestThirdPartyIdField() {
            return this.requestThirdPartyIdField(true);
        }

        public APIRequestGetViewers requestThirdPartyIdField(boolean value) {
            this.requestField("third_party_id", value);
            return this;
        }

        public APIRequestGetViewers requestTimezoneField() {
            return this.requestTimezoneField(true);
        }

        public APIRequestGetViewers requestTimezoneField(boolean value) {
            this.requestField("timezone", value);
            return this;
        }

        public APIRequestGetViewers requestTokenForBusinessField() {
            return this.requestTokenForBusinessField(true);
        }

        public APIRequestGetViewers requestTokenForBusinessField(boolean value) {
            this.requestField("token_for_business", value);
            return this;
        }

        public APIRequestGetViewers requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetViewers requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetViewers requestVerifiedField() {
            return this.requestVerifiedField(true);
        }

        public APIRequestGetViewers requestVerifiedField(boolean value) {
            this.requestField("verified", value);
            return this;
        }

        public APIRequestGetViewers requestVideoUploadLimitsField() {
            return this.requestVideoUploadLimitsField(true);
        }

        public APIRequestGetViewers requestVideoUploadLimitsField(boolean value) {
            this.requestField("video_upload_limits", value);
            return this;
        }

        public APIRequestGetViewers requestViewerCanSendGiftField() {
            return this.requestViewerCanSendGiftField(true);
        }

        public APIRequestGetViewers requestViewerCanSendGiftField(boolean value) {
            this.requestField("viewer_can_send_gift", value);
            return this;
        }

        public APIRequestGetViewers requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetViewers requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetViewers requestWorkField() {
            return this.requestWorkField(true);
        }

        public APIRequestGetViewers requestWorkField(boolean value) {
            this.requestField("work", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateUserPermission
    extends APIRequest<AdStudy> {
        AdStudy lastResponse = null;
        public static final String[] PARAMS = new String[]{"user", "email", "role", "business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdStudy getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudy parseResponse(String response, String header) throws APIException {
            return AdStudy.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdStudy execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudy execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdStudy> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdStudy> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdStudy>(){

                public AdStudy apply(String result) {
                    try {
                        return APIRequestCreateUserPermission.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateUserPermission(String nodeId, APIContext context) {
            super(context, nodeId, "/userpermissions", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateUserPermission setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateUserPermission setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateUserPermission setUser(Long user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateUserPermission setUser(String user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateUserPermission setEmail(String email) {
            this.setParam("email", email);
            return this;
        }

        public APIRequestCreateUserPermission setRole(EnumRole role) {
            this.setParam("role", (Object)role);
            return this;
        }

        public APIRequestCreateUserPermission setRole(String role) {
            this.setParam("role", role);
            return this;
        }

        public APIRequestCreateUserPermission setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestCreateUserPermission requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateUserPermission requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUserPermission requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateUserPermission requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUserPermission requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateUserPermission requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetUserPermissions
    extends APIRequest<AdStudyAdsAssetUserPermissions> {
        APINodeList<AdStudyAdsAssetUserPermissions> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "business_persona", "created_by", "created_time", "email", "role", "status", "updated_by", "updated_time", "user", "id"};

        @Override
        public APINodeList<AdStudyAdsAssetUserPermissions> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdStudyAdsAssetUserPermissions> parseResponse(String response, String header) throws APIException {
            return AdStudyAdsAssetUserPermissions.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdStudyAdsAssetUserPermissions> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdStudyAdsAssetUserPermissions> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdStudyAdsAssetUserPermissions>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdStudyAdsAssetUserPermissions>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdStudyAdsAssetUserPermissions>>(){

                public APINodeList<AdStudyAdsAssetUserPermissions> apply(String result) {
                    try {
                        return APIRequestGetUserPermissions.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetUserPermissions(String nodeId, APIContext context) {
            super(context, nodeId, "/userpermissions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetUserPermissions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetUserPermissions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetUserPermissions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetUserPermissions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetUserPermissions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetUserPermissions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetUserPermissions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetUserPermissions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetUserPermissions requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetUserPermissions requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetUserPermissions requestBusinessPersonaField() {
            return this.requestBusinessPersonaField(true);
        }

        public APIRequestGetUserPermissions requestBusinessPersonaField(boolean value) {
            this.requestField("business_persona", value);
            return this;
        }

        public APIRequestGetUserPermissions requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGetUserPermissions requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGetUserPermissions requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetUserPermissions requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetUserPermissions requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGetUserPermissions requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGetUserPermissions requestRoleField() {
            return this.requestRoleField(true);
        }

        public APIRequestGetUserPermissions requestRoleField(boolean value) {
            this.requestField("role", value);
            return this;
        }

        public APIRequestGetUserPermissions requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetUserPermissions requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetUserPermissions requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGetUserPermissions requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGetUserPermissions requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetUserPermissions requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetUserPermissions requestUserField() {
            return this.requestUserField(true);
        }

        public APIRequestGetUserPermissions requestUserField(boolean value) {
            this.requestField("user", value);
            return this;
        }

        public APIRequestGetUserPermissions requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetUserPermissions requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteUserPermissions
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"user", "email", "business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteUserPermissions.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteUserPermissions(String nodeId, APIContext context) {
            super(context, nodeId, "/userpermissions", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteUserPermissions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteUserPermissions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteUserPermissions setUser(Long user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestDeleteUserPermissions setUser(String user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestDeleteUserPermissions setEmail(String email) {
            this.setParam("email", email);
            return this;
        }

        public APIRequestDeleteUserPermissions setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestDeleteUserPermissions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteUserPermissions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteUserPermissions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteUserPermissions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteUserPermissions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteUserPermissions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateObjective
    extends APIRequest<AdStudyObjective> {
        AdStudyObjective lastResponse = null;
        public static final String[] PARAMS = new String[]{"is_primary", "name", "type", "adspixels", "customconversions", "applications", "offsitepixels", "offline_conversion_data_sets"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdStudyObjective getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudyObjective parseResponse(String response, String header) throws APIException {
            return AdStudyObjective.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdStudyObjective execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudyObjective execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdStudyObjective> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdStudyObjective> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdStudyObjective>(){

                public AdStudyObjective apply(String result) {
                    try {
                        return APIRequestCreateObjective.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateObjective(String nodeId, APIContext context) {
            super(context, nodeId, "/objectives", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateObjective setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateObjective setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateObjective setIsPrimary(Boolean isPrimary) {
            this.setParam("is_primary", isPrimary);
            return this;
        }

        public APIRequestCreateObjective setIsPrimary(String isPrimary) {
            this.setParam("is_primary", isPrimary);
            return this;
        }

        public APIRequestCreateObjective setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateObjective setType(AdStudyObjective.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestCreateObjective setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestCreateObjective setAdspixels(List<Object> adspixels) {
            this.setParam("adspixels", adspixels);
            return this;
        }

        public APIRequestCreateObjective setAdspixels(String adspixels) {
            this.setParam("adspixels", adspixels);
            return this;
        }

        public APIRequestCreateObjective setCustomconversions(List<Object> customconversions) {
            this.setParam("customconversions", customconversions);
            return this;
        }

        public APIRequestCreateObjective setCustomconversions(String customconversions) {
            this.setParam("customconversions", customconversions);
            return this;
        }

        public APIRequestCreateObjective setApplications(List<Object> applications) {
            this.setParam("applications", applications);
            return this;
        }

        public APIRequestCreateObjective setApplications(String applications) {
            this.setParam("applications", applications);
            return this;
        }

        public APIRequestCreateObjective setOffsitepixels(List<Object> offsitepixels) {
            this.setParam("offsitepixels", offsitepixels);
            return this;
        }

        public APIRequestCreateObjective setOffsitepixels(String offsitepixels) {
            this.setParam("offsitepixels", offsitepixels);
            return this;
        }

        public APIRequestCreateObjective setOfflineConversionDataSets(List<Object> offlineConversionDataSets) {
            this.setParam("offline_conversion_data_sets", offlineConversionDataSets);
            return this;
        }

        public APIRequestCreateObjective setOfflineConversionDataSets(String offlineConversionDataSets) {
            this.setParam("offline_conversion_data_sets", offlineConversionDataSets);
            return this;
        }

        public APIRequestCreateObjective requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateObjective requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateObjective requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateObjective requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateObjective requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateObjective requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetObjectives
    extends APIRequest<AdStudyObjective> {
        APINodeList<AdStudyObjective> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"custom_attributes", "id", "is_primary", "last_updated_results", "name", "results", "type"};

        @Override
        public APINodeList<AdStudyObjective> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdStudyObjective> parseResponse(String response, String header) throws APIException {
            return AdStudyObjective.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdStudyObjective> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdStudyObjective> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdStudyObjective>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdStudyObjective>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdStudyObjective>>(){

                public APINodeList<AdStudyObjective> apply(String result) {
                    try {
                        return APIRequestGetObjectives.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetObjectives(String nodeId, APIContext context) {
            super(context, nodeId, "/objectives", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetObjectives setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetObjectives setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetObjectives requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetObjectives requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetObjectives requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetObjectives requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetObjectives requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetObjectives requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetObjectives requestCustomAttributesField() {
            return this.requestCustomAttributesField(true);
        }

        public APIRequestGetObjectives requestCustomAttributesField(boolean value) {
            this.requestField("custom_attributes", value);
            return this;
        }

        public APIRequestGetObjectives requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetObjectives requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetObjectives requestIsPrimaryField() {
            return this.requestIsPrimaryField(true);
        }

        public APIRequestGetObjectives requestIsPrimaryField(boolean value) {
            this.requestField("is_primary", value);
            return this;
        }

        public APIRequestGetObjectives requestLastUpdatedResultsField() {
            return this.requestLastUpdatedResultsField(true);
        }

        public APIRequestGetObjectives requestLastUpdatedResultsField(boolean value) {
            this.requestField("last_updated_results", value);
            return this;
        }

        public APIRequestGetObjectives requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetObjectives requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetObjectives requestResultsField() {
            return this.requestResultsField(true);
        }

        public APIRequestGetObjectives requestResultsField(boolean value) {
            this.requestField("results", value);
            return this;
        }

        public APIRequestGetObjectives requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetObjectives requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetHealthCheckErrors
    extends APIRequest<AdsTALHealthCheckError> {
        APINodeList<AdsTALHealthCheckError> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"error_code", "target_id", "id"};

        @Override
        public APINodeList<AdsTALHealthCheckError> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdsTALHealthCheckError> parseResponse(String response, String header) throws APIException {
            return AdsTALHealthCheckError.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdsTALHealthCheckError> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdsTALHealthCheckError> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdsTALHealthCheckError>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdsTALHealthCheckError>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdsTALHealthCheckError>>(){

                public APINodeList<AdsTALHealthCheckError> apply(String result) {
                    try {
                        return APIRequestGetHealthCheckErrors.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetHealthCheckErrors(String nodeId, APIContext context) {
            super(context, nodeId, "/health_check_errors", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetHealthCheckErrors setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetHealthCheckErrors setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetHealthCheckErrors requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetHealthCheckErrors requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetHealthCheckErrors requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetHealthCheckErrors requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetHealthCheckErrors requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetHealthCheckErrors requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetHealthCheckErrors requestErrorCodeField() {
            return this.requestErrorCodeField(true);
        }

        public APIRequestGetHealthCheckErrors requestErrorCodeField(boolean value) {
            this.requestField("error_code", value);
            return this;
        }

        public APIRequestGetHealthCheckErrors requestTargetIdField() {
            return this.requestTargetIdField(true);
        }

        public APIRequestGetHealthCheckErrors requestTargetIdField(boolean value) {
            this.requestField("target_id", value);
            return this;
        }

        public APIRequestGetHealthCheckErrors requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetHealthCheckErrors requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateCustomAudience
    extends APIRequest<AdStudy> {
        AdStudy lastResponse = null;
        public static final String[] PARAMS = new String[]{"cell_id", "objective_id", "account_id", "audience_name", "audience_type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdStudy getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudy parseResponse(String response, String header) throws APIException {
            return AdStudy.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdStudy execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudy execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdStudy> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdStudy> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdStudy>(){

                public AdStudy apply(String result) {
                    try {
                        return APIRequestCreateCustomAudience.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateCustomAudience(String nodeId, APIContext context) {
            super(context, nodeId, "/customaudiences", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateCustomAudience setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateCustomAudience setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateCustomAudience setCellId(String cellId) {
            this.setParam("cell_id", cellId);
            return this;
        }

        public APIRequestCreateCustomAudience setObjectiveId(String objectiveId) {
            this.setParam("objective_id", objectiveId);
            return this;
        }

        public APIRequestCreateCustomAudience setAccountId(String accountId) {
            this.setParam("account_id", accountId);
            return this;
        }

        public APIRequestCreateCustomAudience setAudienceName(String audienceName) {
            this.setParam("audience_name", audienceName);
            return this;
        }

        public APIRequestCreateCustomAudience setAudienceType(EnumAudienceType audienceType) {
            this.setParam("audience_type", (Object)audienceType);
            return this;
        }

        public APIRequestCreateCustomAudience setAudienceType(String audienceType) {
            this.setParam("audience_type", audienceType);
            return this;
        }

        public APIRequestCreateCustomAudience requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateCustomAudience requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCustomAudience requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateCustomAudience requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCustomAudience requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateCustomAudience requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetCells
    extends APIRequest<AdStudyCell> {
        APINodeList<AdStudyCell> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_entities_count", "control_percentage", "id", "name", "treatment_percentage"};

        @Override
        public APINodeList<AdStudyCell> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdStudyCell> parseResponse(String response, String header) throws APIException {
            return AdStudyCell.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdStudyCell> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdStudyCell> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdStudyCell>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdStudyCell>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdStudyCell>>(){

                public APINodeList<AdStudyCell> apply(String result) {
                    try {
                        return APIRequestGetCells.this.parseResponse(result, null);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetCells(String nodeId, APIContext context) {
            super(context, nodeId, "/cells", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCells setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCells setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCells requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCells requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCells requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCells requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCells requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCells requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetCells requestAdEntitiesCountField() {
            return this.requestAdEntitiesCountField(true);
        }

        public APIRequestGetCells requestAdEntitiesCountField(boolean value) {
            this.requestField("ad_entities_count", value);
            return this;
        }

        public APIRequestGetCells requestControlPercentageField() {
            return this.requestControlPercentageField(true);
        }

        public APIRequestGetCells requestControlPercentageField(boolean value) {
            this.requestField("control_percentage", value);
            return this;
        }

        public APIRequestGetCells requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetCells requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetCells requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetCells requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetCells requestTreatmentPercentageField() {
            return this.requestTreatmentPercentageField(true);
        }

        public APIRequestGetCells requestTreatmentPercentageField(boolean value) {
            this.requestField("treatment_percentage", value);
            return this;
        }
    }
}

