/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAccountContextualTargeting
extends APINode {
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="enabled_in_ui")
    private Boolean mEnabledInUi = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="key")
    private String mKey = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="parent")
    private String mParent = null;
    @SerializedName(value="path")
    private List<String> mPath = null;
    @SerializedName(value="type")
    private String mType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAccountContextualTargeting loadJSON(String json, APIContext context, String header) {
        AdAccountContextualTargeting adAccountContextualTargeting = (AdAccountContextualTargeting)AdAccountContextualTargeting.getGson().fromJson(json, AdAccountContextualTargeting.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAccountContextualTargeting.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAccountContextualTargeting.context = context;
        adAccountContextualTargeting.rawValue = json;
        adAccountContextualTargeting.header = header;
        return adAccountContextualTargeting;
    }

    public static APINodeList<AdAccountContextualTargeting> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAccountContextualTargeting> adAccountContextualTargetings = new APINodeList<AdAccountContextualTargeting>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAccountContextualTargetings.add(AdAccountContextualTargeting.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adAccountContextualTargetings;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAccountContextualTargetings.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAccountContextualTargetings.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAccountContextualTargetings.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAccountContextualTargetings.add(AdAccountContextualTargeting.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAccountContextualTargetings.add(AdAccountContextualTargeting.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAccountContextualTargetings.add(AdAccountContextualTargeting.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adAccountContextualTargetings;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAccountContextualTargetings.add(AdAccountContextualTargeting.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adAccountContextualTargetings;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAccountContextualTargetings.add(AdAccountContextualTargeting.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAccountContextualTargetings;
                }
                adAccountContextualTargetings.clear();
                adAccountContextualTargetings.add(AdAccountContextualTargeting.loadJSON(json, context, header));
                return adAccountContextualTargetings;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAccountContextualTargeting.getGson().toJson((Object)this);
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public AdAccountContextualTargeting setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public Boolean getFieldEnabledInUi() {
        return this.mEnabledInUi;
    }

    public AdAccountContextualTargeting setFieldEnabledInUi(Boolean value) {
        this.mEnabledInUi = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdAccountContextualTargeting setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldKey() {
        return this.mKey;
    }

    public AdAccountContextualTargeting setFieldKey(String value) {
        this.mKey = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public AdAccountContextualTargeting setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldParent() {
        return this.mParent;
    }

    public AdAccountContextualTargeting setFieldParent(String value) {
        this.mParent = value;
        return this;
    }

    public List<String> getFieldPath() {
        return this.mPath;
    }

    public AdAccountContextualTargeting setFieldPath(List<String> value) {
        this.mPath = value;
        return this;
    }

    public String getFieldType() {
        return this.mType;
    }

    public AdAccountContextualTargeting setFieldType(String value) {
        this.mType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAccountContextualTargeting copyFrom(AdAccountContextualTargeting instance) {
        this.mDescription = instance.mDescription;
        this.mEnabledInUi = instance.mEnabledInUi;
        this.mId = instance.mId;
        this.mKey = instance.mKey;
        this.mName = instance.mName;
        this.mParent = instance.mParent;
        this.mPath = instance.mPath;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAccountContextualTargeting> getParser() {
        return new APIRequest.ResponseParser<AdAccountContextualTargeting>(){

            @Override
            public APINodeList<AdAccountContextualTargeting> parseResponse(String response, APIContext context, APIRequest<AdAccountContextualTargeting> request, String header) throws APIException.MalformedResponseException {
                return AdAccountContextualTargeting.parseResponse(response, context, request, header);
            }
        };
    }
}

