/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageLocationsBreakdown
extends APINode {
    @SerializedName(value="location_id")
    private String mLocationId = null;
    @SerializedName(value="location_name")
    private String mLocationName = null;
    @SerializedName(value="location_type")
    private String mLocationType = null;
    @SerializedName(value="num_pages")
    private Long mNumPages = null;
    @SerializedName(value="num_pages_eligible_for_store_visit_reporting")
    private Long mNumPagesEligibleForStoreVisitReporting = null;
    @SerializedName(value="num_unpublished_or_closed_pages")
    private Long mNumUnpublishedOrClosedPages = null;
    @SerializedName(value="parent_country_code")
    private String mParentCountryCode = null;
    @SerializedName(value="parent_region_id")
    private Long mParentRegionId = null;
    @SerializedName(value="parent_region_name")
    private String mParentRegionName = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PageLocationsBreakdown loadJSON(String json, APIContext context) {
        PageLocationsBreakdown pageLocationsBreakdown = (PageLocationsBreakdown)PageLocationsBreakdown.getGson().fromJson(json, PageLocationsBreakdown.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pageLocationsBreakdown.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pageLocationsBreakdown.context = context;
        pageLocationsBreakdown.rawValue = json;
        return pageLocationsBreakdown;
    }

    public static APINodeList<PageLocationsBreakdown> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PageLocationsBreakdown> pageLocationsBreakdowns = new APINodeList<PageLocationsBreakdown>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pageLocationsBreakdowns.add(PageLocationsBreakdown.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return pageLocationsBreakdowns;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pageLocationsBreakdowns.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pageLocationsBreakdowns.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pageLocationsBreakdowns.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pageLocationsBreakdowns.add(PageLocationsBreakdown.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pageLocationsBreakdowns.add(PageLocationsBreakdown.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pageLocationsBreakdowns.add(PageLocationsBreakdown.loadJSON(obj.toString(), context));
                        }
                    }
                    return pageLocationsBreakdowns;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pageLocationsBreakdowns.add(PageLocationsBreakdown.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return pageLocationsBreakdowns;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pageLocationsBreakdowns.add(PageLocationsBreakdown.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pageLocationsBreakdowns;
                }
                pageLocationsBreakdowns.clear();
                pageLocationsBreakdowns.add(PageLocationsBreakdown.loadJSON(json, context));
                return pageLocationsBreakdowns;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PageLocationsBreakdown.getGson().toJson((Object)this);
    }

    public String getFieldLocationId() {
        return this.mLocationId;
    }

    public PageLocationsBreakdown setFieldLocationId(String value) {
        this.mLocationId = value;
        return this;
    }

    public String getFieldLocationName() {
        return this.mLocationName;
    }

    public PageLocationsBreakdown setFieldLocationName(String value) {
        this.mLocationName = value;
        return this;
    }

    public String getFieldLocationType() {
        return this.mLocationType;
    }

    public PageLocationsBreakdown setFieldLocationType(String value) {
        this.mLocationType = value;
        return this;
    }

    public Long getFieldNumPages() {
        return this.mNumPages;
    }

    public PageLocationsBreakdown setFieldNumPages(Long value) {
        this.mNumPages = value;
        return this;
    }

    public Long getFieldNumPagesEligibleForStoreVisitReporting() {
        return this.mNumPagesEligibleForStoreVisitReporting;
    }

    public PageLocationsBreakdown setFieldNumPagesEligibleForStoreVisitReporting(Long value) {
        this.mNumPagesEligibleForStoreVisitReporting = value;
        return this;
    }

    public Long getFieldNumUnpublishedOrClosedPages() {
        return this.mNumUnpublishedOrClosedPages;
    }

    public PageLocationsBreakdown setFieldNumUnpublishedOrClosedPages(Long value) {
        this.mNumUnpublishedOrClosedPages = value;
        return this;
    }

    public String getFieldParentCountryCode() {
        return this.mParentCountryCode;
    }

    public PageLocationsBreakdown setFieldParentCountryCode(String value) {
        this.mParentCountryCode = value;
        return this;
    }

    public Long getFieldParentRegionId() {
        return this.mParentRegionId;
    }

    public PageLocationsBreakdown setFieldParentRegionId(Long value) {
        this.mParentRegionId = value;
        return this;
    }

    public String getFieldParentRegionName() {
        return this.mParentRegionName;
    }

    public PageLocationsBreakdown setFieldParentRegionName(String value) {
        this.mParentRegionName = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public PageLocationsBreakdown setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PageLocationsBreakdown copyFrom(PageLocationsBreakdown instance) {
        this.mLocationId = instance.mLocationId;
        this.mLocationName = instance.mLocationName;
        this.mLocationType = instance.mLocationType;
        this.mNumPages = instance.mNumPages;
        this.mNumPagesEligibleForStoreVisitReporting = instance.mNumPagesEligibleForStoreVisitReporting;
        this.mNumUnpublishedOrClosedPages = instance.mNumUnpublishedOrClosedPages;
        this.mParentCountryCode = instance.mParentCountryCode;
        this.mParentRegionId = instance.mParentRegionId;
        this.mParentRegionName = instance.mParentRegionName;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PageLocationsBreakdown> getParser() {
        return new APIRequest.ResponseParser<PageLocationsBreakdown>(){

            @Override
            public APINodeList<PageLocationsBreakdown> parseResponse(String response, APIContext context, APIRequest<PageLocationsBreakdown> request) throws APIException.MalformedResponseException {
                return PageLocationsBreakdown.parseResponse(response, context, request);
            }
        };
    }
}

