/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdgroupRelevanceScore
extends APINode {
    @SerializedName(value="negative_feedback")
    private String mNegativeFeedback = null;
    @SerializedName(value="positive_feedback")
    private String mPositiveFeedback = null;
    @SerializedName(value="score")
    private String mScore = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdgroupRelevanceScore loadJSON(String json, APIContext context) {
        AdgroupRelevanceScore adgroupRelevanceScore = (AdgroupRelevanceScore)AdgroupRelevanceScore.getGson().fromJson(json, AdgroupRelevanceScore.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adgroupRelevanceScore.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adgroupRelevanceScore.context = context;
        adgroupRelevanceScore.rawValue = json;
        return adgroupRelevanceScore;
    }

    public static APINodeList<AdgroupRelevanceScore> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdgroupRelevanceScore> adgroupRelevanceScores = new APINodeList<AdgroupRelevanceScore>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adgroupRelevanceScores.add(AdgroupRelevanceScore.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adgroupRelevanceScores;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adgroupRelevanceScores.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adgroupRelevanceScores.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adgroupRelevanceScores.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adgroupRelevanceScores.add(AdgroupRelevanceScore.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adgroupRelevanceScores.add(AdgroupRelevanceScore.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adgroupRelevanceScores.add(AdgroupRelevanceScore.loadJSON(obj.toString(), context));
                        }
                    }
                    return adgroupRelevanceScores;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adgroupRelevanceScores.add(AdgroupRelevanceScore.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adgroupRelevanceScores;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adgroupRelevanceScores.add(AdgroupRelevanceScore.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adgroupRelevanceScores;
                }
                adgroupRelevanceScores.clear();
                adgroupRelevanceScores.add(AdgroupRelevanceScore.loadJSON(json, context));
                return adgroupRelevanceScores;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdgroupRelevanceScore.getGson().toJson((Object)this);
    }

    public String getFieldNegativeFeedback() {
        return this.mNegativeFeedback;
    }

    public AdgroupRelevanceScore setFieldNegativeFeedback(String value) {
        this.mNegativeFeedback = value;
        return this;
    }

    public String getFieldPositiveFeedback() {
        return this.mPositiveFeedback;
    }

    public AdgroupRelevanceScore setFieldPositiveFeedback(String value) {
        this.mPositiveFeedback = value;
        return this;
    }

    public String getFieldScore() {
        return this.mScore;
    }

    public AdgroupRelevanceScore setFieldScore(String value) {
        this.mScore = value;
        return this;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public AdgroupRelevanceScore setFieldStatus(String value) {
        this.mStatus = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdgroupRelevanceScore setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdgroupRelevanceScore copyFrom(AdgroupRelevanceScore instance) {
        this.mNegativeFeedback = instance.mNegativeFeedback;
        this.mPositiveFeedback = instance.mPositiveFeedback;
        this.mScore = instance.mScore;
        this.mStatus = instance.mStatus;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdgroupRelevanceScore> getParser() {
        return new APIRequest.ResponseParser<AdgroupRelevanceScore>(){

            @Override
            public APINodeList<AdgroupRelevanceScore> parseResponse(String response, APIContext context, APIRequest<AdgroupRelevanceScore> request) throws APIException.MalformedResponseException {
                return AdgroupRelevanceScore.parseResponse(response, context, request);
            }
        };
    }
}

