/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalsIWLExtractor
extends APINode {
    @SerializedName(value="domain_uri")
    private String mDomainUri = null;
    @SerializedName(value="event_type")
    private String mEventType = null;
    @SerializedName(value="extractor_config")
    private Object mExtractorConfig = null;
    @SerializedName(value="extractor_type")
    private String mExtractorType = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    SignalsIWLExtractor() {
    }

    public SignalsIWLExtractor(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public SignalsIWLExtractor(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public SignalsIWLExtractor fetch() throws APIException {
        SignalsIWLExtractor newInstance = SignalsIWLExtractor.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static SignalsIWLExtractor fetchById(Long id, APIContext context) throws APIException {
        return SignalsIWLExtractor.fetchById(id.toString(), context);
    }

    public static ListenableFuture<SignalsIWLExtractor> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return SignalsIWLExtractor.fetchByIdAsync(id.toString(), context);
    }

    public static SignalsIWLExtractor fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<SignalsIWLExtractor> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<SignalsIWLExtractor> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<SignalsIWLExtractor>(context, "", "/", "GET", SignalsIWLExtractor.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<SignalsIWLExtractor>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<SignalsIWLExtractor>(context, "", "/", "GET", SignalsIWLExtractor.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static SignalsIWLExtractor loadJSON(String json, APIContext context) {
        SignalsIWLExtractor signalsIWLExtractor = (SignalsIWLExtractor)SignalsIWLExtractor.getGson().fromJson(json, SignalsIWLExtractor.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(signalsIWLExtractor.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        signalsIWLExtractor.context = context;
        signalsIWLExtractor.rawValue = json;
        return signalsIWLExtractor;
    }

    public static APINodeList<SignalsIWLExtractor> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<SignalsIWLExtractor> signalsIWLExtractors = new APINodeList<SignalsIWLExtractor>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        signalsIWLExtractors.add(SignalsIWLExtractor.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return signalsIWLExtractors;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            signalsIWLExtractors.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        signalsIWLExtractors.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            signalsIWLExtractors.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            signalsIWLExtractors.add(SignalsIWLExtractor.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                signalsIWLExtractors.add(SignalsIWLExtractor.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            signalsIWLExtractors.add(SignalsIWLExtractor.loadJSON(obj.toString(), context));
                        }
                    }
                    return signalsIWLExtractors;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        signalsIWLExtractors.add(SignalsIWLExtractor.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return signalsIWLExtractors;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        signalsIWLExtractors.add(SignalsIWLExtractor.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return signalsIWLExtractors;
                }
                signalsIWLExtractors.clear();
                signalsIWLExtractors.add(SignalsIWLExtractor.loadJSON(json, context));
                return signalsIWLExtractors;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return SignalsIWLExtractor.getGson().toJson((Object)this);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldDomainUri() {
        return this.mDomainUri;
    }

    public String getFieldEventType() {
        return this.mEventType;
    }

    public Object getFieldExtractorConfig() {
        return this.mExtractorConfig;
    }

    public String getFieldExtractorType() {
        return this.mExtractorType;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public SignalsIWLExtractor copyFrom(SignalsIWLExtractor instance) {
        this.mDomainUri = instance.mDomainUri;
        this.mEventType = instance.mEventType;
        this.mExtractorConfig = instance.mExtractorConfig;
        this.mExtractorType = instance.mExtractorType;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<SignalsIWLExtractor> getParser() {
        return new APIRequest.ResponseParser<SignalsIWLExtractor>(){

            @Override
            public APINodeList<SignalsIWLExtractor> parseResponse(String response, APIContext context, APIRequest<SignalsIWLExtractor> request) throws APIException.MalformedResponseException {
                return SignalsIWLExtractor.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumExtractorType {
        VALUE_CONSTANT_VALUE("CONSTANT_VALUE"),
        VALUE_CSS("CSS"),
        VALUE_GLOBAL_VARIABLE("GLOBAL_VARIABLE"),
        VALUE_GTM("GTM"),
        VALUE_JSON_LD("JSON_LD"),
        VALUE_META_TAG("META_TAG"),
        VALUE_OPEN_GRAPH("OPEN_GRAPH"),
        VALUE_RDFA("RDFA"),
        VALUE_SCHEMA_DOT_ORG("SCHEMA_DOT_ORG"),
        VALUE_URI("URI"),
        NULL(null);

        private String value;

        private EnumExtractorType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumEventType {
        VALUE_ADDPAYMENTINFO("AddPaymentInfo"),
        VALUE_ADDTOCART("AddToCart"),
        VALUE_ADDTOWISHLIST("AddToWishlist"),
        VALUE_COMPLETEREGISTRATION("CompleteRegistration"),
        VALUE_CONTACT("Contact"),
        VALUE_CUSTOMIZEPRODUCT("CustomizeProduct"),
        VALUE_DONATE("Donate"),
        VALUE_FINDLOCATION("FindLocation"),
        VALUE_INITIATECHECKOUT("InitiateCheckout"),
        VALUE_LEAD("Lead"),
        VALUE_OTHER("Other"),
        VALUE_PURCHASE("Purchase"),
        VALUE_SCHEDULE("Schedule"),
        VALUE_SEARCH("Search"),
        VALUE_STARTTRIAL("StartTrial"),
        VALUE_SUBMITAPPLICATION("SubmitApplication"),
        VALUE_SUBSCRIBE("Subscribe"),
        VALUE_VIEWCONTENT("ViewContent"),
        NULL(null);

        private String value;

        private EnumEventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<SignalsIWLExtractor> {
        SignalsIWLExtractor lastResponse = null;
        public static final String[] PARAMS = new String[]{"domain_uri", "event_type", "extractor_config", "extractor_type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public SignalsIWLExtractor getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public SignalsIWLExtractor parseResponse(String response) throws APIException {
            return SignalsIWLExtractor.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public SignalsIWLExtractor execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public SignalsIWLExtractor execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<SignalsIWLExtractor> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<SignalsIWLExtractor> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, SignalsIWLExtractor>(){

                public SignalsIWLExtractor apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setDomainUri(Object domainUri) {
            this.setParam("domain_uri", domainUri);
            return this;
        }

        public APIRequestUpdate setDomainUri(String domainUri) {
            this.setParam("domain_uri", domainUri);
            return this;
        }

        public APIRequestUpdate setEventType(EnumEventType eventType) {
            this.setParam("event_type", (Object)eventType);
            return this;
        }

        public APIRequestUpdate setEventType(String eventType) {
            this.setParam("event_type", eventType);
            return this;
        }

        public APIRequestUpdate setExtractorConfig(Map<String, String> extractorConfig) {
            this.setParam("extractor_config", extractorConfig);
            return this;
        }

        public APIRequestUpdate setExtractorConfig(String extractorConfig) {
            this.setParam("extractor_config", extractorConfig);
            return this;
        }

        public APIRequestUpdate setExtractorType(EnumExtractorType extractorType) {
            this.setParam("extractor_type", (Object)extractorType);
            return this;
        }

        public APIRequestUpdate setExtractorType(String extractorType) {
            this.setParam("extractor_type", extractorType);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<SignalsIWLExtractor> {
        SignalsIWLExtractor lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"domain_uri", "event_type", "extractor_config", "extractor_type", "id"};

        @Override
        public SignalsIWLExtractor getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public SignalsIWLExtractor parseResponse(String response) throws APIException {
            return SignalsIWLExtractor.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public SignalsIWLExtractor execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public SignalsIWLExtractor execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<SignalsIWLExtractor> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<SignalsIWLExtractor> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, SignalsIWLExtractor>(){

                public SignalsIWLExtractor apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDomainUriField() {
            return this.requestDomainUriField(true);
        }

        public APIRequestGet requestDomainUriField(boolean value) {
            this.requestField("domain_uri", value);
            return this;
        }

        public APIRequestGet requestEventTypeField() {
            return this.requestEventTypeField(true);
        }

        public APIRequestGet requestEventTypeField(boolean value) {
            this.requestField("event_type", value);
            return this;
        }

        public APIRequestGet requestExtractorConfigField() {
            return this.requestExtractorConfigField(true);
        }

        public APIRequestGet requestExtractorConfigField(boolean value) {
            this.requestField("extractor_config", value);
            return this;
        }

        public APIRequestGet requestExtractorTypeField() {
            return this.requestExtractorTypeField(true);
        }

        public APIRequestGet requestExtractorTypeField(boolean value) {
            this.requestField("extractor_type", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

