/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.User;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recommendation
extends APINode {
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="has_rating")
    private Boolean mHasRating = null;
    @SerializedName(value="has_review")
    private Boolean mHasReview = null;
    @SerializedName(value="open_graph_story")
    private Object mOpenGraphStory = null;
    @SerializedName(value="rating")
    private Long mRating = null;
    @SerializedName(value="recommendation_type")
    private String mRecommendationType = null;
    @SerializedName(value="review_text")
    private String mReviewText = null;
    @SerializedName(value="reviewer")
    private User mReviewer = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Recommendation loadJSON(String json, APIContext context) {
        Recommendation recommendation = (Recommendation)Recommendation.getGson().fromJson(json, Recommendation.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(recommendation.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        recommendation.context = context;
        recommendation.rawValue = json;
        return recommendation;
    }

    public static APINodeList<Recommendation> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Recommendation> recommendations = new APINodeList<Recommendation>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        recommendations.add(Recommendation.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return recommendations;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            recommendations.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        recommendations.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            recommendations.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            recommendations.add(Recommendation.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                recommendations.add(Recommendation.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            recommendations.add(Recommendation.loadJSON(obj.toString(), context));
                        }
                    }
                    return recommendations;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        recommendations.add(Recommendation.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return recommendations;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        recommendations.add(Recommendation.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return recommendations;
                }
                recommendations.clear();
                recommendations.add(Recommendation.loadJSON(json, context));
                return recommendations;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Recommendation.getGson().toJson((Object)this);
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public Recommendation setFieldCreatedTime(String value) {
        this.mCreatedTime = value;
        return this;
    }

    public Boolean getFieldHasRating() {
        return this.mHasRating;
    }

    public Recommendation setFieldHasRating(Boolean value) {
        this.mHasRating = value;
        return this;
    }

    public Boolean getFieldHasReview() {
        return this.mHasReview;
    }

    public Recommendation setFieldHasReview(Boolean value) {
        this.mHasReview = value;
        return this;
    }

    public Object getFieldOpenGraphStory() {
        return this.mOpenGraphStory;
    }

    public Recommendation setFieldOpenGraphStory(Object value) {
        this.mOpenGraphStory = value;
        return this;
    }

    public Long getFieldRating() {
        return this.mRating;
    }

    public Recommendation setFieldRating(Long value) {
        this.mRating = value;
        return this;
    }

    public String getFieldRecommendationType() {
        return this.mRecommendationType;
    }

    public Recommendation setFieldRecommendationType(String value) {
        this.mRecommendationType = value;
        return this;
    }

    public String getFieldReviewText() {
        return this.mReviewText;
    }

    public Recommendation setFieldReviewText(String value) {
        this.mReviewText = value;
        return this;
    }

    public User getFieldReviewer() {
        if (this.mReviewer != null) {
            this.mReviewer.context = this.getContext();
        }
        return this.mReviewer;
    }

    public Recommendation setFieldReviewer(User value) {
        this.mReviewer = value;
        return this;
    }

    public Recommendation setFieldReviewer(String value) {
        Type type = new TypeToken<User>(){}.getType();
        this.mReviewer = (User)User.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Recommendation setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Recommendation copyFrom(Recommendation instance) {
        this.mCreatedTime = instance.mCreatedTime;
        this.mHasRating = instance.mHasRating;
        this.mHasReview = instance.mHasReview;
        this.mOpenGraphStory = instance.mOpenGraphStory;
        this.mRating = instance.mRating;
        this.mRecommendationType = instance.mRecommendationType;
        this.mReviewText = instance.mReviewText;
        this.mReviewer = instance.mReviewer;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Recommendation> getParser() {
        return new APIRequest.ResponseParser<Recommendation>(){

            @Override
            public APINodeList<Recommendation> parseResponse(String response, APIContext context, APIRequest<Recommendation> request) throws APIException.MalformedResponseException {
                return Recommendation.parseResponse(response, context, request);
            }
        };
    }
}

