/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReachFrequencyEstimatesCurve
extends APINode {
    @SerializedName(value="budget")
    private List<Long> mBudget = null;
    @SerializedName(value="click")
    private List<Long> mClick = null;
    @SerializedName(value="conversion")
    private List<Long> mConversion = null;
    @SerializedName(value="impression")
    private List<Long> mImpression = null;
    @SerializedName(value="interpolated_reach")
    private Double mInterpolatedReach = null;
    @SerializedName(value="num_points")
    private Long mNumPoints = null;
    @SerializedName(value="raw_impression")
    private List<Long> mRawImpression = null;
    @SerializedName(value="raw_reach")
    private List<Long> mRawReach = null;
    @SerializedName(value="reach")
    private List<Long> mReach = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ReachFrequencyEstimatesCurve loadJSON(String json, APIContext context) {
        ReachFrequencyEstimatesCurve reachFrequencyEstimatesCurve = (ReachFrequencyEstimatesCurve)ReachFrequencyEstimatesCurve.getGson().fromJson(json, ReachFrequencyEstimatesCurve.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(reachFrequencyEstimatesCurve.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        reachFrequencyEstimatesCurve.context = context;
        reachFrequencyEstimatesCurve.rawValue = json;
        return reachFrequencyEstimatesCurve;
    }

    public static APINodeList<ReachFrequencyEstimatesCurve> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ReachFrequencyEstimatesCurve> reachFrequencyEstimatesCurves = new APINodeList<ReachFrequencyEstimatesCurve>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        reachFrequencyEstimatesCurves.add(ReachFrequencyEstimatesCurve.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return reachFrequencyEstimatesCurves;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            reachFrequencyEstimatesCurves.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        reachFrequencyEstimatesCurves.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            reachFrequencyEstimatesCurves.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            reachFrequencyEstimatesCurves.add(ReachFrequencyEstimatesCurve.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                reachFrequencyEstimatesCurves.add(ReachFrequencyEstimatesCurve.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            reachFrequencyEstimatesCurves.add(ReachFrequencyEstimatesCurve.loadJSON(obj.toString(), context));
                        }
                    }
                    return reachFrequencyEstimatesCurves;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        reachFrequencyEstimatesCurves.add(ReachFrequencyEstimatesCurve.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return reachFrequencyEstimatesCurves;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        reachFrequencyEstimatesCurves.add(ReachFrequencyEstimatesCurve.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return reachFrequencyEstimatesCurves;
                }
                reachFrequencyEstimatesCurves.clear();
                reachFrequencyEstimatesCurves.add(ReachFrequencyEstimatesCurve.loadJSON(json, context));
                return reachFrequencyEstimatesCurves;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ReachFrequencyEstimatesCurve.getGson().toJson((Object)this);
    }

    public List<Long> getFieldBudget() {
        return this.mBudget;
    }

    public ReachFrequencyEstimatesCurve setFieldBudget(List<Long> value) {
        this.mBudget = value;
        return this;
    }

    public List<Long> getFieldClick() {
        return this.mClick;
    }

    public ReachFrequencyEstimatesCurve setFieldClick(List<Long> value) {
        this.mClick = value;
        return this;
    }

    public List<Long> getFieldConversion() {
        return this.mConversion;
    }

    public ReachFrequencyEstimatesCurve setFieldConversion(List<Long> value) {
        this.mConversion = value;
        return this;
    }

    public List<Long> getFieldImpression() {
        return this.mImpression;
    }

    public ReachFrequencyEstimatesCurve setFieldImpression(List<Long> value) {
        this.mImpression = value;
        return this;
    }

    public Double getFieldInterpolatedReach() {
        return this.mInterpolatedReach;
    }

    public ReachFrequencyEstimatesCurve setFieldInterpolatedReach(Double value) {
        this.mInterpolatedReach = value;
        return this;
    }

    public Long getFieldNumPoints() {
        return this.mNumPoints;
    }

    public ReachFrequencyEstimatesCurve setFieldNumPoints(Long value) {
        this.mNumPoints = value;
        return this;
    }

    public List<Long> getFieldRawImpression() {
        return this.mRawImpression;
    }

    public ReachFrequencyEstimatesCurve setFieldRawImpression(List<Long> value) {
        this.mRawImpression = value;
        return this;
    }

    public List<Long> getFieldRawReach() {
        return this.mRawReach;
    }

    public ReachFrequencyEstimatesCurve setFieldRawReach(List<Long> value) {
        this.mRawReach = value;
        return this;
    }

    public List<Long> getFieldReach() {
        return this.mReach;
    }

    public ReachFrequencyEstimatesCurve setFieldReach(List<Long> value) {
        this.mReach = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public ReachFrequencyEstimatesCurve setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ReachFrequencyEstimatesCurve copyFrom(ReachFrequencyEstimatesCurve instance) {
        this.mBudget = instance.mBudget;
        this.mClick = instance.mClick;
        this.mConversion = instance.mConversion;
        this.mImpression = instance.mImpression;
        this.mInterpolatedReach = instance.mInterpolatedReach;
        this.mNumPoints = instance.mNumPoints;
        this.mRawImpression = instance.mRawImpression;
        this.mRawReach = instance.mRawReach;
        this.mReach = instance.mReach;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ReachFrequencyEstimatesCurve> getParser() {
        return new APIRequest.ResponseParser<ReachFrequencyEstimatesCurve>(){

            @Override
            public APINodeList<ReachFrequencyEstimatesCurve> parseResponse(String response, APIContext context, APIRequest<ReachFrequencyEstimatesCurve> request) throws APIException.MalformedResponseException {
                return ReachFrequencyEstimatesCurve.parseResponse(response, context, request);
            }
        };
    }
}

