/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobileAppAlert
extends APINode {
    @SerializedName(value="cancel_button")
    private Object mCancelButton = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="ok_button")
    private Object mOkButton = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static MobileAppAlert loadJSON(String json, APIContext context) {
        MobileAppAlert mobileAppAlert = (MobileAppAlert)MobileAppAlert.getGson().fromJson(json, MobileAppAlert.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(mobileAppAlert.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        mobileAppAlert.context = context;
        mobileAppAlert.rawValue = json;
        return mobileAppAlert;
    }

    public static APINodeList<MobileAppAlert> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<MobileAppAlert> mobileAppAlerts = new APINodeList<MobileAppAlert>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        mobileAppAlerts.add(MobileAppAlert.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return mobileAppAlerts;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            mobileAppAlerts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        mobileAppAlerts.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            mobileAppAlerts.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            mobileAppAlerts.add(MobileAppAlert.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                mobileAppAlerts.add(MobileAppAlert.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            mobileAppAlerts.add(MobileAppAlert.loadJSON(obj.toString(), context));
                        }
                    }
                    return mobileAppAlerts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        mobileAppAlerts.add(MobileAppAlert.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return mobileAppAlerts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        mobileAppAlerts.add(MobileAppAlert.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return mobileAppAlerts;
                }
                mobileAppAlerts.clear();
                mobileAppAlerts.add(MobileAppAlert.loadJSON(json, context));
                return mobileAppAlerts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MobileAppAlert.getGson().toJson((Object)this);
    }

    public Object getFieldCancelButton() {
        return this.mCancelButton;
    }

    public MobileAppAlert setFieldCancelButton(Object value) {
        this.mCancelButton = value;
        return this;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public MobileAppAlert setFieldMessage(String value) {
        this.mMessage = value;
        return this;
    }

    public Object getFieldOkButton() {
        return this.mOkButton;
    }

    public MobileAppAlert setFieldOkButton(Object value) {
        this.mOkButton = value;
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public MobileAppAlert setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public MobileAppAlert setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MobileAppAlert copyFrom(MobileAppAlert instance) {
        this.mCancelButton = instance.mCancelButton;
        this.mMessage = instance.mMessage;
        this.mOkButton = instance.mOkButton;
        this.mTitle = instance.mTitle;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MobileAppAlert> getParser() {
        return new APIRequest.ResponseParser<MobileAppAlert>(){

            @Override
            public APINodeList<MobileAppAlert> parseResponse(String response, APIContext context, APIRequest<MobileAppAlert> request) throws APIException.MalformedResponseException {
                return MobileAppAlert.parseResponse(response, context, request);
            }
        };
    }
}

