/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsightsResult
extends APINode {
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="description_from_api_doc")
    private String mDescriptionFromApiDoc = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="period")
    private String mPeriod = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="values")
    private List<Object> mValues = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static InsightsResult loadJSON(String json, APIContext context) {
        InsightsResult insightsResult = (InsightsResult)InsightsResult.getGson().fromJson(json, InsightsResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(insightsResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        insightsResult.context = context;
        insightsResult.rawValue = json;
        return insightsResult;
    }

    public static APINodeList<InsightsResult> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<InsightsResult> insightsResults = new APINodeList<InsightsResult>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        insightsResults.add(InsightsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return insightsResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            insightsResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        insightsResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            insightsResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            insightsResults.add(InsightsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                insightsResults.add(InsightsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            insightsResults.add(InsightsResult.loadJSON(obj.toString(), context));
                        }
                    }
                    return insightsResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        insightsResults.add(InsightsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return insightsResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        insightsResults.add(InsightsResult.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return insightsResults;
                }
                insightsResults.clear();
                insightsResults.add(InsightsResult.loadJSON(json, context));
                return insightsResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return InsightsResult.getGson().toJson((Object)this);
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public InsightsResult setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public String getFieldDescriptionFromApiDoc() {
        return this.mDescriptionFromApiDoc;
    }

    public InsightsResult setFieldDescriptionFromApiDoc(String value) {
        this.mDescriptionFromApiDoc = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public InsightsResult setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public InsightsResult setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldPeriod() {
        return this.mPeriod;
    }

    public InsightsResult setFieldPeriod(String value) {
        this.mPeriod = value;
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public InsightsResult setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    public List<Object> getFieldValues() {
        return this.mValues;
    }

    public InsightsResult setFieldValues(List<Object> value) {
        this.mValues = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public InsightsResult copyFrom(InsightsResult instance) {
        this.mDescription = instance.mDescription;
        this.mDescriptionFromApiDoc = instance.mDescriptionFromApiDoc;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mPeriod = instance.mPeriod;
        this.mTitle = instance.mTitle;
        this.mValues = instance.mValues;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<InsightsResult> getParser() {
        return new APIRequest.ResponseParser<InsightsResult>(){

            @Override
            public APINodeList<InsightsResult> parseResponse(String response, APIContext context, APIRequest<InsightsResult> request) throws APIException.MalformedResponseException {
                return InsightsResult.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPeriod {
        VALUE_DAY("day"),
        VALUE_WEEK("week"),
        VALUE_DAYS_28("days_28"),
        VALUE_MONTH("month"),
        VALUE_LIFETIME("lifetime"),
        NULL(null);

        private String value;

        private EnumPeriod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumDatePreset {
        VALUE_TODAY("today"),
        VALUE_YESTERDAY("yesterday"),
        VALUE_THIS_MONTH("this_month"),
        VALUE_LAST_MONTH("last_month"),
        VALUE_THIS_QUARTER("this_quarter"),
        VALUE_LIFETIME("lifetime"),
        VALUE_LAST_3D("last_3d"),
        VALUE_LAST_7D("last_7d"),
        VALUE_LAST_14D("last_14d"),
        VALUE_LAST_28D("last_28d"),
        VALUE_LAST_30D("last_30d"),
        VALUE_LAST_90D("last_90d"),
        VALUE_LAST_WEEK_MON_SUN("last_week_mon_sun"),
        VALUE_LAST_WEEK_SUN_SAT("last_week_sun_sat"),
        VALUE_LAST_QUARTER("last_quarter"),
        VALUE_LAST_YEAR("last_year"),
        VALUE_THIS_WEEK_MON_TODAY("this_week_mon_today"),
        VALUE_THIS_WEEK_SUN_TODAY("this_week_sun_today"),
        VALUE_THIS_YEAR("this_year"),
        NULL(null);

        private String value;

        private EnumDatePreset(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumMetric {
        VALUE_MESSAGES_SENT("messages_sent"),
        NULL(null);

        private String value;

        private EnumMetric(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

