/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.AdContract;
import com.facebook.ads.sdk.AdMonetizationProperty;
import com.facebook.ads.sdk.AdStudy;
import com.facebook.ads.sdk.AdVideo;
import com.facebook.ads.sdk.AgeRange;
import com.facebook.ads.sdk.Album;
import com.facebook.ads.sdk.AppRequest;
import com.facebook.ads.sdk.AppRequestFormerRecipient;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.BusinessActivityLogEvent;
import com.facebook.ads.sdk.BusinessUser;
import com.facebook.ads.sdk.Canvas;
import com.facebook.ads.sdk.Currency;
import com.facebook.ads.sdk.Domain;
import com.facebook.ads.sdk.EducationExperience;
import com.facebook.ads.sdk.Event;
import com.facebook.ads.sdk.Experience;
import com.facebook.ads.sdk.FavoriteRequest;
import com.facebook.ads.sdk.FriendList;
import com.facebook.ads.sdk.Group;
import com.facebook.ads.sdk.Link;
import com.facebook.ads.sdk.LiveVideo;
import com.facebook.ads.sdk.Location;
import com.facebook.ads.sdk.OpenGraphObject;
import com.facebook.ads.sdk.Page;
import com.facebook.ads.sdk.PageAdminNote;
import com.facebook.ads.sdk.PageLabel;
import com.facebook.ads.sdk.PageUserMessageThreadLabel;
import com.facebook.ads.sdk.PaymentPricepoints;
import com.facebook.ads.sdk.Permission;
import com.facebook.ads.sdk.Photo;
import com.facebook.ads.sdk.PlaceTag;
import com.facebook.ads.sdk.PlatformSessionKey;
import com.facebook.ads.sdk.ProductCatalog;
import com.facebook.ads.sdk.ProfilePictureSource;
import com.facebook.ads.sdk.RequestHistory;
import com.facebook.ads.sdk.SecuritySettings;
import com.facebook.ads.sdk.StreamFilter;
import com.facebook.ads.sdk.UnifiedThread;
import com.facebook.ads.sdk.UserContext;
import com.facebook.ads.sdk.UserCoverPhoto;
import com.facebook.ads.sdk.UserDevice;
import com.facebook.ads.sdk.UserIDForApp;
import com.facebook.ads.sdk.UserIDForPage;
import com.facebook.ads.sdk.UserInvitableFriend;
import com.facebook.ads.sdk.UserTaggableFriend;
import com.facebook.ads.sdk.VideoUploadLimits;
import com.facebook.ads.sdk.WithAsset3D;
import com.facebook.ads.sdk.WorkExperience;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends APINode {
    @SerializedName(value="about")
    private String mAbout = null;
    @SerializedName(value="address")
    private Location mAddress = null;
    @SerializedName(value="admin_notes")
    private List<PageAdminNote> mAdminNotes = null;
    @SerializedName(value="age_range")
    private AgeRange mAgeRange = null;
    @SerializedName(value="bio")
    private String mBio = null;
    @SerializedName(value="birthday")
    private String mBirthday = null;
    @SerializedName(value="can_review_measurement_request")
    private Boolean mCanReviewMeasurementRequest = null;
    @SerializedName(value="context")
    private UserContext mContext = null;
    @SerializedName(value="cover")
    private UserCoverPhoto mCover = null;
    @SerializedName(value="currency")
    private Currency mCurrency = null;
    @SerializedName(value="devices")
    private List<UserDevice> mDevices = null;
    @SerializedName(value="education")
    private List<EducationExperience> mEducation = null;
    @SerializedName(value="email")
    private String mEmail = null;
    @SerializedName(value="employee_number")
    private String mEmployeeNumber = null;
    @SerializedName(value="favorite_athletes")
    private List<Experience> mFavoriteAthletes = null;
    @SerializedName(value="favorite_teams")
    private List<Experience> mFavoriteTeams = null;
    @SerializedName(value="first_name")
    private String mFirstName = null;
    @SerializedName(value="gender")
    private String mGender = null;
    @SerializedName(value="hometown")
    private Page mHometown = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="inspirational_people")
    private List<Experience> mInspirationalPeople = null;
    @SerializedName(value="install_type")
    private String mInstallType = null;
    @SerializedName(value="installed")
    private Boolean mInstalled = null;
    @SerializedName(value="interested_in")
    private List<String> mInterestedIn = null;
    @SerializedName(value="is_famedeeplinkinguser")
    private Boolean mIsFamedeeplinkinguser = null;
    @SerializedName(value="is_shared_login")
    private Boolean mIsSharedLogin = null;
    @SerializedName(value="is_verified")
    private Boolean mIsVerified = null;
    @SerializedName(value="labels")
    private List<PageLabel> mLabels = null;
    @SerializedName(value="languages")
    private List<Experience> mLanguages = null;
    @SerializedName(value="last_name")
    private String mLastName = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="local_news_megaphone_dismiss_status")
    private Boolean mLocalNewsMegaphoneDismissStatus = null;
    @SerializedName(value="local_news_subscription_status")
    private Boolean mLocalNewsSubscriptionStatus = null;
    @SerializedName(value="locale")
    private String mLocale = null;
    @SerializedName(value="location")
    private Page mLocation = null;
    @SerializedName(value="meeting_for")
    private List<String> mMeetingFor = null;
    @SerializedName(value="middle_name")
    private String mMiddleName = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="name_format")
    private String mNameFormat = null;
    @SerializedName(value="payment_pricepoints")
    private PaymentPricepoints mPaymentPricepoints = null;
    @SerializedName(value="political")
    private String mPolitical = null;
    @SerializedName(value="profile_pic")
    private String mProfilePic = null;
    @SerializedName(value="public_key")
    private String mPublicKey = null;
    @SerializedName(value="quotes")
    private String mQuotes = null;
    @SerializedName(value="relationship_status")
    private String mRelationshipStatus = null;
    @SerializedName(value="religion")
    private String mReligion = null;
    @SerializedName(value="security_settings")
    private SecuritySettings mSecuritySettings = null;
    @SerializedName(value="shared_login_upgrade_required_by")
    private String mSharedLoginUpgradeRequiredBy = null;
    @SerializedName(value="short_name")
    private String mShortName = null;
    @SerializedName(value="significant_other")
    private User mSignificantOther = null;
    @SerializedName(value="sports")
    private List<Experience> mSports = null;
    @SerializedName(value="test_group")
    private Long mTestGroup = null;
    @SerializedName(value="third_party_id")
    private String mThirdPartyId = null;
    @SerializedName(value="timezone")
    private Double mTimezone = null;
    @SerializedName(value="token_for_business")
    private String mTokenForBusiness = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="username")
    private String mUsername = null;
    @SerializedName(value="verified")
    private Boolean mVerified = null;
    @SerializedName(value="video_upload_limits")
    private VideoUploadLimits mVideoUploadLimits = null;
    @SerializedName(value="viewer_can_send_gift")
    private Boolean mViewerCanSendGift = null;
    @SerializedName(value="website")
    private String mWebsite = null;
    @SerializedName(value="work")
    private List<WorkExperience> mWork = null;
    protected static Gson gson = null;

    User() {
    }

    public User(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public User(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public User fetch() throws APIException {
        User newInstance = User.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static User fetchById(Long id, APIContext context) throws APIException {
        return User.fetchById(id.toString(), context);
    }

    public static ListenableFuture<User> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return User.fetchByIdAsync(id.toString(), context);
    }

    public static User fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<User> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<User> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<User>(context, "", "/", "GET", User.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<User>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<User>(context, "", "/", "GET", User.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static User loadJSON(String json, APIContext context) {
        User user = (User)User.getGson().fromJson(json, User.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(user.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        user.context = context;
        user.rawValue = json;
        return user;
    }

    public static APINodeList<User> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<User> users = new APINodeList<User>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        users.add(User.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return users;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            users.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        users.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            users.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            users.add(User.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                users.add(User.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            users.add(User.loadJSON(obj.toString(), context));
                        }
                    }
                    return users;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        users.add(User.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return users;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        users.add(User.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return users;
                }
                users.clear();
                users.add(User.loadJSON(json, context));
                return users;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return User.getGson().toJson((Object)this);
    }

    public APIRequestCreatePaymentCurrency createPaymentCurrency() {
        return new APIRequestCreatePaymentCurrency(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAccessToken createAccessToken() {
        return new APIRequestCreateAccessToken(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteAccessTokens deleteAccessTokens() {
        return new APIRequestDeleteAccessTokens(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAccounts getAccounts() {
        return new APIRequestGetAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAccount createAccount() {
        return new APIRequestCreateAccount(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAchievements getAchievements() {
        return new APIRequestGetAchievements(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAchievement createAchievement() {
        return new APIRequestCreateAchievement(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdStudies getAdStudies() {
        return new APIRequestGetAdStudies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdAccounts getAdAccounts() {
        return new APIRequestGetAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdContracts getAdContracts() {
        return new APIRequestGetAdContracts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAlbums getAlbums() {
        return new APIRequestGetAlbums(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAlbum createAlbum() {
        return new APIRequestCreateAlbum(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateApplication createApplication() {
        return new APIRequestCreateApplication(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAppRequestFormerRecipients getAppRequestFormerRecipients() {
        return new APIRequestGetAppRequestFormerRecipients(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAppRequests getAppRequests() {
        return new APIRequestGetAppRequests(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAsset3Ds getAsset3Ds() {
        return new APIRequestGetAsset3Ds(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAssignedAdAccounts getAssignedAdAccounts() {
        return new APIRequestGetAssignedAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAssignedMonetizationProperties getAssignedMonetizationProperties() {
        return new APIRequestGetAssignedMonetizationProperties(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAssignedPages getAssignedPages() {
        return new APIRequestGetAssignedPages(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAssignedProductCatalogs getAssignedProductCatalogs() {
        return new APIRequestGetAssignedProductCatalogs(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetBooks getBooks() {
        return new APIRequestGetBooks(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteBulkContacts deleteBulkContacts() {
        return new APIRequestDeleteBulkContacts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetBusinessActivities getBusinessActivities() {
        return new APIRequestGetBusinessActivities(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetBusinessUsers getBusinessUsers() {
        return new APIRequestGetBusinessUsers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteBusinesses deleteBusinesses() {
        return new APIRequestDeleteBusinesses(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetBusinesses getBusinesses() {
        return new APIRequestGetBusinesses(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateCheckin createCheckin() {
        return new APIRequestCreateCheckin(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetConversations getConversations() {
        return new APIRequestGetConversations(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetCustomLabels getCustomLabels() {
        return new APIRequestGetCustomLabels(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetDomains getDomains() {
        return new APIRequestGetDomains(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetEvents getEvents() {
        return new APIRequestGetEvents(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateEvent createEvent() {
        return new APIRequestCreateEvent(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetFamily getFamily() {
        return new APIRequestGetFamily(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetFavoriteRequests getFavoriteRequests() {
        return new APIRequestGetFavoriteRequests(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateFavoriteRequest createFavoriteRequest() {
        return new APIRequestCreateFavoriteRequest(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateFeed createFeed() {
        return new APIRequestCreateFeed(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetFriendLists getFriendLists() {
        return new APIRequestGetFriendLists(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateFriendList createFriendList() {
        return new APIRequestCreateFriendList(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetFriends getFriends() {
        return new APIRequestGetFriends(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateGameItem createGameItem() {
        return new APIRequestCreateGameItem(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateGameTime createGameTime() {
        return new APIRequestCreateGameTime(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetGames getGames() {
        return new APIRequestGetGames(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateGamesStat createGamesStat() {
        return new APIRequestCreateGamesStat(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateGamesAchieve createGamesAchieve() {
        return new APIRequestCreateGamesAchieve(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateGamesPlay createGamesPlay() {
        return new APIRequestCreateGamesPlay(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetGroups getGroups() {
        return new APIRequestGetGroups(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetIdsForApps getIdsForApps() {
        return new APIRequestGetIdsForApps(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetIdsForBusiness getIdsForBusiness() {
        return new APIRequestGetIdsForBusiness(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetIdsForPages getIdsForPages() {
        return new APIRequestGetIdsForPages(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetInvitableFriends getInvitableFriends() {
        return new APIRequestGetInvitableFriends(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteLikes deleteLikes() {
        return new APIRequestDeleteLikes(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetLikes getLikes() {
        return new APIRequestGetLikes(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateLike createLike() {
        return new APIRequestCreateLike(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateLink createLink() {
        return new APIRequestCreateLink(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateLiveEncoder createLiveEncoder() {
        return new APIRequestCreateLiveEncoder(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetLiveVideos getLiveVideos() {
        return new APIRequestGetLiveVideos(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateLiveVideo createLiveVideo() {
        return new APIRequestCreateLiveVideo(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateLocationupdate createLocationupdate() {
        return new APIRequestCreateLocationupdate(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateLoggedOutPushSetNonce createLoggedOutPushSetNonce() {
        return new APIRequestCreateLoggedOutPushSetNonce(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateLogInApprovalsKey createLogInApprovalsKey() {
        return new APIRequestCreateLogInApprovalsKey(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateMfsAccountPinReset createMfsAccountPinReset() {
        return new APIRequestCreateMfsAccountPinReset(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateMomentsLinkInvite createMomentsLinkInvite() {
        return new APIRequestCreateMomentsLinkInvite(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateMomentsLinkInviteConvert createMomentsLinkInviteConvert() {
        return new APIRequestCreateMomentsLinkInviteConvert(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateMomentsUniversalLinkInvite createMomentsUniversalLinkInvite() {
        return new APIRequestCreateMomentsUniversalLinkInvite(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetMovies getMovies() {
        return new APIRequestGetMovies(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetMusic getMusic() {
        return new APIRequestGetMusic(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateNote createNote() {
        return new APIRequestCreateNote(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateNotification createNotification() {
        return new APIRequestCreateNotification(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetObjects getObjects() {
        return new APIRequestGetObjects(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateObject createObject() {
        return new APIRequestCreateObject(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateOpenGraphActionFeed createOpenGraphActionFeed() {
        return new APIRequestCreateOpenGraphActionFeed(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreatePaymentAccountEmail createPaymentAccountEmail() {
        return new APIRequestCreatePaymentAccountEmail(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreatePaymentAccountPhone createPaymentAccountPhone() {
        return new APIRequestCreatePaymentAccountPhone(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeletePermissions deletePermissions() {
        return new APIRequestDeletePermissions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPermissions getPermissions() {
        return new APIRequestGetPermissions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPersonalAdAccounts getPersonalAdAccounts() {
        return new APIRequestGetPersonalAdAccounts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPhotos getPhotos() {
        return new APIRequestGetPhotos(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreatePhoto createPhoto() {
        return new APIRequestCreatePhoto(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPicture getPicture() {
        return new APIRequestGetPicture(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreatePlace createPlace() {
        return new APIRequestCreatePlace(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPromotableDomains getPromotableDomains() {
        return new APIRequestGetPromotableDomains(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPromotableEvents getPromotableEvents() {
        return new APIRequestGetPromotableEvents(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetRequestHistory getRequestHistory() {
        return new APIRequestGetRequestHistory(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetRichMediaDocuments getRichMediaDocuments() {
        return new APIRequestGetRichMediaDocuments(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteScreenNames deleteScreenNames() {
        return new APIRequestDeleteScreenNames(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateScreenName createScreenName() {
        return new APIRequestCreateScreenName(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetSessionKeys getSessionKeys() {
        return new APIRequestGetSessionKeys(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateStagingResource createStagingResource() {
        return new APIRequestCreateStagingResource(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetStreamFilters getStreamFilters() {
        return new APIRequestGetStreamFilters(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateSubscription createSubscription() {
        return new APIRequestCreateSubscription(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTaggableFriends getTaggableFriends() {
        return new APIRequestGetTaggableFriends(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTaggedPlaces getTaggedPlaces() {
        return new APIRequestGetTaggedPlaces(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTelevision getTelevision() {
        return new APIRequestGetTelevision(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetThreads getThreads() {
        return new APIRequestGetThreads(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetVideoBroadcasts getVideoBroadcasts() {
        return new APIRequestGetVideoBroadcasts(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetVideos getVideos() {
        return new APIRequestGetVideos(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateVideo createVideo() {
        return new APIRequestCreateVideo(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAbout() {
        return this.mAbout;
    }

    public Location getFieldAddress() {
        if (this.mAddress != null) {
            this.mAddress.context = this.getContext();
        }
        return this.mAddress;
    }

    public List<PageAdminNote> getFieldAdminNotes() {
        return this.mAdminNotes;
    }

    public AgeRange getFieldAgeRange() {
        if (this.mAgeRange != null) {
            this.mAgeRange.context = this.getContext();
        }
        return this.mAgeRange;
    }

    public String getFieldBio() {
        return this.mBio;
    }

    public String getFieldBirthday() {
        return this.mBirthday;
    }

    public Boolean getFieldCanReviewMeasurementRequest() {
        return this.mCanReviewMeasurementRequest;
    }

    public UserContext getFieldContext() {
        if (this.mContext != null) {
            this.mContext.context = this.getContext();
        }
        return this.mContext;
    }

    public UserCoverPhoto getFieldCover() {
        if (this.mCover != null) {
            this.mCover.context = this.getContext();
        }
        return this.mCover;
    }

    public Currency getFieldCurrency() {
        if (this.mCurrency != null) {
            this.mCurrency.context = this.getContext();
        }
        return this.mCurrency;
    }

    public List<UserDevice> getFieldDevices() {
        return this.mDevices;
    }

    public List<EducationExperience> getFieldEducation() {
        return this.mEducation;
    }

    public String getFieldEmail() {
        return this.mEmail;
    }

    public String getFieldEmployeeNumber() {
        return this.mEmployeeNumber;
    }

    public List<Experience> getFieldFavoriteAthletes() {
        return this.mFavoriteAthletes;
    }

    public List<Experience> getFieldFavoriteTeams() {
        return this.mFavoriteTeams;
    }

    public String getFieldFirstName() {
        return this.mFirstName;
    }

    public String getFieldGender() {
        return this.mGender;
    }

    public Page getFieldHometown() {
        if (this.mHometown != null) {
            this.mHometown.context = this.getContext();
        }
        return this.mHometown;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<Experience> getFieldInspirationalPeople() {
        return this.mInspirationalPeople;
    }

    public String getFieldInstallType() {
        return this.mInstallType;
    }

    public Boolean getFieldInstalled() {
        return this.mInstalled;
    }

    public List<String> getFieldInterestedIn() {
        return this.mInterestedIn;
    }

    public Boolean getFieldIsFamedeeplinkinguser() {
        return this.mIsFamedeeplinkinguser;
    }

    public Boolean getFieldIsSharedLogin() {
        return this.mIsSharedLogin;
    }

    public Boolean getFieldIsVerified() {
        return this.mIsVerified;
    }

    public List<PageLabel> getFieldLabels() {
        return this.mLabels;
    }

    public List<Experience> getFieldLanguages() {
        return this.mLanguages;
    }

    public String getFieldLastName() {
        return this.mLastName;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public Boolean getFieldLocalNewsMegaphoneDismissStatus() {
        return this.mLocalNewsMegaphoneDismissStatus;
    }

    public Boolean getFieldLocalNewsSubscriptionStatus() {
        return this.mLocalNewsSubscriptionStatus;
    }

    public String getFieldLocale() {
        return this.mLocale;
    }

    public Page getFieldLocation() {
        if (this.mLocation != null) {
            this.mLocation.context = this.getContext();
        }
        return this.mLocation;
    }

    public List<String> getFieldMeetingFor() {
        return this.mMeetingFor;
    }

    public String getFieldMiddleName() {
        return this.mMiddleName;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldNameFormat() {
        return this.mNameFormat;
    }

    public PaymentPricepoints getFieldPaymentPricepoints() {
        if (this.mPaymentPricepoints != null) {
            this.mPaymentPricepoints.context = this.getContext();
        }
        return this.mPaymentPricepoints;
    }

    public String getFieldPolitical() {
        return this.mPolitical;
    }

    public String getFieldProfilePic() {
        return this.mProfilePic;
    }

    public String getFieldPublicKey() {
        return this.mPublicKey;
    }

    public String getFieldQuotes() {
        return this.mQuotes;
    }

    public String getFieldRelationshipStatus() {
        return this.mRelationshipStatus;
    }

    public String getFieldReligion() {
        return this.mReligion;
    }

    public SecuritySettings getFieldSecuritySettings() {
        if (this.mSecuritySettings != null) {
            this.mSecuritySettings.context = this.getContext();
        }
        return this.mSecuritySettings;
    }

    public String getFieldSharedLoginUpgradeRequiredBy() {
        return this.mSharedLoginUpgradeRequiredBy;
    }

    public String getFieldShortName() {
        return this.mShortName;
    }

    public User getFieldSignificantOther() {
        if (this.mSignificantOther != null) {
            this.mSignificantOther.context = this.getContext();
        }
        return this.mSignificantOther;
    }

    public List<Experience> getFieldSports() {
        return this.mSports;
    }

    public Long getFieldTestGroup() {
        return this.mTestGroup;
    }

    public String getFieldThirdPartyId() {
        return this.mThirdPartyId;
    }

    public Double getFieldTimezone() {
        return this.mTimezone;
    }

    public String getFieldTokenForBusiness() {
        return this.mTokenForBusiness;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public String getFieldUsername() {
        return this.mUsername;
    }

    public Boolean getFieldVerified() {
        return this.mVerified;
    }

    public VideoUploadLimits getFieldVideoUploadLimits() {
        if (this.mVideoUploadLimits != null) {
            this.mVideoUploadLimits.context = this.getContext();
        }
        return this.mVideoUploadLimits;
    }

    public Boolean getFieldViewerCanSendGift() {
        return this.mViewerCanSendGift;
    }

    public String getFieldWebsite() {
        return this.mWebsite;
    }

    public List<WorkExperience> getFieldWork() {
        return this.mWork;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public User copyFrom(User instance) {
        this.mAbout = instance.mAbout;
        this.mAddress = instance.mAddress;
        this.mAdminNotes = instance.mAdminNotes;
        this.mAgeRange = instance.mAgeRange;
        this.mBio = instance.mBio;
        this.mBirthday = instance.mBirthday;
        this.mCanReviewMeasurementRequest = instance.mCanReviewMeasurementRequest;
        this.mContext = instance.mContext;
        this.mCover = instance.mCover;
        this.mCurrency = instance.mCurrency;
        this.mDevices = instance.mDevices;
        this.mEducation = instance.mEducation;
        this.mEmail = instance.mEmail;
        this.mEmployeeNumber = instance.mEmployeeNumber;
        this.mFavoriteAthletes = instance.mFavoriteAthletes;
        this.mFavoriteTeams = instance.mFavoriteTeams;
        this.mFirstName = instance.mFirstName;
        this.mGender = instance.mGender;
        this.mHometown = instance.mHometown;
        this.mId = instance.mId;
        this.mInspirationalPeople = instance.mInspirationalPeople;
        this.mInstallType = instance.mInstallType;
        this.mInstalled = instance.mInstalled;
        this.mInterestedIn = instance.mInterestedIn;
        this.mIsFamedeeplinkinguser = instance.mIsFamedeeplinkinguser;
        this.mIsSharedLogin = instance.mIsSharedLogin;
        this.mIsVerified = instance.mIsVerified;
        this.mLabels = instance.mLabels;
        this.mLanguages = instance.mLanguages;
        this.mLastName = instance.mLastName;
        this.mLink = instance.mLink;
        this.mLocalNewsMegaphoneDismissStatus = instance.mLocalNewsMegaphoneDismissStatus;
        this.mLocalNewsSubscriptionStatus = instance.mLocalNewsSubscriptionStatus;
        this.mLocale = instance.mLocale;
        this.mLocation = instance.mLocation;
        this.mMeetingFor = instance.mMeetingFor;
        this.mMiddleName = instance.mMiddleName;
        this.mName = instance.mName;
        this.mNameFormat = instance.mNameFormat;
        this.mPaymentPricepoints = instance.mPaymentPricepoints;
        this.mPolitical = instance.mPolitical;
        this.mProfilePic = instance.mProfilePic;
        this.mPublicKey = instance.mPublicKey;
        this.mQuotes = instance.mQuotes;
        this.mRelationshipStatus = instance.mRelationshipStatus;
        this.mReligion = instance.mReligion;
        this.mSecuritySettings = instance.mSecuritySettings;
        this.mSharedLoginUpgradeRequiredBy = instance.mSharedLoginUpgradeRequiredBy;
        this.mShortName = instance.mShortName;
        this.mSignificantOther = instance.mSignificantOther;
        this.mSports = instance.mSports;
        this.mTestGroup = instance.mTestGroup;
        this.mThirdPartyId = instance.mThirdPartyId;
        this.mTimezone = instance.mTimezone;
        this.mTokenForBusiness = instance.mTokenForBusiness;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mUsername = instance.mUsername;
        this.mVerified = instance.mVerified;
        this.mVideoUploadLimits = instance.mVideoUploadLimits;
        this.mViewerCanSendGift = instance.mViewerCanSendGift;
        this.mWebsite = instance.mWebsite;
        this.mWork = instance.mWork;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<User> getParser() {
        return new APIRequest.ResponseParser<User>(){

            @Override
            public APINodeList<User> parseResponse(String response, APIContext context, APIRequest<User> request) throws APIException.MalformedResponseException {
                return User.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPaymentType {
        VALUE_PAYMENT_SETTINGS("PAYMENT_SETTINGS"),
        VALUE_IG_PAYMENT_SETTINGS("IG_PAYMENT_SETTINGS"),
        VALUE_UNKNOWN("UNKNOWN"),
        VALUE_MP_PAYMENT_SETTINGS("MP_PAYMENT_SETTINGS"),
        VALUE_IAP_INSTANT_GAME("IAP_INSTANT_GAME"),
        VALUE_IAP_FAN_FUNDING("IAP_FAN_FUNDING"),
        VALUE_IAP_GROUP_SUBSCRIPTION("IAP_GROUP_SUBSCRIPTION"),
        VALUE_MOR_NONE("MOR_NONE"),
        VALUE_MOR_ADS_CONSENT("MOR_ADS_CONSENT"),
        VALUE_MOR_ADS_INVOICE("MOR_ADS_INVOICE"),
        VALUE_MOR_DONATIONS("MOR_DONATIONS"),
        VALUE_MOR_DONATIONS_MATCHING_CONFIRMATION("MOR_DONATIONS_MATCHING_CONFIRMATION"),
        VALUE_MOR_DONATIONS_MATCHING_PLEDGE("MOR_DONATIONS_MATCHING_PLEDGE"),
        VALUE_MOR_OCULUS_CV1("MOR_OCULUS_CV1"),
        VALUE_MOR_OCULUS_LAUNCH_V1("MOR_OCULUS_LAUNCH_V1"),
        VALUE_MOR_OCULUS_LAUNCH_V2("MOR_OCULUS_LAUNCH_V2"),
        VALUE_MOR_OZONE("MOR_OZONE"),
        VALUE_MOR_OPEN_GRAPH_PRODUCT("MOR_OPEN_GRAPH_PRODUCT"),
        VALUE_MOR_MESSENGER_COMMERCE("MOR_MESSENGER_COMMERCE"),
        VALUE_MOR_P2P_TRANSFER("MOR_P2P_TRANSFER"),
        VALUE_MOR_DUMMY_FIRST_PARTY("MOR_DUMMY_FIRST_PARTY"),
        VALUE_MOR_DUMMY_THIRD_PARTY("MOR_DUMMY_THIRD_PARTY"),
        VALUE_MOR_GIFTS("MOR_GIFTS"),
        VALUE_MOR_BILL("MOR_BILL"),
        VALUE_MOR_AIRMAIL("MOR_AIRMAIL"),
        VALUE_MOR_EVENT_TICKETING("MOR_EVENT_TICKETING"),
        VALUE_MOR_PAYMENT_LITE("MOR_PAYMENT_LITE"),
        VALUE_MOR_MESSENGER_API_FEE("MOR_MESSENGER_API_FEE"),
        VALUE_MOR_WORKPLACE_USAGE("MOR_WORKPLACE_USAGE"),
        VALUE_MOR_FACEBOOK_SHOP("MOR_FACEBOOK_SHOP"),
        VALUE_MOR_FAN_FUNDING("MOR_FAN_FUNDING"),
        VALUE_MOR_GAME_TIPPING_TOKEN("MOR_GAME_TIPPING_TOKEN"),
        VALUE_MOR_INSTANT_GAMES("MOR_INSTANT_GAMES"),
        VALUE_MOR_BLUEBIRD("MOR_BLUEBIRD"),
        VALUE_MOR_GROUP_SUBSCRIPTION("MOR_GROUP_SUBSCRIPTION"),
        VALUE_NMOR_UNKNOWN("NMOR_UNKNOWN"),
        VALUE_NMOR_NONE("NMOR_NONE"),
        VALUE_NMOR_PAGES_COMMERCE("NMOR_PAGES_COMMERCE"),
        VALUE_NMOR_COMPONENT_FLOW("NMOR_COMPONENT_FLOW"),
        VALUE_NMOR_BUSINESS_PLATFORM_COMMERCE("NMOR_BUSINESS_PLATFORM_COMMERCE"),
        VALUE_NMOR_SYNCHRONOUS_COMPONENT_FLOW("NMOR_SYNCHRONOUS_COMPONENT_FLOW"),
        VALUE_NMOR_EVENT_TICKETING("NMOR_EVENT_TICKETING"),
        VALUE_NMOR_PLATFORM_SELF_SERVE("NMOR_PLATFORM_SELF_SERVE"),
        VALUE_NMOR_MESSENGER_PLATFORM("NMOR_MESSENGER_PLATFORM"),
        VALUE_NMOR_MESSENGER_OMNIM("NMOR_MESSENGER_OMNIM"),
        VALUE_NMOR_BILLING_ENGINE("NMOR_BILLING_ENGINE"),
        VALUE_NMOR_TIP_JAR("NMOR_TIP_JAR"),
        VALUE_NMOR_INSTANT_EXPERIENCES("NMOR_INSTANT_EXPERIENCES"),
        VALUE_NMOR_CHECKOUT_EXPERIENCES("NMOR_CHECKOUT_EXPERIENCES"),
        VALUE_NMOR_BUY_ON_FACEBOOK("NMOR_BUY_ON_FACEBOOK"),
        VALUE_NMOR_PAYMENT_APP("NMOR_PAYMENT_APP"),
        VALUE_NMOR_DONATION_P4P("NMOR_DONATION_P4P"),
        VALUE_NMOR_WHATSAPP_P2P("NMOR_WHATSAPP_P2P"),
        VALUE_NMOR_P2P("NMOR_P2P"),
        VALUE_NMOR_MOBILE_TOP_UP("NMOR_MOBILE_TOP_UP"),
        VALUE_NMOR_MFS("NMOR_MFS"),
        VALUE_NMOR_SHIPPING_LABEL("NMOR_SHIPPING_LABEL"),
        VALUE_NMOR_MARKETPLACE_DROPOFF("NMOR_MARKETPLACE_DROPOFF"),
        VALUE_NMOR_PAGES_SOLUTION("NMOR_PAGES_SOLUTION"),
        VALUE_NMOR_BLACKBAUD_RWR_DONATION("NMOR_BLACKBAUD_RWR_DONATION"),
        VALUE_NMOR_MARKETPLACE_SHIPPING("NMOR_MARKETPLACE_SHIPPING"),
        VALUE_NMOR_DUMMY("NMOR_DUMMY"),
        VALUE_NMOR_PPGF_DONATION("NMOR_PPGF_DONATION"),
        VALUE_NMOR_ADVERTISER_SUBSCRIPTION("NMOR_ADVERTISER_SUBSCRIPTION"),
        VALUE_NMOR_WHATSAPP_P2M("NMOR_WHATSAPP_P2M"),
        VALUE_NMOR_MOVIE_TICKETING("NMOR_MOVIE_TICKETING"),
        VALUE_IG_NMOR_P2B("IG_NMOR_P2B"),
        VALUE_NMOR_INSTAGRAM_P2B("NMOR_INSTAGRAM_P2B"),
        NULL(null);

        private String value;

        private EnumPaymentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumAction {
        VALUE_MARK("MARK"),
        VALUE_CONSUME("CONSUME"),
        VALUE_DROP("DROP"),
        NULL(null);

        private String value;

        private EnumAction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumTargetSurface {
        VALUE_STORY("STORY"),
        VALUE_TIMELINE("TIMELINE"),
        NULL(null);

        private String value;

        private EnumTargetSurface(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumFormatting {
        VALUE_PLAINTEXT("PLAINTEXT"),
        VALUE_MARKDOWN("MARKDOWN"),
        NULL(null);

        private String value;

        private EnumFormatting(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPostSurfacesBlacklist {
        VALUE_1("1"),
        VALUE_2("2"),
        VALUE_3("3"),
        VALUE_4("4"),
        VALUE_5("5"),
        NULL(null);

        private String value;

        private EnumPostSurfacesBlacklist(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCheckinEntryPoint {
        VALUE_BRANDING_CHECKIN("BRANDING_CHECKIN"),
        VALUE_BRANDING_STATUS("BRANDING_STATUS"),
        VALUE_BRANDING_PHOTO("BRANDING_PHOTO"),
        VALUE_BRANDING_OTHER("BRANDING_OTHER"),
        NULL(null);

        private String value;

        private EnumCheckinEntryPoint(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPlaceAttachmentSetting {
        VALUE_1("1"),
        VALUE_2("2"),
        NULL(null);

        private String value;

        private EnumPlaceAttachmentSetting(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPostingToRedspace {
        VALUE_ENABLED("enabled"),
        VALUE_DISABLED("disabled"),
        NULL(null);

        private String value;

        private EnumPostingToRedspace(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumUnpublishedContentType {
        VALUE_SCHEDULED("SCHEDULED"),
        VALUE_DRAFT("DRAFT"),
        VALUE_ADS_POST("ADS_POST"),
        VALUE_INLINE_CREATED("INLINE_CREATED"),
        VALUE_PUBLISHED("PUBLISHED"),
        NULL(null);

        private String value;

        private EnumUnpublishedContentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBackdatedTimeGranularity {
        VALUE_YEAR("year"),
        VALUE_MONTH("month"),
        VALUE_DAY("day"),
        VALUE_HOUR("hour"),
        VALUE_MIN("min"),
        VALUE_NONE("none"),
        NULL(null);

        private String value;

        private EnumBackdatedTimeGranularity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumContactSurface {
        VALUE_ORIGINAL("ORIGINAL"),
        VALUE_MESSENGER("MESSENGER"),
        VALUE_CONNECTIONS("CONNECTIONS"),
        VALUE_GROWTH_CONTACT_IMPORTER("GROWTH_CONTACT_IMPORTER"),
        NULL(null);

        private String value;

        private EnumContactSurface(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumServiceType {
        VALUE_AIM("AIM"),
        VALUE_GADU("GADU"),
        VALUE_ICQ("ICQ"),
        VALUE_GTALK("GTALK"),
        VALUE_MSN("MSN"),
        VALUE_SKYPE("SKYPE"),
        VALUE_YAHOO("YAHOO"),
        VALUE_YAHOO_JP("YAHOO_JP"),
        VALUE_QQ("QQ"),
        VALUE_NATEON("NATEON"),
        VALUE_TWITTER("TWITTER"),
        VALUE_HYVES("HYVES"),
        VALUE_ORKUT("ORKUT"),
        VALUE_MYSPACE("MYSPACE"),
        VALUE_GROUPWISE("GROUPWISE"),
        VALUE_CYWORLD("CYWORLD"),
        VALUE_MIXI("MIXI"),
        VALUE_QIP("QIP"),
        VALUE_REDIFF_BOL("REDIFF_BOL"),
        VALUE_VKONTAKTE("VKONTAKTE"),
        VALUE_EBUDDY("EBUDDY"),
        VALUE_MAILRU("MAILRU"),
        VALUE_JABBER("JABBER"),
        VALUE_ICLOUD("ICLOUD"),
        VALUE_BBM("BBM"),
        VALUE_BBM_PPID("BBM_PPID"),
        VALUE_INSTAGRAM("INSTAGRAM"),
        VALUE_LINE("LINE"),
        VALUE_WECHAT("WECHAT"),
        VALUE_KAKAOTALK("KAKAOTALK"),
        VALUE_OTHERS("OTHERS"),
        VALUE_SNAPCHAT("SNAPCHAT"),
        VALUE_TUMBLR("TUMBLR"),
        VALUE_SOUND_CLOUD("SOUND_CLOUD"),
        VALUE_LINKED_IN("LINKED_IN"),
        VALUE_PINTEREST("PINTEREST"),
        VALUE_YOU_TUBE("YOU_TUBE"),
        VALUE_MEDIUM("MEDIUM"),
        VALUE_FOURSQUARE("FOURSQUARE"),
        VALUE_SPOTIFY("SPOTIFY"),
        VALUE_VIMEO("VIMEO"),
        VALUE_KIK("KIK"),
        VALUE_ASK_FM("ASK_FM"),
        VALUE_OK("OK"),
        VALUE_GITHUB("GITHUB"),
        VALUE_TWITCH("TWITCH"),
        VALUE_WHATSAPP("WHATSAPP"),
        NULL(null);

        private String value;

        private EnumServiceType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_GENERIC("generic"),
        VALUE_CONTENT_UPDATE("content_update"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumFiltering {
        VALUE_GROUPS("groups"),
        VALUE_GROUPS_SOCIAL("groups_social"),
        VALUE_EMA("ema"),
        NULL(null);

        private String value;

        private EnumFiltering(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumResumeType {
        VALUE_BOT_ACTION("BOT_ACTION"),
        VALUE_NATIVE("NATIVE"),
        NULL(null);

        private String value;

        private EnumResumeType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumLocalNewsSubscriptionStatus {
        VALUE_STATUS_ON("STATUS_ON"),
        VALUE_STATUS_OFF("STATUS_OFF"),
        NULL(null);

        private String value;

        private EnumLocalNewsSubscriptionStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumLocalNewsMegaphoneDismissStatus {
        VALUE_YES("YES"),
        VALUE_NO("NO"),
        NULL(null);

        private String value;

        private EnumLocalNewsMegaphoneDismissStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumTasks {
        VALUE_MANAGE("MANAGE"),
        VALUE_CREATE_CONTENT("CREATE_CONTENT"),
        VALUE_MODERATE("MODERATE"),
        VALUE_MODERATE_COMMUNITY("MODERATE_COMMUNITY"),
        VALUE_ADVERTISE("ADVERTISE"),
        VALUE_ANALYZE("ANALYZE"),
        NULL(null);

        private String value;

        private EnumTasks(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"password", "name", "firstname", "lastname", "local_news_subscription_status", "local_news_megaphone_dismiss_status", "label_cohort", "emoji_color_pref"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, User>(){

                public User apply(String result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setPassword(String password) {
            this.setParam("password", password);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setFirstname(String firstname) {
            this.setParam("firstname", firstname);
            return this;
        }

        public APIRequestUpdate setLastname(String lastname) {
            this.setParam("lastname", lastname);
            return this;
        }

        public APIRequestUpdate setLocalNewsSubscriptionStatus(EnumLocalNewsSubscriptionStatus localNewsSubscriptionStatus) {
            this.setParam("local_news_subscription_status", (Object)localNewsSubscriptionStatus);
            return this;
        }

        public APIRequestUpdate setLocalNewsSubscriptionStatus(String localNewsSubscriptionStatus) {
            this.setParam("local_news_subscription_status", localNewsSubscriptionStatus);
            return this;
        }

        public APIRequestUpdate setLocalNewsMegaphoneDismissStatus(EnumLocalNewsMegaphoneDismissStatus localNewsMegaphoneDismissStatus) {
            this.setParam("local_news_megaphone_dismiss_status", (Object)localNewsMegaphoneDismissStatus);
            return this;
        }

        public APIRequestUpdate setLocalNewsMegaphoneDismissStatus(String localNewsMegaphoneDismissStatus) {
            this.setParam("local_news_megaphone_dismiss_status", localNewsMegaphoneDismissStatus);
            return this;
        }

        public APIRequestUpdate setLabelCohort(Object labelCohort) {
            this.setParam("label_cohort", labelCohort);
            return this;
        }

        public APIRequestUpdate setLabelCohort(String labelCohort) {
            this.setParam("label_cohort", labelCohort);
            return this;
        }

        public APIRequestUpdate setEmojiColorPref(Long emojiColorPref) {
            this.setParam("emoji_color_pref", emojiColorPref);
            return this;
        }

        public APIRequestUpdate setEmojiColorPref(String emojiColorPref) {
            this.setParam("emoji_color_pref", emojiColorPref);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"about", "address", "admin_notes", "age_range", "bio", "birthday", "can_review_measurement_request", "context", "cover", "currency", "devices", "education", "email", "employee_number", "favorite_athletes", "favorite_teams", "first_name", "gender", "hometown", "id", "inspirational_people", "install_type", "installed", "interested_in", "is_famedeeplinkinguser", "is_shared_login", "is_verified", "labels", "languages", "last_name", "link", "local_news_megaphone_dismiss_status", "local_news_subscription_status", "locale", "location", "meeting_for", "middle_name", "name", "name_format", "payment_pricepoints", "political", "profile_pic", "public_key", "quotes", "relationship_status", "religion", "security_settings", "shared_login_upgrade_required_by", "short_name", "significant_other", "sports", "test_group", "third_party_id", "timezone", "token_for_business", "updated_time", "username", "verified", "video_upload_limits", "viewer_can_send_gift", "website", "work"};

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, User>(){

                public User apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGet requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGet requestAddressField() {
            return this.requestAddressField(true);
        }

        public APIRequestGet requestAddressField(boolean value) {
            this.requestField("address", value);
            return this;
        }

        public APIRequestGet requestAdminNotesField() {
            return this.requestAdminNotesField(true);
        }

        public APIRequestGet requestAdminNotesField(boolean value) {
            this.requestField("admin_notes", value);
            return this;
        }

        public APIRequestGet requestAgeRangeField() {
            return this.requestAgeRangeField(true);
        }

        public APIRequestGet requestAgeRangeField(boolean value) {
            this.requestField("age_range", value);
            return this;
        }

        public APIRequestGet requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGet requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGet requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGet requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGet requestCanReviewMeasurementRequestField() {
            return this.requestCanReviewMeasurementRequestField(true);
        }

        public APIRequestGet requestCanReviewMeasurementRequestField(boolean value) {
            this.requestField("can_review_measurement_request", value);
            return this;
        }

        public APIRequestGet requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGet requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGet requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGet requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestDevicesField() {
            return this.requestDevicesField(true);
        }

        public APIRequestGet requestDevicesField(boolean value) {
            this.requestField("devices", value);
            return this;
        }

        public APIRequestGet requestEducationField() {
            return this.requestEducationField(true);
        }

        public APIRequestGet requestEducationField(boolean value) {
            this.requestField("education", value);
            return this;
        }

        public APIRequestGet requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGet requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGet requestEmployeeNumberField() {
            return this.requestEmployeeNumberField(true);
        }

        public APIRequestGet requestEmployeeNumberField(boolean value) {
            this.requestField("employee_number", value);
            return this;
        }

        public APIRequestGet requestFavoriteAthletesField() {
            return this.requestFavoriteAthletesField(true);
        }

        public APIRequestGet requestFavoriteAthletesField(boolean value) {
            this.requestField("favorite_athletes", value);
            return this;
        }

        public APIRequestGet requestFavoriteTeamsField() {
            return this.requestFavoriteTeamsField(true);
        }

        public APIRequestGet requestFavoriteTeamsField(boolean value) {
            this.requestField("favorite_teams", value);
            return this;
        }

        public APIRequestGet requestFirstNameField() {
            return this.requestFirstNameField(true);
        }

        public APIRequestGet requestFirstNameField(boolean value) {
            this.requestField("first_name", value);
            return this;
        }

        public APIRequestGet requestGenderField() {
            return this.requestGenderField(true);
        }

        public APIRequestGet requestGenderField(boolean value) {
            this.requestField("gender", value);
            return this;
        }

        public APIRequestGet requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGet requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInspirationalPeopleField() {
            return this.requestInspirationalPeopleField(true);
        }

        public APIRequestGet requestInspirationalPeopleField(boolean value) {
            this.requestField("inspirational_people", value);
            return this;
        }

        public APIRequestGet requestInstallTypeField() {
            return this.requestInstallTypeField(true);
        }

        public APIRequestGet requestInstallTypeField(boolean value) {
            this.requestField("install_type", value);
            return this;
        }

        public APIRequestGet requestInstalledField() {
            return this.requestInstalledField(true);
        }

        public APIRequestGet requestInstalledField(boolean value) {
            this.requestField("installed", value);
            return this;
        }

        public APIRequestGet requestInterestedInField() {
            return this.requestInterestedInField(true);
        }

        public APIRequestGet requestInterestedInField(boolean value) {
            this.requestField("interested_in", value);
            return this;
        }

        public APIRequestGet requestIsFamedeeplinkinguserField() {
            return this.requestIsFamedeeplinkinguserField(true);
        }

        public APIRequestGet requestIsFamedeeplinkinguserField(boolean value) {
            this.requestField("is_famedeeplinkinguser", value);
            return this;
        }

        public APIRequestGet requestIsSharedLoginField() {
            return this.requestIsSharedLoginField(true);
        }

        public APIRequestGet requestIsSharedLoginField(boolean value) {
            this.requestField("is_shared_login", value);
            return this;
        }

        public APIRequestGet requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGet requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGet requestLabelsField() {
            return this.requestLabelsField(true);
        }

        public APIRequestGet requestLabelsField(boolean value) {
            this.requestField("labels", value);
            return this;
        }

        public APIRequestGet requestLanguagesField() {
            return this.requestLanguagesField(true);
        }

        public APIRequestGet requestLanguagesField(boolean value) {
            this.requestField("languages", value);
            return this;
        }

        public APIRequestGet requestLastNameField() {
            return this.requestLastNameField(true);
        }

        public APIRequestGet requestLastNameField(boolean value) {
            this.requestField("last_name", value);
            return this;
        }

        public APIRequestGet requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGet requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGet requestLocalNewsMegaphoneDismissStatusField() {
            return this.requestLocalNewsMegaphoneDismissStatusField(true);
        }

        public APIRequestGet requestLocalNewsMegaphoneDismissStatusField(boolean value) {
            this.requestField("local_news_megaphone_dismiss_status", value);
            return this;
        }

        public APIRequestGet requestLocalNewsSubscriptionStatusField() {
            return this.requestLocalNewsSubscriptionStatusField(true);
        }

        public APIRequestGet requestLocalNewsSubscriptionStatusField(boolean value) {
            this.requestField("local_news_subscription_status", value);
            return this;
        }

        public APIRequestGet requestLocaleField() {
            return this.requestLocaleField(true);
        }

        public APIRequestGet requestLocaleField(boolean value) {
            this.requestField("locale", value);
            return this;
        }

        public APIRequestGet requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGet requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGet requestMeetingForField() {
            return this.requestMeetingForField(true);
        }

        public APIRequestGet requestMeetingForField(boolean value) {
            this.requestField("meeting_for", value);
            return this;
        }

        public APIRequestGet requestMiddleNameField() {
            return this.requestMiddleNameField(true);
        }

        public APIRequestGet requestMiddleNameField(boolean value) {
            this.requestField("middle_name", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestNameFormatField() {
            return this.requestNameFormatField(true);
        }

        public APIRequestGet requestNameFormatField(boolean value) {
            this.requestField("name_format", value);
            return this;
        }

        public APIRequestGet requestPaymentPricepointsField() {
            return this.requestPaymentPricepointsField(true);
        }

        public APIRequestGet requestPaymentPricepointsField(boolean value) {
            this.requestField("payment_pricepoints", value);
            return this;
        }

        public APIRequestGet requestPoliticalField() {
            return this.requestPoliticalField(true);
        }

        public APIRequestGet requestPoliticalField(boolean value) {
            this.requestField("political", value);
            return this;
        }

        public APIRequestGet requestProfilePicField() {
            return this.requestProfilePicField(true);
        }

        public APIRequestGet requestProfilePicField(boolean value) {
            this.requestField("profile_pic", value);
            return this;
        }

        public APIRequestGet requestPublicKeyField() {
            return this.requestPublicKeyField(true);
        }

        public APIRequestGet requestPublicKeyField(boolean value) {
            this.requestField("public_key", value);
            return this;
        }

        public APIRequestGet requestQuotesField() {
            return this.requestQuotesField(true);
        }

        public APIRequestGet requestQuotesField(boolean value) {
            this.requestField("quotes", value);
            return this;
        }

        public APIRequestGet requestRelationshipStatusField() {
            return this.requestRelationshipStatusField(true);
        }

        public APIRequestGet requestRelationshipStatusField(boolean value) {
            this.requestField("relationship_status", value);
            return this;
        }

        public APIRequestGet requestReligionField() {
            return this.requestReligionField(true);
        }

        public APIRequestGet requestReligionField(boolean value) {
            this.requestField("religion", value);
            return this;
        }

        public APIRequestGet requestSecuritySettingsField() {
            return this.requestSecuritySettingsField(true);
        }

        public APIRequestGet requestSecuritySettingsField(boolean value) {
            this.requestField("security_settings", value);
            return this;
        }

        public APIRequestGet requestSharedLoginUpgradeRequiredByField() {
            return this.requestSharedLoginUpgradeRequiredByField(true);
        }

        public APIRequestGet requestSharedLoginUpgradeRequiredByField(boolean value) {
            this.requestField("shared_login_upgrade_required_by", value);
            return this;
        }

        public APIRequestGet requestShortNameField() {
            return this.requestShortNameField(true);
        }

        public APIRequestGet requestShortNameField(boolean value) {
            this.requestField("short_name", value);
            return this;
        }

        public APIRequestGet requestSignificantOtherField() {
            return this.requestSignificantOtherField(true);
        }

        public APIRequestGet requestSignificantOtherField(boolean value) {
            this.requestField("significant_other", value);
            return this;
        }

        public APIRequestGet requestSportsField() {
            return this.requestSportsField(true);
        }

        public APIRequestGet requestSportsField(boolean value) {
            this.requestField("sports", value);
            return this;
        }

        public APIRequestGet requestTestGroupField() {
            return this.requestTestGroupField(true);
        }

        public APIRequestGet requestTestGroupField(boolean value) {
            this.requestField("test_group", value);
            return this;
        }

        public APIRequestGet requestThirdPartyIdField() {
            return this.requestThirdPartyIdField(true);
        }

        public APIRequestGet requestThirdPartyIdField(boolean value) {
            this.requestField("third_party_id", value);
            return this;
        }

        public APIRequestGet requestTimezoneField() {
            return this.requestTimezoneField(true);
        }

        public APIRequestGet requestTimezoneField(boolean value) {
            this.requestField("timezone", value);
            return this;
        }

        public APIRequestGet requestTokenForBusinessField() {
            return this.requestTokenForBusinessField(true);
        }

        public APIRequestGet requestTokenForBusinessField(boolean value) {
            this.requestField("token_for_business", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGet requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGet requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGet requestVerifiedField() {
            return this.requestVerifiedField(true);
        }

        public APIRequestGet requestVerifiedField(boolean value) {
            this.requestField("verified", value);
            return this;
        }

        public APIRequestGet requestVideoUploadLimitsField() {
            return this.requestVideoUploadLimitsField(true);
        }

        public APIRequestGet requestVideoUploadLimitsField(boolean value) {
            this.requestField("video_upload_limits", value);
            return this;
        }

        public APIRequestGet requestViewerCanSendGiftField() {
            return this.requestViewerCanSendGiftField(true);
        }

        public APIRequestGet requestViewerCanSendGiftField(boolean value) {
            this.requestField("viewer_can_send_gift", value);
            return this;
        }

        public APIRequestGet requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGet requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGet requestWorkField() {
            return this.requestWorkField(true);
        }

        public APIRequestGet requestWorkField(boolean value) {
            this.requestField("work", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateVideo
    extends APIRequest<AdVideo> {
        AdVideo lastResponse = null;
        public static final String[] PARAMS = new String[]{"title", "source", "unpublished_content_type", "time_since_original_post", "file_url", "composer_session_id", "waterfall_id", "og_action_type_id", "og_object_id", "og_phrase", "og_icon_id", "og_suggestion_mechanism", "manual_privacy", "is_explicit_share", "thumb", "spherical", "original_projection_type", "initial_heading", "initial_pitch", "fov", "original_fov", "fisheye_video_cropped", "front_z_rotation", "guide_enabled", "guide", "audio_story_wave_animation_handle", "adaptive_type", "animated_effect_id", "asked_fun_fact_prompt_id", "composer_entry_picker", "composer_entry_point", "composer_entry_time", "composer_session_events_log", "composer_source_surface", "composer_type", "formatting", "fun_fact_prompt_id", "fun_fact_toastee_id", "is_group_linking_post", "has_nickname", "holiday_card", "instant_game_entry_point_data", "is_boost_intended", "location_source_id", "description", "offer_like_post_id", "publish_event_id", "react_mode_metadata", "sales_promo_id", "text_format_metadata", "throwback_camera_roll_media", "video_start_time_ms", "application_id", "upload_phase", "file_size", "start_offset", "end_offset", "video_file_chunk", "fbuploader_video_file_chunk", "upload_session_id", "is_voice_clip", "attribution_app_id", "content_category", "embeddable", "slideshow_spec", "upload_setting_properties", "transcode_setting_properties", "container_type", "referenced_sticker_id", "replace_video_id", "swap_mode", "privacy", "no_story", "sponsor_id", "direct_share_status"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdVideo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdVideo parseResponse(String response) throws APIException {
            return AdVideo.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdVideo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdVideo execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdVideo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdVideo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdVideo>(){

                public AdVideo apply(String result) {
                    try {
                        return APIRequestCreateVideo.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateVideo(String nodeId, APIContext context) {
            super(context, nodeId, "/videos", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateVideo setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateVideo setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateVideo setTitle(String title) {
            this.setParam("title", title);
            return this;
        }

        public APIRequestCreateVideo setSource(String source) {
            this.setParam("source", source);
            return this;
        }

        public APIRequestCreateVideo setUnpublishedContentType(AdVideo.EnumUnpublishedContentType unpublishedContentType) {
            this.setParam("unpublished_content_type", (Object)unpublishedContentType);
            return this;
        }

        public APIRequestCreateVideo setUnpublishedContentType(String unpublishedContentType) {
            this.setParam("unpublished_content_type", unpublishedContentType);
            return this;
        }

        public APIRequestCreateVideo setTimeSinceOriginalPost(Long timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestCreateVideo setTimeSinceOriginalPost(String timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestCreateVideo setFileUrl(String fileUrl) {
            this.setParam("file_url", fileUrl);
            return this;
        }

        public APIRequestCreateVideo setComposerSessionId(String composerSessionId) {
            this.setParam("composer_session_id", composerSessionId);
            return this;
        }

        public APIRequestCreateVideo setWaterfallId(String waterfallId) {
            this.setParam("waterfall_id", waterfallId);
            return this;
        }

        public APIRequestCreateVideo setOgActionTypeId(String ogActionTypeId) {
            this.setParam("og_action_type_id", ogActionTypeId);
            return this;
        }

        public APIRequestCreateVideo setOgObjectId(String ogObjectId) {
            this.setParam("og_object_id", ogObjectId);
            return this;
        }

        public APIRequestCreateVideo setOgPhrase(String ogPhrase) {
            this.setParam("og_phrase", ogPhrase);
            return this;
        }

        public APIRequestCreateVideo setOgIconId(String ogIconId) {
            this.setParam("og_icon_id", ogIconId);
            return this;
        }

        public APIRequestCreateVideo setOgSuggestionMechanism(String ogSuggestionMechanism) {
            this.setParam("og_suggestion_mechanism", ogSuggestionMechanism);
            return this;
        }

        public APIRequestCreateVideo setManualPrivacy(Boolean manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreateVideo setManualPrivacy(String manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreateVideo setIsExplicitShare(Boolean isExplicitShare) {
            this.setParam("is_explicit_share", isExplicitShare);
            return this;
        }

        public APIRequestCreateVideo setIsExplicitShare(String isExplicitShare) {
            this.setParam("is_explicit_share", isExplicitShare);
            return this;
        }

        public APIRequestCreateVideo setThumb(File thumb) {
            this.setParam("thumb", thumb);
            return this;
        }

        public APIRequestCreateVideo setThumb(String thumb) {
            this.setParam("thumb", thumb);
            return this;
        }

        public APIRequestCreateVideo setSpherical(Boolean spherical) {
            this.setParam("spherical", spherical);
            return this;
        }

        public APIRequestCreateVideo setSpherical(String spherical) {
            this.setParam("spherical", spherical);
            return this;
        }

        public APIRequestCreateVideo setOriginalProjectionType(AdVideo.EnumOriginalProjectionType originalProjectionType) {
            this.setParam("original_projection_type", (Object)originalProjectionType);
            return this;
        }

        public APIRequestCreateVideo setOriginalProjectionType(String originalProjectionType) {
            this.setParam("original_projection_type", originalProjectionType);
            return this;
        }

        public APIRequestCreateVideo setInitialHeading(Long initialHeading) {
            this.setParam("initial_heading", initialHeading);
            return this;
        }

        public APIRequestCreateVideo setInitialHeading(String initialHeading) {
            this.setParam("initial_heading", initialHeading);
            return this;
        }

        public APIRequestCreateVideo setInitialPitch(Long initialPitch) {
            this.setParam("initial_pitch", initialPitch);
            return this;
        }

        public APIRequestCreateVideo setInitialPitch(String initialPitch) {
            this.setParam("initial_pitch", initialPitch);
            return this;
        }

        public APIRequestCreateVideo setFov(Long fov) {
            this.setParam("fov", fov);
            return this;
        }

        public APIRequestCreateVideo setFov(String fov) {
            this.setParam("fov", fov);
            return this;
        }

        public APIRequestCreateVideo setOriginalFov(Long originalFov) {
            this.setParam("original_fov", originalFov);
            return this;
        }

        public APIRequestCreateVideo setOriginalFov(String originalFov) {
            this.setParam("original_fov", originalFov);
            return this;
        }

        public APIRequestCreateVideo setFisheyeVideoCropped(Boolean fisheyeVideoCropped) {
            this.setParam("fisheye_video_cropped", fisheyeVideoCropped);
            return this;
        }

        public APIRequestCreateVideo setFisheyeVideoCropped(String fisheyeVideoCropped) {
            this.setParam("fisheye_video_cropped", fisheyeVideoCropped);
            return this;
        }

        public APIRequestCreateVideo setFrontZRotation(Double frontZRotation) {
            this.setParam("front_z_rotation", frontZRotation);
            return this;
        }

        public APIRequestCreateVideo setFrontZRotation(String frontZRotation) {
            this.setParam("front_z_rotation", frontZRotation);
            return this;
        }

        public APIRequestCreateVideo setGuideEnabled(Boolean guideEnabled) {
            this.setParam("guide_enabled", guideEnabled);
            return this;
        }

        public APIRequestCreateVideo setGuideEnabled(String guideEnabled) {
            this.setParam("guide_enabled", guideEnabled);
            return this;
        }

        public APIRequestCreateVideo setGuide(List<List<Long>> guide) {
            this.setParam("guide", guide);
            return this;
        }

        public APIRequestCreateVideo setGuide(String guide) {
            this.setParam("guide", guide);
            return this;
        }

        public APIRequestCreateVideo setAudioStoryWaveAnimationHandle(String audioStoryWaveAnimationHandle) {
            this.setParam("audio_story_wave_animation_handle", audioStoryWaveAnimationHandle);
            return this;
        }

        public APIRequestCreateVideo setAdaptiveType(String adaptiveType) {
            this.setParam("adaptive_type", adaptiveType);
            return this;
        }

        public APIRequestCreateVideo setAnimatedEffectId(Long animatedEffectId) {
            this.setParam("animated_effect_id", animatedEffectId);
            return this;
        }

        public APIRequestCreateVideo setAnimatedEffectId(String animatedEffectId) {
            this.setParam("animated_effect_id", animatedEffectId);
            return this;
        }

        public APIRequestCreateVideo setAskedFunFactPromptId(Long askedFunFactPromptId) {
            this.setParam("asked_fun_fact_prompt_id", askedFunFactPromptId);
            return this;
        }

        public APIRequestCreateVideo setAskedFunFactPromptId(String askedFunFactPromptId) {
            this.setParam("asked_fun_fact_prompt_id", askedFunFactPromptId);
            return this;
        }

        public APIRequestCreateVideo setComposerEntryPicker(String composerEntryPicker) {
            this.setParam("composer_entry_picker", composerEntryPicker);
            return this;
        }

        public APIRequestCreateVideo setComposerEntryPoint(String composerEntryPoint) {
            this.setParam("composer_entry_point", composerEntryPoint);
            return this;
        }

        public APIRequestCreateVideo setComposerEntryTime(Long composerEntryTime) {
            this.setParam("composer_entry_time", composerEntryTime);
            return this;
        }

        public APIRequestCreateVideo setComposerEntryTime(String composerEntryTime) {
            this.setParam("composer_entry_time", composerEntryTime);
            return this;
        }

        public APIRequestCreateVideo setComposerSessionEventsLog(String composerSessionEventsLog) {
            this.setParam("composer_session_events_log", composerSessionEventsLog);
            return this;
        }

        public APIRequestCreateVideo setComposerSourceSurface(String composerSourceSurface) {
            this.setParam("composer_source_surface", composerSourceSurface);
            return this;
        }

        public APIRequestCreateVideo setComposerType(String composerType) {
            this.setParam("composer_type", composerType);
            return this;
        }

        public APIRequestCreateVideo setFormatting(AdVideo.EnumFormatting formatting) {
            this.setParam("formatting", (Object)formatting);
            return this;
        }

        public APIRequestCreateVideo setFormatting(String formatting) {
            this.setParam("formatting", formatting);
            return this;
        }

        public APIRequestCreateVideo setFunFactPromptId(String funFactPromptId) {
            this.setParam("fun_fact_prompt_id", funFactPromptId);
            return this;
        }

        public APIRequestCreateVideo setFunFactToasteeId(Long funFactToasteeId) {
            this.setParam("fun_fact_toastee_id", funFactToasteeId);
            return this;
        }

        public APIRequestCreateVideo setFunFactToasteeId(String funFactToasteeId) {
            this.setParam("fun_fact_toastee_id", funFactToasteeId);
            return this;
        }

        public APIRequestCreateVideo setIsGroupLinkingPost(Boolean isGroupLinkingPost) {
            this.setParam("is_group_linking_post", isGroupLinkingPost);
            return this;
        }

        public APIRequestCreateVideo setIsGroupLinkingPost(String isGroupLinkingPost) {
            this.setParam("is_group_linking_post", isGroupLinkingPost);
            return this;
        }

        public APIRequestCreateVideo setHasNickname(Boolean hasNickname) {
            this.setParam("has_nickname", hasNickname);
            return this;
        }

        public APIRequestCreateVideo setHasNickname(String hasNickname) {
            this.setParam("has_nickname", hasNickname);
            return this;
        }

        public APIRequestCreateVideo setHolidayCard(String holidayCard) {
            this.setParam("holiday_card", holidayCard);
            return this;
        }

        public APIRequestCreateVideo setInstantGameEntryPointData(String instantGameEntryPointData) {
            this.setParam("instant_game_entry_point_data", instantGameEntryPointData);
            return this;
        }

        public APIRequestCreateVideo setIsBoostIntended(Boolean isBoostIntended) {
            this.setParam("is_boost_intended", isBoostIntended);
            return this;
        }

        public APIRequestCreateVideo setIsBoostIntended(String isBoostIntended) {
            this.setParam("is_boost_intended", isBoostIntended);
            return this;
        }

        public APIRequestCreateVideo setLocationSourceId(String locationSourceId) {
            this.setParam("location_source_id", locationSourceId);
            return this;
        }

        public APIRequestCreateVideo setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateVideo setOfferLikePostId(String offerLikePostId) {
            this.setParam("offer_like_post_id", offerLikePostId);
            return this;
        }

        public APIRequestCreateVideo setPublishEventId(Long publishEventId) {
            this.setParam("publish_event_id", publishEventId);
            return this;
        }

        public APIRequestCreateVideo setPublishEventId(String publishEventId) {
            this.setParam("publish_event_id", publishEventId);
            return this;
        }

        public APIRequestCreateVideo setReactModeMetadata(String reactModeMetadata) {
            this.setParam("react_mode_metadata", reactModeMetadata);
            return this;
        }

        public APIRequestCreateVideo setSalesPromoId(Long salesPromoId) {
            this.setParam("sales_promo_id", salesPromoId);
            return this;
        }

        public APIRequestCreateVideo setSalesPromoId(String salesPromoId) {
            this.setParam("sales_promo_id", salesPromoId);
            return this;
        }

        public APIRequestCreateVideo setTextFormatMetadata(String textFormatMetadata) {
            this.setParam("text_format_metadata", textFormatMetadata);
            return this;
        }

        public APIRequestCreateVideo setThrowbackCameraRollMedia(String throwbackCameraRollMedia) {
            this.setParam("throwback_camera_roll_media", throwbackCameraRollMedia);
            return this;
        }

        public APIRequestCreateVideo setVideoStartTimeMs(Long videoStartTimeMs) {
            this.setParam("video_start_time_ms", videoStartTimeMs);
            return this;
        }

        public APIRequestCreateVideo setVideoStartTimeMs(String videoStartTimeMs) {
            this.setParam("video_start_time_ms", videoStartTimeMs);
            return this;
        }

        public APIRequestCreateVideo setApplicationId(String applicationId) {
            this.setParam("application_id", applicationId);
            return this;
        }

        public APIRequestCreateVideo setUploadPhase(AdVideo.EnumUploadPhase uploadPhase) {
            this.setParam("upload_phase", (Object)uploadPhase);
            return this;
        }

        public APIRequestCreateVideo setUploadPhase(String uploadPhase) {
            this.setParam("upload_phase", uploadPhase);
            return this;
        }

        public APIRequestCreateVideo setFileSize(Long fileSize) {
            this.setParam("file_size", fileSize);
            return this;
        }

        public APIRequestCreateVideo setFileSize(String fileSize) {
            this.setParam("file_size", fileSize);
            return this;
        }

        public APIRequestCreateVideo setStartOffset(Long startOffset) {
            this.setParam("start_offset", startOffset);
            return this;
        }

        public APIRequestCreateVideo setStartOffset(String startOffset) {
            this.setParam("start_offset", startOffset);
            return this;
        }

        public APIRequestCreateVideo setEndOffset(Long endOffset) {
            this.setParam("end_offset", endOffset);
            return this;
        }

        public APIRequestCreateVideo setEndOffset(String endOffset) {
            this.setParam("end_offset", endOffset);
            return this;
        }

        public APIRequestCreateVideo setVideoFileChunk(String videoFileChunk) {
            this.setParam("video_file_chunk", videoFileChunk);
            return this;
        }

        public APIRequestCreateVideo setFbuploaderVideoFileChunk(String fbuploaderVideoFileChunk) {
            this.setParam("fbuploader_video_file_chunk", fbuploaderVideoFileChunk);
            return this;
        }

        public APIRequestCreateVideo setUploadSessionId(String uploadSessionId) {
            this.setParam("upload_session_id", uploadSessionId);
            return this;
        }

        public APIRequestCreateVideo setIsVoiceClip(Boolean isVoiceClip) {
            this.setParam("is_voice_clip", isVoiceClip);
            return this;
        }

        public APIRequestCreateVideo setIsVoiceClip(String isVoiceClip) {
            this.setParam("is_voice_clip", isVoiceClip);
            return this;
        }

        public APIRequestCreateVideo setAttributionAppId(String attributionAppId) {
            this.setParam("attribution_app_id", attributionAppId);
            return this;
        }

        public APIRequestCreateVideo setContentCategory(AdVideo.EnumContentCategory contentCategory) {
            this.setParam("content_category", (Object)contentCategory);
            return this;
        }

        public APIRequestCreateVideo setContentCategory(String contentCategory) {
            this.setParam("content_category", contentCategory);
            return this;
        }

        public APIRequestCreateVideo setEmbeddable(Boolean embeddable) {
            this.setParam("embeddable", embeddable);
            return this;
        }

        public APIRequestCreateVideo setEmbeddable(String embeddable) {
            this.setParam("embeddable", embeddable);
            return this;
        }

        public APIRequestCreateVideo setSlideshowSpec(Map<String, String> slideshowSpec) {
            this.setParam("slideshow_spec", slideshowSpec);
            return this;
        }

        public APIRequestCreateVideo setSlideshowSpec(String slideshowSpec) {
            this.setParam("slideshow_spec", slideshowSpec);
            return this;
        }

        public APIRequestCreateVideo setUploadSettingProperties(String uploadSettingProperties) {
            this.setParam("upload_setting_properties", uploadSettingProperties);
            return this;
        }

        public APIRequestCreateVideo setTranscodeSettingProperties(String transcodeSettingProperties) {
            this.setParam("transcode_setting_properties", transcodeSettingProperties);
            return this;
        }

        public APIRequestCreateVideo setContainerType(AdVideo.EnumContainerType containerType) {
            this.setParam("container_type", (Object)containerType);
            return this;
        }

        public APIRequestCreateVideo setContainerType(String containerType) {
            this.setParam("container_type", containerType);
            return this;
        }

        public APIRequestCreateVideo setReferencedStickerId(String referencedStickerId) {
            this.setParam("referenced_sticker_id", referencedStickerId);
            return this;
        }

        public APIRequestCreateVideo setReplaceVideoId(String replaceVideoId) {
            this.setParam("replace_video_id", replaceVideoId);
            return this;
        }

        public APIRequestCreateVideo setSwapMode(AdVideo.EnumSwapMode swapMode) {
            this.setParam("swap_mode", (Object)swapMode);
            return this;
        }

        public APIRequestCreateVideo setSwapMode(String swapMode) {
            this.setParam("swap_mode", swapMode);
            return this;
        }

        public APIRequestCreateVideo setPrivacy(Object privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateVideo setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateVideo setNoStory(Boolean noStory) {
            this.setParam("no_story", noStory);
            return this;
        }

        public APIRequestCreateVideo setNoStory(String noStory) {
            this.setParam("no_story", noStory);
            return this;
        }

        public APIRequestCreateVideo setSponsorId(String sponsorId) {
            this.setParam("sponsor_id", sponsorId);
            return this;
        }

        public APIRequestCreateVideo setDirectShareStatus(Long directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestCreateVideo setDirectShareStatus(String directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestCreateVideo requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateVideo requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateVideo requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateVideo requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateVideo requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateVideo requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetVideos
    extends APIRequest<AdVideo> {
        APINodeList<AdVideo> lastResponse = null;
        public static final String[] PARAMS = new String[]{"type"};
        public static final String[] FIELDS = new String[]{"ad_breaks", "backdated_time", "backdated_time_granularity", "content_category", "content_tags", "created_time", "custom_labels", "description", "embed_html", "embeddable", "event", "expiration", "format", "from", "icon", "id", "is_crosspost_video", "is_crossposting_eligible", "is_episode", "is_instagram_eligible", "length", "live_audience_count", "live_status", "name", "permalink_url", "picture", "place", "privacy", "published", "scheduled_publish_time", "source", "spherical", "status", "title", "tv_banner_ad", "universal_video_id", "updated_time"};

        @Override
        public APINodeList<AdVideo> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdVideo> parseResponse(String response) throws APIException {
            return AdVideo.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdVideo> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdVideo> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdVideo>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdVideo>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdVideo>>(){

                public APINodeList<AdVideo> apply(String result) {
                    try {
                        return APIRequestGetVideos.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetVideos(String nodeId, APIContext context) {
            super(context, nodeId, "/videos", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetVideos setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetVideos setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetVideos setType(AdVideo.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetVideos setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetVideos requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetVideos requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideos requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetVideos requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideos requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetVideos requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetVideos requestAdBreaksField() {
            return this.requestAdBreaksField(true);
        }

        public APIRequestGetVideos requestAdBreaksField(boolean value) {
            this.requestField("ad_breaks", value);
            return this;
        }

        public APIRequestGetVideos requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGetVideos requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGetVideos requestBackdatedTimeGranularityField() {
            return this.requestBackdatedTimeGranularityField(true);
        }

        public APIRequestGetVideos requestBackdatedTimeGranularityField(boolean value) {
            this.requestField("backdated_time_granularity", value);
            return this;
        }

        public APIRequestGetVideos requestContentCategoryField() {
            return this.requestContentCategoryField(true);
        }

        public APIRequestGetVideos requestContentCategoryField(boolean value) {
            this.requestField("content_category", value);
            return this;
        }

        public APIRequestGetVideos requestContentTagsField() {
            return this.requestContentTagsField(true);
        }

        public APIRequestGetVideos requestContentTagsField(boolean value) {
            this.requestField("content_tags", value);
            return this;
        }

        public APIRequestGetVideos requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetVideos requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetVideos requestCustomLabelsField() {
            return this.requestCustomLabelsField(true);
        }

        public APIRequestGetVideos requestCustomLabelsField(boolean value) {
            this.requestField("custom_labels", value);
            return this;
        }

        public APIRequestGetVideos requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetVideos requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetVideos requestEmbedHtmlField() {
            return this.requestEmbedHtmlField(true);
        }

        public APIRequestGetVideos requestEmbedHtmlField(boolean value) {
            this.requestField("embed_html", value);
            return this;
        }

        public APIRequestGetVideos requestEmbeddableField() {
            return this.requestEmbeddableField(true);
        }

        public APIRequestGetVideos requestEmbeddableField(boolean value) {
            this.requestField("embeddable", value);
            return this;
        }

        public APIRequestGetVideos requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGetVideos requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGetVideos requestExpirationField() {
            return this.requestExpirationField(true);
        }

        public APIRequestGetVideos requestExpirationField(boolean value) {
            this.requestField("expiration", value);
            return this;
        }

        public APIRequestGetVideos requestFormatField() {
            return this.requestFormatField(true);
        }

        public APIRequestGetVideos requestFormatField(boolean value) {
            this.requestField("format", value);
            return this;
        }

        public APIRequestGetVideos requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetVideos requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetVideos requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGetVideos requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGetVideos requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetVideos requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetVideos requestIsCrosspostVideoField() {
            return this.requestIsCrosspostVideoField(true);
        }

        public APIRequestGetVideos requestIsCrosspostVideoField(boolean value) {
            this.requestField("is_crosspost_video", value);
            return this;
        }

        public APIRequestGetVideos requestIsCrosspostingEligibleField() {
            return this.requestIsCrosspostingEligibleField(true);
        }

        public APIRequestGetVideos requestIsCrosspostingEligibleField(boolean value) {
            this.requestField("is_crossposting_eligible", value);
            return this;
        }

        public APIRequestGetVideos requestIsEpisodeField() {
            return this.requestIsEpisodeField(true);
        }

        public APIRequestGetVideos requestIsEpisodeField(boolean value) {
            this.requestField("is_episode", value);
            return this;
        }

        public APIRequestGetVideos requestIsInstagramEligibleField() {
            return this.requestIsInstagramEligibleField(true);
        }

        public APIRequestGetVideos requestIsInstagramEligibleField(boolean value) {
            this.requestField("is_instagram_eligible", value);
            return this;
        }

        public APIRequestGetVideos requestLengthField() {
            return this.requestLengthField(true);
        }

        public APIRequestGetVideos requestLengthField(boolean value) {
            this.requestField("length", value);
            return this;
        }

        public APIRequestGetVideos requestLiveAudienceCountField() {
            return this.requestLiveAudienceCountField(true);
        }

        public APIRequestGetVideos requestLiveAudienceCountField(boolean value) {
            this.requestField("live_audience_count", value);
            return this;
        }

        public APIRequestGetVideos requestLiveStatusField() {
            return this.requestLiveStatusField(true);
        }

        public APIRequestGetVideos requestLiveStatusField(boolean value) {
            this.requestField("live_status", value);
            return this;
        }

        public APIRequestGetVideos requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetVideos requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetVideos requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGetVideos requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGetVideos requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGetVideos requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGetVideos requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGetVideos requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGetVideos requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGetVideos requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGetVideos requestPublishedField() {
            return this.requestPublishedField(true);
        }

        public APIRequestGetVideos requestPublishedField(boolean value) {
            this.requestField("published", value);
            return this;
        }

        public APIRequestGetVideos requestScheduledPublishTimeField() {
            return this.requestScheduledPublishTimeField(true);
        }

        public APIRequestGetVideos requestScheduledPublishTimeField(boolean value) {
            this.requestField("scheduled_publish_time", value);
            return this;
        }

        public APIRequestGetVideos requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetVideos requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetVideos requestSphericalField() {
            return this.requestSphericalField(true);
        }

        public APIRequestGetVideos requestSphericalField(boolean value) {
            this.requestField("spherical", value);
            return this;
        }

        public APIRequestGetVideos requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetVideos requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetVideos requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetVideos requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetVideos requestTvBannerAdField() {
            return this.requestTvBannerAdField(true);
        }

        public APIRequestGetVideos requestTvBannerAdField(boolean value) {
            this.requestField("tv_banner_ad", value);
            return this;
        }

        public APIRequestGetVideos requestUniversalVideoIdField() {
            return this.requestUniversalVideoIdField(true);
        }

        public APIRequestGetVideos requestUniversalVideoIdField(boolean value) {
            this.requestField("universal_video_id", value);
            return this;
        }

        public APIRequestGetVideos requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetVideos requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetVideoBroadcasts
    extends APIRequest<LiveVideo> {
        APINodeList<LiveVideo> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_break_config", "ad_break_failure_reason", "broadcast_start_time", "copyright", "creation_time", "dash_ingest_url", "dash_preview_url", "description", "embed_html", "from", "id", "ingest_streams", "is_manual_mode", "is_reference_only", "live_encoders", "live_views", "permalink_url", "planned_start_time", "preview_url", "seconds_left", "secure_stream_url", "status", "stream_url", "targeting", "title", "total_views", "video"};

        @Override
        public APINodeList<LiveVideo> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<LiveVideo> parseResponse(String response) throws APIException {
            return LiveVideo.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<LiveVideo> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<LiveVideo> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<LiveVideo>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<LiveVideo>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<LiveVideo>>(){

                public APINodeList<LiveVideo> apply(String result) {
                    try {
                        return APIRequestGetVideoBroadcasts.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetVideoBroadcasts(String nodeId, APIContext context) {
            super(context, nodeId, "/video_broadcasts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetVideoBroadcasts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetVideoBroadcasts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetVideoBroadcasts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideoBroadcasts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetVideoBroadcasts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetVideoBroadcasts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetVideoBroadcasts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestAdBreakConfigField() {
            return this.requestAdBreakConfigField(true);
        }

        public APIRequestGetVideoBroadcasts requestAdBreakConfigField(boolean value) {
            this.requestField("ad_break_config", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestAdBreakFailureReasonField() {
            return this.requestAdBreakFailureReasonField(true);
        }

        public APIRequestGetVideoBroadcasts requestAdBreakFailureReasonField(boolean value) {
            this.requestField("ad_break_failure_reason", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestBroadcastStartTimeField() {
            return this.requestBroadcastStartTimeField(true);
        }

        public APIRequestGetVideoBroadcasts requestBroadcastStartTimeField(boolean value) {
            this.requestField("broadcast_start_time", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestCopyrightField() {
            return this.requestCopyrightField(true);
        }

        public APIRequestGetVideoBroadcasts requestCopyrightField(boolean value) {
            this.requestField("copyright", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGetVideoBroadcasts requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestDashIngestUrlField() {
            return this.requestDashIngestUrlField(true);
        }

        public APIRequestGetVideoBroadcasts requestDashIngestUrlField(boolean value) {
            this.requestField("dash_ingest_url", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestDashPreviewUrlField() {
            return this.requestDashPreviewUrlField(true);
        }

        public APIRequestGetVideoBroadcasts requestDashPreviewUrlField(boolean value) {
            this.requestField("dash_preview_url", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetVideoBroadcasts requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestEmbedHtmlField() {
            return this.requestEmbedHtmlField(true);
        }

        public APIRequestGetVideoBroadcasts requestEmbedHtmlField(boolean value) {
            this.requestField("embed_html", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetVideoBroadcasts requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetVideoBroadcasts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestIngestStreamsField() {
            return this.requestIngestStreamsField(true);
        }

        public APIRequestGetVideoBroadcasts requestIngestStreamsField(boolean value) {
            this.requestField("ingest_streams", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestIsManualModeField() {
            return this.requestIsManualModeField(true);
        }

        public APIRequestGetVideoBroadcasts requestIsManualModeField(boolean value) {
            this.requestField("is_manual_mode", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestIsReferenceOnlyField() {
            return this.requestIsReferenceOnlyField(true);
        }

        public APIRequestGetVideoBroadcasts requestIsReferenceOnlyField(boolean value) {
            this.requestField("is_reference_only", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestLiveEncodersField() {
            return this.requestLiveEncodersField(true);
        }

        public APIRequestGetVideoBroadcasts requestLiveEncodersField(boolean value) {
            this.requestField("live_encoders", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestLiveViewsField() {
            return this.requestLiveViewsField(true);
        }

        public APIRequestGetVideoBroadcasts requestLiveViewsField(boolean value) {
            this.requestField("live_views", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGetVideoBroadcasts requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestPlannedStartTimeField() {
            return this.requestPlannedStartTimeField(true);
        }

        public APIRequestGetVideoBroadcasts requestPlannedStartTimeField(boolean value) {
            this.requestField("planned_start_time", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestPreviewUrlField() {
            return this.requestPreviewUrlField(true);
        }

        public APIRequestGetVideoBroadcasts requestPreviewUrlField(boolean value) {
            this.requestField("preview_url", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestSecondsLeftField() {
            return this.requestSecondsLeftField(true);
        }

        public APIRequestGetVideoBroadcasts requestSecondsLeftField(boolean value) {
            this.requestField("seconds_left", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestSecureStreamUrlField() {
            return this.requestSecureStreamUrlField(true);
        }

        public APIRequestGetVideoBroadcasts requestSecureStreamUrlField(boolean value) {
            this.requestField("secure_stream_url", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetVideoBroadcasts requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestStreamUrlField() {
            return this.requestStreamUrlField(true);
        }

        public APIRequestGetVideoBroadcasts requestStreamUrlField(boolean value) {
            this.requestField("stream_url", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetVideoBroadcasts requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetVideoBroadcasts requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestTotalViewsField() {
            return this.requestTotalViewsField(true);
        }

        public APIRequestGetVideoBroadcasts requestTotalViewsField(boolean value) {
            this.requestField("total_views", value);
            return this;
        }

        public APIRequestGetVideoBroadcasts requestVideoField() {
            return this.requestVideoField(true);
        }

        public APIRequestGetVideoBroadcasts requestVideoField(boolean value) {
            this.requestField("video", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetThreads
    extends APIRequest<UnifiedThread> {
        APINodeList<UnifiedThread> lastResponse = null;
        public static final String[] PARAMS = new String[]{"tags", "folder", "psid"};
        public static final String[] FIELDS = new String[]{"can_reply", "former_participants", "id", "is_subscribed", "link", "message_count", "name", "participants", "scoped_thread_key", "senders", "snippet", "subject", "tags", "thread_key", "unread_count", "updated_time", "wallpaper"};

        @Override
        public APINodeList<UnifiedThread> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<UnifiedThread> parseResponse(String response) throws APIException {
            return UnifiedThread.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<UnifiedThread> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<UnifiedThread> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<UnifiedThread>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<UnifiedThread>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<UnifiedThread>>(){

                public APINodeList<UnifiedThread> apply(String result) {
                    try {
                        return APIRequestGetThreads.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetThreads(String nodeId, APIContext context) {
            super(context, nodeId, "/threads", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetThreads setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetThreads setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetThreads setTags(List<String> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestGetThreads setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestGetThreads setFolder(String folder) {
            this.setParam("folder", folder);
            return this;
        }

        public APIRequestGetThreads setPsid(Object psid) {
            this.setParam("psid", psid);
            return this;
        }

        public APIRequestGetThreads setPsid(String psid) {
            this.setParam("psid", psid);
            return this;
        }

        public APIRequestGetThreads requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetThreads requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetThreads requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetThreads requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetThreads requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetThreads requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetThreads requestCanReplyField() {
            return this.requestCanReplyField(true);
        }

        public APIRequestGetThreads requestCanReplyField(boolean value) {
            this.requestField("can_reply", value);
            return this;
        }

        public APIRequestGetThreads requestFormerParticipantsField() {
            return this.requestFormerParticipantsField(true);
        }

        public APIRequestGetThreads requestFormerParticipantsField(boolean value) {
            this.requestField("former_participants", value);
            return this;
        }

        public APIRequestGetThreads requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetThreads requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetThreads requestIsSubscribedField() {
            return this.requestIsSubscribedField(true);
        }

        public APIRequestGetThreads requestIsSubscribedField(boolean value) {
            this.requestField("is_subscribed", value);
            return this;
        }

        public APIRequestGetThreads requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetThreads requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetThreads requestMessageCountField() {
            return this.requestMessageCountField(true);
        }

        public APIRequestGetThreads requestMessageCountField(boolean value) {
            this.requestField("message_count", value);
            return this;
        }

        public APIRequestGetThreads requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetThreads requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetThreads requestParticipantsField() {
            return this.requestParticipantsField(true);
        }

        public APIRequestGetThreads requestParticipantsField(boolean value) {
            this.requestField("participants", value);
            return this;
        }

        public APIRequestGetThreads requestScopedThreadKeyField() {
            return this.requestScopedThreadKeyField(true);
        }

        public APIRequestGetThreads requestScopedThreadKeyField(boolean value) {
            this.requestField("scoped_thread_key", value);
            return this;
        }

        public APIRequestGetThreads requestSendersField() {
            return this.requestSendersField(true);
        }

        public APIRequestGetThreads requestSendersField(boolean value) {
            this.requestField("senders", value);
            return this;
        }

        public APIRequestGetThreads requestSnippetField() {
            return this.requestSnippetField(true);
        }

        public APIRequestGetThreads requestSnippetField(boolean value) {
            this.requestField("snippet", value);
            return this;
        }

        public APIRequestGetThreads requestSubjectField() {
            return this.requestSubjectField(true);
        }

        public APIRequestGetThreads requestSubjectField(boolean value) {
            this.requestField("subject", value);
            return this;
        }

        public APIRequestGetThreads requestTagsField() {
            return this.requestTagsField(true);
        }

        public APIRequestGetThreads requestTagsField(boolean value) {
            this.requestField("tags", value);
            return this;
        }

        public APIRequestGetThreads requestThreadKeyField() {
            return this.requestThreadKeyField(true);
        }

        public APIRequestGetThreads requestThreadKeyField(boolean value) {
            this.requestField("thread_key", value);
            return this;
        }

        public APIRequestGetThreads requestUnreadCountField() {
            return this.requestUnreadCountField(true);
        }

        public APIRequestGetThreads requestUnreadCountField(boolean value) {
            this.requestField("unread_count", value);
            return this;
        }

        public APIRequestGetThreads requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetThreads requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetThreads requestWallpaperField() {
            return this.requestWallpaperField(true);
        }

        public APIRequestGetThreads requestWallpaperField(boolean value) {
            this.requestField("wallpaper", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetTelevision
    extends APIRequest<Page> {
        APINodeList<Page> lastResponse = null;
        public static final String[] PARAMS = new String[]{"target_id"};
        public static final String[] FIELDS = new String[]{"about", "access_token", "ad_campaign", "affiliation", "app_id", "app_links", "artists_we_like", "attire", "awards", "band_interests", "band_members", "best_page", "bio", "birthday", "booking_agent", "built", "business", "can_checkin", "can_post", "category", "category_list", "checkins", "company_overview", "connected_instagram_account", "contact_address", "context", "copyright_attribution_insights", "copyright_whitelisted_ig_partners", "country_page_likes", "cover", "culinary_team", "current_location", "description", "description_html", "directed_by", "display_subtext", "displayed_message_response_time", "emails", "engagement", "fan_count", "featured_video", "features", "food_styles", "founded", "general_info", "general_manager", "genre", "global_brand_page_name", "global_brand_parent_page", "global_brand_root_id", "has_added_app", "has_whatsapp_business_number", "has_whatsapp_number", "hometown", "hours", "id", "impressum", "influences", "instagram_business_account", "instant_articles_review_status", "is_always_open", "is_chain", "is_community_page", "is_eligible_for_branded_content", "is_messenger_bot_get_started_enabled", "is_messenger_platform_bot", "is_owned", "is_permanently_closed", "is_published", "is_unclaimed", "is_verified", "is_webhooks_subscribed", "keywords", "leadgen_form_preview_details", "leadgen_has_crm_integration", "leadgen_has_fat_ping_crm_integration", "leadgen_tos_acceptance_time", "leadgen_tos_accepted", "leadgen_tos_accepting_user", "link", "location", "members", "merchant_id", "merchant_review_status", "messenger_ads_default_icebreakers", "messenger_ads_default_page_welcome_message", "messenger_ads_default_quick_replies", "messenger_ads_quick_replies_type", "mission", "mpg", "name", "name_with_location_descriptor", "network", "new_like_count", "offer_eligible", "overall_star_rating", "page_token", "parent_page", "parking", "payment_options", "personal_info", "personal_interests", "pharma_safety_info", "phone", "place_type", "plot_outline", "preferred_audience", "press_contact", "price_range", "produced_by", "products", "promotion_eligible", "promotion_ineligible_reason", "public_transit", "publisher_space", "rating_count", "recipient", "record_label", "release_date", "restaurant_services", "restaurant_specialties", "schedule", "screenplay_by", "season", "single_line_address", "starring", "start_info", "store_code", "store_location_descriptor", "store_number", "studio", "supports_instant_articles", "talking_about_count", "unread_message_count", "unread_notif_count", "unseen_message_count", "username", "verification_status", "voip_info", "website", "were_here_count", "whatsapp_number", "written_by"};

        @Override
        public APINodeList<Page> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Page> parseResponse(String response) throws APIException {
            return Page.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Page> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Page>>(){

                public APINodeList<Page> apply(String result) {
                    try {
                        return APIRequestGetTelevision.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetTelevision(String nodeId, APIContext context) {
            super(context, nodeId, "/television", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTelevision setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTelevision setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTelevision setTargetId(String targetId) {
            this.setParam("target_id", targetId);
            return this;
        }

        public APIRequestGetTelevision requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTelevision requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTelevision requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTelevision requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTelevision requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTelevision requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetTelevision requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetTelevision requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetTelevision requestAccessTokenField() {
            return this.requestAccessTokenField(true);
        }

        public APIRequestGetTelevision requestAccessTokenField(boolean value) {
            this.requestField("access_token", value);
            return this;
        }

        public APIRequestGetTelevision requestAdCampaignField() {
            return this.requestAdCampaignField(true);
        }

        public APIRequestGetTelevision requestAdCampaignField(boolean value) {
            this.requestField("ad_campaign", value);
            return this;
        }

        public APIRequestGetTelevision requestAffiliationField() {
            return this.requestAffiliationField(true);
        }

        public APIRequestGetTelevision requestAffiliationField(boolean value) {
            this.requestField("affiliation", value);
            return this;
        }

        public APIRequestGetTelevision requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetTelevision requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetTelevision requestAppLinksField() {
            return this.requestAppLinksField(true);
        }

        public APIRequestGetTelevision requestAppLinksField(boolean value) {
            this.requestField("app_links", value);
            return this;
        }

        public APIRequestGetTelevision requestArtistsWeLikeField() {
            return this.requestArtistsWeLikeField(true);
        }

        public APIRequestGetTelevision requestArtistsWeLikeField(boolean value) {
            this.requestField("artists_we_like", value);
            return this;
        }

        public APIRequestGetTelevision requestAttireField() {
            return this.requestAttireField(true);
        }

        public APIRequestGetTelevision requestAttireField(boolean value) {
            this.requestField("attire", value);
            return this;
        }

        public APIRequestGetTelevision requestAwardsField() {
            return this.requestAwardsField(true);
        }

        public APIRequestGetTelevision requestAwardsField(boolean value) {
            this.requestField("awards", value);
            return this;
        }

        public APIRequestGetTelevision requestBandInterestsField() {
            return this.requestBandInterestsField(true);
        }

        public APIRequestGetTelevision requestBandInterestsField(boolean value) {
            this.requestField("band_interests", value);
            return this;
        }

        public APIRequestGetTelevision requestBandMembersField() {
            return this.requestBandMembersField(true);
        }

        public APIRequestGetTelevision requestBandMembersField(boolean value) {
            this.requestField("band_members", value);
            return this;
        }

        public APIRequestGetTelevision requestBestPageField() {
            return this.requestBestPageField(true);
        }

        public APIRequestGetTelevision requestBestPageField(boolean value) {
            this.requestField("best_page", value);
            return this;
        }

        public APIRequestGetTelevision requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetTelevision requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetTelevision requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetTelevision requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetTelevision requestBookingAgentField() {
            return this.requestBookingAgentField(true);
        }

        public APIRequestGetTelevision requestBookingAgentField(boolean value) {
            this.requestField("booking_agent", value);
            return this;
        }

        public APIRequestGetTelevision requestBuiltField() {
            return this.requestBuiltField(true);
        }

        public APIRequestGetTelevision requestBuiltField(boolean value) {
            this.requestField("built", value);
            return this;
        }

        public APIRequestGetTelevision requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetTelevision requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetTelevision requestCanCheckinField() {
            return this.requestCanCheckinField(true);
        }

        public APIRequestGetTelevision requestCanCheckinField(boolean value) {
            this.requestField("can_checkin", value);
            return this;
        }

        public APIRequestGetTelevision requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetTelevision requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetTelevision requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetTelevision requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetTelevision requestCategoryListField() {
            return this.requestCategoryListField(true);
        }

        public APIRequestGetTelevision requestCategoryListField(boolean value) {
            this.requestField("category_list", value);
            return this;
        }

        public APIRequestGetTelevision requestCheckinsField() {
            return this.requestCheckinsField(true);
        }

        public APIRequestGetTelevision requestCheckinsField(boolean value) {
            this.requestField("checkins", value);
            return this;
        }

        public APIRequestGetTelevision requestCompanyOverviewField() {
            return this.requestCompanyOverviewField(true);
        }

        public APIRequestGetTelevision requestCompanyOverviewField(boolean value) {
            this.requestField("company_overview", value);
            return this;
        }

        public APIRequestGetTelevision requestConnectedInstagramAccountField() {
            return this.requestConnectedInstagramAccountField(true);
        }

        public APIRequestGetTelevision requestConnectedInstagramAccountField(boolean value) {
            this.requestField("connected_instagram_account", value);
            return this;
        }

        public APIRequestGetTelevision requestContactAddressField() {
            return this.requestContactAddressField(true);
        }

        public APIRequestGetTelevision requestContactAddressField(boolean value) {
            this.requestField("contact_address", value);
            return this;
        }

        public APIRequestGetTelevision requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetTelevision requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetTelevision requestCopyrightAttributionInsightsField() {
            return this.requestCopyrightAttributionInsightsField(true);
        }

        public APIRequestGetTelevision requestCopyrightAttributionInsightsField(boolean value) {
            this.requestField("copyright_attribution_insights", value);
            return this;
        }

        public APIRequestGetTelevision requestCopyrightWhitelistedIgPartnersField() {
            return this.requestCopyrightWhitelistedIgPartnersField(true);
        }

        public APIRequestGetTelevision requestCopyrightWhitelistedIgPartnersField(boolean value) {
            this.requestField("copyright_whitelisted_ig_partners", value);
            return this;
        }

        public APIRequestGetTelevision requestCountryPageLikesField() {
            return this.requestCountryPageLikesField(true);
        }

        public APIRequestGetTelevision requestCountryPageLikesField(boolean value) {
            this.requestField("country_page_likes", value);
            return this;
        }

        public APIRequestGetTelevision requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetTelevision requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetTelevision requestCulinaryTeamField() {
            return this.requestCulinaryTeamField(true);
        }

        public APIRequestGetTelevision requestCulinaryTeamField(boolean value) {
            this.requestField("culinary_team", value);
            return this;
        }

        public APIRequestGetTelevision requestCurrentLocationField() {
            return this.requestCurrentLocationField(true);
        }

        public APIRequestGetTelevision requestCurrentLocationField(boolean value) {
            this.requestField("current_location", value);
            return this;
        }

        public APIRequestGetTelevision requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetTelevision requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetTelevision requestDescriptionHtmlField() {
            return this.requestDescriptionHtmlField(true);
        }

        public APIRequestGetTelevision requestDescriptionHtmlField(boolean value) {
            this.requestField("description_html", value);
            return this;
        }

        public APIRequestGetTelevision requestDirectedByField() {
            return this.requestDirectedByField(true);
        }

        public APIRequestGetTelevision requestDirectedByField(boolean value) {
            this.requestField("directed_by", value);
            return this;
        }

        public APIRequestGetTelevision requestDisplaySubtextField() {
            return this.requestDisplaySubtextField(true);
        }

        public APIRequestGetTelevision requestDisplaySubtextField(boolean value) {
            this.requestField("display_subtext", value);
            return this;
        }

        public APIRequestGetTelevision requestDisplayedMessageResponseTimeField() {
            return this.requestDisplayedMessageResponseTimeField(true);
        }

        public APIRequestGetTelevision requestDisplayedMessageResponseTimeField(boolean value) {
            this.requestField("displayed_message_response_time", value);
            return this;
        }

        public APIRequestGetTelevision requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGetTelevision requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGetTelevision requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGetTelevision requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGetTelevision requestFanCountField() {
            return this.requestFanCountField(true);
        }

        public APIRequestGetTelevision requestFanCountField(boolean value) {
            this.requestField("fan_count", value);
            return this;
        }

        public APIRequestGetTelevision requestFeaturedVideoField() {
            return this.requestFeaturedVideoField(true);
        }

        public APIRequestGetTelevision requestFeaturedVideoField(boolean value) {
            this.requestField("featured_video", value);
            return this;
        }

        public APIRequestGetTelevision requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGetTelevision requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGetTelevision requestFoodStylesField() {
            return this.requestFoodStylesField(true);
        }

        public APIRequestGetTelevision requestFoodStylesField(boolean value) {
            this.requestField("food_styles", value);
            return this;
        }

        public APIRequestGetTelevision requestFoundedField() {
            return this.requestFoundedField(true);
        }

        public APIRequestGetTelevision requestFoundedField(boolean value) {
            this.requestField("founded", value);
            return this;
        }

        public APIRequestGetTelevision requestGeneralInfoField() {
            return this.requestGeneralInfoField(true);
        }

        public APIRequestGetTelevision requestGeneralInfoField(boolean value) {
            this.requestField("general_info", value);
            return this;
        }

        public APIRequestGetTelevision requestGeneralManagerField() {
            return this.requestGeneralManagerField(true);
        }

        public APIRequestGetTelevision requestGeneralManagerField(boolean value) {
            this.requestField("general_manager", value);
            return this;
        }

        public APIRequestGetTelevision requestGenreField() {
            return this.requestGenreField(true);
        }

        public APIRequestGetTelevision requestGenreField(boolean value) {
            this.requestField("genre", value);
            return this;
        }

        public APIRequestGetTelevision requestGlobalBrandPageNameField() {
            return this.requestGlobalBrandPageNameField(true);
        }

        public APIRequestGetTelevision requestGlobalBrandPageNameField(boolean value) {
            this.requestField("global_brand_page_name", value);
            return this;
        }

        public APIRequestGetTelevision requestGlobalBrandParentPageField() {
            return this.requestGlobalBrandParentPageField(true);
        }

        public APIRequestGetTelevision requestGlobalBrandParentPageField(boolean value) {
            this.requestField("global_brand_parent_page", value);
            return this;
        }

        public APIRequestGetTelevision requestGlobalBrandRootIdField() {
            return this.requestGlobalBrandRootIdField(true);
        }

        public APIRequestGetTelevision requestGlobalBrandRootIdField(boolean value) {
            this.requestField("global_brand_root_id", value);
            return this;
        }

        public APIRequestGetTelevision requestHasAddedAppField() {
            return this.requestHasAddedAppField(true);
        }

        public APIRequestGetTelevision requestHasAddedAppField(boolean value) {
            this.requestField("has_added_app", value);
            return this;
        }

        public APIRequestGetTelevision requestHasWhatsappBusinessNumberField() {
            return this.requestHasWhatsappBusinessNumberField(true);
        }

        public APIRequestGetTelevision requestHasWhatsappBusinessNumberField(boolean value) {
            this.requestField("has_whatsapp_business_number", value);
            return this;
        }

        public APIRequestGetTelevision requestHasWhatsappNumberField() {
            return this.requestHasWhatsappNumberField(true);
        }

        public APIRequestGetTelevision requestHasWhatsappNumberField(boolean value) {
            this.requestField("has_whatsapp_number", value);
            return this;
        }

        public APIRequestGetTelevision requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetTelevision requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetTelevision requestHoursField() {
            return this.requestHoursField(true);
        }

        public APIRequestGetTelevision requestHoursField(boolean value) {
            this.requestField("hours", value);
            return this;
        }

        public APIRequestGetTelevision requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetTelevision requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetTelevision requestImpressumField() {
            return this.requestImpressumField(true);
        }

        public APIRequestGetTelevision requestImpressumField(boolean value) {
            this.requestField("impressum", value);
            return this;
        }

        public APIRequestGetTelevision requestInfluencesField() {
            return this.requestInfluencesField(true);
        }

        public APIRequestGetTelevision requestInfluencesField(boolean value) {
            this.requestField("influences", value);
            return this;
        }

        public APIRequestGetTelevision requestInstagramBusinessAccountField() {
            return this.requestInstagramBusinessAccountField(true);
        }

        public APIRequestGetTelevision requestInstagramBusinessAccountField(boolean value) {
            this.requestField("instagram_business_account", value);
            return this;
        }

        public APIRequestGetTelevision requestInstantArticlesReviewStatusField() {
            return this.requestInstantArticlesReviewStatusField(true);
        }

        public APIRequestGetTelevision requestInstantArticlesReviewStatusField(boolean value) {
            this.requestField("instant_articles_review_status", value);
            return this;
        }

        public APIRequestGetTelevision requestIsAlwaysOpenField() {
            return this.requestIsAlwaysOpenField(true);
        }

        public APIRequestGetTelevision requestIsAlwaysOpenField(boolean value) {
            this.requestField("is_always_open", value);
            return this;
        }

        public APIRequestGetTelevision requestIsChainField() {
            return this.requestIsChainField(true);
        }

        public APIRequestGetTelevision requestIsChainField(boolean value) {
            this.requestField("is_chain", value);
            return this;
        }

        public APIRequestGetTelevision requestIsCommunityPageField() {
            return this.requestIsCommunityPageField(true);
        }

        public APIRequestGetTelevision requestIsCommunityPageField(boolean value) {
            this.requestField("is_community_page", value);
            return this;
        }

        public APIRequestGetTelevision requestIsEligibleForBrandedContentField() {
            return this.requestIsEligibleForBrandedContentField(true);
        }

        public APIRequestGetTelevision requestIsEligibleForBrandedContentField(boolean value) {
            this.requestField("is_eligible_for_branded_content", value);
            return this;
        }

        public APIRequestGetTelevision requestIsMessengerBotGetStartedEnabledField() {
            return this.requestIsMessengerBotGetStartedEnabledField(true);
        }

        public APIRequestGetTelevision requestIsMessengerBotGetStartedEnabledField(boolean value) {
            this.requestField("is_messenger_bot_get_started_enabled", value);
            return this;
        }

        public APIRequestGetTelevision requestIsMessengerPlatformBotField() {
            return this.requestIsMessengerPlatformBotField(true);
        }

        public APIRequestGetTelevision requestIsMessengerPlatformBotField(boolean value) {
            this.requestField("is_messenger_platform_bot", value);
            return this;
        }

        public APIRequestGetTelevision requestIsOwnedField() {
            return this.requestIsOwnedField(true);
        }

        public APIRequestGetTelevision requestIsOwnedField(boolean value) {
            this.requestField("is_owned", value);
            return this;
        }

        public APIRequestGetTelevision requestIsPermanentlyClosedField() {
            return this.requestIsPermanentlyClosedField(true);
        }

        public APIRequestGetTelevision requestIsPermanentlyClosedField(boolean value) {
            this.requestField("is_permanently_closed", value);
            return this;
        }

        public APIRequestGetTelevision requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetTelevision requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetTelevision requestIsUnclaimedField() {
            return this.requestIsUnclaimedField(true);
        }

        public APIRequestGetTelevision requestIsUnclaimedField(boolean value) {
            this.requestField("is_unclaimed", value);
            return this;
        }

        public APIRequestGetTelevision requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetTelevision requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetTelevision requestIsWebhooksSubscribedField() {
            return this.requestIsWebhooksSubscribedField(true);
        }

        public APIRequestGetTelevision requestIsWebhooksSubscribedField(boolean value) {
            this.requestField("is_webhooks_subscribed", value);
            return this;
        }

        public APIRequestGetTelevision requestKeywordsField() {
            return this.requestKeywordsField(true);
        }

        public APIRequestGetTelevision requestKeywordsField(boolean value) {
            this.requestField("keywords", value);
            return this;
        }

        public APIRequestGetTelevision requestLeadgenFormPreviewDetailsField() {
            return this.requestLeadgenFormPreviewDetailsField(true);
        }

        public APIRequestGetTelevision requestLeadgenFormPreviewDetailsField(boolean value) {
            this.requestField("leadgen_form_preview_details", value);
            return this;
        }

        public APIRequestGetTelevision requestLeadgenHasCrmIntegrationField() {
            return this.requestLeadgenHasCrmIntegrationField(true);
        }

        public APIRequestGetTelevision requestLeadgenHasCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_crm_integration", value);
            return this;
        }

        public APIRequestGetTelevision requestLeadgenHasFatPingCrmIntegrationField() {
            return this.requestLeadgenHasFatPingCrmIntegrationField(true);
        }

        public APIRequestGetTelevision requestLeadgenHasFatPingCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_fat_ping_crm_integration", value);
            return this;
        }

        public APIRequestGetTelevision requestLeadgenTosAcceptanceTimeField() {
            return this.requestLeadgenTosAcceptanceTimeField(true);
        }

        public APIRequestGetTelevision requestLeadgenTosAcceptanceTimeField(boolean value) {
            this.requestField("leadgen_tos_acceptance_time", value);
            return this;
        }

        public APIRequestGetTelevision requestLeadgenTosAcceptedField() {
            return this.requestLeadgenTosAcceptedField(true);
        }

        public APIRequestGetTelevision requestLeadgenTosAcceptedField(boolean value) {
            this.requestField("leadgen_tos_accepted", value);
            return this;
        }

        public APIRequestGetTelevision requestLeadgenTosAcceptingUserField() {
            return this.requestLeadgenTosAcceptingUserField(true);
        }

        public APIRequestGetTelevision requestLeadgenTosAcceptingUserField(boolean value) {
            this.requestField("leadgen_tos_accepting_user", value);
            return this;
        }

        public APIRequestGetTelevision requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetTelevision requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetTelevision requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetTelevision requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetTelevision requestMembersField() {
            return this.requestMembersField(true);
        }

        public APIRequestGetTelevision requestMembersField(boolean value) {
            this.requestField("members", value);
            return this;
        }

        public APIRequestGetTelevision requestMerchantIdField() {
            return this.requestMerchantIdField(true);
        }

        public APIRequestGetTelevision requestMerchantIdField(boolean value) {
            this.requestField("merchant_id", value);
            return this;
        }

        public APIRequestGetTelevision requestMerchantReviewStatusField() {
            return this.requestMerchantReviewStatusField(true);
        }

        public APIRequestGetTelevision requestMerchantReviewStatusField(boolean value) {
            this.requestField("merchant_review_status", value);
            return this;
        }

        public APIRequestGetTelevision requestMessengerAdsDefaultIcebreakersField() {
            return this.requestMessengerAdsDefaultIcebreakersField(true);
        }

        public APIRequestGetTelevision requestMessengerAdsDefaultIcebreakersField(boolean value) {
            this.requestField("messenger_ads_default_icebreakers", value);
            return this;
        }

        public APIRequestGetTelevision requestMessengerAdsDefaultPageWelcomeMessageField() {
            return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
        }

        public APIRequestGetTelevision requestMessengerAdsDefaultPageWelcomeMessageField(boolean value) {
            this.requestField("messenger_ads_default_page_welcome_message", value);
            return this;
        }

        public APIRequestGetTelevision requestMessengerAdsDefaultQuickRepliesField() {
            return this.requestMessengerAdsDefaultQuickRepliesField(true);
        }

        public APIRequestGetTelevision requestMessengerAdsDefaultQuickRepliesField(boolean value) {
            this.requestField("messenger_ads_default_quick_replies", value);
            return this;
        }

        public APIRequestGetTelevision requestMessengerAdsQuickRepliesTypeField() {
            return this.requestMessengerAdsQuickRepliesTypeField(true);
        }

        public APIRequestGetTelevision requestMessengerAdsQuickRepliesTypeField(boolean value) {
            this.requestField("messenger_ads_quick_replies_type", value);
            return this;
        }

        public APIRequestGetTelevision requestMissionField() {
            return this.requestMissionField(true);
        }

        public APIRequestGetTelevision requestMissionField(boolean value) {
            this.requestField("mission", value);
            return this;
        }

        public APIRequestGetTelevision requestMpgField() {
            return this.requestMpgField(true);
        }

        public APIRequestGetTelevision requestMpgField(boolean value) {
            this.requestField("mpg", value);
            return this;
        }

        public APIRequestGetTelevision requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetTelevision requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetTelevision requestNameWithLocationDescriptorField() {
            return this.requestNameWithLocationDescriptorField(true);
        }

        public APIRequestGetTelevision requestNameWithLocationDescriptorField(boolean value) {
            this.requestField("name_with_location_descriptor", value);
            return this;
        }

        public APIRequestGetTelevision requestNetworkField() {
            return this.requestNetworkField(true);
        }

        public APIRequestGetTelevision requestNetworkField(boolean value) {
            this.requestField("network", value);
            return this;
        }

        public APIRequestGetTelevision requestNewLikeCountField() {
            return this.requestNewLikeCountField(true);
        }

        public APIRequestGetTelevision requestNewLikeCountField(boolean value) {
            this.requestField("new_like_count", value);
            return this;
        }

        public APIRequestGetTelevision requestOfferEligibleField() {
            return this.requestOfferEligibleField(true);
        }

        public APIRequestGetTelevision requestOfferEligibleField(boolean value) {
            this.requestField("offer_eligible", value);
            return this;
        }

        public APIRequestGetTelevision requestOverallStarRatingField() {
            return this.requestOverallStarRatingField(true);
        }

        public APIRequestGetTelevision requestOverallStarRatingField(boolean value) {
            this.requestField("overall_star_rating", value);
            return this;
        }

        public APIRequestGetTelevision requestPageTokenField() {
            return this.requestPageTokenField(true);
        }

        public APIRequestGetTelevision requestPageTokenField(boolean value) {
            this.requestField("page_token", value);
            return this;
        }

        public APIRequestGetTelevision requestParentPageField() {
            return this.requestParentPageField(true);
        }

        public APIRequestGetTelevision requestParentPageField(boolean value) {
            this.requestField("parent_page", value);
            return this;
        }

        public APIRequestGetTelevision requestParkingField() {
            return this.requestParkingField(true);
        }

        public APIRequestGetTelevision requestParkingField(boolean value) {
            this.requestField("parking", value);
            return this;
        }

        public APIRequestGetTelevision requestPaymentOptionsField() {
            return this.requestPaymentOptionsField(true);
        }

        public APIRequestGetTelevision requestPaymentOptionsField(boolean value) {
            this.requestField("payment_options", value);
            return this;
        }

        public APIRequestGetTelevision requestPersonalInfoField() {
            return this.requestPersonalInfoField(true);
        }

        public APIRequestGetTelevision requestPersonalInfoField(boolean value) {
            this.requestField("personal_info", value);
            return this;
        }

        public APIRequestGetTelevision requestPersonalInterestsField() {
            return this.requestPersonalInterestsField(true);
        }

        public APIRequestGetTelevision requestPersonalInterestsField(boolean value) {
            this.requestField("personal_interests", value);
            return this;
        }

        public APIRequestGetTelevision requestPharmaSafetyInfoField() {
            return this.requestPharmaSafetyInfoField(true);
        }

        public APIRequestGetTelevision requestPharmaSafetyInfoField(boolean value) {
            this.requestField("pharma_safety_info", value);
            return this;
        }

        public APIRequestGetTelevision requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGetTelevision requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGetTelevision requestPlaceTypeField() {
            return this.requestPlaceTypeField(true);
        }

        public APIRequestGetTelevision requestPlaceTypeField(boolean value) {
            this.requestField("place_type", value);
            return this;
        }

        public APIRequestGetTelevision requestPlotOutlineField() {
            return this.requestPlotOutlineField(true);
        }

        public APIRequestGetTelevision requestPlotOutlineField(boolean value) {
            this.requestField("plot_outline", value);
            return this;
        }

        public APIRequestGetTelevision requestPreferredAudienceField() {
            return this.requestPreferredAudienceField(true);
        }

        public APIRequestGetTelevision requestPreferredAudienceField(boolean value) {
            this.requestField("preferred_audience", value);
            return this;
        }

        public APIRequestGetTelevision requestPressContactField() {
            return this.requestPressContactField(true);
        }

        public APIRequestGetTelevision requestPressContactField(boolean value) {
            this.requestField("press_contact", value);
            return this;
        }

        public APIRequestGetTelevision requestPriceRangeField() {
            return this.requestPriceRangeField(true);
        }

        public APIRequestGetTelevision requestPriceRangeField(boolean value) {
            this.requestField("price_range", value);
            return this;
        }

        public APIRequestGetTelevision requestProducedByField() {
            return this.requestProducedByField(true);
        }

        public APIRequestGetTelevision requestProducedByField(boolean value) {
            this.requestField("produced_by", value);
            return this;
        }

        public APIRequestGetTelevision requestProductsField() {
            return this.requestProductsField(true);
        }

        public APIRequestGetTelevision requestProductsField(boolean value) {
            this.requestField("products", value);
            return this;
        }

        public APIRequestGetTelevision requestPromotionEligibleField() {
            return this.requestPromotionEligibleField(true);
        }

        public APIRequestGetTelevision requestPromotionEligibleField(boolean value) {
            this.requestField("promotion_eligible", value);
            return this;
        }

        public APIRequestGetTelevision requestPromotionIneligibleReasonField() {
            return this.requestPromotionIneligibleReasonField(true);
        }

        public APIRequestGetTelevision requestPromotionIneligibleReasonField(boolean value) {
            this.requestField("promotion_ineligible_reason", value);
            return this;
        }

        public APIRequestGetTelevision requestPublicTransitField() {
            return this.requestPublicTransitField(true);
        }

        public APIRequestGetTelevision requestPublicTransitField(boolean value) {
            this.requestField("public_transit", value);
            return this;
        }

        public APIRequestGetTelevision requestPublisherSpaceField() {
            return this.requestPublisherSpaceField(true);
        }

        public APIRequestGetTelevision requestPublisherSpaceField(boolean value) {
            this.requestField("publisher_space", value);
            return this;
        }

        public APIRequestGetTelevision requestRatingCountField() {
            return this.requestRatingCountField(true);
        }

        public APIRequestGetTelevision requestRatingCountField(boolean value) {
            this.requestField("rating_count", value);
            return this;
        }

        public APIRequestGetTelevision requestRecipientField() {
            return this.requestRecipientField(true);
        }

        public APIRequestGetTelevision requestRecipientField(boolean value) {
            this.requestField("recipient", value);
            return this;
        }

        public APIRequestGetTelevision requestRecordLabelField() {
            return this.requestRecordLabelField(true);
        }

        public APIRequestGetTelevision requestRecordLabelField(boolean value) {
            this.requestField("record_label", value);
            return this;
        }

        public APIRequestGetTelevision requestReleaseDateField() {
            return this.requestReleaseDateField(true);
        }

        public APIRequestGetTelevision requestReleaseDateField(boolean value) {
            this.requestField("release_date", value);
            return this;
        }

        public APIRequestGetTelevision requestRestaurantServicesField() {
            return this.requestRestaurantServicesField(true);
        }

        public APIRequestGetTelevision requestRestaurantServicesField(boolean value) {
            this.requestField("restaurant_services", value);
            return this;
        }

        public APIRequestGetTelevision requestRestaurantSpecialtiesField() {
            return this.requestRestaurantSpecialtiesField(true);
        }

        public APIRequestGetTelevision requestRestaurantSpecialtiesField(boolean value) {
            this.requestField("restaurant_specialties", value);
            return this;
        }

        public APIRequestGetTelevision requestScheduleField() {
            return this.requestScheduleField(true);
        }

        public APIRequestGetTelevision requestScheduleField(boolean value) {
            this.requestField("schedule", value);
            return this;
        }

        public APIRequestGetTelevision requestScreenplayByField() {
            return this.requestScreenplayByField(true);
        }

        public APIRequestGetTelevision requestScreenplayByField(boolean value) {
            this.requestField("screenplay_by", value);
            return this;
        }

        public APIRequestGetTelevision requestSeasonField() {
            return this.requestSeasonField(true);
        }

        public APIRequestGetTelevision requestSeasonField(boolean value) {
            this.requestField("season", value);
            return this;
        }

        public APIRequestGetTelevision requestSingleLineAddressField() {
            return this.requestSingleLineAddressField(true);
        }

        public APIRequestGetTelevision requestSingleLineAddressField(boolean value) {
            this.requestField("single_line_address", value);
            return this;
        }

        public APIRequestGetTelevision requestStarringField() {
            return this.requestStarringField(true);
        }

        public APIRequestGetTelevision requestStarringField(boolean value) {
            this.requestField("starring", value);
            return this;
        }

        public APIRequestGetTelevision requestStartInfoField() {
            return this.requestStartInfoField(true);
        }

        public APIRequestGetTelevision requestStartInfoField(boolean value) {
            this.requestField("start_info", value);
            return this;
        }

        public APIRequestGetTelevision requestStoreCodeField() {
            return this.requestStoreCodeField(true);
        }

        public APIRequestGetTelevision requestStoreCodeField(boolean value) {
            this.requestField("store_code", value);
            return this;
        }

        public APIRequestGetTelevision requestStoreLocationDescriptorField() {
            return this.requestStoreLocationDescriptorField(true);
        }

        public APIRequestGetTelevision requestStoreLocationDescriptorField(boolean value) {
            this.requestField("store_location_descriptor", value);
            return this;
        }

        public APIRequestGetTelevision requestStoreNumberField() {
            return this.requestStoreNumberField(true);
        }

        public APIRequestGetTelevision requestStoreNumberField(boolean value) {
            this.requestField("store_number", value);
            return this;
        }

        public APIRequestGetTelevision requestStudioField() {
            return this.requestStudioField(true);
        }

        public APIRequestGetTelevision requestStudioField(boolean value) {
            this.requestField("studio", value);
            return this;
        }

        public APIRequestGetTelevision requestSupportsInstantArticlesField() {
            return this.requestSupportsInstantArticlesField(true);
        }

        public APIRequestGetTelevision requestSupportsInstantArticlesField(boolean value) {
            this.requestField("supports_instant_articles", value);
            return this;
        }

        public APIRequestGetTelevision requestTalkingAboutCountField() {
            return this.requestTalkingAboutCountField(true);
        }

        public APIRequestGetTelevision requestTalkingAboutCountField(boolean value) {
            this.requestField("talking_about_count", value);
            return this;
        }

        public APIRequestGetTelevision requestUnreadMessageCountField() {
            return this.requestUnreadMessageCountField(true);
        }

        public APIRequestGetTelevision requestUnreadMessageCountField(boolean value) {
            this.requestField("unread_message_count", value);
            return this;
        }

        public APIRequestGetTelevision requestUnreadNotifCountField() {
            return this.requestUnreadNotifCountField(true);
        }

        public APIRequestGetTelevision requestUnreadNotifCountField(boolean value) {
            this.requestField("unread_notif_count", value);
            return this;
        }

        public APIRequestGetTelevision requestUnseenMessageCountField() {
            return this.requestUnseenMessageCountField(true);
        }

        public APIRequestGetTelevision requestUnseenMessageCountField(boolean value) {
            this.requestField("unseen_message_count", value);
            return this;
        }

        public APIRequestGetTelevision requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetTelevision requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGetTelevision requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetTelevision requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetTelevision requestVoipInfoField() {
            return this.requestVoipInfoField(true);
        }

        public APIRequestGetTelevision requestVoipInfoField(boolean value) {
            this.requestField("voip_info", value);
            return this;
        }

        public APIRequestGetTelevision requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetTelevision requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetTelevision requestWereHereCountField() {
            return this.requestWereHereCountField(true);
        }

        public APIRequestGetTelevision requestWereHereCountField(boolean value) {
            this.requestField("were_here_count", value);
            return this;
        }

        public APIRequestGetTelevision requestWhatsappNumberField() {
            return this.requestWhatsappNumberField(true);
        }

        public APIRequestGetTelevision requestWhatsappNumberField(boolean value) {
            this.requestField("whatsapp_number", value);
            return this;
        }

        public APIRequestGetTelevision requestWrittenByField() {
            return this.requestWrittenByField(true);
        }

        public APIRequestGetTelevision requestWrittenByField(boolean value) {
            this.requestField("written_by", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetTaggedPlaces
    extends APIRequest<PlaceTag> {
        APINodeList<PlaceTag> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"created_time", "id", "place"};

        @Override
        public APINodeList<PlaceTag> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<PlaceTag> parseResponse(String response) throws APIException {
            return PlaceTag.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<PlaceTag> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<PlaceTag> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<PlaceTag>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<PlaceTag>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<PlaceTag>>(){

                public APINodeList<PlaceTag> apply(String result) {
                    try {
                        return APIRequestGetTaggedPlaces.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetTaggedPlaces(String nodeId, APIContext context) {
            super(context, nodeId, "/tagged_places", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTaggedPlaces setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTaggedPlaces setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTaggedPlaces requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTaggedPlaces requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTaggedPlaces requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTaggedPlaces requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTaggedPlaces requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTaggedPlaces requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetTaggedPlaces requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetTaggedPlaces requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetTaggedPlaces requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetTaggedPlaces requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetTaggedPlaces requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGetTaggedPlaces requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetTaggableFriends
    extends APIRequest<UserTaggableFriend> {
        APINodeList<UserTaggableFriend> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"first_name", "id", "last_name", "middle_name", "name"};

        @Override
        public APINodeList<UserTaggableFriend> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<UserTaggableFriend> parseResponse(String response) throws APIException {
            return UserTaggableFriend.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<UserTaggableFriend> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<UserTaggableFriend> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<UserTaggableFriend>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<UserTaggableFriend>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<UserTaggableFriend>>(){

                public APINodeList<UserTaggableFriend> apply(String result) {
                    try {
                        return APIRequestGetTaggableFriends.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetTaggableFriends(String nodeId, APIContext context) {
            super(context, nodeId, "/taggable_friends", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTaggableFriends setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTaggableFriends setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTaggableFriends requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTaggableFriends requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTaggableFriends requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTaggableFriends requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTaggableFriends requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTaggableFriends requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetTaggableFriends requestFirstNameField() {
            return this.requestFirstNameField(true);
        }

        public APIRequestGetTaggableFriends requestFirstNameField(boolean value) {
            this.requestField("first_name", value);
            return this;
        }

        public APIRequestGetTaggableFriends requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetTaggableFriends requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetTaggableFriends requestLastNameField() {
            return this.requestLastNameField(true);
        }

        public APIRequestGetTaggableFriends requestLastNameField(boolean value) {
            this.requestField("last_name", value);
            return this;
        }

        public APIRequestGetTaggableFriends requestMiddleNameField() {
            return this.requestMiddleNameField(true);
        }

        public APIRequestGetTaggableFriends requestMiddleNameField(boolean value) {
            this.requestField("middle_name", value);
            return this;
        }

        public APIRequestGetTaggableFriends requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetTaggableFriends requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateSubscription
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"object", "fields", "callback_url", "verify_token", "include_values"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateSubscription.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateSubscription(String nodeId, APIContext context) {
            super(context, nodeId, "/subscriptions", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateSubscription setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateSubscription setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateSubscription setObject(String object) {
            this.setParam("object", object);
            return this;
        }

        public APIRequestCreateSubscription setFields(List<String> fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestCreateSubscription setFields(String fields) {
            this.setParam("fields", fields);
            return this;
        }

        public APIRequestCreateSubscription setCallbackUrl(Object callbackUrl) {
            this.setParam("callback_url", callbackUrl);
            return this;
        }

        public APIRequestCreateSubscription setCallbackUrl(String callbackUrl) {
            this.setParam("callback_url", callbackUrl);
            return this;
        }

        public APIRequestCreateSubscription setVerifyToken(String verifyToken) {
            this.setParam("verify_token", verifyToken);
            return this;
        }

        public APIRequestCreateSubscription setIncludeValues(Boolean includeValues) {
            this.setParam("include_values", includeValues);
            return this;
        }

        public APIRequestCreateSubscription setIncludeValues(String includeValues) {
            this.setParam("include_values", includeValues);
            return this;
        }

        public APIRequestCreateSubscription requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateSubscription requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSubscription requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateSubscription requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSubscription requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateSubscription requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetStreamFilters
    extends APIRequest<StreamFilter> {
        APINodeList<StreamFilter> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"filter_key", "name", "type", "id"};

        @Override
        public APINodeList<StreamFilter> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<StreamFilter> parseResponse(String response) throws APIException {
            return StreamFilter.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<StreamFilter> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<StreamFilter> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<StreamFilter>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<StreamFilter>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<StreamFilter>>(){

                public APINodeList<StreamFilter> apply(String result) {
                    try {
                        return APIRequestGetStreamFilters.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetStreamFilters(String nodeId, APIContext context) {
            super(context, nodeId, "/stream_filters", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetStreamFilters setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetStreamFilters setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetStreamFilters requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetStreamFilters requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetStreamFilters requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetStreamFilters requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetStreamFilters requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetStreamFilters requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetStreamFilters requestFilterKeyField() {
            return this.requestFilterKeyField(true);
        }

        public APIRequestGetStreamFilters requestFilterKeyField(boolean value) {
            this.requestField("filter_key", value);
            return this;
        }

        public APIRequestGetStreamFilters requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetStreamFilters requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetStreamFilters requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetStreamFilters requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetStreamFilters requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetStreamFilters requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateStagingResource
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"file"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, User>(){

                public User apply(String result) {
                    try {
                        return APIRequestCreateStagingResource.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateStagingResource(String nodeId, APIContext context) {
            super(context, nodeId, "/stagingresources", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateStagingResource setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateStagingResource setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateStagingResource addUploadFile(String uploadName, File file) {
            this.setParam(uploadName, file);
            return this;
        }

        @Override
        public APIRequestCreateStagingResource setUseVideoEndpoint(boolean useVideoEndpoint) {
            this.useVideoEndpoint = useVideoEndpoint;
            return this;
        }

        public APIRequestCreateStagingResource requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateStagingResource requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateStagingResource requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateStagingResource requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateStagingResource requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateStagingResource requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetSessionKeys
    extends APIRequest<PlatformSessionKey> {
        APINodeList<PlatformSessionKey> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id"};

        @Override
        public APINodeList<PlatformSessionKey> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<PlatformSessionKey> parseResponse(String response) throws APIException {
            return PlatformSessionKey.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<PlatformSessionKey> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<PlatformSessionKey> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<PlatformSessionKey>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<PlatformSessionKey>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<PlatformSessionKey>>(){

                public APINodeList<PlatformSessionKey> apply(String result) {
                    try {
                        return APIRequestGetSessionKeys.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetSessionKeys(String nodeId, APIContext context) {
            super(context, nodeId, "/session_keys", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSessionKeys setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSessionKeys setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSessionKeys requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSessionKeys requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSessionKeys requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSessionKeys requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSessionKeys requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSessionKeys requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetSessionKeys requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetSessionKeys requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateScreenName
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"service_type", "value"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, User>(){

                public User apply(String result) {
                    try {
                        return APIRequestCreateScreenName.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateScreenName(String nodeId, APIContext context) {
            super(context, nodeId, "/screennames", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateScreenName setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateScreenName setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateScreenName setServiceType(EnumServiceType serviceType) {
            this.setParam("service_type", (Object)serviceType);
            return this;
        }

        public APIRequestCreateScreenName setServiceType(String serviceType) {
            this.setParam("service_type", serviceType);
            return this;
        }

        public APIRequestCreateScreenName setValue(String value) {
            this.setParam("value", value);
            return this;
        }

        public APIRequestCreateScreenName requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateScreenName requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateScreenName requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateScreenName requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateScreenName requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateScreenName requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteScreenNames
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"service_type", "value"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteScreenNames.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteScreenNames(String nodeId, APIContext context) {
            super(context, nodeId, "/screennames", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteScreenNames setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteScreenNames setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteScreenNames setServiceType(EnumServiceType serviceType) {
            this.setParam("service_type", (Object)serviceType);
            return this;
        }

        public APIRequestDeleteScreenNames setServiceType(String serviceType) {
            this.setParam("service_type", serviceType);
            return this;
        }

        public APIRequestDeleteScreenNames setValue(String value) {
            this.setParam("value", value);
            return this;
        }

        public APIRequestDeleteScreenNames requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteScreenNames requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteScreenNames requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteScreenNames requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteScreenNames requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteScreenNames requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetRichMediaDocuments
    extends APIRequest<Canvas> {
        APINodeList<Canvas> lastResponse = null;
        public static final String[] PARAMS = new String[]{"query"};
        public static final String[] FIELDS = new String[]{"background_color", "body_elements", "canvas_link", "id", "is_hidden", "is_published", "last_editor", "name", "owner", "update_time"};

        @Override
        public APINodeList<Canvas> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Canvas> parseResponse(String response) throws APIException {
            return Canvas.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Canvas> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Canvas> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Canvas>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Canvas>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Canvas>>(){

                public APINodeList<Canvas> apply(String result) {
                    try {
                        return APIRequestGetRichMediaDocuments.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetRichMediaDocuments(String nodeId, APIContext context) {
            super(context, nodeId, "/rich_media_documents", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetRichMediaDocuments setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetRichMediaDocuments setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetRichMediaDocuments setQuery(String query) {
            this.setParam("query", query);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetRichMediaDocuments requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRichMediaDocuments requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetRichMediaDocuments requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRichMediaDocuments requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetRichMediaDocuments requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestBackgroundColorField() {
            return this.requestBackgroundColorField(true);
        }

        public APIRequestGetRichMediaDocuments requestBackgroundColorField(boolean value) {
            this.requestField("background_color", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestBodyElementsField() {
            return this.requestBodyElementsField(true);
        }

        public APIRequestGetRichMediaDocuments requestBodyElementsField(boolean value) {
            this.requestField("body_elements", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestCanvasLinkField() {
            return this.requestCanvasLinkField(true);
        }

        public APIRequestGetRichMediaDocuments requestCanvasLinkField(boolean value) {
            this.requestField("canvas_link", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetRichMediaDocuments requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetRichMediaDocuments requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetRichMediaDocuments requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestLastEditorField() {
            return this.requestLastEditorField(true);
        }

        public APIRequestGetRichMediaDocuments requestLastEditorField(boolean value) {
            this.requestField("last_editor", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetRichMediaDocuments requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetRichMediaDocuments requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetRichMediaDocuments requestUpdateTimeField() {
            return this.requestUpdateTimeField(true);
        }

        public APIRequestGetRichMediaDocuments requestUpdateTimeField(boolean value) {
            this.requestField("update_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetRequestHistory
    extends APIRequest<RequestHistory> {
        APINodeList<RequestHistory> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"api_version", "created_time", "error_code", "graph_path", "http_method", "post_params", "query_params", "id"};

        @Override
        public APINodeList<RequestHistory> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<RequestHistory> parseResponse(String response) throws APIException {
            return RequestHistory.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<RequestHistory> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<RequestHistory> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<RequestHistory>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<RequestHistory>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<RequestHistory>>(){

                public APINodeList<RequestHistory> apply(String result) {
                    try {
                        return APIRequestGetRequestHistory.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetRequestHistory(String nodeId, APIContext context) {
            super(context, nodeId, "/request_history", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetRequestHistory setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetRequestHistory setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetRequestHistory requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetRequestHistory requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRequestHistory requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetRequestHistory requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetRequestHistory requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetRequestHistory requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetRequestHistory requestApiVersionField() {
            return this.requestApiVersionField(true);
        }

        public APIRequestGetRequestHistory requestApiVersionField(boolean value) {
            this.requestField("api_version", value);
            return this;
        }

        public APIRequestGetRequestHistory requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetRequestHistory requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetRequestHistory requestErrorCodeField() {
            return this.requestErrorCodeField(true);
        }

        public APIRequestGetRequestHistory requestErrorCodeField(boolean value) {
            this.requestField("error_code", value);
            return this;
        }

        public APIRequestGetRequestHistory requestGraphPathField() {
            return this.requestGraphPathField(true);
        }

        public APIRequestGetRequestHistory requestGraphPathField(boolean value) {
            this.requestField("graph_path", value);
            return this;
        }

        public APIRequestGetRequestHistory requestHttpMethodField() {
            return this.requestHttpMethodField(true);
        }

        public APIRequestGetRequestHistory requestHttpMethodField(boolean value) {
            this.requestField("http_method", value);
            return this;
        }

        public APIRequestGetRequestHistory requestPostParamsField() {
            return this.requestPostParamsField(true);
        }

        public APIRequestGetRequestHistory requestPostParamsField(boolean value) {
            this.requestField("post_params", value);
            return this;
        }

        public APIRequestGetRequestHistory requestQueryParamsField() {
            return this.requestQueryParamsField(true);
        }

        public APIRequestGetRequestHistory requestQueryParamsField(boolean value) {
            this.requestField("query_params", value);
            return this;
        }

        public APIRequestGetRequestHistory requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetRequestHistory requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPromotableEvents
    extends APIRequest<Event> {
        APINodeList<Event> lastResponse = null;
        public static final String[] PARAMS = new String[]{"is_page_event", "page_id", "include_past_events", "promotable_event_types"};
        public static final String[] FIELDS = new String[]{"attending_count", "can_guests_invite", "can_viewer_post", "category", "cover", "declined_count", "description", "discount_code_enabled", "end_time", "event_times", "guest_list_enabled", "id", "interested_count", "invited_count", "is_canceled", "is_date_only", "is_draft", "is_page_owned", "location", "maybe_count", "name", "noreply_count", "owner", "parent_group", "place", "privacy", "scheduled_publish_time", "start_time", "ticket_uri", "ticket_uri_start_sales_time", "ticketing_privacy_uri", "ticketing_terms_uri", "timezone", "type", "updated_time", "venue"};

        @Override
        public APINodeList<Event> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Event> parseResponse(String response) throws APIException {
            return Event.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Event> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Event> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Event>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Event>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Event>>(){

                public APINodeList<Event> apply(String result) {
                    try {
                        return APIRequestGetPromotableEvents.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPromotableEvents(String nodeId, APIContext context) {
            super(context, nodeId, "/promotable_events", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPromotableEvents setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPromotableEvents setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPromotableEvents setIsPageEvent(Boolean isPageEvent) {
            this.setParam("is_page_event", isPageEvent);
            return this;
        }

        public APIRequestGetPromotableEvents setIsPageEvent(String isPageEvent) {
            this.setParam("is_page_event", isPageEvent);
            return this;
        }

        public APIRequestGetPromotableEvents setPageId(Long pageId) {
            this.setParam("page_id", pageId);
            return this;
        }

        public APIRequestGetPromotableEvents setPageId(String pageId) {
            this.setParam("page_id", pageId);
            return this;
        }

        public APIRequestGetPromotableEvents setIncludePastEvents(Boolean includePastEvents) {
            this.setParam("include_past_events", includePastEvents);
            return this;
        }

        public APIRequestGetPromotableEvents setIncludePastEvents(String includePastEvents) {
            this.setParam("include_past_events", includePastEvents);
            return this;
        }

        public APIRequestGetPromotableEvents setPromotableEventTypes(List<Event.EnumPromotableEventTypes> promotableEventTypes) {
            this.setParam("promotable_event_types", promotableEventTypes);
            return this;
        }

        public APIRequestGetPromotableEvents setPromotableEventTypes(String promotableEventTypes) {
            this.setParam("promotable_event_types", promotableEventTypes);
            return this;
        }

        public APIRequestGetPromotableEvents requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPromotableEvents requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPromotableEvents requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPromotableEvents requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPromotableEvents requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPromotableEvents requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPromotableEvents requestAttendingCountField() {
            return this.requestAttendingCountField(true);
        }

        public APIRequestGetPromotableEvents requestAttendingCountField(boolean value) {
            this.requestField("attending_count", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestCanGuestsInviteField() {
            return this.requestCanGuestsInviteField(true);
        }

        public APIRequestGetPromotableEvents requestCanGuestsInviteField(boolean value) {
            this.requestField("can_guests_invite", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestCanViewerPostField() {
            return this.requestCanViewerPostField(true);
        }

        public APIRequestGetPromotableEvents requestCanViewerPostField(boolean value) {
            this.requestField("can_viewer_post", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetPromotableEvents requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetPromotableEvents requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestDeclinedCountField() {
            return this.requestDeclinedCountField(true);
        }

        public APIRequestGetPromotableEvents requestDeclinedCountField(boolean value) {
            this.requestField("declined_count", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetPromotableEvents requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestDiscountCodeEnabledField() {
            return this.requestDiscountCodeEnabledField(true);
        }

        public APIRequestGetPromotableEvents requestDiscountCodeEnabledField(boolean value) {
            this.requestField("discount_code_enabled", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetPromotableEvents requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestEventTimesField() {
            return this.requestEventTimesField(true);
        }

        public APIRequestGetPromotableEvents requestEventTimesField(boolean value) {
            this.requestField("event_times", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestGuestListEnabledField() {
            return this.requestGuestListEnabledField(true);
        }

        public APIRequestGetPromotableEvents requestGuestListEnabledField(boolean value) {
            this.requestField("guest_list_enabled", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPromotableEvents requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestInterestedCountField() {
            return this.requestInterestedCountField(true);
        }

        public APIRequestGetPromotableEvents requestInterestedCountField(boolean value) {
            this.requestField("interested_count", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestInvitedCountField() {
            return this.requestInvitedCountField(true);
        }

        public APIRequestGetPromotableEvents requestInvitedCountField(boolean value) {
            this.requestField("invited_count", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestIsCanceledField() {
            return this.requestIsCanceledField(true);
        }

        public APIRequestGetPromotableEvents requestIsCanceledField(boolean value) {
            this.requestField("is_canceled", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestIsDateOnlyField() {
            return this.requestIsDateOnlyField(true);
        }

        public APIRequestGetPromotableEvents requestIsDateOnlyField(boolean value) {
            this.requestField("is_date_only", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestIsDraftField() {
            return this.requestIsDraftField(true);
        }

        public APIRequestGetPromotableEvents requestIsDraftField(boolean value) {
            this.requestField("is_draft", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestIsPageOwnedField() {
            return this.requestIsPageOwnedField(true);
        }

        public APIRequestGetPromotableEvents requestIsPageOwnedField(boolean value) {
            this.requestField("is_page_owned", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetPromotableEvents requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestMaybeCountField() {
            return this.requestMaybeCountField(true);
        }

        public APIRequestGetPromotableEvents requestMaybeCountField(boolean value) {
            this.requestField("maybe_count", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetPromotableEvents requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestNoreplyCountField() {
            return this.requestNoreplyCountField(true);
        }

        public APIRequestGetPromotableEvents requestNoreplyCountField(boolean value) {
            this.requestField("noreply_count", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetPromotableEvents requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestParentGroupField() {
            return this.requestParentGroupField(true);
        }

        public APIRequestGetPromotableEvents requestParentGroupField(boolean value) {
            this.requestField("parent_group", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGetPromotableEvents requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGetPromotableEvents requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestScheduledPublishTimeField() {
            return this.requestScheduledPublishTimeField(true);
        }

        public APIRequestGetPromotableEvents requestScheduledPublishTimeField(boolean value) {
            this.requestField("scheduled_publish_time", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetPromotableEvents requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestTicketUriField() {
            return this.requestTicketUriField(true);
        }

        public APIRequestGetPromotableEvents requestTicketUriField(boolean value) {
            this.requestField("ticket_uri", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestTicketUriStartSalesTimeField() {
            return this.requestTicketUriStartSalesTimeField(true);
        }

        public APIRequestGetPromotableEvents requestTicketUriStartSalesTimeField(boolean value) {
            this.requestField("ticket_uri_start_sales_time", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestTicketingPrivacyUriField() {
            return this.requestTicketingPrivacyUriField(true);
        }

        public APIRequestGetPromotableEvents requestTicketingPrivacyUriField(boolean value) {
            this.requestField("ticketing_privacy_uri", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestTicketingTermsUriField() {
            return this.requestTicketingTermsUriField(true);
        }

        public APIRequestGetPromotableEvents requestTicketingTermsUriField(boolean value) {
            this.requestField("ticketing_terms_uri", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestTimezoneField() {
            return this.requestTimezoneField(true);
        }

        public APIRequestGetPromotableEvents requestTimezoneField(boolean value) {
            this.requestField("timezone", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetPromotableEvents requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetPromotableEvents requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetPromotableEvents requestVenueField() {
            return this.requestVenueField(true);
        }

        public APIRequestGetPromotableEvents requestVenueField(boolean value) {
            this.requestField("venue", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPromotableDomains
    extends APIRequest<Domain> {
        APINodeList<Domain> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "name", "url"};

        @Override
        public APINodeList<Domain> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Domain> parseResponse(String response) throws APIException {
            return Domain.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Domain> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Domain> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Domain>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Domain>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Domain>>(){

                public APINodeList<Domain> apply(String result) {
                    try {
                        return APIRequestGetPromotableDomains.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPromotableDomains(String nodeId, APIContext context) {
            super(context, nodeId, "/promotable_domains", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPromotableDomains setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPromotableDomains setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPromotableDomains requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPromotableDomains requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPromotableDomains requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPromotableDomains requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPromotableDomains requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPromotableDomains requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPromotableDomains requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPromotableDomains requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPromotableDomains requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetPromotableDomains requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetPromotableDomains requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGetPromotableDomains requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreatePlace
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"type", "coords", "name", "description", "topics", "uid", "geometry", "override_ids", "address", "privacy", "phone", "website", "city_id", "neighborhood_name", "pin_source", "custom_provider"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreatePlace.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreatePlace(String nodeId, APIContext context) {
            super(context, nodeId, "/places", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreatePlace setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreatePlace setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreatePlace setType(EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestCreatePlace setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestCreatePlace setCoords(Object coords) {
            this.setParam("coords", coords);
            return this;
        }

        public APIRequestCreatePlace setCoords(String coords) {
            this.setParam("coords", coords);
            return this;
        }

        public APIRequestCreatePlace setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreatePlace setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreatePlace setTopics(List<String> topics) {
            this.setParam("topics", topics);
            return this;
        }

        public APIRequestCreatePlace setTopics(String topics) {
            this.setParam("topics", topics);
            return this;
        }

        public APIRequestCreatePlace setUid(Long uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestCreatePlace setUid(String uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestCreatePlace setGeometry(Object geometry) {
            this.setParam("geometry", geometry);
            return this;
        }

        public APIRequestCreatePlace setGeometry(String geometry) {
            this.setParam("geometry", geometry);
            return this;
        }

        public APIRequestCreatePlace setOverrideIds(List<Long> overrideIds) {
            this.setParam("override_ids", overrideIds);
            return this;
        }

        public APIRequestCreatePlace setOverrideIds(String overrideIds) {
            this.setParam("override_ids", overrideIds);
            return this;
        }

        public APIRequestCreatePlace setAddress(Object address) {
            this.setParam("address", address);
            return this;
        }

        public APIRequestCreatePlace setAddress(String address) {
            this.setParam("address", address);
            return this;
        }

        public APIRequestCreatePlace setPrivacy(Object privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreatePlace setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreatePlace setPhone(String phone) {
            this.setParam("phone", phone);
            return this;
        }

        public APIRequestCreatePlace setWebsite(String website) {
            this.setParam("website", website);
            return this;
        }

        public APIRequestCreatePlace setCityId(String cityId) {
            this.setParam("city_id", cityId);
            return this;
        }

        public APIRequestCreatePlace setNeighborhoodName(String neighborhoodName) {
            this.setParam("neighborhood_name", neighborhoodName);
            return this;
        }

        public APIRequestCreatePlace setPinSource(String pinSource) {
            this.setParam("pin_source", pinSource);
            return this;
        }

        public APIRequestCreatePlace setCustomProvider(String customProvider) {
            this.setParam("custom_provider", customProvider);
            return this;
        }

        public APIRequestCreatePlace requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreatePlace requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePlace requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreatePlace requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePlace requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreatePlace requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPicture
    extends APIRequest<ProfilePictureSource> {
        APINodeList<ProfilePictureSource> lastResponse = null;
        public static final String[] PARAMS = new String[]{"height", "width", "type", "redirect"};
        public static final String[] FIELDS = new String[]{"bottom", "cache_key", "height", "is_silhouette", "left", "right", "top", "uri", "url", "width", "id"};

        @Override
        public APINodeList<ProfilePictureSource> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ProfilePictureSource> parseResponse(String response) throws APIException {
            return ProfilePictureSource.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<ProfilePictureSource> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ProfilePictureSource> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ProfilePictureSource>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ProfilePictureSource>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<ProfilePictureSource>>(){

                public APINodeList<ProfilePictureSource> apply(String result) {
                    try {
                        return APIRequestGetPicture.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPicture(String nodeId, APIContext context) {
            super(context, nodeId, "/picture", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPicture setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPicture setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPicture setHeight(Long height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetPicture setHeight(String height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetPicture setWidth(Long width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetPicture setWidth(String width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetPicture setType(ProfilePictureSource.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetPicture setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetPicture setRedirect(Boolean redirect) {
            this.setParam("redirect", redirect);
            return this;
        }

        public APIRequestGetPicture setRedirect(String redirect) {
            this.setParam("redirect", redirect);
            return this;
        }

        public APIRequestGetPicture requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPicture requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPicture requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPicture requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPicture requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPicture requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPicture requestBottomField() {
            return this.requestBottomField(true);
        }

        public APIRequestGetPicture requestBottomField(boolean value) {
            this.requestField("bottom", value);
            return this;
        }

        public APIRequestGetPicture requestCacheKeyField() {
            return this.requestCacheKeyField(true);
        }

        public APIRequestGetPicture requestCacheKeyField(boolean value) {
            this.requestField("cache_key", value);
            return this;
        }

        public APIRequestGetPicture requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGetPicture requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGetPicture requestIsSilhouetteField() {
            return this.requestIsSilhouetteField(true);
        }

        public APIRequestGetPicture requestIsSilhouetteField(boolean value) {
            this.requestField("is_silhouette", value);
            return this;
        }

        public APIRequestGetPicture requestLeftField() {
            return this.requestLeftField(true);
        }

        public APIRequestGetPicture requestLeftField(boolean value) {
            this.requestField("left", value);
            return this;
        }

        public APIRequestGetPicture requestRightField() {
            return this.requestRightField(true);
        }

        public APIRequestGetPicture requestRightField(boolean value) {
            this.requestField("right", value);
            return this;
        }

        public APIRequestGetPicture requestTopField() {
            return this.requestTopField(true);
        }

        public APIRequestGetPicture requestTopField(boolean value) {
            this.requestField("top", value);
            return this;
        }

        public APIRequestGetPicture requestUriField() {
            return this.requestUriField(true);
        }

        public APIRequestGetPicture requestUriField(boolean value) {
            this.requestField("uri", value);
            return this;
        }

        public APIRequestGetPicture requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGetPicture requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGetPicture requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGetPicture requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }

        public APIRequestGetPicture requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPicture requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreatePhoto
    extends APIRequest<Photo> {
        Photo lastResponse = null;
        public static final String[] PARAMS = new String[]{"aid", "caption", "url", "uid", "profile_id", "target_id", "checkin_id", "vault_image_id", "tags", "place", "is_explicit_place", "is_explicit_location", "og_action_type_id", "og_object_id", "og_phrase", "og_icon_id", "og_suggestion_mechanism", "og_set_profile_badge", "privacy", "targeting", "feed_targeting", "no_story", "published", "offline_id", "attempt", "backdated_time", "backdated_time_granularity", "time_since_original_post", "filter_type", "scheduled_publish_time", "unpublished_content_type", "full_res_is_coming_later", "composer_session_id", "qn", "manual_privacy", "audience_exp", "proxied_app_id", "ios_bundle_id", "android_key_hash", "user_selected_tags", "allow_spherical_photo", "spherical_metadata", "initial_view_heading_override_degrees", "initial_view_pitch_override_degrees", "initial_view_vertical_fov_override_degrees", "sponsor_id", "direct_share_status", "sponsor_relationship", "application_id", "name", "message"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Photo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Photo parseResponse(String response) throws APIException {
            return Photo.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Photo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Photo execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Photo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Photo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Photo>(){

                public Photo apply(String result) {
                    try {
                        return APIRequestCreatePhoto.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreatePhoto(String nodeId, APIContext context) {
            super(context, nodeId, "/photos", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreatePhoto setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreatePhoto setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreatePhoto setAid(String aid) {
            this.setParam("aid", aid);
            return this;
        }

        public APIRequestCreatePhoto setCaption(String caption) {
            this.setParam("caption", caption);
            return this;
        }

        public APIRequestCreatePhoto setUrl(String url) {
            this.setParam("url", url);
            return this;
        }

        public APIRequestCreatePhoto setUid(Long uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestCreatePhoto setUid(String uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestCreatePhoto setProfileId(Long profileId) {
            this.setParam("profile_id", profileId);
            return this;
        }

        public APIRequestCreatePhoto setProfileId(String profileId) {
            this.setParam("profile_id", profileId);
            return this;
        }

        public APIRequestCreatePhoto setTargetId(Long targetId) {
            this.setParam("target_id", targetId);
            return this;
        }

        public APIRequestCreatePhoto setTargetId(String targetId) {
            this.setParam("target_id", targetId);
            return this;
        }

        public APIRequestCreatePhoto setCheckinId(Object checkinId) {
            this.setParam("checkin_id", checkinId);
            return this;
        }

        public APIRequestCreatePhoto setCheckinId(String checkinId) {
            this.setParam("checkin_id", checkinId);
            return this;
        }

        public APIRequestCreatePhoto setVaultImageId(String vaultImageId) {
            this.setParam("vault_image_id", vaultImageId);
            return this;
        }

        public APIRequestCreatePhoto setTags(List<Object> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreatePhoto setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreatePhoto setPlace(Object place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreatePhoto setPlace(String place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreatePhoto setIsExplicitPlace(Boolean isExplicitPlace) {
            this.setParam("is_explicit_place", isExplicitPlace);
            return this;
        }

        public APIRequestCreatePhoto setIsExplicitPlace(String isExplicitPlace) {
            this.setParam("is_explicit_place", isExplicitPlace);
            return this;
        }

        public APIRequestCreatePhoto setIsExplicitLocation(Boolean isExplicitLocation) {
            this.setParam("is_explicit_location", isExplicitLocation);
            return this;
        }

        public APIRequestCreatePhoto setIsExplicitLocation(String isExplicitLocation) {
            this.setParam("is_explicit_location", isExplicitLocation);
            return this;
        }

        public APIRequestCreatePhoto setOgActionTypeId(String ogActionTypeId) {
            this.setParam("og_action_type_id", ogActionTypeId);
            return this;
        }

        public APIRequestCreatePhoto setOgObjectId(String ogObjectId) {
            this.setParam("og_object_id", ogObjectId);
            return this;
        }

        public APIRequestCreatePhoto setOgPhrase(String ogPhrase) {
            this.setParam("og_phrase", ogPhrase);
            return this;
        }

        public APIRequestCreatePhoto setOgIconId(String ogIconId) {
            this.setParam("og_icon_id", ogIconId);
            return this;
        }

        public APIRequestCreatePhoto setOgSuggestionMechanism(String ogSuggestionMechanism) {
            this.setParam("og_suggestion_mechanism", ogSuggestionMechanism);
            return this;
        }

        public APIRequestCreatePhoto setOgSetProfileBadge(Boolean ogSetProfileBadge) {
            this.setParam("og_set_profile_badge", ogSetProfileBadge);
            return this;
        }

        public APIRequestCreatePhoto setOgSetProfileBadge(String ogSetProfileBadge) {
            this.setParam("og_set_profile_badge", ogSetProfileBadge);
            return this;
        }

        public APIRequestCreatePhoto setPrivacy(Object privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreatePhoto setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreatePhoto setTargeting(Object targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreatePhoto setTargeting(String targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreatePhoto setFeedTargeting(Object feedTargeting) {
            this.setParam("feed_targeting", feedTargeting);
            return this;
        }

        public APIRequestCreatePhoto setFeedTargeting(String feedTargeting) {
            this.setParam("feed_targeting", feedTargeting);
            return this;
        }

        public APIRequestCreatePhoto setNoStory(Boolean noStory) {
            this.setParam("no_story", noStory);
            return this;
        }

        public APIRequestCreatePhoto setNoStory(String noStory) {
            this.setParam("no_story", noStory);
            return this;
        }

        public APIRequestCreatePhoto setPublished(Boolean published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreatePhoto setPublished(String published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreatePhoto setOfflineId(Long offlineId) {
            this.setParam("offline_id", offlineId);
            return this;
        }

        public APIRequestCreatePhoto setOfflineId(String offlineId) {
            this.setParam("offline_id", offlineId);
            return this;
        }

        public APIRequestCreatePhoto setAttempt(Long attempt) {
            this.setParam("attempt", attempt);
            return this;
        }

        public APIRequestCreatePhoto setAttempt(String attempt) {
            this.setParam("attempt", attempt);
            return this;
        }

        public APIRequestCreatePhoto setBackdatedTime(String backdatedTime) {
            this.setParam("backdated_time", backdatedTime);
            return this;
        }

        public APIRequestCreatePhoto setBackdatedTimeGranularity(Photo.EnumBackdatedTimeGranularity backdatedTimeGranularity) {
            this.setParam("backdated_time_granularity", (Object)backdatedTimeGranularity);
            return this;
        }

        public APIRequestCreatePhoto setBackdatedTimeGranularity(String backdatedTimeGranularity) {
            this.setParam("backdated_time_granularity", backdatedTimeGranularity);
            return this;
        }

        public APIRequestCreatePhoto setTimeSinceOriginalPost(Long timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestCreatePhoto setTimeSinceOriginalPost(String timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestCreatePhoto setFilterType(Long filterType) {
            this.setParam("filter_type", filterType);
            return this;
        }

        public APIRequestCreatePhoto setFilterType(String filterType) {
            this.setParam("filter_type", filterType);
            return this;
        }

        public APIRequestCreatePhoto setScheduledPublishTime(Long scheduledPublishTime) {
            this.setParam("scheduled_publish_time", scheduledPublishTime);
            return this;
        }

        public APIRequestCreatePhoto setScheduledPublishTime(String scheduledPublishTime) {
            this.setParam("scheduled_publish_time", scheduledPublishTime);
            return this;
        }

        public APIRequestCreatePhoto setUnpublishedContentType(Photo.EnumUnpublishedContentType unpublishedContentType) {
            this.setParam("unpublished_content_type", (Object)unpublishedContentType);
            return this;
        }

        public APIRequestCreatePhoto setUnpublishedContentType(String unpublishedContentType) {
            this.setParam("unpublished_content_type", unpublishedContentType);
            return this;
        }

        public APIRequestCreatePhoto setFullResIsComingLater(Boolean fullResIsComingLater) {
            this.setParam("full_res_is_coming_later", fullResIsComingLater);
            return this;
        }

        public APIRequestCreatePhoto setFullResIsComingLater(String fullResIsComingLater) {
            this.setParam("full_res_is_coming_later", fullResIsComingLater);
            return this;
        }

        public APIRequestCreatePhoto setComposerSessionId(String composerSessionId) {
            this.setParam("composer_session_id", composerSessionId);
            return this;
        }

        public APIRequestCreatePhoto setQn(String qn) {
            this.setParam("qn", qn);
            return this;
        }

        public APIRequestCreatePhoto setManualPrivacy(Boolean manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreatePhoto setManualPrivacy(String manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreatePhoto setAudienceExp(Boolean audienceExp) {
            this.setParam("audience_exp", audienceExp);
            return this;
        }

        public APIRequestCreatePhoto setAudienceExp(String audienceExp) {
            this.setParam("audience_exp", audienceExp);
            return this;
        }

        public APIRequestCreatePhoto setProxiedAppId(String proxiedAppId) {
            this.setParam("proxied_app_id", proxiedAppId);
            return this;
        }

        public APIRequestCreatePhoto setIosBundleId(String iosBundleId) {
            this.setParam("ios_bundle_id", iosBundleId);
            return this;
        }

        public APIRequestCreatePhoto setAndroidKeyHash(String androidKeyHash) {
            this.setParam("android_key_hash", androidKeyHash);
            return this;
        }

        public APIRequestCreatePhoto setUserSelectedTags(Boolean userSelectedTags) {
            this.setParam("user_selected_tags", userSelectedTags);
            return this;
        }

        public APIRequestCreatePhoto setUserSelectedTags(String userSelectedTags) {
            this.setParam("user_selected_tags", userSelectedTags);
            return this;
        }

        public APIRequestCreatePhoto setAllowSphericalPhoto(Boolean allowSphericalPhoto) {
            this.setParam("allow_spherical_photo", allowSphericalPhoto);
            return this;
        }

        public APIRequestCreatePhoto setAllowSphericalPhoto(String allowSphericalPhoto) {
            this.setParam("allow_spherical_photo", allowSphericalPhoto);
            return this;
        }

        public APIRequestCreatePhoto setSphericalMetadata(Map<String, String> sphericalMetadata) {
            this.setParam("spherical_metadata", sphericalMetadata);
            return this;
        }

        public APIRequestCreatePhoto setSphericalMetadata(String sphericalMetadata) {
            this.setParam("spherical_metadata", sphericalMetadata);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewHeadingOverrideDegrees(Long initialViewHeadingOverrideDegrees) {
            this.setParam("initial_view_heading_override_degrees", initialViewHeadingOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewHeadingOverrideDegrees(String initialViewHeadingOverrideDegrees) {
            this.setParam("initial_view_heading_override_degrees", initialViewHeadingOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewPitchOverrideDegrees(Long initialViewPitchOverrideDegrees) {
            this.setParam("initial_view_pitch_override_degrees", initialViewPitchOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewPitchOverrideDegrees(String initialViewPitchOverrideDegrees) {
            this.setParam("initial_view_pitch_override_degrees", initialViewPitchOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewVerticalFovOverrideDegrees(Long initialViewVerticalFovOverrideDegrees) {
            this.setParam("initial_view_vertical_fov_override_degrees", initialViewVerticalFovOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setInitialViewVerticalFovOverrideDegrees(String initialViewVerticalFovOverrideDegrees) {
            this.setParam("initial_view_vertical_fov_override_degrees", initialViewVerticalFovOverrideDegrees);
            return this;
        }

        public APIRequestCreatePhoto setSponsorId(String sponsorId) {
            this.setParam("sponsor_id", sponsorId);
            return this;
        }

        public APIRequestCreatePhoto setDirectShareStatus(Long directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestCreatePhoto setDirectShareStatus(String directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestCreatePhoto setSponsorRelationship(Long sponsorRelationship) {
            this.setParam("sponsor_relationship", sponsorRelationship);
            return this;
        }

        public APIRequestCreatePhoto setSponsorRelationship(String sponsorRelationship) {
            this.setParam("sponsor_relationship", sponsorRelationship);
            return this;
        }

        public APIRequestCreatePhoto setApplicationId(String applicationId) {
            this.setParam("application_id", applicationId);
            return this;
        }

        public APIRequestCreatePhoto setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreatePhoto setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreatePhoto requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreatePhoto requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePhoto requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreatePhoto requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePhoto requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreatePhoto requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPhotos
    extends APIRequest<Photo> {
        APINodeList<Photo> lastResponse = null;
        public static final String[] PARAMS = new String[]{"type"};
        public static final String[] FIELDS = new String[]{"album", "backdated_time", "backdated_time_granularity", "can_backdate", "can_delete", "can_tag", "created_time", "event", "from", "height", "icon", "id", "images", "link", "name", "name_tags", "page_story_id", "picture", "place", "position", "source", "target", "updated_time", "webp_images", "width"};

        @Override
        public APINodeList<Photo> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Photo> parseResponse(String response) throws APIException {
            return Photo.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Photo> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Photo> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Photo>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Photo>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Photo>>(){

                public APINodeList<Photo> apply(String result) {
                    try {
                        return APIRequestGetPhotos.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPhotos(String nodeId, APIContext context) {
            super(context, nodeId, "/photos", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPhotos setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPhotos setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPhotos setType(Photo.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetPhotos setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetPhotos requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPhotos requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPhotos requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPhotos requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPhotos requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPhotos requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPhotos requestAlbumField() {
            return this.requestAlbumField(true);
        }

        public APIRequestGetPhotos requestAlbumField(boolean value) {
            this.requestField("album", value);
            return this;
        }

        public APIRequestGetPhotos requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGetPhotos requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGetPhotos requestBackdatedTimeGranularityField() {
            return this.requestBackdatedTimeGranularityField(true);
        }

        public APIRequestGetPhotos requestBackdatedTimeGranularityField(boolean value) {
            this.requestField("backdated_time_granularity", value);
            return this;
        }

        public APIRequestGetPhotos requestCanBackdateField() {
            return this.requestCanBackdateField(true);
        }

        public APIRequestGetPhotos requestCanBackdateField(boolean value) {
            this.requestField("can_backdate", value);
            return this;
        }

        public APIRequestGetPhotos requestCanDeleteField() {
            return this.requestCanDeleteField(true);
        }

        public APIRequestGetPhotos requestCanDeleteField(boolean value) {
            this.requestField("can_delete", value);
            return this;
        }

        public APIRequestGetPhotos requestCanTagField() {
            return this.requestCanTagField(true);
        }

        public APIRequestGetPhotos requestCanTagField(boolean value) {
            this.requestField("can_tag", value);
            return this;
        }

        public APIRequestGetPhotos requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetPhotos requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetPhotos requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGetPhotos requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGetPhotos requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetPhotos requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetPhotos requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGetPhotos requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGetPhotos requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGetPhotos requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGetPhotos requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPhotos requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPhotos requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGetPhotos requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGetPhotos requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetPhotos requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetPhotos requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetPhotos requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetPhotos requestNameTagsField() {
            return this.requestNameTagsField(true);
        }

        public APIRequestGetPhotos requestNameTagsField(boolean value) {
            this.requestField("name_tags", value);
            return this;
        }

        public APIRequestGetPhotos requestPageStoryIdField() {
            return this.requestPageStoryIdField(true);
        }

        public APIRequestGetPhotos requestPageStoryIdField(boolean value) {
            this.requestField("page_story_id", value);
            return this;
        }

        public APIRequestGetPhotos requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGetPhotos requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGetPhotos requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGetPhotos requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGetPhotos requestPositionField() {
            return this.requestPositionField(true);
        }

        public APIRequestGetPhotos requestPositionField(boolean value) {
            this.requestField("position", value);
            return this;
        }

        public APIRequestGetPhotos requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGetPhotos requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGetPhotos requestTargetField() {
            return this.requestTargetField(true);
        }

        public APIRequestGetPhotos requestTargetField(boolean value) {
            this.requestField("target", value);
            return this;
        }

        public APIRequestGetPhotos requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetPhotos requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetPhotos requestWebpImagesField() {
            return this.requestWebpImagesField(true);
        }

        public APIRequestGetPhotos requestWebpImagesField(boolean value) {
            this.requestField("webp_images", value);
            return this;
        }

        public APIRequestGetPhotos requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGetPhotos requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPersonalAdAccounts
    extends APIRequest<AdAccount> {
        APINodeList<AdAccount> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "account_status", "ad_account_creation_request", "ad_account_promotable_objects", "age", "agency_client_declaration", "amount_spent", "attribution_spec", "balance", "business", "business_city", "business_country_code", "business_name", "business_state", "business_street", "business_street2", "business_zip", "capabilities", "created_time", "currency", "daily_spend_limit", "direct_deals_tos_accepted", "disable_reason", "end_advertiser", "end_advertiser_name", "extended_credit_invoice_group", "failed_delivery_checks", "funding_source", "funding_source_details", "has_migrated_permissions", "has_page_authorized_adaccount", "id", "io_number", "is_attribution_spec_system_default", "is_direct_deals_enabled", "is_in_3ds_authorization_enabled_market", "is_in_middle_of_local_entity_migration", "is_notifications_enabled", "is_personal", "is_prepay_account", "is_tax_id_required", "line_numbers", "media_agency", "min_campaign_group_spend_cap", "min_daily_budget", "name", "offsite_pixels_tos_accepted", "owner", "partner", "rate_limit_reset_time", "rf_spec", "show_checkout_experience", "spend_cap", "tax_id", "tax_id_status", "tax_id_type", "timezone_id", "timezone_name", "timezone_offset_hours_utc", "tos_accepted", "user_role", "user_tos_accepted"};

        @Override
        public APINodeList<AdAccount> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdAccount> parseResponse(String response) throws APIException {
            return AdAccount.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdAccount> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdAccount> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdAccount>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdAccount>>(){

                public APINodeList<AdAccount> apply(String result) {
                    try {
                        return APIRequestGetPersonalAdAccounts.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPersonalAdAccounts(String nodeId, APIContext context) {
            super(context, nodeId, "/personal_ad_accounts", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPersonalAdAccounts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPersonalAdAccounts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPersonalAdAccounts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPersonalAdAccounts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPersonalAdAccounts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPersonalAdAccounts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPersonalAdAccounts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGetPersonalAdAccounts requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAccountStatusField() {
            return this.requestAccountStatusField(true);
        }

        public APIRequestGetPersonalAdAccounts requestAccountStatusField(boolean value) {
            this.requestField("account_status", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAdAccountCreationRequestField() {
            return this.requestAdAccountCreationRequestField(true);
        }

        public APIRequestGetPersonalAdAccounts requestAdAccountCreationRequestField(boolean value) {
            this.requestField("ad_account_creation_request", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAdAccountPromotableObjectsField() {
            return this.requestAdAccountPromotableObjectsField(true);
        }

        public APIRequestGetPersonalAdAccounts requestAdAccountPromotableObjectsField(boolean value) {
            this.requestField("ad_account_promotable_objects", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGetPersonalAdAccounts requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAgencyClientDeclarationField() {
            return this.requestAgencyClientDeclarationField(true);
        }

        public APIRequestGetPersonalAdAccounts requestAgencyClientDeclarationField(boolean value) {
            this.requestField("agency_client_declaration", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAmountSpentField() {
            return this.requestAmountSpentField(true);
        }

        public APIRequestGetPersonalAdAccounts requestAmountSpentField(boolean value) {
            this.requestField("amount_spent", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestAttributionSpecField() {
            return this.requestAttributionSpecField(true);
        }

        public APIRequestGetPersonalAdAccounts requestAttributionSpecField(boolean value) {
            this.requestField("attribution_spec", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBalanceField() {
            return this.requestBalanceField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBalanceField(boolean value) {
            this.requestField("balance", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessCityField() {
            return this.requestBusinessCityField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessCityField(boolean value) {
            this.requestField("business_city", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessCountryCodeField() {
            return this.requestBusinessCountryCodeField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessCountryCodeField(boolean value) {
            this.requestField("business_country_code", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessNameField() {
            return this.requestBusinessNameField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessNameField(boolean value) {
            this.requestField("business_name", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessStateField() {
            return this.requestBusinessStateField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessStateField(boolean value) {
            this.requestField("business_state", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessStreetField() {
            return this.requestBusinessStreetField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessStreetField(boolean value) {
            this.requestField("business_street", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessStreet2Field() {
            return this.requestBusinessStreet2Field(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessStreet2Field(boolean value) {
            this.requestField("business_street2", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestBusinessZipField() {
            return this.requestBusinessZipField(true);
        }

        public APIRequestGetPersonalAdAccounts requestBusinessZipField(boolean value) {
            this.requestField("business_zip", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestCapabilitiesField() {
            return this.requestCapabilitiesField(true);
        }

        public APIRequestGetPersonalAdAccounts requestCapabilitiesField(boolean value) {
            this.requestField("capabilities", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetPersonalAdAccounts requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetPersonalAdAccounts requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestDailySpendLimitField() {
            return this.requestDailySpendLimitField(true);
        }

        public APIRequestGetPersonalAdAccounts requestDailySpendLimitField(boolean value) {
            this.requestField("daily_spend_limit", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestDirectDealsTosAcceptedField() {
            return this.requestDirectDealsTosAcceptedField(true);
        }

        public APIRequestGetPersonalAdAccounts requestDirectDealsTosAcceptedField(boolean value) {
            this.requestField("direct_deals_tos_accepted", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestDisableReasonField() {
            return this.requestDisableReasonField(true);
        }

        public APIRequestGetPersonalAdAccounts requestDisableReasonField(boolean value) {
            this.requestField("disable_reason", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestEndAdvertiserField() {
            return this.requestEndAdvertiserField(true);
        }

        public APIRequestGetPersonalAdAccounts requestEndAdvertiserField(boolean value) {
            this.requestField("end_advertiser", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestEndAdvertiserNameField() {
            return this.requestEndAdvertiserNameField(true);
        }

        public APIRequestGetPersonalAdAccounts requestEndAdvertiserNameField(boolean value) {
            this.requestField("end_advertiser_name", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestExtendedCreditInvoiceGroupField() {
            return this.requestExtendedCreditInvoiceGroupField(true);
        }

        public APIRequestGetPersonalAdAccounts requestExtendedCreditInvoiceGroupField(boolean value) {
            this.requestField("extended_credit_invoice_group", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestFailedDeliveryChecksField() {
            return this.requestFailedDeliveryChecksField(true);
        }

        public APIRequestGetPersonalAdAccounts requestFailedDeliveryChecksField(boolean value) {
            this.requestField("failed_delivery_checks", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestFundingSourceField() {
            return this.requestFundingSourceField(true);
        }

        public APIRequestGetPersonalAdAccounts requestFundingSourceField(boolean value) {
            this.requestField("funding_source", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestFundingSourceDetailsField() {
            return this.requestFundingSourceDetailsField(true);
        }

        public APIRequestGetPersonalAdAccounts requestFundingSourceDetailsField(boolean value) {
            this.requestField("funding_source_details", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestHasMigratedPermissionsField() {
            return this.requestHasMigratedPermissionsField(true);
        }

        public APIRequestGetPersonalAdAccounts requestHasMigratedPermissionsField(boolean value) {
            this.requestField("has_migrated_permissions", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestHasPageAuthorizedAdaccountField() {
            return this.requestHasPageAuthorizedAdaccountField(true);
        }

        public APIRequestGetPersonalAdAccounts requestHasPageAuthorizedAdaccountField(boolean value) {
            this.requestField("has_page_authorized_adaccount", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIoNumberField() {
            return this.requestIoNumberField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIoNumberField(boolean value) {
            this.requestField("io_number", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIsAttributionSpecSystemDefaultField() {
            return this.requestIsAttributionSpecSystemDefaultField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIsAttributionSpecSystemDefaultField(boolean value) {
            this.requestField("is_attribution_spec_system_default", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIsDirectDealsEnabledField() {
            return this.requestIsDirectDealsEnabledField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIsDirectDealsEnabledField(boolean value) {
            this.requestField("is_direct_deals_enabled", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIsIn3dsAuthorizationEnabledMarketField() {
            return this.requestIsIn3dsAuthorizationEnabledMarketField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIsIn3dsAuthorizationEnabledMarketField(boolean value) {
            this.requestField("is_in_3ds_authorization_enabled_market", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIsInMiddleOfLocalEntityMigrationField() {
            return this.requestIsInMiddleOfLocalEntityMigrationField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIsInMiddleOfLocalEntityMigrationField(boolean value) {
            this.requestField("is_in_middle_of_local_entity_migration", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIsNotificationsEnabledField() {
            return this.requestIsNotificationsEnabledField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIsNotificationsEnabledField(boolean value) {
            this.requestField("is_notifications_enabled", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIsPersonalField() {
            return this.requestIsPersonalField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIsPersonalField(boolean value) {
            this.requestField("is_personal", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIsPrepayAccountField() {
            return this.requestIsPrepayAccountField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIsPrepayAccountField(boolean value) {
            this.requestField("is_prepay_account", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestIsTaxIdRequiredField() {
            return this.requestIsTaxIdRequiredField(true);
        }

        public APIRequestGetPersonalAdAccounts requestIsTaxIdRequiredField(boolean value) {
            this.requestField("is_tax_id_required", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestLineNumbersField() {
            return this.requestLineNumbersField(true);
        }

        public APIRequestGetPersonalAdAccounts requestLineNumbersField(boolean value) {
            this.requestField("line_numbers", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestMediaAgencyField() {
            return this.requestMediaAgencyField(true);
        }

        public APIRequestGetPersonalAdAccounts requestMediaAgencyField(boolean value) {
            this.requestField("media_agency", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestMinCampaignGroupSpendCapField() {
            return this.requestMinCampaignGroupSpendCapField(true);
        }

        public APIRequestGetPersonalAdAccounts requestMinCampaignGroupSpendCapField(boolean value) {
            this.requestField("min_campaign_group_spend_cap", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestMinDailyBudgetField() {
            return this.requestMinDailyBudgetField(true);
        }

        public APIRequestGetPersonalAdAccounts requestMinDailyBudgetField(boolean value) {
            this.requestField("min_daily_budget", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetPersonalAdAccounts requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestOffsitePixelsTosAcceptedField() {
            return this.requestOffsitePixelsTosAcceptedField(true);
        }

        public APIRequestGetPersonalAdAccounts requestOffsitePixelsTosAcceptedField(boolean value) {
            this.requestField("offsite_pixels_tos_accepted", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetPersonalAdAccounts requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestPartnerField() {
            return this.requestPartnerField(true);
        }

        public APIRequestGetPersonalAdAccounts requestPartnerField(boolean value) {
            this.requestField("partner", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestRateLimitResetTimeField() {
            return this.requestRateLimitResetTimeField(true);
        }

        public APIRequestGetPersonalAdAccounts requestRateLimitResetTimeField(boolean value) {
            this.requestField("rate_limit_reset_time", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestRfSpecField() {
            return this.requestRfSpecField(true);
        }

        public APIRequestGetPersonalAdAccounts requestRfSpecField(boolean value) {
            this.requestField("rf_spec", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestShowCheckoutExperienceField() {
            return this.requestShowCheckoutExperienceField(true);
        }

        public APIRequestGetPersonalAdAccounts requestShowCheckoutExperienceField(boolean value) {
            this.requestField("show_checkout_experience", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestSpendCapField() {
            return this.requestSpendCapField(true);
        }

        public APIRequestGetPersonalAdAccounts requestSpendCapField(boolean value) {
            this.requestField("spend_cap", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestTaxIdField() {
            return this.requestTaxIdField(true);
        }

        public APIRequestGetPersonalAdAccounts requestTaxIdField(boolean value) {
            this.requestField("tax_id", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestTaxIdStatusField() {
            return this.requestTaxIdStatusField(true);
        }

        public APIRequestGetPersonalAdAccounts requestTaxIdStatusField(boolean value) {
            this.requestField("tax_id_status", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestTaxIdTypeField() {
            return this.requestTaxIdTypeField(true);
        }

        public APIRequestGetPersonalAdAccounts requestTaxIdTypeField(boolean value) {
            this.requestField("tax_id_type", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetPersonalAdAccounts requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestTimezoneNameField() {
            return this.requestTimezoneNameField(true);
        }

        public APIRequestGetPersonalAdAccounts requestTimezoneNameField(boolean value) {
            this.requestField("timezone_name", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestTimezoneOffsetHoursUtcField() {
            return this.requestTimezoneOffsetHoursUtcField(true);
        }

        public APIRequestGetPersonalAdAccounts requestTimezoneOffsetHoursUtcField(boolean value) {
            this.requestField("timezone_offset_hours_utc", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestTosAcceptedField() {
            return this.requestTosAcceptedField(true);
        }

        public APIRequestGetPersonalAdAccounts requestTosAcceptedField(boolean value) {
            this.requestField("tos_accepted", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestUserRoleField() {
            return this.requestUserRoleField(true);
        }

        public APIRequestGetPersonalAdAccounts requestUserRoleField(boolean value) {
            this.requestField("user_role", value);
            return this;
        }

        public APIRequestGetPersonalAdAccounts requestUserTosAcceptedField() {
            return this.requestUserTosAcceptedField(true);
        }

        public APIRequestGetPersonalAdAccounts requestUserTosAcceptedField(boolean value) {
            this.requestField("user_tos_accepted", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPermissions
    extends APIRequest<Permission> {
        APINodeList<Permission> lastResponse = null;
        public static final String[] PARAMS = new String[]{"permission", "status"};
        public static final String[] FIELDS = new String[]{"permission", "status", "id"};

        @Override
        public APINodeList<Permission> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Permission> parseResponse(String response) throws APIException {
            return Permission.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Permission> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Permission> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Permission>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Permission>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Permission>>(){

                public APINodeList<Permission> apply(String result) {
                    try {
                        return APIRequestGetPermissions.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetPermissions(String nodeId, APIContext context) {
            super(context, nodeId, "/permissions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPermissions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPermissions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPermissions setPermission(String permission) {
            this.setParam("permission", permission);
            return this;
        }

        public APIRequestGetPermissions setStatus(Permission.EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestGetPermissions setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestGetPermissions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPermissions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPermissions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPermissions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPermissions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPermissions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPermissions requestPermissionField() {
            return this.requestPermissionField(true);
        }

        public APIRequestGetPermissions requestPermissionField(boolean value) {
            this.requestField("permission", value);
            return this;
        }

        public APIRequestGetPermissions requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetPermissions requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetPermissions requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetPermissions requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeletePermissions
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"permission"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeletePermissions.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeletePermissions(String nodeId, APIContext context) {
            super(context, nodeId, "/permissions", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeletePermissions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeletePermissions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeletePermissions setPermission(String permission) {
            this.setParam("permission", permission);
            return this;
        }

        public APIRequestDeletePermissions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeletePermissions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeletePermissions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeletePermissions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeletePermissions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeletePermissions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreatePaymentAccountPhone
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"raw_input", "country_code", "default", "payment_type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreatePaymentAccountPhone.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreatePaymentAccountPhone(String nodeId, APIContext context) {
            super(context, nodeId, "/payment_account_phones", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreatePaymentAccountPhone setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreatePaymentAccountPhone setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreatePaymentAccountPhone setRawInput(String rawInput) {
            this.setParam("raw_input", rawInput);
            return this;
        }

        public APIRequestCreatePaymentAccountPhone setCountryCode(String countryCode) {
            this.setParam("country_code", countryCode);
            return this;
        }

        public APIRequestCreatePaymentAccountPhone setDefault(Boolean _default) {
            this.setParam("default", _default);
            return this;
        }

        public APIRequestCreatePaymentAccountPhone setDefault(String _default) {
            this.setParam("default", _default);
            return this;
        }

        public APIRequestCreatePaymentAccountPhone setPaymentType(EnumPaymentType paymentType) {
            this.setParam("payment_type", (Object)paymentType);
            return this;
        }

        public APIRequestCreatePaymentAccountPhone setPaymentType(String paymentType) {
            this.setParam("payment_type", paymentType);
            return this;
        }

        public APIRequestCreatePaymentAccountPhone requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreatePaymentAccountPhone requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePaymentAccountPhone requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreatePaymentAccountPhone requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePaymentAccountPhone requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreatePaymentAccountPhone requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreatePaymentAccountEmail
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"user_input_email", "default", "payment_type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreatePaymentAccountEmail.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreatePaymentAccountEmail(String nodeId, APIContext context) {
            super(context, nodeId, "/payment_account_emails", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreatePaymentAccountEmail setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreatePaymentAccountEmail setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreatePaymentAccountEmail setUserInputEmail(String userInputEmail) {
            this.setParam("user_input_email", userInputEmail);
            return this;
        }

        public APIRequestCreatePaymentAccountEmail setDefault(Boolean _default) {
            this.setParam("default", _default);
            return this;
        }

        public APIRequestCreatePaymentAccountEmail setDefault(String _default) {
            this.setParam("default", _default);
            return this;
        }

        public APIRequestCreatePaymentAccountEmail setPaymentType(EnumPaymentType paymentType) {
            this.setParam("payment_type", (Object)paymentType);
            return this;
        }

        public APIRequestCreatePaymentAccountEmail setPaymentType(String paymentType) {
            this.setParam("payment_type", paymentType);
            return this;
        }

        public APIRequestCreatePaymentAccountEmail requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreatePaymentAccountEmail requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePaymentAccountEmail requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreatePaymentAccountEmail requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePaymentAccountEmail requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreatePaymentAccountEmail requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateOpenGraphActionFeed
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"to", "client_secret", "preview", "ios_bundle_id", "android_key_hash", "proxied_app_id", "user_selected_tags", "user_selected_place", "added", "alias", "fb:channel", "created_time", "end_time", "expires_in", "fb:explicitly_shared", "image:height", "image:secure_url", "image:type", "image:url", "image:user_generated", "image:width", "no_feed_story", "no_action_link", "notify", "message", "place", "privacy", "ref", "scrape", "start_time", "tags"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateOpenGraphActionFeed.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateOpenGraphActionFeed(String nodeId, APIContext context) {
            super(context, nodeId, "/opengraphactionfeed", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateOpenGraphActionFeed setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateOpenGraphActionFeed setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setTo(String to) {
            this.setParam("to", to);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setClientSecret(String clientSecret) {
            this.setParam("client_secret", clientSecret);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setPreview(Boolean preview) {
            this.setParam("preview", preview);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setPreview(String preview) {
            this.setParam("preview", preview);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setIosBundleId(String iosBundleId) {
            this.setParam("ios_bundle_id", iosBundleId);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setAndroidKeyHash(String androidKeyHash) {
            this.setParam("android_key_hash", androidKeyHash);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setProxiedAppId(String proxiedAppId) {
            this.setParam("proxied_app_id", proxiedAppId);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setUserSelectedTags(Boolean userSelectedTags) {
            this.setParam("user_selected_tags", userSelectedTags);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setUserSelectedTags(String userSelectedTags) {
            this.setParam("user_selected_tags", userSelectedTags);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setUserSelectedPlace(Boolean userSelectedPlace) {
            this.setParam("user_selected_place", userSelectedPlace);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setUserSelectedPlace(String userSelectedPlace) {
            this.setParam("user_selected_place", userSelectedPlace);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setAdded(String added) {
            this.setParam("added", added);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setAlias(String alias) {
            this.setParam("alias", alias);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setFbChannel(String fbChannel) {
            this.setParam("fb:channel", fbChannel);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setCreatedTime(String createdTime) {
            this.setParam("created_time", createdTime);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setExpiresIn(Long expiresIn) {
            this.setParam("expires_in", expiresIn);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setExpiresIn(String expiresIn) {
            this.setParam("expires_in", expiresIn);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setFbExplicitlyShared(Boolean fbExplicitlyShared) {
            this.setParam("fb:explicitly_shared", fbExplicitlyShared);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setFbExplicitlyShared(String fbExplicitlyShared) {
            this.setParam("fb:explicitly_shared", fbExplicitlyShared);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setImageHeight(Long imageHeight) {
            this.setParam("image:height", imageHeight);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setImageHeight(String imageHeight) {
            this.setParam("image:height", imageHeight);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setImageSecureUrl(String imageSecureUrl) {
            this.setParam("image:secure_url", imageSecureUrl);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setImageType(String imageType) {
            this.setParam("image:type", imageType);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setImageUrl(String imageUrl) {
            this.setParam("image:url", imageUrl);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setImageUserGenerated(Boolean imageUserGenerated) {
            this.setParam("image:user_generated", imageUserGenerated);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setImageUserGenerated(String imageUserGenerated) {
            this.setParam("image:user_generated", imageUserGenerated);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setImageWidth(Long imageWidth) {
            this.setParam("image:width", imageWidth);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setImageWidth(String imageWidth) {
            this.setParam("image:width", imageWidth);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setNoFeedStory(Boolean noFeedStory) {
            this.setParam("no_feed_story", noFeedStory);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setNoFeedStory(String noFeedStory) {
            this.setParam("no_feed_story", noFeedStory);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setNoActionLink(Boolean noActionLink) {
            this.setParam("no_action_link", noActionLink);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setNoActionLink(String noActionLink) {
            this.setParam("no_action_link", noActionLink);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setNotify(Boolean notify) {
            this.setParam("notify", notify);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setNotify(String notify) {
            this.setParam("notify", notify);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setPlace(String place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setPrivacy(Object privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setRef(String ref) {
            this.setParam("ref", ref);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setScrape(Boolean scrape) {
            this.setParam("scrape", scrape);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setScrape(String scrape) {
            this.setParam("scrape", scrape);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setTags(List<Long> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateOpenGraphActionFeed requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateOpenGraphActionFeed requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateOpenGraphActionFeed requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateOpenGraphActionFeed requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateOpenGraphActionFeed requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateOpenGraphActionFeed requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateObject
    extends APIRequest<OpenGraphObject> {
        OpenGraphObject lastResponse = null;
        public static final String[] PARAMS = new String[]{"type", "object", "action_properties", "privacy", "ios_bundle_id", "android_key_hash", "proxied_app_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public OpenGraphObject getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public OpenGraphObject parseResponse(String response) throws APIException {
            return OpenGraphObject.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public OpenGraphObject execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public OpenGraphObject execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<OpenGraphObject> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<OpenGraphObject> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, OpenGraphObject>(){

                public OpenGraphObject apply(String result) {
                    try {
                        return APIRequestCreateObject.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateObject(String nodeId, APIContext context) {
            super(context, nodeId, "/objects", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateObject setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateObject setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateObject setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestCreateObject setObject(Object object) {
            this.setParam("object", object);
            return this;
        }

        public APIRequestCreateObject setObject(String object) {
            this.setParam("object", object);
            return this;
        }

        public APIRequestCreateObject setActionProperties(Object actionProperties) {
            this.setParam("action_properties", actionProperties);
            return this;
        }

        public APIRequestCreateObject setActionProperties(String actionProperties) {
            this.setParam("action_properties", actionProperties);
            return this;
        }

        public APIRequestCreateObject setPrivacy(Object privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateObject setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateObject setIosBundleId(String iosBundleId) {
            this.setParam("ios_bundle_id", iosBundleId);
            return this;
        }

        public APIRequestCreateObject setAndroidKeyHash(String androidKeyHash) {
            this.setParam("android_key_hash", androidKeyHash);
            return this;
        }

        public APIRequestCreateObject setProxiedAppId(String proxiedAppId) {
            this.setParam("proxied_app_id", proxiedAppId);
            return this;
        }

        public APIRequestCreateObject requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateObject requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateObject requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateObject requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateObject requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateObject requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetObjects
    extends APIRequest<OpenGraphObject> {
        APINodeList<OpenGraphObject> lastResponse = null;
        public static final String[] PARAMS = new String[]{"type"};
        public static final String[] FIELDS = new String[]{"admins", "application", "audio", "context", "created_time", "description", "determiner", "engagement", "id", "image", "is_scraped", "locale", "location", "post_action_id", "profile_id", "restrictions", "see_also", "site_name", "title", "type", "updated_time", "url", "video"};

        @Override
        public APINodeList<OpenGraphObject> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<OpenGraphObject> parseResponse(String response) throws APIException {
            return OpenGraphObject.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<OpenGraphObject> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<OpenGraphObject> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<OpenGraphObject>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<OpenGraphObject>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<OpenGraphObject>>(){

                public APINodeList<OpenGraphObject> apply(String result) {
                    try {
                        return APIRequestGetObjects.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetObjects(String nodeId, APIContext context) {
            super(context, nodeId, "/objects", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetObjects setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetObjects setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetObjects setType(Object type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetObjects setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetObjects requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetObjects requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetObjects requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetObjects requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetObjects requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetObjects requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetObjects requestAdminsField() {
            return this.requestAdminsField(true);
        }

        public APIRequestGetObjects requestAdminsField(boolean value) {
            this.requestField("admins", value);
            return this;
        }

        public APIRequestGetObjects requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGetObjects requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGetObjects requestAudioField() {
            return this.requestAudioField(true);
        }

        public APIRequestGetObjects requestAudioField(boolean value) {
            this.requestField("audio", value);
            return this;
        }

        public APIRequestGetObjects requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetObjects requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetObjects requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetObjects requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetObjects requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetObjects requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetObjects requestDeterminerField() {
            return this.requestDeterminerField(true);
        }

        public APIRequestGetObjects requestDeterminerField(boolean value) {
            this.requestField("determiner", value);
            return this;
        }

        public APIRequestGetObjects requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGetObjects requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGetObjects requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetObjects requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetObjects requestImageField() {
            return this.requestImageField(true);
        }

        public APIRequestGetObjects requestImageField(boolean value) {
            this.requestField("image", value);
            return this;
        }

        public APIRequestGetObjects requestIsScrapedField() {
            return this.requestIsScrapedField(true);
        }

        public APIRequestGetObjects requestIsScrapedField(boolean value) {
            this.requestField("is_scraped", value);
            return this;
        }

        public APIRequestGetObjects requestLocaleField() {
            return this.requestLocaleField(true);
        }

        public APIRequestGetObjects requestLocaleField(boolean value) {
            this.requestField("locale", value);
            return this;
        }

        public APIRequestGetObjects requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetObjects requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetObjects requestPostActionIdField() {
            return this.requestPostActionIdField(true);
        }

        public APIRequestGetObjects requestPostActionIdField(boolean value) {
            this.requestField("post_action_id", value);
            return this;
        }

        public APIRequestGetObjects requestProfileIdField() {
            return this.requestProfileIdField(true);
        }

        public APIRequestGetObjects requestProfileIdField(boolean value) {
            this.requestField("profile_id", value);
            return this;
        }

        public APIRequestGetObjects requestRestrictionsField() {
            return this.requestRestrictionsField(true);
        }

        public APIRequestGetObjects requestRestrictionsField(boolean value) {
            this.requestField("restrictions", value);
            return this;
        }

        public APIRequestGetObjects requestSeeAlsoField() {
            return this.requestSeeAlsoField(true);
        }

        public APIRequestGetObjects requestSeeAlsoField(boolean value) {
            this.requestField("see_also", value);
            return this;
        }

        public APIRequestGetObjects requestSiteNameField() {
            return this.requestSiteNameField(true);
        }

        public APIRequestGetObjects requestSiteNameField(boolean value) {
            this.requestField("site_name", value);
            return this;
        }

        public APIRequestGetObjects requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetObjects requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetObjects requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetObjects requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetObjects requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetObjects requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetObjects requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGetObjects requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGetObjects requestVideoField() {
            return this.requestVideoField(true);
        }

        public APIRequestGetObjects requestVideoField(boolean value) {
            this.requestField("video", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateNotification
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"seen", "read", "notif_ids", "filtering", "template", "href", "ref", "type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, User>(){

                public User apply(String result) {
                    try {
                        return APIRequestCreateNotification.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateNotification(String nodeId, APIContext context) {
            super(context, nodeId, "/notifications", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateNotification setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateNotification setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateNotification setSeen(Boolean seen) {
            this.setParam("seen", seen);
            return this;
        }

        public APIRequestCreateNotification setSeen(String seen) {
            this.setParam("seen", seen);
            return this;
        }

        public APIRequestCreateNotification setRead(Boolean read) {
            this.setParam("read", read);
            return this;
        }

        public APIRequestCreateNotification setRead(String read) {
            this.setParam("read", read);
            return this;
        }

        public APIRequestCreateNotification setNotifIds(List<String> notifIds) {
            this.setParam("notif_ids", notifIds);
            return this;
        }

        public APIRequestCreateNotification setNotifIds(String notifIds) {
            this.setParam("notif_ids", notifIds);
            return this;
        }

        public APIRequestCreateNotification setFiltering(List<EnumFiltering> filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestCreateNotification setFiltering(String filtering) {
            this.setParam("filtering", filtering);
            return this;
        }

        public APIRequestCreateNotification setTemplate(Object template) {
            this.setParam("template", template);
            return this;
        }

        public APIRequestCreateNotification setTemplate(String template) {
            this.setParam("template", template);
            return this;
        }

        public APIRequestCreateNotification setHref(Object href) {
            this.setParam("href", href);
            return this;
        }

        public APIRequestCreateNotification setHref(String href) {
            this.setParam("href", href);
            return this;
        }

        public APIRequestCreateNotification setRef(String ref) {
            this.setParam("ref", ref);
            return this;
        }

        public APIRequestCreateNotification setType(EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestCreateNotification setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestCreateNotification requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateNotification requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateNotification requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateNotification requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateNotification requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateNotification requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateNote
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"message", "subject", "privacy"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateNote.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateNote(String nodeId, APIContext context) {
            super(context, nodeId, "/notes", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateNote setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateNote setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateNote setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateNote setSubject(String subject) {
            this.setParam("subject", subject);
            return this;
        }

        public APIRequestCreateNote setPrivacy(Object privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateNote setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateNote requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateNote requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateNote requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateNote requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateNote requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateNote requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetMusic
    extends APIRequest<Page> {
        APINodeList<Page> lastResponse = null;
        public static final String[] PARAMS = new String[]{"target_id"};
        public static final String[] FIELDS = new String[]{"about", "access_token", "ad_campaign", "affiliation", "app_id", "app_links", "artists_we_like", "attire", "awards", "band_interests", "band_members", "best_page", "bio", "birthday", "booking_agent", "built", "business", "can_checkin", "can_post", "category", "category_list", "checkins", "company_overview", "connected_instagram_account", "contact_address", "context", "copyright_attribution_insights", "copyright_whitelisted_ig_partners", "country_page_likes", "cover", "culinary_team", "current_location", "description", "description_html", "directed_by", "display_subtext", "displayed_message_response_time", "emails", "engagement", "fan_count", "featured_video", "features", "food_styles", "founded", "general_info", "general_manager", "genre", "global_brand_page_name", "global_brand_parent_page", "global_brand_root_id", "has_added_app", "has_whatsapp_business_number", "has_whatsapp_number", "hometown", "hours", "id", "impressum", "influences", "instagram_business_account", "instant_articles_review_status", "is_always_open", "is_chain", "is_community_page", "is_eligible_for_branded_content", "is_messenger_bot_get_started_enabled", "is_messenger_platform_bot", "is_owned", "is_permanently_closed", "is_published", "is_unclaimed", "is_verified", "is_webhooks_subscribed", "keywords", "leadgen_form_preview_details", "leadgen_has_crm_integration", "leadgen_has_fat_ping_crm_integration", "leadgen_tos_acceptance_time", "leadgen_tos_accepted", "leadgen_tos_accepting_user", "link", "location", "members", "merchant_id", "merchant_review_status", "messenger_ads_default_icebreakers", "messenger_ads_default_page_welcome_message", "messenger_ads_default_quick_replies", "messenger_ads_quick_replies_type", "mission", "mpg", "name", "name_with_location_descriptor", "network", "new_like_count", "offer_eligible", "overall_star_rating", "page_token", "parent_page", "parking", "payment_options", "personal_info", "personal_interests", "pharma_safety_info", "phone", "place_type", "plot_outline", "preferred_audience", "press_contact", "price_range", "produced_by", "products", "promotion_eligible", "promotion_ineligible_reason", "public_transit", "publisher_space", "rating_count", "recipient", "record_label", "release_date", "restaurant_services", "restaurant_specialties", "schedule", "screenplay_by", "season", "single_line_address", "starring", "start_info", "store_code", "store_location_descriptor", "store_number", "studio", "supports_instant_articles", "talking_about_count", "unread_message_count", "unread_notif_count", "unseen_message_count", "username", "verification_status", "voip_info", "website", "were_here_count", "whatsapp_number", "written_by"};

        @Override
        public APINodeList<Page> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Page> parseResponse(String response) throws APIException {
            return Page.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Page> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Page>>(){

                public APINodeList<Page> apply(String result) {
                    try {
                        return APIRequestGetMusic.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetMusic(String nodeId, APIContext context) {
            super(context, nodeId, "/music", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetMusic setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetMusic setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetMusic setTargetId(String targetId) {
            this.setParam("target_id", targetId);
            return this;
        }

        public APIRequestGetMusic requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetMusic requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMusic requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetMusic requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMusic requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetMusic requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetMusic requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetMusic requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetMusic requestAccessTokenField() {
            return this.requestAccessTokenField(true);
        }

        public APIRequestGetMusic requestAccessTokenField(boolean value) {
            this.requestField("access_token", value);
            return this;
        }

        public APIRequestGetMusic requestAdCampaignField() {
            return this.requestAdCampaignField(true);
        }

        public APIRequestGetMusic requestAdCampaignField(boolean value) {
            this.requestField("ad_campaign", value);
            return this;
        }

        public APIRequestGetMusic requestAffiliationField() {
            return this.requestAffiliationField(true);
        }

        public APIRequestGetMusic requestAffiliationField(boolean value) {
            this.requestField("affiliation", value);
            return this;
        }

        public APIRequestGetMusic requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetMusic requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetMusic requestAppLinksField() {
            return this.requestAppLinksField(true);
        }

        public APIRequestGetMusic requestAppLinksField(boolean value) {
            this.requestField("app_links", value);
            return this;
        }

        public APIRequestGetMusic requestArtistsWeLikeField() {
            return this.requestArtistsWeLikeField(true);
        }

        public APIRequestGetMusic requestArtistsWeLikeField(boolean value) {
            this.requestField("artists_we_like", value);
            return this;
        }

        public APIRequestGetMusic requestAttireField() {
            return this.requestAttireField(true);
        }

        public APIRequestGetMusic requestAttireField(boolean value) {
            this.requestField("attire", value);
            return this;
        }

        public APIRequestGetMusic requestAwardsField() {
            return this.requestAwardsField(true);
        }

        public APIRequestGetMusic requestAwardsField(boolean value) {
            this.requestField("awards", value);
            return this;
        }

        public APIRequestGetMusic requestBandInterestsField() {
            return this.requestBandInterestsField(true);
        }

        public APIRequestGetMusic requestBandInterestsField(boolean value) {
            this.requestField("band_interests", value);
            return this;
        }

        public APIRequestGetMusic requestBandMembersField() {
            return this.requestBandMembersField(true);
        }

        public APIRequestGetMusic requestBandMembersField(boolean value) {
            this.requestField("band_members", value);
            return this;
        }

        public APIRequestGetMusic requestBestPageField() {
            return this.requestBestPageField(true);
        }

        public APIRequestGetMusic requestBestPageField(boolean value) {
            this.requestField("best_page", value);
            return this;
        }

        public APIRequestGetMusic requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetMusic requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetMusic requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetMusic requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetMusic requestBookingAgentField() {
            return this.requestBookingAgentField(true);
        }

        public APIRequestGetMusic requestBookingAgentField(boolean value) {
            this.requestField("booking_agent", value);
            return this;
        }

        public APIRequestGetMusic requestBuiltField() {
            return this.requestBuiltField(true);
        }

        public APIRequestGetMusic requestBuiltField(boolean value) {
            this.requestField("built", value);
            return this;
        }

        public APIRequestGetMusic requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetMusic requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetMusic requestCanCheckinField() {
            return this.requestCanCheckinField(true);
        }

        public APIRequestGetMusic requestCanCheckinField(boolean value) {
            this.requestField("can_checkin", value);
            return this;
        }

        public APIRequestGetMusic requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetMusic requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetMusic requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetMusic requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetMusic requestCategoryListField() {
            return this.requestCategoryListField(true);
        }

        public APIRequestGetMusic requestCategoryListField(boolean value) {
            this.requestField("category_list", value);
            return this;
        }

        public APIRequestGetMusic requestCheckinsField() {
            return this.requestCheckinsField(true);
        }

        public APIRequestGetMusic requestCheckinsField(boolean value) {
            this.requestField("checkins", value);
            return this;
        }

        public APIRequestGetMusic requestCompanyOverviewField() {
            return this.requestCompanyOverviewField(true);
        }

        public APIRequestGetMusic requestCompanyOverviewField(boolean value) {
            this.requestField("company_overview", value);
            return this;
        }

        public APIRequestGetMusic requestConnectedInstagramAccountField() {
            return this.requestConnectedInstagramAccountField(true);
        }

        public APIRequestGetMusic requestConnectedInstagramAccountField(boolean value) {
            this.requestField("connected_instagram_account", value);
            return this;
        }

        public APIRequestGetMusic requestContactAddressField() {
            return this.requestContactAddressField(true);
        }

        public APIRequestGetMusic requestContactAddressField(boolean value) {
            this.requestField("contact_address", value);
            return this;
        }

        public APIRequestGetMusic requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetMusic requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetMusic requestCopyrightAttributionInsightsField() {
            return this.requestCopyrightAttributionInsightsField(true);
        }

        public APIRequestGetMusic requestCopyrightAttributionInsightsField(boolean value) {
            this.requestField("copyright_attribution_insights", value);
            return this;
        }

        public APIRequestGetMusic requestCopyrightWhitelistedIgPartnersField() {
            return this.requestCopyrightWhitelistedIgPartnersField(true);
        }

        public APIRequestGetMusic requestCopyrightWhitelistedIgPartnersField(boolean value) {
            this.requestField("copyright_whitelisted_ig_partners", value);
            return this;
        }

        public APIRequestGetMusic requestCountryPageLikesField() {
            return this.requestCountryPageLikesField(true);
        }

        public APIRequestGetMusic requestCountryPageLikesField(boolean value) {
            this.requestField("country_page_likes", value);
            return this;
        }

        public APIRequestGetMusic requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetMusic requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetMusic requestCulinaryTeamField() {
            return this.requestCulinaryTeamField(true);
        }

        public APIRequestGetMusic requestCulinaryTeamField(boolean value) {
            this.requestField("culinary_team", value);
            return this;
        }

        public APIRequestGetMusic requestCurrentLocationField() {
            return this.requestCurrentLocationField(true);
        }

        public APIRequestGetMusic requestCurrentLocationField(boolean value) {
            this.requestField("current_location", value);
            return this;
        }

        public APIRequestGetMusic requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetMusic requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetMusic requestDescriptionHtmlField() {
            return this.requestDescriptionHtmlField(true);
        }

        public APIRequestGetMusic requestDescriptionHtmlField(boolean value) {
            this.requestField("description_html", value);
            return this;
        }

        public APIRequestGetMusic requestDirectedByField() {
            return this.requestDirectedByField(true);
        }

        public APIRequestGetMusic requestDirectedByField(boolean value) {
            this.requestField("directed_by", value);
            return this;
        }

        public APIRequestGetMusic requestDisplaySubtextField() {
            return this.requestDisplaySubtextField(true);
        }

        public APIRequestGetMusic requestDisplaySubtextField(boolean value) {
            this.requestField("display_subtext", value);
            return this;
        }

        public APIRequestGetMusic requestDisplayedMessageResponseTimeField() {
            return this.requestDisplayedMessageResponseTimeField(true);
        }

        public APIRequestGetMusic requestDisplayedMessageResponseTimeField(boolean value) {
            this.requestField("displayed_message_response_time", value);
            return this;
        }

        public APIRequestGetMusic requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGetMusic requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGetMusic requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGetMusic requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGetMusic requestFanCountField() {
            return this.requestFanCountField(true);
        }

        public APIRequestGetMusic requestFanCountField(boolean value) {
            this.requestField("fan_count", value);
            return this;
        }

        public APIRequestGetMusic requestFeaturedVideoField() {
            return this.requestFeaturedVideoField(true);
        }

        public APIRequestGetMusic requestFeaturedVideoField(boolean value) {
            this.requestField("featured_video", value);
            return this;
        }

        public APIRequestGetMusic requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGetMusic requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGetMusic requestFoodStylesField() {
            return this.requestFoodStylesField(true);
        }

        public APIRequestGetMusic requestFoodStylesField(boolean value) {
            this.requestField("food_styles", value);
            return this;
        }

        public APIRequestGetMusic requestFoundedField() {
            return this.requestFoundedField(true);
        }

        public APIRequestGetMusic requestFoundedField(boolean value) {
            this.requestField("founded", value);
            return this;
        }

        public APIRequestGetMusic requestGeneralInfoField() {
            return this.requestGeneralInfoField(true);
        }

        public APIRequestGetMusic requestGeneralInfoField(boolean value) {
            this.requestField("general_info", value);
            return this;
        }

        public APIRequestGetMusic requestGeneralManagerField() {
            return this.requestGeneralManagerField(true);
        }

        public APIRequestGetMusic requestGeneralManagerField(boolean value) {
            this.requestField("general_manager", value);
            return this;
        }

        public APIRequestGetMusic requestGenreField() {
            return this.requestGenreField(true);
        }

        public APIRequestGetMusic requestGenreField(boolean value) {
            this.requestField("genre", value);
            return this;
        }

        public APIRequestGetMusic requestGlobalBrandPageNameField() {
            return this.requestGlobalBrandPageNameField(true);
        }

        public APIRequestGetMusic requestGlobalBrandPageNameField(boolean value) {
            this.requestField("global_brand_page_name", value);
            return this;
        }

        public APIRequestGetMusic requestGlobalBrandParentPageField() {
            return this.requestGlobalBrandParentPageField(true);
        }

        public APIRequestGetMusic requestGlobalBrandParentPageField(boolean value) {
            this.requestField("global_brand_parent_page", value);
            return this;
        }

        public APIRequestGetMusic requestGlobalBrandRootIdField() {
            return this.requestGlobalBrandRootIdField(true);
        }

        public APIRequestGetMusic requestGlobalBrandRootIdField(boolean value) {
            this.requestField("global_brand_root_id", value);
            return this;
        }

        public APIRequestGetMusic requestHasAddedAppField() {
            return this.requestHasAddedAppField(true);
        }

        public APIRequestGetMusic requestHasAddedAppField(boolean value) {
            this.requestField("has_added_app", value);
            return this;
        }

        public APIRequestGetMusic requestHasWhatsappBusinessNumberField() {
            return this.requestHasWhatsappBusinessNumberField(true);
        }

        public APIRequestGetMusic requestHasWhatsappBusinessNumberField(boolean value) {
            this.requestField("has_whatsapp_business_number", value);
            return this;
        }

        public APIRequestGetMusic requestHasWhatsappNumberField() {
            return this.requestHasWhatsappNumberField(true);
        }

        public APIRequestGetMusic requestHasWhatsappNumberField(boolean value) {
            this.requestField("has_whatsapp_number", value);
            return this;
        }

        public APIRequestGetMusic requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetMusic requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetMusic requestHoursField() {
            return this.requestHoursField(true);
        }

        public APIRequestGetMusic requestHoursField(boolean value) {
            this.requestField("hours", value);
            return this;
        }

        public APIRequestGetMusic requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetMusic requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetMusic requestImpressumField() {
            return this.requestImpressumField(true);
        }

        public APIRequestGetMusic requestImpressumField(boolean value) {
            this.requestField("impressum", value);
            return this;
        }

        public APIRequestGetMusic requestInfluencesField() {
            return this.requestInfluencesField(true);
        }

        public APIRequestGetMusic requestInfluencesField(boolean value) {
            this.requestField("influences", value);
            return this;
        }

        public APIRequestGetMusic requestInstagramBusinessAccountField() {
            return this.requestInstagramBusinessAccountField(true);
        }

        public APIRequestGetMusic requestInstagramBusinessAccountField(boolean value) {
            this.requestField("instagram_business_account", value);
            return this;
        }

        public APIRequestGetMusic requestInstantArticlesReviewStatusField() {
            return this.requestInstantArticlesReviewStatusField(true);
        }

        public APIRequestGetMusic requestInstantArticlesReviewStatusField(boolean value) {
            this.requestField("instant_articles_review_status", value);
            return this;
        }

        public APIRequestGetMusic requestIsAlwaysOpenField() {
            return this.requestIsAlwaysOpenField(true);
        }

        public APIRequestGetMusic requestIsAlwaysOpenField(boolean value) {
            this.requestField("is_always_open", value);
            return this;
        }

        public APIRequestGetMusic requestIsChainField() {
            return this.requestIsChainField(true);
        }

        public APIRequestGetMusic requestIsChainField(boolean value) {
            this.requestField("is_chain", value);
            return this;
        }

        public APIRequestGetMusic requestIsCommunityPageField() {
            return this.requestIsCommunityPageField(true);
        }

        public APIRequestGetMusic requestIsCommunityPageField(boolean value) {
            this.requestField("is_community_page", value);
            return this;
        }

        public APIRequestGetMusic requestIsEligibleForBrandedContentField() {
            return this.requestIsEligibleForBrandedContentField(true);
        }

        public APIRequestGetMusic requestIsEligibleForBrandedContentField(boolean value) {
            this.requestField("is_eligible_for_branded_content", value);
            return this;
        }

        public APIRequestGetMusic requestIsMessengerBotGetStartedEnabledField() {
            return this.requestIsMessengerBotGetStartedEnabledField(true);
        }

        public APIRequestGetMusic requestIsMessengerBotGetStartedEnabledField(boolean value) {
            this.requestField("is_messenger_bot_get_started_enabled", value);
            return this;
        }

        public APIRequestGetMusic requestIsMessengerPlatformBotField() {
            return this.requestIsMessengerPlatformBotField(true);
        }

        public APIRequestGetMusic requestIsMessengerPlatformBotField(boolean value) {
            this.requestField("is_messenger_platform_bot", value);
            return this;
        }

        public APIRequestGetMusic requestIsOwnedField() {
            return this.requestIsOwnedField(true);
        }

        public APIRequestGetMusic requestIsOwnedField(boolean value) {
            this.requestField("is_owned", value);
            return this;
        }

        public APIRequestGetMusic requestIsPermanentlyClosedField() {
            return this.requestIsPermanentlyClosedField(true);
        }

        public APIRequestGetMusic requestIsPermanentlyClosedField(boolean value) {
            this.requestField("is_permanently_closed", value);
            return this;
        }

        public APIRequestGetMusic requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetMusic requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetMusic requestIsUnclaimedField() {
            return this.requestIsUnclaimedField(true);
        }

        public APIRequestGetMusic requestIsUnclaimedField(boolean value) {
            this.requestField("is_unclaimed", value);
            return this;
        }

        public APIRequestGetMusic requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetMusic requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetMusic requestIsWebhooksSubscribedField() {
            return this.requestIsWebhooksSubscribedField(true);
        }

        public APIRequestGetMusic requestIsWebhooksSubscribedField(boolean value) {
            this.requestField("is_webhooks_subscribed", value);
            return this;
        }

        public APIRequestGetMusic requestKeywordsField() {
            return this.requestKeywordsField(true);
        }

        public APIRequestGetMusic requestKeywordsField(boolean value) {
            this.requestField("keywords", value);
            return this;
        }

        public APIRequestGetMusic requestLeadgenFormPreviewDetailsField() {
            return this.requestLeadgenFormPreviewDetailsField(true);
        }

        public APIRequestGetMusic requestLeadgenFormPreviewDetailsField(boolean value) {
            this.requestField("leadgen_form_preview_details", value);
            return this;
        }

        public APIRequestGetMusic requestLeadgenHasCrmIntegrationField() {
            return this.requestLeadgenHasCrmIntegrationField(true);
        }

        public APIRequestGetMusic requestLeadgenHasCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_crm_integration", value);
            return this;
        }

        public APIRequestGetMusic requestLeadgenHasFatPingCrmIntegrationField() {
            return this.requestLeadgenHasFatPingCrmIntegrationField(true);
        }

        public APIRequestGetMusic requestLeadgenHasFatPingCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_fat_ping_crm_integration", value);
            return this;
        }

        public APIRequestGetMusic requestLeadgenTosAcceptanceTimeField() {
            return this.requestLeadgenTosAcceptanceTimeField(true);
        }

        public APIRequestGetMusic requestLeadgenTosAcceptanceTimeField(boolean value) {
            this.requestField("leadgen_tos_acceptance_time", value);
            return this;
        }

        public APIRequestGetMusic requestLeadgenTosAcceptedField() {
            return this.requestLeadgenTosAcceptedField(true);
        }

        public APIRequestGetMusic requestLeadgenTosAcceptedField(boolean value) {
            this.requestField("leadgen_tos_accepted", value);
            return this;
        }

        public APIRequestGetMusic requestLeadgenTosAcceptingUserField() {
            return this.requestLeadgenTosAcceptingUserField(true);
        }

        public APIRequestGetMusic requestLeadgenTosAcceptingUserField(boolean value) {
            this.requestField("leadgen_tos_accepting_user", value);
            return this;
        }

        public APIRequestGetMusic requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetMusic requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetMusic requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetMusic requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetMusic requestMembersField() {
            return this.requestMembersField(true);
        }

        public APIRequestGetMusic requestMembersField(boolean value) {
            this.requestField("members", value);
            return this;
        }

        public APIRequestGetMusic requestMerchantIdField() {
            return this.requestMerchantIdField(true);
        }

        public APIRequestGetMusic requestMerchantIdField(boolean value) {
            this.requestField("merchant_id", value);
            return this;
        }

        public APIRequestGetMusic requestMerchantReviewStatusField() {
            return this.requestMerchantReviewStatusField(true);
        }

        public APIRequestGetMusic requestMerchantReviewStatusField(boolean value) {
            this.requestField("merchant_review_status", value);
            return this;
        }

        public APIRequestGetMusic requestMessengerAdsDefaultIcebreakersField() {
            return this.requestMessengerAdsDefaultIcebreakersField(true);
        }

        public APIRequestGetMusic requestMessengerAdsDefaultIcebreakersField(boolean value) {
            this.requestField("messenger_ads_default_icebreakers", value);
            return this;
        }

        public APIRequestGetMusic requestMessengerAdsDefaultPageWelcomeMessageField() {
            return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
        }

        public APIRequestGetMusic requestMessengerAdsDefaultPageWelcomeMessageField(boolean value) {
            this.requestField("messenger_ads_default_page_welcome_message", value);
            return this;
        }

        public APIRequestGetMusic requestMessengerAdsDefaultQuickRepliesField() {
            return this.requestMessengerAdsDefaultQuickRepliesField(true);
        }

        public APIRequestGetMusic requestMessengerAdsDefaultQuickRepliesField(boolean value) {
            this.requestField("messenger_ads_default_quick_replies", value);
            return this;
        }

        public APIRequestGetMusic requestMessengerAdsQuickRepliesTypeField() {
            return this.requestMessengerAdsQuickRepliesTypeField(true);
        }

        public APIRequestGetMusic requestMessengerAdsQuickRepliesTypeField(boolean value) {
            this.requestField("messenger_ads_quick_replies_type", value);
            return this;
        }

        public APIRequestGetMusic requestMissionField() {
            return this.requestMissionField(true);
        }

        public APIRequestGetMusic requestMissionField(boolean value) {
            this.requestField("mission", value);
            return this;
        }

        public APIRequestGetMusic requestMpgField() {
            return this.requestMpgField(true);
        }

        public APIRequestGetMusic requestMpgField(boolean value) {
            this.requestField("mpg", value);
            return this;
        }

        public APIRequestGetMusic requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetMusic requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetMusic requestNameWithLocationDescriptorField() {
            return this.requestNameWithLocationDescriptorField(true);
        }

        public APIRequestGetMusic requestNameWithLocationDescriptorField(boolean value) {
            this.requestField("name_with_location_descriptor", value);
            return this;
        }

        public APIRequestGetMusic requestNetworkField() {
            return this.requestNetworkField(true);
        }

        public APIRequestGetMusic requestNetworkField(boolean value) {
            this.requestField("network", value);
            return this;
        }

        public APIRequestGetMusic requestNewLikeCountField() {
            return this.requestNewLikeCountField(true);
        }

        public APIRequestGetMusic requestNewLikeCountField(boolean value) {
            this.requestField("new_like_count", value);
            return this;
        }

        public APIRequestGetMusic requestOfferEligibleField() {
            return this.requestOfferEligibleField(true);
        }

        public APIRequestGetMusic requestOfferEligibleField(boolean value) {
            this.requestField("offer_eligible", value);
            return this;
        }

        public APIRequestGetMusic requestOverallStarRatingField() {
            return this.requestOverallStarRatingField(true);
        }

        public APIRequestGetMusic requestOverallStarRatingField(boolean value) {
            this.requestField("overall_star_rating", value);
            return this;
        }

        public APIRequestGetMusic requestPageTokenField() {
            return this.requestPageTokenField(true);
        }

        public APIRequestGetMusic requestPageTokenField(boolean value) {
            this.requestField("page_token", value);
            return this;
        }

        public APIRequestGetMusic requestParentPageField() {
            return this.requestParentPageField(true);
        }

        public APIRequestGetMusic requestParentPageField(boolean value) {
            this.requestField("parent_page", value);
            return this;
        }

        public APIRequestGetMusic requestParkingField() {
            return this.requestParkingField(true);
        }

        public APIRequestGetMusic requestParkingField(boolean value) {
            this.requestField("parking", value);
            return this;
        }

        public APIRequestGetMusic requestPaymentOptionsField() {
            return this.requestPaymentOptionsField(true);
        }

        public APIRequestGetMusic requestPaymentOptionsField(boolean value) {
            this.requestField("payment_options", value);
            return this;
        }

        public APIRequestGetMusic requestPersonalInfoField() {
            return this.requestPersonalInfoField(true);
        }

        public APIRequestGetMusic requestPersonalInfoField(boolean value) {
            this.requestField("personal_info", value);
            return this;
        }

        public APIRequestGetMusic requestPersonalInterestsField() {
            return this.requestPersonalInterestsField(true);
        }

        public APIRequestGetMusic requestPersonalInterestsField(boolean value) {
            this.requestField("personal_interests", value);
            return this;
        }

        public APIRequestGetMusic requestPharmaSafetyInfoField() {
            return this.requestPharmaSafetyInfoField(true);
        }

        public APIRequestGetMusic requestPharmaSafetyInfoField(boolean value) {
            this.requestField("pharma_safety_info", value);
            return this;
        }

        public APIRequestGetMusic requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGetMusic requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGetMusic requestPlaceTypeField() {
            return this.requestPlaceTypeField(true);
        }

        public APIRequestGetMusic requestPlaceTypeField(boolean value) {
            this.requestField("place_type", value);
            return this;
        }

        public APIRequestGetMusic requestPlotOutlineField() {
            return this.requestPlotOutlineField(true);
        }

        public APIRequestGetMusic requestPlotOutlineField(boolean value) {
            this.requestField("plot_outline", value);
            return this;
        }

        public APIRequestGetMusic requestPreferredAudienceField() {
            return this.requestPreferredAudienceField(true);
        }

        public APIRequestGetMusic requestPreferredAudienceField(boolean value) {
            this.requestField("preferred_audience", value);
            return this;
        }

        public APIRequestGetMusic requestPressContactField() {
            return this.requestPressContactField(true);
        }

        public APIRequestGetMusic requestPressContactField(boolean value) {
            this.requestField("press_contact", value);
            return this;
        }

        public APIRequestGetMusic requestPriceRangeField() {
            return this.requestPriceRangeField(true);
        }

        public APIRequestGetMusic requestPriceRangeField(boolean value) {
            this.requestField("price_range", value);
            return this;
        }

        public APIRequestGetMusic requestProducedByField() {
            return this.requestProducedByField(true);
        }

        public APIRequestGetMusic requestProducedByField(boolean value) {
            this.requestField("produced_by", value);
            return this;
        }

        public APIRequestGetMusic requestProductsField() {
            return this.requestProductsField(true);
        }

        public APIRequestGetMusic requestProductsField(boolean value) {
            this.requestField("products", value);
            return this;
        }

        public APIRequestGetMusic requestPromotionEligibleField() {
            return this.requestPromotionEligibleField(true);
        }

        public APIRequestGetMusic requestPromotionEligibleField(boolean value) {
            this.requestField("promotion_eligible", value);
            return this;
        }

        public APIRequestGetMusic requestPromotionIneligibleReasonField() {
            return this.requestPromotionIneligibleReasonField(true);
        }

        public APIRequestGetMusic requestPromotionIneligibleReasonField(boolean value) {
            this.requestField("promotion_ineligible_reason", value);
            return this;
        }

        public APIRequestGetMusic requestPublicTransitField() {
            return this.requestPublicTransitField(true);
        }

        public APIRequestGetMusic requestPublicTransitField(boolean value) {
            this.requestField("public_transit", value);
            return this;
        }

        public APIRequestGetMusic requestPublisherSpaceField() {
            return this.requestPublisherSpaceField(true);
        }

        public APIRequestGetMusic requestPublisherSpaceField(boolean value) {
            this.requestField("publisher_space", value);
            return this;
        }

        public APIRequestGetMusic requestRatingCountField() {
            return this.requestRatingCountField(true);
        }

        public APIRequestGetMusic requestRatingCountField(boolean value) {
            this.requestField("rating_count", value);
            return this;
        }

        public APIRequestGetMusic requestRecipientField() {
            return this.requestRecipientField(true);
        }

        public APIRequestGetMusic requestRecipientField(boolean value) {
            this.requestField("recipient", value);
            return this;
        }

        public APIRequestGetMusic requestRecordLabelField() {
            return this.requestRecordLabelField(true);
        }

        public APIRequestGetMusic requestRecordLabelField(boolean value) {
            this.requestField("record_label", value);
            return this;
        }

        public APIRequestGetMusic requestReleaseDateField() {
            return this.requestReleaseDateField(true);
        }

        public APIRequestGetMusic requestReleaseDateField(boolean value) {
            this.requestField("release_date", value);
            return this;
        }

        public APIRequestGetMusic requestRestaurantServicesField() {
            return this.requestRestaurantServicesField(true);
        }

        public APIRequestGetMusic requestRestaurantServicesField(boolean value) {
            this.requestField("restaurant_services", value);
            return this;
        }

        public APIRequestGetMusic requestRestaurantSpecialtiesField() {
            return this.requestRestaurantSpecialtiesField(true);
        }

        public APIRequestGetMusic requestRestaurantSpecialtiesField(boolean value) {
            this.requestField("restaurant_specialties", value);
            return this;
        }

        public APIRequestGetMusic requestScheduleField() {
            return this.requestScheduleField(true);
        }

        public APIRequestGetMusic requestScheduleField(boolean value) {
            this.requestField("schedule", value);
            return this;
        }

        public APIRequestGetMusic requestScreenplayByField() {
            return this.requestScreenplayByField(true);
        }

        public APIRequestGetMusic requestScreenplayByField(boolean value) {
            this.requestField("screenplay_by", value);
            return this;
        }

        public APIRequestGetMusic requestSeasonField() {
            return this.requestSeasonField(true);
        }

        public APIRequestGetMusic requestSeasonField(boolean value) {
            this.requestField("season", value);
            return this;
        }

        public APIRequestGetMusic requestSingleLineAddressField() {
            return this.requestSingleLineAddressField(true);
        }

        public APIRequestGetMusic requestSingleLineAddressField(boolean value) {
            this.requestField("single_line_address", value);
            return this;
        }

        public APIRequestGetMusic requestStarringField() {
            return this.requestStarringField(true);
        }

        public APIRequestGetMusic requestStarringField(boolean value) {
            this.requestField("starring", value);
            return this;
        }

        public APIRequestGetMusic requestStartInfoField() {
            return this.requestStartInfoField(true);
        }

        public APIRequestGetMusic requestStartInfoField(boolean value) {
            this.requestField("start_info", value);
            return this;
        }

        public APIRequestGetMusic requestStoreCodeField() {
            return this.requestStoreCodeField(true);
        }

        public APIRequestGetMusic requestStoreCodeField(boolean value) {
            this.requestField("store_code", value);
            return this;
        }

        public APIRequestGetMusic requestStoreLocationDescriptorField() {
            return this.requestStoreLocationDescriptorField(true);
        }

        public APIRequestGetMusic requestStoreLocationDescriptorField(boolean value) {
            this.requestField("store_location_descriptor", value);
            return this;
        }

        public APIRequestGetMusic requestStoreNumberField() {
            return this.requestStoreNumberField(true);
        }

        public APIRequestGetMusic requestStoreNumberField(boolean value) {
            this.requestField("store_number", value);
            return this;
        }

        public APIRequestGetMusic requestStudioField() {
            return this.requestStudioField(true);
        }

        public APIRequestGetMusic requestStudioField(boolean value) {
            this.requestField("studio", value);
            return this;
        }

        public APIRequestGetMusic requestSupportsInstantArticlesField() {
            return this.requestSupportsInstantArticlesField(true);
        }

        public APIRequestGetMusic requestSupportsInstantArticlesField(boolean value) {
            this.requestField("supports_instant_articles", value);
            return this;
        }

        public APIRequestGetMusic requestTalkingAboutCountField() {
            return this.requestTalkingAboutCountField(true);
        }

        public APIRequestGetMusic requestTalkingAboutCountField(boolean value) {
            this.requestField("talking_about_count", value);
            return this;
        }

        public APIRequestGetMusic requestUnreadMessageCountField() {
            return this.requestUnreadMessageCountField(true);
        }

        public APIRequestGetMusic requestUnreadMessageCountField(boolean value) {
            this.requestField("unread_message_count", value);
            return this;
        }

        public APIRequestGetMusic requestUnreadNotifCountField() {
            return this.requestUnreadNotifCountField(true);
        }

        public APIRequestGetMusic requestUnreadNotifCountField(boolean value) {
            this.requestField("unread_notif_count", value);
            return this;
        }

        public APIRequestGetMusic requestUnseenMessageCountField() {
            return this.requestUnseenMessageCountField(true);
        }

        public APIRequestGetMusic requestUnseenMessageCountField(boolean value) {
            this.requestField("unseen_message_count", value);
            return this;
        }

        public APIRequestGetMusic requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetMusic requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGetMusic requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetMusic requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetMusic requestVoipInfoField() {
            return this.requestVoipInfoField(true);
        }

        public APIRequestGetMusic requestVoipInfoField(boolean value) {
            this.requestField("voip_info", value);
            return this;
        }

        public APIRequestGetMusic requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetMusic requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetMusic requestWereHereCountField() {
            return this.requestWereHereCountField(true);
        }

        public APIRequestGetMusic requestWereHereCountField(boolean value) {
            this.requestField("were_here_count", value);
            return this;
        }

        public APIRequestGetMusic requestWhatsappNumberField() {
            return this.requestWhatsappNumberField(true);
        }

        public APIRequestGetMusic requestWhatsappNumberField(boolean value) {
            this.requestField("whatsapp_number", value);
            return this;
        }

        public APIRequestGetMusic requestWrittenByField() {
            return this.requestWrittenByField(true);
        }

        public APIRequestGetMusic requestWrittenByField(boolean value) {
            this.requestField("written_by", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetMovies
    extends APIRequest<Page> {
        APINodeList<Page> lastResponse = null;
        public static final String[] PARAMS = new String[]{"target_id"};
        public static final String[] FIELDS = new String[]{"about", "access_token", "ad_campaign", "affiliation", "app_id", "app_links", "artists_we_like", "attire", "awards", "band_interests", "band_members", "best_page", "bio", "birthday", "booking_agent", "built", "business", "can_checkin", "can_post", "category", "category_list", "checkins", "company_overview", "connected_instagram_account", "contact_address", "context", "copyright_attribution_insights", "copyright_whitelisted_ig_partners", "country_page_likes", "cover", "culinary_team", "current_location", "description", "description_html", "directed_by", "display_subtext", "displayed_message_response_time", "emails", "engagement", "fan_count", "featured_video", "features", "food_styles", "founded", "general_info", "general_manager", "genre", "global_brand_page_name", "global_brand_parent_page", "global_brand_root_id", "has_added_app", "has_whatsapp_business_number", "has_whatsapp_number", "hometown", "hours", "id", "impressum", "influences", "instagram_business_account", "instant_articles_review_status", "is_always_open", "is_chain", "is_community_page", "is_eligible_for_branded_content", "is_messenger_bot_get_started_enabled", "is_messenger_platform_bot", "is_owned", "is_permanently_closed", "is_published", "is_unclaimed", "is_verified", "is_webhooks_subscribed", "keywords", "leadgen_form_preview_details", "leadgen_has_crm_integration", "leadgen_has_fat_ping_crm_integration", "leadgen_tos_acceptance_time", "leadgen_tos_accepted", "leadgen_tos_accepting_user", "link", "location", "members", "merchant_id", "merchant_review_status", "messenger_ads_default_icebreakers", "messenger_ads_default_page_welcome_message", "messenger_ads_default_quick_replies", "messenger_ads_quick_replies_type", "mission", "mpg", "name", "name_with_location_descriptor", "network", "new_like_count", "offer_eligible", "overall_star_rating", "page_token", "parent_page", "parking", "payment_options", "personal_info", "personal_interests", "pharma_safety_info", "phone", "place_type", "plot_outline", "preferred_audience", "press_contact", "price_range", "produced_by", "products", "promotion_eligible", "promotion_ineligible_reason", "public_transit", "publisher_space", "rating_count", "recipient", "record_label", "release_date", "restaurant_services", "restaurant_specialties", "schedule", "screenplay_by", "season", "single_line_address", "starring", "start_info", "store_code", "store_location_descriptor", "store_number", "studio", "supports_instant_articles", "talking_about_count", "unread_message_count", "unread_notif_count", "unseen_message_count", "username", "verification_status", "voip_info", "website", "were_here_count", "whatsapp_number", "written_by"};

        @Override
        public APINodeList<Page> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Page> parseResponse(String response) throws APIException {
            return Page.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Page> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Page>>(){

                public APINodeList<Page> apply(String result) {
                    try {
                        return APIRequestGetMovies.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetMovies(String nodeId, APIContext context) {
            super(context, nodeId, "/movies", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetMovies setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetMovies setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetMovies setTargetId(String targetId) {
            this.setParam("target_id", targetId);
            return this;
        }

        public APIRequestGetMovies requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetMovies requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMovies requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetMovies requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMovies requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetMovies requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetMovies requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetMovies requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetMovies requestAccessTokenField() {
            return this.requestAccessTokenField(true);
        }

        public APIRequestGetMovies requestAccessTokenField(boolean value) {
            this.requestField("access_token", value);
            return this;
        }

        public APIRequestGetMovies requestAdCampaignField() {
            return this.requestAdCampaignField(true);
        }

        public APIRequestGetMovies requestAdCampaignField(boolean value) {
            this.requestField("ad_campaign", value);
            return this;
        }

        public APIRequestGetMovies requestAffiliationField() {
            return this.requestAffiliationField(true);
        }

        public APIRequestGetMovies requestAffiliationField(boolean value) {
            this.requestField("affiliation", value);
            return this;
        }

        public APIRequestGetMovies requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetMovies requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetMovies requestAppLinksField() {
            return this.requestAppLinksField(true);
        }

        public APIRequestGetMovies requestAppLinksField(boolean value) {
            this.requestField("app_links", value);
            return this;
        }

        public APIRequestGetMovies requestArtistsWeLikeField() {
            return this.requestArtistsWeLikeField(true);
        }

        public APIRequestGetMovies requestArtistsWeLikeField(boolean value) {
            this.requestField("artists_we_like", value);
            return this;
        }

        public APIRequestGetMovies requestAttireField() {
            return this.requestAttireField(true);
        }

        public APIRequestGetMovies requestAttireField(boolean value) {
            this.requestField("attire", value);
            return this;
        }

        public APIRequestGetMovies requestAwardsField() {
            return this.requestAwardsField(true);
        }

        public APIRequestGetMovies requestAwardsField(boolean value) {
            this.requestField("awards", value);
            return this;
        }

        public APIRequestGetMovies requestBandInterestsField() {
            return this.requestBandInterestsField(true);
        }

        public APIRequestGetMovies requestBandInterestsField(boolean value) {
            this.requestField("band_interests", value);
            return this;
        }

        public APIRequestGetMovies requestBandMembersField() {
            return this.requestBandMembersField(true);
        }

        public APIRequestGetMovies requestBandMembersField(boolean value) {
            this.requestField("band_members", value);
            return this;
        }

        public APIRequestGetMovies requestBestPageField() {
            return this.requestBestPageField(true);
        }

        public APIRequestGetMovies requestBestPageField(boolean value) {
            this.requestField("best_page", value);
            return this;
        }

        public APIRequestGetMovies requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetMovies requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetMovies requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetMovies requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetMovies requestBookingAgentField() {
            return this.requestBookingAgentField(true);
        }

        public APIRequestGetMovies requestBookingAgentField(boolean value) {
            this.requestField("booking_agent", value);
            return this;
        }

        public APIRequestGetMovies requestBuiltField() {
            return this.requestBuiltField(true);
        }

        public APIRequestGetMovies requestBuiltField(boolean value) {
            this.requestField("built", value);
            return this;
        }

        public APIRequestGetMovies requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetMovies requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetMovies requestCanCheckinField() {
            return this.requestCanCheckinField(true);
        }

        public APIRequestGetMovies requestCanCheckinField(boolean value) {
            this.requestField("can_checkin", value);
            return this;
        }

        public APIRequestGetMovies requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetMovies requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetMovies requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetMovies requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetMovies requestCategoryListField() {
            return this.requestCategoryListField(true);
        }

        public APIRequestGetMovies requestCategoryListField(boolean value) {
            this.requestField("category_list", value);
            return this;
        }

        public APIRequestGetMovies requestCheckinsField() {
            return this.requestCheckinsField(true);
        }

        public APIRequestGetMovies requestCheckinsField(boolean value) {
            this.requestField("checkins", value);
            return this;
        }

        public APIRequestGetMovies requestCompanyOverviewField() {
            return this.requestCompanyOverviewField(true);
        }

        public APIRequestGetMovies requestCompanyOverviewField(boolean value) {
            this.requestField("company_overview", value);
            return this;
        }

        public APIRequestGetMovies requestConnectedInstagramAccountField() {
            return this.requestConnectedInstagramAccountField(true);
        }

        public APIRequestGetMovies requestConnectedInstagramAccountField(boolean value) {
            this.requestField("connected_instagram_account", value);
            return this;
        }

        public APIRequestGetMovies requestContactAddressField() {
            return this.requestContactAddressField(true);
        }

        public APIRequestGetMovies requestContactAddressField(boolean value) {
            this.requestField("contact_address", value);
            return this;
        }

        public APIRequestGetMovies requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetMovies requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetMovies requestCopyrightAttributionInsightsField() {
            return this.requestCopyrightAttributionInsightsField(true);
        }

        public APIRequestGetMovies requestCopyrightAttributionInsightsField(boolean value) {
            this.requestField("copyright_attribution_insights", value);
            return this;
        }

        public APIRequestGetMovies requestCopyrightWhitelistedIgPartnersField() {
            return this.requestCopyrightWhitelistedIgPartnersField(true);
        }

        public APIRequestGetMovies requestCopyrightWhitelistedIgPartnersField(boolean value) {
            this.requestField("copyright_whitelisted_ig_partners", value);
            return this;
        }

        public APIRequestGetMovies requestCountryPageLikesField() {
            return this.requestCountryPageLikesField(true);
        }

        public APIRequestGetMovies requestCountryPageLikesField(boolean value) {
            this.requestField("country_page_likes", value);
            return this;
        }

        public APIRequestGetMovies requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetMovies requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetMovies requestCulinaryTeamField() {
            return this.requestCulinaryTeamField(true);
        }

        public APIRequestGetMovies requestCulinaryTeamField(boolean value) {
            this.requestField("culinary_team", value);
            return this;
        }

        public APIRequestGetMovies requestCurrentLocationField() {
            return this.requestCurrentLocationField(true);
        }

        public APIRequestGetMovies requestCurrentLocationField(boolean value) {
            this.requestField("current_location", value);
            return this;
        }

        public APIRequestGetMovies requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetMovies requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetMovies requestDescriptionHtmlField() {
            return this.requestDescriptionHtmlField(true);
        }

        public APIRequestGetMovies requestDescriptionHtmlField(boolean value) {
            this.requestField("description_html", value);
            return this;
        }

        public APIRequestGetMovies requestDirectedByField() {
            return this.requestDirectedByField(true);
        }

        public APIRequestGetMovies requestDirectedByField(boolean value) {
            this.requestField("directed_by", value);
            return this;
        }

        public APIRequestGetMovies requestDisplaySubtextField() {
            return this.requestDisplaySubtextField(true);
        }

        public APIRequestGetMovies requestDisplaySubtextField(boolean value) {
            this.requestField("display_subtext", value);
            return this;
        }

        public APIRequestGetMovies requestDisplayedMessageResponseTimeField() {
            return this.requestDisplayedMessageResponseTimeField(true);
        }

        public APIRequestGetMovies requestDisplayedMessageResponseTimeField(boolean value) {
            this.requestField("displayed_message_response_time", value);
            return this;
        }

        public APIRequestGetMovies requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGetMovies requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGetMovies requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGetMovies requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGetMovies requestFanCountField() {
            return this.requestFanCountField(true);
        }

        public APIRequestGetMovies requestFanCountField(boolean value) {
            this.requestField("fan_count", value);
            return this;
        }

        public APIRequestGetMovies requestFeaturedVideoField() {
            return this.requestFeaturedVideoField(true);
        }

        public APIRequestGetMovies requestFeaturedVideoField(boolean value) {
            this.requestField("featured_video", value);
            return this;
        }

        public APIRequestGetMovies requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGetMovies requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGetMovies requestFoodStylesField() {
            return this.requestFoodStylesField(true);
        }

        public APIRequestGetMovies requestFoodStylesField(boolean value) {
            this.requestField("food_styles", value);
            return this;
        }

        public APIRequestGetMovies requestFoundedField() {
            return this.requestFoundedField(true);
        }

        public APIRequestGetMovies requestFoundedField(boolean value) {
            this.requestField("founded", value);
            return this;
        }

        public APIRequestGetMovies requestGeneralInfoField() {
            return this.requestGeneralInfoField(true);
        }

        public APIRequestGetMovies requestGeneralInfoField(boolean value) {
            this.requestField("general_info", value);
            return this;
        }

        public APIRequestGetMovies requestGeneralManagerField() {
            return this.requestGeneralManagerField(true);
        }

        public APIRequestGetMovies requestGeneralManagerField(boolean value) {
            this.requestField("general_manager", value);
            return this;
        }

        public APIRequestGetMovies requestGenreField() {
            return this.requestGenreField(true);
        }

        public APIRequestGetMovies requestGenreField(boolean value) {
            this.requestField("genre", value);
            return this;
        }

        public APIRequestGetMovies requestGlobalBrandPageNameField() {
            return this.requestGlobalBrandPageNameField(true);
        }

        public APIRequestGetMovies requestGlobalBrandPageNameField(boolean value) {
            this.requestField("global_brand_page_name", value);
            return this;
        }

        public APIRequestGetMovies requestGlobalBrandParentPageField() {
            return this.requestGlobalBrandParentPageField(true);
        }

        public APIRequestGetMovies requestGlobalBrandParentPageField(boolean value) {
            this.requestField("global_brand_parent_page", value);
            return this;
        }

        public APIRequestGetMovies requestGlobalBrandRootIdField() {
            return this.requestGlobalBrandRootIdField(true);
        }

        public APIRequestGetMovies requestGlobalBrandRootIdField(boolean value) {
            this.requestField("global_brand_root_id", value);
            return this;
        }

        public APIRequestGetMovies requestHasAddedAppField() {
            return this.requestHasAddedAppField(true);
        }

        public APIRequestGetMovies requestHasAddedAppField(boolean value) {
            this.requestField("has_added_app", value);
            return this;
        }

        public APIRequestGetMovies requestHasWhatsappBusinessNumberField() {
            return this.requestHasWhatsappBusinessNumberField(true);
        }

        public APIRequestGetMovies requestHasWhatsappBusinessNumberField(boolean value) {
            this.requestField("has_whatsapp_business_number", value);
            return this;
        }

        public APIRequestGetMovies requestHasWhatsappNumberField() {
            return this.requestHasWhatsappNumberField(true);
        }

        public APIRequestGetMovies requestHasWhatsappNumberField(boolean value) {
            this.requestField("has_whatsapp_number", value);
            return this;
        }

        public APIRequestGetMovies requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetMovies requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetMovies requestHoursField() {
            return this.requestHoursField(true);
        }

        public APIRequestGetMovies requestHoursField(boolean value) {
            this.requestField("hours", value);
            return this;
        }

        public APIRequestGetMovies requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetMovies requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetMovies requestImpressumField() {
            return this.requestImpressumField(true);
        }

        public APIRequestGetMovies requestImpressumField(boolean value) {
            this.requestField("impressum", value);
            return this;
        }

        public APIRequestGetMovies requestInfluencesField() {
            return this.requestInfluencesField(true);
        }

        public APIRequestGetMovies requestInfluencesField(boolean value) {
            this.requestField("influences", value);
            return this;
        }

        public APIRequestGetMovies requestInstagramBusinessAccountField() {
            return this.requestInstagramBusinessAccountField(true);
        }

        public APIRequestGetMovies requestInstagramBusinessAccountField(boolean value) {
            this.requestField("instagram_business_account", value);
            return this;
        }

        public APIRequestGetMovies requestInstantArticlesReviewStatusField() {
            return this.requestInstantArticlesReviewStatusField(true);
        }

        public APIRequestGetMovies requestInstantArticlesReviewStatusField(boolean value) {
            this.requestField("instant_articles_review_status", value);
            return this;
        }

        public APIRequestGetMovies requestIsAlwaysOpenField() {
            return this.requestIsAlwaysOpenField(true);
        }

        public APIRequestGetMovies requestIsAlwaysOpenField(boolean value) {
            this.requestField("is_always_open", value);
            return this;
        }

        public APIRequestGetMovies requestIsChainField() {
            return this.requestIsChainField(true);
        }

        public APIRequestGetMovies requestIsChainField(boolean value) {
            this.requestField("is_chain", value);
            return this;
        }

        public APIRequestGetMovies requestIsCommunityPageField() {
            return this.requestIsCommunityPageField(true);
        }

        public APIRequestGetMovies requestIsCommunityPageField(boolean value) {
            this.requestField("is_community_page", value);
            return this;
        }

        public APIRequestGetMovies requestIsEligibleForBrandedContentField() {
            return this.requestIsEligibleForBrandedContentField(true);
        }

        public APIRequestGetMovies requestIsEligibleForBrandedContentField(boolean value) {
            this.requestField("is_eligible_for_branded_content", value);
            return this;
        }

        public APIRequestGetMovies requestIsMessengerBotGetStartedEnabledField() {
            return this.requestIsMessengerBotGetStartedEnabledField(true);
        }

        public APIRequestGetMovies requestIsMessengerBotGetStartedEnabledField(boolean value) {
            this.requestField("is_messenger_bot_get_started_enabled", value);
            return this;
        }

        public APIRequestGetMovies requestIsMessengerPlatformBotField() {
            return this.requestIsMessengerPlatformBotField(true);
        }

        public APIRequestGetMovies requestIsMessengerPlatformBotField(boolean value) {
            this.requestField("is_messenger_platform_bot", value);
            return this;
        }

        public APIRequestGetMovies requestIsOwnedField() {
            return this.requestIsOwnedField(true);
        }

        public APIRequestGetMovies requestIsOwnedField(boolean value) {
            this.requestField("is_owned", value);
            return this;
        }

        public APIRequestGetMovies requestIsPermanentlyClosedField() {
            return this.requestIsPermanentlyClosedField(true);
        }

        public APIRequestGetMovies requestIsPermanentlyClosedField(boolean value) {
            this.requestField("is_permanently_closed", value);
            return this;
        }

        public APIRequestGetMovies requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetMovies requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetMovies requestIsUnclaimedField() {
            return this.requestIsUnclaimedField(true);
        }

        public APIRequestGetMovies requestIsUnclaimedField(boolean value) {
            this.requestField("is_unclaimed", value);
            return this;
        }

        public APIRequestGetMovies requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetMovies requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetMovies requestIsWebhooksSubscribedField() {
            return this.requestIsWebhooksSubscribedField(true);
        }

        public APIRequestGetMovies requestIsWebhooksSubscribedField(boolean value) {
            this.requestField("is_webhooks_subscribed", value);
            return this;
        }

        public APIRequestGetMovies requestKeywordsField() {
            return this.requestKeywordsField(true);
        }

        public APIRequestGetMovies requestKeywordsField(boolean value) {
            this.requestField("keywords", value);
            return this;
        }

        public APIRequestGetMovies requestLeadgenFormPreviewDetailsField() {
            return this.requestLeadgenFormPreviewDetailsField(true);
        }

        public APIRequestGetMovies requestLeadgenFormPreviewDetailsField(boolean value) {
            this.requestField("leadgen_form_preview_details", value);
            return this;
        }

        public APIRequestGetMovies requestLeadgenHasCrmIntegrationField() {
            return this.requestLeadgenHasCrmIntegrationField(true);
        }

        public APIRequestGetMovies requestLeadgenHasCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_crm_integration", value);
            return this;
        }

        public APIRequestGetMovies requestLeadgenHasFatPingCrmIntegrationField() {
            return this.requestLeadgenHasFatPingCrmIntegrationField(true);
        }

        public APIRequestGetMovies requestLeadgenHasFatPingCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_fat_ping_crm_integration", value);
            return this;
        }

        public APIRequestGetMovies requestLeadgenTosAcceptanceTimeField() {
            return this.requestLeadgenTosAcceptanceTimeField(true);
        }

        public APIRequestGetMovies requestLeadgenTosAcceptanceTimeField(boolean value) {
            this.requestField("leadgen_tos_acceptance_time", value);
            return this;
        }

        public APIRequestGetMovies requestLeadgenTosAcceptedField() {
            return this.requestLeadgenTosAcceptedField(true);
        }

        public APIRequestGetMovies requestLeadgenTosAcceptedField(boolean value) {
            this.requestField("leadgen_tos_accepted", value);
            return this;
        }

        public APIRequestGetMovies requestLeadgenTosAcceptingUserField() {
            return this.requestLeadgenTosAcceptingUserField(true);
        }

        public APIRequestGetMovies requestLeadgenTosAcceptingUserField(boolean value) {
            this.requestField("leadgen_tos_accepting_user", value);
            return this;
        }

        public APIRequestGetMovies requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetMovies requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetMovies requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetMovies requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetMovies requestMembersField() {
            return this.requestMembersField(true);
        }

        public APIRequestGetMovies requestMembersField(boolean value) {
            this.requestField("members", value);
            return this;
        }

        public APIRequestGetMovies requestMerchantIdField() {
            return this.requestMerchantIdField(true);
        }

        public APIRequestGetMovies requestMerchantIdField(boolean value) {
            this.requestField("merchant_id", value);
            return this;
        }

        public APIRequestGetMovies requestMerchantReviewStatusField() {
            return this.requestMerchantReviewStatusField(true);
        }

        public APIRequestGetMovies requestMerchantReviewStatusField(boolean value) {
            this.requestField("merchant_review_status", value);
            return this;
        }

        public APIRequestGetMovies requestMessengerAdsDefaultIcebreakersField() {
            return this.requestMessengerAdsDefaultIcebreakersField(true);
        }

        public APIRequestGetMovies requestMessengerAdsDefaultIcebreakersField(boolean value) {
            this.requestField("messenger_ads_default_icebreakers", value);
            return this;
        }

        public APIRequestGetMovies requestMessengerAdsDefaultPageWelcomeMessageField() {
            return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
        }

        public APIRequestGetMovies requestMessengerAdsDefaultPageWelcomeMessageField(boolean value) {
            this.requestField("messenger_ads_default_page_welcome_message", value);
            return this;
        }

        public APIRequestGetMovies requestMessengerAdsDefaultQuickRepliesField() {
            return this.requestMessengerAdsDefaultQuickRepliesField(true);
        }

        public APIRequestGetMovies requestMessengerAdsDefaultQuickRepliesField(boolean value) {
            this.requestField("messenger_ads_default_quick_replies", value);
            return this;
        }

        public APIRequestGetMovies requestMessengerAdsQuickRepliesTypeField() {
            return this.requestMessengerAdsQuickRepliesTypeField(true);
        }

        public APIRequestGetMovies requestMessengerAdsQuickRepliesTypeField(boolean value) {
            this.requestField("messenger_ads_quick_replies_type", value);
            return this;
        }

        public APIRequestGetMovies requestMissionField() {
            return this.requestMissionField(true);
        }

        public APIRequestGetMovies requestMissionField(boolean value) {
            this.requestField("mission", value);
            return this;
        }

        public APIRequestGetMovies requestMpgField() {
            return this.requestMpgField(true);
        }

        public APIRequestGetMovies requestMpgField(boolean value) {
            this.requestField("mpg", value);
            return this;
        }

        public APIRequestGetMovies requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetMovies requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetMovies requestNameWithLocationDescriptorField() {
            return this.requestNameWithLocationDescriptorField(true);
        }

        public APIRequestGetMovies requestNameWithLocationDescriptorField(boolean value) {
            this.requestField("name_with_location_descriptor", value);
            return this;
        }

        public APIRequestGetMovies requestNetworkField() {
            return this.requestNetworkField(true);
        }

        public APIRequestGetMovies requestNetworkField(boolean value) {
            this.requestField("network", value);
            return this;
        }

        public APIRequestGetMovies requestNewLikeCountField() {
            return this.requestNewLikeCountField(true);
        }

        public APIRequestGetMovies requestNewLikeCountField(boolean value) {
            this.requestField("new_like_count", value);
            return this;
        }

        public APIRequestGetMovies requestOfferEligibleField() {
            return this.requestOfferEligibleField(true);
        }

        public APIRequestGetMovies requestOfferEligibleField(boolean value) {
            this.requestField("offer_eligible", value);
            return this;
        }

        public APIRequestGetMovies requestOverallStarRatingField() {
            return this.requestOverallStarRatingField(true);
        }

        public APIRequestGetMovies requestOverallStarRatingField(boolean value) {
            this.requestField("overall_star_rating", value);
            return this;
        }

        public APIRequestGetMovies requestPageTokenField() {
            return this.requestPageTokenField(true);
        }

        public APIRequestGetMovies requestPageTokenField(boolean value) {
            this.requestField("page_token", value);
            return this;
        }

        public APIRequestGetMovies requestParentPageField() {
            return this.requestParentPageField(true);
        }

        public APIRequestGetMovies requestParentPageField(boolean value) {
            this.requestField("parent_page", value);
            return this;
        }

        public APIRequestGetMovies requestParkingField() {
            return this.requestParkingField(true);
        }

        public APIRequestGetMovies requestParkingField(boolean value) {
            this.requestField("parking", value);
            return this;
        }

        public APIRequestGetMovies requestPaymentOptionsField() {
            return this.requestPaymentOptionsField(true);
        }

        public APIRequestGetMovies requestPaymentOptionsField(boolean value) {
            this.requestField("payment_options", value);
            return this;
        }

        public APIRequestGetMovies requestPersonalInfoField() {
            return this.requestPersonalInfoField(true);
        }

        public APIRequestGetMovies requestPersonalInfoField(boolean value) {
            this.requestField("personal_info", value);
            return this;
        }

        public APIRequestGetMovies requestPersonalInterestsField() {
            return this.requestPersonalInterestsField(true);
        }

        public APIRequestGetMovies requestPersonalInterestsField(boolean value) {
            this.requestField("personal_interests", value);
            return this;
        }

        public APIRequestGetMovies requestPharmaSafetyInfoField() {
            return this.requestPharmaSafetyInfoField(true);
        }

        public APIRequestGetMovies requestPharmaSafetyInfoField(boolean value) {
            this.requestField("pharma_safety_info", value);
            return this;
        }

        public APIRequestGetMovies requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGetMovies requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGetMovies requestPlaceTypeField() {
            return this.requestPlaceTypeField(true);
        }

        public APIRequestGetMovies requestPlaceTypeField(boolean value) {
            this.requestField("place_type", value);
            return this;
        }

        public APIRequestGetMovies requestPlotOutlineField() {
            return this.requestPlotOutlineField(true);
        }

        public APIRequestGetMovies requestPlotOutlineField(boolean value) {
            this.requestField("plot_outline", value);
            return this;
        }

        public APIRequestGetMovies requestPreferredAudienceField() {
            return this.requestPreferredAudienceField(true);
        }

        public APIRequestGetMovies requestPreferredAudienceField(boolean value) {
            this.requestField("preferred_audience", value);
            return this;
        }

        public APIRequestGetMovies requestPressContactField() {
            return this.requestPressContactField(true);
        }

        public APIRequestGetMovies requestPressContactField(boolean value) {
            this.requestField("press_contact", value);
            return this;
        }

        public APIRequestGetMovies requestPriceRangeField() {
            return this.requestPriceRangeField(true);
        }

        public APIRequestGetMovies requestPriceRangeField(boolean value) {
            this.requestField("price_range", value);
            return this;
        }

        public APIRequestGetMovies requestProducedByField() {
            return this.requestProducedByField(true);
        }

        public APIRequestGetMovies requestProducedByField(boolean value) {
            this.requestField("produced_by", value);
            return this;
        }

        public APIRequestGetMovies requestProductsField() {
            return this.requestProductsField(true);
        }

        public APIRequestGetMovies requestProductsField(boolean value) {
            this.requestField("products", value);
            return this;
        }

        public APIRequestGetMovies requestPromotionEligibleField() {
            return this.requestPromotionEligibleField(true);
        }

        public APIRequestGetMovies requestPromotionEligibleField(boolean value) {
            this.requestField("promotion_eligible", value);
            return this;
        }

        public APIRequestGetMovies requestPromotionIneligibleReasonField() {
            return this.requestPromotionIneligibleReasonField(true);
        }

        public APIRequestGetMovies requestPromotionIneligibleReasonField(boolean value) {
            this.requestField("promotion_ineligible_reason", value);
            return this;
        }

        public APIRequestGetMovies requestPublicTransitField() {
            return this.requestPublicTransitField(true);
        }

        public APIRequestGetMovies requestPublicTransitField(boolean value) {
            this.requestField("public_transit", value);
            return this;
        }

        public APIRequestGetMovies requestPublisherSpaceField() {
            return this.requestPublisherSpaceField(true);
        }

        public APIRequestGetMovies requestPublisherSpaceField(boolean value) {
            this.requestField("publisher_space", value);
            return this;
        }

        public APIRequestGetMovies requestRatingCountField() {
            return this.requestRatingCountField(true);
        }

        public APIRequestGetMovies requestRatingCountField(boolean value) {
            this.requestField("rating_count", value);
            return this;
        }

        public APIRequestGetMovies requestRecipientField() {
            return this.requestRecipientField(true);
        }

        public APIRequestGetMovies requestRecipientField(boolean value) {
            this.requestField("recipient", value);
            return this;
        }

        public APIRequestGetMovies requestRecordLabelField() {
            return this.requestRecordLabelField(true);
        }

        public APIRequestGetMovies requestRecordLabelField(boolean value) {
            this.requestField("record_label", value);
            return this;
        }

        public APIRequestGetMovies requestReleaseDateField() {
            return this.requestReleaseDateField(true);
        }

        public APIRequestGetMovies requestReleaseDateField(boolean value) {
            this.requestField("release_date", value);
            return this;
        }

        public APIRequestGetMovies requestRestaurantServicesField() {
            return this.requestRestaurantServicesField(true);
        }

        public APIRequestGetMovies requestRestaurantServicesField(boolean value) {
            this.requestField("restaurant_services", value);
            return this;
        }

        public APIRequestGetMovies requestRestaurantSpecialtiesField() {
            return this.requestRestaurantSpecialtiesField(true);
        }

        public APIRequestGetMovies requestRestaurantSpecialtiesField(boolean value) {
            this.requestField("restaurant_specialties", value);
            return this;
        }

        public APIRequestGetMovies requestScheduleField() {
            return this.requestScheduleField(true);
        }

        public APIRequestGetMovies requestScheduleField(boolean value) {
            this.requestField("schedule", value);
            return this;
        }

        public APIRequestGetMovies requestScreenplayByField() {
            return this.requestScreenplayByField(true);
        }

        public APIRequestGetMovies requestScreenplayByField(boolean value) {
            this.requestField("screenplay_by", value);
            return this;
        }

        public APIRequestGetMovies requestSeasonField() {
            return this.requestSeasonField(true);
        }

        public APIRequestGetMovies requestSeasonField(boolean value) {
            this.requestField("season", value);
            return this;
        }

        public APIRequestGetMovies requestSingleLineAddressField() {
            return this.requestSingleLineAddressField(true);
        }

        public APIRequestGetMovies requestSingleLineAddressField(boolean value) {
            this.requestField("single_line_address", value);
            return this;
        }

        public APIRequestGetMovies requestStarringField() {
            return this.requestStarringField(true);
        }

        public APIRequestGetMovies requestStarringField(boolean value) {
            this.requestField("starring", value);
            return this;
        }

        public APIRequestGetMovies requestStartInfoField() {
            return this.requestStartInfoField(true);
        }

        public APIRequestGetMovies requestStartInfoField(boolean value) {
            this.requestField("start_info", value);
            return this;
        }

        public APIRequestGetMovies requestStoreCodeField() {
            return this.requestStoreCodeField(true);
        }

        public APIRequestGetMovies requestStoreCodeField(boolean value) {
            this.requestField("store_code", value);
            return this;
        }

        public APIRequestGetMovies requestStoreLocationDescriptorField() {
            return this.requestStoreLocationDescriptorField(true);
        }

        public APIRequestGetMovies requestStoreLocationDescriptorField(boolean value) {
            this.requestField("store_location_descriptor", value);
            return this;
        }

        public APIRequestGetMovies requestStoreNumberField() {
            return this.requestStoreNumberField(true);
        }

        public APIRequestGetMovies requestStoreNumberField(boolean value) {
            this.requestField("store_number", value);
            return this;
        }

        public APIRequestGetMovies requestStudioField() {
            return this.requestStudioField(true);
        }

        public APIRequestGetMovies requestStudioField(boolean value) {
            this.requestField("studio", value);
            return this;
        }

        public APIRequestGetMovies requestSupportsInstantArticlesField() {
            return this.requestSupportsInstantArticlesField(true);
        }

        public APIRequestGetMovies requestSupportsInstantArticlesField(boolean value) {
            this.requestField("supports_instant_articles", value);
            return this;
        }

        public APIRequestGetMovies requestTalkingAboutCountField() {
            return this.requestTalkingAboutCountField(true);
        }

        public APIRequestGetMovies requestTalkingAboutCountField(boolean value) {
            this.requestField("talking_about_count", value);
            return this;
        }

        public APIRequestGetMovies requestUnreadMessageCountField() {
            return this.requestUnreadMessageCountField(true);
        }

        public APIRequestGetMovies requestUnreadMessageCountField(boolean value) {
            this.requestField("unread_message_count", value);
            return this;
        }

        public APIRequestGetMovies requestUnreadNotifCountField() {
            return this.requestUnreadNotifCountField(true);
        }

        public APIRequestGetMovies requestUnreadNotifCountField(boolean value) {
            this.requestField("unread_notif_count", value);
            return this;
        }

        public APIRequestGetMovies requestUnseenMessageCountField() {
            return this.requestUnseenMessageCountField(true);
        }

        public APIRequestGetMovies requestUnseenMessageCountField(boolean value) {
            this.requestField("unseen_message_count", value);
            return this;
        }

        public APIRequestGetMovies requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetMovies requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGetMovies requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetMovies requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetMovies requestVoipInfoField() {
            return this.requestVoipInfoField(true);
        }

        public APIRequestGetMovies requestVoipInfoField(boolean value) {
            this.requestField("voip_info", value);
            return this;
        }

        public APIRequestGetMovies requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetMovies requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetMovies requestWereHereCountField() {
            return this.requestWereHereCountField(true);
        }

        public APIRequestGetMovies requestWereHereCountField(boolean value) {
            this.requestField("were_here_count", value);
            return this;
        }

        public APIRequestGetMovies requestWhatsappNumberField() {
            return this.requestWhatsappNumberField(true);
        }

        public APIRequestGetMovies requestWhatsappNumberField(boolean value) {
            this.requestField("whatsapp_number", value);
            return this;
        }

        public APIRequestGetMovies requestWrittenByField() {
            return this.requestWrittenByField(true);
        }

        public APIRequestGetMovies requestWrittenByField(boolean value) {
            this.requestField("written_by", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateMomentsUniversalLinkInvite
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"invite_url"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, User>(){

                public User apply(String result) {
                    try {
                        return APIRequestCreateMomentsUniversalLinkInvite.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateMomentsUniversalLinkInvite(String nodeId, APIContext context) {
            super(context, nodeId, "/moments_universal_link_invite", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateMomentsUniversalLinkInvite setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateMomentsUniversalLinkInvite setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateMomentsUniversalLinkInvite setInviteUrl(String inviteUrl) {
            this.setParam("invite_url", inviteUrl);
            return this;
        }

        public APIRequestCreateMomentsUniversalLinkInvite requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateMomentsUniversalLinkInvite requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMomentsUniversalLinkInvite requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateMomentsUniversalLinkInvite requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMomentsUniversalLinkInvite requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateMomentsUniversalLinkInvite requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateMomentsLinkInviteConvert
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"encoded_invite_id", "invite_nonce", "invite_source", "funnel_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, User>(){

                public User apply(String result) {
                    try {
                        return APIRequestCreateMomentsLinkInviteConvert.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateMomentsLinkInviteConvert(String nodeId, APIContext context) {
            super(context, nodeId, "/moments_link_invite_convert", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateMomentsLinkInviteConvert setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateMomentsLinkInviteConvert setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateMomentsLinkInviteConvert setEncodedInviteId(String encodedInviteId) {
            this.setParam("encoded_invite_id", encodedInviteId);
            return this;
        }

        public APIRequestCreateMomentsLinkInviteConvert setInviteNonce(String inviteNonce) {
            this.setParam("invite_nonce", inviteNonce);
            return this;
        }

        public APIRequestCreateMomentsLinkInviteConvert setInviteSource(String inviteSource) {
            this.setParam("invite_source", inviteSource);
            return this;
        }

        public APIRequestCreateMomentsLinkInviteConvert setFunnelId(String funnelId) {
            this.setParam("funnel_id", funnelId);
            return this;
        }

        public APIRequestCreateMomentsLinkInviteConvert requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateMomentsLinkInviteConvert requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMomentsLinkInviteConvert requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateMomentsLinkInviteConvert requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMomentsLinkInviteConvert requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateMomentsLinkInviteConvert requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateMomentsLinkInvite
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"moments_folder_uuid", "invite_source", "is_aldrin_region"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateMomentsLinkInvite.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateMomentsLinkInvite(String nodeId, APIContext context) {
            super(context, nodeId, "/moments_link_invite", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateMomentsLinkInvite setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateMomentsLinkInvite setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateMomentsLinkInvite setMomentsFolderUuid(String momentsFolderUuid) {
            this.setParam("moments_folder_uuid", momentsFolderUuid);
            return this;
        }

        public APIRequestCreateMomentsLinkInvite setInviteSource(String inviteSource) {
            this.setParam("invite_source", inviteSource);
            return this;
        }

        public APIRequestCreateMomentsLinkInvite setIsAldrinRegion(Boolean isAldrinRegion) {
            this.setParam("is_aldrin_region", isAldrinRegion);
            return this;
        }

        public APIRequestCreateMomentsLinkInvite setIsAldrinRegion(String isAldrinRegion) {
            this.setParam("is_aldrin_region", isAldrinRegion);
            return this;
        }

        public APIRequestCreateMomentsLinkInvite requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateMomentsLinkInvite requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMomentsLinkInvite requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateMomentsLinkInvite requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMomentsLinkInvite requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateMomentsLinkInvite requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateMfsAccountPinReset
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"provider_id", "password_token", "should_bypass_token_proxy", "resume_type", "resume_payload"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, User>(){

                public User apply(String result) {
                    try {
                        return APIRequestCreateMfsAccountPinReset.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateMfsAccountPinReset(String nodeId, APIContext context) {
            super(context, nodeId, "/mfs_account_pin_reset", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateMfsAccountPinReset setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateMfsAccountPinReset setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateMfsAccountPinReset setProviderId(String providerId) {
            this.setParam("provider_id", providerId);
            return this;
        }

        public APIRequestCreateMfsAccountPinReset setPasswordToken(String passwordToken) {
            this.setParam("password_token", passwordToken);
            return this;
        }

        public APIRequestCreateMfsAccountPinReset setShouldBypassTokenProxy(Boolean shouldBypassTokenProxy) {
            this.setParam("should_bypass_token_proxy", shouldBypassTokenProxy);
            return this;
        }

        public APIRequestCreateMfsAccountPinReset setShouldBypassTokenProxy(String shouldBypassTokenProxy) {
            this.setParam("should_bypass_token_proxy", shouldBypassTokenProxy);
            return this;
        }

        public APIRequestCreateMfsAccountPinReset setResumeType(EnumResumeType resumeType) {
            this.setParam("resume_type", (Object)resumeType);
            return this;
        }

        public APIRequestCreateMfsAccountPinReset setResumeType(String resumeType) {
            this.setParam("resume_type", resumeType);
            return this;
        }

        public APIRequestCreateMfsAccountPinReset setResumePayload(String resumePayload) {
            this.setParam("resume_payload", resumePayload);
            return this;
        }

        public APIRequestCreateMfsAccountPinReset requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateMfsAccountPinReset requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMfsAccountPinReset requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateMfsAccountPinReset requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMfsAccountPinReset requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateMfsAccountPinReset requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateLogInApprovalsKey
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"machine_id", "check_code", "client_time"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateLogInApprovalsKey.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateLogInApprovalsKey(String nodeId, APIContext context) {
            super(context, nodeId, "/loginapprovalskeys", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateLogInApprovalsKey setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateLogInApprovalsKey setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateLogInApprovalsKey setMachineId(String machineId) {
            this.setParam("machine_id", machineId);
            return this;
        }

        public APIRequestCreateLogInApprovalsKey setCheckCode(String checkCode) {
            this.setParam("check_code", checkCode);
            return this;
        }

        public APIRequestCreateLogInApprovalsKey setClientTime(String clientTime) {
            this.setParam("client_time", clientTime);
            return this;
        }

        public APIRequestCreateLogInApprovalsKey requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateLogInApprovalsKey requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLogInApprovalsKey requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateLogInApprovalsKey requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLogInApprovalsKey requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateLogInApprovalsKey requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateLoggedOutPushSetNonce
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"device_id", "existing_nonce"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, User>(){

                public User apply(String result) {
                    try {
                        return APIRequestCreateLoggedOutPushSetNonce.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateLoggedOutPushSetNonce(String nodeId, APIContext context) {
            super(context, nodeId, "/loggedoutpushsetnonces", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateLoggedOutPushSetNonce setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateLoggedOutPushSetNonce setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateLoggedOutPushSetNonce setDeviceId(String deviceId) {
            this.setParam("device_id", deviceId);
            return this;
        }

        public APIRequestCreateLoggedOutPushSetNonce setExistingNonce(String existingNonce) {
            this.setParam("existing_nonce", existingNonce);
            return this;
        }

        public APIRequestCreateLoggedOutPushSetNonce requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateLoggedOutPushSetNonce requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLoggedOutPushSetNonce requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateLoggedOutPushSetNonce requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLoggedOutPushSetNonce requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateLoggedOutPushSetNonce requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateLocationupdate
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"locations", "deviceid", "trace_ids", "dynamic_collection_checksum", "android_config_checksum", "skip_pvd"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, User>(){

                public User apply(String result) {
                    try {
                        return APIRequestCreateLocationupdate.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateLocationupdate(String nodeId, APIContext context) {
            super(context, nodeId, "/locationupdates", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateLocationupdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateLocationupdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateLocationupdate setLocations(List<Object> locations) {
            this.setParam("locations", locations);
            return this;
        }

        public APIRequestCreateLocationupdate setLocations(String locations) {
            this.setParam("locations", locations);
            return this;
        }

        public APIRequestCreateLocationupdate setDeviceid(String deviceid) {
            this.setParam("deviceid", deviceid);
            return this;
        }

        public APIRequestCreateLocationupdate setTraceIds(List<String> traceIds) {
            this.setParam("trace_ids", traceIds);
            return this;
        }

        public APIRequestCreateLocationupdate setTraceIds(String traceIds) {
            this.setParam("trace_ids", traceIds);
            return this;
        }

        public APIRequestCreateLocationupdate setDynamicCollectionChecksum(String dynamicCollectionChecksum) {
            this.setParam("dynamic_collection_checksum", dynamicCollectionChecksum);
            return this;
        }

        public APIRequestCreateLocationupdate setAndroidConfigChecksum(String androidConfigChecksum) {
            this.setParam("android_config_checksum", androidConfigChecksum);
            return this;
        }

        public APIRequestCreateLocationupdate setSkipPvd(Boolean skipPvd) {
            this.setParam("skip_pvd", skipPvd);
            return this;
        }

        public APIRequestCreateLocationupdate setSkipPvd(String skipPvd) {
            this.setParam("skip_pvd", skipPvd);
            return this;
        }

        public APIRequestCreateLocationupdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateLocationupdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLocationupdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateLocationupdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLocationupdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateLocationupdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateLiveVideo
    extends APIRequest<LiveVideo> {
        LiveVideo lastResponse = null;
        public static final String[] PARAMS = new String[]{"title", "description", "save_vod", "published", "status", "privacy", "stop_on_delete_stream", "stream_type", "content_tags", "is_spherical", "is_audio_only", "planned_start_time", "schedule_custom_profile_image", "projection", "spatial_audio_format", "encoding_settings", "live_encoders", "original_fov", "fisheye_video_cropped", "front_z_rotation", "attribution_app_id", "stereoscopic_mode"};
        public static final String[] FIELDS = new String[0];

        @Override
        public LiveVideo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LiveVideo parseResponse(String response) throws APIException {
            return LiveVideo.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public LiveVideo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LiveVideo execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<LiveVideo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LiveVideo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, LiveVideo>(){

                public LiveVideo apply(String result) {
                    try {
                        return APIRequestCreateLiveVideo.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateLiveVideo(String nodeId, APIContext context) {
            super(context, nodeId, "/live_videos", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateLiveVideo setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateLiveVideo setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateLiveVideo setTitle(String title) {
            this.setParam("title", title);
            return this;
        }

        public APIRequestCreateLiveVideo setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateLiveVideo setSaveVod(Boolean saveVod) {
            this.setParam("save_vod", saveVod);
            return this;
        }

        public APIRequestCreateLiveVideo setSaveVod(String saveVod) {
            this.setParam("save_vod", saveVod);
            return this;
        }

        public APIRequestCreateLiveVideo setPublished(Boolean published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreateLiveVideo setPublished(String published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreateLiveVideo setStatus(LiveVideo.EnumStatus status) {
            this.setParam("status", (Object)status);
            return this;
        }

        public APIRequestCreateLiveVideo setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestCreateLiveVideo setPrivacy(Object privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateLiveVideo setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateLiveVideo setStopOnDeleteStream(Boolean stopOnDeleteStream) {
            this.setParam("stop_on_delete_stream", stopOnDeleteStream);
            return this;
        }

        public APIRequestCreateLiveVideo setStopOnDeleteStream(String stopOnDeleteStream) {
            this.setParam("stop_on_delete_stream", stopOnDeleteStream);
            return this;
        }

        public APIRequestCreateLiveVideo setStreamType(LiveVideo.EnumStreamType streamType) {
            this.setParam("stream_type", (Object)streamType);
            return this;
        }

        public APIRequestCreateLiveVideo setStreamType(String streamType) {
            this.setParam("stream_type", streamType);
            return this;
        }

        public APIRequestCreateLiveVideo setContentTags(List<String> contentTags) {
            this.setParam("content_tags", contentTags);
            return this;
        }

        public APIRequestCreateLiveVideo setContentTags(String contentTags) {
            this.setParam("content_tags", contentTags);
            return this;
        }

        public APIRequestCreateLiveVideo setIsSpherical(Boolean isSpherical) {
            this.setParam("is_spherical", isSpherical);
            return this;
        }

        public APIRequestCreateLiveVideo setIsSpherical(String isSpherical) {
            this.setParam("is_spherical", isSpherical);
            return this;
        }

        public APIRequestCreateLiveVideo setIsAudioOnly(Boolean isAudioOnly) {
            this.setParam("is_audio_only", isAudioOnly);
            return this;
        }

        public APIRequestCreateLiveVideo setIsAudioOnly(String isAudioOnly) {
            this.setParam("is_audio_only", isAudioOnly);
            return this;
        }

        public APIRequestCreateLiveVideo setPlannedStartTime(Long plannedStartTime) {
            this.setParam("planned_start_time", plannedStartTime);
            return this;
        }

        public APIRequestCreateLiveVideo setPlannedStartTime(String plannedStartTime) {
            this.setParam("planned_start_time", plannedStartTime);
            return this;
        }

        public APIRequestCreateLiveVideo setScheduleCustomProfileImage(File scheduleCustomProfileImage) {
            this.setParam("schedule_custom_profile_image", scheduleCustomProfileImage);
            return this;
        }

        public APIRequestCreateLiveVideo setScheduleCustomProfileImage(String scheduleCustomProfileImage) {
            this.setParam("schedule_custom_profile_image", scheduleCustomProfileImage);
            return this;
        }

        public APIRequestCreateLiveVideo setProjection(LiveVideo.EnumProjection projection) {
            this.setParam("projection", (Object)projection);
            return this;
        }

        public APIRequestCreateLiveVideo setProjection(String projection) {
            this.setParam("projection", projection);
            return this;
        }

        public APIRequestCreateLiveVideo setSpatialAudioFormat(LiveVideo.EnumSpatialAudioFormat spatialAudioFormat) {
            this.setParam("spatial_audio_format", (Object)spatialAudioFormat);
            return this;
        }

        public APIRequestCreateLiveVideo setSpatialAudioFormat(String spatialAudioFormat) {
            this.setParam("spatial_audio_format", spatialAudioFormat);
            return this;
        }

        public APIRequestCreateLiveVideo setEncodingSettings(String encodingSettings) {
            this.setParam("encoding_settings", encodingSettings);
            return this;
        }

        public APIRequestCreateLiveVideo setLiveEncoders(List<String> liveEncoders) {
            this.setParam("live_encoders", liveEncoders);
            return this;
        }

        public APIRequestCreateLiveVideo setLiveEncoders(String liveEncoders) {
            this.setParam("live_encoders", liveEncoders);
            return this;
        }

        public APIRequestCreateLiveVideo setOriginalFov(Long originalFov) {
            this.setParam("original_fov", originalFov);
            return this;
        }

        public APIRequestCreateLiveVideo setOriginalFov(String originalFov) {
            this.setParam("original_fov", originalFov);
            return this;
        }

        public APIRequestCreateLiveVideo setFisheyeVideoCropped(Boolean fisheyeVideoCropped) {
            this.setParam("fisheye_video_cropped", fisheyeVideoCropped);
            return this;
        }

        public APIRequestCreateLiveVideo setFisheyeVideoCropped(String fisheyeVideoCropped) {
            this.setParam("fisheye_video_cropped", fisheyeVideoCropped);
            return this;
        }

        public APIRequestCreateLiveVideo setFrontZRotation(Double frontZRotation) {
            this.setParam("front_z_rotation", frontZRotation);
            return this;
        }

        public APIRequestCreateLiveVideo setFrontZRotation(String frontZRotation) {
            this.setParam("front_z_rotation", frontZRotation);
            return this;
        }

        public APIRequestCreateLiveVideo setAttributionAppId(String attributionAppId) {
            this.setParam("attribution_app_id", attributionAppId);
            return this;
        }

        public APIRequestCreateLiveVideo setStereoscopicMode(LiveVideo.EnumStereoscopicMode stereoscopicMode) {
            this.setParam("stereoscopic_mode", (Object)stereoscopicMode);
            return this;
        }

        public APIRequestCreateLiveVideo setStereoscopicMode(String stereoscopicMode) {
            this.setParam("stereoscopic_mode", stereoscopicMode);
            return this;
        }

        public APIRequestCreateLiveVideo requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateLiveVideo requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLiveVideo requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateLiveVideo requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLiveVideo requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateLiveVideo requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetLiveVideos
    extends APIRequest<LiveVideo> {
        APINodeList<LiveVideo> lastResponse = null;
        public static final String[] PARAMS = new String[]{"type", "source", "broadcast_status"};
        public static final String[] FIELDS = new String[]{"ad_break_config", "ad_break_failure_reason", "broadcast_start_time", "copyright", "creation_time", "dash_ingest_url", "dash_preview_url", "description", "embed_html", "from", "id", "ingest_streams", "is_manual_mode", "is_reference_only", "live_encoders", "live_views", "permalink_url", "planned_start_time", "preview_url", "seconds_left", "secure_stream_url", "status", "stream_url", "targeting", "title", "total_views", "video"};

        @Override
        public APINodeList<LiveVideo> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<LiveVideo> parseResponse(String response) throws APIException {
            return LiveVideo.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<LiveVideo> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<LiveVideo> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<LiveVideo>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<LiveVideo>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<LiveVideo>>(){

                public APINodeList<LiveVideo> apply(String result) {
                    try {
                        return APIRequestGetLiveVideos.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetLiveVideos(String nodeId, APIContext context) {
            super(context, nodeId, "/live_videos", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetLiveVideos setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetLiveVideos setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetLiveVideos setType(LiveVideo.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetLiveVideos setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetLiveVideos setSource(LiveVideo.EnumSource source) {
            this.setParam("source", (Object)source);
            return this;
        }

        public APIRequestGetLiveVideos setSource(String source) {
            this.setParam("source", source);
            return this;
        }

        public APIRequestGetLiveVideos setBroadcastStatus(List<LiveVideo.EnumBroadcastStatus> broadcastStatus) {
            this.setParam("broadcast_status", broadcastStatus);
            return this;
        }

        public APIRequestGetLiveVideos setBroadcastStatus(String broadcastStatus) {
            this.setParam("broadcast_status", broadcastStatus);
            return this;
        }

        public APIRequestGetLiveVideos requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetLiveVideos requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLiveVideos requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetLiveVideos requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLiveVideos requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetLiveVideos requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetLiveVideos requestAdBreakConfigField() {
            return this.requestAdBreakConfigField(true);
        }

        public APIRequestGetLiveVideos requestAdBreakConfigField(boolean value) {
            this.requestField("ad_break_config", value);
            return this;
        }

        public APIRequestGetLiveVideos requestAdBreakFailureReasonField() {
            return this.requestAdBreakFailureReasonField(true);
        }

        public APIRequestGetLiveVideos requestAdBreakFailureReasonField(boolean value) {
            this.requestField("ad_break_failure_reason", value);
            return this;
        }

        public APIRequestGetLiveVideos requestBroadcastStartTimeField() {
            return this.requestBroadcastStartTimeField(true);
        }

        public APIRequestGetLiveVideos requestBroadcastStartTimeField(boolean value) {
            this.requestField("broadcast_start_time", value);
            return this;
        }

        public APIRequestGetLiveVideos requestCopyrightField() {
            return this.requestCopyrightField(true);
        }

        public APIRequestGetLiveVideos requestCopyrightField(boolean value) {
            this.requestField("copyright", value);
            return this;
        }

        public APIRequestGetLiveVideos requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGetLiveVideos requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGetLiveVideos requestDashIngestUrlField() {
            return this.requestDashIngestUrlField(true);
        }

        public APIRequestGetLiveVideos requestDashIngestUrlField(boolean value) {
            this.requestField("dash_ingest_url", value);
            return this;
        }

        public APIRequestGetLiveVideos requestDashPreviewUrlField() {
            return this.requestDashPreviewUrlField(true);
        }

        public APIRequestGetLiveVideos requestDashPreviewUrlField(boolean value) {
            this.requestField("dash_preview_url", value);
            return this;
        }

        public APIRequestGetLiveVideos requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetLiveVideos requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetLiveVideos requestEmbedHtmlField() {
            return this.requestEmbedHtmlField(true);
        }

        public APIRequestGetLiveVideos requestEmbedHtmlField(boolean value) {
            this.requestField("embed_html", value);
            return this;
        }

        public APIRequestGetLiveVideos requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetLiveVideos requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetLiveVideos requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetLiveVideos requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetLiveVideos requestIngestStreamsField() {
            return this.requestIngestStreamsField(true);
        }

        public APIRequestGetLiveVideos requestIngestStreamsField(boolean value) {
            this.requestField("ingest_streams", value);
            return this;
        }

        public APIRequestGetLiveVideos requestIsManualModeField() {
            return this.requestIsManualModeField(true);
        }

        public APIRequestGetLiveVideos requestIsManualModeField(boolean value) {
            this.requestField("is_manual_mode", value);
            return this;
        }

        public APIRequestGetLiveVideos requestIsReferenceOnlyField() {
            return this.requestIsReferenceOnlyField(true);
        }

        public APIRequestGetLiveVideos requestIsReferenceOnlyField(boolean value) {
            this.requestField("is_reference_only", value);
            return this;
        }

        public APIRequestGetLiveVideos requestLiveEncodersField() {
            return this.requestLiveEncodersField(true);
        }

        public APIRequestGetLiveVideos requestLiveEncodersField(boolean value) {
            this.requestField("live_encoders", value);
            return this;
        }

        public APIRequestGetLiveVideos requestLiveViewsField() {
            return this.requestLiveViewsField(true);
        }

        public APIRequestGetLiveVideos requestLiveViewsField(boolean value) {
            this.requestField("live_views", value);
            return this;
        }

        public APIRequestGetLiveVideos requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGetLiveVideos requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGetLiveVideos requestPlannedStartTimeField() {
            return this.requestPlannedStartTimeField(true);
        }

        public APIRequestGetLiveVideos requestPlannedStartTimeField(boolean value) {
            this.requestField("planned_start_time", value);
            return this;
        }

        public APIRequestGetLiveVideos requestPreviewUrlField() {
            return this.requestPreviewUrlField(true);
        }

        public APIRequestGetLiveVideos requestPreviewUrlField(boolean value) {
            this.requestField("preview_url", value);
            return this;
        }

        public APIRequestGetLiveVideos requestSecondsLeftField() {
            return this.requestSecondsLeftField(true);
        }

        public APIRequestGetLiveVideos requestSecondsLeftField(boolean value) {
            this.requestField("seconds_left", value);
            return this;
        }

        public APIRequestGetLiveVideos requestSecureStreamUrlField() {
            return this.requestSecureStreamUrlField(true);
        }

        public APIRequestGetLiveVideos requestSecureStreamUrlField(boolean value) {
            this.requestField("secure_stream_url", value);
            return this;
        }

        public APIRequestGetLiveVideos requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetLiveVideos requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetLiveVideos requestStreamUrlField() {
            return this.requestStreamUrlField(true);
        }

        public APIRequestGetLiveVideos requestStreamUrlField(boolean value) {
            this.requestField("stream_url", value);
            return this;
        }

        public APIRequestGetLiveVideos requestTargetingField() {
            return this.requestTargetingField(true);
        }

        public APIRequestGetLiveVideos requestTargetingField(boolean value) {
            this.requestField("targeting", value);
            return this;
        }

        public APIRequestGetLiveVideos requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetLiveVideos requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetLiveVideos requestTotalViewsField() {
            return this.requestTotalViewsField(true);
        }

        public APIRequestGetLiveVideos requestTotalViewsField(boolean value) {
            this.requestField("total_views", value);
            return this;
        }

        public APIRequestGetLiveVideos requestVideoField() {
            return this.requestVideoField(true);
        }

        public APIRequestGetLiveVideos requestVideoField(boolean value) {
            this.requestField("video", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateLiveEncoder
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"device_id", "name", "brand", "model", "version"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateLiveEncoder.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateLiveEncoder(String nodeId, APIContext context) {
            super(context, nodeId, "/live_encoders", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateLiveEncoder setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateLiveEncoder setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateLiveEncoder setDeviceId(String deviceId) {
            this.setParam("device_id", deviceId);
            return this;
        }

        public APIRequestCreateLiveEncoder setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateLiveEncoder setBrand(String brand) {
            this.setParam("brand", brand);
            return this;
        }

        public APIRequestCreateLiveEncoder setModel(String model) {
            this.setParam("model", model);
            return this;
        }

        public APIRequestCreateLiveEncoder setVersion(String version) {
            this.setParam("version", version);
            return this;
        }

        public APIRequestCreateLiveEncoder requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateLiveEncoder requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLiveEncoder requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateLiveEncoder requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLiveEncoder requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateLiveEncoder requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateLink
    extends APIRequest<Link> {
        Link lastResponse = null;
        public static final String[] PARAMS = new String[]{"link", "message", "image", "tags", "place", "published", "scheduled_publish_time", "unpublished_content_type", "targeting", "privacy", "application_id", "is_explicit_share"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Link getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Link parseResponse(String response) throws APIException {
            return Link.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Link execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Link execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Link> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Link> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Link>(){

                public Link apply(String result) {
                    try {
                        return APIRequestCreateLink.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateLink(String nodeId, APIContext context) {
            super(context, nodeId, "/links", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateLink setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateLink setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateLink setLink(String link) {
            this.setParam("link", link);
            return this;
        }

        public APIRequestCreateLink setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateLink setImage(String image) {
            this.setParam("image", image);
            return this;
        }

        public APIRequestCreateLink setTags(List<Long> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateLink setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateLink setPlace(Object place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreateLink setPlace(String place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreateLink setPublished(Boolean published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreateLink setPublished(String published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreateLink setScheduledPublishTime(Long scheduledPublishTime) {
            this.setParam("scheduled_publish_time", scheduledPublishTime);
            return this;
        }

        public APIRequestCreateLink setScheduledPublishTime(String scheduledPublishTime) {
            this.setParam("scheduled_publish_time", scheduledPublishTime);
            return this;
        }

        public APIRequestCreateLink setUnpublishedContentType(Link.EnumUnpublishedContentType unpublishedContentType) {
            this.setParam("unpublished_content_type", (Object)unpublishedContentType);
            return this;
        }

        public APIRequestCreateLink setUnpublishedContentType(String unpublishedContentType) {
            this.setParam("unpublished_content_type", unpublishedContentType);
            return this;
        }

        public APIRequestCreateLink setTargeting(Object targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreateLink setTargeting(String targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreateLink setPrivacy(Object privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateLink setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateLink setApplicationId(String applicationId) {
            this.setParam("application_id", applicationId);
            return this;
        }

        public APIRequestCreateLink setIsExplicitShare(Boolean isExplicitShare) {
            this.setParam("is_explicit_share", isExplicitShare);
            return this;
        }

        public APIRequestCreateLink setIsExplicitShare(String isExplicitShare) {
            this.setParam("is_explicit_share", isExplicitShare);
            return this;
        }

        public APIRequestCreateLink requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateLink requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLink requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateLink requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLink requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateLink requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateLike
    extends APIRequest<User> {
        User lastResponse = null;
        public static final String[] PARAMS = new String[]{"message", "url", "ref", "action"};
        public static final String[] FIELDS = new String[0];

        @Override
        public User getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public User parseResponse(String response) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public User execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public User execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<User> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<User> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, User>(){

                public User apply(String result) {
                    try {
                        return APIRequestCreateLike.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateLike(String nodeId, APIContext context) {
            super(context, nodeId, "/likes", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateLike setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateLike setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateLike setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateLike setUrl(String url) {
            this.setParam("url", url);
            return this;
        }

        public APIRequestCreateLike setRef(String ref) {
            this.setParam("ref", ref);
            return this;
        }

        public APIRequestCreateLike setAction(String action) {
            this.setParam("action", action);
            return this;
        }

        public APIRequestCreateLike requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateLike requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLike requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateLike requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLike requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateLike requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetLikes
    extends APIRequest<Page> {
        APINodeList<Page> lastResponse = null;
        public static final String[] PARAMS = new String[]{"target_id"};
        public static final String[] FIELDS = new String[]{"about", "access_token", "ad_campaign", "affiliation", "app_id", "app_links", "artists_we_like", "attire", "awards", "band_interests", "band_members", "best_page", "bio", "birthday", "booking_agent", "built", "business", "can_checkin", "can_post", "category", "category_list", "checkins", "company_overview", "connected_instagram_account", "contact_address", "context", "copyright_attribution_insights", "copyright_whitelisted_ig_partners", "country_page_likes", "cover", "culinary_team", "current_location", "description", "description_html", "directed_by", "display_subtext", "displayed_message_response_time", "emails", "engagement", "fan_count", "featured_video", "features", "food_styles", "founded", "general_info", "general_manager", "genre", "global_brand_page_name", "global_brand_parent_page", "global_brand_root_id", "has_added_app", "has_whatsapp_business_number", "has_whatsapp_number", "hometown", "hours", "id", "impressum", "influences", "instagram_business_account", "instant_articles_review_status", "is_always_open", "is_chain", "is_community_page", "is_eligible_for_branded_content", "is_messenger_bot_get_started_enabled", "is_messenger_platform_bot", "is_owned", "is_permanently_closed", "is_published", "is_unclaimed", "is_verified", "is_webhooks_subscribed", "keywords", "leadgen_form_preview_details", "leadgen_has_crm_integration", "leadgen_has_fat_ping_crm_integration", "leadgen_tos_acceptance_time", "leadgen_tos_accepted", "leadgen_tos_accepting_user", "link", "location", "members", "merchant_id", "merchant_review_status", "messenger_ads_default_icebreakers", "messenger_ads_default_page_welcome_message", "messenger_ads_default_quick_replies", "messenger_ads_quick_replies_type", "mission", "mpg", "name", "name_with_location_descriptor", "network", "new_like_count", "offer_eligible", "overall_star_rating", "page_token", "parent_page", "parking", "payment_options", "personal_info", "personal_interests", "pharma_safety_info", "phone", "place_type", "plot_outline", "preferred_audience", "press_contact", "price_range", "produced_by", "products", "promotion_eligible", "promotion_ineligible_reason", "public_transit", "publisher_space", "rating_count", "recipient", "record_label", "release_date", "restaurant_services", "restaurant_specialties", "schedule", "screenplay_by", "season", "single_line_address", "starring", "start_info", "store_code", "store_location_descriptor", "store_number", "studio", "supports_instant_articles", "talking_about_count", "unread_message_count", "unread_notif_count", "unseen_message_count", "username", "verification_status", "voip_info", "website", "were_here_count", "whatsapp_number", "written_by"};

        @Override
        public APINodeList<Page> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Page> parseResponse(String response) throws APIException {
            return Page.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Page> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Page>>(){

                public APINodeList<Page> apply(String result) {
                    try {
                        return APIRequestGetLikes.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetLikes(String nodeId, APIContext context) {
            super(context, nodeId, "/likes", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetLikes setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetLikes setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetLikes setTargetId(String targetId) {
            this.setParam("target_id", targetId);
            return this;
        }

        public APIRequestGetLikes requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetLikes requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLikes requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetLikes requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLikes requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetLikes requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetLikes requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetLikes requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetLikes requestAccessTokenField() {
            return this.requestAccessTokenField(true);
        }

        public APIRequestGetLikes requestAccessTokenField(boolean value) {
            this.requestField("access_token", value);
            return this;
        }

        public APIRequestGetLikes requestAdCampaignField() {
            return this.requestAdCampaignField(true);
        }

        public APIRequestGetLikes requestAdCampaignField(boolean value) {
            this.requestField("ad_campaign", value);
            return this;
        }

        public APIRequestGetLikes requestAffiliationField() {
            return this.requestAffiliationField(true);
        }

        public APIRequestGetLikes requestAffiliationField(boolean value) {
            this.requestField("affiliation", value);
            return this;
        }

        public APIRequestGetLikes requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetLikes requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetLikes requestAppLinksField() {
            return this.requestAppLinksField(true);
        }

        public APIRequestGetLikes requestAppLinksField(boolean value) {
            this.requestField("app_links", value);
            return this;
        }

        public APIRequestGetLikes requestArtistsWeLikeField() {
            return this.requestArtistsWeLikeField(true);
        }

        public APIRequestGetLikes requestArtistsWeLikeField(boolean value) {
            this.requestField("artists_we_like", value);
            return this;
        }

        public APIRequestGetLikes requestAttireField() {
            return this.requestAttireField(true);
        }

        public APIRequestGetLikes requestAttireField(boolean value) {
            this.requestField("attire", value);
            return this;
        }

        public APIRequestGetLikes requestAwardsField() {
            return this.requestAwardsField(true);
        }

        public APIRequestGetLikes requestAwardsField(boolean value) {
            this.requestField("awards", value);
            return this;
        }

        public APIRequestGetLikes requestBandInterestsField() {
            return this.requestBandInterestsField(true);
        }

        public APIRequestGetLikes requestBandInterestsField(boolean value) {
            this.requestField("band_interests", value);
            return this;
        }

        public APIRequestGetLikes requestBandMembersField() {
            return this.requestBandMembersField(true);
        }

        public APIRequestGetLikes requestBandMembersField(boolean value) {
            this.requestField("band_members", value);
            return this;
        }

        public APIRequestGetLikes requestBestPageField() {
            return this.requestBestPageField(true);
        }

        public APIRequestGetLikes requestBestPageField(boolean value) {
            this.requestField("best_page", value);
            return this;
        }

        public APIRequestGetLikes requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetLikes requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetLikes requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetLikes requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetLikes requestBookingAgentField() {
            return this.requestBookingAgentField(true);
        }

        public APIRequestGetLikes requestBookingAgentField(boolean value) {
            this.requestField("booking_agent", value);
            return this;
        }

        public APIRequestGetLikes requestBuiltField() {
            return this.requestBuiltField(true);
        }

        public APIRequestGetLikes requestBuiltField(boolean value) {
            this.requestField("built", value);
            return this;
        }

        public APIRequestGetLikes requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetLikes requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetLikes requestCanCheckinField() {
            return this.requestCanCheckinField(true);
        }

        public APIRequestGetLikes requestCanCheckinField(boolean value) {
            this.requestField("can_checkin", value);
            return this;
        }

        public APIRequestGetLikes requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetLikes requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetLikes requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetLikes requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetLikes requestCategoryListField() {
            return this.requestCategoryListField(true);
        }

        public APIRequestGetLikes requestCategoryListField(boolean value) {
            this.requestField("category_list", value);
            return this;
        }

        public APIRequestGetLikes requestCheckinsField() {
            return this.requestCheckinsField(true);
        }

        public APIRequestGetLikes requestCheckinsField(boolean value) {
            this.requestField("checkins", value);
            return this;
        }

        public APIRequestGetLikes requestCompanyOverviewField() {
            return this.requestCompanyOverviewField(true);
        }

        public APIRequestGetLikes requestCompanyOverviewField(boolean value) {
            this.requestField("company_overview", value);
            return this;
        }

        public APIRequestGetLikes requestConnectedInstagramAccountField() {
            return this.requestConnectedInstagramAccountField(true);
        }

        public APIRequestGetLikes requestConnectedInstagramAccountField(boolean value) {
            this.requestField("connected_instagram_account", value);
            return this;
        }

        public APIRequestGetLikes requestContactAddressField() {
            return this.requestContactAddressField(true);
        }

        public APIRequestGetLikes requestContactAddressField(boolean value) {
            this.requestField("contact_address", value);
            return this;
        }

        public APIRequestGetLikes requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetLikes requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetLikes requestCopyrightAttributionInsightsField() {
            return this.requestCopyrightAttributionInsightsField(true);
        }

        public APIRequestGetLikes requestCopyrightAttributionInsightsField(boolean value) {
            this.requestField("copyright_attribution_insights", value);
            return this;
        }

        public APIRequestGetLikes requestCopyrightWhitelistedIgPartnersField() {
            return this.requestCopyrightWhitelistedIgPartnersField(true);
        }

        public APIRequestGetLikes requestCopyrightWhitelistedIgPartnersField(boolean value) {
            this.requestField("copyright_whitelisted_ig_partners", value);
            return this;
        }

        public APIRequestGetLikes requestCountryPageLikesField() {
            return this.requestCountryPageLikesField(true);
        }

        public APIRequestGetLikes requestCountryPageLikesField(boolean value) {
            this.requestField("country_page_likes", value);
            return this;
        }

        public APIRequestGetLikes requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetLikes requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetLikes requestCulinaryTeamField() {
            return this.requestCulinaryTeamField(true);
        }

        public APIRequestGetLikes requestCulinaryTeamField(boolean value) {
            this.requestField("culinary_team", value);
            return this;
        }

        public APIRequestGetLikes requestCurrentLocationField() {
            return this.requestCurrentLocationField(true);
        }

        public APIRequestGetLikes requestCurrentLocationField(boolean value) {
            this.requestField("current_location", value);
            return this;
        }

        public APIRequestGetLikes requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetLikes requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetLikes requestDescriptionHtmlField() {
            return this.requestDescriptionHtmlField(true);
        }

        public APIRequestGetLikes requestDescriptionHtmlField(boolean value) {
            this.requestField("description_html", value);
            return this;
        }

        public APIRequestGetLikes requestDirectedByField() {
            return this.requestDirectedByField(true);
        }

        public APIRequestGetLikes requestDirectedByField(boolean value) {
            this.requestField("directed_by", value);
            return this;
        }

        public APIRequestGetLikes requestDisplaySubtextField() {
            return this.requestDisplaySubtextField(true);
        }

        public APIRequestGetLikes requestDisplaySubtextField(boolean value) {
            this.requestField("display_subtext", value);
            return this;
        }

        public APIRequestGetLikes requestDisplayedMessageResponseTimeField() {
            return this.requestDisplayedMessageResponseTimeField(true);
        }

        public APIRequestGetLikes requestDisplayedMessageResponseTimeField(boolean value) {
            this.requestField("displayed_message_response_time", value);
            return this;
        }

        public APIRequestGetLikes requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGetLikes requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGetLikes requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGetLikes requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGetLikes requestFanCountField() {
            return this.requestFanCountField(true);
        }

        public APIRequestGetLikes requestFanCountField(boolean value) {
            this.requestField("fan_count", value);
            return this;
        }

        public APIRequestGetLikes requestFeaturedVideoField() {
            return this.requestFeaturedVideoField(true);
        }

        public APIRequestGetLikes requestFeaturedVideoField(boolean value) {
            this.requestField("featured_video", value);
            return this;
        }

        public APIRequestGetLikes requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGetLikes requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGetLikes requestFoodStylesField() {
            return this.requestFoodStylesField(true);
        }

        public APIRequestGetLikes requestFoodStylesField(boolean value) {
            this.requestField("food_styles", value);
            return this;
        }

        public APIRequestGetLikes requestFoundedField() {
            return this.requestFoundedField(true);
        }

        public APIRequestGetLikes requestFoundedField(boolean value) {
            this.requestField("founded", value);
            return this;
        }

        public APIRequestGetLikes requestGeneralInfoField() {
            return this.requestGeneralInfoField(true);
        }

        public APIRequestGetLikes requestGeneralInfoField(boolean value) {
            this.requestField("general_info", value);
            return this;
        }

        public APIRequestGetLikes requestGeneralManagerField() {
            return this.requestGeneralManagerField(true);
        }

        public APIRequestGetLikes requestGeneralManagerField(boolean value) {
            this.requestField("general_manager", value);
            return this;
        }

        public APIRequestGetLikes requestGenreField() {
            return this.requestGenreField(true);
        }

        public APIRequestGetLikes requestGenreField(boolean value) {
            this.requestField("genre", value);
            return this;
        }

        public APIRequestGetLikes requestGlobalBrandPageNameField() {
            return this.requestGlobalBrandPageNameField(true);
        }

        public APIRequestGetLikes requestGlobalBrandPageNameField(boolean value) {
            this.requestField("global_brand_page_name", value);
            return this;
        }

        public APIRequestGetLikes requestGlobalBrandParentPageField() {
            return this.requestGlobalBrandParentPageField(true);
        }

        public APIRequestGetLikes requestGlobalBrandParentPageField(boolean value) {
            this.requestField("global_brand_parent_page", value);
            return this;
        }

        public APIRequestGetLikes requestGlobalBrandRootIdField() {
            return this.requestGlobalBrandRootIdField(true);
        }

        public APIRequestGetLikes requestGlobalBrandRootIdField(boolean value) {
            this.requestField("global_brand_root_id", value);
            return this;
        }

        public APIRequestGetLikes requestHasAddedAppField() {
            return this.requestHasAddedAppField(true);
        }

        public APIRequestGetLikes requestHasAddedAppField(boolean value) {
            this.requestField("has_added_app", value);
            return this;
        }

        public APIRequestGetLikes requestHasWhatsappBusinessNumberField() {
            return this.requestHasWhatsappBusinessNumberField(true);
        }

        public APIRequestGetLikes requestHasWhatsappBusinessNumberField(boolean value) {
            this.requestField("has_whatsapp_business_number", value);
            return this;
        }

        public APIRequestGetLikes requestHasWhatsappNumberField() {
            return this.requestHasWhatsappNumberField(true);
        }

        public APIRequestGetLikes requestHasWhatsappNumberField(boolean value) {
            this.requestField("has_whatsapp_number", value);
            return this;
        }

        public APIRequestGetLikes requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetLikes requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetLikes requestHoursField() {
            return this.requestHoursField(true);
        }

        public APIRequestGetLikes requestHoursField(boolean value) {
            this.requestField("hours", value);
            return this;
        }

        public APIRequestGetLikes requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetLikes requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetLikes requestImpressumField() {
            return this.requestImpressumField(true);
        }

        public APIRequestGetLikes requestImpressumField(boolean value) {
            this.requestField("impressum", value);
            return this;
        }

        public APIRequestGetLikes requestInfluencesField() {
            return this.requestInfluencesField(true);
        }

        public APIRequestGetLikes requestInfluencesField(boolean value) {
            this.requestField("influences", value);
            return this;
        }

        public APIRequestGetLikes requestInstagramBusinessAccountField() {
            return this.requestInstagramBusinessAccountField(true);
        }

        public APIRequestGetLikes requestInstagramBusinessAccountField(boolean value) {
            this.requestField("instagram_business_account", value);
            return this;
        }

        public APIRequestGetLikes requestInstantArticlesReviewStatusField() {
            return this.requestInstantArticlesReviewStatusField(true);
        }

        public APIRequestGetLikes requestInstantArticlesReviewStatusField(boolean value) {
            this.requestField("instant_articles_review_status", value);
            return this;
        }

        public APIRequestGetLikes requestIsAlwaysOpenField() {
            return this.requestIsAlwaysOpenField(true);
        }

        public APIRequestGetLikes requestIsAlwaysOpenField(boolean value) {
            this.requestField("is_always_open", value);
            return this;
        }

        public APIRequestGetLikes requestIsChainField() {
            return this.requestIsChainField(true);
        }

        public APIRequestGetLikes requestIsChainField(boolean value) {
            this.requestField("is_chain", value);
            return this;
        }

        public APIRequestGetLikes requestIsCommunityPageField() {
            return this.requestIsCommunityPageField(true);
        }

        public APIRequestGetLikes requestIsCommunityPageField(boolean value) {
            this.requestField("is_community_page", value);
            return this;
        }

        public APIRequestGetLikes requestIsEligibleForBrandedContentField() {
            return this.requestIsEligibleForBrandedContentField(true);
        }

        public APIRequestGetLikes requestIsEligibleForBrandedContentField(boolean value) {
            this.requestField("is_eligible_for_branded_content", value);
            return this;
        }

        public APIRequestGetLikes requestIsMessengerBotGetStartedEnabledField() {
            return this.requestIsMessengerBotGetStartedEnabledField(true);
        }

        public APIRequestGetLikes requestIsMessengerBotGetStartedEnabledField(boolean value) {
            this.requestField("is_messenger_bot_get_started_enabled", value);
            return this;
        }

        public APIRequestGetLikes requestIsMessengerPlatformBotField() {
            return this.requestIsMessengerPlatformBotField(true);
        }

        public APIRequestGetLikes requestIsMessengerPlatformBotField(boolean value) {
            this.requestField("is_messenger_platform_bot", value);
            return this;
        }

        public APIRequestGetLikes requestIsOwnedField() {
            return this.requestIsOwnedField(true);
        }

        public APIRequestGetLikes requestIsOwnedField(boolean value) {
            this.requestField("is_owned", value);
            return this;
        }

        public APIRequestGetLikes requestIsPermanentlyClosedField() {
            return this.requestIsPermanentlyClosedField(true);
        }

        public APIRequestGetLikes requestIsPermanentlyClosedField(boolean value) {
            this.requestField("is_permanently_closed", value);
            return this;
        }

        public APIRequestGetLikes requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetLikes requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetLikes requestIsUnclaimedField() {
            return this.requestIsUnclaimedField(true);
        }

        public APIRequestGetLikes requestIsUnclaimedField(boolean value) {
            this.requestField("is_unclaimed", value);
            return this;
        }

        public APIRequestGetLikes requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetLikes requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetLikes requestIsWebhooksSubscribedField() {
            return this.requestIsWebhooksSubscribedField(true);
        }

        public APIRequestGetLikes requestIsWebhooksSubscribedField(boolean value) {
            this.requestField("is_webhooks_subscribed", value);
            return this;
        }

        public APIRequestGetLikes requestKeywordsField() {
            return this.requestKeywordsField(true);
        }

        public APIRequestGetLikes requestKeywordsField(boolean value) {
            this.requestField("keywords", value);
            return this;
        }

        public APIRequestGetLikes requestLeadgenFormPreviewDetailsField() {
            return this.requestLeadgenFormPreviewDetailsField(true);
        }

        public APIRequestGetLikes requestLeadgenFormPreviewDetailsField(boolean value) {
            this.requestField("leadgen_form_preview_details", value);
            return this;
        }

        public APIRequestGetLikes requestLeadgenHasCrmIntegrationField() {
            return this.requestLeadgenHasCrmIntegrationField(true);
        }

        public APIRequestGetLikes requestLeadgenHasCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_crm_integration", value);
            return this;
        }

        public APIRequestGetLikes requestLeadgenHasFatPingCrmIntegrationField() {
            return this.requestLeadgenHasFatPingCrmIntegrationField(true);
        }

        public APIRequestGetLikes requestLeadgenHasFatPingCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_fat_ping_crm_integration", value);
            return this;
        }

        public APIRequestGetLikes requestLeadgenTosAcceptanceTimeField() {
            return this.requestLeadgenTosAcceptanceTimeField(true);
        }

        public APIRequestGetLikes requestLeadgenTosAcceptanceTimeField(boolean value) {
            this.requestField("leadgen_tos_acceptance_time", value);
            return this;
        }

        public APIRequestGetLikes requestLeadgenTosAcceptedField() {
            return this.requestLeadgenTosAcceptedField(true);
        }

        public APIRequestGetLikes requestLeadgenTosAcceptedField(boolean value) {
            this.requestField("leadgen_tos_accepted", value);
            return this;
        }

        public APIRequestGetLikes requestLeadgenTosAcceptingUserField() {
            return this.requestLeadgenTosAcceptingUserField(true);
        }

        public APIRequestGetLikes requestLeadgenTosAcceptingUserField(boolean value) {
            this.requestField("leadgen_tos_accepting_user", value);
            return this;
        }

        public APIRequestGetLikes requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetLikes requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetLikes requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetLikes requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetLikes requestMembersField() {
            return this.requestMembersField(true);
        }

        public APIRequestGetLikes requestMembersField(boolean value) {
            this.requestField("members", value);
            return this;
        }

        public APIRequestGetLikes requestMerchantIdField() {
            return this.requestMerchantIdField(true);
        }

        public APIRequestGetLikes requestMerchantIdField(boolean value) {
            this.requestField("merchant_id", value);
            return this;
        }

        public APIRequestGetLikes requestMerchantReviewStatusField() {
            return this.requestMerchantReviewStatusField(true);
        }

        public APIRequestGetLikes requestMerchantReviewStatusField(boolean value) {
            this.requestField("merchant_review_status", value);
            return this;
        }

        public APIRequestGetLikes requestMessengerAdsDefaultIcebreakersField() {
            return this.requestMessengerAdsDefaultIcebreakersField(true);
        }

        public APIRequestGetLikes requestMessengerAdsDefaultIcebreakersField(boolean value) {
            this.requestField("messenger_ads_default_icebreakers", value);
            return this;
        }

        public APIRequestGetLikes requestMessengerAdsDefaultPageWelcomeMessageField() {
            return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
        }

        public APIRequestGetLikes requestMessengerAdsDefaultPageWelcomeMessageField(boolean value) {
            this.requestField("messenger_ads_default_page_welcome_message", value);
            return this;
        }

        public APIRequestGetLikes requestMessengerAdsDefaultQuickRepliesField() {
            return this.requestMessengerAdsDefaultQuickRepliesField(true);
        }

        public APIRequestGetLikes requestMessengerAdsDefaultQuickRepliesField(boolean value) {
            this.requestField("messenger_ads_default_quick_replies", value);
            return this;
        }

        public APIRequestGetLikes requestMessengerAdsQuickRepliesTypeField() {
            return this.requestMessengerAdsQuickRepliesTypeField(true);
        }

        public APIRequestGetLikes requestMessengerAdsQuickRepliesTypeField(boolean value) {
            this.requestField("messenger_ads_quick_replies_type", value);
            return this;
        }

        public APIRequestGetLikes requestMissionField() {
            return this.requestMissionField(true);
        }

        public APIRequestGetLikes requestMissionField(boolean value) {
            this.requestField("mission", value);
            return this;
        }

        public APIRequestGetLikes requestMpgField() {
            return this.requestMpgField(true);
        }

        public APIRequestGetLikes requestMpgField(boolean value) {
            this.requestField("mpg", value);
            return this;
        }

        public APIRequestGetLikes requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetLikes requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetLikes requestNameWithLocationDescriptorField() {
            return this.requestNameWithLocationDescriptorField(true);
        }

        public APIRequestGetLikes requestNameWithLocationDescriptorField(boolean value) {
            this.requestField("name_with_location_descriptor", value);
            return this;
        }

        public APIRequestGetLikes requestNetworkField() {
            return this.requestNetworkField(true);
        }

        public APIRequestGetLikes requestNetworkField(boolean value) {
            this.requestField("network", value);
            return this;
        }

        public APIRequestGetLikes requestNewLikeCountField() {
            return this.requestNewLikeCountField(true);
        }

        public APIRequestGetLikes requestNewLikeCountField(boolean value) {
            this.requestField("new_like_count", value);
            return this;
        }

        public APIRequestGetLikes requestOfferEligibleField() {
            return this.requestOfferEligibleField(true);
        }

        public APIRequestGetLikes requestOfferEligibleField(boolean value) {
            this.requestField("offer_eligible", value);
            return this;
        }

        public APIRequestGetLikes requestOverallStarRatingField() {
            return this.requestOverallStarRatingField(true);
        }

        public APIRequestGetLikes requestOverallStarRatingField(boolean value) {
            this.requestField("overall_star_rating", value);
            return this;
        }

        public APIRequestGetLikes requestPageTokenField() {
            return this.requestPageTokenField(true);
        }

        public APIRequestGetLikes requestPageTokenField(boolean value) {
            this.requestField("page_token", value);
            return this;
        }

        public APIRequestGetLikes requestParentPageField() {
            return this.requestParentPageField(true);
        }

        public APIRequestGetLikes requestParentPageField(boolean value) {
            this.requestField("parent_page", value);
            return this;
        }

        public APIRequestGetLikes requestParkingField() {
            return this.requestParkingField(true);
        }

        public APIRequestGetLikes requestParkingField(boolean value) {
            this.requestField("parking", value);
            return this;
        }

        public APIRequestGetLikes requestPaymentOptionsField() {
            return this.requestPaymentOptionsField(true);
        }

        public APIRequestGetLikes requestPaymentOptionsField(boolean value) {
            this.requestField("payment_options", value);
            return this;
        }

        public APIRequestGetLikes requestPersonalInfoField() {
            return this.requestPersonalInfoField(true);
        }

        public APIRequestGetLikes requestPersonalInfoField(boolean value) {
            this.requestField("personal_info", value);
            return this;
        }

        public APIRequestGetLikes requestPersonalInterestsField() {
            return this.requestPersonalInterestsField(true);
        }

        public APIRequestGetLikes requestPersonalInterestsField(boolean value) {
            this.requestField("personal_interests", value);
            return this;
        }

        public APIRequestGetLikes requestPharmaSafetyInfoField() {
            return this.requestPharmaSafetyInfoField(true);
        }

        public APIRequestGetLikes requestPharmaSafetyInfoField(boolean value) {
            this.requestField("pharma_safety_info", value);
            return this;
        }

        public APIRequestGetLikes requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGetLikes requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGetLikes requestPlaceTypeField() {
            return this.requestPlaceTypeField(true);
        }

        public APIRequestGetLikes requestPlaceTypeField(boolean value) {
            this.requestField("place_type", value);
            return this;
        }

        public APIRequestGetLikes requestPlotOutlineField() {
            return this.requestPlotOutlineField(true);
        }

        public APIRequestGetLikes requestPlotOutlineField(boolean value) {
            this.requestField("plot_outline", value);
            return this;
        }

        public APIRequestGetLikes requestPreferredAudienceField() {
            return this.requestPreferredAudienceField(true);
        }

        public APIRequestGetLikes requestPreferredAudienceField(boolean value) {
            this.requestField("preferred_audience", value);
            return this;
        }

        public APIRequestGetLikes requestPressContactField() {
            return this.requestPressContactField(true);
        }

        public APIRequestGetLikes requestPressContactField(boolean value) {
            this.requestField("press_contact", value);
            return this;
        }

        public APIRequestGetLikes requestPriceRangeField() {
            return this.requestPriceRangeField(true);
        }

        public APIRequestGetLikes requestPriceRangeField(boolean value) {
            this.requestField("price_range", value);
            return this;
        }

        public APIRequestGetLikes requestProducedByField() {
            return this.requestProducedByField(true);
        }

        public APIRequestGetLikes requestProducedByField(boolean value) {
            this.requestField("produced_by", value);
            return this;
        }

        public APIRequestGetLikes requestProductsField() {
            return this.requestProductsField(true);
        }

        public APIRequestGetLikes requestProductsField(boolean value) {
            this.requestField("products", value);
            return this;
        }

        public APIRequestGetLikes requestPromotionEligibleField() {
            return this.requestPromotionEligibleField(true);
        }

        public APIRequestGetLikes requestPromotionEligibleField(boolean value) {
            this.requestField("promotion_eligible", value);
            return this;
        }

        public APIRequestGetLikes requestPromotionIneligibleReasonField() {
            return this.requestPromotionIneligibleReasonField(true);
        }

        public APIRequestGetLikes requestPromotionIneligibleReasonField(boolean value) {
            this.requestField("promotion_ineligible_reason", value);
            return this;
        }

        public APIRequestGetLikes requestPublicTransitField() {
            return this.requestPublicTransitField(true);
        }

        public APIRequestGetLikes requestPublicTransitField(boolean value) {
            this.requestField("public_transit", value);
            return this;
        }

        public APIRequestGetLikes requestPublisherSpaceField() {
            return this.requestPublisherSpaceField(true);
        }

        public APIRequestGetLikes requestPublisherSpaceField(boolean value) {
            this.requestField("publisher_space", value);
            return this;
        }

        public APIRequestGetLikes requestRatingCountField() {
            return this.requestRatingCountField(true);
        }

        public APIRequestGetLikes requestRatingCountField(boolean value) {
            this.requestField("rating_count", value);
            return this;
        }

        public APIRequestGetLikes requestRecipientField() {
            return this.requestRecipientField(true);
        }

        public APIRequestGetLikes requestRecipientField(boolean value) {
            this.requestField("recipient", value);
            return this;
        }

        public APIRequestGetLikes requestRecordLabelField() {
            return this.requestRecordLabelField(true);
        }

        public APIRequestGetLikes requestRecordLabelField(boolean value) {
            this.requestField("record_label", value);
            return this;
        }

        public APIRequestGetLikes requestReleaseDateField() {
            return this.requestReleaseDateField(true);
        }

        public APIRequestGetLikes requestReleaseDateField(boolean value) {
            this.requestField("release_date", value);
            return this;
        }

        public APIRequestGetLikes requestRestaurantServicesField() {
            return this.requestRestaurantServicesField(true);
        }

        public APIRequestGetLikes requestRestaurantServicesField(boolean value) {
            this.requestField("restaurant_services", value);
            return this;
        }

        public APIRequestGetLikes requestRestaurantSpecialtiesField() {
            return this.requestRestaurantSpecialtiesField(true);
        }

        public APIRequestGetLikes requestRestaurantSpecialtiesField(boolean value) {
            this.requestField("restaurant_specialties", value);
            return this;
        }

        public APIRequestGetLikes requestScheduleField() {
            return this.requestScheduleField(true);
        }

        public APIRequestGetLikes requestScheduleField(boolean value) {
            this.requestField("schedule", value);
            return this;
        }

        public APIRequestGetLikes requestScreenplayByField() {
            return this.requestScreenplayByField(true);
        }

        public APIRequestGetLikes requestScreenplayByField(boolean value) {
            this.requestField("screenplay_by", value);
            return this;
        }

        public APIRequestGetLikes requestSeasonField() {
            return this.requestSeasonField(true);
        }

        public APIRequestGetLikes requestSeasonField(boolean value) {
            this.requestField("season", value);
            return this;
        }

        public APIRequestGetLikes requestSingleLineAddressField() {
            return this.requestSingleLineAddressField(true);
        }

        public APIRequestGetLikes requestSingleLineAddressField(boolean value) {
            this.requestField("single_line_address", value);
            return this;
        }

        public APIRequestGetLikes requestStarringField() {
            return this.requestStarringField(true);
        }

        public APIRequestGetLikes requestStarringField(boolean value) {
            this.requestField("starring", value);
            return this;
        }

        public APIRequestGetLikes requestStartInfoField() {
            return this.requestStartInfoField(true);
        }

        public APIRequestGetLikes requestStartInfoField(boolean value) {
            this.requestField("start_info", value);
            return this;
        }

        public APIRequestGetLikes requestStoreCodeField() {
            return this.requestStoreCodeField(true);
        }

        public APIRequestGetLikes requestStoreCodeField(boolean value) {
            this.requestField("store_code", value);
            return this;
        }

        public APIRequestGetLikes requestStoreLocationDescriptorField() {
            return this.requestStoreLocationDescriptorField(true);
        }

        public APIRequestGetLikes requestStoreLocationDescriptorField(boolean value) {
            this.requestField("store_location_descriptor", value);
            return this;
        }

        public APIRequestGetLikes requestStoreNumberField() {
            return this.requestStoreNumberField(true);
        }

        public APIRequestGetLikes requestStoreNumberField(boolean value) {
            this.requestField("store_number", value);
            return this;
        }

        public APIRequestGetLikes requestStudioField() {
            return this.requestStudioField(true);
        }

        public APIRequestGetLikes requestStudioField(boolean value) {
            this.requestField("studio", value);
            return this;
        }

        public APIRequestGetLikes requestSupportsInstantArticlesField() {
            return this.requestSupportsInstantArticlesField(true);
        }

        public APIRequestGetLikes requestSupportsInstantArticlesField(boolean value) {
            this.requestField("supports_instant_articles", value);
            return this;
        }

        public APIRequestGetLikes requestTalkingAboutCountField() {
            return this.requestTalkingAboutCountField(true);
        }

        public APIRequestGetLikes requestTalkingAboutCountField(boolean value) {
            this.requestField("talking_about_count", value);
            return this;
        }

        public APIRequestGetLikes requestUnreadMessageCountField() {
            return this.requestUnreadMessageCountField(true);
        }

        public APIRequestGetLikes requestUnreadMessageCountField(boolean value) {
            this.requestField("unread_message_count", value);
            return this;
        }

        public APIRequestGetLikes requestUnreadNotifCountField() {
            return this.requestUnreadNotifCountField(true);
        }

        public APIRequestGetLikes requestUnreadNotifCountField(boolean value) {
            this.requestField("unread_notif_count", value);
            return this;
        }

        public APIRequestGetLikes requestUnseenMessageCountField() {
            return this.requestUnseenMessageCountField(true);
        }

        public APIRequestGetLikes requestUnseenMessageCountField(boolean value) {
            this.requestField("unseen_message_count", value);
            return this;
        }

        public APIRequestGetLikes requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetLikes requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGetLikes requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetLikes requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetLikes requestVoipInfoField() {
            return this.requestVoipInfoField(true);
        }

        public APIRequestGetLikes requestVoipInfoField(boolean value) {
            this.requestField("voip_info", value);
            return this;
        }

        public APIRequestGetLikes requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetLikes requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetLikes requestWereHereCountField() {
            return this.requestWereHereCountField(true);
        }

        public APIRequestGetLikes requestWereHereCountField(boolean value) {
            this.requestField("were_here_count", value);
            return this;
        }

        public APIRequestGetLikes requestWhatsappNumberField() {
            return this.requestWhatsappNumberField(true);
        }

        public APIRequestGetLikes requestWhatsappNumberField(boolean value) {
            this.requestField("whatsapp_number", value);
            return this;
        }

        public APIRequestGetLikes requestWrittenByField() {
            return this.requestWrittenByField(true);
        }

        public APIRequestGetLikes requestWrittenByField(boolean value) {
            this.requestField("written_by", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteLikes
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"uid", "url"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteLikes.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteLikes(String nodeId, APIContext context) {
            super(context, nodeId, "/likes", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteLikes setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteLikes setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteLikes setUid(Long uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestDeleteLikes setUid(String uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestDeleteLikes setUrl(String url) {
            this.setParam("url", url);
            return this;
        }

        public APIRequestDeleteLikes requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteLikes requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteLikes requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteLikes requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteLikes requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteLikes requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetInvitableFriends
    extends APIRequest<UserInvitableFriend> {
        APINodeList<UserInvitableFriend> lastResponse = null;
        public static final String[] PARAMS = new String[]{"excluded_ids"};
        public static final String[] FIELDS = new String[]{"first_name", "id", "last_name", "middle_name", "name"};

        @Override
        public APINodeList<UserInvitableFriend> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<UserInvitableFriend> parseResponse(String response) throws APIException {
            return UserInvitableFriend.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<UserInvitableFriend> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<UserInvitableFriend> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<UserInvitableFriend>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<UserInvitableFriend>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<UserInvitableFriend>>(){

                public APINodeList<UserInvitableFriend> apply(String result) {
                    try {
                        return APIRequestGetInvitableFriends.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetInvitableFriends(String nodeId, APIContext context) {
            super(context, nodeId, "/invitable_friends", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetInvitableFriends setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInvitableFriends setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInvitableFriends setExcludedIds(List<Object> excludedIds) {
            this.setParam("excluded_ids", excludedIds);
            return this;
        }

        public APIRequestGetInvitableFriends setExcludedIds(String excludedIds) {
            this.setParam("excluded_ids", excludedIds);
            return this;
        }

        public APIRequestGetInvitableFriends requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInvitableFriends requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInvitableFriends requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInvitableFriends requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInvitableFriends requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInvitableFriends requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetInvitableFriends requestFirstNameField() {
            return this.requestFirstNameField(true);
        }

        public APIRequestGetInvitableFriends requestFirstNameField(boolean value) {
            this.requestField("first_name", value);
            return this;
        }

        public APIRequestGetInvitableFriends requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetInvitableFriends requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetInvitableFriends requestLastNameField() {
            return this.requestLastNameField(true);
        }

        public APIRequestGetInvitableFriends requestLastNameField(boolean value) {
            this.requestField("last_name", value);
            return this;
        }

        public APIRequestGetInvitableFriends requestMiddleNameField() {
            return this.requestMiddleNameField(true);
        }

        public APIRequestGetInvitableFriends requestMiddleNameField(boolean value) {
            this.requestField("middle_name", value);
            return this;
        }

        public APIRequestGetInvitableFriends requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetInvitableFriends requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetIdsForPages
    extends APIRequest<UserIDForPage> {
        APINodeList<UserIDForPage> lastResponse = null;
        public static final String[] PARAMS = new String[]{"page"};
        public static final String[] FIELDS = new String[]{"id", "page"};

        @Override
        public APINodeList<UserIDForPage> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<UserIDForPage> parseResponse(String response) throws APIException {
            return UserIDForPage.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<UserIDForPage> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<UserIDForPage> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<UserIDForPage>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<UserIDForPage>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<UserIDForPage>>(){

                public APINodeList<UserIDForPage> apply(String result) {
                    try {
                        return APIRequestGetIdsForPages.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetIdsForPages(String nodeId, APIContext context) {
            super(context, nodeId, "/ids_for_pages", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetIdsForPages setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetIdsForPages setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetIdsForPages setPage(Long page) {
            this.setParam("page", page);
            return this;
        }

        public APIRequestGetIdsForPages setPage(String page) {
            this.setParam("page", page);
            return this;
        }

        public APIRequestGetIdsForPages requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetIdsForPages requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetIdsForPages requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetIdsForPages requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetIdsForPages requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetIdsForPages requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetIdsForPages requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetIdsForPages requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetIdsForPages requestPageField() {
            return this.requestPageField(true);
        }

        public APIRequestGetIdsForPages requestPageField(boolean value) {
            this.requestField("page", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetIdsForBusiness
    extends APIRequest<UserIDForApp> {
        APINodeList<UserIDForApp> lastResponse = null;
        public static final String[] PARAMS = new String[]{"app"};
        public static final String[] FIELDS = new String[]{"app", "id"};

        @Override
        public APINodeList<UserIDForApp> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<UserIDForApp> parseResponse(String response) throws APIException {
            return UserIDForApp.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<UserIDForApp> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<UserIDForApp> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<UserIDForApp>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<UserIDForApp>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<UserIDForApp>>(){

                public APINodeList<UserIDForApp> apply(String result) {
                    try {
                        return APIRequestGetIdsForBusiness.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetIdsForBusiness(String nodeId, APIContext context) {
            super(context, nodeId, "/ids_for_business", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetIdsForBusiness setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetIdsForBusiness setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetIdsForBusiness setApp(Long app) {
            this.setParam("app", app);
            return this;
        }

        public APIRequestGetIdsForBusiness setApp(String app) {
            this.setParam("app", app);
            return this;
        }

        public APIRequestGetIdsForBusiness requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetIdsForBusiness requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetIdsForBusiness requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetIdsForBusiness requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetIdsForBusiness requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetIdsForBusiness requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetIdsForBusiness requestAppField() {
            return this.requestAppField(true);
        }

        public APIRequestGetIdsForBusiness requestAppField(boolean value) {
            this.requestField("app", value);
            return this;
        }

        public APIRequestGetIdsForBusiness requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetIdsForBusiness requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetIdsForApps
    extends APIRequest<UserIDForApp> {
        APINodeList<UserIDForApp> lastResponse = null;
        public static final String[] PARAMS = new String[]{"app"};
        public static final String[] FIELDS = new String[]{"app", "id"};

        @Override
        public APINodeList<UserIDForApp> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<UserIDForApp> parseResponse(String response) throws APIException {
            return UserIDForApp.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<UserIDForApp> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<UserIDForApp> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<UserIDForApp>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<UserIDForApp>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<UserIDForApp>>(){

                public APINodeList<UserIDForApp> apply(String result) {
                    try {
                        return APIRequestGetIdsForApps.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetIdsForApps(String nodeId, APIContext context) {
            super(context, nodeId, "/ids_for_apps", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetIdsForApps setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetIdsForApps setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetIdsForApps setApp(Long app) {
            this.setParam("app", app);
            return this;
        }

        public APIRequestGetIdsForApps setApp(String app) {
            this.setParam("app", app);
            return this;
        }

        public APIRequestGetIdsForApps requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetIdsForApps requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetIdsForApps requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetIdsForApps requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetIdsForApps requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetIdsForApps requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetIdsForApps requestAppField() {
            return this.requestAppField(true);
        }

        public APIRequestGetIdsForApps requestAppField(boolean value) {
            this.requestField("app", value);
            return this;
        }

        public APIRequestGetIdsForApps requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetIdsForApps requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetGroups
    extends APIRequest<Group> {
        APINodeList<Group> lastResponse = null;
        public static final String[] PARAMS = new String[]{"parent", "admin_only"};
        public static final String[] FIELDS = new String[]{"archived", "cover", "created_time", "description", "email", "icon", "id", "link", "member_count", "member_request_count", "name", "owner", "parent", "permissions", "privacy", "purpose", "subdomain", "updated_time", "venue"};

        @Override
        public APINodeList<Group> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Group> parseResponse(String response) throws APIException {
            return Group.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Group> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Group> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Group>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Group>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Group>>(){

                public APINodeList<Group> apply(String result) {
                    try {
                        return APIRequestGetGroups.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetGroups(String nodeId, APIContext context) {
            super(context, nodeId, "/groups", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetGroups setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetGroups setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetGroups setParent(String parent) {
            this.setParam("parent", parent);
            return this;
        }

        public APIRequestGetGroups setAdminOnly(Boolean adminOnly) {
            this.setParam("admin_only", adminOnly);
            return this;
        }

        public APIRequestGetGroups setAdminOnly(String adminOnly) {
            this.setParam("admin_only", adminOnly);
            return this;
        }

        public APIRequestGetGroups requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetGroups requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetGroups requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetGroups requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetGroups requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetGroups requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetGroups requestArchivedField() {
            return this.requestArchivedField(true);
        }

        public APIRequestGetGroups requestArchivedField(boolean value) {
            this.requestField("archived", value);
            return this;
        }

        public APIRequestGetGroups requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetGroups requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetGroups requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetGroups requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetGroups requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetGroups requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetGroups requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGetGroups requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGetGroups requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGetGroups requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGetGroups requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetGroups requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetGroups requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetGroups requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetGroups requestMemberCountField() {
            return this.requestMemberCountField(true);
        }

        public APIRequestGetGroups requestMemberCountField(boolean value) {
            this.requestField("member_count", value);
            return this;
        }

        public APIRequestGetGroups requestMemberRequestCountField() {
            return this.requestMemberRequestCountField(true);
        }

        public APIRequestGetGroups requestMemberRequestCountField(boolean value) {
            this.requestField("member_request_count", value);
            return this;
        }

        public APIRequestGetGroups requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetGroups requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetGroups requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetGroups requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetGroups requestParentField() {
            return this.requestParentField(true);
        }

        public APIRequestGetGroups requestParentField(boolean value) {
            this.requestField("parent", value);
            return this;
        }

        public APIRequestGetGroups requestPermissionsField() {
            return this.requestPermissionsField(true);
        }

        public APIRequestGetGroups requestPermissionsField(boolean value) {
            this.requestField("permissions", value);
            return this;
        }

        public APIRequestGetGroups requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGetGroups requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGetGroups requestPurposeField() {
            return this.requestPurposeField(true);
        }

        public APIRequestGetGroups requestPurposeField(boolean value) {
            this.requestField("purpose", value);
            return this;
        }

        public APIRequestGetGroups requestSubdomainField() {
            return this.requestSubdomainField(true);
        }

        public APIRequestGetGroups requestSubdomainField(boolean value) {
            this.requestField("subdomain", value);
            return this;
        }

        public APIRequestGetGroups requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetGroups requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetGroups requestVenueField() {
            return this.requestVenueField(true);
        }

        public APIRequestGetGroups requestVenueField(boolean value) {
            this.requestField("venue", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateGamesPlay
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"to", "client_secret", "preview", "ios_bundle_id", "android_key_hash", "proxied_app_id", "user_selected_tags", "user_selected_place", "added", "alias", "fb:channel", "created_time", "end_time", "expires_in", "fb:explicitly_shared", "image:height", "image:secure_url", "image:type", "image:url", "image:user_generated", "image:width", "no_feed_story", "no_action_link", "notify", "message", "place", "privacy", "ref", "scrape", "start_time", "tags"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateGamesPlay.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateGamesPlay(String nodeId, APIContext context) {
            super(context, nodeId, "/gamesplays", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateGamesPlay setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateGamesPlay setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateGamesPlay setTo(String to) {
            this.setParam("to", to);
            return this;
        }

        public APIRequestCreateGamesPlay setClientSecret(String clientSecret) {
            this.setParam("client_secret", clientSecret);
            return this;
        }

        public APIRequestCreateGamesPlay setPreview(Boolean preview) {
            this.setParam("preview", preview);
            return this;
        }

        public APIRequestCreateGamesPlay setPreview(String preview) {
            this.setParam("preview", preview);
            return this;
        }

        public APIRequestCreateGamesPlay setIosBundleId(String iosBundleId) {
            this.setParam("ios_bundle_id", iosBundleId);
            return this;
        }

        public APIRequestCreateGamesPlay setAndroidKeyHash(String androidKeyHash) {
            this.setParam("android_key_hash", androidKeyHash);
            return this;
        }

        public APIRequestCreateGamesPlay setProxiedAppId(String proxiedAppId) {
            this.setParam("proxied_app_id", proxiedAppId);
            return this;
        }

        public APIRequestCreateGamesPlay setUserSelectedTags(Boolean userSelectedTags) {
            this.setParam("user_selected_tags", userSelectedTags);
            return this;
        }

        public APIRequestCreateGamesPlay setUserSelectedTags(String userSelectedTags) {
            this.setParam("user_selected_tags", userSelectedTags);
            return this;
        }

        public APIRequestCreateGamesPlay setUserSelectedPlace(Boolean userSelectedPlace) {
            this.setParam("user_selected_place", userSelectedPlace);
            return this;
        }

        public APIRequestCreateGamesPlay setUserSelectedPlace(String userSelectedPlace) {
            this.setParam("user_selected_place", userSelectedPlace);
            return this;
        }

        public APIRequestCreateGamesPlay setAdded(String added) {
            this.setParam("added", added);
            return this;
        }

        public APIRequestCreateGamesPlay setAlias(String alias) {
            this.setParam("alias", alias);
            return this;
        }

        public APIRequestCreateGamesPlay setFbChannel(String fbChannel) {
            this.setParam("fb:channel", fbChannel);
            return this;
        }

        public APIRequestCreateGamesPlay setCreatedTime(String createdTime) {
            this.setParam("created_time", createdTime);
            return this;
        }

        public APIRequestCreateGamesPlay setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestCreateGamesPlay setExpiresIn(Long expiresIn) {
            this.setParam("expires_in", expiresIn);
            return this;
        }

        public APIRequestCreateGamesPlay setExpiresIn(String expiresIn) {
            this.setParam("expires_in", expiresIn);
            return this;
        }

        public APIRequestCreateGamesPlay setFbExplicitlyShared(Boolean fbExplicitlyShared) {
            this.setParam("fb:explicitly_shared", fbExplicitlyShared);
            return this;
        }

        public APIRequestCreateGamesPlay setFbExplicitlyShared(String fbExplicitlyShared) {
            this.setParam("fb:explicitly_shared", fbExplicitlyShared);
            return this;
        }

        public APIRequestCreateGamesPlay setImageHeight(Long imageHeight) {
            this.setParam("image:height", imageHeight);
            return this;
        }

        public APIRequestCreateGamesPlay setImageHeight(String imageHeight) {
            this.setParam("image:height", imageHeight);
            return this;
        }

        public APIRequestCreateGamesPlay setImageSecureUrl(String imageSecureUrl) {
            this.setParam("image:secure_url", imageSecureUrl);
            return this;
        }

        public APIRequestCreateGamesPlay setImageType(String imageType) {
            this.setParam("image:type", imageType);
            return this;
        }

        public APIRequestCreateGamesPlay setImageUrl(String imageUrl) {
            this.setParam("image:url", imageUrl);
            return this;
        }

        public APIRequestCreateGamesPlay setImageUserGenerated(Boolean imageUserGenerated) {
            this.setParam("image:user_generated", imageUserGenerated);
            return this;
        }

        public APIRequestCreateGamesPlay setImageUserGenerated(String imageUserGenerated) {
            this.setParam("image:user_generated", imageUserGenerated);
            return this;
        }

        public APIRequestCreateGamesPlay setImageWidth(Long imageWidth) {
            this.setParam("image:width", imageWidth);
            return this;
        }

        public APIRequestCreateGamesPlay setImageWidth(String imageWidth) {
            this.setParam("image:width", imageWidth);
            return this;
        }

        public APIRequestCreateGamesPlay setNoFeedStory(Boolean noFeedStory) {
            this.setParam("no_feed_story", noFeedStory);
            return this;
        }

        public APIRequestCreateGamesPlay setNoFeedStory(String noFeedStory) {
            this.setParam("no_feed_story", noFeedStory);
            return this;
        }

        public APIRequestCreateGamesPlay setNoActionLink(Boolean noActionLink) {
            this.setParam("no_action_link", noActionLink);
            return this;
        }

        public APIRequestCreateGamesPlay setNoActionLink(String noActionLink) {
            this.setParam("no_action_link", noActionLink);
            return this;
        }

        public APIRequestCreateGamesPlay setNotify(Boolean notify) {
            this.setParam("notify", notify);
            return this;
        }

        public APIRequestCreateGamesPlay setNotify(String notify) {
            this.setParam("notify", notify);
            return this;
        }

        public APIRequestCreateGamesPlay setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateGamesPlay setPlace(String place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreateGamesPlay setPrivacy(Object privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateGamesPlay setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateGamesPlay setRef(String ref) {
            this.setParam("ref", ref);
            return this;
        }

        public APIRequestCreateGamesPlay setScrape(Boolean scrape) {
            this.setParam("scrape", scrape);
            return this;
        }

        public APIRequestCreateGamesPlay setScrape(String scrape) {
            this.setParam("scrape", scrape);
            return this;
        }

        public APIRequestCreateGamesPlay setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestCreateGamesPlay setTags(List<Long> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateGamesPlay setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateGamesPlay requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateGamesPlay requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGamesPlay requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateGamesPlay requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGamesPlay requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateGamesPlay requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateGamesAchieve
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"to", "client_secret", "preview", "ios_bundle_id", "android_key_hash", "proxied_app_id", "user_selected_tags", "user_selected_place", "added", "alias", "fb:channel", "created_time", "end_time", "expires_in", "fb:explicitly_shared", "image:height", "image:secure_url", "image:type", "image:url", "image:user_generated", "image:width", "no_feed_story", "no_action_link", "notify", "message", "place", "privacy", "ref", "scrape", "start_time", "tags"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateGamesAchieve.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateGamesAchieve(String nodeId, APIContext context) {
            super(context, nodeId, "/gamesachieves", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateGamesAchieve setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateGamesAchieve setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateGamesAchieve setTo(String to) {
            this.setParam("to", to);
            return this;
        }

        public APIRequestCreateGamesAchieve setClientSecret(String clientSecret) {
            this.setParam("client_secret", clientSecret);
            return this;
        }

        public APIRequestCreateGamesAchieve setPreview(Boolean preview) {
            this.setParam("preview", preview);
            return this;
        }

        public APIRequestCreateGamesAchieve setPreview(String preview) {
            this.setParam("preview", preview);
            return this;
        }

        public APIRequestCreateGamesAchieve setIosBundleId(String iosBundleId) {
            this.setParam("ios_bundle_id", iosBundleId);
            return this;
        }

        public APIRequestCreateGamesAchieve setAndroidKeyHash(String androidKeyHash) {
            this.setParam("android_key_hash", androidKeyHash);
            return this;
        }

        public APIRequestCreateGamesAchieve setProxiedAppId(String proxiedAppId) {
            this.setParam("proxied_app_id", proxiedAppId);
            return this;
        }

        public APIRequestCreateGamesAchieve setUserSelectedTags(Boolean userSelectedTags) {
            this.setParam("user_selected_tags", userSelectedTags);
            return this;
        }

        public APIRequestCreateGamesAchieve setUserSelectedTags(String userSelectedTags) {
            this.setParam("user_selected_tags", userSelectedTags);
            return this;
        }

        public APIRequestCreateGamesAchieve setUserSelectedPlace(Boolean userSelectedPlace) {
            this.setParam("user_selected_place", userSelectedPlace);
            return this;
        }

        public APIRequestCreateGamesAchieve setUserSelectedPlace(String userSelectedPlace) {
            this.setParam("user_selected_place", userSelectedPlace);
            return this;
        }

        public APIRequestCreateGamesAchieve setAdded(String added) {
            this.setParam("added", added);
            return this;
        }

        public APIRequestCreateGamesAchieve setAlias(String alias) {
            this.setParam("alias", alias);
            return this;
        }

        public APIRequestCreateGamesAchieve setFbChannel(String fbChannel) {
            this.setParam("fb:channel", fbChannel);
            return this;
        }

        public APIRequestCreateGamesAchieve setCreatedTime(String createdTime) {
            this.setParam("created_time", createdTime);
            return this;
        }

        public APIRequestCreateGamesAchieve setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestCreateGamesAchieve setExpiresIn(Long expiresIn) {
            this.setParam("expires_in", expiresIn);
            return this;
        }

        public APIRequestCreateGamesAchieve setExpiresIn(String expiresIn) {
            this.setParam("expires_in", expiresIn);
            return this;
        }

        public APIRequestCreateGamesAchieve setFbExplicitlyShared(Boolean fbExplicitlyShared) {
            this.setParam("fb:explicitly_shared", fbExplicitlyShared);
            return this;
        }

        public APIRequestCreateGamesAchieve setFbExplicitlyShared(String fbExplicitlyShared) {
            this.setParam("fb:explicitly_shared", fbExplicitlyShared);
            return this;
        }

        public APIRequestCreateGamesAchieve setImageHeight(Long imageHeight) {
            this.setParam("image:height", imageHeight);
            return this;
        }

        public APIRequestCreateGamesAchieve setImageHeight(String imageHeight) {
            this.setParam("image:height", imageHeight);
            return this;
        }

        public APIRequestCreateGamesAchieve setImageSecureUrl(String imageSecureUrl) {
            this.setParam("image:secure_url", imageSecureUrl);
            return this;
        }

        public APIRequestCreateGamesAchieve setImageType(String imageType) {
            this.setParam("image:type", imageType);
            return this;
        }

        public APIRequestCreateGamesAchieve setImageUrl(String imageUrl) {
            this.setParam("image:url", imageUrl);
            return this;
        }

        public APIRequestCreateGamesAchieve setImageUserGenerated(Boolean imageUserGenerated) {
            this.setParam("image:user_generated", imageUserGenerated);
            return this;
        }

        public APIRequestCreateGamesAchieve setImageUserGenerated(String imageUserGenerated) {
            this.setParam("image:user_generated", imageUserGenerated);
            return this;
        }

        public APIRequestCreateGamesAchieve setImageWidth(Long imageWidth) {
            this.setParam("image:width", imageWidth);
            return this;
        }

        public APIRequestCreateGamesAchieve setImageWidth(String imageWidth) {
            this.setParam("image:width", imageWidth);
            return this;
        }

        public APIRequestCreateGamesAchieve setNoFeedStory(Boolean noFeedStory) {
            this.setParam("no_feed_story", noFeedStory);
            return this;
        }

        public APIRequestCreateGamesAchieve setNoFeedStory(String noFeedStory) {
            this.setParam("no_feed_story", noFeedStory);
            return this;
        }

        public APIRequestCreateGamesAchieve setNoActionLink(Boolean noActionLink) {
            this.setParam("no_action_link", noActionLink);
            return this;
        }

        public APIRequestCreateGamesAchieve setNoActionLink(String noActionLink) {
            this.setParam("no_action_link", noActionLink);
            return this;
        }

        public APIRequestCreateGamesAchieve setNotify(Boolean notify) {
            this.setParam("notify", notify);
            return this;
        }

        public APIRequestCreateGamesAchieve setNotify(String notify) {
            this.setParam("notify", notify);
            return this;
        }

        public APIRequestCreateGamesAchieve setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateGamesAchieve setPlace(String place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreateGamesAchieve setPrivacy(Object privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateGamesAchieve setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateGamesAchieve setRef(String ref) {
            this.setParam("ref", ref);
            return this;
        }

        public APIRequestCreateGamesAchieve setScrape(Boolean scrape) {
            this.setParam("scrape", scrape);
            return this;
        }

        public APIRequestCreateGamesAchieve setScrape(String scrape) {
            this.setParam("scrape", scrape);
            return this;
        }

        public APIRequestCreateGamesAchieve setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestCreateGamesAchieve setTags(List<Long> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateGamesAchieve setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateGamesAchieve requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateGamesAchieve requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGamesAchieve requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateGamesAchieve requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGamesAchieve requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateGamesAchieve requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateGamesStat
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"stat_name", "set", "inc"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateGamesStat.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateGamesStat(String nodeId, APIContext context) {
            super(context, nodeId, "/games_stats", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateGamesStat setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateGamesStat setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateGamesStat setStatName(String statName) {
            this.setParam("stat_name", statName);
            return this;
        }

        public APIRequestCreateGamesStat setSet(Long set) {
            this.setParam("set", set);
            return this;
        }

        public APIRequestCreateGamesStat setSet(String set) {
            this.setParam("set", set);
            return this;
        }

        public APIRequestCreateGamesStat setInc(Long inc) {
            this.setParam("inc", inc);
            return this;
        }

        public APIRequestCreateGamesStat setInc(String inc) {
            this.setParam("inc", inc);
            return this;
        }

        public APIRequestCreateGamesStat requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateGamesStat requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGamesStat requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateGamesStat requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGamesStat requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateGamesStat requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetGames
    extends APIRequest<Page> {
        APINodeList<Page> lastResponse = null;
        public static final String[] PARAMS = new String[]{"target_id"};
        public static final String[] FIELDS = new String[]{"about", "access_token", "ad_campaign", "affiliation", "app_id", "app_links", "artists_we_like", "attire", "awards", "band_interests", "band_members", "best_page", "bio", "birthday", "booking_agent", "built", "business", "can_checkin", "can_post", "category", "category_list", "checkins", "company_overview", "connected_instagram_account", "contact_address", "context", "copyright_attribution_insights", "copyright_whitelisted_ig_partners", "country_page_likes", "cover", "culinary_team", "current_location", "description", "description_html", "directed_by", "display_subtext", "displayed_message_response_time", "emails", "engagement", "fan_count", "featured_video", "features", "food_styles", "founded", "general_info", "general_manager", "genre", "global_brand_page_name", "global_brand_parent_page", "global_brand_root_id", "has_added_app", "has_whatsapp_business_number", "has_whatsapp_number", "hometown", "hours", "id", "impressum", "influences", "instagram_business_account", "instant_articles_review_status", "is_always_open", "is_chain", "is_community_page", "is_eligible_for_branded_content", "is_messenger_bot_get_started_enabled", "is_messenger_platform_bot", "is_owned", "is_permanently_closed", "is_published", "is_unclaimed", "is_verified", "is_webhooks_subscribed", "keywords", "leadgen_form_preview_details", "leadgen_has_crm_integration", "leadgen_has_fat_ping_crm_integration", "leadgen_tos_acceptance_time", "leadgen_tos_accepted", "leadgen_tos_accepting_user", "link", "location", "members", "merchant_id", "merchant_review_status", "messenger_ads_default_icebreakers", "messenger_ads_default_page_welcome_message", "messenger_ads_default_quick_replies", "messenger_ads_quick_replies_type", "mission", "mpg", "name", "name_with_location_descriptor", "network", "new_like_count", "offer_eligible", "overall_star_rating", "page_token", "parent_page", "parking", "payment_options", "personal_info", "personal_interests", "pharma_safety_info", "phone", "place_type", "plot_outline", "preferred_audience", "press_contact", "price_range", "produced_by", "products", "promotion_eligible", "promotion_ineligible_reason", "public_transit", "publisher_space", "rating_count", "recipient", "record_label", "release_date", "restaurant_services", "restaurant_specialties", "schedule", "screenplay_by", "season", "single_line_address", "starring", "start_info", "store_code", "store_location_descriptor", "store_number", "studio", "supports_instant_articles", "talking_about_count", "unread_message_count", "unread_notif_count", "unseen_message_count", "username", "verification_status", "voip_info", "website", "were_here_count", "whatsapp_number", "written_by"};

        @Override
        public APINodeList<Page> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Page> parseResponse(String response) throws APIException {
            return Page.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Page> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Page>>(){

                public APINodeList<Page> apply(String result) {
                    try {
                        return APIRequestGetGames.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetGames(String nodeId, APIContext context) {
            super(context, nodeId, "/games", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetGames setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetGames setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetGames setTargetId(String targetId) {
            this.setParam("target_id", targetId);
            return this;
        }

        public APIRequestGetGames requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetGames requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetGames requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetGames requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetGames requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetGames requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetGames requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetGames requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetGames requestAccessTokenField() {
            return this.requestAccessTokenField(true);
        }

        public APIRequestGetGames requestAccessTokenField(boolean value) {
            this.requestField("access_token", value);
            return this;
        }

        public APIRequestGetGames requestAdCampaignField() {
            return this.requestAdCampaignField(true);
        }

        public APIRequestGetGames requestAdCampaignField(boolean value) {
            this.requestField("ad_campaign", value);
            return this;
        }

        public APIRequestGetGames requestAffiliationField() {
            return this.requestAffiliationField(true);
        }

        public APIRequestGetGames requestAffiliationField(boolean value) {
            this.requestField("affiliation", value);
            return this;
        }

        public APIRequestGetGames requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetGames requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetGames requestAppLinksField() {
            return this.requestAppLinksField(true);
        }

        public APIRequestGetGames requestAppLinksField(boolean value) {
            this.requestField("app_links", value);
            return this;
        }

        public APIRequestGetGames requestArtistsWeLikeField() {
            return this.requestArtistsWeLikeField(true);
        }

        public APIRequestGetGames requestArtistsWeLikeField(boolean value) {
            this.requestField("artists_we_like", value);
            return this;
        }

        public APIRequestGetGames requestAttireField() {
            return this.requestAttireField(true);
        }

        public APIRequestGetGames requestAttireField(boolean value) {
            this.requestField("attire", value);
            return this;
        }

        public APIRequestGetGames requestAwardsField() {
            return this.requestAwardsField(true);
        }

        public APIRequestGetGames requestAwardsField(boolean value) {
            this.requestField("awards", value);
            return this;
        }

        public APIRequestGetGames requestBandInterestsField() {
            return this.requestBandInterestsField(true);
        }

        public APIRequestGetGames requestBandInterestsField(boolean value) {
            this.requestField("band_interests", value);
            return this;
        }

        public APIRequestGetGames requestBandMembersField() {
            return this.requestBandMembersField(true);
        }

        public APIRequestGetGames requestBandMembersField(boolean value) {
            this.requestField("band_members", value);
            return this;
        }

        public APIRequestGetGames requestBestPageField() {
            return this.requestBestPageField(true);
        }

        public APIRequestGetGames requestBestPageField(boolean value) {
            this.requestField("best_page", value);
            return this;
        }

        public APIRequestGetGames requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetGames requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetGames requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetGames requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetGames requestBookingAgentField() {
            return this.requestBookingAgentField(true);
        }

        public APIRequestGetGames requestBookingAgentField(boolean value) {
            this.requestField("booking_agent", value);
            return this;
        }

        public APIRequestGetGames requestBuiltField() {
            return this.requestBuiltField(true);
        }

        public APIRequestGetGames requestBuiltField(boolean value) {
            this.requestField("built", value);
            return this;
        }

        public APIRequestGetGames requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetGames requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetGames requestCanCheckinField() {
            return this.requestCanCheckinField(true);
        }

        public APIRequestGetGames requestCanCheckinField(boolean value) {
            this.requestField("can_checkin", value);
            return this;
        }

        public APIRequestGetGames requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetGames requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetGames requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetGames requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetGames requestCategoryListField() {
            return this.requestCategoryListField(true);
        }

        public APIRequestGetGames requestCategoryListField(boolean value) {
            this.requestField("category_list", value);
            return this;
        }

        public APIRequestGetGames requestCheckinsField() {
            return this.requestCheckinsField(true);
        }

        public APIRequestGetGames requestCheckinsField(boolean value) {
            this.requestField("checkins", value);
            return this;
        }

        public APIRequestGetGames requestCompanyOverviewField() {
            return this.requestCompanyOverviewField(true);
        }

        public APIRequestGetGames requestCompanyOverviewField(boolean value) {
            this.requestField("company_overview", value);
            return this;
        }

        public APIRequestGetGames requestConnectedInstagramAccountField() {
            return this.requestConnectedInstagramAccountField(true);
        }

        public APIRequestGetGames requestConnectedInstagramAccountField(boolean value) {
            this.requestField("connected_instagram_account", value);
            return this;
        }

        public APIRequestGetGames requestContactAddressField() {
            return this.requestContactAddressField(true);
        }

        public APIRequestGetGames requestContactAddressField(boolean value) {
            this.requestField("contact_address", value);
            return this;
        }

        public APIRequestGetGames requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetGames requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetGames requestCopyrightAttributionInsightsField() {
            return this.requestCopyrightAttributionInsightsField(true);
        }

        public APIRequestGetGames requestCopyrightAttributionInsightsField(boolean value) {
            this.requestField("copyright_attribution_insights", value);
            return this;
        }

        public APIRequestGetGames requestCopyrightWhitelistedIgPartnersField() {
            return this.requestCopyrightWhitelistedIgPartnersField(true);
        }

        public APIRequestGetGames requestCopyrightWhitelistedIgPartnersField(boolean value) {
            this.requestField("copyright_whitelisted_ig_partners", value);
            return this;
        }

        public APIRequestGetGames requestCountryPageLikesField() {
            return this.requestCountryPageLikesField(true);
        }

        public APIRequestGetGames requestCountryPageLikesField(boolean value) {
            this.requestField("country_page_likes", value);
            return this;
        }

        public APIRequestGetGames requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetGames requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetGames requestCulinaryTeamField() {
            return this.requestCulinaryTeamField(true);
        }

        public APIRequestGetGames requestCulinaryTeamField(boolean value) {
            this.requestField("culinary_team", value);
            return this;
        }

        public APIRequestGetGames requestCurrentLocationField() {
            return this.requestCurrentLocationField(true);
        }

        public APIRequestGetGames requestCurrentLocationField(boolean value) {
            this.requestField("current_location", value);
            return this;
        }

        public APIRequestGetGames requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetGames requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetGames requestDescriptionHtmlField() {
            return this.requestDescriptionHtmlField(true);
        }

        public APIRequestGetGames requestDescriptionHtmlField(boolean value) {
            this.requestField("description_html", value);
            return this;
        }

        public APIRequestGetGames requestDirectedByField() {
            return this.requestDirectedByField(true);
        }

        public APIRequestGetGames requestDirectedByField(boolean value) {
            this.requestField("directed_by", value);
            return this;
        }

        public APIRequestGetGames requestDisplaySubtextField() {
            return this.requestDisplaySubtextField(true);
        }

        public APIRequestGetGames requestDisplaySubtextField(boolean value) {
            this.requestField("display_subtext", value);
            return this;
        }

        public APIRequestGetGames requestDisplayedMessageResponseTimeField() {
            return this.requestDisplayedMessageResponseTimeField(true);
        }

        public APIRequestGetGames requestDisplayedMessageResponseTimeField(boolean value) {
            this.requestField("displayed_message_response_time", value);
            return this;
        }

        public APIRequestGetGames requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGetGames requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGetGames requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGetGames requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGetGames requestFanCountField() {
            return this.requestFanCountField(true);
        }

        public APIRequestGetGames requestFanCountField(boolean value) {
            this.requestField("fan_count", value);
            return this;
        }

        public APIRequestGetGames requestFeaturedVideoField() {
            return this.requestFeaturedVideoField(true);
        }

        public APIRequestGetGames requestFeaturedVideoField(boolean value) {
            this.requestField("featured_video", value);
            return this;
        }

        public APIRequestGetGames requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGetGames requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGetGames requestFoodStylesField() {
            return this.requestFoodStylesField(true);
        }

        public APIRequestGetGames requestFoodStylesField(boolean value) {
            this.requestField("food_styles", value);
            return this;
        }

        public APIRequestGetGames requestFoundedField() {
            return this.requestFoundedField(true);
        }

        public APIRequestGetGames requestFoundedField(boolean value) {
            this.requestField("founded", value);
            return this;
        }

        public APIRequestGetGames requestGeneralInfoField() {
            return this.requestGeneralInfoField(true);
        }

        public APIRequestGetGames requestGeneralInfoField(boolean value) {
            this.requestField("general_info", value);
            return this;
        }

        public APIRequestGetGames requestGeneralManagerField() {
            return this.requestGeneralManagerField(true);
        }

        public APIRequestGetGames requestGeneralManagerField(boolean value) {
            this.requestField("general_manager", value);
            return this;
        }

        public APIRequestGetGames requestGenreField() {
            return this.requestGenreField(true);
        }

        public APIRequestGetGames requestGenreField(boolean value) {
            this.requestField("genre", value);
            return this;
        }

        public APIRequestGetGames requestGlobalBrandPageNameField() {
            return this.requestGlobalBrandPageNameField(true);
        }

        public APIRequestGetGames requestGlobalBrandPageNameField(boolean value) {
            this.requestField("global_brand_page_name", value);
            return this;
        }

        public APIRequestGetGames requestGlobalBrandParentPageField() {
            return this.requestGlobalBrandParentPageField(true);
        }

        public APIRequestGetGames requestGlobalBrandParentPageField(boolean value) {
            this.requestField("global_brand_parent_page", value);
            return this;
        }

        public APIRequestGetGames requestGlobalBrandRootIdField() {
            return this.requestGlobalBrandRootIdField(true);
        }

        public APIRequestGetGames requestGlobalBrandRootIdField(boolean value) {
            this.requestField("global_brand_root_id", value);
            return this;
        }

        public APIRequestGetGames requestHasAddedAppField() {
            return this.requestHasAddedAppField(true);
        }

        public APIRequestGetGames requestHasAddedAppField(boolean value) {
            this.requestField("has_added_app", value);
            return this;
        }

        public APIRequestGetGames requestHasWhatsappBusinessNumberField() {
            return this.requestHasWhatsappBusinessNumberField(true);
        }

        public APIRequestGetGames requestHasWhatsappBusinessNumberField(boolean value) {
            this.requestField("has_whatsapp_business_number", value);
            return this;
        }

        public APIRequestGetGames requestHasWhatsappNumberField() {
            return this.requestHasWhatsappNumberField(true);
        }

        public APIRequestGetGames requestHasWhatsappNumberField(boolean value) {
            this.requestField("has_whatsapp_number", value);
            return this;
        }

        public APIRequestGetGames requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetGames requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetGames requestHoursField() {
            return this.requestHoursField(true);
        }

        public APIRequestGetGames requestHoursField(boolean value) {
            this.requestField("hours", value);
            return this;
        }

        public APIRequestGetGames requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetGames requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetGames requestImpressumField() {
            return this.requestImpressumField(true);
        }

        public APIRequestGetGames requestImpressumField(boolean value) {
            this.requestField("impressum", value);
            return this;
        }

        public APIRequestGetGames requestInfluencesField() {
            return this.requestInfluencesField(true);
        }

        public APIRequestGetGames requestInfluencesField(boolean value) {
            this.requestField("influences", value);
            return this;
        }

        public APIRequestGetGames requestInstagramBusinessAccountField() {
            return this.requestInstagramBusinessAccountField(true);
        }

        public APIRequestGetGames requestInstagramBusinessAccountField(boolean value) {
            this.requestField("instagram_business_account", value);
            return this;
        }

        public APIRequestGetGames requestInstantArticlesReviewStatusField() {
            return this.requestInstantArticlesReviewStatusField(true);
        }

        public APIRequestGetGames requestInstantArticlesReviewStatusField(boolean value) {
            this.requestField("instant_articles_review_status", value);
            return this;
        }

        public APIRequestGetGames requestIsAlwaysOpenField() {
            return this.requestIsAlwaysOpenField(true);
        }

        public APIRequestGetGames requestIsAlwaysOpenField(boolean value) {
            this.requestField("is_always_open", value);
            return this;
        }

        public APIRequestGetGames requestIsChainField() {
            return this.requestIsChainField(true);
        }

        public APIRequestGetGames requestIsChainField(boolean value) {
            this.requestField("is_chain", value);
            return this;
        }

        public APIRequestGetGames requestIsCommunityPageField() {
            return this.requestIsCommunityPageField(true);
        }

        public APIRequestGetGames requestIsCommunityPageField(boolean value) {
            this.requestField("is_community_page", value);
            return this;
        }

        public APIRequestGetGames requestIsEligibleForBrandedContentField() {
            return this.requestIsEligibleForBrandedContentField(true);
        }

        public APIRequestGetGames requestIsEligibleForBrandedContentField(boolean value) {
            this.requestField("is_eligible_for_branded_content", value);
            return this;
        }

        public APIRequestGetGames requestIsMessengerBotGetStartedEnabledField() {
            return this.requestIsMessengerBotGetStartedEnabledField(true);
        }

        public APIRequestGetGames requestIsMessengerBotGetStartedEnabledField(boolean value) {
            this.requestField("is_messenger_bot_get_started_enabled", value);
            return this;
        }

        public APIRequestGetGames requestIsMessengerPlatformBotField() {
            return this.requestIsMessengerPlatformBotField(true);
        }

        public APIRequestGetGames requestIsMessengerPlatformBotField(boolean value) {
            this.requestField("is_messenger_platform_bot", value);
            return this;
        }

        public APIRequestGetGames requestIsOwnedField() {
            return this.requestIsOwnedField(true);
        }

        public APIRequestGetGames requestIsOwnedField(boolean value) {
            this.requestField("is_owned", value);
            return this;
        }

        public APIRequestGetGames requestIsPermanentlyClosedField() {
            return this.requestIsPermanentlyClosedField(true);
        }

        public APIRequestGetGames requestIsPermanentlyClosedField(boolean value) {
            this.requestField("is_permanently_closed", value);
            return this;
        }

        public APIRequestGetGames requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetGames requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetGames requestIsUnclaimedField() {
            return this.requestIsUnclaimedField(true);
        }

        public APIRequestGetGames requestIsUnclaimedField(boolean value) {
            this.requestField("is_unclaimed", value);
            return this;
        }

        public APIRequestGetGames requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetGames requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetGames requestIsWebhooksSubscribedField() {
            return this.requestIsWebhooksSubscribedField(true);
        }

        public APIRequestGetGames requestIsWebhooksSubscribedField(boolean value) {
            this.requestField("is_webhooks_subscribed", value);
            return this;
        }

        public APIRequestGetGames requestKeywordsField() {
            return this.requestKeywordsField(true);
        }

        public APIRequestGetGames requestKeywordsField(boolean value) {
            this.requestField("keywords", value);
            return this;
        }

        public APIRequestGetGames requestLeadgenFormPreviewDetailsField() {
            return this.requestLeadgenFormPreviewDetailsField(true);
        }

        public APIRequestGetGames requestLeadgenFormPreviewDetailsField(boolean value) {
            this.requestField("leadgen_form_preview_details", value);
            return this;
        }

        public APIRequestGetGames requestLeadgenHasCrmIntegrationField() {
            return this.requestLeadgenHasCrmIntegrationField(true);
        }

        public APIRequestGetGames requestLeadgenHasCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_crm_integration", value);
            return this;
        }

        public APIRequestGetGames requestLeadgenHasFatPingCrmIntegrationField() {
            return this.requestLeadgenHasFatPingCrmIntegrationField(true);
        }

        public APIRequestGetGames requestLeadgenHasFatPingCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_fat_ping_crm_integration", value);
            return this;
        }

        public APIRequestGetGames requestLeadgenTosAcceptanceTimeField() {
            return this.requestLeadgenTosAcceptanceTimeField(true);
        }

        public APIRequestGetGames requestLeadgenTosAcceptanceTimeField(boolean value) {
            this.requestField("leadgen_tos_acceptance_time", value);
            return this;
        }

        public APIRequestGetGames requestLeadgenTosAcceptedField() {
            return this.requestLeadgenTosAcceptedField(true);
        }

        public APIRequestGetGames requestLeadgenTosAcceptedField(boolean value) {
            this.requestField("leadgen_tos_accepted", value);
            return this;
        }

        public APIRequestGetGames requestLeadgenTosAcceptingUserField() {
            return this.requestLeadgenTosAcceptingUserField(true);
        }

        public APIRequestGetGames requestLeadgenTosAcceptingUserField(boolean value) {
            this.requestField("leadgen_tos_accepting_user", value);
            return this;
        }

        public APIRequestGetGames requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetGames requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetGames requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetGames requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetGames requestMembersField() {
            return this.requestMembersField(true);
        }

        public APIRequestGetGames requestMembersField(boolean value) {
            this.requestField("members", value);
            return this;
        }

        public APIRequestGetGames requestMerchantIdField() {
            return this.requestMerchantIdField(true);
        }

        public APIRequestGetGames requestMerchantIdField(boolean value) {
            this.requestField("merchant_id", value);
            return this;
        }

        public APIRequestGetGames requestMerchantReviewStatusField() {
            return this.requestMerchantReviewStatusField(true);
        }

        public APIRequestGetGames requestMerchantReviewStatusField(boolean value) {
            this.requestField("merchant_review_status", value);
            return this;
        }

        public APIRequestGetGames requestMessengerAdsDefaultIcebreakersField() {
            return this.requestMessengerAdsDefaultIcebreakersField(true);
        }

        public APIRequestGetGames requestMessengerAdsDefaultIcebreakersField(boolean value) {
            this.requestField("messenger_ads_default_icebreakers", value);
            return this;
        }

        public APIRequestGetGames requestMessengerAdsDefaultPageWelcomeMessageField() {
            return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
        }

        public APIRequestGetGames requestMessengerAdsDefaultPageWelcomeMessageField(boolean value) {
            this.requestField("messenger_ads_default_page_welcome_message", value);
            return this;
        }

        public APIRequestGetGames requestMessengerAdsDefaultQuickRepliesField() {
            return this.requestMessengerAdsDefaultQuickRepliesField(true);
        }

        public APIRequestGetGames requestMessengerAdsDefaultQuickRepliesField(boolean value) {
            this.requestField("messenger_ads_default_quick_replies", value);
            return this;
        }

        public APIRequestGetGames requestMessengerAdsQuickRepliesTypeField() {
            return this.requestMessengerAdsQuickRepliesTypeField(true);
        }

        public APIRequestGetGames requestMessengerAdsQuickRepliesTypeField(boolean value) {
            this.requestField("messenger_ads_quick_replies_type", value);
            return this;
        }

        public APIRequestGetGames requestMissionField() {
            return this.requestMissionField(true);
        }

        public APIRequestGetGames requestMissionField(boolean value) {
            this.requestField("mission", value);
            return this;
        }

        public APIRequestGetGames requestMpgField() {
            return this.requestMpgField(true);
        }

        public APIRequestGetGames requestMpgField(boolean value) {
            this.requestField("mpg", value);
            return this;
        }

        public APIRequestGetGames requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetGames requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetGames requestNameWithLocationDescriptorField() {
            return this.requestNameWithLocationDescriptorField(true);
        }

        public APIRequestGetGames requestNameWithLocationDescriptorField(boolean value) {
            this.requestField("name_with_location_descriptor", value);
            return this;
        }

        public APIRequestGetGames requestNetworkField() {
            return this.requestNetworkField(true);
        }

        public APIRequestGetGames requestNetworkField(boolean value) {
            this.requestField("network", value);
            return this;
        }

        public APIRequestGetGames requestNewLikeCountField() {
            return this.requestNewLikeCountField(true);
        }

        public APIRequestGetGames requestNewLikeCountField(boolean value) {
            this.requestField("new_like_count", value);
            return this;
        }

        public APIRequestGetGames requestOfferEligibleField() {
            return this.requestOfferEligibleField(true);
        }

        public APIRequestGetGames requestOfferEligibleField(boolean value) {
            this.requestField("offer_eligible", value);
            return this;
        }

        public APIRequestGetGames requestOverallStarRatingField() {
            return this.requestOverallStarRatingField(true);
        }

        public APIRequestGetGames requestOverallStarRatingField(boolean value) {
            this.requestField("overall_star_rating", value);
            return this;
        }

        public APIRequestGetGames requestPageTokenField() {
            return this.requestPageTokenField(true);
        }

        public APIRequestGetGames requestPageTokenField(boolean value) {
            this.requestField("page_token", value);
            return this;
        }

        public APIRequestGetGames requestParentPageField() {
            return this.requestParentPageField(true);
        }

        public APIRequestGetGames requestParentPageField(boolean value) {
            this.requestField("parent_page", value);
            return this;
        }

        public APIRequestGetGames requestParkingField() {
            return this.requestParkingField(true);
        }

        public APIRequestGetGames requestParkingField(boolean value) {
            this.requestField("parking", value);
            return this;
        }

        public APIRequestGetGames requestPaymentOptionsField() {
            return this.requestPaymentOptionsField(true);
        }

        public APIRequestGetGames requestPaymentOptionsField(boolean value) {
            this.requestField("payment_options", value);
            return this;
        }

        public APIRequestGetGames requestPersonalInfoField() {
            return this.requestPersonalInfoField(true);
        }

        public APIRequestGetGames requestPersonalInfoField(boolean value) {
            this.requestField("personal_info", value);
            return this;
        }

        public APIRequestGetGames requestPersonalInterestsField() {
            return this.requestPersonalInterestsField(true);
        }

        public APIRequestGetGames requestPersonalInterestsField(boolean value) {
            this.requestField("personal_interests", value);
            return this;
        }

        public APIRequestGetGames requestPharmaSafetyInfoField() {
            return this.requestPharmaSafetyInfoField(true);
        }

        public APIRequestGetGames requestPharmaSafetyInfoField(boolean value) {
            this.requestField("pharma_safety_info", value);
            return this;
        }

        public APIRequestGetGames requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGetGames requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGetGames requestPlaceTypeField() {
            return this.requestPlaceTypeField(true);
        }

        public APIRequestGetGames requestPlaceTypeField(boolean value) {
            this.requestField("place_type", value);
            return this;
        }

        public APIRequestGetGames requestPlotOutlineField() {
            return this.requestPlotOutlineField(true);
        }

        public APIRequestGetGames requestPlotOutlineField(boolean value) {
            this.requestField("plot_outline", value);
            return this;
        }

        public APIRequestGetGames requestPreferredAudienceField() {
            return this.requestPreferredAudienceField(true);
        }

        public APIRequestGetGames requestPreferredAudienceField(boolean value) {
            this.requestField("preferred_audience", value);
            return this;
        }

        public APIRequestGetGames requestPressContactField() {
            return this.requestPressContactField(true);
        }

        public APIRequestGetGames requestPressContactField(boolean value) {
            this.requestField("press_contact", value);
            return this;
        }

        public APIRequestGetGames requestPriceRangeField() {
            return this.requestPriceRangeField(true);
        }

        public APIRequestGetGames requestPriceRangeField(boolean value) {
            this.requestField("price_range", value);
            return this;
        }

        public APIRequestGetGames requestProducedByField() {
            return this.requestProducedByField(true);
        }

        public APIRequestGetGames requestProducedByField(boolean value) {
            this.requestField("produced_by", value);
            return this;
        }

        public APIRequestGetGames requestProductsField() {
            return this.requestProductsField(true);
        }

        public APIRequestGetGames requestProductsField(boolean value) {
            this.requestField("products", value);
            return this;
        }

        public APIRequestGetGames requestPromotionEligibleField() {
            return this.requestPromotionEligibleField(true);
        }

        public APIRequestGetGames requestPromotionEligibleField(boolean value) {
            this.requestField("promotion_eligible", value);
            return this;
        }

        public APIRequestGetGames requestPromotionIneligibleReasonField() {
            return this.requestPromotionIneligibleReasonField(true);
        }

        public APIRequestGetGames requestPromotionIneligibleReasonField(boolean value) {
            this.requestField("promotion_ineligible_reason", value);
            return this;
        }

        public APIRequestGetGames requestPublicTransitField() {
            return this.requestPublicTransitField(true);
        }

        public APIRequestGetGames requestPublicTransitField(boolean value) {
            this.requestField("public_transit", value);
            return this;
        }

        public APIRequestGetGames requestPublisherSpaceField() {
            return this.requestPublisherSpaceField(true);
        }

        public APIRequestGetGames requestPublisherSpaceField(boolean value) {
            this.requestField("publisher_space", value);
            return this;
        }

        public APIRequestGetGames requestRatingCountField() {
            return this.requestRatingCountField(true);
        }

        public APIRequestGetGames requestRatingCountField(boolean value) {
            this.requestField("rating_count", value);
            return this;
        }

        public APIRequestGetGames requestRecipientField() {
            return this.requestRecipientField(true);
        }

        public APIRequestGetGames requestRecipientField(boolean value) {
            this.requestField("recipient", value);
            return this;
        }

        public APIRequestGetGames requestRecordLabelField() {
            return this.requestRecordLabelField(true);
        }

        public APIRequestGetGames requestRecordLabelField(boolean value) {
            this.requestField("record_label", value);
            return this;
        }

        public APIRequestGetGames requestReleaseDateField() {
            return this.requestReleaseDateField(true);
        }

        public APIRequestGetGames requestReleaseDateField(boolean value) {
            this.requestField("release_date", value);
            return this;
        }

        public APIRequestGetGames requestRestaurantServicesField() {
            return this.requestRestaurantServicesField(true);
        }

        public APIRequestGetGames requestRestaurantServicesField(boolean value) {
            this.requestField("restaurant_services", value);
            return this;
        }

        public APIRequestGetGames requestRestaurantSpecialtiesField() {
            return this.requestRestaurantSpecialtiesField(true);
        }

        public APIRequestGetGames requestRestaurantSpecialtiesField(boolean value) {
            this.requestField("restaurant_specialties", value);
            return this;
        }

        public APIRequestGetGames requestScheduleField() {
            return this.requestScheduleField(true);
        }

        public APIRequestGetGames requestScheduleField(boolean value) {
            this.requestField("schedule", value);
            return this;
        }

        public APIRequestGetGames requestScreenplayByField() {
            return this.requestScreenplayByField(true);
        }

        public APIRequestGetGames requestScreenplayByField(boolean value) {
            this.requestField("screenplay_by", value);
            return this;
        }

        public APIRequestGetGames requestSeasonField() {
            return this.requestSeasonField(true);
        }

        public APIRequestGetGames requestSeasonField(boolean value) {
            this.requestField("season", value);
            return this;
        }

        public APIRequestGetGames requestSingleLineAddressField() {
            return this.requestSingleLineAddressField(true);
        }

        public APIRequestGetGames requestSingleLineAddressField(boolean value) {
            this.requestField("single_line_address", value);
            return this;
        }

        public APIRequestGetGames requestStarringField() {
            return this.requestStarringField(true);
        }

        public APIRequestGetGames requestStarringField(boolean value) {
            this.requestField("starring", value);
            return this;
        }

        public APIRequestGetGames requestStartInfoField() {
            return this.requestStartInfoField(true);
        }

        public APIRequestGetGames requestStartInfoField(boolean value) {
            this.requestField("start_info", value);
            return this;
        }

        public APIRequestGetGames requestStoreCodeField() {
            return this.requestStoreCodeField(true);
        }

        public APIRequestGetGames requestStoreCodeField(boolean value) {
            this.requestField("store_code", value);
            return this;
        }

        public APIRequestGetGames requestStoreLocationDescriptorField() {
            return this.requestStoreLocationDescriptorField(true);
        }

        public APIRequestGetGames requestStoreLocationDescriptorField(boolean value) {
            this.requestField("store_location_descriptor", value);
            return this;
        }

        public APIRequestGetGames requestStoreNumberField() {
            return this.requestStoreNumberField(true);
        }

        public APIRequestGetGames requestStoreNumberField(boolean value) {
            this.requestField("store_number", value);
            return this;
        }

        public APIRequestGetGames requestStudioField() {
            return this.requestStudioField(true);
        }

        public APIRequestGetGames requestStudioField(boolean value) {
            this.requestField("studio", value);
            return this;
        }

        public APIRequestGetGames requestSupportsInstantArticlesField() {
            return this.requestSupportsInstantArticlesField(true);
        }

        public APIRequestGetGames requestSupportsInstantArticlesField(boolean value) {
            this.requestField("supports_instant_articles", value);
            return this;
        }

        public APIRequestGetGames requestTalkingAboutCountField() {
            return this.requestTalkingAboutCountField(true);
        }

        public APIRequestGetGames requestTalkingAboutCountField(boolean value) {
            this.requestField("talking_about_count", value);
            return this;
        }

        public APIRequestGetGames requestUnreadMessageCountField() {
            return this.requestUnreadMessageCountField(true);
        }

        public APIRequestGetGames requestUnreadMessageCountField(boolean value) {
            this.requestField("unread_message_count", value);
            return this;
        }

        public APIRequestGetGames requestUnreadNotifCountField() {
            return this.requestUnreadNotifCountField(true);
        }

        public APIRequestGetGames requestUnreadNotifCountField(boolean value) {
            this.requestField("unread_notif_count", value);
            return this;
        }

        public APIRequestGetGames requestUnseenMessageCountField() {
            return this.requestUnseenMessageCountField(true);
        }

        public APIRequestGetGames requestUnseenMessageCountField(boolean value) {
            this.requestField("unseen_message_count", value);
            return this;
        }

        public APIRequestGetGames requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetGames requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGetGames requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetGames requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetGames requestVoipInfoField() {
            return this.requestVoipInfoField(true);
        }

        public APIRequestGetGames requestVoipInfoField(boolean value) {
            this.requestField("voip_info", value);
            return this;
        }

        public APIRequestGetGames requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetGames requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetGames requestWereHereCountField() {
            return this.requestWereHereCountField(true);
        }

        public APIRequestGetGames requestWereHereCountField(boolean value) {
            this.requestField("were_here_count", value);
            return this;
        }

        public APIRequestGetGames requestWhatsappNumberField() {
            return this.requestWhatsappNumberField(true);
        }

        public APIRequestGetGames requestWhatsappNumberField(boolean value) {
            this.requestField("whatsapp_number", value);
            return this;
        }

        public APIRequestGetGames requestWrittenByField() {
            return this.requestWrittenByField(true);
        }

        public APIRequestGetGames requestWrittenByField(boolean value) {
            this.requestField("written_by", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateGameTime
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"action"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateGameTime.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateGameTime(String nodeId, APIContext context) {
            super(context, nodeId, "/game_times", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateGameTime setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateGameTime setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateGameTime setAction(EnumAction action) {
            this.setParam("action", (Object)action);
            return this;
        }

        public APIRequestCreateGameTime setAction(String action) {
            this.setParam("action", action);
            return this;
        }

        public APIRequestCreateGameTime requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateGameTime requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGameTime requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateGameTime requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGameTime requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateGameTime requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateGameItem
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"action", "item_id", "drop_table_id", "ext_id", "quantity", "app_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateGameItem.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateGameItem(String nodeId, APIContext context) {
            super(context, nodeId, "/game_items", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateGameItem setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateGameItem setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateGameItem setAction(EnumAction action) {
            this.setParam("action", (Object)action);
            return this;
        }

        public APIRequestCreateGameItem setAction(String action) {
            this.setParam("action", action);
            return this;
        }

        public APIRequestCreateGameItem setItemId(Object itemId) {
            this.setParam("item_id", itemId);
            return this;
        }

        public APIRequestCreateGameItem setItemId(String itemId) {
            this.setParam("item_id", itemId);
            return this;
        }

        public APIRequestCreateGameItem setDropTableId(Object dropTableId) {
            this.setParam("drop_table_id", dropTableId);
            return this;
        }

        public APIRequestCreateGameItem setDropTableId(String dropTableId) {
            this.setParam("drop_table_id", dropTableId);
            return this;
        }

        public APIRequestCreateGameItem setExtId(String extId) {
            this.setParam("ext_id", extId);
            return this;
        }

        public APIRequestCreateGameItem setQuantity(Long quantity) {
            this.setParam("quantity", quantity);
            return this;
        }

        public APIRequestCreateGameItem setQuantity(String quantity) {
            this.setParam("quantity", quantity);
            return this;
        }

        public APIRequestCreateGameItem setAppId(Object appId) {
            this.setParam("app_id", appId);
            return this;
        }

        public APIRequestCreateGameItem setAppId(String appId) {
            this.setParam("app_id", appId);
            return this;
        }

        public APIRequestCreateGameItem requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateGameItem requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGameItem requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateGameItem requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGameItem requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateGameItem requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetFriends
    extends APIRequest<User> {
        APINodeList<User> lastResponse = null;
        public static final String[] PARAMS = new String[]{"uid"};
        public static final String[] FIELDS = new String[]{"about", "address", "admin_notes", "age_range", "bio", "birthday", "can_review_measurement_request", "context", "cover", "currency", "devices", "education", "email", "employee_number", "favorite_athletes", "favorite_teams", "first_name", "gender", "hometown", "id", "inspirational_people", "install_type", "installed", "interested_in", "is_famedeeplinkinguser", "is_shared_login", "is_verified", "labels", "languages", "last_name", "link", "local_news_megaphone_dismiss_status", "local_news_subscription_status", "locale", "location", "meeting_for", "middle_name", "name", "name_format", "payment_pricepoints", "political", "profile_pic", "public_key", "quotes", "relationship_status", "religion", "security_settings", "shared_login_upgrade_required_by", "short_name", "significant_other", "sports", "test_group", "third_party_id", "timezone", "token_for_business", "updated_time", "username", "verified", "video_upload_limits", "viewer_can_send_gift", "website", "work"};

        @Override
        public APINodeList<User> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<User> parseResponse(String response) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<User> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<User> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<User>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<User>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<User>>(){

                public APINodeList<User> apply(String result) {
                    try {
                        return APIRequestGetFriends.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetFriends(String nodeId, APIContext context) {
            super(context, nodeId, "/friends", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetFriends setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetFriends setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetFriends setUid(Long uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestGetFriends setUid(String uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestGetFriends requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetFriends requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFriends requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetFriends requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFriends requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetFriends requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetFriends requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetFriends requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetFriends requestAddressField() {
            return this.requestAddressField(true);
        }

        public APIRequestGetFriends requestAddressField(boolean value) {
            this.requestField("address", value);
            return this;
        }

        public APIRequestGetFriends requestAdminNotesField() {
            return this.requestAdminNotesField(true);
        }

        public APIRequestGetFriends requestAdminNotesField(boolean value) {
            this.requestField("admin_notes", value);
            return this;
        }

        public APIRequestGetFriends requestAgeRangeField() {
            return this.requestAgeRangeField(true);
        }

        public APIRequestGetFriends requestAgeRangeField(boolean value) {
            this.requestField("age_range", value);
            return this;
        }

        public APIRequestGetFriends requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetFriends requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetFriends requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetFriends requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetFriends requestCanReviewMeasurementRequestField() {
            return this.requestCanReviewMeasurementRequestField(true);
        }

        public APIRequestGetFriends requestCanReviewMeasurementRequestField(boolean value) {
            this.requestField("can_review_measurement_request", value);
            return this;
        }

        public APIRequestGetFriends requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetFriends requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetFriends requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetFriends requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetFriends requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetFriends requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetFriends requestDevicesField() {
            return this.requestDevicesField(true);
        }

        public APIRequestGetFriends requestDevicesField(boolean value) {
            this.requestField("devices", value);
            return this;
        }

        public APIRequestGetFriends requestEducationField() {
            return this.requestEducationField(true);
        }

        public APIRequestGetFriends requestEducationField(boolean value) {
            this.requestField("education", value);
            return this;
        }

        public APIRequestGetFriends requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGetFriends requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGetFriends requestEmployeeNumberField() {
            return this.requestEmployeeNumberField(true);
        }

        public APIRequestGetFriends requestEmployeeNumberField(boolean value) {
            this.requestField("employee_number", value);
            return this;
        }

        public APIRequestGetFriends requestFavoriteAthletesField() {
            return this.requestFavoriteAthletesField(true);
        }

        public APIRequestGetFriends requestFavoriteAthletesField(boolean value) {
            this.requestField("favorite_athletes", value);
            return this;
        }

        public APIRequestGetFriends requestFavoriteTeamsField() {
            return this.requestFavoriteTeamsField(true);
        }

        public APIRequestGetFriends requestFavoriteTeamsField(boolean value) {
            this.requestField("favorite_teams", value);
            return this;
        }

        public APIRequestGetFriends requestFirstNameField() {
            return this.requestFirstNameField(true);
        }

        public APIRequestGetFriends requestFirstNameField(boolean value) {
            this.requestField("first_name", value);
            return this;
        }

        public APIRequestGetFriends requestGenderField() {
            return this.requestGenderField(true);
        }

        public APIRequestGetFriends requestGenderField(boolean value) {
            this.requestField("gender", value);
            return this;
        }

        public APIRequestGetFriends requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetFriends requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetFriends requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetFriends requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetFriends requestInspirationalPeopleField() {
            return this.requestInspirationalPeopleField(true);
        }

        public APIRequestGetFriends requestInspirationalPeopleField(boolean value) {
            this.requestField("inspirational_people", value);
            return this;
        }

        public APIRequestGetFriends requestInstallTypeField() {
            return this.requestInstallTypeField(true);
        }

        public APIRequestGetFriends requestInstallTypeField(boolean value) {
            this.requestField("install_type", value);
            return this;
        }

        public APIRequestGetFriends requestInstalledField() {
            return this.requestInstalledField(true);
        }

        public APIRequestGetFriends requestInstalledField(boolean value) {
            this.requestField("installed", value);
            return this;
        }

        public APIRequestGetFriends requestInterestedInField() {
            return this.requestInterestedInField(true);
        }

        public APIRequestGetFriends requestInterestedInField(boolean value) {
            this.requestField("interested_in", value);
            return this;
        }

        public APIRequestGetFriends requestIsFamedeeplinkinguserField() {
            return this.requestIsFamedeeplinkinguserField(true);
        }

        public APIRequestGetFriends requestIsFamedeeplinkinguserField(boolean value) {
            this.requestField("is_famedeeplinkinguser", value);
            return this;
        }

        public APIRequestGetFriends requestIsSharedLoginField() {
            return this.requestIsSharedLoginField(true);
        }

        public APIRequestGetFriends requestIsSharedLoginField(boolean value) {
            this.requestField("is_shared_login", value);
            return this;
        }

        public APIRequestGetFriends requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetFriends requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetFriends requestLabelsField() {
            return this.requestLabelsField(true);
        }

        public APIRequestGetFriends requestLabelsField(boolean value) {
            this.requestField("labels", value);
            return this;
        }

        public APIRequestGetFriends requestLanguagesField() {
            return this.requestLanguagesField(true);
        }

        public APIRequestGetFriends requestLanguagesField(boolean value) {
            this.requestField("languages", value);
            return this;
        }

        public APIRequestGetFriends requestLastNameField() {
            return this.requestLastNameField(true);
        }

        public APIRequestGetFriends requestLastNameField(boolean value) {
            this.requestField("last_name", value);
            return this;
        }

        public APIRequestGetFriends requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetFriends requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetFriends requestLocalNewsMegaphoneDismissStatusField() {
            return this.requestLocalNewsMegaphoneDismissStatusField(true);
        }

        public APIRequestGetFriends requestLocalNewsMegaphoneDismissStatusField(boolean value) {
            this.requestField("local_news_megaphone_dismiss_status", value);
            return this;
        }

        public APIRequestGetFriends requestLocalNewsSubscriptionStatusField() {
            return this.requestLocalNewsSubscriptionStatusField(true);
        }

        public APIRequestGetFriends requestLocalNewsSubscriptionStatusField(boolean value) {
            this.requestField("local_news_subscription_status", value);
            return this;
        }

        public APIRequestGetFriends requestLocaleField() {
            return this.requestLocaleField(true);
        }

        public APIRequestGetFriends requestLocaleField(boolean value) {
            this.requestField("locale", value);
            return this;
        }

        public APIRequestGetFriends requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetFriends requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetFriends requestMeetingForField() {
            return this.requestMeetingForField(true);
        }

        public APIRequestGetFriends requestMeetingForField(boolean value) {
            this.requestField("meeting_for", value);
            return this;
        }

        public APIRequestGetFriends requestMiddleNameField() {
            return this.requestMiddleNameField(true);
        }

        public APIRequestGetFriends requestMiddleNameField(boolean value) {
            this.requestField("middle_name", value);
            return this;
        }

        public APIRequestGetFriends requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetFriends requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetFriends requestNameFormatField() {
            return this.requestNameFormatField(true);
        }

        public APIRequestGetFriends requestNameFormatField(boolean value) {
            this.requestField("name_format", value);
            return this;
        }

        public APIRequestGetFriends requestPaymentPricepointsField() {
            return this.requestPaymentPricepointsField(true);
        }

        public APIRequestGetFriends requestPaymentPricepointsField(boolean value) {
            this.requestField("payment_pricepoints", value);
            return this;
        }

        public APIRequestGetFriends requestPoliticalField() {
            return this.requestPoliticalField(true);
        }

        public APIRequestGetFriends requestPoliticalField(boolean value) {
            this.requestField("political", value);
            return this;
        }

        public APIRequestGetFriends requestProfilePicField() {
            return this.requestProfilePicField(true);
        }

        public APIRequestGetFriends requestProfilePicField(boolean value) {
            this.requestField("profile_pic", value);
            return this;
        }

        public APIRequestGetFriends requestPublicKeyField() {
            return this.requestPublicKeyField(true);
        }

        public APIRequestGetFriends requestPublicKeyField(boolean value) {
            this.requestField("public_key", value);
            return this;
        }

        public APIRequestGetFriends requestQuotesField() {
            return this.requestQuotesField(true);
        }

        public APIRequestGetFriends requestQuotesField(boolean value) {
            this.requestField("quotes", value);
            return this;
        }

        public APIRequestGetFriends requestRelationshipStatusField() {
            return this.requestRelationshipStatusField(true);
        }

        public APIRequestGetFriends requestRelationshipStatusField(boolean value) {
            this.requestField("relationship_status", value);
            return this;
        }

        public APIRequestGetFriends requestReligionField() {
            return this.requestReligionField(true);
        }

        public APIRequestGetFriends requestReligionField(boolean value) {
            this.requestField("religion", value);
            return this;
        }

        public APIRequestGetFriends requestSecuritySettingsField() {
            return this.requestSecuritySettingsField(true);
        }

        public APIRequestGetFriends requestSecuritySettingsField(boolean value) {
            this.requestField("security_settings", value);
            return this;
        }

        public APIRequestGetFriends requestSharedLoginUpgradeRequiredByField() {
            return this.requestSharedLoginUpgradeRequiredByField(true);
        }

        public APIRequestGetFriends requestSharedLoginUpgradeRequiredByField(boolean value) {
            this.requestField("shared_login_upgrade_required_by", value);
            return this;
        }

        public APIRequestGetFriends requestShortNameField() {
            return this.requestShortNameField(true);
        }

        public APIRequestGetFriends requestShortNameField(boolean value) {
            this.requestField("short_name", value);
            return this;
        }

        public APIRequestGetFriends requestSignificantOtherField() {
            return this.requestSignificantOtherField(true);
        }

        public APIRequestGetFriends requestSignificantOtherField(boolean value) {
            this.requestField("significant_other", value);
            return this;
        }

        public APIRequestGetFriends requestSportsField() {
            return this.requestSportsField(true);
        }

        public APIRequestGetFriends requestSportsField(boolean value) {
            this.requestField("sports", value);
            return this;
        }

        public APIRequestGetFriends requestTestGroupField() {
            return this.requestTestGroupField(true);
        }

        public APIRequestGetFriends requestTestGroupField(boolean value) {
            this.requestField("test_group", value);
            return this;
        }

        public APIRequestGetFriends requestThirdPartyIdField() {
            return this.requestThirdPartyIdField(true);
        }

        public APIRequestGetFriends requestThirdPartyIdField(boolean value) {
            this.requestField("third_party_id", value);
            return this;
        }

        public APIRequestGetFriends requestTimezoneField() {
            return this.requestTimezoneField(true);
        }

        public APIRequestGetFriends requestTimezoneField(boolean value) {
            this.requestField("timezone", value);
            return this;
        }

        public APIRequestGetFriends requestTokenForBusinessField() {
            return this.requestTokenForBusinessField(true);
        }

        public APIRequestGetFriends requestTokenForBusinessField(boolean value) {
            this.requestField("token_for_business", value);
            return this;
        }

        public APIRequestGetFriends requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetFriends requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetFriends requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetFriends requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGetFriends requestVerifiedField() {
            return this.requestVerifiedField(true);
        }

        public APIRequestGetFriends requestVerifiedField(boolean value) {
            this.requestField("verified", value);
            return this;
        }

        public APIRequestGetFriends requestVideoUploadLimitsField() {
            return this.requestVideoUploadLimitsField(true);
        }

        public APIRequestGetFriends requestVideoUploadLimitsField(boolean value) {
            this.requestField("video_upload_limits", value);
            return this;
        }

        public APIRequestGetFriends requestViewerCanSendGiftField() {
            return this.requestViewerCanSendGiftField(true);
        }

        public APIRequestGetFriends requestViewerCanSendGiftField(boolean value) {
            this.requestField("viewer_can_send_gift", value);
            return this;
        }

        public APIRequestGetFriends requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetFriends requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetFriends requestWorkField() {
            return this.requestWorkField(true);
        }

        public APIRequestGetFriends requestWorkField(boolean value) {
            this.requestField("work", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateFriendList
    extends APIRequest<FriendList> {
        FriendList lastResponse = null;
        public static final String[] PARAMS = new String[]{"name", "uid", "list_type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public FriendList getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public FriendList parseResponse(String response) throws APIException {
            return FriendList.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public FriendList execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public FriendList execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<FriendList> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<FriendList> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, FriendList>(){

                public FriendList apply(String result) {
                    try {
                        return APIRequestCreateFriendList.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateFriendList(String nodeId, APIContext context) {
            super(context, nodeId, "/friendlists", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateFriendList setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateFriendList setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateFriendList setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateFriendList setUid(Long uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestCreateFriendList setUid(String uid) {
            this.setParam("uid", uid);
            return this;
        }

        public APIRequestCreateFriendList setListType(FriendList.EnumListType listType) {
            this.setParam("list_type", (Object)listType);
            return this;
        }

        public APIRequestCreateFriendList setListType(String listType) {
            this.setParam("list_type", listType);
            return this;
        }

        public APIRequestCreateFriendList requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateFriendList requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateFriendList requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateFriendList requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateFriendList requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateFriendList requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetFriendLists
    extends APIRequest<FriendList> {
        APINodeList<FriendList> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "list_type", "name", "owner"};

        @Override
        public APINodeList<FriendList> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<FriendList> parseResponse(String response) throws APIException {
            return FriendList.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<FriendList> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<FriendList> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<FriendList>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<FriendList>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<FriendList>>(){

                public APINodeList<FriendList> apply(String result) {
                    try {
                        return APIRequestGetFriendLists.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetFriendLists(String nodeId, APIContext context) {
            super(context, nodeId, "/friendlists", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetFriendLists setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetFriendLists setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetFriendLists requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetFriendLists requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFriendLists requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetFriendLists requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFriendLists requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetFriendLists requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetFriendLists requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetFriendLists requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetFriendLists requestListTypeField() {
            return this.requestListTypeField(true);
        }

        public APIRequestGetFriendLists requestListTypeField(boolean value) {
            this.requestField("list_type", value);
            return this;
        }

        public APIRequestGetFriendLists requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetFriendLists requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetFriendLists requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetFriendLists requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateFeed
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"picture", "name", "link", "caption", "description", "quote", "source", "properties", "object_attachment", "height", "width", "expanded_height", "expanded_width", "referral_id", "thumbnail", "image_crops", "call_to_action", "time_since_original_post", "client_mutation_id", "privacy", "composer_session_id", "content_attachment", "actions", "targeting", "feed_targeting", "ref", "tags", "place", "is_explicit_location", "og_action_type_id", "og_object_id", "og_phrase", "og_icon_id", "og_set_profile_badge", "og_suggestion_mechanism", "og_hide_object_attachment", "backdated_time", "backdated_time_granularity", "published", "scheduled_publish_time", "unpublished_content_type", "application_id", "proxied_app_id", "ios_bundle_id", "android_key_hash", "user_selected_tags", "nectar_module", "manual_privacy", "audience_exp", "coordinates", "is_explicit_share", "is_photo_container", "implicit_with_tags", "child_attachments", "suggested_place_id", "attach_place_suggestion", "viewer_coordinates", "album_id", "multi_share_optimized", "multi_share_end_card", "title", "attached_media", "home_checkin_city_id", "text_only_place", "connection_class", "associated_id", "posting_to_redspace", "place_attachment_setting", "checkin_entry_point", "is_backout_draft", "sponsor_id", "direct_share_status", "sponsor_relationship", "referenceable_image_ids", "prompt_id", "prompt_tracking_string", "post_surfaces_blacklist", "tracking_info", "text_format_preset_id", "cta_link", "cta_type", "place_list_data", "formatting", "target_surface", "adaptive_type", "animated_effect_id", "asked_fun_fact_prompt_id", "asset3d_id", "composer_entry_picker", "composer_entry_point", "composer_entry_time", "composer_session_events_log", "composer_source_surface", "composer_type", "fun_fact_prompt_id", "fun_fact_toastee_id", "is_group_linking_post", "has_nickname", "holiday_card", "instant_game_entry_point_data", "is_boost_intended", "location_source_id", "message", "offer_like_post_id", "page_recommendation", "place_list", "publish_event_id", "react_mode_metadata", "sales_promo_id", "text_format_metadata", "throwback_camera_roll_media", "video_start_time_ms"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateFeed.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateFeed(String nodeId, APIContext context) {
            super(context, nodeId, "/feed", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateFeed setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateFeed setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateFeed setPicture(String picture) {
            this.setParam("picture", picture);
            return this;
        }

        public APIRequestCreateFeed setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateFeed setLink(String link) {
            this.setParam("link", link);
            return this;
        }

        public APIRequestCreateFeed setCaption(String caption) {
            this.setParam("caption", caption);
            return this;
        }

        public APIRequestCreateFeed setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateFeed setQuote(String quote) {
            this.setParam("quote", quote);
            return this;
        }

        public APIRequestCreateFeed setSource(String source) {
            this.setParam("source", source);
            return this;
        }

        public APIRequestCreateFeed setProperties(Object properties) {
            this.setParam("properties", properties);
            return this;
        }

        public APIRequestCreateFeed setProperties(String properties) {
            this.setParam("properties", properties);
            return this;
        }

        public APIRequestCreateFeed setObjectAttachment(String objectAttachment) {
            this.setParam("object_attachment", objectAttachment);
            return this;
        }

        public APIRequestCreateFeed setHeight(Long height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestCreateFeed setHeight(String height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestCreateFeed setWidth(Long width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestCreateFeed setWidth(String width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestCreateFeed setExpandedHeight(Long expandedHeight) {
            this.setParam("expanded_height", expandedHeight);
            return this;
        }

        public APIRequestCreateFeed setExpandedHeight(String expandedHeight) {
            this.setParam("expanded_height", expandedHeight);
            return this;
        }

        public APIRequestCreateFeed setExpandedWidth(Long expandedWidth) {
            this.setParam("expanded_width", expandedWidth);
            return this;
        }

        public APIRequestCreateFeed setExpandedWidth(String expandedWidth) {
            this.setParam("expanded_width", expandedWidth);
            return this;
        }

        public APIRequestCreateFeed setReferralId(String referralId) {
            this.setParam("referral_id", referralId);
            return this;
        }

        public APIRequestCreateFeed setThumbnail(File thumbnail) {
            this.setParam("thumbnail", thumbnail);
            return this;
        }

        public APIRequestCreateFeed setThumbnail(String thumbnail) {
            this.setParam("thumbnail", thumbnail);
            return this;
        }

        public APIRequestCreateFeed setImageCrops(Map<String, String> imageCrops) {
            this.setParam("image_crops", imageCrops);
            return this;
        }

        public APIRequestCreateFeed setImageCrops(String imageCrops) {
            this.setParam("image_crops", imageCrops);
            return this;
        }

        public APIRequestCreateFeed setCallToAction(Object callToAction) {
            this.setParam("call_to_action", callToAction);
            return this;
        }

        public APIRequestCreateFeed setCallToAction(String callToAction) {
            this.setParam("call_to_action", callToAction);
            return this;
        }

        public APIRequestCreateFeed setTimeSinceOriginalPost(Long timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestCreateFeed setTimeSinceOriginalPost(String timeSinceOriginalPost) {
            this.setParam("time_since_original_post", timeSinceOriginalPost);
            return this;
        }

        public APIRequestCreateFeed setClientMutationId(String clientMutationId) {
            this.setParam("client_mutation_id", clientMutationId);
            return this;
        }

        public APIRequestCreateFeed setPrivacy(Object privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateFeed setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateFeed setComposerSessionId(String composerSessionId) {
            this.setParam("composer_session_id", composerSessionId);
            return this;
        }

        public APIRequestCreateFeed setContentAttachment(String contentAttachment) {
            this.setParam("content_attachment", contentAttachment);
            return this;
        }

        public APIRequestCreateFeed setActions(Object actions) {
            this.setParam("actions", actions);
            return this;
        }

        public APIRequestCreateFeed setActions(String actions) {
            this.setParam("actions", actions);
            return this;
        }

        public APIRequestCreateFeed setTargeting(Object targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreateFeed setTargeting(String targeting) {
            this.setParam("targeting", targeting);
            return this;
        }

        public APIRequestCreateFeed setFeedTargeting(Object feedTargeting) {
            this.setParam("feed_targeting", feedTargeting);
            return this;
        }

        public APIRequestCreateFeed setFeedTargeting(String feedTargeting) {
            this.setParam("feed_targeting", feedTargeting);
            return this;
        }

        public APIRequestCreateFeed setRef(List<String> ref) {
            this.setParam("ref", ref);
            return this;
        }

        public APIRequestCreateFeed setRef(String ref) {
            this.setParam("ref", ref);
            return this;
        }

        public APIRequestCreateFeed setTags(List<Long> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateFeed setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateFeed setPlace(Object place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreateFeed setPlace(String place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreateFeed setIsExplicitLocation(Boolean isExplicitLocation) {
            this.setParam("is_explicit_location", isExplicitLocation);
            return this;
        }

        public APIRequestCreateFeed setIsExplicitLocation(String isExplicitLocation) {
            this.setParam("is_explicit_location", isExplicitLocation);
            return this;
        }

        public APIRequestCreateFeed setOgActionTypeId(String ogActionTypeId) {
            this.setParam("og_action_type_id", ogActionTypeId);
            return this;
        }

        public APIRequestCreateFeed setOgObjectId(String ogObjectId) {
            this.setParam("og_object_id", ogObjectId);
            return this;
        }

        public APIRequestCreateFeed setOgPhrase(String ogPhrase) {
            this.setParam("og_phrase", ogPhrase);
            return this;
        }

        public APIRequestCreateFeed setOgIconId(String ogIconId) {
            this.setParam("og_icon_id", ogIconId);
            return this;
        }

        public APIRequestCreateFeed setOgSetProfileBadge(Boolean ogSetProfileBadge) {
            this.setParam("og_set_profile_badge", ogSetProfileBadge);
            return this;
        }

        public APIRequestCreateFeed setOgSetProfileBadge(String ogSetProfileBadge) {
            this.setParam("og_set_profile_badge", ogSetProfileBadge);
            return this;
        }

        public APIRequestCreateFeed setOgSuggestionMechanism(String ogSuggestionMechanism) {
            this.setParam("og_suggestion_mechanism", ogSuggestionMechanism);
            return this;
        }

        public APIRequestCreateFeed setOgHideObjectAttachment(Boolean ogHideObjectAttachment) {
            this.setParam("og_hide_object_attachment", ogHideObjectAttachment);
            return this;
        }

        public APIRequestCreateFeed setOgHideObjectAttachment(String ogHideObjectAttachment) {
            this.setParam("og_hide_object_attachment", ogHideObjectAttachment);
            return this;
        }

        public APIRequestCreateFeed setBackdatedTime(String backdatedTime) {
            this.setParam("backdated_time", backdatedTime);
            return this;
        }

        public APIRequestCreateFeed setBackdatedTimeGranularity(EnumBackdatedTimeGranularity backdatedTimeGranularity) {
            this.setParam("backdated_time_granularity", (Object)backdatedTimeGranularity);
            return this;
        }

        public APIRequestCreateFeed setBackdatedTimeGranularity(String backdatedTimeGranularity) {
            this.setParam("backdated_time_granularity", backdatedTimeGranularity);
            return this;
        }

        public APIRequestCreateFeed setPublished(Boolean published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreateFeed setPublished(String published) {
            this.setParam("published", published);
            return this;
        }

        public APIRequestCreateFeed setScheduledPublishTime(String scheduledPublishTime) {
            this.setParam("scheduled_publish_time", scheduledPublishTime);
            return this;
        }

        public APIRequestCreateFeed setUnpublishedContentType(EnumUnpublishedContentType unpublishedContentType) {
            this.setParam("unpublished_content_type", (Object)unpublishedContentType);
            return this;
        }

        public APIRequestCreateFeed setUnpublishedContentType(String unpublishedContentType) {
            this.setParam("unpublished_content_type", unpublishedContentType);
            return this;
        }

        public APIRequestCreateFeed setApplicationId(String applicationId) {
            this.setParam("application_id", applicationId);
            return this;
        }

        public APIRequestCreateFeed setProxiedAppId(String proxiedAppId) {
            this.setParam("proxied_app_id", proxiedAppId);
            return this;
        }

        public APIRequestCreateFeed setIosBundleId(String iosBundleId) {
            this.setParam("ios_bundle_id", iosBundleId);
            return this;
        }

        public APIRequestCreateFeed setAndroidKeyHash(String androidKeyHash) {
            this.setParam("android_key_hash", androidKeyHash);
            return this;
        }

        public APIRequestCreateFeed setUserSelectedTags(Boolean userSelectedTags) {
            this.setParam("user_selected_tags", userSelectedTags);
            return this;
        }

        public APIRequestCreateFeed setUserSelectedTags(String userSelectedTags) {
            this.setParam("user_selected_tags", userSelectedTags);
            return this;
        }

        public APIRequestCreateFeed setNectarModule(String nectarModule) {
            this.setParam("nectar_module", nectarModule);
            return this;
        }

        public APIRequestCreateFeed setManualPrivacy(Boolean manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreateFeed setManualPrivacy(String manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreateFeed setAudienceExp(Boolean audienceExp) {
            this.setParam("audience_exp", audienceExp);
            return this;
        }

        public APIRequestCreateFeed setAudienceExp(String audienceExp) {
            this.setParam("audience_exp", audienceExp);
            return this;
        }

        public APIRequestCreateFeed setCoordinates(Object coordinates) {
            this.setParam("coordinates", coordinates);
            return this;
        }

        public APIRequestCreateFeed setCoordinates(String coordinates) {
            this.setParam("coordinates", coordinates);
            return this;
        }

        public APIRequestCreateFeed setIsExplicitShare(Boolean isExplicitShare) {
            this.setParam("is_explicit_share", isExplicitShare);
            return this;
        }

        public APIRequestCreateFeed setIsExplicitShare(String isExplicitShare) {
            this.setParam("is_explicit_share", isExplicitShare);
            return this;
        }

        public APIRequestCreateFeed setIsPhotoContainer(Boolean isPhotoContainer) {
            this.setParam("is_photo_container", isPhotoContainer);
            return this;
        }

        public APIRequestCreateFeed setIsPhotoContainer(String isPhotoContainer) {
            this.setParam("is_photo_container", isPhotoContainer);
            return this;
        }

        public APIRequestCreateFeed setImplicitWithTags(List<Long> implicitWithTags) {
            this.setParam("implicit_with_tags", implicitWithTags);
            return this;
        }

        public APIRequestCreateFeed setImplicitWithTags(String implicitWithTags) {
            this.setParam("implicit_with_tags", implicitWithTags);
            return this;
        }

        public APIRequestCreateFeed setChildAttachments(List<Object> childAttachments) {
            this.setParam("child_attachments", childAttachments);
            return this;
        }

        public APIRequestCreateFeed setChildAttachments(String childAttachments) {
            this.setParam("child_attachments", childAttachments);
            return this;
        }

        public APIRequestCreateFeed setSuggestedPlaceId(Object suggestedPlaceId) {
            this.setParam("suggested_place_id", suggestedPlaceId);
            return this;
        }

        public APIRequestCreateFeed setSuggestedPlaceId(String suggestedPlaceId) {
            this.setParam("suggested_place_id", suggestedPlaceId);
            return this;
        }

        public APIRequestCreateFeed setAttachPlaceSuggestion(Boolean attachPlaceSuggestion) {
            this.setParam("attach_place_suggestion", attachPlaceSuggestion);
            return this;
        }

        public APIRequestCreateFeed setAttachPlaceSuggestion(String attachPlaceSuggestion) {
            this.setParam("attach_place_suggestion", attachPlaceSuggestion);
            return this;
        }

        public APIRequestCreateFeed setViewerCoordinates(Object viewerCoordinates) {
            this.setParam("viewer_coordinates", viewerCoordinates);
            return this;
        }

        public APIRequestCreateFeed setViewerCoordinates(String viewerCoordinates) {
            this.setParam("viewer_coordinates", viewerCoordinates);
            return this;
        }

        public APIRequestCreateFeed setAlbumId(String albumId) {
            this.setParam("album_id", albumId);
            return this;
        }

        public APIRequestCreateFeed setMultiShareOptimized(Boolean multiShareOptimized) {
            this.setParam("multi_share_optimized", multiShareOptimized);
            return this;
        }

        public APIRequestCreateFeed setMultiShareOptimized(String multiShareOptimized) {
            this.setParam("multi_share_optimized", multiShareOptimized);
            return this;
        }

        public APIRequestCreateFeed setMultiShareEndCard(Boolean multiShareEndCard) {
            this.setParam("multi_share_end_card", multiShareEndCard);
            return this;
        }

        public APIRequestCreateFeed setMultiShareEndCard(String multiShareEndCard) {
            this.setParam("multi_share_end_card", multiShareEndCard);
            return this;
        }

        public APIRequestCreateFeed setTitle(String title) {
            this.setParam("title", title);
            return this;
        }

        public APIRequestCreateFeed setAttachedMedia(List<Object> attachedMedia) {
            this.setParam("attached_media", attachedMedia);
            return this;
        }

        public APIRequestCreateFeed setAttachedMedia(String attachedMedia) {
            this.setParam("attached_media", attachedMedia);
            return this;
        }

        public APIRequestCreateFeed setHomeCheckinCityId(Object homeCheckinCityId) {
            this.setParam("home_checkin_city_id", homeCheckinCityId);
            return this;
        }

        public APIRequestCreateFeed setHomeCheckinCityId(String homeCheckinCityId) {
            this.setParam("home_checkin_city_id", homeCheckinCityId);
            return this;
        }

        public APIRequestCreateFeed setTextOnlyPlace(String textOnlyPlace) {
            this.setParam("text_only_place", textOnlyPlace);
            return this;
        }

        public APIRequestCreateFeed setConnectionClass(String connectionClass) {
            this.setParam("connection_class", connectionClass);
            return this;
        }

        public APIRequestCreateFeed setAssociatedId(String associatedId) {
            this.setParam("associated_id", associatedId);
            return this;
        }

        public APIRequestCreateFeed setPostingToRedspace(EnumPostingToRedspace postingToRedspace) {
            this.setParam("posting_to_redspace", (Object)postingToRedspace);
            return this;
        }

        public APIRequestCreateFeed setPostingToRedspace(String postingToRedspace) {
            this.setParam("posting_to_redspace", postingToRedspace);
            return this;
        }

        public APIRequestCreateFeed setPlaceAttachmentSetting(EnumPlaceAttachmentSetting placeAttachmentSetting) {
            this.setParam("place_attachment_setting", (Object)placeAttachmentSetting);
            return this;
        }

        public APIRequestCreateFeed setPlaceAttachmentSetting(String placeAttachmentSetting) {
            this.setParam("place_attachment_setting", placeAttachmentSetting);
            return this;
        }

        public APIRequestCreateFeed setCheckinEntryPoint(EnumCheckinEntryPoint checkinEntryPoint) {
            this.setParam("checkin_entry_point", (Object)checkinEntryPoint);
            return this;
        }

        public APIRequestCreateFeed setCheckinEntryPoint(String checkinEntryPoint) {
            this.setParam("checkin_entry_point", checkinEntryPoint);
            return this;
        }

        public APIRequestCreateFeed setIsBackoutDraft(Boolean isBackoutDraft) {
            this.setParam("is_backout_draft", isBackoutDraft);
            return this;
        }

        public APIRequestCreateFeed setIsBackoutDraft(String isBackoutDraft) {
            this.setParam("is_backout_draft", isBackoutDraft);
            return this;
        }

        public APIRequestCreateFeed setSponsorId(String sponsorId) {
            this.setParam("sponsor_id", sponsorId);
            return this;
        }

        public APIRequestCreateFeed setDirectShareStatus(Long directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestCreateFeed setDirectShareStatus(String directShareStatus) {
            this.setParam("direct_share_status", directShareStatus);
            return this;
        }

        public APIRequestCreateFeed setSponsorRelationship(Long sponsorRelationship) {
            this.setParam("sponsor_relationship", sponsorRelationship);
            return this;
        }

        public APIRequestCreateFeed setSponsorRelationship(String sponsorRelationship) {
            this.setParam("sponsor_relationship", sponsorRelationship);
            return this;
        }

        public APIRequestCreateFeed setReferenceableImageIds(List<String> referenceableImageIds) {
            this.setParam("referenceable_image_ids", referenceableImageIds);
            return this;
        }

        public APIRequestCreateFeed setReferenceableImageIds(String referenceableImageIds) {
            this.setParam("referenceable_image_ids", referenceableImageIds);
            return this;
        }

        public APIRequestCreateFeed setPromptId(String promptId) {
            this.setParam("prompt_id", promptId);
            return this;
        }

        public APIRequestCreateFeed setPromptTrackingString(String promptTrackingString) {
            this.setParam("prompt_tracking_string", promptTrackingString);
            return this;
        }

        public APIRequestCreateFeed setPostSurfacesBlacklist(List<EnumPostSurfacesBlacklist> postSurfacesBlacklist) {
            this.setParam("post_surfaces_blacklist", postSurfacesBlacklist);
            return this;
        }

        public APIRequestCreateFeed setPostSurfacesBlacklist(String postSurfacesBlacklist) {
            this.setParam("post_surfaces_blacklist", postSurfacesBlacklist);
            return this;
        }

        public APIRequestCreateFeed setTrackingInfo(String trackingInfo) {
            this.setParam("tracking_info", trackingInfo);
            return this;
        }

        public APIRequestCreateFeed setTextFormatPresetId(String textFormatPresetId) {
            this.setParam("text_format_preset_id", textFormatPresetId);
            return this;
        }

        public APIRequestCreateFeed setCtaLink(String ctaLink) {
            this.setParam("cta_link", ctaLink);
            return this;
        }

        public APIRequestCreateFeed setCtaType(String ctaType) {
            this.setParam("cta_type", ctaType);
            return this;
        }

        public APIRequestCreateFeed setPlaceListData(Object placeListData) {
            this.setParam("place_list_data", placeListData);
            return this;
        }

        public APIRequestCreateFeed setPlaceListData(String placeListData) {
            this.setParam("place_list_data", placeListData);
            return this;
        }

        public APIRequestCreateFeed setFormatting(EnumFormatting formatting) {
            this.setParam("formatting", (Object)formatting);
            return this;
        }

        public APIRequestCreateFeed setFormatting(String formatting) {
            this.setParam("formatting", formatting);
            return this;
        }

        public APIRequestCreateFeed setTargetSurface(EnumTargetSurface targetSurface) {
            this.setParam("target_surface", (Object)targetSurface);
            return this;
        }

        public APIRequestCreateFeed setTargetSurface(String targetSurface) {
            this.setParam("target_surface", targetSurface);
            return this;
        }

        public APIRequestCreateFeed setAdaptiveType(String adaptiveType) {
            this.setParam("adaptive_type", adaptiveType);
            return this;
        }

        public APIRequestCreateFeed setAnimatedEffectId(Long animatedEffectId) {
            this.setParam("animated_effect_id", animatedEffectId);
            return this;
        }

        public APIRequestCreateFeed setAnimatedEffectId(String animatedEffectId) {
            this.setParam("animated_effect_id", animatedEffectId);
            return this;
        }

        public APIRequestCreateFeed setAskedFunFactPromptId(Long askedFunFactPromptId) {
            this.setParam("asked_fun_fact_prompt_id", askedFunFactPromptId);
            return this;
        }

        public APIRequestCreateFeed setAskedFunFactPromptId(String askedFunFactPromptId) {
            this.setParam("asked_fun_fact_prompt_id", askedFunFactPromptId);
            return this;
        }

        public APIRequestCreateFeed setAsset3dId(Long asset3dId) {
            this.setParam("asset3d_id", asset3dId);
            return this;
        }

        public APIRequestCreateFeed setAsset3dId(String asset3dId) {
            this.setParam("asset3d_id", asset3dId);
            return this;
        }

        public APIRequestCreateFeed setComposerEntryPicker(String composerEntryPicker) {
            this.setParam("composer_entry_picker", composerEntryPicker);
            return this;
        }

        public APIRequestCreateFeed setComposerEntryPoint(String composerEntryPoint) {
            this.setParam("composer_entry_point", composerEntryPoint);
            return this;
        }

        public APIRequestCreateFeed setComposerEntryTime(Long composerEntryTime) {
            this.setParam("composer_entry_time", composerEntryTime);
            return this;
        }

        public APIRequestCreateFeed setComposerEntryTime(String composerEntryTime) {
            this.setParam("composer_entry_time", composerEntryTime);
            return this;
        }

        public APIRequestCreateFeed setComposerSessionEventsLog(String composerSessionEventsLog) {
            this.setParam("composer_session_events_log", composerSessionEventsLog);
            return this;
        }

        public APIRequestCreateFeed setComposerSourceSurface(String composerSourceSurface) {
            this.setParam("composer_source_surface", composerSourceSurface);
            return this;
        }

        public APIRequestCreateFeed setComposerType(String composerType) {
            this.setParam("composer_type", composerType);
            return this;
        }

        public APIRequestCreateFeed setFunFactPromptId(String funFactPromptId) {
            this.setParam("fun_fact_prompt_id", funFactPromptId);
            return this;
        }

        public APIRequestCreateFeed setFunFactToasteeId(Long funFactToasteeId) {
            this.setParam("fun_fact_toastee_id", funFactToasteeId);
            return this;
        }

        public APIRequestCreateFeed setFunFactToasteeId(String funFactToasteeId) {
            this.setParam("fun_fact_toastee_id", funFactToasteeId);
            return this;
        }

        public APIRequestCreateFeed setIsGroupLinkingPost(Boolean isGroupLinkingPost) {
            this.setParam("is_group_linking_post", isGroupLinkingPost);
            return this;
        }

        public APIRequestCreateFeed setIsGroupLinkingPost(String isGroupLinkingPost) {
            this.setParam("is_group_linking_post", isGroupLinkingPost);
            return this;
        }

        public APIRequestCreateFeed setHasNickname(Boolean hasNickname) {
            this.setParam("has_nickname", hasNickname);
            return this;
        }

        public APIRequestCreateFeed setHasNickname(String hasNickname) {
            this.setParam("has_nickname", hasNickname);
            return this;
        }

        public APIRequestCreateFeed setHolidayCard(String holidayCard) {
            this.setParam("holiday_card", holidayCard);
            return this;
        }

        public APIRequestCreateFeed setInstantGameEntryPointData(String instantGameEntryPointData) {
            this.setParam("instant_game_entry_point_data", instantGameEntryPointData);
            return this;
        }

        public APIRequestCreateFeed setIsBoostIntended(Boolean isBoostIntended) {
            this.setParam("is_boost_intended", isBoostIntended);
            return this;
        }

        public APIRequestCreateFeed setIsBoostIntended(String isBoostIntended) {
            this.setParam("is_boost_intended", isBoostIntended);
            return this;
        }

        public APIRequestCreateFeed setLocationSourceId(String locationSourceId) {
            this.setParam("location_source_id", locationSourceId);
            return this;
        }

        public APIRequestCreateFeed setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateFeed setOfferLikePostId(String offerLikePostId) {
            this.setParam("offer_like_post_id", offerLikePostId);
            return this;
        }

        public APIRequestCreateFeed setPageRecommendation(String pageRecommendation) {
            this.setParam("page_recommendation", pageRecommendation);
            return this;
        }

        public APIRequestCreateFeed setPlaceList(String placeList) {
            this.setParam("place_list", placeList);
            return this;
        }

        public APIRequestCreateFeed setPublishEventId(Long publishEventId) {
            this.setParam("publish_event_id", publishEventId);
            return this;
        }

        public APIRequestCreateFeed setPublishEventId(String publishEventId) {
            this.setParam("publish_event_id", publishEventId);
            return this;
        }

        public APIRequestCreateFeed setReactModeMetadata(String reactModeMetadata) {
            this.setParam("react_mode_metadata", reactModeMetadata);
            return this;
        }

        public APIRequestCreateFeed setSalesPromoId(Long salesPromoId) {
            this.setParam("sales_promo_id", salesPromoId);
            return this;
        }

        public APIRequestCreateFeed setSalesPromoId(String salesPromoId) {
            this.setParam("sales_promo_id", salesPromoId);
            return this;
        }

        public APIRequestCreateFeed setTextFormatMetadata(String textFormatMetadata) {
            this.setParam("text_format_metadata", textFormatMetadata);
            return this;
        }

        public APIRequestCreateFeed setThrowbackCameraRollMedia(String throwbackCameraRollMedia) {
            this.setParam("throwback_camera_roll_media", throwbackCameraRollMedia);
            return this;
        }

        public APIRequestCreateFeed setVideoStartTimeMs(Long videoStartTimeMs) {
            this.setParam("video_start_time_ms", videoStartTimeMs);
            return this;
        }

        public APIRequestCreateFeed setVideoStartTimeMs(String videoStartTimeMs) {
            this.setParam("video_start_time_ms", videoStartTimeMs);
            return this;
        }

        public APIRequestCreateFeed requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateFeed requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateFeed requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateFeed requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateFeed requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateFeed requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateFavoriteRequest
    extends APIRequest<FavoriteRequest> {
        FavoriteRequest lastResponse = null;
        public static final String[] PARAMS = new String[]{"api_version", "graph_path", "query_params", "http_method", "description", "post_params"};
        public static final String[] FIELDS = new String[0];

        @Override
        public FavoriteRequest getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public FavoriteRequest parseResponse(String response) throws APIException {
            return FavoriteRequest.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public FavoriteRequest execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public FavoriteRequest execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<FavoriteRequest> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<FavoriteRequest> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, FavoriteRequest>(){

                public FavoriteRequest apply(String result) {
                    try {
                        return APIRequestCreateFavoriteRequest.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateFavoriteRequest(String nodeId, APIContext context) {
            super(context, nodeId, "/favorite_requests", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateFavoriteRequest setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateFavoriteRequest setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateFavoriteRequest setApiVersion(FavoriteRequest.EnumApiVersion apiVersion) {
            this.setParam("api_version", (Object)apiVersion);
            return this;
        }

        public APIRequestCreateFavoriteRequest setApiVersion(String apiVersion) {
            this.setParam("api_version", apiVersion);
            return this;
        }

        public APIRequestCreateFavoriteRequest setGraphPath(String graphPath) {
            this.setParam("graph_path", graphPath);
            return this;
        }

        public APIRequestCreateFavoriteRequest setQueryParams(Map<String, String> queryParams) {
            this.setParam("query_params", queryParams);
            return this;
        }

        public APIRequestCreateFavoriteRequest setQueryParams(String queryParams) {
            this.setParam("query_params", queryParams);
            return this;
        }

        public APIRequestCreateFavoriteRequest setHttpMethod(FavoriteRequest.EnumHttpMethod httpMethod) {
            this.setParam("http_method", (Object)httpMethod);
            return this;
        }

        public APIRequestCreateFavoriteRequest setHttpMethod(String httpMethod) {
            this.setParam("http_method", httpMethod);
            return this;
        }

        public APIRequestCreateFavoriteRequest setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateFavoriteRequest setPostParams(Map<String, String> postParams) {
            this.setParam("post_params", postParams);
            return this;
        }

        public APIRequestCreateFavoriteRequest setPostParams(String postParams) {
            this.setParam("post_params", postParams);
            return this;
        }

        public APIRequestCreateFavoriteRequest requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateFavoriteRequest requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateFavoriteRequest requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateFavoriteRequest requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateFavoriteRequest requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateFavoriteRequest requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetFavoriteRequests
    extends APIRequest<FavoriteRequest> {
        APINodeList<FavoriteRequest> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"api_version", "description", "graph_path", "hash", "http_method", "id", "post_params", "query_params"};

        @Override
        public APINodeList<FavoriteRequest> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<FavoriteRequest> parseResponse(String response) throws APIException {
            return FavoriteRequest.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<FavoriteRequest> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<FavoriteRequest> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<FavoriteRequest>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<FavoriteRequest>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<FavoriteRequest>>(){

                public APINodeList<FavoriteRequest> apply(String result) {
                    try {
                        return APIRequestGetFavoriteRequests.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetFavoriteRequests(String nodeId, APIContext context) {
            super(context, nodeId, "/favorite_requests", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetFavoriteRequests setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetFavoriteRequests setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetFavoriteRequests requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetFavoriteRequests requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFavoriteRequests requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetFavoriteRequests requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFavoriteRequests requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetFavoriteRequests requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetFavoriteRequests requestApiVersionField() {
            return this.requestApiVersionField(true);
        }

        public APIRequestGetFavoriteRequests requestApiVersionField(boolean value) {
            this.requestField("api_version", value);
            return this;
        }

        public APIRequestGetFavoriteRequests requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetFavoriteRequests requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetFavoriteRequests requestGraphPathField() {
            return this.requestGraphPathField(true);
        }

        public APIRequestGetFavoriteRequests requestGraphPathField(boolean value) {
            this.requestField("graph_path", value);
            return this;
        }

        public APIRequestGetFavoriteRequests requestHashField() {
            return this.requestHashField(true);
        }

        public APIRequestGetFavoriteRequests requestHashField(boolean value) {
            this.requestField("hash", value);
            return this;
        }

        public APIRequestGetFavoriteRequests requestHttpMethodField() {
            return this.requestHttpMethodField(true);
        }

        public APIRequestGetFavoriteRequests requestHttpMethodField(boolean value) {
            this.requestField("http_method", value);
            return this;
        }

        public APIRequestGetFavoriteRequests requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetFavoriteRequests requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetFavoriteRequests requestPostParamsField() {
            return this.requestPostParamsField(true);
        }

        public APIRequestGetFavoriteRequests requestPostParamsField(boolean value) {
            this.requestField("post_params", value);
            return this;
        }

        public APIRequestGetFavoriteRequests requestQueryParamsField() {
            return this.requestQueryParamsField(true);
        }

        public APIRequestGetFavoriteRequests requestQueryParamsField(boolean value) {
            this.requestField("query_params", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetFamily
    extends APIRequest<User> {
        APINodeList<User> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"about", "address", "admin_notes", "age_range", "bio", "birthday", "can_review_measurement_request", "context", "cover", "currency", "devices", "education", "email", "employee_number", "favorite_athletes", "favorite_teams", "first_name", "gender", "hometown", "id", "inspirational_people", "install_type", "installed", "interested_in", "is_famedeeplinkinguser", "is_shared_login", "is_verified", "labels", "languages", "last_name", "link", "local_news_megaphone_dismiss_status", "local_news_subscription_status", "locale", "location", "meeting_for", "middle_name", "name", "name_format", "payment_pricepoints", "political", "profile_pic", "public_key", "quotes", "relationship_status", "religion", "security_settings", "shared_login_upgrade_required_by", "short_name", "significant_other", "sports", "test_group", "third_party_id", "timezone", "token_for_business", "updated_time", "username", "verified", "video_upload_limits", "viewer_can_send_gift", "website", "work"};

        @Override
        public APINodeList<User> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<User> parseResponse(String response) throws APIException {
            return User.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<User> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<User> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<User>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<User>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<User>>(){

                public APINodeList<User> apply(String result) {
                    try {
                        return APIRequestGetFamily.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetFamily(String nodeId, APIContext context) {
            super(context, nodeId, "/family", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetFamily setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetFamily setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetFamily requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetFamily requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFamily requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetFamily requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFamily requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetFamily requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetFamily requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetFamily requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetFamily requestAddressField() {
            return this.requestAddressField(true);
        }

        public APIRequestGetFamily requestAddressField(boolean value) {
            this.requestField("address", value);
            return this;
        }

        public APIRequestGetFamily requestAdminNotesField() {
            return this.requestAdminNotesField(true);
        }

        public APIRequestGetFamily requestAdminNotesField(boolean value) {
            this.requestField("admin_notes", value);
            return this;
        }

        public APIRequestGetFamily requestAgeRangeField() {
            return this.requestAgeRangeField(true);
        }

        public APIRequestGetFamily requestAgeRangeField(boolean value) {
            this.requestField("age_range", value);
            return this;
        }

        public APIRequestGetFamily requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetFamily requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetFamily requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetFamily requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetFamily requestCanReviewMeasurementRequestField() {
            return this.requestCanReviewMeasurementRequestField(true);
        }

        public APIRequestGetFamily requestCanReviewMeasurementRequestField(boolean value) {
            this.requestField("can_review_measurement_request", value);
            return this;
        }

        public APIRequestGetFamily requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetFamily requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetFamily requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetFamily requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetFamily requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGetFamily requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGetFamily requestDevicesField() {
            return this.requestDevicesField(true);
        }

        public APIRequestGetFamily requestDevicesField(boolean value) {
            this.requestField("devices", value);
            return this;
        }

        public APIRequestGetFamily requestEducationField() {
            return this.requestEducationField(true);
        }

        public APIRequestGetFamily requestEducationField(boolean value) {
            this.requestField("education", value);
            return this;
        }

        public APIRequestGetFamily requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGetFamily requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGetFamily requestEmployeeNumberField() {
            return this.requestEmployeeNumberField(true);
        }

        public APIRequestGetFamily requestEmployeeNumberField(boolean value) {
            this.requestField("employee_number", value);
            return this;
        }

        public APIRequestGetFamily requestFavoriteAthletesField() {
            return this.requestFavoriteAthletesField(true);
        }

        public APIRequestGetFamily requestFavoriteAthletesField(boolean value) {
            this.requestField("favorite_athletes", value);
            return this;
        }

        public APIRequestGetFamily requestFavoriteTeamsField() {
            return this.requestFavoriteTeamsField(true);
        }

        public APIRequestGetFamily requestFavoriteTeamsField(boolean value) {
            this.requestField("favorite_teams", value);
            return this;
        }

        public APIRequestGetFamily requestFirstNameField() {
            return this.requestFirstNameField(true);
        }

        public APIRequestGetFamily requestFirstNameField(boolean value) {
            this.requestField("first_name", value);
            return this;
        }

        public APIRequestGetFamily requestGenderField() {
            return this.requestGenderField(true);
        }

        public APIRequestGetFamily requestGenderField(boolean value) {
            this.requestField("gender", value);
            return this;
        }

        public APIRequestGetFamily requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetFamily requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetFamily requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetFamily requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetFamily requestInspirationalPeopleField() {
            return this.requestInspirationalPeopleField(true);
        }

        public APIRequestGetFamily requestInspirationalPeopleField(boolean value) {
            this.requestField("inspirational_people", value);
            return this;
        }

        public APIRequestGetFamily requestInstallTypeField() {
            return this.requestInstallTypeField(true);
        }

        public APIRequestGetFamily requestInstallTypeField(boolean value) {
            this.requestField("install_type", value);
            return this;
        }

        public APIRequestGetFamily requestInstalledField() {
            return this.requestInstalledField(true);
        }

        public APIRequestGetFamily requestInstalledField(boolean value) {
            this.requestField("installed", value);
            return this;
        }

        public APIRequestGetFamily requestInterestedInField() {
            return this.requestInterestedInField(true);
        }

        public APIRequestGetFamily requestInterestedInField(boolean value) {
            this.requestField("interested_in", value);
            return this;
        }

        public APIRequestGetFamily requestIsFamedeeplinkinguserField() {
            return this.requestIsFamedeeplinkinguserField(true);
        }

        public APIRequestGetFamily requestIsFamedeeplinkinguserField(boolean value) {
            this.requestField("is_famedeeplinkinguser", value);
            return this;
        }

        public APIRequestGetFamily requestIsSharedLoginField() {
            return this.requestIsSharedLoginField(true);
        }

        public APIRequestGetFamily requestIsSharedLoginField(boolean value) {
            this.requestField("is_shared_login", value);
            return this;
        }

        public APIRequestGetFamily requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetFamily requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetFamily requestLabelsField() {
            return this.requestLabelsField(true);
        }

        public APIRequestGetFamily requestLabelsField(boolean value) {
            this.requestField("labels", value);
            return this;
        }

        public APIRequestGetFamily requestLanguagesField() {
            return this.requestLanguagesField(true);
        }

        public APIRequestGetFamily requestLanguagesField(boolean value) {
            this.requestField("languages", value);
            return this;
        }

        public APIRequestGetFamily requestLastNameField() {
            return this.requestLastNameField(true);
        }

        public APIRequestGetFamily requestLastNameField(boolean value) {
            this.requestField("last_name", value);
            return this;
        }

        public APIRequestGetFamily requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetFamily requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetFamily requestLocalNewsMegaphoneDismissStatusField() {
            return this.requestLocalNewsMegaphoneDismissStatusField(true);
        }

        public APIRequestGetFamily requestLocalNewsMegaphoneDismissStatusField(boolean value) {
            this.requestField("local_news_megaphone_dismiss_status", value);
            return this;
        }

        public APIRequestGetFamily requestLocalNewsSubscriptionStatusField() {
            return this.requestLocalNewsSubscriptionStatusField(true);
        }

        public APIRequestGetFamily requestLocalNewsSubscriptionStatusField(boolean value) {
            this.requestField("local_news_subscription_status", value);
            return this;
        }

        public APIRequestGetFamily requestLocaleField() {
            return this.requestLocaleField(true);
        }

        public APIRequestGetFamily requestLocaleField(boolean value) {
            this.requestField("locale", value);
            return this;
        }

        public APIRequestGetFamily requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetFamily requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetFamily requestMeetingForField() {
            return this.requestMeetingForField(true);
        }

        public APIRequestGetFamily requestMeetingForField(boolean value) {
            this.requestField("meeting_for", value);
            return this;
        }

        public APIRequestGetFamily requestMiddleNameField() {
            return this.requestMiddleNameField(true);
        }

        public APIRequestGetFamily requestMiddleNameField(boolean value) {
            this.requestField("middle_name", value);
            return this;
        }

        public APIRequestGetFamily requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetFamily requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetFamily requestNameFormatField() {
            return this.requestNameFormatField(true);
        }

        public APIRequestGetFamily requestNameFormatField(boolean value) {
            this.requestField("name_format", value);
            return this;
        }

        public APIRequestGetFamily requestPaymentPricepointsField() {
            return this.requestPaymentPricepointsField(true);
        }

        public APIRequestGetFamily requestPaymentPricepointsField(boolean value) {
            this.requestField("payment_pricepoints", value);
            return this;
        }

        public APIRequestGetFamily requestPoliticalField() {
            return this.requestPoliticalField(true);
        }

        public APIRequestGetFamily requestPoliticalField(boolean value) {
            this.requestField("political", value);
            return this;
        }

        public APIRequestGetFamily requestProfilePicField() {
            return this.requestProfilePicField(true);
        }

        public APIRequestGetFamily requestProfilePicField(boolean value) {
            this.requestField("profile_pic", value);
            return this;
        }

        public APIRequestGetFamily requestPublicKeyField() {
            return this.requestPublicKeyField(true);
        }

        public APIRequestGetFamily requestPublicKeyField(boolean value) {
            this.requestField("public_key", value);
            return this;
        }

        public APIRequestGetFamily requestQuotesField() {
            return this.requestQuotesField(true);
        }

        public APIRequestGetFamily requestQuotesField(boolean value) {
            this.requestField("quotes", value);
            return this;
        }

        public APIRequestGetFamily requestRelationshipStatusField() {
            return this.requestRelationshipStatusField(true);
        }

        public APIRequestGetFamily requestRelationshipStatusField(boolean value) {
            this.requestField("relationship_status", value);
            return this;
        }

        public APIRequestGetFamily requestReligionField() {
            return this.requestReligionField(true);
        }

        public APIRequestGetFamily requestReligionField(boolean value) {
            this.requestField("religion", value);
            return this;
        }

        public APIRequestGetFamily requestSecuritySettingsField() {
            return this.requestSecuritySettingsField(true);
        }

        public APIRequestGetFamily requestSecuritySettingsField(boolean value) {
            this.requestField("security_settings", value);
            return this;
        }

        public APIRequestGetFamily requestSharedLoginUpgradeRequiredByField() {
            return this.requestSharedLoginUpgradeRequiredByField(true);
        }

        public APIRequestGetFamily requestSharedLoginUpgradeRequiredByField(boolean value) {
            this.requestField("shared_login_upgrade_required_by", value);
            return this;
        }

        public APIRequestGetFamily requestShortNameField() {
            return this.requestShortNameField(true);
        }

        public APIRequestGetFamily requestShortNameField(boolean value) {
            this.requestField("short_name", value);
            return this;
        }

        public APIRequestGetFamily requestSignificantOtherField() {
            return this.requestSignificantOtherField(true);
        }

        public APIRequestGetFamily requestSignificantOtherField(boolean value) {
            this.requestField("significant_other", value);
            return this;
        }

        public APIRequestGetFamily requestSportsField() {
            return this.requestSportsField(true);
        }

        public APIRequestGetFamily requestSportsField(boolean value) {
            this.requestField("sports", value);
            return this;
        }

        public APIRequestGetFamily requestTestGroupField() {
            return this.requestTestGroupField(true);
        }

        public APIRequestGetFamily requestTestGroupField(boolean value) {
            this.requestField("test_group", value);
            return this;
        }

        public APIRequestGetFamily requestThirdPartyIdField() {
            return this.requestThirdPartyIdField(true);
        }

        public APIRequestGetFamily requestThirdPartyIdField(boolean value) {
            this.requestField("third_party_id", value);
            return this;
        }

        public APIRequestGetFamily requestTimezoneField() {
            return this.requestTimezoneField(true);
        }

        public APIRequestGetFamily requestTimezoneField(boolean value) {
            this.requestField("timezone", value);
            return this;
        }

        public APIRequestGetFamily requestTokenForBusinessField() {
            return this.requestTokenForBusinessField(true);
        }

        public APIRequestGetFamily requestTokenForBusinessField(boolean value) {
            this.requestField("token_for_business", value);
            return this;
        }

        public APIRequestGetFamily requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetFamily requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetFamily requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetFamily requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGetFamily requestVerifiedField() {
            return this.requestVerifiedField(true);
        }

        public APIRequestGetFamily requestVerifiedField(boolean value) {
            this.requestField("verified", value);
            return this;
        }

        public APIRequestGetFamily requestVideoUploadLimitsField() {
            return this.requestVideoUploadLimitsField(true);
        }

        public APIRequestGetFamily requestVideoUploadLimitsField(boolean value) {
            this.requestField("video_upload_limits", value);
            return this;
        }

        public APIRequestGetFamily requestViewerCanSendGiftField() {
            return this.requestViewerCanSendGiftField(true);
        }

        public APIRequestGetFamily requestViewerCanSendGiftField(boolean value) {
            this.requestField("viewer_can_send_gift", value);
            return this;
        }

        public APIRequestGetFamily requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetFamily requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetFamily requestWorkField() {
            return this.requestWorkField(true);
        }

        public APIRequestGetFamily requestWorkField(boolean value) {
            this.requestField("work", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateEvent
    extends APIRequest<Event> {
        Event lastResponse = null;
        public static final String[] PARAMS = new String[]{"event_info", "action_context", "app_context"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Event getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Event parseResponse(String response) throws APIException {
            return Event.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Event execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Event execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Event> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Event> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Event>(){

                public Event apply(String result) {
                    try {
                        return APIRequestCreateEvent.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateEvent(String nodeId, APIContext context) {
            super(context, nodeId, "/events", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateEvent setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateEvent setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateEvent setEventInfo(Object eventInfo) {
            this.setParam("event_info", eventInfo);
            return this;
        }

        public APIRequestCreateEvent setEventInfo(String eventInfo) {
            this.setParam("event_info", eventInfo);
            return this;
        }

        public APIRequestCreateEvent setActionContext(Object actionContext) {
            this.setParam("action_context", actionContext);
            return this;
        }

        public APIRequestCreateEvent setActionContext(String actionContext) {
            this.setParam("action_context", actionContext);
            return this;
        }

        public APIRequestCreateEvent setAppContext(Object appContext) {
            this.setParam("app_context", appContext);
            return this;
        }

        public APIRequestCreateEvent setAppContext(String appContext) {
            this.setParam("app_context", appContext);
            return this;
        }

        public APIRequestCreateEvent requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateEvent requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateEvent requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateEvent requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateEvent requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateEvent requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetEvents
    extends APIRequest<Event> {
        APINodeList<Event> lastResponse = null;
        public static final String[] PARAMS = new String[]{"type", "include_canceled"};
        public static final String[] FIELDS = new String[]{"attending_count", "can_guests_invite", "can_viewer_post", "category", "cover", "declined_count", "description", "discount_code_enabled", "end_time", "event_times", "guest_list_enabled", "id", "interested_count", "invited_count", "is_canceled", "is_date_only", "is_draft", "is_page_owned", "location", "maybe_count", "name", "noreply_count", "owner", "parent_group", "place", "privacy", "scheduled_publish_time", "start_time", "ticket_uri", "ticket_uri_start_sales_time", "ticketing_privacy_uri", "ticketing_terms_uri", "timezone", "type", "updated_time", "venue"};

        @Override
        public APINodeList<Event> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Event> parseResponse(String response) throws APIException {
            return Event.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Event> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Event> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Event>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Event>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Event>>(){

                public APINodeList<Event> apply(String result) {
                    try {
                        return APIRequestGetEvents.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetEvents(String nodeId, APIContext context) {
            super(context, nodeId, "/events", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetEvents setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetEvents setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetEvents setType(Event.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetEvents setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetEvents setIncludeCanceled(Boolean includeCanceled) {
            this.setParam("include_canceled", includeCanceled);
            return this;
        }

        public APIRequestGetEvents setIncludeCanceled(String includeCanceled) {
            this.setParam("include_canceled", includeCanceled);
            return this;
        }

        public APIRequestGetEvents requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetEvents requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetEvents requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetEvents requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetEvents requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetEvents requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetEvents requestAttendingCountField() {
            return this.requestAttendingCountField(true);
        }

        public APIRequestGetEvents requestAttendingCountField(boolean value) {
            this.requestField("attending_count", value);
            return this;
        }

        public APIRequestGetEvents requestCanGuestsInviteField() {
            return this.requestCanGuestsInviteField(true);
        }

        public APIRequestGetEvents requestCanGuestsInviteField(boolean value) {
            this.requestField("can_guests_invite", value);
            return this;
        }

        public APIRequestGetEvents requestCanViewerPostField() {
            return this.requestCanViewerPostField(true);
        }

        public APIRequestGetEvents requestCanViewerPostField(boolean value) {
            this.requestField("can_viewer_post", value);
            return this;
        }

        public APIRequestGetEvents requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetEvents requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetEvents requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetEvents requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetEvents requestDeclinedCountField() {
            return this.requestDeclinedCountField(true);
        }

        public APIRequestGetEvents requestDeclinedCountField(boolean value) {
            this.requestField("declined_count", value);
            return this;
        }

        public APIRequestGetEvents requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetEvents requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetEvents requestDiscountCodeEnabledField() {
            return this.requestDiscountCodeEnabledField(true);
        }

        public APIRequestGetEvents requestDiscountCodeEnabledField(boolean value) {
            this.requestField("discount_code_enabled", value);
            return this;
        }

        public APIRequestGetEvents requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGetEvents requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGetEvents requestEventTimesField() {
            return this.requestEventTimesField(true);
        }

        public APIRequestGetEvents requestEventTimesField(boolean value) {
            this.requestField("event_times", value);
            return this;
        }

        public APIRequestGetEvents requestGuestListEnabledField() {
            return this.requestGuestListEnabledField(true);
        }

        public APIRequestGetEvents requestGuestListEnabledField(boolean value) {
            this.requestField("guest_list_enabled", value);
            return this;
        }

        public APIRequestGetEvents requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetEvents requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetEvents requestInterestedCountField() {
            return this.requestInterestedCountField(true);
        }

        public APIRequestGetEvents requestInterestedCountField(boolean value) {
            this.requestField("interested_count", value);
            return this;
        }

        public APIRequestGetEvents requestInvitedCountField() {
            return this.requestInvitedCountField(true);
        }

        public APIRequestGetEvents requestInvitedCountField(boolean value) {
            this.requestField("invited_count", value);
            return this;
        }

        public APIRequestGetEvents requestIsCanceledField() {
            return this.requestIsCanceledField(true);
        }

        public APIRequestGetEvents requestIsCanceledField(boolean value) {
            this.requestField("is_canceled", value);
            return this;
        }

        public APIRequestGetEvents requestIsDateOnlyField() {
            return this.requestIsDateOnlyField(true);
        }

        public APIRequestGetEvents requestIsDateOnlyField(boolean value) {
            this.requestField("is_date_only", value);
            return this;
        }

        public APIRequestGetEvents requestIsDraftField() {
            return this.requestIsDraftField(true);
        }

        public APIRequestGetEvents requestIsDraftField(boolean value) {
            this.requestField("is_draft", value);
            return this;
        }

        public APIRequestGetEvents requestIsPageOwnedField() {
            return this.requestIsPageOwnedField(true);
        }

        public APIRequestGetEvents requestIsPageOwnedField(boolean value) {
            this.requestField("is_page_owned", value);
            return this;
        }

        public APIRequestGetEvents requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetEvents requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetEvents requestMaybeCountField() {
            return this.requestMaybeCountField(true);
        }

        public APIRequestGetEvents requestMaybeCountField(boolean value) {
            this.requestField("maybe_count", value);
            return this;
        }

        public APIRequestGetEvents requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetEvents requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetEvents requestNoreplyCountField() {
            return this.requestNoreplyCountField(true);
        }

        public APIRequestGetEvents requestNoreplyCountField(boolean value) {
            this.requestField("noreply_count", value);
            return this;
        }

        public APIRequestGetEvents requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGetEvents requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGetEvents requestParentGroupField() {
            return this.requestParentGroupField(true);
        }

        public APIRequestGetEvents requestParentGroupField(boolean value) {
            this.requestField("parent_group", value);
            return this;
        }

        public APIRequestGetEvents requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGetEvents requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGetEvents requestPrivacyField() {
            return this.requestPrivacyField(true);
        }

        public APIRequestGetEvents requestPrivacyField(boolean value) {
            this.requestField("privacy", value);
            return this;
        }

        public APIRequestGetEvents requestScheduledPublishTimeField() {
            return this.requestScheduledPublishTimeField(true);
        }

        public APIRequestGetEvents requestScheduledPublishTimeField(boolean value) {
            this.requestField("scheduled_publish_time", value);
            return this;
        }

        public APIRequestGetEvents requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGetEvents requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGetEvents requestTicketUriField() {
            return this.requestTicketUriField(true);
        }

        public APIRequestGetEvents requestTicketUriField(boolean value) {
            this.requestField("ticket_uri", value);
            return this;
        }

        public APIRequestGetEvents requestTicketUriStartSalesTimeField() {
            return this.requestTicketUriStartSalesTimeField(true);
        }

        public APIRequestGetEvents requestTicketUriStartSalesTimeField(boolean value) {
            this.requestField("ticket_uri_start_sales_time", value);
            return this;
        }

        public APIRequestGetEvents requestTicketingPrivacyUriField() {
            return this.requestTicketingPrivacyUriField(true);
        }

        public APIRequestGetEvents requestTicketingPrivacyUriField(boolean value) {
            this.requestField("ticketing_privacy_uri", value);
            return this;
        }

        public APIRequestGetEvents requestTicketingTermsUriField() {
            return this.requestTicketingTermsUriField(true);
        }

        public APIRequestGetEvents requestTicketingTermsUriField(boolean value) {
            this.requestField("ticketing_terms_uri", value);
            return this;
        }

        public APIRequestGetEvents requestTimezoneField() {
            return this.requestTimezoneField(true);
        }

        public APIRequestGetEvents requestTimezoneField(boolean value) {
            this.requestField("timezone", value);
            return this;
        }

        public APIRequestGetEvents requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetEvents requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGetEvents requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetEvents requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetEvents requestVenueField() {
            return this.requestVenueField(true);
        }

        public APIRequestGetEvents requestVenueField(boolean value) {
            this.requestField("venue", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetDomains
    extends APIRequest<Domain> {
        APINodeList<Domain> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "name", "url"};

        @Override
        public APINodeList<Domain> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Domain> parseResponse(String response) throws APIException {
            return Domain.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Domain> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Domain> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Domain>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Domain>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Domain>>(){

                public APINodeList<Domain> apply(String result) {
                    try {
                        return APIRequestGetDomains.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetDomains(String nodeId, APIContext context) {
            super(context, nodeId, "/domains", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetDomains setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetDomains setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetDomains requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetDomains requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDomains requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetDomains requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDomains requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetDomains requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetDomains requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetDomains requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetDomains requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetDomains requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetDomains requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGetDomains requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetCustomLabels
    extends APIRequest<PageUserMessageThreadLabel> {
        APINodeList<PageUserMessageThreadLabel> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "name"};

        @Override
        public APINodeList<PageUserMessageThreadLabel> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<PageUserMessageThreadLabel> parseResponse(String response) throws APIException {
            return PageUserMessageThreadLabel.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<PageUserMessageThreadLabel> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<PageUserMessageThreadLabel> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<PageUserMessageThreadLabel>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<PageUserMessageThreadLabel>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<PageUserMessageThreadLabel>>(){

                public APINodeList<PageUserMessageThreadLabel> apply(String result) {
                    try {
                        return APIRequestGetCustomLabels.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetCustomLabels(String nodeId, APIContext context) {
            super(context, nodeId, "/custom_labels", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCustomLabels setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCustomLabels setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCustomLabels requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCustomLabels requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCustomLabels requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCustomLabels requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCustomLabels requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCustomLabels requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetCustomLabels requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetCustomLabels requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetCustomLabels requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetCustomLabels requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetConversations
    extends APIRequest<UnifiedThread> {
        APINodeList<UnifiedThread> lastResponse = null;
        public static final String[] PARAMS = new String[]{"tags", "folder", "psid"};
        public static final String[] FIELDS = new String[]{"can_reply", "former_participants", "id", "is_subscribed", "link", "message_count", "name", "participants", "scoped_thread_key", "senders", "snippet", "subject", "tags", "thread_key", "unread_count", "updated_time", "wallpaper"};

        @Override
        public APINodeList<UnifiedThread> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<UnifiedThread> parseResponse(String response) throws APIException {
            return UnifiedThread.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<UnifiedThread> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<UnifiedThread> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<UnifiedThread>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<UnifiedThread>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<UnifiedThread>>(){

                public APINodeList<UnifiedThread> apply(String result) {
                    try {
                        return APIRequestGetConversations.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetConversations(String nodeId, APIContext context) {
            super(context, nodeId, "/conversations", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetConversations setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetConversations setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetConversations setTags(List<String> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestGetConversations setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestGetConversations setFolder(String folder) {
            this.setParam("folder", folder);
            return this;
        }

        public APIRequestGetConversations setPsid(Object psid) {
            this.setParam("psid", psid);
            return this;
        }

        public APIRequestGetConversations setPsid(String psid) {
            this.setParam("psid", psid);
            return this;
        }

        public APIRequestGetConversations requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetConversations requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetConversations requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetConversations requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetConversations requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetConversations requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetConversations requestCanReplyField() {
            return this.requestCanReplyField(true);
        }

        public APIRequestGetConversations requestCanReplyField(boolean value) {
            this.requestField("can_reply", value);
            return this;
        }

        public APIRequestGetConversations requestFormerParticipantsField() {
            return this.requestFormerParticipantsField(true);
        }

        public APIRequestGetConversations requestFormerParticipantsField(boolean value) {
            this.requestField("former_participants", value);
            return this;
        }

        public APIRequestGetConversations requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetConversations requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetConversations requestIsSubscribedField() {
            return this.requestIsSubscribedField(true);
        }

        public APIRequestGetConversations requestIsSubscribedField(boolean value) {
            this.requestField("is_subscribed", value);
            return this;
        }

        public APIRequestGetConversations requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetConversations requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetConversations requestMessageCountField() {
            return this.requestMessageCountField(true);
        }

        public APIRequestGetConversations requestMessageCountField(boolean value) {
            this.requestField("message_count", value);
            return this;
        }

        public APIRequestGetConversations requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetConversations requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetConversations requestParticipantsField() {
            return this.requestParticipantsField(true);
        }

        public APIRequestGetConversations requestParticipantsField(boolean value) {
            this.requestField("participants", value);
            return this;
        }

        public APIRequestGetConversations requestScopedThreadKeyField() {
            return this.requestScopedThreadKeyField(true);
        }

        public APIRequestGetConversations requestScopedThreadKeyField(boolean value) {
            this.requestField("scoped_thread_key", value);
            return this;
        }

        public APIRequestGetConversations requestSendersField() {
            return this.requestSendersField(true);
        }

        public APIRequestGetConversations requestSendersField(boolean value) {
            this.requestField("senders", value);
            return this;
        }

        public APIRequestGetConversations requestSnippetField() {
            return this.requestSnippetField(true);
        }

        public APIRequestGetConversations requestSnippetField(boolean value) {
            this.requestField("snippet", value);
            return this;
        }

        public APIRequestGetConversations requestSubjectField() {
            return this.requestSubjectField(true);
        }

        public APIRequestGetConversations requestSubjectField(boolean value) {
            this.requestField("subject", value);
            return this;
        }

        public APIRequestGetConversations requestTagsField() {
            return this.requestTagsField(true);
        }

        public APIRequestGetConversations requestTagsField(boolean value) {
            this.requestField("tags", value);
            return this;
        }

        public APIRequestGetConversations requestThreadKeyField() {
            return this.requestThreadKeyField(true);
        }

        public APIRequestGetConversations requestThreadKeyField(boolean value) {
            this.requestField("thread_key", value);
            return this;
        }

        public APIRequestGetConversations requestUnreadCountField() {
            return this.requestUnreadCountField(true);
        }

        public APIRequestGetConversations requestUnreadCountField(boolean value) {
            this.requestField("unread_count", value);
            return this;
        }

        public APIRequestGetConversations requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetConversations requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetConversations requestWallpaperField() {
            return this.requestWallpaperField(true);
        }

        public APIRequestGetConversations requestWallpaperField(boolean value) {
            this.requestField("wallpaper", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateCheckin
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"picture", "name", "link", "caption", "description", "quote", "source", "properties", "object_attachment", "height", "width", "expanded_height", "expanded_width", "referral_id", "thumbnail", "image_crops", "call_to_action", "place", "coordinates", "message", "tags", "privacy", "group", "nectar_module", "manual_privacy", "audience_exp", "composer_session_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINode>(){

                public APINode apply(String result) {
                    try {
                        return APIRequestCreateCheckin.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateCheckin(String nodeId, APIContext context) {
            super(context, nodeId, "/checkins", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateCheckin setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateCheckin setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateCheckin setPicture(String picture) {
            this.setParam("picture", picture);
            return this;
        }

        public APIRequestCreateCheckin setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateCheckin setLink(String link) {
            this.setParam("link", link);
            return this;
        }

        public APIRequestCreateCheckin setCaption(String caption) {
            this.setParam("caption", caption);
            return this;
        }

        public APIRequestCreateCheckin setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateCheckin setQuote(String quote) {
            this.setParam("quote", quote);
            return this;
        }

        public APIRequestCreateCheckin setSource(String source) {
            this.setParam("source", source);
            return this;
        }

        public APIRequestCreateCheckin setProperties(Object properties) {
            this.setParam("properties", properties);
            return this;
        }

        public APIRequestCreateCheckin setProperties(String properties) {
            this.setParam("properties", properties);
            return this;
        }

        public APIRequestCreateCheckin setObjectAttachment(String objectAttachment) {
            this.setParam("object_attachment", objectAttachment);
            return this;
        }

        public APIRequestCreateCheckin setHeight(Long height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestCreateCheckin setHeight(String height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestCreateCheckin setWidth(Long width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestCreateCheckin setWidth(String width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestCreateCheckin setExpandedHeight(Long expandedHeight) {
            this.setParam("expanded_height", expandedHeight);
            return this;
        }

        public APIRequestCreateCheckin setExpandedHeight(String expandedHeight) {
            this.setParam("expanded_height", expandedHeight);
            return this;
        }

        public APIRequestCreateCheckin setExpandedWidth(Long expandedWidth) {
            this.setParam("expanded_width", expandedWidth);
            return this;
        }

        public APIRequestCreateCheckin setExpandedWidth(String expandedWidth) {
            this.setParam("expanded_width", expandedWidth);
            return this;
        }

        public APIRequestCreateCheckin setReferralId(String referralId) {
            this.setParam("referral_id", referralId);
            return this;
        }

        public APIRequestCreateCheckin setThumbnail(File thumbnail) {
            this.setParam("thumbnail", thumbnail);
            return this;
        }

        public APIRequestCreateCheckin setThumbnail(String thumbnail) {
            this.setParam("thumbnail", thumbnail);
            return this;
        }

        public APIRequestCreateCheckin setImageCrops(Map<String, String> imageCrops) {
            this.setParam("image_crops", imageCrops);
            return this;
        }

        public APIRequestCreateCheckin setImageCrops(String imageCrops) {
            this.setParam("image_crops", imageCrops);
            return this;
        }

        public APIRequestCreateCheckin setCallToAction(Object callToAction) {
            this.setParam("call_to_action", callToAction);
            return this;
        }

        public APIRequestCreateCheckin setCallToAction(String callToAction) {
            this.setParam("call_to_action", callToAction);
            return this;
        }

        public APIRequestCreateCheckin setPlace(Object place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreateCheckin setPlace(String place) {
            this.setParam("place", place);
            return this;
        }

        public APIRequestCreateCheckin setCoordinates(Object coordinates) {
            this.setParam("coordinates", coordinates);
            return this;
        }

        public APIRequestCreateCheckin setCoordinates(String coordinates) {
            this.setParam("coordinates", coordinates);
            return this;
        }

        public APIRequestCreateCheckin setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateCheckin setTags(List<Long> tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateCheckin setTags(String tags) {
            this.setParam("tags", tags);
            return this;
        }

        public APIRequestCreateCheckin setPrivacy(Object privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateCheckin setPrivacy(String privacy) {
            this.setParam("privacy", privacy);
            return this;
        }

        public APIRequestCreateCheckin setGroup(String group) {
            this.setParam("group", group);
            return this;
        }

        public APIRequestCreateCheckin setNectarModule(String nectarModule) {
            this.setParam("nectar_module", nectarModule);
            return this;
        }

        public APIRequestCreateCheckin setManualPrivacy(Boolean manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreateCheckin setManualPrivacy(String manualPrivacy) {
            this.setParam("manual_privacy", manualPrivacy);
            return this;
        }

        public APIRequestCreateCheckin setAudienceExp(Boolean audienceExp) {
            this.setParam("audience_exp", audienceExp);
            return this;
        }

        public APIRequestCreateCheckin setAudienceExp(String audienceExp) {
            this.setParam("audience_exp", audienceExp);
            return this;
        }

        public APIRequestCreateCheckin setComposerSessionId(String composerSessionId) {
            this.setParam("composer_session_id", composerSessionId);
            return this;
        }

        public APIRequestCreateCheckin requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateCheckin requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCheckin requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateCheckin requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateCheckin requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateCheckin requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetBusinesses
    extends APIRequest<Business> {
        APINodeList<Business> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"block_offline_analytics", "created_by", "created_time", "extended_updated_time", "id", "is_hidden", "is_instagram_enabled_in_fb_analytics", "link", "name", "primary_page", "profile_picture_uri", "timezone_id", "two_factor_type", "updated_by", "updated_time", "verification_status", "vertical", "vertical_id"};

        @Override
        public APINodeList<Business> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Business> parseResponse(String response) throws APIException {
            return Business.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Business> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Business> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Business>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Business>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Business>>(){

                public APINodeList<Business> apply(String result) {
                    try {
                        return APIRequestGetBusinesses.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetBusinesses(String nodeId, APIContext context) {
            super(context, nodeId, "/businesses", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetBusinesses setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetBusinesses setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetBusinesses requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetBusinesses requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBusinesses requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetBusinesses requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBusinesses requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetBusinesses requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetBusinesses requestBlockOfflineAnalyticsField() {
            return this.requestBlockOfflineAnalyticsField(true);
        }

        public APIRequestGetBusinesses requestBlockOfflineAnalyticsField(boolean value) {
            this.requestField("block_offline_analytics", value);
            return this;
        }

        public APIRequestGetBusinesses requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGetBusinesses requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGetBusinesses requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetBusinesses requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetBusinesses requestExtendedUpdatedTimeField() {
            return this.requestExtendedUpdatedTimeField(true);
        }

        public APIRequestGetBusinesses requestExtendedUpdatedTimeField(boolean value) {
            this.requestField("extended_updated_time", value);
            return this;
        }

        public APIRequestGetBusinesses requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetBusinesses requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetBusinesses requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetBusinesses requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetBusinesses requestIsInstagramEnabledInFbAnalyticsField() {
            return this.requestIsInstagramEnabledInFbAnalyticsField(true);
        }

        public APIRequestGetBusinesses requestIsInstagramEnabledInFbAnalyticsField(boolean value) {
            this.requestField("is_instagram_enabled_in_fb_analytics", value);
            return this;
        }

        public APIRequestGetBusinesses requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetBusinesses requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetBusinesses requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetBusinesses requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetBusinesses requestPrimaryPageField() {
            return this.requestPrimaryPageField(true);
        }

        public APIRequestGetBusinesses requestPrimaryPageField(boolean value) {
            this.requestField("primary_page", value);
            return this;
        }

        public APIRequestGetBusinesses requestProfilePictureUriField() {
            return this.requestProfilePictureUriField(true);
        }

        public APIRequestGetBusinesses requestProfilePictureUriField(boolean value) {
            this.requestField("profile_picture_uri", value);
            return this;
        }

        public APIRequestGetBusinesses requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGetBusinesses requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }

        public APIRequestGetBusinesses requestTwoFactorTypeField() {
            return this.requestTwoFactorTypeField(true);
        }

        public APIRequestGetBusinesses requestTwoFactorTypeField(boolean value) {
            this.requestField("two_factor_type", value);
            return this;
        }

        public APIRequestGetBusinesses requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGetBusinesses requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGetBusinesses requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGetBusinesses requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGetBusinesses requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetBusinesses requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetBusinesses requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGetBusinesses requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }

        public APIRequestGetBusinesses requestVerticalIdField() {
            return this.requestVerticalIdField(true);
        }

        public APIRequestGetBusinesses requestVerticalIdField(boolean value) {
            this.requestField("vertical_id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteBusinesses
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteBusinesses.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteBusinesses(String nodeId, APIContext context) {
            super(context, nodeId, "/businesses", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteBusinesses setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteBusinesses setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteBusinesses setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestDeleteBusinesses requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteBusinesses requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteBusinesses requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteBusinesses requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteBusinesses requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteBusinesses requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetBusinessUsers
    extends APIRequest<BusinessUser> {
        APINodeList<BusinessUser> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "email", "finance_permission", "first_name", "id", "ip_permission", "last_name", "marked_for_removal", "name", "pending_email", "role", "title", "two_fac_status"};

        @Override
        public APINodeList<BusinessUser> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<BusinessUser> parseResponse(String response) throws APIException {
            return BusinessUser.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<BusinessUser> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<BusinessUser> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<BusinessUser>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<BusinessUser>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<BusinessUser>>(){

                public APINodeList<BusinessUser> apply(String result) {
                    try {
                        return APIRequestGetBusinessUsers.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetBusinessUsers(String nodeId, APIContext context) {
            super(context, nodeId, "/business_users", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetBusinessUsers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetBusinessUsers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetBusinessUsers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetBusinessUsers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBusinessUsers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetBusinessUsers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBusinessUsers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetBusinessUsers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetBusinessUsers requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetBusinessUsers requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGetBusinessUsers requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestFinancePermissionField() {
            return this.requestFinancePermissionField(true);
        }

        public APIRequestGetBusinessUsers requestFinancePermissionField(boolean value) {
            this.requestField("finance_permission", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestFirstNameField() {
            return this.requestFirstNameField(true);
        }

        public APIRequestGetBusinessUsers requestFirstNameField(boolean value) {
            this.requestField("first_name", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetBusinessUsers requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestIpPermissionField() {
            return this.requestIpPermissionField(true);
        }

        public APIRequestGetBusinessUsers requestIpPermissionField(boolean value) {
            this.requestField("ip_permission", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestLastNameField() {
            return this.requestLastNameField(true);
        }

        public APIRequestGetBusinessUsers requestLastNameField(boolean value) {
            this.requestField("last_name", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestMarkedForRemovalField() {
            return this.requestMarkedForRemovalField(true);
        }

        public APIRequestGetBusinessUsers requestMarkedForRemovalField(boolean value) {
            this.requestField("marked_for_removal", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetBusinessUsers requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestPendingEmailField() {
            return this.requestPendingEmailField(true);
        }

        public APIRequestGetBusinessUsers requestPendingEmailField(boolean value) {
            this.requestField("pending_email", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestRoleField() {
            return this.requestRoleField(true);
        }

        public APIRequestGetBusinessUsers requestRoleField(boolean value) {
            this.requestField("role", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetBusinessUsers requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetBusinessUsers requestTwoFacStatusField() {
            return this.requestTwoFacStatusField(true);
        }

        public APIRequestGetBusinessUsers requestTwoFacStatusField(boolean value) {
            this.requestField("two_fac_status", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetBusinessActivities
    extends APIRequest<BusinessActivityLogEvent> {
        APINodeList<BusinessActivityLogEvent> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[]{"acted_upon_business_id", "acted_upon_business_name", "acted_upon_business_object_id", "acted_upon_business_object_name", "acted_upon_business_object_type", "acted_upon_user_id", "acted_upon_user_name", "acting_business_id", "acting_business_name", "acting_user_id", "acting_user_name", "event_time", "event_type", "extra_data", "target_business_id", "target_business_name", "target_business_object_id", "target_business_object_name", "target_business_object_type", "id"};

        @Override
        public APINodeList<BusinessActivityLogEvent> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<BusinessActivityLogEvent> parseResponse(String response) throws APIException {
            return BusinessActivityLogEvent.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<BusinessActivityLogEvent> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<BusinessActivityLogEvent> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<BusinessActivityLogEvent>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<BusinessActivityLogEvent>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<BusinessActivityLogEvent>>(){

                public APINodeList<BusinessActivityLogEvent> apply(String result) {
                    try {
                        return APIRequestGetBusinessActivities.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetBusinessActivities(String nodeId, APIContext context) {
            super(context, nodeId, "/business_activities", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetBusinessActivities setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetBusinessActivities setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetBusinessActivities setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestGetBusinessActivities requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetBusinessActivities requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBusinessActivities requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetBusinessActivities requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBusinessActivities requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetBusinessActivities requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessIdField() {
            return this.requestActedUponBusinessIdField(true);
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessIdField(boolean value) {
            this.requestField("acted_upon_business_id", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessNameField() {
            return this.requestActedUponBusinessNameField(true);
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessNameField(boolean value) {
            this.requestField("acted_upon_business_name", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessObjectIdField() {
            return this.requestActedUponBusinessObjectIdField(true);
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessObjectIdField(boolean value) {
            this.requestField("acted_upon_business_object_id", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessObjectNameField() {
            return this.requestActedUponBusinessObjectNameField(true);
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessObjectNameField(boolean value) {
            this.requestField("acted_upon_business_object_name", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessObjectTypeField() {
            return this.requestActedUponBusinessObjectTypeField(true);
        }

        public APIRequestGetBusinessActivities requestActedUponBusinessObjectTypeField(boolean value) {
            this.requestField("acted_upon_business_object_type", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActedUponUserIdField() {
            return this.requestActedUponUserIdField(true);
        }

        public APIRequestGetBusinessActivities requestActedUponUserIdField(boolean value) {
            this.requestField("acted_upon_user_id", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActedUponUserNameField() {
            return this.requestActedUponUserNameField(true);
        }

        public APIRequestGetBusinessActivities requestActedUponUserNameField(boolean value) {
            this.requestField("acted_upon_user_name", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActingBusinessIdField() {
            return this.requestActingBusinessIdField(true);
        }

        public APIRequestGetBusinessActivities requestActingBusinessIdField(boolean value) {
            this.requestField("acting_business_id", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActingBusinessNameField() {
            return this.requestActingBusinessNameField(true);
        }

        public APIRequestGetBusinessActivities requestActingBusinessNameField(boolean value) {
            this.requestField("acting_business_name", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActingUserIdField() {
            return this.requestActingUserIdField(true);
        }

        public APIRequestGetBusinessActivities requestActingUserIdField(boolean value) {
            this.requestField("acting_user_id", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestActingUserNameField() {
            return this.requestActingUserNameField(true);
        }

        public APIRequestGetBusinessActivities requestActingUserNameField(boolean value) {
            this.requestField("acting_user_name", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestEventTimeField() {
            return this.requestEventTimeField(true);
        }

        public APIRequestGetBusinessActivities requestEventTimeField(boolean value) {
            this.requestField("event_time", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestEventTypeField() {
            return this.requestEventTypeField(true);
        }

        public APIRequestGetBusinessActivities requestEventTypeField(boolean value) {
            this.requestField("event_type", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestExtraDataField() {
            return this.requestExtraDataField(true);
        }

        public APIRequestGetBusinessActivities requestExtraDataField(boolean value) {
            this.requestField("extra_data", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestTargetBusinessIdField() {
            return this.requestTargetBusinessIdField(true);
        }

        public APIRequestGetBusinessActivities requestTargetBusinessIdField(boolean value) {
            this.requestField("target_business_id", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestTargetBusinessNameField() {
            return this.requestTargetBusinessNameField(true);
        }

        public APIRequestGetBusinessActivities requestTargetBusinessNameField(boolean value) {
            this.requestField("target_business_name", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestTargetBusinessObjectIdField() {
            return this.requestTargetBusinessObjectIdField(true);
        }

        public APIRequestGetBusinessActivities requestTargetBusinessObjectIdField(boolean value) {
            this.requestField("target_business_object_id", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestTargetBusinessObjectNameField() {
            return this.requestTargetBusinessObjectNameField(true);
        }

        public APIRequestGetBusinessActivities requestTargetBusinessObjectNameField(boolean value) {
            this.requestField("target_business_object_name", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestTargetBusinessObjectTypeField() {
            return this.requestTargetBusinessObjectTypeField(true);
        }

        public APIRequestGetBusinessActivities requestTargetBusinessObjectTypeField(boolean value) {
            this.requestField("target_business_object_type", value);
            return this;
        }

        public APIRequestGetBusinessActivities requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetBusinessActivities requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDeleteBulkContacts
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"contact_surface"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(String result) {
                    try {
                        return APIRequestDeleteBulkContacts.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDeleteBulkContacts(String nodeId, APIContext context) {
            super(context, nodeId, "/bulkcontacts", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteBulkContacts setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteBulkContacts setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteBulkContacts setContactSurface(EnumContactSurface contactSurface) {
            this.setParam("contact_surface", (Object)contactSurface);
            return this;
        }

        public APIRequestDeleteBulkContacts setContactSurface(String contactSurface) {
            this.setParam("contact_surface", contactSurface);
            return this;
        }

        public APIRequestDeleteBulkContacts requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteBulkContacts requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteBulkContacts requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteBulkContacts requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteBulkContacts requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteBulkContacts requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetBooks
    extends APIRequest<Page> {
        APINodeList<Page> lastResponse = null;
        public static final String[] PARAMS = new String[]{"target_id"};
        public static final String[] FIELDS = new String[]{"about", "access_token", "ad_campaign", "affiliation", "app_id", "app_links", "artists_we_like", "attire", "awards", "band_interests", "band_members", "best_page", "bio", "birthday", "booking_agent", "built", "business", "can_checkin", "can_post", "category", "category_list", "checkins", "company_overview", "connected_instagram_account", "contact_address", "context", "copyright_attribution_insights", "copyright_whitelisted_ig_partners", "country_page_likes", "cover", "culinary_team", "current_location", "description", "description_html", "directed_by", "display_subtext", "displayed_message_response_time", "emails", "engagement", "fan_count", "featured_video", "features", "food_styles", "founded", "general_info", "general_manager", "genre", "global_brand_page_name", "global_brand_parent_page", "global_brand_root_id", "has_added_app", "has_whatsapp_business_number", "has_whatsapp_number", "hometown", "hours", "id", "impressum", "influences", "instagram_business_account", "instant_articles_review_status", "is_always_open", "is_chain", "is_community_page", "is_eligible_for_branded_content", "is_messenger_bot_get_started_enabled", "is_messenger_platform_bot", "is_owned", "is_permanently_closed", "is_published", "is_unclaimed", "is_verified", "is_webhooks_subscribed", "keywords", "leadgen_form_preview_details", "leadgen_has_crm_integration", "leadgen_has_fat_ping_crm_integration", "leadgen_tos_acceptance_time", "leadgen_tos_accepted", "leadgen_tos_accepting_user", "link", "location", "members", "merchant_id", "merchant_review_status", "messenger_ads_default_icebreakers", "messenger_ads_default_page_welcome_message", "messenger_ads_default_quick_replies", "messenger_ads_quick_replies_type", "mission", "mpg", "name", "name_with_location_descriptor", "network", "new_like_count", "offer_eligible", "overall_star_rating", "page_token", "parent_page", "parking", "payment_options", "personal_info", "personal_interests", "pharma_safety_info", "phone", "place_type", "plot_outline", "preferred_audience", "press_contact", "price_range", "produced_by", "products", "promotion_eligible", "promotion_ineligible_reason", "public_transit", "publisher_space", "rating_count", "recipient", "record_label", "release_date", "restaurant_services", "restaurant_specialties", "schedule", "screenplay_by", "season", "single_line_address", "starring", "start_info", "store_code", "store_location_descriptor", "store_number", "studio", "supports_instant_articles", "talking_about_count", "unread_message_count", "unread_notif_count", "unseen_message_count", "username", "verification_status", "voip_info", "website", "were_here_count", "whatsapp_number", "written_by"};

        @Override
        public APINodeList<Page> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Page> parseResponse(String response) throws APIException {
            return Page.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Page> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Page>>(){

                public APINodeList<Page> apply(String result) {
                    try {
                        return APIRequestGetBooks.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetBooks(String nodeId, APIContext context) {
            super(context, nodeId, "/books", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetBooks setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetBooks setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetBooks setTargetId(String targetId) {
            this.setParam("target_id", targetId);
            return this;
        }

        public APIRequestGetBooks requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetBooks requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBooks requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetBooks requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetBooks requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetBooks requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetBooks requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetBooks requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetBooks requestAccessTokenField() {
            return this.requestAccessTokenField(true);
        }

        public APIRequestGetBooks requestAccessTokenField(boolean value) {
            this.requestField("access_token", value);
            return this;
        }

        public APIRequestGetBooks requestAdCampaignField() {
            return this.requestAdCampaignField(true);
        }

        public APIRequestGetBooks requestAdCampaignField(boolean value) {
            this.requestField("ad_campaign", value);
            return this;
        }

        public APIRequestGetBooks requestAffiliationField() {
            return this.requestAffiliationField(true);
        }

        public APIRequestGetBooks requestAffiliationField(boolean value) {
            this.requestField("affiliation", value);
            return this;
        }

        public APIRequestGetBooks requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetBooks requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetBooks requestAppLinksField() {
            return this.requestAppLinksField(true);
        }

        public APIRequestGetBooks requestAppLinksField(boolean value) {
            this.requestField("app_links", value);
            return this;
        }

        public APIRequestGetBooks requestArtistsWeLikeField() {
            return this.requestArtistsWeLikeField(true);
        }

        public APIRequestGetBooks requestArtistsWeLikeField(boolean value) {
            this.requestField("artists_we_like", value);
            return this;
        }

        public APIRequestGetBooks requestAttireField() {
            return this.requestAttireField(true);
        }

        public APIRequestGetBooks requestAttireField(boolean value) {
            this.requestField("attire", value);
            return this;
        }

        public APIRequestGetBooks requestAwardsField() {
            return this.requestAwardsField(true);
        }

        public APIRequestGetBooks requestAwardsField(boolean value) {
            this.requestField("awards", value);
            return this;
        }

        public APIRequestGetBooks requestBandInterestsField() {
            return this.requestBandInterestsField(true);
        }

        public APIRequestGetBooks requestBandInterestsField(boolean value) {
            this.requestField("band_interests", value);
            return this;
        }

        public APIRequestGetBooks requestBandMembersField() {
            return this.requestBandMembersField(true);
        }

        public APIRequestGetBooks requestBandMembersField(boolean value) {
            this.requestField("band_members", value);
            return this;
        }

        public APIRequestGetBooks requestBestPageField() {
            return this.requestBestPageField(true);
        }

        public APIRequestGetBooks requestBestPageField(boolean value) {
            this.requestField("best_page", value);
            return this;
        }

        public APIRequestGetBooks requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetBooks requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetBooks requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetBooks requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetBooks requestBookingAgentField() {
            return this.requestBookingAgentField(true);
        }

        public APIRequestGetBooks requestBookingAgentField(boolean value) {
            this.requestField("booking_agent", value);
            return this;
        }

        public APIRequestGetBooks requestBuiltField() {
            return this.requestBuiltField(true);
        }

        public APIRequestGetBooks requestBuiltField(boolean value) {
            this.requestField("built", value);
            return this;
        }

        public APIRequestGetBooks requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetBooks requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetBooks requestCanCheckinField() {
            return this.requestCanCheckinField(true);
        }

        public APIRequestGetBooks requestCanCheckinField(boolean value) {
            this.requestField("can_checkin", value);
            return this;
        }

        public APIRequestGetBooks requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetBooks requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetBooks requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetBooks requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetBooks requestCategoryListField() {
            return this.requestCategoryListField(true);
        }

        public APIRequestGetBooks requestCategoryListField(boolean value) {
            this.requestField("category_list", value);
            return this;
        }

        public APIRequestGetBooks requestCheckinsField() {
            return this.requestCheckinsField(true);
        }

        public APIRequestGetBooks requestCheckinsField(boolean value) {
            this.requestField("checkins", value);
            return this;
        }

        public APIRequestGetBooks requestCompanyOverviewField() {
            return this.requestCompanyOverviewField(true);
        }

        public APIRequestGetBooks requestCompanyOverviewField(boolean value) {
            this.requestField("company_overview", value);
            return this;
        }

        public APIRequestGetBooks requestConnectedInstagramAccountField() {
            return this.requestConnectedInstagramAccountField(true);
        }

        public APIRequestGetBooks requestConnectedInstagramAccountField(boolean value) {
            this.requestField("connected_instagram_account", value);
            return this;
        }

        public APIRequestGetBooks requestContactAddressField() {
            return this.requestContactAddressField(true);
        }

        public APIRequestGetBooks requestContactAddressField(boolean value) {
            this.requestField("contact_address", value);
            return this;
        }

        public APIRequestGetBooks requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetBooks requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetBooks requestCopyrightAttributionInsightsField() {
            return this.requestCopyrightAttributionInsightsField(true);
        }

        public APIRequestGetBooks requestCopyrightAttributionInsightsField(boolean value) {
            this.requestField("copyright_attribution_insights", value);
            return this;
        }

        public APIRequestGetBooks requestCopyrightWhitelistedIgPartnersField() {
            return this.requestCopyrightWhitelistedIgPartnersField(true);
        }

        public APIRequestGetBooks requestCopyrightWhitelistedIgPartnersField(boolean value) {
            this.requestField("copyright_whitelisted_ig_partners", value);
            return this;
        }

        public APIRequestGetBooks requestCountryPageLikesField() {
            return this.requestCountryPageLikesField(true);
        }

        public APIRequestGetBooks requestCountryPageLikesField(boolean value) {
            this.requestField("country_page_likes", value);
            return this;
        }

        public APIRequestGetBooks requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetBooks requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetBooks requestCulinaryTeamField() {
            return this.requestCulinaryTeamField(true);
        }

        public APIRequestGetBooks requestCulinaryTeamField(boolean value) {
            this.requestField("culinary_team", value);
            return this;
        }

        public APIRequestGetBooks requestCurrentLocationField() {
            return this.requestCurrentLocationField(true);
        }

        public APIRequestGetBooks requestCurrentLocationField(boolean value) {
            this.requestField("current_location", value);
            return this;
        }

        public APIRequestGetBooks requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetBooks requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetBooks requestDescriptionHtmlField() {
            return this.requestDescriptionHtmlField(true);
        }

        public APIRequestGetBooks requestDescriptionHtmlField(boolean value) {
            this.requestField("description_html", value);
            return this;
        }

        public APIRequestGetBooks requestDirectedByField() {
            return this.requestDirectedByField(true);
        }

        public APIRequestGetBooks requestDirectedByField(boolean value) {
            this.requestField("directed_by", value);
            return this;
        }

        public APIRequestGetBooks requestDisplaySubtextField() {
            return this.requestDisplaySubtextField(true);
        }

        public APIRequestGetBooks requestDisplaySubtextField(boolean value) {
            this.requestField("display_subtext", value);
            return this;
        }

        public APIRequestGetBooks requestDisplayedMessageResponseTimeField() {
            return this.requestDisplayedMessageResponseTimeField(true);
        }

        public APIRequestGetBooks requestDisplayedMessageResponseTimeField(boolean value) {
            this.requestField("displayed_message_response_time", value);
            return this;
        }

        public APIRequestGetBooks requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGetBooks requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGetBooks requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGetBooks requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGetBooks requestFanCountField() {
            return this.requestFanCountField(true);
        }

        public APIRequestGetBooks requestFanCountField(boolean value) {
            this.requestField("fan_count", value);
            return this;
        }

        public APIRequestGetBooks requestFeaturedVideoField() {
            return this.requestFeaturedVideoField(true);
        }

        public APIRequestGetBooks requestFeaturedVideoField(boolean value) {
            this.requestField("featured_video", value);
            return this;
        }

        public APIRequestGetBooks requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGetBooks requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGetBooks requestFoodStylesField() {
            return this.requestFoodStylesField(true);
        }

        public APIRequestGetBooks requestFoodStylesField(boolean value) {
            this.requestField("food_styles", value);
            return this;
        }

        public APIRequestGetBooks requestFoundedField() {
            return this.requestFoundedField(true);
        }

        public APIRequestGetBooks requestFoundedField(boolean value) {
            this.requestField("founded", value);
            return this;
        }

        public APIRequestGetBooks requestGeneralInfoField() {
            return this.requestGeneralInfoField(true);
        }

        public APIRequestGetBooks requestGeneralInfoField(boolean value) {
            this.requestField("general_info", value);
            return this;
        }

        public APIRequestGetBooks requestGeneralManagerField() {
            return this.requestGeneralManagerField(true);
        }

        public APIRequestGetBooks requestGeneralManagerField(boolean value) {
            this.requestField("general_manager", value);
            return this;
        }

        public APIRequestGetBooks requestGenreField() {
            return this.requestGenreField(true);
        }

        public APIRequestGetBooks requestGenreField(boolean value) {
            this.requestField("genre", value);
            return this;
        }

        public APIRequestGetBooks requestGlobalBrandPageNameField() {
            return this.requestGlobalBrandPageNameField(true);
        }

        public APIRequestGetBooks requestGlobalBrandPageNameField(boolean value) {
            this.requestField("global_brand_page_name", value);
            return this;
        }

        public APIRequestGetBooks requestGlobalBrandParentPageField() {
            return this.requestGlobalBrandParentPageField(true);
        }

        public APIRequestGetBooks requestGlobalBrandParentPageField(boolean value) {
            this.requestField("global_brand_parent_page", value);
            return this;
        }

        public APIRequestGetBooks requestGlobalBrandRootIdField() {
            return this.requestGlobalBrandRootIdField(true);
        }

        public APIRequestGetBooks requestGlobalBrandRootIdField(boolean value) {
            this.requestField("global_brand_root_id", value);
            return this;
        }

        public APIRequestGetBooks requestHasAddedAppField() {
            return this.requestHasAddedAppField(true);
        }

        public APIRequestGetBooks requestHasAddedAppField(boolean value) {
            this.requestField("has_added_app", value);
            return this;
        }

        public APIRequestGetBooks requestHasWhatsappBusinessNumberField() {
            return this.requestHasWhatsappBusinessNumberField(true);
        }

        public APIRequestGetBooks requestHasWhatsappBusinessNumberField(boolean value) {
            this.requestField("has_whatsapp_business_number", value);
            return this;
        }

        public APIRequestGetBooks requestHasWhatsappNumberField() {
            return this.requestHasWhatsappNumberField(true);
        }

        public APIRequestGetBooks requestHasWhatsappNumberField(boolean value) {
            this.requestField("has_whatsapp_number", value);
            return this;
        }

        public APIRequestGetBooks requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetBooks requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetBooks requestHoursField() {
            return this.requestHoursField(true);
        }

        public APIRequestGetBooks requestHoursField(boolean value) {
            this.requestField("hours", value);
            return this;
        }

        public APIRequestGetBooks requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetBooks requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetBooks requestImpressumField() {
            return this.requestImpressumField(true);
        }

        public APIRequestGetBooks requestImpressumField(boolean value) {
            this.requestField("impressum", value);
            return this;
        }

        public APIRequestGetBooks requestInfluencesField() {
            return this.requestInfluencesField(true);
        }

        public APIRequestGetBooks requestInfluencesField(boolean value) {
            this.requestField("influences", value);
            return this;
        }

        public APIRequestGetBooks requestInstagramBusinessAccountField() {
            return this.requestInstagramBusinessAccountField(true);
        }

        public APIRequestGetBooks requestInstagramBusinessAccountField(boolean value) {
            this.requestField("instagram_business_account", value);
            return this;
        }

        public APIRequestGetBooks requestInstantArticlesReviewStatusField() {
            return this.requestInstantArticlesReviewStatusField(true);
        }

        public APIRequestGetBooks requestInstantArticlesReviewStatusField(boolean value) {
            this.requestField("instant_articles_review_status", value);
            return this;
        }

        public APIRequestGetBooks requestIsAlwaysOpenField() {
            return this.requestIsAlwaysOpenField(true);
        }

        public APIRequestGetBooks requestIsAlwaysOpenField(boolean value) {
            this.requestField("is_always_open", value);
            return this;
        }

        public APIRequestGetBooks requestIsChainField() {
            return this.requestIsChainField(true);
        }

        public APIRequestGetBooks requestIsChainField(boolean value) {
            this.requestField("is_chain", value);
            return this;
        }

        public APIRequestGetBooks requestIsCommunityPageField() {
            return this.requestIsCommunityPageField(true);
        }

        public APIRequestGetBooks requestIsCommunityPageField(boolean value) {
            this.requestField("is_community_page", value);
            return this;
        }

        public APIRequestGetBooks requestIsEligibleForBrandedContentField() {
            return this.requestIsEligibleForBrandedContentField(true);
        }

        public APIRequestGetBooks requestIsEligibleForBrandedContentField(boolean value) {
            this.requestField("is_eligible_for_branded_content", value);
            return this;
        }

        public APIRequestGetBooks requestIsMessengerBotGetStartedEnabledField() {
            return this.requestIsMessengerBotGetStartedEnabledField(true);
        }

        public APIRequestGetBooks requestIsMessengerBotGetStartedEnabledField(boolean value) {
            this.requestField("is_messenger_bot_get_started_enabled", value);
            return this;
        }

        public APIRequestGetBooks requestIsMessengerPlatformBotField() {
            return this.requestIsMessengerPlatformBotField(true);
        }

        public APIRequestGetBooks requestIsMessengerPlatformBotField(boolean value) {
            this.requestField("is_messenger_platform_bot", value);
            return this;
        }

        public APIRequestGetBooks requestIsOwnedField() {
            return this.requestIsOwnedField(true);
        }

        public APIRequestGetBooks requestIsOwnedField(boolean value) {
            this.requestField("is_owned", value);
            return this;
        }

        public APIRequestGetBooks requestIsPermanentlyClosedField() {
            return this.requestIsPermanentlyClosedField(true);
        }

        public APIRequestGetBooks requestIsPermanentlyClosedField(boolean value) {
            this.requestField("is_permanently_closed", value);
            return this;
        }

        public APIRequestGetBooks requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetBooks requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetBooks requestIsUnclaimedField() {
            return this.requestIsUnclaimedField(true);
        }

        public APIRequestGetBooks requestIsUnclaimedField(boolean value) {
            this.requestField("is_unclaimed", value);
            return this;
        }

        public APIRequestGetBooks requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetBooks requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetBooks requestIsWebhooksSubscribedField() {
            return this.requestIsWebhooksSubscribedField(true);
        }

        public APIRequestGetBooks requestIsWebhooksSubscribedField(boolean value) {
            this.requestField("is_webhooks_subscribed", value);
            return this;
        }

        public APIRequestGetBooks requestKeywordsField() {
            return this.requestKeywordsField(true);
        }

        public APIRequestGetBooks requestKeywordsField(boolean value) {
            this.requestField("keywords", value);
            return this;
        }

        public APIRequestGetBooks requestLeadgenFormPreviewDetailsField() {
            return this.requestLeadgenFormPreviewDetailsField(true);
        }

        public APIRequestGetBooks requestLeadgenFormPreviewDetailsField(boolean value) {
            this.requestField("leadgen_form_preview_details", value);
            return this;
        }

        public APIRequestGetBooks requestLeadgenHasCrmIntegrationField() {
            return this.requestLeadgenHasCrmIntegrationField(true);
        }

        public APIRequestGetBooks requestLeadgenHasCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_crm_integration", value);
            return this;
        }

        public APIRequestGetBooks requestLeadgenHasFatPingCrmIntegrationField() {
            return this.requestLeadgenHasFatPingCrmIntegrationField(true);
        }

        public APIRequestGetBooks requestLeadgenHasFatPingCrmIntegrationField(boolean value) {
            this.requestField("leadgen_has_fat_ping_crm_integration", value);
            return this;
        }

        public APIRequestGetBooks requestLeadgenTosAcceptanceTimeField() {
            return this.requestLeadgenTosAcceptanceTimeField(true);
        }

        public APIRequestGetBooks requestLeadgenTosAcceptanceTimeField(boolean value) {
            this.requestField("leadgen_tos_acceptance_time", value);
            return this;
        }

        public APIRequestGetBooks requestLeadgenTosAcceptedField() {
            return this.requestLeadgenTosAcceptedField(true);
        }

        public APIRequestGetBooks requestLeadgenTosAcceptedField(boolean value) {
            this.requestField("leadgen_tos_accepted", value);
            return this;
        }

        public APIRequestGetBooks requestLeadgenTosAcceptingUserField() {
            return this.requestLeadgenTosAcceptingUserField(true);
        }

        public APIRequestGetBooks requestLeadgenTosAcceptingUserField(boolean value) {
            this.requestField("leadgen_tos_accepting_user", value);
            return this;
        }

        public APIRequestGetBooks requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetBooks requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetBooks requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetBooks requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetBooks requestMembersField() {
            return this.requestMembersField(true);
        }

        public APIRequestGetBooks requestMembersField(boolean value) {
            this.requestField("members", value);
            return this;
        }

        public APIRequestGetBooks requestMerchantIdField() {
            return this.requestMerchantIdField(true);
        }

        public APIRequestGetBooks requestMerchantIdField(boolean value) {
            this.requestField("merchant_id", value);
            return this;
        }

        public APIRequestGetBooks requestMerchantReviewStatusField() {
            return this.requestMerchantReviewStatusField(true);
        }

        public APIRequestGetBooks requestMerchantReviewStatusField(boolean value) {
            this.requestField("merchant_review_status", value);
            return this;
        }

        public APIRequestGetBooks requestMessengerAdsDefaultIcebreakersField() {
            return this.requestMessengerAdsDefaultIcebreakersField(true);
        }

        public APIRequestGetBooks requestMessengerAdsDefaultIcebreakersField(boolean value) {
            this.requestField("messenger_ads_default_icebreakers", value);
            return this;
        }

        public APIRequestGetBooks requestMessengerAdsDefaultPageWelcomeMessageField() {
            return this.requestMessengerAdsDefaultPageWelcomeMessageField(true);
        }

        public APIRequestGetBooks requestMessengerAdsDefaultPageWelcomeMessageField(boolean value) {
            this.requestField("messenger_ads_default_page_welcome_message", value);
            return this;
        }

        public APIRequestGetBooks requestMessengerAdsDefaultQuickRepliesField() {
            return this.requestMessengerAdsDefaultQuickRepliesField(true);
        }

        public APIRequestGetBooks requestMessengerAdsDefaultQuickRepliesField(boolean value) {
            this.requestField("messenger_ads_default_quick_replies", value);
            return this;
        }

        public APIRequestGetBooks requestMessengerAdsQuickRepliesTypeField() {
            return this.requestMessengerAdsQuickRepliesTypeField(true);
        }

        public APIRequestGetBooks requestMessengerAdsQuickRepliesTypeField(boolean value) {
            this.requestField("messenger_ads_quick_replies_type", value);
            return this;
        }

        public APIRequestGetBooks requestMissionField() {
            return this.requestMissionField(true);
        }

        public APIRequestGetBooks requestMissionField(boolean value) {
            this.requestField("mission", value);
            return this;
        }

        public APIRequestGetBooks requestMpgField() {
            return this.requestMpgField(true);
        }

        public APIRequestGetBooks requestMpgField(boolean value) {
            this.requestField("mpg", value);
            return this;
        }

        public APIRequestGetBooks requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetBooks requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetBooks requestNameWithLocationDescriptorField() {
            return this.requestNameWithLocationDescriptorField(true);
        }

        public APIRequestGetBooks requestNameWithLocationDescriptorField(boolean value) {
            this.requestField("name_with_location_descriptor", value);
            return this;
        }

        public APIRequestGetBooks requestNetworkField() {
            return this.requestNetworkField(true);
        }

        public APIRequestGetBooks requestNetworkField(boolean value) {
            this.requestField("network", value);
            return this;
        }

        public APIRequestGetBooks requestNewLikeCountField() {
            return this.requestNewLikeCountField(true);
        }

        public APIRequestGetBooks requestNewLikeCountField(boolean value) {
            this.requestField("new_like_count", value);
            return this;
        }

        public APIRequestGetBooks requestOfferEligibleField() {
            return this.requestOfferEligibleField(true);
        }

        public APIRequestGetBooks requestOfferEligibleField(boolean value) {
            this.requestField("offer_eligible", value);
            return this;
        }

        public APIRequestGetBooks requestOverallStarRatingField() {
            return this.requestOverallStarRatingField(true);
        }

        public APIRequestGetBooks requestOverallStarRatingField(boolean value) {
            this.requestField("overall_star_rating", value);
            return this;
        }

        public APIRequestGetBooks requestPageTokenField() {
            return this.requestPageTokenField(true);
        }

        public APIRequestGetBooks requestPageTokenField(boolean value) {
            this.requestField("page_token", value);
            return this;
        }

        public APIRequestGetBooks requestParentPageField() {
            return this.requestParentPageField(true);
        }

        public APIRequestGetBooks requestParentPageField(boolean value) {
            this.requestField("parent_page", value);
            return this;
        }

        public APIRequestGetBooks requestParkingField() {
            return this.requestParkingField(true);
        }

        public APIRequestGetBooks requestParkingField(boolean value) {
            this.requestField("parking", value);
            return this;
        }

        public APIRequestGetBooks requestPaymentOptionsField() {
            return this.requestPaymentOptionsField(true);
        }

        public APIRequestGetBooks requestPaymentOptionsField(boolean value) {
            this.requestField("payment_options", value);
            return this;
        }

        public APIRequestGetBooks requestPersonalInfoField() {
            return this.requestPersonalInfoField(true);
        }

        public APIRequestGetBooks requestPersonalInfoField(boolean value) {
            this.requestField("personal_info", value);
            return this;
        }

        public APIRequestGetBooks requestPersonalInterestsField() {
            return this.requestPersonalInterestsField(true);
        }

        public APIRequestGetBooks requestPersonalInterestsField(boolean value) {
            this.requestField("personal_interests", value);
            return this;
        }

        public APIRequestGetBooks requestPharmaSafetyInfoField() {
            return this.requestPharmaSafetyInfoField(true);
        }

        public APIRequestGetBooks requestPharmaSafetyInfoField(boolean value) {
            this.requestField("pharma_safety_info", value);
            return this;
        }

        public APIRequestGetBooks requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGetBooks requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGetBooks requestPlaceTypeField() {
            return this.requestPlaceTypeField(true);
        }

        public APIRequestGetBooks requestPlaceTypeField(boolean value) {
            this.requestField("place_type", value);
            return this;
        }

        public APIRequestGetBooks requestPlotOutlineField() {
            return this.requestPlotOutlineField(true);
        }

        public APIRequestGetBooks requestPlotOutlineField(boolean value) {
            this.requestField("plot_outline", value);
            return this;
        }

        public APIRequestGetBooks requestPreferredAudienceField() {
            return this.requestPreferredAudienceField(true);
        }

        public APIRequestGetBooks requestPreferredAudienceField(boolean value) {
            this.requestField("preferred_audience", value);
            return this;
        }

        public APIRequestGetBooks requestPressContactField() {
            return this.requestPressContactField(true);
        }

        public APIRequestGetBooks requestPressContactField(boolean value) {
            this.requestField("press_contact", value);
            return this;
        }

        public APIRequestGetBooks requestPriceRangeField() {
            return this.requestPriceRangeField(true);
        }

        public APIRequestGetBooks requestPriceRangeField(boolean value) {
            this.requestField("price_range", value);
            return this;
        }

        public APIRequestGetBooks requestProducedByField() {
            return this.requestProducedByField(true);
        }

        public APIRequestGetBooks requestProducedByField(boolean value) {
            this.requestField("produced_by", value);
            return this;
        }

        public APIRequestGetBooks requestProductsField() {
            return this.requestProductsField(true);
        }

        public APIRequestGetBooks requestProductsField(boolean value) {
            this.requestField("products", value);
            return this;
        }

        public APIRequestGetBooks requestPromotionEligibleField() {
            return this.requestPromotionEligibleField(true);
        }

        public APIRequestGetBooks requestPromotionEligibleField(boolean value) {
            this.requestField("promotion_eligible", value);
            return this;
        }

        public APIRequestGetBooks requestPromotionIneligibleReasonField() {
            return this.requestPromotionIneligibleReasonField(true);
        }

        public APIRequestGetBooks requestPromotionIneligibleReasonField(boolean value) {
            this.requestField("promotion_ineligible_reason", value);
            return this;
        }

        public APIRequestGetBooks requestPublicTransitField() {
            return this.requestPublicTransitField(true);
        }

        public APIRequestGetBooks requestPublicTransitField(boolean value) {
            this.requestField("public_transit", value);
            return this;
        }

        public APIRequestGetBooks requestPublisherSpaceField() {
            return this.requestPublisherSpaceField(true);
        }

        public APIRequestGetBooks requestPublisherSpaceField(boolean value) {
            this.requestField("publisher_space", value);
            return this;
        }

        public APIRequestGetBooks requestRatingCountField() {
            return this.requestRatingCountField(true);
        }

        public APIRequestGetBooks requestRatingCountField(boolean value) {
            this.requestField("rating_count", value);
            return this;
        }

        public APIRequestGetBooks requestRecipientField() {
            return this.requestRecipientField(true);
        }

        public APIRequestGetBooks requestRecipientField(boolean value) {
            this.requestField("recipient", value);
            return this;
        }

        public APIRequestGetBooks requestRecordLabelField() {
            return this.requestRecordLabelField(true);
        }

        public APIRequestGetBooks requestRecordLabelField(boolean value) {
            this.requestField("record_label", value);
            return this;
        }

        public APIRequestGetBooks requestReleaseDateField() {
            return this.requestReleaseDateField(true);
        }

        public APIRequestGetBooks requestReleaseDateField(boolean value) {
            this.requestField("release_date", value);
            return this;
        }

        public APIRequestGetBooks requestRestaurantServicesField() {
            return this.requestRestaurantServicesField(true);
        }

        public APIRequestGetBooks requestRestaurantServicesField(boolean value) {
            this.requestField("restaurant_services", value);
            return this;
        }

        public APIRequestGetBooks requestRestaurantSpecialtiesField() {
            return this.requestRestaurantSpecialtiesField(true);
        }

        public APIRequestGetBooks requestRestaurantSpecialtiesField(boolean value) {
            this.requestField("restaurant_specialties", value);
            return this;
        }

        public APIRequestGetBooks requestScheduleField() {
            return this.requestScheduleField(true);
        }

        public APIRequestGetBooks requestScheduleField(boolean value) {
            this.requestField("schedule", value);
            return this;
        }

        public APIRequestGetBooks requestScreenplayByField() {
            return this.requestScreenplayByField(true);
        }

        public APIRequestGetBooks requestScreenplayByField(boolean value) {
            this.requestField("screenplay_by", value);
            return this;
        }

        public APIRequestGetBooks requestSeasonField() {
            return this.requestSeasonField(true);
        }

        public APIRequestGetBooks requestSeasonField(boolean value) {
            this.requestField("season", value);
            return this;
        }

        public APIRequestGetBooks requestSingleLineAddressField() {
            return this.requestSingleLineAddressField(true);
        }

        public APIRequestGetBooks requestSingleLineAddressField(boolean value) {
            this.requestField("single_line_address", value);
            return this;
        }

        public APIRequestGetBooks requestStarringField() {
            return this.requestStarringField(true);
        }

        public APIRequestGetBooks requestStarringField(boolean value) {
            this.requestField("starring", value);
            return this;
        }

        public APIRequestGetBooks requestStartInfoField() {
            return this.requestStartInfoField(true);
        }

        public APIRequestGetBooks requestStartInfoField(boolean value) {
            this.requestField("start_info", value);
            return this;
        }

        public APIRequestGetBooks requestStoreCodeField() {
            return this.requestStoreCodeField(true);
        }

        public APIRequestGetBooks requestStoreCodeField(boolean value) {
            this.requestField("store_code", value);
            return this;
        }

        public APIRequestGetBooks requestStoreLocationDescriptorField() {
            return this.requestStoreLocationDescriptorField(true);
        }

        public APIRequestGetBooks requestStoreLocationDescriptorField(boolean value) {
            this.requestField("store_location_descriptor", value);
            return this;
        }

        public APIRequestGetBooks requestStoreNumberField() {
            return this.requestStoreNumberField(true);
        }

        public APIRequestGetBooks requestStoreNumberField(boolean value) {
            this.requestField("store_number", value);
            return this;
        }

        public APIRequestGetBooks requestStudioField() {
            return this.requestStudioField(true);
        }

        public APIRequestGetBooks requestStudioField(boolean value) {
            this.requestField("studio", value);
            return this;
        }

        public APIRequestGetBooks requestSupportsInstantArticlesField() {
            return this.requestSupportsInstantArticlesField(true);
        }

        public APIRequestGetBooks requestSupportsInstantArticlesField(boolean value) {
            this.requestField("supports_instant_articles", value);
            return this;
        }

        public APIRequestGetBooks requestTalkingAboutCountField() {
            return this.requestTalkingAboutCountField(true);
        }

        public APIRequestGetBooks requestTalkingAboutCountField(boolean value) {
            this.requestField("talking_about_count", value);
            return this;
        }

        public APIRequestGetBooks requestUnreadMessageCountField() {
            return this.requestUnreadMessageCountField(true);
        }

        public APIRequestGetBooks requestUnreadMessageCountField(boolean value) {
            this.requestField("unread_message_count", value);
            return this;
        }

        public APIRequestGetBooks requestUnreadNotifCountField() {
            return this.requestUnreadNotifCountField(true);
        }

        public APIRequestGetBooks requestUnreadNotifCountField(boolean value) {
            this.requestField("unread_notif_count", value);
            return this;
        }

        public APIRequestGetBooks requestUnseenMessageCountField() {
            return this.requestUnseenMessageCountField(true);
        }

        public APIRequestGetBooks requestUnseenMessageCountField(boolean value) {
            this.requestField("unseen_message_count", value);
            return this;
        }

        public APIRequestGetBooks requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetBooks requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGetBooks requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetBooks requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetBooks requestVoipInfoField() {
            return this.requestVoipInfoField(true);
        }

        public APIRequestGetBooks requestVoipInfoField(boolean value) {
            this.requestField("voip_info", value);
            return this;
        }

        public APIRequestGetBooks requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetBooks requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetBooks requestWereHereCountField() {
            return this.requestWereHereCountField(true);
        }

        public APIRequestGetBooks requestWereHereCountField(boolean value) {
            this.requestField("were_here_count", value);
            return this;
        }

        public APIRequestGetBooks requestWhatsappNumberField() {
            return this.requestWhatsappNumberField(true);
        }

        public APIRequestGetBooks requestWhatsappNumberField(boolean value) {
            this.requestField("whatsapp_number", value);
            return this;
        }

        public APIRequestGetBooks requestWrittenByField() {
            return this.requestWrittenByField(true);
        }

        public APIRequestGetBooks requestWrittenByField(boolean value) {
            this.requestField("written_by", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAssignedProductCatalogs
    extends APIRequest<ProductCatalog> {
        APINodeList<ProductCatalog> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "da_display_settings", "default_image_url", "fallback_image_url", "feed_count", "flight_catalog_settings", "id", "image_padding_landscape", "image_padding_square", "name", "product_count", "qualified_product_count", "vertical"};

        @Override
        public APINodeList<ProductCatalog> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ProductCatalog> parseResponse(String response) throws APIException {
            return ProductCatalog.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<ProductCatalog> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ProductCatalog> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ProductCatalog>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ProductCatalog>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<ProductCatalog>>(){

                public APINodeList<ProductCatalog> apply(String result) {
                    try {
                        return APIRequestGetAssignedProductCatalogs.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAssignedProductCatalogs(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_product_catalogs", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAssignedProductCatalogs setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAssignedProductCatalogs setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAssignedProductCatalogs requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedProductCatalogs requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAssignedProductCatalogs requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedProductCatalogs requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAssignedProductCatalogs requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestDaDisplaySettingsField() {
            return this.requestDaDisplaySettingsField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestDaDisplaySettingsField(boolean value) {
            this.requestField("da_display_settings", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestDefaultImageUrlField() {
            return this.requestDefaultImageUrlField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestDefaultImageUrlField(boolean value) {
            this.requestField("default_image_url", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestFallbackImageUrlField() {
            return this.requestFallbackImageUrlField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestFallbackImageUrlField(boolean value) {
            this.requestField("fallback_image_url", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestFeedCountField() {
            return this.requestFeedCountField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestFeedCountField(boolean value) {
            this.requestField("feed_count", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestFlightCatalogSettingsField() {
            return this.requestFlightCatalogSettingsField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestFlightCatalogSettingsField(boolean value) {
            this.requestField("flight_catalog_settings", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestImagePaddingLandscapeField() {
            return this.requestImagePaddingLandscapeField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestImagePaddingLandscapeField(boolean value) {
            this.requestField("image_padding_landscape", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestImagePaddingSquareField() {
            return this.requestImagePaddingSquareField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestImagePaddingSquareField(boolean value) {
            this.requestField("image_padding_square", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestProductCountField() {
            return this.requestProductCountField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestProductCountField(boolean value) {
            this.requestField("product_count", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestQualifiedProductCountField() {
            return this.requestQualifiedProductCountField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestQualifiedProductCountField(boolean value) {
            this.requestField("qualified_product_count", value);
            return this;
        }

        public APIRequestGetAssignedProductCatalogs requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGetAssignedProductCatalogs requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAssignedPages
    extends APIRequest<Page> {
        APINodeList<Page> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"about", "access_token", "ad_campaign", "affiliation", "app_id", "app_links", "artists_we_like", "attire", "awards", "band_interests", "band_members", "best_page", "bio", "birthday", "booking_agent", "built", "business", "can_checkin", "can_post", "category", "category_list", "checkins", "company_overview", "connected_instagram_account", "contact_address", "context", "copyright_attribution_insights", "copyright_whitelisted_ig_partners", "country_page_likes", "cover", "culinary_team", "current_location", "description", "description_html", "directed_by", "display_subtext", "displayed_message_response_time", "emails", "engagement", "fan_count", "featured_video", "features", "food_styles", "founded", "general_info", "general_manager", "genre", "global_brand_page_name", "global_brand_parent_page", "global_brand_root_id", "has_added_app", "has_whatsapp_business_number", "has_whatsapp_number", "hometown", "hours", "id", "impressum", "influences", "instagram_business_account", "instant_articles_review_status", "is_always_open", "is_chain", "is_community_page", "is_eligible_for_branded_content", "is_messenger_bot_get_started_enabled", "is_messenger_platform_bot", "is_owned", "is_permanently_closed", "is_published", "is_unclaimed", "is_verified", "is_webhooks_subscribed", "keywords", "leadgen_form_preview_details", "leadgen_has_crm_integration", "leadgen_has_fat_ping_crm_integration", "leadgen_tos_acceptance_time", "leadgen_tos_accepted", "leadgen_tos_accepting_user", "link", "location", "members", "merchant_id", "merchant_review_status", "messenger_ads_default_icebreakers", "messenger_ads_default_page_welcome_message", "messenger_ads_default_quick_replies", "messenger_ads_quick_replies_type", "mission", "mpg", "name", "name_with_location_descriptor", "network", "new_like_count", "offer_eligible", "overall_star_rating", "page_token", "parent_page", "parking", "payment_options", "personal_info", "personal_interests", "pharma_safety_info", "phone", "place_type", "plot_outline", "preferred_audience", "press_contact", "price_range", "produced_by", "products", "promotion_eligible", "promotion_ineligible_reason", "public_transit", "publisher_space", "rating_count", "recipient", "record_label", "release_date", "restaurant_services", "restaurant_specialties", "schedule", "screenplay_by", "season", "single_line_address", "starring", "start_info", "store_code", "store_location_descriptor", "store_number", "studio", "supports_instant_articles", "talking_about_count", "unread_message_count", "unread_notif_count", "unseen_message_count", "username", "verification_status", "voip_info", "website", "were_here_count", "whatsapp_number", "written_by"};

        @Override
        public APINodeList<Page> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Page> parseResponse(String response) throws APIException {
            return Page.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<Page> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<Page>>(){

                public APINodeList<Page> apply(String result) {
                    try {
                        return APIRequestGetAssignedPages.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAssignedPages(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_pages", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAssignedPages setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAssignedPages setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAssignedPages requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAssignedPages requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedPages requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAssignedPages requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedPages requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAssignedPages requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAssignedPages requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetAssignedPages requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetAssignedPages requestAccessTokenField() {
            return this.requestAccessTokenField(true);
        }

        public APIRequestGetAssignedPages requestAccessTokenField(boolean value) {
            this.requestField("access_token", value);
            return this;
        }

        public APIRequestGetAssignedPages requestAdCampaignField() {
            return this.requestAdCampaignField(true);
        }

        public APIRequestGetAssignedPages requestAdCampaignField(boolean value) {
            this.requestField("ad_campaign", value);
            return this;
        }

        public APIRequestGetAssignedPages requestAffiliationField() {
            return this.requestAffiliationField(true);
        }

        public APIRequestGetAssignedPages requestAffiliationField(boolean value) {
            this.requestField("affiliation", value);
            return this;
        }

        public APIRequestGetAssignedPages requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetAssignedPages requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetAssignedPages requestAppLinksField() {
            return this.requestAppLinksField(true);
        }

        public APIRequestGetAssignedPages requestAppLinksField(boolean value) {
            this.requestField("app_links", value);
            return this;
        }

        public APIRequestGetAssignedPages requestArtistsWeLikeField() {
            return this.requestArtistsWeLikeField(true);
        }

        public APIRequestGetAssignedPages requestArtistsWeLikeField(boolean value) {
            this.requestField("artists_we_like", value);
            return this;
        }

        public APIRequestGetAssignedPages requestAttireField() {
            return this.requestAttireField(true);
        }

        public APIRequestGetAssignedPages requestAttireField(boolean value) {
            this.requestField("attire", value);
            return this;
        }

        public APIRequestGetAssignedPages requestAwardsField() {
            return this.requestAwardsField(true);
        }

        public APIRequestGetAssignedPages requestAwardsField(boolean value) {
            this.requestField("awards", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBandInterestsField() {
            return this.requestBandInterestsField(true);
        }

        public APIRequestGetAssignedPages requestBandInterestsField(boolean value) {
            this.requestField("band_interests", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBandMembersField() {
            return this.requestBandMembersField(true);
        }

        public APIRequestGetAssignedPages requestBandMembersField(boolean value) {
            this.requestField("band_members", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBestPageField() {
            return this.requestBestPageField(true);
        }

        public APIRequestGetAssignedPages requestBestPageField(boolean value) {
            this.requestField("best_page", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetAssignedPages requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetAssignedPages requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBookingAgentField() {
            return this.requestBookingAgentField(true);
        }

        public APIRequestGetAssignedPages requestBookingAgentField(boolean value) {
            this.requestField("booking_agent", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBuiltField() {
            return this.requestBuiltField(true);
        }

        public APIRequestGetAssignedPages requestBuiltField(boolean value) {
            this.requestField("built", value);
            return this;
        }

        public APIRequestGetAssignedPages requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAssignedPages requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCanCheckinField() {
            return this.requestCanCheckinField(true);
        }

        public APIRequestGetAssignedPages requestCanCheckinField(boolean value) {
            this.requestField("can_checkin", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetAssignedPages requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetAssignedPages requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCategoryListField() {
            return this.requestCategoryListField(true);
        }

        public APIRequestGetAssignedPages requestCategoryListField(boolean value) {
            this.requestField("category_list", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCheckinsField() {
            return this.requestCheckinsField(true);
        }

        public APIRequestGetAssignedPages requestCheckinsField(boolean value) {
            this.requestField("checkins", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCompanyOverviewField() {
            return this.requestCompanyOverviewField(true);
        }

        public APIRequestGetAssignedPages requestCompanyOverviewField(boolean value) {
            this.requestField("company_overview", value);
            return this;
        }

        public APIRequestGetAssignedPages requestConnectedInstagramAccountField() {
            return this.requestConnectedInstagramAccountField(true);
        }

        public APIRequestGetAssignedPages requestConnectedInstagramAccountField(boolean value) {
            this.requestField("connected_instagram_account", value);
            return this;
        }

        public APIRequestGetAssignedPages requestContactAddressField() {
            return this.requestContactAddressField(true);
        }

        public APIRequestGetAssignedPages requestContactAddressField(boolean value) {
            this.requestField("contact_address", value);
            return this;
        }

        public APIRequestGetAssignedPages requestContextField() {
            return this.requestContextField(true);
        }

        public APIRequestGetAssignedPages requestContextField(boolean value) {
            this.requestField("context", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCopyrightAttributionInsightsField() {
            return this.requestCopyrightAttributionInsightsField(true);
        }

        public APIRequestGetAssignedPages requestCopyrightAttributionInsightsField(boolean value) {
            this.requestField("copyright_attribution_insights", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCopyrightWhitelistedIgPartnersField() {
            return this.requestCopyrightWhitelistedIgPartnersField(true);
        }

        public APIRequestGetAssignedPages requestCopyrightWhitelistedIgPartnersField(boolean value) {
            this.requestField("copyright_whitelisted_ig_partners", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCountryPageLikesField() {
            return this.requestCountryPageLikesField(true);
        }

        public APIRequestGetAssignedPages requestCountryPageLikesField(boolean value) {
            this.requestField("country_page_likes", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetAssignedPages requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCulinaryTeamField() {
            return this.requestCulinaryTeamField(true);
        }

        public APIRequestGetAssignedPages requestCulinaryTeamField(boolean value) {
            this.requestField("culinary_team", value);
            return this;
        }

        public APIRequestGetAssignedPages requestCurrentLocationField() {
            return this.requestCurrentLocationField(true);
        }

        public APIRequestGetAssignedPages requestCurrentLocationField(boolean value) {
            this.requestField("current_location", value);
            return this;
        }

        public APIRequestGetAssignedPages requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetAssignedPages requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetAssignedPages requestDescriptionHtmlField() {
            return this.requestDescriptionHtmlField(true);
        }

        public APIRequestGetAssignedPages requestDescriptionHtmlField(boolean value) {
            this.requestField("description_html", value);
            return this;
        }

        public APIRequestGetAssignedPages requestDirectedByField() {
            return this.requestDirectedByField(true);
        }

        public APIRequestGetAssignedPages requestDirectedByField(boolean value) {
            this.requestField("directed_by", value);
            return this;
        }

        public APIRequestGetAssignedPages requestDisplaySubtextField() {
            return this.requestDisplaySubtextField(true);
        }

        public APIRequestGetAssignedPages requestDisplaySubtextField(boolean value) {
            this.requestField("display_subtext", value);
            return this;
        }

        public APIRequestGetAssignedPages requestDisplayedMessageResponseTimeField() {
            return this.requestDisplayedMessageResponseTimeField(true);
        }

        public APIRequestGetAssignedPages requestDisplayedMessageResponseTimeField(boolean value) {
            this.requestField("displayed_message_response_time", value);
            return this;
        }

        public APIRequestGetAssignedPages requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGetAssignedPages requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGetAssignedPages requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGetAssignedPages requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGetAssignedPages requestFanCountField() {
            return this.requestFanCountField(true);
        }

        public APIRequestGetAssignedPages requestFanCountField(boolean value) {
            this.requestField("fan_count", value);
            return this;
        }

        public APIRequestGetAssignedPages requestFeaturedVideoField() {
            return this.requestFeaturedVideoField(true);
        }

        public APIRequestGetAssignedPages requestFeaturedVideoField(boolean value) {
            this.requestField("featured_video", value);
            return this;
        }

        public APIRequestGetAssignedPages requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGetAssignedPages requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGetAssignedPages requestFoodStylesField() {
            return this.requestFoodStylesField(true);
        }

        public APIRequestGetAssignedPages requestFoodStylesField(boolean value) {
            this.requestField("food_styles", value);
            return this;
        }

        public APIRequestGetAssignedPages requestFoundedField() {
            return this.requestFoundedField(true);
        }

        public APIRequestGetAssignedPages requestFoundedField(boolean value) {
            this.requestField("founded", value);
            return this;
        }

        public APIRequestGetAssignedPages requestGeneralInfoField() {
            return this.requestGeneralInfoField(true);
        }

        public APIRequestGetAssignedPages requestGeneralInfoField(boolean value) {
            this.requestField("general_info", value);
            return this;
        }

        public APIRequestGetAssignedPages requestGeneralManagerField() {
            return this.requestGeneralManagerField(true);
        }

        public APIRequestGetAssignedPages requestGeneralManagerField(boolean value) {
            this.requestField("general_manager", value);
            return this;
        }

        public APIRequestGetAssignedPages requestGenreField() {
            return this.requestGenreField(true);
        }

        public APIRequestGetAssignedPages requestGenreField(boolean value) {
            this.requestField("genre", value);
            return this;
        }

        public APIRequestGetAssignedPages requestGlobalBrandPageNameField() {
            return this.requestGlobalBrandPageNameField(true);
        }

        public APIRequestGetAssignedPages requestGlobalBrandPageNameField(boolean value) {
            this.requestField("global_brand_page_name", value);
            return this;
        }

        public APIRequestGetAssignedPages requestGlobalBrandParentPageField() {
            return this.requestGlobalBrandParentPageField(true);
        }

        public APIRequestGetAssignedPages requestGlobalBrandParentPageField(boolean value) {
            this.requestField("global_brand_parent_page", value);
            return this;
        }

        public APIRequestGetAssignedPages requestGlobalBrandRootIdField() {
            return this.requestGlobalBrandRootIdField(true);
        }

        public APIRequestGetAssignedPages requestGlobalBrandRootIdField(boolean value) {
            this.requestField("global_brand_root_id", value);
            return this;
        }

        public APIRequestGetAssignedPages requestHasAddedAppField() {
            return this.requestHasAddedAppField(true);
        }

        public APIRequestGetAssignedPages requestHasAddedAppField(boolean value) {
            this.requestField("has_added_app", value);
            return this;
        }

        public APIRequestGetAssignedPages requestHasWhatsappBusinessNumberField() {
            return this.requestHasWhatsappBusinessNumberField(true);
        }

        public APIRequestGetAssignedPages requestHasWhatsappBusinessNumberField(boolean value) {
            this.requestField("has_whatsapp_business_number", value);
            return this;
        }

        public APIRequestGetAssignedPages requestHasWhatsappNumberField() {
            return this.requestHasWhatsappNumberField(true);
        }

        public APIRequestGetAssign