/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetingGeoLocationCity
extends APINode {
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="distance_unit")
    private String mDistanceUnit = null;
    @SerializedName(value="key")
    private String mKey = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="radius")
    private Long mRadius = null;
    @SerializedName(value="region")
    private String mRegion = null;
    @SerializedName(value="region_id")
    private String mRegionId = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    TargetingGeoLocationCity() {
    }

    public TargetingGeoLocationCity(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public TargetingGeoLocationCity(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public TargetingGeoLocationCity fetch() throws APIException {
        TargetingGeoLocationCity newInstance = TargetingGeoLocationCity.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static TargetingGeoLocationCity fetchById(Long id, APIContext context) throws APIException {
        return TargetingGeoLocationCity.fetchById(id.toString(), context);
    }

    public static ListenableFuture<TargetingGeoLocationCity> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return TargetingGeoLocationCity.fetchByIdAsync(id.toString(), context);
    }

    public static TargetingGeoLocationCity fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<TargetingGeoLocationCity> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<TargetingGeoLocationCity> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<TargetingGeoLocationCity>(context, "", "/", "GET", TargetingGeoLocationCity.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<TargetingGeoLocationCity>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<TargetingGeoLocationCity>(context, "", "/", "GET", TargetingGeoLocationCity.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static TargetingGeoLocationCity loadJSON(String json, APIContext context) {
        TargetingGeoLocationCity targetingGeoLocationCity = (TargetingGeoLocationCity)TargetingGeoLocationCity.getGson().fromJson(json, TargetingGeoLocationCity.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(targetingGeoLocationCity.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        targetingGeoLocationCity.context = context;
        targetingGeoLocationCity.rawValue = json;
        return targetingGeoLocationCity;
    }

    public static APINodeList<TargetingGeoLocationCity> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<TargetingGeoLocationCity> targetingGeoLocationCitys = new APINodeList<TargetingGeoLocationCity>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        targetingGeoLocationCitys.add(TargetingGeoLocationCity.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return targetingGeoLocationCitys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            targetingGeoLocationCitys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        targetingGeoLocationCitys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            targetingGeoLocationCitys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            targetingGeoLocationCitys.add(TargetingGeoLocationCity.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                targetingGeoLocationCitys.add(TargetingGeoLocationCity.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            targetingGeoLocationCitys.add(TargetingGeoLocationCity.loadJSON(obj.toString(), context));
                        }
                    }
                    return targetingGeoLocationCitys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        targetingGeoLocationCitys.add(TargetingGeoLocationCity.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return targetingGeoLocationCitys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        targetingGeoLocationCitys.add(TargetingGeoLocationCity.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return targetingGeoLocationCitys;
                }
                targetingGeoLocationCitys.clear();
                targetingGeoLocationCitys.add(TargetingGeoLocationCity.loadJSON(json, context));
                return targetingGeoLocationCitys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return TargetingGeoLocationCity.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public String getFieldDistanceUnit() {
        return this.mDistanceUnit;
    }

    public String getFieldKey() {
        return this.mKey;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Long getFieldRadius() {
        return this.mRadius;
    }

    public String getFieldRegion() {
        return this.mRegion;
    }

    public String getFieldRegionId() {
        return this.mRegionId;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public TargetingGeoLocationCity copyFrom(TargetingGeoLocationCity instance) {
        this.mCountry = instance.mCountry;
        this.mDistanceUnit = instance.mDistanceUnit;
        this.mKey = instance.mKey;
        this.mName = instance.mName;
        this.mRadius = instance.mRadius;
        this.mRegion = instance.mRegion;
        this.mRegionId = instance.mRegionId;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<TargetingGeoLocationCity> getParser() {
        return new APIRequest.ResponseParser<TargetingGeoLocationCity>(){

            @Override
            public APINodeList<TargetingGeoLocationCity> parseResponse(String response, APIContext context, APIRequest<TargetingGeoLocationCity> request) throws APIException.MalformedResponseException {
                return TargetingGeoLocationCity.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<TargetingGeoLocationCity> {
        TargetingGeoLocationCity lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"country", "distance_unit", "key", "name", "radius", "region", "region_id", "id"};

        @Override
        public TargetingGeoLocationCity getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public TargetingGeoLocationCity parseResponse(String response) throws APIException {
            return TargetingGeoLocationCity.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public TargetingGeoLocationCity execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public TargetingGeoLocationCity execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<TargetingGeoLocationCity> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<TargetingGeoLocationCity> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, TargetingGeoLocationCity>(){

                public TargetingGeoLocationCity apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGet requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGet requestDistanceUnitField() {
            return this.requestDistanceUnitField(true);
        }

        public APIRequestGet requestDistanceUnitField(boolean value) {
            this.requestField("distance_unit", value);
            return this;
        }

        public APIRequestGet requestKeyField() {
            return this.requestKeyField(true);
        }

        public APIRequestGet requestKeyField(boolean value) {
            this.requestField("key", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestRadiusField() {
            return this.requestRadiusField(true);
        }

        public APIRequestGet requestRadiusField(boolean value) {
            this.requestField("radius", value);
            return this;
        }

        public APIRequestGet requestRegionField() {
            return this.requestRegionField(true);
        }

        public APIRequestGet requestRegionField(boolean value) {
            this.requestField("region", value);
            return this;
        }

        public APIRequestGet requestRegionIdField() {
            return this.requestRegionIdField(true);
        }

        public APIRequestGet requestRegionIdField(boolean value) {
            this.requestField("region_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

