/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReachFrequencyActivity
extends APINode {
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="campaign_active")
    private Boolean mCampaignActive = null;
    @SerializedName(value="campaign_started")
    private Boolean mCampaignStarted = null;
    @SerializedName(value="creative_uploaded")
    private Boolean mCreativeUploaded = null;
    @SerializedName(value="delivered_budget")
    private Long mDeliveredBudget = null;
    @SerializedName(value="delivered_daily_grp")
    private List<Double> mDeliveredDailyGrp = null;
    @SerializedName(value="delivered_daily_impression")
    private List<Double> mDeliveredDailyImpression = null;
    @SerializedName(value="delivered_impression")
    private Long mDeliveredImpression = null;
    @SerializedName(value="delivered_reach")
    private Long mDeliveredReach = null;
    @SerializedName(value="delivered_total_impression")
    private Long mDeliveredTotalImpression = null;
    @SerializedName(value="io_approved")
    private Boolean mIoApproved = null;
    @SerializedName(value="sf_link")
    private String mSfLink = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    ReachFrequencyActivity() {
    }

    public ReachFrequencyActivity(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ReachFrequencyActivity(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ReachFrequencyActivity fetch() throws APIException {
        ReachFrequencyActivity newInstance = ReachFrequencyActivity.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ReachFrequencyActivity fetchById(Long id, APIContext context) throws APIException {
        return ReachFrequencyActivity.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ReachFrequencyActivity> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ReachFrequencyActivity.fetchByIdAsync(id.toString(), context);
    }

    public static ReachFrequencyActivity fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ReachFrequencyActivity> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ReachFrequencyActivity> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ReachFrequencyActivity>(context, "", "/", "GET", ReachFrequencyActivity.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ReachFrequencyActivity>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ReachFrequencyActivity>(context, "", "/", "GET", ReachFrequencyActivity.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ReachFrequencyActivity loadJSON(String json, APIContext context) {
        ReachFrequencyActivity reachFrequencyActivity = (ReachFrequencyActivity)ReachFrequencyActivity.getGson().fromJson(json, ReachFrequencyActivity.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(reachFrequencyActivity.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        reachFrequencyActivity.context = context;
        reachFrequencyActivity.rawValue = json;
        return reachFrequencyActivity;
    }

    public static APINodeList<ReachFrequencyActivity> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ReachFrequencyActivity> reachFrequencyActivitys = new APINodeList<ReachFrequencyActivity>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        reachFrequencyActivitys.add(ReachFrequencyActivity.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return reachFrequencyActivitys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            reachFrequencyActivitys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        reachFrequencyActivitys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            reachFrequencyActivitys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            reachFrequencyActivitys.add(ReachFrequencyActivity.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                reachFrequencyActivitys.add(ReachFrequencyActivity.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            reachFrequencyActivitys.add(ReachFrequencyActivity.loadJSON(obj.toString(), context));
                        }
                    }
                    return reachFrequencyActivitys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        reachFrequencyActivitys.add(ReachFrequencyActivity.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return reachFrequencyActivitys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        reachFrequencyActivitys.add(ReachFrequencyActivity.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return reachFrequencyActivitys;
                }
                reachFrequencyActivitys.clear();
                reachFrequencyActivitys.add(ReachFrequencyActivity.loadJSON(json, context));
                return reachFrequencyActivitys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ReachFrequencyActivity.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public Boolean getFieldCampaignActive() {
        return this.mCampaignActive;
    }

    public Boolean getFieldCampaignStarted() {
        return this.mCampaignStarted;
    }

    public Boolean getFieldCreativeUploaded() {
        return this.mCreativeUploaded;
    }

    public Long getFieldDeliveredBudget() {
        return this.mDeliveredBudget;
    }

    public List<Double> getFieldDeliveredDailyGrp() {
        return this.mDeliveredDailyGrp;
    }

    public List<Double> getFieldDeliveredDailyImpression() {
        return this.mDeliveredDailyImpression;
    }

    public Long getFieldDeliveredImpression() {
        return this.mDeliveredImpression;
    }

    public Long getFieldDeliveredReach() {
        return this.mDeliveredReach;
    }

    public Long getFieldDeliveredTotalImpression() {
        return this.mDeliveredTotalImpression;
    }

    public Boolean getFieldIoApproved() {
        return this.mIoApproved;
    }

    public String getFieldSfLink() {
        return this.mSfLink;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ReachFrequencyActivity copyFrom(ReachFrequencyActivity instance) {
        this.mAccountId = instance.mAccountId;
        this.mCampaignActive = instance.mCampaignActive;
        this.mCampaignStarted = instance.mCampaignStarted;
        this.mCreativeUploaded = instance.mCreativeUploaded;
        this.mDeliveredBudget = instance.mDeliveredBudget;
        this.mDeliveredDailyGrp = instance.mDeliveredDailyGrp;
        this.mDeliveredDailyImpression = instance.mDeliveredDailyImpression;
        this.mDeliveredImpression = instance.mDeliveredImpression;
        this.mDeliveredReach = instance.mDeliveredReach;
        this.mDeliveredTotalImpression = instance.mDeliveredTotalImpression;
        this.mIoApproved = instance.mIoApproved;
        this.mSfLink = instance.mSfLink;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ReachFrequencyActivity> getParser() {
        return new APIRequest.ResponseParser<ReachFrequencyActivity>(){

            @Override
            public APINodeList<ReachFrequencyActivity> parseResponse(String response, APIContext context, APIRequest<ReachFrequencyActivity> request) throws APIException.MalformedResponseException {
                return ReachFrequencyActivity.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ReachFrequencyActivity> {
        ReachFrequencyActivity lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_id", "campaign_active", "campaign_started", "creative_uploaded", "delivered_budget", "delivered_daily_grp", "delivered_daily_impression", "delivered_impression", "delivered_reach", "delivered_total_impression", "io_approved", "sf_link", "id"};

        @Override
        public ReachFrequencyActivity getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ReachFrequencyActivity parseResponse(String response) throws APIException {
            return ReachFrequencyActivity.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ReachFrequencyActivity execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ReachFrequencyActivity execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ReachFrequencyActivity> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ReachFrequencyActivity> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ReachFrequencyActivity>(){

                public ReachFrequencyActivity apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestCampaignActiveField() {
            return this.requestCampaignActiveField(true);
        }

        public APIRequestGet requestCampaignActiveField(boolean value) {
            this.requestField("campaign_active", value);
            return this;
        }

        public APIRequestGet requestCampaignStartedField() {
            return this.requestCampaignStartedField(true);
        }

        public APIRequestGet requestCampaignStartedField(boolean value) {
            this.requestField("campaign_started", value);
            return this;
        }

        public APIRequestGet requestCreativeUploadedField() {
            return this.requestCreativeUploadedField(true);
        }

        public APIRequestGet requestCreativeUploadedField(boolean value) {
            this.requestField("creative_uploaded", value);
            return this;
        }

        public APIRequestGet requestDeliveredBudgetField() {
            return this.requestDeliveredBudgetField(true);
        }

        public APIRequestGet requestDeliveredBudgetField(boolean value) {
            this.requestField("delivered_budget", value);
            return this;
        }

        public APIRequestGet requestDeliveredDailyGrpField() {
            return this.requestDeliveredDailyGrpField(true);
        }

        public APIRequestGet requestDeliveredDailyGrpField(boolean value) {
            this.requestField("delivered_daily_grp", value);
            return this;
        }

        public APIRequestGet requestDeliveredDailyImpressionField() {
            return this.requestDeliveredDailyImpressionField(true);
        }

        public APIRequestGet requestDeliveredDailyImpressionField(boolean value) {
            this.requestField("delivered_daily_impression", value);
            return this;
        }

        public APIRequestGet requestDeliveredImpressionField() {
            return this.requestDeliveredImpressionField(true);
        }

        public APIRequestGet requestDeliveredImpressionField(boolean value) {
            this.requestField("delivered_impression", value);
            return this;
        }

        public APIRequestGet requestDeliveredReachField() {
            return this.requestDeliveredReachField(true);
        }

        public APIRequestGet requestDeliveredReachField(boolean value) {
            this.requestField("delivered_reach", value);
            return this;
        }

        public APIRequestGet requestDeliveredTotalImpressionField() {
            return this.requestDeliveredTotalImpressionField(true);
        }

        public APIRequestGet requestDeliveredTotalImpressionField(boolean value) {
            this.requestField("delivered_total_impression", value);
            return this;
        }

        public APIRequestGet requestIoApprovedField() {
            return this.requestIoApprovedField(true);
        }

        public APIRequestGet requestIoApprovedField(boolean value) {
            this.requestField("io_approved", value);
            return this;
        }

        public APIRequestGet requestSfLinkField() {
            return this.requestSfLinkField(true);
        }

        public APIRequestGet requestSfLinkField(boolean value) {
            this.requestField("sf_link", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

