/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Canvas;
import com.facebook.ads.sdk.Photo;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeadGenContextCard
extends APINode {
    @SerializedName(value="button_text")
    private String mButtonText = null;
    @SerializedName(value="canvas")
    private Canvas mCanvas = null;
    @SerializedName(value="canvas_jump_to_form_button_text")
    private String mCanvasJumpToFormButtonText = null;
    @SerializedName(value="content")
    private List<String> mContent = null;
    @SerializedName(value="cover_photo")
    private Photo mCoverPhoto = null;
    @SerializedName(value="format")
    private String mFormat = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="style")
    private String mStyle = null;
    @SerializedName(value="title")
    private String mTitle = null;
    protected static Gson gson = null;

    LeadGenContextCard() {
    }

    public LeadGenContextCard(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public LeadGenContextCard(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public LeadGenContextCard fetch() throws APIException {
        LeadGenContextCard newInstance = LeadGenContextCard.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static LeadGenContextCard fetchById(Long id, APIContext context) throws APIException {
        return LeadGenContextCard.fetchById(id.toString(), context);
    }

    public static ListenableFuture<LeadGenContextCard> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return LeadGenContextCard.fetchByIdAsync(id.toString(), context);
    }

    public static LeadGenContextCard fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<LeadGenContextCard> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<LeadGenContextCard> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<LeadGenContextCard>(context, "", "/", "GET", LeadGenContextCard.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<LeadGenContextCard>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<LeadGenContextCard>(context, "", "/", "GET", LeadGenContextCard.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static LeadGenContextCard loadJSON(String json, APIContext context) {
        LeadGenContextCard leadGenContextCard = (LeadGenContextCard)LeadGenContextCard.getGson().fromJson(json, LeadGenContextCard.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(leadGenContextCard.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        leadGenContextCard.context = context;
        leadGenContextCard.rawValue = json;
        return leadGenContextCard;
    }

    public static APINodeList<LeadGenContextCard> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LeadGenContextCard> leadGenContextCards = new APINodeList<LeadGenContextCard>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        leadGenContextCards.add(LeadGenContextCard.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return leadGenContextCards;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            leadGenContextCards.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        leadGenContextCards.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            leadGenContextCards.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            leadGenContextCards.add(LeadGenContextCard.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                leadGenContextCards.add(LeadGenContextCard.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            leadGenContextCards.add(LeadGenContextCard.loadJSON(obj.toString(), context));
                        }
                    }
                    return leadGenContextCards;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        leadGenContextCards.add(LeadGenContextCard.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return leadGenContextCards;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        leadGenContextCards.add(LeadGenContextCard.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return leadGenContextCards;
                }
                leadGenContextCards.clear();
                leadGenContextCards.add(LeadGenContextCard.loadJSON(json, context));
                return leadGenContextCards;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LeadGenContextCard.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldButtonText() {
        return this.mButtonText;
    }

    public Canvas getFieldCanvas() {
        if (this.mCanvas != null) {
            this.mCanvas.context = this.getContext();
        }
        return this.mCanvas;
    }

    public String getFieldCanvasJumpToFormButtonText() {
        return this.mCanvasJumpToFormButtonText;
    }

    public List<String> getFieldContent() {
        return this.mContent;
    }

    public Photo getFieldCoverPhoto() {
        if (this.mCoverPhoto != null) {
            this.mCoverPhoto.context = this.getContext();
        }
        return this.mCoverPhoto;
    }

    public String getFieldFormat() {
        return this.mFormat;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldStyle() {
        return this.mStyle;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LeadGenContextCard copyFrom(LeadGenContextCard instance) {
        this.mButtonText = instance.mButtonText;
        this.mCanvas = instance.mCanvas;
        this.mCanvasJumpToFormButtonText = instance.mCanvasJumpToFormButtonText;
        this.mContent = instance.mContent;
        this.mCoverPhoto = instance.mCoverPhoto;
        this.mFormat = instance.mFormat;
        this.mId = instance.mId;
        this.mStyle = instance.mStyle;
        this.mTitle = instance.mTitle;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LeadGenContextCard> getParser() {
        return new APIRequest.ResponseParser<LeadGenContextCard>(){

            @Override
            public APINodeList<LeadGenContextCard> parseResponse(String response, APIContext context, APIRequest<LeadGenContextCard> request) throws APIException.MalformedResponseException {
                return LeadGenContextCard.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStyle {
        VALUE_LIST_STYLE("LIST_STYLE"),
        VALUE_PARAGRAPH_STYLE("PARAGRAPH_STYLE"),
        NULL(null);

        private String value;

        private EnumStyle(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStatus {
        VALUE_ACTIVE("ACTIVE"),
        VALUE_ARCHIVED("ARCHIVED"),
        VALUE_DELETED("DELETED"),
        VALUE_DRAFT("DRAFT"),
        NULL(null);

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<LeadGenContextCard> {
        LeadGenContextCard lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"button_text", "canvas", "canvas_jump_to_form_button_text", "content", "cover_photo", "format", "id", "style", "title"};

        @Override
        public LeadGenContextCard getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public LeadGenContextCard parseResponse(String response) throws APIException {
            return LeadGenContextCard.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public LeadGenContextCard execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public LeadGenContextCard execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<LeadGenContextCard> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<LeadGenContextCard> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, LeadGenContextCard>(){

                public LeadGenContextCard apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestButtonTextField() {
            return this.requestButtonTextField(true);
        }

        public APIRequestGet requestButtonTextField(boolean value) {
            this.requestField("button_text", value);
            return this;
        }

        public APIRequestGet requestCanvasField() {
            return this.requestCanvasField(true);
        }

        public APIRequestGet requestCanvasField(boolean value) {
            this.requestField("canvas", value);
            return this;
        }

        public APIRequestGet requestCanvasJumpToFormButtonTextField() {
            return this.requestCanvasJumpToFormButtonTextField(true);
        }

        public APIRequestGet requestCanvasJumpToFormButtonTextField(boolean value) {
            this.requestField("canvas_jump_to_form_button_text", value);
            return this;
        }

        public APIRequestGet requestContentField() {
            return this.requestContentField(true);
        }

        public APIRequestGet requestContentField(boolean value) {
            this.requestField("content", value);
            return this;
        }

        public APIRequestGet requestCoverPhotoField() {
            return this.requestCoverPhotoField(true);
        }

        public APIRequestGet requestCoverPhotoField(boolean value) {
            this.requestField("cover_photo", value);
            return this;
        }

        public APIRequestGet requestFormatField() {
            return this.requestFormatField(true);
        }

        public APIRequestGet requestFormatField(boolean value) {
            this.requestField("format", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestStyleField() {
            return this.requestStyleField(true);
        }

        public APIRequestGet requestStyleField(boolean value) {
            this.requestField("style", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }
    }
}

