/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyrightReferenceContainer
extends APINode {
    @SerializedName(value="content_type")
    private String mContentType = null;
    @SerializedName(value="copyright_creation_time")
    private String mCopyrightCreationTime = null;
    @SerializedName(value="download_hd_url")
    private String mDownloadHdUrl = null;
    @SerializedName(value="duration_in_sec")
    private Double mDurationInSec = null;
    @SerializedName(value="fingerprint_validity")
    private String mFingerprintValidity = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="metadata")
    private Object mMetadata = null;
    @SerializedName(value="published_time")
    private String mPublishedTime = null;
    @SerializedName(value="thumbnail_url")
    private String mThumbnailUrl = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="universal_content_id")
    private String mUniversalContentId = null;
    protected static Gson gson = null;

    CopyrightReferenceContainer() {
    }

    public CopyrightReferenceContainer(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CopyrightReferenceContainer(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CopyrightReferenceContainer fetch() throws APIException {
        CopyrightReferenceContainer newInstance = CopyrightReferenceContainer.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CopyrightReferenceContainer fetchById(Long id, APIContext context) throws APIException {
        return CopyrightReferenceContainer.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CopyrightReferenceContainer> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CopyrightReferenceContainer.fetchByIdAsync(id.toString(), context);
    }

    public static CopyrightReferenceContainer fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CopyrightReferenceContainer> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CopyrightReferenceContainer> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CopyrightReferenceContainer>(context, "", "/", "GET", CopyrightReferenceContainer.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CopyrightReferenceContainer>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CopyrightReferenceContainer>(context, "", "/", "GET", CopyrightReferenceContainer.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CopyrightReferenceContainer loadJSON(String json, APIContext context) {
        CopyrightReferenceContainer copyrightReferenceContainer = (CopyrightReferenceContainer)CopyrightReferenceContainer.getGson().fromJson(json, CopyrightReferenceContainer.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(copyrightReferenceContainer.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        copyrightReferenceContainer.context = context;
        copyrightReferenceContainer.rawValue = json;
        return copyrightReferenceContainer;
    }

    public static APINodeList<CopyrightReferenceContainer> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CopyrightReferenceContainer> copyrightReferenceContainers = new APINodeList<CopyrightReferenceContainer>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        copyrightReferenceContainers.add(CopyrightReferenceContainer.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return copyrightReferenceContainers;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            copyrightReferenceContainers.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        copyrightReferenceContainers.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            copyrightReferenceContainers.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            copyrightReferenceContainers.add(CopyrightReferenceContainer.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                copyrightReferenceContainers.add(CopyrightReferenceContainer.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            copyrightReferenceContainers.add(CopyrightReferenceContainer.loadJSON(obj.toString(), context));
                        }
                    }
                    return copyrightReferenceContainers;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        copyrightReferenceContainers.add(CopyrightReferenceContainer.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return copyrightReferenceContainers;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        copyrightReferenceContainers.add(CopyrightReferenceContainer.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return copyrightReferenceContainers;
                }
                copyrightReferenceContainers.clear();
                copyrightReferenceContainers.add(CopyrightReferenceContainer.loadJSON(json, context));
                return copyrightReferenceContainers;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CopyrightReferenceContainer.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldContentType() {
        return this.mContentType;
    }

    public String getFieldCopyrightCreationTime() {
        return this.mCopyrightCreationTime;
    }

    public String getFieldDownloadHdUrl() {
        return this.mDownloadHdUrl;
    }

    public Double getFieldDurationInSec() {
        return this.mDurationInSec;
    }

    public String getFieldFingerprintValidity() {
        return this.mFingerprintValidity;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Object getFieldMetadata() {
        return this.mMetadata;
    }

    public String getFieldPublishedTime() {
        return this.mPublishedTime;
    }

    public String getFieldThumbnailUrl() {
        return this.mThumbnailUrl;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public String getFieldUniversalContentId() {
        return this.mUniversalContentId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CopyrightReferenceContainer copyFrom(CopyrightReferenceContainer instance) {
        this.mContentType = instance.mContentType;
        this.mCopyrightCreationTime = instance.mCopyrightCreationTime;
        this.mDownloadHdUrl = instance.mDownloadHdUrl;
        this.mDurationInSec = instance.mDurationInSec;
        this.mFingerprintValidity = instance.mFingerprintValidity;
        this.mId = instance.mId;
        this.mMetadata = instance.mMetadata;
        this.mPublishedTime = instance.mPublishedTime;
        this.mThumbnailUrl = instance.mThumbnailUrl;
        this.mTitle = instance.mTitle;
        this.mUniversalContentId = instance.mUniversalContentId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CopyrightReferenceContainer> getParser() {
        return new APIRequest.ResponseParser<CopyrightReferenceContainer>(){

            @Override
            public APINodeList<CopyrightReferenceContainer> parseResponse(String response, APIContext context, APIRequest<CopyrightReferenceContainer> request) throws APIException.MalformedResponseException {
                return CopyrightReferenceContainer.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<CopyrightReferenceContainer> {
        CopyrightReferenceContainer lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"content_type", "copyright_creation_time", "download_hd_url", "duration_in_sec", "fingerprint_validity", "id", "metadata", "published_time", "thumbnail_url", "title", "universal_content_id"};

        @Override
        public CopyrightReferenceContainer getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CopyrightReferenceContainer parseResponse(String response) throws APIException {
            return CopyrightReferenceContainer.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public CopyrightReferenceContainer execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CopyrightReferenceContainer execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<CopyrightReferenceContainer> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CopyrightReferenceContainer> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CopyrightReferenceContainer>(){

                public CopyrightReferenceContainer apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestContentTypeField() {
            return this.requestContentTypeField(true);
        }

        public APIRequestGet requestContentTypeField(boolean value) {
            this.requestField("content_type", value);
            return this;
        }

        public APIRequestGet requestCopyrightCreationTimeField() {
            return this.requestCopyrightCreationTimeField(true);
        }

        public APIRequestGet requestCopyrightCreationTimeField(boolean value) {
            this.requestField("copyright_creation_time", value);
            return this;
        }

        public APIRequestGet requestDownloadHdUrlField() {
            return this.requestDownloadHdUrlField(true);
        }

        public APIRequestGet requestDownloadHdUrlField(boolean value) {
            this.requestField("download_hd_url", value);
            return this;
        }

        public APIRequestGet requestDurationInSecField() {
            return this.requestDurationInSecField(true);
        }

        public APIRequestGet requestDurationInSecField(boolean value) {
            this.requestField("duration_in_sec", value);
            return this;
        }

        public APIRequestGet requestFingerprintValidityField() {
            return this.requestFingerprintValidityField(true);
        }

        public APIRequestGet requestFingerprintValidityField(boolean value) {
            this.requestField("fingerprint_validity", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestMetadataField() {
            return this.requestMetadataField(true);
        }

        public APIRequestGet requestMetadataField(boolean value) {
            this.requestField("metadata", value);
            return this;
        }

        public APIRequestGet requestPublishedTimeField() {
            return this.requestPublishedTimeField(true);
        }

        public APIRequestGet requestPublishedTimeField(boolean value) {
            this.requestField("published_time", value);
            return this;
        }

        public APIRequestGet requestThumbnailUrlField() {
            return this.requestThumbnailUrlField(true);
        }

        public APIRequestGet requestThumbnailUrlField(boolean value) {
            this.requestField("thumbnail_url", value);
            return this;
        }

        public APIRequestGet requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGet requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGet requestUniversalContentIdField() {
            return this.requestUniversalContentIdField(true);
        }

        public APIRequestGet requestUniversalContentIdField(boolean value) {
            this.requestField("universal_content_id", value);
            return this;
        }
    }
}

