/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockedUserInfo
extends APINode {
    @SerializedName(value="block_time")
    private String mBlockTime = null;
    @SerializedName(value="block_type")
    private String mBlockType = null;
    @SerializedName(value="fbid")
    private String mFbid = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    BlockedUserInfo() {
    }

    public BlockedUserInfo(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public BlockedUserInfo(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public BlockedUserInfo fetch() throws APIException {
        BlockedUserInfo newInstance = BlockedUserInfo.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static BlockedUserInfo fetchById(Long id, APIContext context) throws APIException {
        return BlockedUserInfo.fetchById(id.toString(), context);
    }

    public static ListenableFuture<BlockedUserInfo> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return BlockedUserInfo.fetchByIdAsync(id.toString(), context);
    }

    public static BlockedUserInfo fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<BlockedUserInfo> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<BlockedUserInfo> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<BlockedUserInfo>(context, "", "/", "GET", BlockedUserInfo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<BlockedUserInfo>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<BlockedUserInfo>(context, "", "/", "GET", BlockedUserInfo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BlockedUserInfo loadJSON(String json, APIContext context) {
        BlockedUserInfo blockedUserInfo = (BlockedUserInfo)BlockedUserInfo.getGson().fromJson(json, BlockedUserInfo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(blockedUserInfo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        blockedUserInfo.context = context;
        blockedUserInfo.rawValue = json;
        return blockedUserInfo;
    }

    public static APINodeList<BlockedUserInfo> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BlockedUserInfo> blockedUserInfos = new APINodeList<BlockedUserInfo>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        blockedUserInfos.add(BlockedUserInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return blockedUserInfos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            blockedUserInfos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        blockedUserInfos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            blockedUserInfos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            blockedUserInfos.add(BlockedUserInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                blockedUserInfos.add(BlockedUserInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            blockedUserInfos.add(BlockedUserInfo.loadJSON(obj.toString(), context));
                        }
                    }
                    return blockedUserInfos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        blockedUserInfos.add(BlockedUserInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return blockedUserInfos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        blockedUserInfos.add(BlockedUserInfo.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return blockedUserInfos;
                }
                blockedUserInfos.clear();
                blockedUserInfos.add(BlockedUserInfo.loadJSON(json, context));
                return blockedUserInfos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BlockedUserInfo.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBlockTime() {
        return this.mBlockTime;
    }

    public String getFieldBlockType() {
        return this.mBlockType;
    }

    public String getFieldFbid() {
        return this.mFbid;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BlockedUserInfo copyFrom(BlockedUserInfo instance) {
        this.mBlockTime = instance.mBlockTime;
        this.mBlockType = instance.mBlockType;
        this.mFbid = instance.mFbid;
        this.mName = instance.mName;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BlockedUserInfo> getParser() {
        return new APIRequest.ResponseParser<BlockedUserInfo>(){

            @Override
            public APINodeList<BlockedUserInfo> parseResponse(String response, APIContext context, APIRequest<BlockedUserInfo> request) throws APIException.MalformedResponseException {
                return BlockedUserInfo.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<BlockedUserInfo> {
        BlockedUserInfo lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"block_time", "block_type", "fbid", "name", "id"};

        @Override
        public BlockedUserInfo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public BlockedUserInfo parseResponse(String response) throws APIException {
            return BlockedUserInfo.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public BlockedUserInfo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public BlockedUserInfo execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<BlockedUserInfo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<BlockedUserInfo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, BlockedUserInfo>(){

                public BlockedUserInfo apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBlockTimeField() {
            return this.requestBlockTimeField(true);
        }

        public APIRequestGet requestBlockTimeField(boolean value) {
            this.requestField("block_time", value);
            return this;
        }

        public APIRequestGet requestBlockTypeField() {
            return this.requestBlockTypeField(true);
        }

        public APIRequestGet requestBlockTypeField(boolean value) {
            this.requestField("block_type", value);
            return this;
        }

        public APIRequestGet requestFbidField() {
            return this.requestFbidField(true);
        }

        public APIRequestGet requestFbidField(boolean value) {
            this.requestField("fbid", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

