/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncRequest
extends APINode {
    @SerializedName(value="id")
    private Long mId = null;
    @SerializedName(value="result")
    private String mResult = null;
    @SerializedName(value="status")
    private Long mStatus = null;
    @SerializedName(value="type")
    private Long mType = null;
    protected static Gson gson = null;

    AsyncRequest() {
    }

    public AsyncRequest(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AsyncRequest(String id, APIContext context) {
        this.mId = Long.valueOf(id);
        this.context = context;
    }

    public AsyncRequest fetch() throws APIException {
        AsyncRequest newInstance = AsyncRequest.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AsyncRequest fetchById(Long id, APIContext context) throws APIException {
        return AsyncRequest.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AsyncRequest> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AsyncRequest.fetchByIdAsync(id.toString(), context);
    }

    public static AsyncRequest fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AsyncRequest> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AsyncRequest> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AsyncRequest>(context, "", "/", "GET", AsyncRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AsyncRequest>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AsyncRequest>(context, "", "/", "GET", AsyncRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AsyncRequest loadJSON(String json, APIContext context) {
        AsyncRequest asyncRequest = (AsyncRequest)AsyncRequest.getGson().fromJson(json, AsyncRequest.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(asyncRequest.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        asyncRequest.context = context;
        asyncRequest.rawValue = json;
        return asyncRequest;
    }

    public static APINodeList<AsyncRequest> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AsyncRequest> asyncRequests = new APINodeList<AsyncRequest>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        asyncRequests.add(AsyncRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return asyncRequests;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            asyncRequests.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        asyncRequests.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            asyncRequests.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            asyncRequests.add(AsyncRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                asyncRequests.add(AsyncRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            asyncRequests.add(AsyncRequest.loadJSON(obj.toString(), context));
                        }
                    }
                    return asyncRequests;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        asyncRequests.add(AsyncRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return asyncRequests;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        asyncRequests.add(AsyncRequest.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return asyncRequests;
                }
                asyncRequests.clear();
                asyncRequests.add(AsyncRequest.loadJSON(json, context));
                return asyncRequests;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AsyncRequest.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldId() {
        return this.mId;
    }

    public String getFieldResult() {
        return this.mResult;
    }

    public Long getFieldStatus() {
        return this.mStatus;
    }

    public Long getFieldType() {
        return this.mType;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AsyncRequest copyFrom(AsyncRequest instance) {
        this.mId = instance.mId;
        this.mResult = instance.mResult;
        this.mStatus = instance.mStatus;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AsyncRequest> getParser() {
        return new APIRequest.ResponseParser<AsyncRequest>(){

            @Override
            public APINodeList<AsyncRequest> parseResponse(String response, APIContext context, APIRequest<AsyncRequest> request) throws APIException.MalformedResponseException {
                return AsyncRequest.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_DRAFTS("DRAFTS"),
        VALUE_BATCH_API("BATCH_API"),
        VALUE_ASYNC_ADGROUP_CREATION("ASYNC_ADGROUP_CREATION"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumStatus {
        VALUE_INITIALIZED("INITIALIZED"),
        VALUE_EXECUTING("EXECUTING"),
        VALUE_FINISHED("FINISHED"),
        VALUE_ERROR("ERROR"),
        NULL(null);

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AsyncRequest> {
        AsyncRequest lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "result", "status", "type"};

        @Override
        public AsyncRequest getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AsyncRequest parseResponse(String response) throws APIException {
            return AsyncRequest.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AsyncRequest execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AsyncRequest execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AsyncRequest> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AsyncRequest> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AsyncRequest>(){

                public AsyncRequest apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestResultField() {
            return this.requestResultField(true);
        }

        public APIRequestGet requestResultField(boolean value) {
            this.requestField("result", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }
    }
}

