/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdgroupRelevanceScore;
import com.facebook.ads.sdk.AdsActionStats;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdsInsights
extends APINode {
    @SerializedName(value="account_currency")
    private String mAccountCurrency = null;
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="account_name")
    private String mAccountName = null;
    @SerializedName(value="action_values")
    private List<AdsActionStats> mActionValues = null;
    @SerializedName(value="actions")
    private List<AdsActionStats> mActions = null;
    @SerializedName(value="activity_recency")
    private String mActivityRecency = null;
    @SerializedName(value="ad_click_actions")
    private List<AdsActionStats> mAdClickActions = null;
    @SerializedName(value="ad_format_asset")
    private String mAdFormatAsset = null;
    @SerializedName(value="ad_id")
    private String mAdId = null;
    @SerializedName(value="ad_impression_actions")
    private List<AdsActionStats> mAdImpressionActions = null;
    @SerializedName(value="ad_name")
    private String mAdName = null;
    @SerializedName(value="adset_id")
    private String mAdsetId = null;
    @SerializedName(value="adset_name")
    private String mAdsetName = null;
    @SerializedName(value="age")
    private String mAge = null;
    @SerializedName(value="age_targeting")
    private String mAgeTargeting = null;
    @SerializedName(value="auction_bid")
    private String mAuctionBid = null;
    @SerializedName(value="auction_competitiveness")
    private String mAuctionCompetitiveness = null;
    @SerializedName(value="auction_max_competitor_bid")
    private String mAuctionMaxCompetitorBid = null;
    @SerializedName(value="bid_type")
    private String mBidType = null;
    @SerializedName(value="body_asset")
    private Object mBodyAsset = null;
    @SerializedName(value="buying_type")
    private String mBuyingType = null;
    @SerializedName(value="call_to_action_asset")
    private Object mCallToActionAsset = null;
    @SerializedName(value="campaign_id")
    private String mCampaignId = null;
    @SerializedName(value="campaign_name")
    private String mCampaignName = null;
    @SerializedName(value="canvas_avg_view_percent")
    private String mCanvasAvgViewPercent = null;
    @SerializedName(value="canvas_avg_view_time")
    private String mCanvasAvgViewTime = null;
    @SerializedName(value="canvas_component_avg_pct_view")
    private List<AdsActionStats> mCanvasComponentAvgPctView = null;
    @SerializedName(value="clicks")
    private String mClicks = null;
    @SerializedName(value="cost_per_10_sec_video_view")
    private List<AdsActionStats> mCostPer10SecVideoView = null;
    @SerializedName(value="cost_per_15_sec_video_view")
    private List<AdsActionStats> mCostPer15SecVideoView = null;
    @SerializedName(value="cost_per_2_sec_continuous_video_view")
    private List<AdsActionStats> mCostPer2SecContinuousVideoView = null;
    @SerializedName(value="cost_per_action_type")
    private List<AdsActionStats> mCostPerActionType = null;
    @SerializedName(value="cost_per_ad_click")
    private List<AdsActionStats> mCostPerAdClick = null;
    @SerializedName(value="cost_per_dda_countby_convs")
    private String mCostPerDdaCountbyConvs = null;
    @SerializedName(value="cost_per_estimated_ad_recallers")
    private String mCostPerEstimatedAdRecallers = null;
    @SerializedName(value="cost_per_inline_link_click")
    private String mCostPerInlineLinkClick = null;
    @SerializedName(value="cost_per_inline_post_engagement")
    private String mCostPerInlinePostEngagement = null;
    @SerializedName(value="cost_per_one_thousand_ad_impression")
    private List<AdsActionStats> mCostPerOneThousandAdImpression = null;
    @SerializedName(value="cost_per_outbound_click")
    private List<AdsActionStats> mCostPerOutboundClick = null;
    @SerializedName(value="cost_per_thruplay")
    private List<AdsActionStats> mCostPerThruplay = null;
    @SerializedName(value="cost_per_unique_action_type")
    private List<AdsActionStats> mCostPerUniqueActionType = null;
    @SerializedName(value="cost_per_unique_click")
    private String mCostPerUniqueClick = null;
    @SerializedName(value="cost_per_unique_inline_link_click")
    private String mCostPerUniqueInlineLinkClick = null;
    @SerializedName(value="cost_per_unique_outbound_click")
    private List<AdsActionStats> mCostPerUniqueOutboundClick = null;
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="cpc")
    private String mCpc = null;
    @SerializedName(value="cpm")
    private String mCpm = null;
    @SerializedName(value="cpp")
    private String mCpp = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="creative_fingerprint")
    private String mCreativeFingerprint = null;
    @SerializedName(value="ctr")
    private String mCtr = null;
    @SerializedName(value="date_start")
    private String mDateStart = null;
    @SerializedName(value="date_stop")
    private String mDateStop = null;
    @SerializedName(value="dda_countby_convs")
    private String mDdaCountbyConvs = null;
    @SerializedName(value="description_asset")
    private Object mDescriptionAsset = null;
    @SerializedName(value="device_platform")
    private String mDevicePlatform = null;
    @SerializedName(value="dma")
    private String mDma = null;
    @SerializedName(value="estimated_ad_recall_rate")
    private String mEstimatedAdRecallRate = null;
    @SerializedName(value="estimated_ad_recall_rate_lower_bound")
    private String mEstimatedAdRecallRateLowerBound = null;
    @SerializedName(value="estimated_ad_recall_rate_upper_bound")
    private String mEstimatedAdRecallRateUpperBound = null;
    @SerializedName(value="estimated_ad_recallers")
    private String mEstimatedAdRecallers = null;
    @SerializedName(value="estimated_ad_recallers_lower_bound")
    private String mEstimatedAdRecallersLowerBound = null;
    @SerializedName(value="estimated_ad_recallers_upper_bound")
    private String mEstimatedAdRecallersUpperBound = null;
    @SerializedName(value="frequency")
    private String mFrequency = null;
    @SerializedName(value="frequency_value")
    private String mFrequencyValue = null;
    @SerializedName(value="gender")
    private String mGender = null;
    @SerializedName(value="gender_targeting")
    private String mGenderTargeting = null;
    @SerializedName(value="hourly_stats_aggregated_by_advertiser_time_zone")
    private String mHourlyStatsAggregatedByAdvertiserTimeZone = null;
    @SerializedName(value="hourly_stats_aggregated_by_audience_time_zone")
    private String mHourlyStatsAggregatedByAudienceTimeZone = null;
    @SerializedName(value="image_asset")
    private Object mImageAsset = null;
    @SerializedName(value="impression_device")
    private String mImpressionDevice = null;
    @SerializedName(value="impressions")
    private String mImpressions = null;
    @SerializedName(value="impressions_dummy")
    private String mImpressionsDummy = null;
    @SerializedName(value="inline_link_click_ctr")
    private String mInlineLinkClickCtr = null;
    @SerializedName(value="inline_link_clicks")
    private String mInlineLinkClicks = null;
    @SerializedName(value="inline_post_engagement")
    private String mInlinePostEngagement = null;
    @SerializedName(value="labels")
    private String mLabels = null;
    @SerializedName(value="link_url_asset")
    private Object mLinkUrlAsset = null;
    @SerializedName(value="location")
    private String mLocation = null;
    @SerializedName(value="media_asset")
    private Object mMediaAsset = null;
    @SerializedName(value="mobile_app_purchase_roas")
    private List<AdsActionStats> mMobileAppPurchaseRoas = null;
    @SerializedName(value="objective")
    private String mObjective = null;
    @SerializedName(value="outbound_clicks")
    private List<AdsActionStats> mOutboundClicks = null;
    @SerializedName(value="outbound_clicks_ctr")
    private List<AdsActionStats> mOutboundClicksCtr = null;
    @SerializedName(value="place_page_id")
    private String mPlacePageId = null;
    @SerializedName(value="place_page_name")
    private String mPlacePageName = null;
    @SerializedName(value="placement")
    private String mPlacement = null;
    @SerializedName(value="platform_position")
    private String mPlatformPosition = null;
    @SerializedName(value="product_format")
    private String mProductFormat = null;
    @SerializedName(value="product_id")
    private String mProductId = null;
    @SerializedName(value="publisher_platform")
    private String mPublisherPlatform = null;
    @SerializedName(value="purchasing_interface")
    private String mPurchasingInterface = null;
    @SerializedName(value="reach")
    private String mReach = null;
    @SerializedName(value="region")
    private String mRegion = null;
    @SerializedName(value="relevance_score")
    private AdgroupRelevanceScore mRelevanceScore = null;
    @SerializedName(value="rule_asset")
    private Object mRuleAsset = null;
    @SerializedName(value="social_spend")
    private String mSocialSpend = null;
    @SerializedName(value="spend")
    private String mSpend = null;
    @SerializedName(value="title_asset")
    private Object mTitleAsset = null;
    @SerializedName(value="unique_actions")
    private List<AdsActionStats> mUniqueActions = null;
    @SerializedName(value="unique_clicks")
    private String mUniqueClicks = null;
    @SerializedName(value="unique_ctr")
    private String mUniqueCtr = null;
    @SerializedName(value="unique_inline_link_click_ctr")
    private String mUniqueInlineLinkClickCtr = null;
    @SerializedName(value="unique_inline_link_clicks")
    private String mUniqueInlineLinkClicks = null;
    @SerializedName(value="unique_link_clicks_ctr")
    private String mUniqueLinkClicksCtr = null;
    @SerializedName(value="unique_outbound_clicks")
    private List<AdsActionStats> mUniqueOutboundClicks = null;
    @SerializedName(value="unique_outbound_clicks_ctr")
    private List<AdsActionStats> mUniqueOutboundClicksCtr = null;
    @SerializedName(value="unique_video_continuous_2_sec_watched_actions")
    private List<AdsActionStats> mUniqueVideoContinuous2SecWatchedActions = null;
    @SerializedName(value="unique_video_view_10_sec")
    private List<AdsActionStats> mUniqueVideoView10Sec = null;
    @SerializedName(value="unique_video_view_15_sec")
    private List<AdsActionStats> mUniqueVideoView15Sec = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="video_10_sec_watched_actions")
    private List<AdsActionStats> mVideo10SecWatchedActions = null;
    @SerializedName(value="video_15_sec_watched_actions")
    private List<AdsActionStats> mVideo15SecWatchedActions = null;
    @SerializedName(value="video_30_sec_watched_actions")
    private List<AdsActionStats> mVideo30SecWatchedActions = null;
    @SerializedName(value="video_asset")
    private Object mVideoAsset = null;
    @SerializedName(value="video_avg_percent_watched_actions")
    private List<AdsActionStats> mVideoAvgPercentWatchedActions = null;
    @SerializedName(value="video_avg_time_watched_actions")
    private List<AdsActionStats> mVideoAvgTimeWatchedActions = null;
    @SerializedName(value="video_continuous_2_sec_watched_actions")
    private List<AdsActionStats> mVideoContinuous2SecWatchedActions = null;
    @SerializedName(value="video_p100_watched_actions")
    private List<AdsActionStats> mVideoP100WatchedActions = null;
    @SerializedName(value="video_p25_watched_actions")
    private List<AdsActionStats> mVideoP25WatchedActions = null;
    @SerializedName(value="video_p50_watched_actions")
    private List<AdsActionStats> mVideoP50WatchedActions = null;
    @SerializedName(value="video_p75_watched_actions")
    private List<AdsActionStats> mVideoP75WatchedActions = null;
    @SerializedName(value="video_p95_watched_actions")
    private List<AdsActionStats> mVideoP95WatchedActions = null;
    @SerializedName(value="video_play_actions")
    private List<AdsActionStats> mVideoPlayActions = null;
    @SerializedName(value="video_play_retention_0_to_15s_actions")
    private List<Object> mVideoPlayRetention0To15sActions = null;
    @SerializedName(value="video_play_retention_20_to_60s_actions")
    private List<Object> mVideoPlayRetention20To60sActions = null;
    @SerializedName(value="video_play_retention_graph_actions")
    private List<Object> mVideoPlayRetentionGraphActions = null;
    @SerializedName(value="video_thruplay_watched_actions")
    private List<AdsActionStats> mVideoThruplayWatchedActions = null;
    @SerializedName(value="video_time_watched_actions")
    private List<AdsActionStats> mVideoTimeWatchedActions = null;
    @SerializedName(value="website_ctr")
    private List<AdsActionStats> mWebsiteCtr = null;
    @SerializedName(value="website_purchase_roas")
    private List<AdsActionStats> mWebsitePurchaseRoas = null;
    @SerializedName(value="wish_bid")
    private String mWishBid = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdsInsights() {
    }

    public AdsInsights(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdsInsights(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdsInsights fetch() throws APIException {
        AdsInsights newInstance = AdsInsights.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdsInsights fetchById(Long id, APIContext context) throws APIException {
        return AdsInsights.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdsInsights> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdsInsights.fetchByIdAsync(id.toString(), context);
    }

    public static AdsInsights fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdsInsights> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdsInsights> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdsInsights>(context, "", "/", "GET", AdsInsights.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdsInsights>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdsInsights>(context, "", "/", "GET", AdsInsights.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsInsights loadJSON(String json, APIContext context) {
        AdsInsights adsInsights = (AdsInsights)AdsInsights.getGson().fromJson(json, AdsInsights.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsInsights.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsInsights.context = context;
        adsInsights.rawValue = json;
        return adsInsights;
    }

    public static APINodeList<AdsInsights> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsInsights> adsInsightss = new APINodeList<AdsInsights>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsInsightss.add(AdsInsights.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adsInsightss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsInsightss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsInsightss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsInsightss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsInsightss.add(AdsInsights.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsInsightss.add(AdsInsights.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsInsightss.add(AdsInsights.loadJSON(obj.toString(), context));
                        }
                    }
                    return adsInsightss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsInsightss.add(AdsInsights.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adsInsightss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsInsightss.add(AdsInsights.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsInsightss;
                }
                adsInsightss.clear();
                adsInsightss.add(AdsInsights.loadJSON(json, context));
                return adsInsightss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsInsights.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountCurrency() {
        return this.mAccountCurrency;
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public String getFieldAccountName() {
        return this.mAccountName;
    }

    public List<AdsActionStats> getFieldActionValues() {
        return this.mActionValues;
    }

    public List<AdsActionStats> getFieldActions() {
        return this.mActions;
    }

    public String getFieldActivityRecency() {
        return this.mActivityRecency;
    }

    public List<AdsActionStats> getFieldAdClickActions() {
        return this.mAdClickActions;
    }

    public String getFieldAdFormatAsset() {
        return this.mAdFormatAsset;
    }

    public String getFieldAdId() {
        return this.mAdId;
    }

    public List<AdsActionStats> getFieldAdImpressionActions() {
        return this.mAdImpressionActions;
    }

    public String getFieldAdName() {
        return this.mAdName;
    }

    public String getFieldAdsetId() {
        return this.mAdsetId;
    }

    public String getFieldAdsetName() {
        return this.mAdsetName;
    }

    public String getFieldAge() {
        return this.mAge;
    }

    public String getFieldAgeTargeting() {
        return this.mAgeTargeting;
    }

    public String getFieldAuctionBid() {
        return this.mAuctionBid;
    }

    public String getFieldAuctionCompetitiveness() {
        return this.mAuctionCompetitiveness;
    }

    public String getFieldAuctionMaxCompetitorBid() {
        return this.mAuctionMaxCompetitorBid;
    }

    public String getFieldBidType() {
        return this.mBidType;
    }

    public Object getFieldBodyAsset() {
        return this.mBodyAsset;
    }

    public String getFieldBuyingType() {
        return this.mBuyingType;
    }

    public Object getFieldCallToActionAsset() {
        return this.mCallToActionAsset;
    }

    public String getFieldCampaignId() {
        return this.mCampaignId;
    }

    public String getFieldCampaignName() {
        return this.mCampaignName;
    }

    public String getFieldCanvasAvgViewPercent() {
        return this.mCanvasAvgViewPercent;
    }

    public String getFieldCanvasAvgViewTime() {
        return this.mCanvasAvgViewTime;
    }

    public List<AdsActionStats> getFieldCanvasComponentAvgPctView() {
        return this.mCanvasComponentAvgPctView;
    }

    public String getFieldClicks() {
        return this.mClicks;
    }

    public List<AdsActionStats> getFieldCostPer10SecVideoView() {
        return this.mCostPer10SecVideoView;
    }

    public List<AdsActionStats> getFieldCostPer15SecVideoView() {
        return this.mCostPer15SecVideoView;
    }

    public List<AdsActionStats> getFieldCostPer2SecContinuousVideoView() {
        return this.mCostPer2SecContinuousVideoView;
    }

    public List<AdsActionStats> getFieldCostPerActionType() {
        return this.mCostPerActionType;
    }

    public List<AdsActionStats> getFieldCostPerAdClick() {
        return this.mCostPerAdClick;
    }

    public String getFieldCostPerDdaCountbyConvs() {
        return this.mCostPerDdaCountbyConvs;
    }

    public String getFieldCostPerEstimatedAdRecallers() {
        return this.mCostPerEstimatedAdRecallers;
    }

    public String getFieldCostPerInlineLinkClick() {
        return this.mCostPerInlineLinkClick;
    }

    public String getFieldCostPerInlinePostEngagement() {
        return this.mCostPerInlinePostEngagement;
    }

    public List<AdsActionStats> getFieldCostPerOneThousandAdImpression() {
        return this.mCostPerOneThousandAdImpression;
    }

    public List<AdsActionStats> getFieldCostPerOutboundClick() {
        return this.mCostPerOutboundClick;
    }

    public List<AdsActionStats> getFieldCostPerThruplay() {
        return this.mCostPerThruplay;
    }

    public List<AdsActionStats> getFieldCostPerUniqueActionType() {
        return this.mCostPerUniqueActionType;
    }

    public String getFieldCostPerUniqueClick() {
        return this.mCostPerUniqueClick;
    }

    public String getFieldCostPerUniqueInlineLinkClick() {
        return this.mCostPerUniqueInlineLinkClick;
    }

    public List<AdsActionStats> getFieldCostPerUniqueOutboundClick() {
        return this.mCostPerUniqueOutboundClick;
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public String getFieldCpc() {
        return this.mCpc;
    }

    public String getFieldCpm() {
        return this.mCpm;
    }

    public String getFieldCpp() {
        return this.mCpp;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldCreativeFingerprint() {
        return this.mCreativeFingerprint;
    }

    public String getFieldCtr() {
        return this.mCtr;
    }

    public String getFieldDateStart() {
        return this.mDateStart;
    }

    public String getFieldDateStop() {
        return this.mDateStop;
    }

    public String getFieldDdaCountbyConvs() {
        return this.mDdaCountbyConvs;
    }

    public Object getFieldDescriptionAsset() {
        return this.mDescriptionAsset;
    }

    public String getFieldDevicePlatform() {
        return this.mDevicePlatform;
    }

    public String getFieldDma() {
        return this.mDma;
    }

    public String getFieldEstimatedAdRecallRate() {
        return this.mEstimatedAdRecallRate;
    }

    public String getFieldEstimatedAdRecallRateLowerBound() {
        return this.mEstimatedAdRecallRateLowerBound;
    }

    public String getFieldEstimatedAdRecallRateUpperBound() {
        return this.mEstimatedAdRecallRateUpperBound;
    }

    public String getFieldEstimatedAdRecallers() {
        return this.mEstimatedAdRecallers;
    }

    public String getFieldEstimatedAdRecallersLowerBound() {
        return this.mEstimatedAdRecallersLowerBound;
    }

    public String getFieldEstimatedAdRecallersUpperBound() {
        return this.mEstimatedAdRecallersUpperBound;
    }

    public String getFieldFrequency() {
        return this.mFrequency;
    }

    public String getFieldFrequencyValue() {
        return this.mFrequencyValue;
    }

    public String getFieldGender() {
        return this.mGender;
    }

    public String getFieldGenderTargeting() {
        return this.mGenderTargeting;
    }

    public String getFieldHourlyStatsAggregatedByAdvertiserTimeZone() {
        return this.mHourlyStatsAggregatedByAdvertiserTimeZone;
    }

    public String getFieldHourlyStatsAggregatedByAudienceTimeZone() {
        return this.mHourlyStatsAggregatedByAudienceTimeZone;
    }

    public Object getFieldImageAsset() {
        return this.mImageAsset;
    }

    public String getFieldImpressionDevice() {
        return this.mImpressionDevice;
    }

    public String getFieldImpressions() {
        return this.mImpressions;
    }

    public String getFieldImpressionsDummy() {
        return this.mImpressionsDummy;
    }

    public String getFieldInlineLinkClickCtr() {
        return this.mInlineLinkClickCtr;
    }

    public String getFieldInlineLinkClicks() {
        return this.mInlineLinkClicks;
    }

    public String getFieldInlinePostEngagement() {
        return this.mInlinePostEngagement;
    }

    public String getFieldLabels() {
        return this.mLabels;
    }

    public Object getFieldLinkUrlAsset() {
        return this.mLinkUrlAsset;
    }

    public String getFieldLocation() {
        return this.mLocation;
    }

    public Object getFieldMediaAsset() {
        return this.mMediaAsset;
    }

    public List<AdsActionStats> getFieldMobileAppPurchaseRoas() {
        return this.mMobileAppPurchaseRoas;
    }

    public String getFieldObjective() {
        return this.mObjective;
    }

    public List<AdsActionStats> getFieldOutboundClicks() {
        return this.mOutboundClicks;
    }

    public List<AdsActionStats> getFieldOutboundClicksCtr() {
        return this.mOutboundClicksCtr;
    }

    public String getFieldPlacePageId() {
        return this.mPlacePageId;
    }

    public String getFieldPlacePageName() {
        return this.mPlacePageName;
    }

    public String getFieldPlacement() {
        return this.mPlacement;
    }

    public String getFieldPlatformPosition() {
        return this.mPlatformPosition;
    }

    public String getFieldProductFormat() {
        return this.mProductFormat;
    }

    public String getFieldProductId() {
        return this.mProductId;
    }

    public String getFieldPublisherPlatform() {
        return this.mPublisherPlatform;
    }

    public String getFieldPurchasingInterface() {
        return this.mPurchasingInterface;
    }

    public String getFieldReach() {
        return this.mReach;
    }

    public String getFieldRegion() {
        return this.mRegion;
    }

    public AdgroupRelevanceScore getFieldRelevanceScore() {
        if (this.mRelevanceScore != null) {
            this.mRelevanceScore.context = this.getContext();
        }
        return this.mRelevanceScore;
    }

    public Object getFieldRuleAsset() {
        return this.mRuleAsset;
    }

    public String getFieldSocialSpend() {
        return this.mSocialSpend;
    }

    public String getFieldSpend() {
        return this.mSpend;
    }

    public Object getFieldTitleAsset() {
        return this.mTitleAsset;
    }

    public List<AdsActionStats> getFieldUniqueActions() {
        return this.mUniqueActions;
    }

    public String getFieldUniqueClicks() {
        return this.mUniqueClicks;
    }

    public String getFieldUniqueCtr() {
        return this.mUniqueCtr;
    }

    public String getFieldUniqueInlineLinkClickCtr() {
        return this.mUniqueInlineLinkClickCtr;
    }

    public String getFieldUniqueInlineLinkClicks() {
        return this.mUniqueInlineLinkClicks;
    }

    public String getFieldUniqueLinkClicksCtr() {
        return this.mUniqueLinkClicksCtr;
    }

    public List<AdsActionStats> getFieldUniqueOutboundClicks() {
        return this.mUniqueOutboundClicks;
    }

    public List<AdsActionStats> getFieldUniqueOutboundClicksCtr() {
        return this.mUniqueOutboundClicksCtr;
    }

    public List<AdsActionStats> getFieldUniqueVideoContinuous2SecWatchedActions() {
        return this.mUniqueVideoContinuous2SecWatchedActions;
    }

    public List<AdsActionStats> getFieldUniqueVideoView10Sec() {
        return this.mUniqueVideoView10Sec;
    }

    public List<AdsActionStats> getFieldUniqueVideoView15Sec() {
        return this.mUniqueVideoView15Sec;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public List<AdsActionStats> getFieldVideo10SecWatchedActions() {
        return this.mVideo10SecWatchedActions;
    }

    public List<AdsActionStats> getFieldVideo15SecWatchedActions() {
        return this.mVideo15SecWatchedActions;
    }

    public List<AdsActionStats> getFieldVideo30SecWatchedActions() {
        return this.mVideo30SecWatchedActions;
    }

    public Object getFieldVideoAsset() {
        return this.mVideoAsset;
    }

    public List<AdsActionStats> getFieldVideoAvgPercentWatchedActions() {
        return this.mVideoAvgPercentWatchedActions;
    }

    public List<AdsActionStats> getFieldVideoAvgTimeWatchedActions() {
        return this.mVideoAvgTimeWatchedActions;
    }

    public List<AdsActionStats> getFieldVideoContinuous2SecWatchedActions() {
        return this.mVideoContinuous2SecWatchedActions;
    }

    public List<AdsActionStats> getFieldVideoP100WatchedActions() {
        return this.mVideoP100WatchedActions;
    }

    public List<AdsActionStats> getFieldVideoP25WatchedActions() {
        return this.mVideoP25WatchedActions;
    }

    public List<AdsActionStats> getFieldVideoP50WatchedActions() {
        return this.mVideoP50WatchedActions;
    }

    public List<AdsActionStats> getFieldVideoP75WatchedActions() {
        return this.mVideoP75WatchedActions;
    }

    public List<AdsActionStats> getFieldVideoP95WatchedActions() {
        return this.mVideoP95WatchedActions;
    }

    public List<AdsActionStats> getFieldVideoPlayActions() {
        return this.mVideoPlayActions;
    }

    public List<Object> getFieldVideoPlayRetention0To15sActions() {
        return this.mVideoPlayRetention0To15sActions;
    }

    public List<Object> getFieldVideoPlayRetention20To60sActions() {
        return this.mVideoPlayRetention20To60sActions;
    }

    public List<Object> getFieldVideoPlayRetentionGraphActions() {
        return this.mVideoPlayRetentionGraphActions;
    }

    public List<AdsActionStats> getFieldVideoThruplayWatchedActions() {
        return this.mVideoThruplayWatchedActions;
    }

    public List<AdsActionStats> getFieldVideoTimeWatchedActions() {
        return this.mVideoTimeWatchedActions;
    }

    public List<AdsActionStats> getFieldWebsiteCtr() {
        return this.mWebsiteCtr;
    }

    public List<AdsActionStats> getFieldWebsitePurchaseRoas() {
        return this.mWebsitePurchaseRoas;
    }

    public String getFieldWishBid() {
        return this.mWishBid;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsInsights copyFrom(AdsInsights instance) {
        this.mAccountCurrency = instance.mAccountCurrency;
        this.mAccountId = instance.mAccountId;
        this.mAccountName = instance.mAccountName;
        this.mActionValues = instance.mActionValues;
        this.mActions = instance.mActions;
        this.mActivityRecency = instance.mActivityRecency;
        this.mAdClickActions = instance.mAdClickActions;
        this.mAdFormatAsset = instance.mAdFormatAsset;
        this.mAdId = instance.mAdId;
        this.mAdImpressionActions = instance.mAdImpressionActions;
        this.mAdName = instance.mAdName;
        this.mAdsetId = instance.mAdsetId;
        this.mAdsetName = instance.mAdsetName;
        this.mAge = instance.mAge;
        this.mAgeTargeting = instance.mAgeTargeting;
        this.mAuctionBid = instance.mAuctionBid;
        this.mAuctionCompetitiveness = instance.mAuctionCompetitiveness;
        this.mAuctionMaxCompetitorBid = instance.mAuctionMaxCompetitorBid;
        this.mBidType = instance.mBidType;
        this.mBodyAsset = instance.mBodyAsset;
        this.mBuyingType = instance.mBuyingType;
        this.mCallToActionAsset = instance.mCallToActionAsset;
        this.mCampaignId = instance.mCampaignId;
        this.mCampaignName = instance.mCampaignName;
        this.mCanvasAvgViewPercent = instance.mCanvasAvgViewPercent;
        this.mCanvasAvgViewTime = instance.mCanvasAvgViewTime;
        this.mCanvasComponentAvgPctView = instance.mCanvasComponentAvgPctView;
        this.mClicks = instance.mClicks;
        this.mCostPer10SecVideoView = instance.mCostPer10SecVideoView;
        this.mCostPer15SecVideoView = instance.mCostPer15SecVideoView;
        this.mCostPer2SecContinuousVideoView = instance.mCostPer2SecContinuousVideoView;
        this.mCostPerActionType = instance.mCostPerActionType;
        this.mCostPerAdClick = instance.mCostPerAdClick;
        this.mCostPerDdaCountbyConvs = instance.mCostPerDdaCountbyConvs;
        this.mCostPerEstimatedAdRecallers = instance.mCostPerEstimatedAdRecallers;
        this.mCostPerInlineLinkClick = instance.mCostPerInlineLinkClick;
        this.mCostPerInlinePostEngagement = instance.mCostPerInlinePostEngagement;
        this.mCostPerOneThousandAdImpression = instance.mCostPerOneThousandAdImpression;
        this.mCostPerOutboundClick = instance.mCostPerOutboundClick;
        this.mCostPerThruplay = instance.mCostPerThruplay;
        this.mCostPerUniqueActionType = instance.mCostPerUniqueActionType;
        this.mCostPerUniqueClick = instance.mCostPerUniqueClick;
        this.mCostPerUniqueInlineLinkClick = instance.mCostPerUniqueInlineLinkClick;
        this.mCostPerUniqueOutboundClick = instance.mCostPerUniqueOutboundClick;
        this.mCountry = instance.mCountry;
        this.mCpc = instance.mCpc;
        this.mCpm = instance.mCpm;
        this.mCpp = instance.mCpp;
        this.mCreatedTime = instance.mCreatedTime;
        this.mCreativeFingerprint = instance.mCreativeFingerprint;
        this.mCtr = instance.mCtr;
        this.mDateStart = instance.mDateStart;
        this.mDateStop = instance.mDateStop;
        this.mDdaCountbyConvs = instance.mDdaCountbyConvs;
        this.mDescriptionAsset = instance.mDescriptionAsset;
        this.mDevicePlatform = instance.mDevicePlatform;
        this.mDma = instance.mDma;
        this.mEstimatedAdRecallRate = instance.mEstimatedAdRecallRate;
        this.mEstimatedAdRecallRateLowerBound = instance.mEstimatedAdRecallRateLowerBound;
        this.mEstimatedAdRecallRateUpperBound = instance.mEstimatedAdRecallRateUpperBound;
        this.mEstimatedAdRecallers = instance.mEstimatedAdRecallers;
        this.mEstimatedAdRecallersLowerBound = instance.mEstimatedAdRecallersLowerBound;
        this.mEstimatedAdRecallersUpperBound = instance.mEstimatedAdRecallersUpperBound;
        this.mFrequency = instance.mFrequency;
        this.mFrequencyValue = instance.mFrequencyValue;
        this.mGender = instance.mGender;
        this.mGenderTargeting = instance.mGenderTargeting;
        this.mHourlyStatsAggregatedByAdvertiserTimeZone = instance.mHourlyStatsAggregatedByAdvertiserTimeZone;
        this.mHourlyStatsAggregatedByAudienceTimeZone = instance.mHourlyStatsAggregatedByAudienceTimeZone;
        this.mImageAsset = instance.mImageAsset;
        this.mImpressionDevice = instance.mImpressionDevice;
        this.mImpressions = instance.mImpressions;
        this.mImpressionsDummy = instance.mImpressionsDummy;
        this.mInlineLinkClickCtr = instance.mInlineLinkClickCtr;
        this.mInlineLinkClicks = instance.mInlineLinkClicks;
        this.mInlinePostEngagement = instance.mInlinePostEngagement;
        this.mLabels = instance.mLabels;
        this.mLinkUrlAsset = instance.mLinkUrlAsset;
        this.mLocation = instance.mLocation;
        this.mMediaAsset = instance.mMediaAsset;
        this.mMobileAppPurchaseRoas = instance.mMobileAppPurchaseRoas;
        this.mObjective = instance.mObjective;
        this.mOutboundClicks = instance.mOutboundClicks;
        this.mOutboundClicksCtr = instance.mOutboundClicksCtr;
        this.mPlacePageId = instance.mPlacePageId;
        this.mPlacePageName = instance.mPlacePageName;
        this.mPlacement = instance.mPlacement;
        this.mPlatformPosition = instance.mPlatformPosition;
        this.mProductFormat = instance.mProductFormat;
        this.mProductId = instance.mProductId;
        this.mPublisherPlatform = instance.mPublisherPlatform;
        this.mPurchasingInterface = instance.mPurchasingInterface;
        this.mReach = instance.mReach;
        this.mRegion = instance.mRegion;
        this.mRelevanceScore = instance.mRelevanceScore;
        this.mRuleAsset = instance.mRuleAsset;
        this.mSocialSpend = instance.mSocialSpend;
        this.mSpend = instance.mSpend;
        this.mTitleAsset = instance.mTitleAsset;
        this.mUniqueActions = instance.mUniqueActions;
        this.mUniqueClicks = instance.mUniqueClicks;
        this.mUniqueCtr = instance.mUniqueCtr;
        this.mUniqueInlineLinkClickCtr = instance.mUniqueInlineLinkClickCtr;
        this.mUniqueInlineLinkClicks = instance.mUniqueInlineLinkClicks;
        this.mUniqueLinkClicksCtr = instance.mUniqueLinkClicksCtr;
        this.mUniqueOutboundClicks = instance.mUniqueOutboundClicks;
        this.mUniqueOutboundClicksCtr = instance.mUniqueOutboundClicksCtr;
        this.mUniqueVideoContinuous2SecWatchedActions = instance.mUniqueVideoContinuous2SecWatchedActions;
        this.mUniqueVideoView10Sec = instance.mUniqueVideoView10Sec;
        this.mUniqueVideoView15Sec = instance.mUniqueVideoView15Sec;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mVideo10SecWatchedActions = instance.mVideo10SecWatchedActions;
        this.mVideo15SecWatchedActions = instance.mVideo15SecWatchedActions;
        this.mVideo30SecWatchedActions = instance.mVideo30SecWatchedActions;
        this.mVideoAsset = instance.mVideoAsset;
        this.mVideoAvgPercentWatchedActions = instance.mVideoAvgPercentWatchedActions;
        this.mVideoAvgTimeWatchedActions = instance.mVideoAvgTimeWatchedActions;
        this.mVideoContinuous2SecWatchedActions = instance.mVideoContinuous2SecWatchedActions;
        this.mVideoP100WatchedActions = instance.mVideoP100WatchedActions;
        this.mVideoP25WatchedActions = instance.mVideoP25WatchedActions;
        this.mVideoP50WatchedActions = instance.mVideoP50WatchedActions;
        this.mVideoP75WatchedActions = instance.mVideoP75WatchedActions;
        this.mVideoP95WatchedActions = instance.mVideoP95WatchedActions;
        this.mVideoPlayActions = instance.mVideoPlayActions;
        this.mVideoPlayRetention0To15sActions = instance.mVideoPlayRetention0To15sActions;
        this.mVideoPlayRetention20To60sActions = instance.mVideoPlayRetention20To60sActions;
        this.mVideoPlayRetentionGraphActions = instance.mVideoPlayRetentionGraphActions;
        this.mVideoThruplayWatchedActions = instance.mVideoThruplayWatchedActions;
        this.mVideoTimeWatchedActions = instance.mVideoTimeWatchedActions;
        this.mWebsiteCtr = instance.mWebsiteCtr;
        this.mWebsitePurchaseRoas = instance.mWebsitePurchaseRoas;
        this.mWishBid = instance.mWishBid;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsInsights> getParser() {
        return new APIRequest.ResponseParser<AdsInsights>(){

            @Override
            public APINodeList<AdsInsights> parseResponse(String response, APIContext context, APIRequest<AdsInsights> request) throws APIException.MalformedResponseException {
                return AdsInsights.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumSummaryActionBreakdowns {
        VALUE_ACTION_CANVAS_COMPONENT_NAME("action_canvas_component_name"),
        VALUE_ACTION_CAROUSEL_CARD_ID("action_carousel_card_id"),
        VALUE_ACTION_CAROUSEL_CARD_NAME("action_carousel_card_name"),
        VALUE_ACTION_DESTINATION("action_destination"),
        VALUE_ACTION_DEVICE("action_device"),
        VALUE_ACTION_LINK_CLICK_DESTINATION("action_link_click_destination"),
        VALUE_ACTION_REACTION("action_reaction"),
        VALUE_ACTION_TARGET_ID("action_target_id"),
        VALUE_ACTION_TYPE("action_type"),
        VALUE_ACTION_VIDEO_SOUND("action_video_sound"),
        VALUE_ACTION_VIDEO_TYPE("action_video_type"),
        NULL(null);

        private String value;

        private EnumSummaryActionBreakdowns(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumLevel {
        VALUE_AD("ad"),
        VALUE_ADSET("adset"),
        VALUE_CAMPAIGN("campaign"),
        VALUE_ACCOUNT("account"),
        NULL(null);

        private String value;

        private EnumLevel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumDatePreset {
        VALUE_TODAY("today"),
        VALUE_YESTERDAY("yesterday"),
        VALUE_THIS_MONTH("this_month"),
        VALUE_LAST_MONTH("last_month"),
        VALUE_THIS_QUARTER("this_quarter"),
        VALUE_LIFETIME("lifetime"),
        VALUE_LAST_3D("last_3d"),
        VALUE_LAST_7D("last_7d"),
        VALUE_LAST_14D("last_14d"),
        VALUE_LAST_28D("last_28d"),
        VALUE_LAST_30D("last_30d"),
        VALUE_LAST_90D("last_90d"),
        VALUE_LAST_WEEK_MON_SUN("last_week_mon_sun"),
        VALUE_LAST_WEEK_SUN_SAT("last_week_sun_sat"),
        VALUE_LAST_QUARTER("last_quarter"),
        VALUE_LAST_YEAR("last_year"),
        VALUE_THIS_WEEK_MON_TODAY("this_week_mon_today"),
        VALUE_THIS_WEEK_SUN_TODAY("this_week_sun_today"),
        VALUE_THIS_YEAR("this_year"),
        NULL(null);

        private String value;

        private EnumDatePreset(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBreakdowns {
        VALUE_AGE("age"),
        VALUE_COUNTRY("country"),
        VALUE_DMA("dma"),
        VALUE_GENDER("gender"),
        VALUE_FREQUENCY_VALUE("frequency_value"),
        VALUE_HOURLY_STATS_AGGREGATED_BY_ADVERTISER_TIME_ZONE("hourly_stats_aggregated_by_advertiser_time_zone"),
        VALUE_HOURLY_STATS_AGGREGATED_BY_AUDIENCE_TIME_ZONE("hourly_stats_aggregated_by_audience_time_zone"),
        VALUE_IMPRESSION_DEVICE("impression_device"),
        VALUE_PLACE_PAGE_ID("place_page_id"),
        VALUE_PUBLISHER_PLATFORM("publisher_platform"),
        VALUE_PLATFORM_POSITION("platform_position"),
        VALUE_DEVICE_PLATFORM("device_platform"),
        VALUE_PRODUCT_ID("product_id"),
        VALUE_REGION("region"),
        VALUE_AD_FORMAT_ASSET("ad_format_asset"),
        VALUE_BODY_ASSET("body_asset"),
        VALUE_CALL_TO_ACTION_ASSET("call_to_action_asset"),
        VALUE_DESCRIPTION_ASSET("description_asset"),
        VALUE_IMAGE_ASSET("image_asset"),
        VALUE_LINK_URL_ASSET("link_url_asset"),
        VALUE_TITLE_ASSET("title_asset"),
        VALUE_VIDEO_ASSET("video_asset"),
        NULL(null);

        private String value;

        private EnumBreakdowns(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumActionReportTime {
        VALUE_IMPRESSION("impression"),
        VALUE_CONVERSION("conversion"),
        NULL(null);

        private String value;

        private EnumActionReportTime(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumActionBreakdowns {
        VALUE_ACTION_CANVAS_COMPONENT_NAME("action_canvas_component_name"),
        VALUE_ACTION_CAROUSEL_CARD_ID("action_carousel_card_id"),
        VALUE_ACTION_CAROUSEL_CARD_NAME("action_carousel_card_name"),
        VALUE_ACTION_DESTINATION("action_destination"),
        VALUE_ACTION_DEVICE("action_device"),
        VALUE_ACTION_LINK_CLICK_DESTINATION("action_link_click_destination"),
        VALUE_ACTION_REACTION("action_reaction"),
        VALUE_ACTION_TARGET_ID("action_target_id"),
        VALUE_ACTION_TYPE("action_type"),
        VALUE_ACTION_VIDEO_SOUND("action_video_sound"),
        VALUE_ACTION_VIDEO_TYPE("action_video_type"),
        NULL(null);

        private String value;

        private EnumActionBreakdowns(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumActionAttributionWindows {
        VALUE_1D_VIEW("1d_view"),
        VALUE_7D_VIEW("7d_view"),
        VALUE_28D_VIEW("28d_view"),
        VALUE_1D_CLICK("1d_click"),
        VALUE_7D_CLICK("7d_click"),
        VALUE_28D_CLICK("28d_click"),
        VALUE_DEFAULT("default"),
        NULL(null);

        private String value;

        private EnumActionAttributionWindows(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdsInsights> {
        AdsInsights lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_currency", "account_id", "account_name", "action_values", "actions", "activity_recency", "ad_click_actions", "ad_format_asset", "ad_id", "ad_impression_actions", "ad_name", "adset_id", "adset_name", "age", "age_targeting", "auction_bid", "auction_competitiveness", "auction_max_competitor_bid", "bid_type", "body_asset", "buying_type", "call_to_action_asset", "campaign_id", "campaign_name", "canvas_avg_view_percent", "canvas_avg_view_time", "canvas_component_avg_pct_view", "clicks", "cost_per_10_sec_video_view", "cost_per_15_sec_video_view", "cost_per_2_sec_continuous_video_view", "cost_per_action_type", "cost_per_ad_click", "cost_per_dda_countby_convs", "cost_per_estimated_ad_recallers", "cost_per_inline_link_click", "cost_per_inline_post_engagement", "cost_per_one_thousand_ad_impression", "cost_per_outbound_click", "cost_per_thruplay", "cost_per_unique_action_type", "cost_per_unique_click", "cost_per_unique_inline_link_click", "cost_per_unique_outbound_click", "country", "cpc", "cpm", "cpp", "created_time", "creative_fingerprint", "ctr", "date_start", "date_stop", "dda_countby_convs", "description_asset", "device_platform", "dma", "estimated_ad_recall_rate", "estimated_ad_recall_rate_lower_bound", "estimated_ad_recall_rate_upper_bound", "estimated_ad_recallers", "estimated_ad_recallers_lower_bound", "estimated_ad_recallers_upper_bound", "frequency", "frequency_value", "gender", "gender_targeting", "hourly_stats_aggregated_by_advertiser_time_zone", "hourly_stats_aggregated_by_audience_time_zone", "image_asset", "impression_device", "impressions", "impressions_dummy", "inline_link_click_ctr", "inline_link_clicks", "inline_post_engagement", "labels", "link_url_asset", "location", "media_asset", "mobile_app_purchase_roas", "objective", "outbound_clicks", "outbound_clicks_ctr", "place_page_id", "place_page_name", "placement", "platform_position", "product_format", "product_id", "publisher_platform", "purchasing_interface", "reach", "region", "relevance_score", "rule_asset", "social_spend", "spend", "title_asset", "unique_actions", "unique_clicks", "unique_ctr", "unique_inline_link_click_ctr", "unique_inline_link_clicks", "unique_link_clicks_ctr", "unique_outbound_clicks", "unique_outbound_clicks_ctr", "unique_video_continuous_2_sec_watched_actions", "unique_video_view_10_sec", "unique_video_view_15_sec", "updated_time", "video_10_sec_watched_actions", "video_15_sec_watched_actions", "video_30_sec_watched_actions", "video_asset", "video_avg_percent_watched_actions", "video_avg_time_watched_actions", "video_continuous_2_sec_watched_actions", "video_p100_watched_actions", "video_p25_watched_actions", "video_p50_watched_actions", "video_p75_watched_actions", "video_p95_watched_actions", "video_play_actions", "video_play_retention_0_to_15s_actions", "video_play_retention_20_to_60s_actions", "video_play_retention_graph_actions", "video_thruplay_watched_actions", "video_time_watched_actions", "website_ctr", "website_purchase_roas", "wish_bid", "id"};

        @Override
        public AdsInsights getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdsInsights parseResponse(String response) throws APIException {
            return AdsInsights.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdsInsights execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdsInsights execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdsInsights> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdsInsights> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdsInsights>(){

                public AdsInsights apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountCurrencyField() {
            return this.requestAccountCurrencyField(true);
        }

        public APIRequestGet requestAccountCurrencyField(boolean value) {
            this.requestField("account_currency", value);
            return this;
        }

        public APIRequestGet requestAccountIdField() {
            return this.requestAccountIdField(true);
        }

        public APIRequestGet requestAccountIdField(boolean value) {
            this.requestField("account_id", value);
            return this;
        }

        public APIRequestGet requestAccountNameField() {
            return this.requestAccountNameField(true);
        }

        public APIRequestGet requestAccountNameField(boolean value) {
            this.requestField("account_name", value);
            return this;
        }

        public APIRequestGet requestActionValuesField() {
            return this.requestActionValuesField(true);
        }

        public APIRequestGet requestActionValuesField(boolean value) {
            this.requestField("action_values", value);
            return this;
        }

        public APIRequestGet requestActionsField() {
            return this.requestActionsField(true);
        }

        public APIRequestGet requestActionsField(boolean value) {
            this.requestField("actions", value);
            return this;
        }

        public APIRequestGet requestActivityRecencyField() {
            return this.requestActivityRecencyField(true);
        }

        public APIRequestGet requestActivityRecencyField(boolean value) {
            this.requestField("activity_recency", value);
            return this;
        }

        public APIRequestGet requestAdClickActionsField() {
            return this.requestAdClickActionsField(true);
        }

        public APIRequestGet requestAdClickActionsField(boolean value) {
            this.requestField("ad_click_actions", value);
            return this;
        }

        public APIRequestGet requestAdFormatAssetField() {
            return this.requestAdFormatAssetField(true);
        }

        public APIRequestGet requestAdFormatAssetField(boolean value) {
            this.requestField("ad_format_asset", value);
            return this;
        }

        public APIRequestGet requestAdIdField() {
            return this.requestAdIdField(true);
        }

        public APIRequestGet requestAdIdField(boolean value) {
            this.requestField("ad_id", value);
            return this;
        }

        public APIRequestGet requestAdImpressionActionsField() {
            return this.requestAdImpressionActionsField(true);
        }

        public APIRequestGet requestAdImpressionActionsField(boolean value) {
            this.requestField("ad_impression_actions", value);
            return this;
        }

        public APIRequestGet requestAdNameField() {
            return this.requestAdNameField(true);
        }

        public APIRequestGet requestAdNameField(boolean value) {
            this.requestField("ad_name", value);
            return this;
        }

        public APIRequestGet requestAdsetIdField() {
            return this.requestAdsetIdField(true);
        }

        public APIRequestGet requestAdsetIdField(boolean value) {
            this.requestField("adset_id", value);
            return this;
        }

        public APIRequestGet requestAdsetNameField() {
            return this.requestAdsetNameField(true);
        }

        public APIRequestGet requestAdsetNameField(boolean value) {
            this.requestField("adset_name", value);
            return this;
        }

        public APIRequestGet requestAgeField() {
            return this.requestAgeField(true);
        }

        public APIRequestGet requestAgeField(boolean value) {
            this.requestField("age", value);
            return this;
        }

        public APIRequestGet requestAgeTargetingField() {
            return this.requestAgeTargetingField(true);
        }

        public APIRequestGet requestAgeTargetingField(boolean value) {
            this.requestField("age_targeting", value);
            return this;
        }

        public APIRequestGet requestAuctionBidField() {
            return this.requestAuctionBidField(true);
        }

        public APIRequestGet requestAuctionBidField(boolean value) {
            this.requestField("auction_bid", value);
            return this;
        }

        public APIRequestGet requestAuctionCompetitivenessField() {
            return this.requestAuctionCompetitivenessField(true);
        }

        public APIRequestGet requestAuctionCompetitivenessField(boolean value) {
            this.requestField("auction_competitiveness", value);
            return this;
        }

        public APIRequestGet requestAuctionMaxCompetitorBidField() {
            return this.requestAuctionMaxCompetitorBidField(true);
        }

        public APIRequestGet requestAuctionMaxCompetitorBidField(boolean value) {
            this.requestField("auction_max_competitor_bid", value);
            return this;
        }

        public APIRequestGet requestBidTypeField() {
            return this.requestBidTypeField(true);
        }

        public APIRequestGet requestBidTypeField(boolean value) {
            this.requestField("bid_type", value);
            return this;
        }

        public APIRequestGet requestBodyAssetField() {
            return this.requestBodyAssetField(true);
        }

        public APIRequestGet requestBodyAssetField(boolean value) {
            this.requestField("body_asset", value);
            return this;
        }

        public APIRequestGet requestBuyingTypeField() {
            return this.requestBuyingTypeField(true);
        }

        public APIRequestGet requestBuyingTypeField(boolean value) {
            this.requestField("buying_type", value);
            return this;
        }

        public APIRequestGet requestCallToActionAssetField() {
            return this.requestCallToActionAssetField(true);
        }

        public APIRequestGet requestCallToActionAssetField(boolean value) {
            this.requestField("call_to_action_asset", value);
            return this;
        }

        public APIRequestGet requestCampaignIdField() {
            return this.requestCampaignIdField(true);
        }

        public APIRequestGet requestCampaignIdField(boolean value) {
            this.requestField("campaign_id", value);
            return this;
        }

        public APIRequestGet requestCampaignNameField() {
            return this.requestCampaignNameField(true);
        }

        public APIRequestGet requestCampaignNameField(boolean value) {
            this.requestField("campaign_name", value);
            return this;
        }

        public APIRequestGet requestCanvasAvgViewPercentField() {
            return this.requestCanvasAvgViewPercentField(true);
        }

        public APIRequestGet requestCanvasAvgViewPercentField(boolean value) {
            this.requestField("canvas_avg_view_percent", value);
            return this;
        }

        public APIRequestGet requestCanvasAvgViewTimeField() {
            return this.requestCanvasAvgViewTimeField(true);
        }

        public APIRequestGet requestCanvasAvgViewTimeField(boolean value) {
            this.requestField("canvas_avg_view_time", value);
            return this;
        }

        public APIRequestGet requestCanvasComponentAvgPctViewField() {
            return this.requestCanvasComponentAvgPctViewField(true);
        }

        public APIRequestGet requestCanvasComponentAvgPctViewField(boolean value) {
            this.requestField("canvas_component_avg_pct_view", value);
            return this;
        }

        public APIRequestGet requestClicksField() {
            return this.requestClicksField(true);
        }

        public APIRequestGet requestClicksField(boolean value) {
            this.requestField("clicks", value);
            return this;
        }

        public APIRequestGet requestCostPer10SecVideoViewField() {
            return this.requestCostPer10SecVideoViewField(true);
        }

        public APIRequestGet requestCostPer10SecVideoViewField(boolean value) {
            this.requestField("cost_per_10_sec_video_view", value);
            return this;
        }

        public APIRequestGet requestCostPer15SecVideoViewField() {
            return this.requestCostPer15SecVideoViewField(true);
        }

        public APIRequestGet requestCostPer15SecVideoViewField(boolean value) {
            this.requestField("cost_per_15_sec_video_view", value);
            return this;
        }

        public APIRequestGet requestCostPer2SecContinuousVideoViewField() {
            return this.requestCostPer2SecContinuousVideoViewField(true);
        }

        public APIRequestGet requestCostPer2SecContinuousVideoViewField(boolean value) {
            this.requestField("cost_per_2_sec_continuous_video_view", value);
            return this;
        }

        public APIRequestGet requestCostPerActionTypeField() {
            return this.requestCostPerActionTypeField(true);
        }

        public APIRequestGet requestCostPerActionTypeField(boolean value) {
            this.requestField("cost_per_action_type", value);
            return this;
        }

        public APIRequestGet requestCostPerAdClickField() {
            return this.requestCostPerAdClickField(true);
        }

        public APIRequestGet requestCostPerAdClickField(boolean value) {
            this.requestField("cost_per_ad_click", value);
            return this;
        }

        public APIRequestGet requestCostPerDdaCountbyConvsField() {
            return this.requestCostPerDdaCountbyConvsField(true);
        }

        public APIRequestGet requestCostPerDdaCountbyConvsField(boolean value) {
            this.requestField("cost_per_dda_countby_convs", value);
            return this;
        }

        public APIRequestGet requestCostPerEstimatedAdRecallersField() {
            return this.requestCostPerEstimatedAdRecallersField(true);
        }

        public APIRequestGet requestCostPerEstimatedAdRecallersField(boolean value) {
            this.requestField("cost_per_estimated_ad_recallers", value);
            return this;
        }

        public APIRequestGet requestCostPerInlineLinkClickField() {
            return this.requestCostPerInlineLinkClickField(true);
        }

        public APIRequestGet requestCostPerInlineLinkClickField(boolean value) {
            this.requestField("cost_per_inline_link_click", value);
            return this;
        }

        public APIRequestGet requestCostPerInlinePostEngagementField() {
            return this.requestCostPerInlinePostEngagementField(true);
        }

        public APIRequestGet requestCostPerInlinePostEngagementField(boolean value) {
            this.requestField("cost_per_inline_post_engagement", value);
            return this;
        }

        public APIRequestGet requestCostPerOneThousandAdImpressionField() {
            return this.requestCostPerOneThousandAdImpressionField(true);
        }

        public APIRequestGet requestCostPerOneThousandAdImpressionField(boolean value) {
            this.requestField("cost_per_one_thousand_ad_impression", value);
            return this;
        }

        public APIRequestGet requestCostPerOutboundClickField() {
            return this.requestCostPerOutboundClickField(true);
        }

        public APIRequestGet requestCostPerOutboundClickField(boolean value) {
            this.requestField("cost_per_outbound_click", value);
            return this;
        }

        public APIRequestGet requestCostPerThruplayField() {
            return this.requestCostPerThruplayField(true);
        }

        public APIRequestGet requestCostPerThruplayField(boolean value) {
            this.requestField("cost_per_thruplay", value);
            return this;
        }

        public APIRequestGet requestCostPerUniqueActionTypeField() {
            return this.requestCostPerUniqueActionTypeField(true);
        }

        public APIRequestGet requestCostPerUniqueActionTypeField(boolean value) {
            this.requestField("cost_per_unique_action_type", value);
            return this;
        }

        public APIRequestGet requestCostPerUniqueClickField() {
            return this.requestCostPerUniqueClickField(true);
        }

        public APIRequestGet requestCostPerUniqueClickField(boolean value) {
            this.requestField("cost_per_unique_click", value);
            return this;
        }

        public APIRequestGet requestCostPerUniqueInlineLinkClickField() {
            return this.requestCostPerUniqueInlineLinkClickField(true);
        }

        public APIRequestGet requestCostPerUniqueInlineLinkClickField(boolean value) {
            this.requestField("cost_per_unique_inline_link_click", value);
            return this;
        }

        public APIRequestGet requestCostPerUniqueOutboundClickField() {
            return this.requestCostPerUniqueOutboundClickField(true);
        }

        public APIRequestGet requestCostPerUniqueOutboundClickField(boolean value) {
            this.requestField("cost_per_unique_outbound_click", value);
            return this;
        }

        public APIRequestGet requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGet requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGet requestCpcField() {
            return this.requestCpcField(true);
        }

        public APIRequestGet requestCpcField(boolean value) {
            this.requestField("cpc", value);
            return this;
        }

        public APIRequestGet requestCpmField() {
            return this.requestCpmField(true);
        }

        public APIRequestGet requestCpmField(boolean value) {
            this.requestField("cpm", value);
            return this;
        }

        public APIRequestGet requestCppField() {
            return this.requestCppField(true);
        }

        public APIRequestGet requestCppField(boolean value) {
            this.requestField("cpp", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestCreativeFingerprintField() {
            return this.requestCreativeFingerprintField(true);
        }

        public APIRequestGet requestCreativeFingerprintField(boolean value) {
            this.requestField("creative_fingerprint", value);
            return this;
        }

        public APIRequestGet requestCtrField() {
            return this.requestCtrField(true);
        }

        public APIRequestGet requestCtrField(boolean value) {
            this.requestField("ctr", value);
            return this;
        }

        public APIRequestGet requestDateStartField() {
            return this.requestDateStartField(true);
        }

        public APIRequestGet requestDateStartField(boolean value) {
            this.requestField("date_start", value);
            return this;
        }

        public APIRequestGet requestDateStopField() {
            return this.requestDateStopField(true);
        }

        public APIRequestGet requestDateStopField(boolean value) {
            this.requestField("date_stop", value);
            return this;
        }

        public APIRequestGet requestDdaCountbyConvsField() {
            return this.requestDdaCountbyConvsField(true);
        }

        public APIRequestGet requestDdaCountbyConvsField(boolean value) {
            this.requestField("dda_countby_convs", value);
            return this;
        }

        public APIRequestGet requestDescriptionAssetField() {
            return this.requestDescriptionAssetField(true);
        }

        public APIRequestGet requestDescriptionAssetField(boolean value) {
            this.requestField("description_asset", value);
            return this;
        }

        public APIRequestGet requestDevicePlatformField() {
            return this.requestDevicePlatformField(true);
        }

        public APIRequestGet requestDevicePlatformField(boolean value) {
            this.requestField("device_platform", value);
            return this;
        }

        public APIRequestGet requestDmaField() {
            return this.requestDmaField(true);
        }

        public APIRequestGet requestDmaField(boolean value) {
            this.requestField("dma", value);
            return this;
        }

        public APIRequestGet requestEstimatedAdRecallRateField() {
            return this.requestEstimatedAdRecallRateField(true);
        }

        public APIRequestGet requestEstimatedAdRecallRateField(boolean value) {
            this.requestField("estimated_ad_recall_rate", value);
            return this;
        }

        public APIRequestGet requestEstimatedAdRecallRateLowerBoundField() {
            return this.requestEstimatedAdRecallRateLowerBoundField(true);
        }

        public APIRequestGet requestEstimatedAdRecallRateLowerBoundField(boolean value) {
            this.requestField("estimated_ad_recall_rate_lower_bound", value);
            return this;
        }

        public APIRequestGet requestEstimatedAdRecallRateUpperBoundField() {
            return this.requestEstimatedAdRecallRateUpperBoundField(true);
        }

        public APIRequestGet requestEstimatedAdRecallRateUpperBoundField(boolean value) {
            this.requestField("estimated_ad_recall_rate_upper_bound", value);
            return this;
        }

        public APIRequestGet requestEstimatedAdRecallersField() {
            return this.requestEstimatedAdRecallersField(true);
        }

        public APIRequestGet requestEstimatedAdRecallersField(boolean value) {
            this.requestField("estimated_ad_recallers", value);
            return this;
        }

        public APIRequestGet requestEstimatedAdRecallersLowerBoundField() {
            return this.requestEstimatedAdRecallersLowerBoundField(true);
        }

        public APIRequestGet requestEstimatedAdRecallersLowerBoundField(boolean value) {
            this.requestField("estimated_ad_recallers_lower_bound", value);
            return this;
        }

        public APIRequestGet requestEstimatedAdRecallersUpperBoundField() {
            return this.requestEstimatedAdRecallersUpperBoundField(true);
        }

        public APIRequestGet requestEstimatedAdRecallersUpperBoundField(boolean value) {
            this.requestField("estimated_ad_recallers_upper_bound", value);
            return this;
        }

        public APIRequestGet requestFrequencyField() {
            return this.requestFrequencyField(true);
        }

        public APIRequestGet requestFrequencyField(boolean value) {
            this.requestField("frequency", value);
            return this;
        }

        public APIRequestGet requestFrequencyValueField() {
            return this.requestFrequencyValueField(true);
        }

        public APIRequestGet requestFrequencyValueField(boolean value) {
            this.requestField("frequency_value", value);
            return this;
        }

        public APIRequestGet requestGenderField() {
            return this.requestGenderField(true);
        }

        public APIRequestGet requestGenderField(boolean value) {
            this.requestField("gender", value);
            return this;
        }

        public APIRequestGet requestGenderTargetingField() {
            return this.requestGenderTargetingField(true);
        }

        public APIRequestGet requestGenderTargetingField(boolean value) {
            this.requestField("gender_targeting", value);
            return this;
        }

        public APIRequestGet requestHourlyStatsAggregatedByAdvertiserTimeZoneField() {
            return this.requestHourlyStatsAggregatedByAdvertiserTimeZoneField(true);
        }

        public APIRequestGet requestHourlyStatsAggregatedByAdvertiserTimeZoneField(boolean value) {
            this.requestField("hourly_stats_aggregated_by_advertiser_time_zone", value);
            return this;
        }

        public APIRequestGet requestHourlyStatsAggregatedByAudienceTimeZoneField() {
            return this.requestHourlyStatsAggregatedByAudienceTimeZoneField(true);
        }

        public APIRequestGet requestHourlyStatsAggregatedByAudienceTimeZoneField(boolean value) {
            this.requestField("hourly_stats_aggregated_by_audience_time_zone", value);
            return this;
        }

        public APIRequestGet requestImageAssetField() {
            return this.requestImageAssetField(true);
        }

        public APIRequestGet requestImageAssetField(boolean value) {
            this.requestField("image_asset", value);
            return this;
        }

        public APIRequestGet requestImpressionDeviceField() {
            return this.requestImpressionDeviceField(true);
        }

        public APIRequestGet requestImpressionDeviceField(boolean value) {
            this.requestField("impression_device", value);
            return this;
        }

        public APIRequestGet requestImpressionsField() {
            return this.requestImpressionsField(true);
        }

        public APIRequestGet requestImpressionsField(boolean value) {
            this.requestField("impressions", value);
            return this;
        }

        public APIRequestGet requestImpressionsDummyField() {
            return this.requestImpressionsDummyField(true);
        }

        public APIRequestGet requestImpressionsDummyField(boolean value) {
            this.requestField("impressions_dummy", value);
            return this;
        }

        public APIRequestGet requestInlineLinkClickCtrField() {
            return this.requestInlineLinkClickCtrField(true);
        }

        public APIRequestGet requestInlineLinkClickCtrField(boolean value) {
            this.requestField("inline_link_click_ctr", value);
            return this;
        }

        public APIRequestGet requestInlineLinkClicksField() {
            return this.requestInlineLinkClicksField(true);
        }

        public APIRequestGet requestInlineLinkClicksField(boolean value) {
            this.requestField("inline_link_clicks", value);
            return this;
        }

        public APIRequestGet requestInlinePostEngagementField() {
            return this.requestInlinePostEngagementField(true);
        }

        public APIRequestGet requestInlinePostEngagementField(boolean value) {
            this.requestField("inline_post_engagement", value);
            return this;
        }

        public APIRequestGet requestLabelsField() {
            return this.requestLabelsField(true);
        }

        public APIRequestGet requestLabelsField(boolean value) {
            this.requestField("labels", value);
            return this;
        }

        public APIRequestGet requestLinkUrlAssetField() {
            return this.requestLinkUrlAssetField(true);
        }

        public APIRequestGet requestLinkUrlAssetField(boolean value) {
            this.requestField("link_url_asset", value);
            return this;
        }

        public APIRequestGet requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGet requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGet requestMediaAssetField() {
            return this.requestMediaAssetField(true);
        }

        public APIRequestGet requestMediaAssetField(boolean value) {
            this.requestField("media_asset", value);
            return this;
        }

        public APIRequestGet requestMobileAppPurchaseRoasField() {
            return this.requestMobileAppPurchaseRoasField(true);
        }

        public APIRequestGet requestMobileAppPurchaseRoasField(boolean value) {
            this.requestField("mobile_app_purchase_roas", value);
            return this;
        }

        public APIRequestGet requestObjectiveField() {
            return this.requestObjectiveField(true);
        }

        public APIRequestGet requestObjectiveField(boolean value) {
            this.requestField("objective", value);
            return this;
        }

        public APIRequestGet requestOutboundClicksField() {
            return this.requestOutboundClicksField(true);
        }

        public APIRequestGet requestOutboundClicksField(boolean value) {
            this.requestField("outbound_clicks", value);
            return this;
        }

        public APIRequestGet requestOutboundClicksCtrField() {
            return this.requestOutboundClicksCtrField(true);
        }

        public APIRequestGet requestOutboundClicksCtrField(boolean value) {
            this.requestField("outbound_clicks_ctr", value);
            return this;
        }

        public APIRequestGet requestPlacePageIdField() {
            return this.requestPlacePageIdField(true);
        }

        public APIRequestGet requestPlacePageIdField(boolean value) {
            this.requestField("place_page_id", value);
            return this;
        }

        public APIRequestGet requestPlacePageNameField() {
            return this.requestPlacePageNameField(true);
        }

        public APIRequestGet requestPlacePageNameField(boolean value) {
            this.requestField("place_page_name", value);
            return this;
        }

        public APIRequestGet requestPlacementField() {
            return this.requestPlacementField(true);
        }

        public APIRequestGet requestPlacementField(boolean value) {
            this.requestField("placement", value);
            return this;
        }

        public APIRequestGet requestPlatformPositionField() {
            return this.requestPlatformPositionField(true);
        }

        public APIRequestGet requestPlatformPositionField(boolean value) {
            this.requestField("platform_position", value);
            return this;
        }

        public APIRequestGet requestProductFormatField() {
            return this.requestProductFormatField(true);
        }

        public APIRequestGet requestProductFormatField(boolean value) {
            this.requestField("product_format", value);
            return this;
        }

        public APIRequestGet requestProductIdField() {
            return this.requestProductIdField(true);
        }

        public APIRequestGet requestProductIdField(boolean value) {
            this.requestField("product_id", value);
            return this;
        }

        public APIRequestGet requestPublisherPlatformField() {
            return this.requestPublisherPlatformField(true);
        }

        public APIRequestGet requestPublisherPlatformField(boolean value) {
            this.requestField("publisher_platform", value);
            return this;
        }

        public APIRequestGet requestPurchasingInterfaceField() {
            return this.requestPurchasingInterfaceField(true);
        }

        public APIRequestGet requestPurchasingInterfaceField(boolean value) {
            this.requestField("purchasing_interface", value);
            return this;
        }

        public APIRequestGet requestReachField() {
            return this.requestReachField(true);
        }

        public APIRequestGet requestReachField(boolean value) {
            this.requestField("reach", value);
            return this;
        }

        public APIRequestGet requestRegionField() {
            return this.requestRegionField(true);
        }

        public APIRequestGet requestRegionField(boolean value) {
            this.requestField("region", value);
            return this;
        }

        public APIRequestGet requestRelevanceScoreField() {
            return this.requestRelevanceScoreField(true);
        }

        public APIRequestGet requestRelevanceScoreField(boolean value) {
            this.requestField("relevance_score", value);
            return this;
        }

        public APIRequestGet requestRuleAssetField() {
            return this.requestRuleAssetField(true);
        }

        public APIRequestGet requestRuleAssetField(boolean value) {
            this.requestField("rule_asset", value);
            return this;
        }

        public APIRequestGet requestSocialSpendField() {
            return this.requestSocialSpendField(true);
        }

        public APIRequestGet requestSocialSpendField(boolean value) {
            this.requestField("social_spend", value);
            return this;
        }

        public APIRequestGet requestSpendField() {
            return this.requestSpendField(true);
        }

        public APIRequestGet requestSpendField(boolean value) {
            this.requestField("spend", value);
            return this;
        }

        public APIRequestGet requestTitleAssetField() {
            return this.requestTitleAssetField(true);
        }

        public APIRequestGet requestTitleAssetField(boolean value) {
            this.requestField("title_asset", value);
            return this;
        }

        public APIRequestGet requestUniqueActionsField() {
            return this.requestUniqueActionsField(true);
        }

        public APIRequestGet requestUniqueActionsField(boolean value) {
            this.requestField("unique_actions", value);
            return this;
        }

        public APIRequestGet requestUniqueClicksField() {
            return this.requestUniqueClicksField(true);
        }

        public APIRequestGet requestUniqueClicksField(boolean value) {
            this.requestField("unique_clicks", value);
            return this;
        }

        public APIRequestGet requestUniqueCtrField() {
            return this.requestUniqueCtrField(true);
        }

        public APIRequestGet requestUniqueCtrField(boolean value) {
            this.requestField("unique_ctr", value);
            return this;
        }

        public APIRequestGet requestUniqueInlineLinkClickCtrField() {
            return this.requestUniqueInlineLinkClickCtrField(true);
        }

        public APIRequestGet requestUniqueInlineLinkClickCtrField(boolean value) {
            this.requestField("unique_inline_link_click_ctr", value);
            return this;
        }

        public APIRequestGet requestUniqueInlineLinkClicksField() {
            return this.requestUniqueInlineLinkClicksField(true);
        }

        public APIRequestGet requestUniqueInlineLinkClicksField(boolean value) {
            this.requestField("unique_inline_link_clicks", value);
            return this;
        }

        public APIRequestGet requestUniqueLinkClicksCtrField() {
            return this.requestUniqueLinkClicksCtrField(true);
        }

        public APIRequestGet requestUniqueLinkClicksCtrField(boolean value) {
            this.requestField("unique_link_clicks_ctr", value);
            return this;
        }

        public APIRequestGet requestUniqueOutboundClicksField() {
            return this.requestUniqueOutboundClicksField(true);
        }

        public APIRequestGet requestUniqueOutboundClicksField(boolean value) {
            this.requestField("unique_outbound_clicks", value);
            return this;
        }

        public APIRequestGet requestUniqueOutboundClicksCtrField() {
            return this.requestUniqueOutboundClicksCtrField(true);
        }

        public APIRequestGet requestUniqueOutboundClicksCtrField(boolean value) {
            this.requestField("unique_outbound_clicks_ctr", value);
            return this;
        }

        public APIRequestGet requestUniqueVideoContinuous2SecWatchedActionsField() {
            return this.requestUniqueVideoContinuous2SecWatchedActionsField(true);
        }

        public APIRequestGet requestUniqueVideoContinuous2SecWatchedActionsField(boolean value) {
            this.requestField("unique_video_continuous_2_sec_watched_actions", value);
            return this;
        }

        public APIRequestGet requestUniqueVideoView10SecField() {
            return this.requestUniqueVideoView10SecField(true);
        }

        public APIRequestGet requestUniqueVideoView10SecField(boolean value) {
            this.requestField("unique_video_view_10_sec", value);
            return this;
        }

        public APIRequestGet requestUniqueVideoView15SecField() {
            return this.requestUniqueVideoView15SecField(true);
        }

        public APIRequestGet requestUniqueVideoView15SecField(boolean value) {
            this.requestField("unique_video_view_15_sec", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGet requestVideo10SecWatchedActionsField() {
            return this.requestVideo10SecWatchedActionsField(true);
        }

        public APIRequestGet requestVideo10SecWatchedActionsField(boolean value) {
            this.requestField("video_10_sec_watched_actions", value);
            return this;
        }

        public APIRequestGet requestVideo15SecWatchedActionsField() {
            return this.requestVideo15SecWatchedActionsField(true);
        }

        public APIRequestGet requestVideo15SecWatchedActionsField(boolean value) {
            this.requestField("video_15_sec_watched_actions", value);
            return this;
        }

        public APIRequestGet requestVideo30SecWatchedActionsField() {
            return this.requestVideo30SecWatchedActionsField(true);
        }

        public APIRequestGet requestVideo30SecWatchedActionsField(boolean value) {
            this.requestField("video_30_sec_watched_actions", value);
            return this;
        }

        public APIRequestGet requestVideoAssetField() {
            return this.requestVideoAssetField(true);
        }

        public APIRequestGet requestVideoAssetField(boolean value) {
            this.requestField("video_asset", value);
            return this;
        }

        public APIRequestGet requestVideoAvgPercentWatchedActionsField() {
            return this.requestVideoAvgPercentWatchedActionsField(true);
        }

        public APIRequestGet requestVideoAvgPercentWatchedActionsField(boolean value) {
            this.requestField("video_avg_percent_watched_actions", value);
            return this;
        }

        public APIRequestGet requestVideoAvgTimeWatchedActionsField() {
            return this.requestVideoAvgTimeWatchedActionsField(true);
        }

        public APIRequestGet requestVideoAvgTimeWatchedActionsField(boolean value) {
            this.requestField("video_avg_time_watched_actions", value);
            return this;
        }

        public APIRequestGet requestVideoContinuous2SecWatchedActionsField() {
            return this.requestVideoContinuous2SecWatchedActionsField(true);
        }

        public APIRequestGet requestVideoContinuous2SecWatchedActionsField(boolean value) {
            this.requestField("video_continuous_2_sec_watched_actions", value);
            return this;
        }

        public APIRequestGet requestVideoP100WatchedActionsField() {
            return this.requestVideoP100WatchedActionsField(true);
        }

        public APIRequestGet requestVideoP100WatchedActionsField(boolean value) {
            this.requestField("video_p100_watched_actions", value);
            return this;
        }

        public APIRequestGet requestVideoP25WatchedActionsField() {
            return this.requestVideoP25WatchedActionsField(true);
        }

        public APIRequestGet requestVideoP25WatchedActionsField(boolean value) {
            this.requestField("video_p25_watched_actions", value);
            return this;
        }

        public APIRequestGet requestVideoP50WatchedActionsField() {
            return this.requestVideoP50WatchedActionsField(true);
        }

        public APIRequestGet requestVideoP50WatchedActionsField(boolean value) {
            this.requestField("video_p50_watched_actions", value);
            return this;
        }

        public APIRequestGet requestVideoP75WatchedActionsField() {
            return this.requestVideoP75WatchedActionsField(true);
        }

        public APIRequestGet requestVideoP75WatchedActionsField(boolean value) {
            this.requestField("video_p75_watched_actions", value);
            return this;
        }

        public APIRequestGet requestVideoP95WatchedActionsField() {
            return this.requestVideoP95WatchedActionsField(true);
        }

        public APIRequestGet requestVideoP95WatchedActionsField(boolean value) {
            this.requestField("video_p95_watched_actions", value);
            return this;
        }

        public APIRequestGet requestVideoPlayActionsField() {
            return this.requestVideoPlayActionsField(true);
        }

        public APIRequestGet requestVideoPlayActionsField(boolean value) {
            this.requestField("video_play_actions", value);
            return this;
        }

        public APIRequestGet requestVideoPlayRetention0To15sActionsField() {
            return this.requestVideoPlayRetention0To15sActionsField(true);
        }

        public APIRequestGet requestVideoPlayRetention0To15sActionsField(boolean value) {
            this.requestField("video_play_retention_0_to_15s_actions", value);
            return this;
        }

        public APIRequestGet requestVideoPlayRetention20To60sActionsField() {
            return this.requestVideoPlayRetention20To60sActionsField(true);
        }

        public APIRequestGet requestVideoPlayRetention20To60sActionsField(boolean value) {
            this.requestField("video_play_retention_20_to_60s_actions", value);
            return this;
        }

        public APIRequestGet requestVideoPlayRetentionGraphActionsField() {
            return this.requestVideoPlayRetentionGraphActionsField(true);
        }

        public APIRequestGet requestVideoPlayRetentionGraphActionsField(boolean value) {
            this.requestField("video_play_retention_graph_actions", value);
            return this;
        }

        public APIRequestGet requestVideoThruplayWatchedActionsField() {
            return this.requestVideoThruplayWatchedActionsField(true);
        }

        public APIRequestGet requestVideoThruplayWatchedActionsField(boolean value) {
            this.requestField("video_thruplay_watched_actions", value);
            return this;
        }

        public APIRequestGet requestVideoTimeWatchedActionsField() {
            return this.requestVideoTimeWatchedActionsField(true);
        }

        public APIRequestGet requestVideoTimeWatchedActionsField(boolean value) {
            this.requestField("video_time_watched_actions", value);
            return this;
        }

        public APIRequestGet requestWebsiteCtrField() {
            return this.requestWebsiteCtrField(true);
        }

        public APIRequestGet requestWebsiteCtrField(boolean value) {
            this.requestField("website_ctr", value);
            return this;
        }

        public APIRequestGet requestWebsitePurchaseRoasField() {
            return this.requestWebsitePurchaseRoasField(true);
        }

        public APIRequestGet requestWebsitePurchaseRoasField(boolean value) {
            this.requestField("website_purchase_roas", value);
            return this;
        }

        public APIRequestGet requestWishBidField() {
            return this.requestWishBidField(true);
        }

        public APIRequestGet requestWishBidField(boolean value) {
            this.requestField("wish_bid", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

