/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdNetworkAnalyticsAsyncQueryResult;
import com.facebook.ads.sdk.AdNetworkAnalyticsSyncQueryResult;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdMonetizationProperty
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdMonetizationProperty() {
    }

    public AdMonetizationProperty(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdMonetizationProperty(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdMonetizationProperty fetch() throws APIException {
        AdMonetizationProperty newInstance = AdMonetizationProperty.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdMonetizationProperty fetchById(Long id, APIContext context) throws APIException {
        return AdMonetizationProperty.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdMonetizationProperty> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdMonetizationProperty.fetchByIdAsync(id.toString(), context);
    }

    public static AdMonetizationProperty fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdMonetizationProperty> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdMonetizationProperty> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdMonetizationProperty>(context, "", "/", "GET", AdMonetizationProperty.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdMonetizationProperty>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdMonetizationProperty>(context, "", "/", "GET", AdMonetizationProperty.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdMonetizationProperty loadJSON(String json, APIContext context) {
        AdMonetizationProperty adMonetizationProperty = (AdMonetizationProperty)AdMonetizationProperty.getGson().fromJson(json, AdMonetizationProperty.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adMonetizationProperty.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adMonetizationProperty.context = context;
        adMonetizationProperty.rawValue = json;
        return adMonetizationProperty;
    }

    public static APINodeList<AdMonetizationProperty> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdMonetizationProperty> adMonetizationPropertys = new APINodeList<AdMonetizationProperty>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adMonetizationPropertys.add(AdMonetizationProperty.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adMonetizationPropertys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adMonetizationPropertys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adMonetizationPropertys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adMonetizationPropertys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adMonetizationPropertys.add(AdMonetizationProperty.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adMonetizationPropertys.add(AdMonetizationProperty.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adMonetizationPropertys.add(AdMonetizationProperty.loadJSON(obj.toString(), context));
                        }
                    }
                    return adMonetizationPropertys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adMonetizationPropertys.add(AdMonetizationProperty.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adMonetizationPropertys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adMonetizationPropertys.add(AdMonetizationProperty.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adMonetizationPropertys;
                }
                adMonetizationPropertys.clear();
                adMonetizationPropertys.add(AdMonetizationProperty.loadJSON(json, context));
                return adMonetizationPropertys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdMonetizationProperty.getGson().toJson((Object)this);
    }

    public APIRequestGetAdNetworkAnalytics getAdNetworkAnalytics() {
        return new APIRequestGetAdNetworkAnalytics(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAdNetworkAnalytic createAdNetworkAnalytic() {
        return new APIRequestCreateAdNetworkAnalytic(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAdNetworkAnalyticsResults getAdNetworkAnalyticsResults() {
        return new APIRequestGetAdNetworkAnalyticsResults(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdMonetizationProperty copyFrom(AdMonetizationProperty instance) {
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdMonetizationProperty> getParser() {
        return new APIRequest.ResponseParser<AdMonetizationProperty>(){

            @Override
            public APINodeList<AdMonetizationProperty> parseResponse(String response, APIContext context, APIRequest<AdMonetizationProperty> request) throws APIException.MalformedResponseException {
                return AdMonetizationProperty.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdMonetizationProperty> {
        AdMonetizationProperty lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id"};

        @Override
        public AdMonetizationProperty getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdMonetizationProperty parseResponse(String response) throws APIException {
            return AdMonetizationProperty.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdMonetizationProperty execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdMonetizationProperty execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdMonetizationProperty> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdMonetizationProperty> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdMonetizationProperty>(){

                public AdMonetizationProperty apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdNetworkAnalyticsResults
    extends APIRequest<AdNetworkAnalyticsAsyncQueryResult> {
        APINodeList<AdNetworkAnalyticsAsyncQueryResult> lastResponse = null;
        public static final String[] PARAMS = new String[]{"query_ids"};
        public static final String[] FIELDS = new String[]{"data", "error", "query_id", "results", "status", "id"};

        @Override
        public APINodeList<AdNetworkAnalyticsAsyncQueryResult> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdNetworkAnalyticsAsyncQueryResult> parseResponse(String response) throws APIException {
            return AdNetworkAnalyticsAsyncQueryResult.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdNetworkAnalyticsAsyncQueryResult> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdNetworkAnalyticsAsyncQueryResult> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdNetworkAnalyticsAsyncQueryResult>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdNetworkAnalyticsAsyncQueryResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdNetworkAnalyticsAsyncQueryResult>>(){

                public APINodeList<AdNetworkAnalyticsAsyncQueryResult> apply(String result) {
                    try {
                        return APIRequestGetAdNetworkAnalyticsResults.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdNetworkAnalyticsResults(String nodeId, APIContext context) {
            super(context, nodeId, "/adnetworkanalytics_results", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdNetworkAnalyticsResults setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdNetworkAnalyticsResults setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdNetworkAnalyticsResults setQueryIds(List<String> queryIds) {
            this.setParam("query_ids", queryIds);
            return this;
        }

        public APIRequestGetAdNetworkAnalyticsResults setQueryIds(String queryIds) {
            this.setParam("query_ids", queryIds);
            return this;
        }

        public APIRequestGetAdNetworkAnalyticsResults requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdNetworkAnalyticsResults requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdNetworkAnalyticsResults requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdNetworkAnalyticsResults requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdNetworkAnalyticsResults requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdNetworkAnalyticsResults requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdNetworkAnalyticsResults requestDataField() {
            return this.requestDataField(true);
        }

        public APIRequestGetAdNetworkAnalyticsResults requestDataField(boolean value) {
            this.requestField("data", value);
            return this;
        }

        public APIRequestGetAdNetworkAnalyticsResults requestErrorField() {
            return this.requestErrorField(true);
        }

        public APIRequestGetAdNetworkAnalyticsResults requestErrorField(boolean value) {
            this.requestField("error", value);
            return this;
        }

        public APIRequestGetAdNetworkAnalyticsResults requestQueryIdField() {
            return this.requestQueryIdField(true);
        }

        public APIRequestGetAdNetworkAnalyticsResults requestQueryIdField(boolean value) {
            this.requestField("query_id", value);
            return this;
        }

        public APIRequestGetAdNetworkAnalyticsResults requestResultsField() {
            return this.requestResultsField(true);
        }

        public APIRequestGetAdNetworkAnalyticsResults requestResultsField(boolean value) {
            this.requestField("results", value);
            return this;
        }

        public APIRequestGetAdNetworkAnalyticsResults requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGetAdNetworkAnalyticsResults requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGetAdNetworkAnalyticsResults requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdNetworkAnalyticsResults requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateAdNetworkAnalytic
    extends APIRequest<AdMonetizationProperty> {
        AdMonetizationProperty lastResponse = null;
        public static final String[] PARAMS = new String[]{"aggregation_period", "breakdowns", "metrics", "filters", "limit", "ordering_column", "ordering_type", "since", "until"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdMonetizationProperty getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdMonetizationProperty parseResponse(String response) throws APIException {
            return AdMonetizationProperty.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdMonetizationProperty execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdMonetizationProperty execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdMonetizationProperty> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdMonetizationProperty> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdMonetizationProperty>(){

                public AdMonetizationProperty apply(String result) {
                    try {
                        return APIRequestCreateAdNetworkAnalytic.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateAdNetworkAnalytic(String nodeId, APIContext context) {
            super(context, nodeId, "/adnetworkanalytics", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAdNetworkAnalytic setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAdNetworkAnalytic setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setAggregationPeriod(AdNetworkAnalyticsSyncQueryResult.EnumAggregationPeriod aggregationPeriod) {
            this.setParam("aggregation_period", (Object)aggregationPeriod);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setAggregationPeriod(String aggregationPeriod) {
            this.setParam("aggregation_period", aggregationPeriod);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setBreakdowns(List<AdNetworkAnalyticsSyncQueryResult.EnumBreakdowns> breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setBreakdowns(String breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setMetrics(List<AdNetworkAnalyticsSyncQueryResult.EnumMetrics> metrics) {
            this.setParam("metrics", metrics);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setMetrics(String metrics) {
            this.setParam("metrics", metrics);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setFilters(List<Object> filters) {
            this.setParam("filters", filters);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setFilters(String filters) {
            this.setParam("filters", filters);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setLimit(Long limit) {
            this.setParam("limit", limit);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setLimit(String limit) {
            this.setParam("limit", limit);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setOrderingColumn(AdNetworkAnalyticsSyncQueryResult.EnumOrderingColumn orderingColumn) {
            this.setParam("ordering_column", (Object)orderingColumn);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setOrderingColumn(String orderingColumn) {
            this.setParam("ordering_column", orderingColumn);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setOrderingType(AdNetworkAnalyticsSyncQueryResult.EnumOrderingType orderingType) {
            this.setParam("ordering_type", (Object)orderingType);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setOrderingType(String orderingType) {
            this.setParam("ordering_type", orderingType);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setSince(Object since) {
            this.setParam("since", since);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setSince(String since) {
            this.setParam("since", since);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setUntil(Object until) {
            this.setParam("until", until);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic setUntil(String until) {
            this.setParam("until", until);
            return this;
        }

        public APIRequestCreateAdNetworkAnalytic requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAdNetworkAnalytic requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdNetworkAnalytic requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAdNetworkAnalytic requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAdNetworkAnalytic requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAdNetworkAnalytic requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetAdNetworkAnalytics
    extends APIRequest<AdNetworkAnalyticsSyncQueryResult> {
        APINodeList<AdNetworkAnalyticsSyncQueryResult> lastResponse = null;
        public static final String[] PARAMS = new String[]{"aggregation_period", "breakdowns", "filters", "limit", "metrics", "ordering_column", "ordering_type", "since", "until"};
        public static final String[] FIELDS = new String[]{"query_id", "results", "id"};

        @Override
        public APINodeList<AdNetworkAnalyticsSyncQueryResult> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdNetworkAnalyticsSyncQueryResult> parseResponse(String response) throws APIException {
            return AdNetworkAnalyticsSyncQueryResult.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<AdNetworkAnalyticsSyncQueryResult> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdNetworkAnalyticsSyncQueryResult> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdNetworkAnalyticsSyncQueryResult>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdNetworkAnalyticsSyncQueryResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, APINodeList<AdNetworkAnalyticsSyncQueryResult>>(){

                public APINodeList<AdNetworkAnalyticsSyncQueryResult> apply(String result) {
                    try {
                        return APIRequestGetAdNetworkAnalytics.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetAdNetworkAnalytics(String nodeId, APIContext context) {
            super(context, nodeId, "/adnetworkanalytics", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAdNetworkAnalytics setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAdNetworkAnalytics setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setAggregationPeriod(AdNetworkAnalyticsSyncQueryResult.EnumAggregationPeriod aggregationPeriod) {
            this.setParam("aggregation_period", (Object)aggregationPeriod);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setAggregationPeriod(String aggregationPeriod) {
            this.setParam("aggregation_period", aggregationPeriod);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setBreakdowns(List<AdNetworkAnalyticsSyncQueryResult.EnumBreakdowns> breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setBreakdowns(String breakdowns) {
            this.setParam("breakdowns", breakdowns);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setFilters(List<Map<String, String>> filters) {
            this.setParam("filters", filters);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setFilters(String filters) {
            this.setParam("filters", filters);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setLimit(Long limit) {
            this.setParam("limit", limit);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setLimit(String limit) {
            this.setParam("limit", limit);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setMetrics(List<AdNetworkAnalyticsSyncQueryResult.EnumMetrics> metrics) {
            this.setParam("metrics", metrics);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setMetrics(String metrics) {
            this.setParam("metrics", metrics);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setOrderingColumn(AdNetworkAnalyticsSyncQueryResult.EnumOrderingColumn orderingColumn) {
            this.setParam("ordering_column", (Object)orderingColumn);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setOrderingColumn(String orderingColumn) {
            this.setParam("ordering_column", orderingColumn);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setOrderingType(AdNetworkAnalyticsSyncQueryResult.EnumOrderingType orderingType) {
            this.setParam("ordering_type", (Object)orderingType);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setOrderingType(String orderingType) {
            this.setParam("ordering_type", orderingType);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setSince(Object since) {
            this.setParam("since", since);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setSince(String since) {
            this.setParam("since", since);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setUntil(Object until) {
            this.setParam("until", until);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics setUntil(String until) {
            this.setParam("until", until);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAdNetworkAnalytics requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdNetworkAnalytics requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAdNetworkAnalytics requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAdNetworkAnalytics requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAdNetworkAnalytics requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics requestQueryIdField() {
            return this.requestQueryIdField(true);
        }

        public APIRequestGetAdNetworkAnalytics requestQueryIdField(boolean value) {
            this.requestField("query_id", value);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics requestResultsField() {
            return this.requestResultsField(true);
        }

        public APIRequestGetAdNetworkAnalytics requestResultsField(boolean value) {
            this.requestField("results", value);
            return this;
        }

        public APIRequestGetAdNetworkAnalytics requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAdNetworkAnalytics requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

