/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdCreativeTemplateURLSpec;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCustomizationRuleSpec
extends APINode {
    @SerializedName(value="caption")
    private String mCaption = null;
    @SerializedName(value="customization_spec")
    private Object mCustomizationSpec = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="priority")
    private Long mPriority = null;
    @SerializedName(value="template_url_spec")
    private AdCreativeTemplateURLSpec mTemplateUrlSpec = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdCustomizationRuleSpec() {
    }

    public AdCustomizationRuleSpec(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCustomizationRuleSpec(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCustomizationRuleSpec fetch() throws APIException {
        AdCustomizationRuleSpec newInstance = AdCustomizationRuleSpec.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCustomizationRuleSpec fetchById(Long id, APIContext context) throws APIException {
        return AdCustomizationRuleSpec.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCustomizationRuleSpec> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCustomizationRuleSpec.fetchByIdAsync(id.toString(), context);
    }

    public static AdCustomizationRuleSpec fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCustomizationRuleSpec> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCustomizationRuleSpec> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCustomizationRuleSpec>(context, "", "/", "GET", AdCustomizationRuleSpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCustomizationRuleSpec>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCustomizationRuleSpec>(context, "", "/", "GET", AdCustomizationRuleSpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCustomizationRuleSpec loadJSON(String json, APIContext context) {
        AdCustomizationRuleSpec adCustomizationRuleSpec = (AdCustomizationRuleSpec)AdCustomizationRuleSpec.getGson().fromJson(json, AdCustomizationRuleSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCustomizationRuleSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCustomizationRuleSpec.context = context;
        adCustomizationRuleSpec.rawValue = json;
        return adCustomizationRuleSpec;
    }

    public static APINodeList<AdCustomizationRuleSpec> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCustomizationRuleSpec> adCustomizationRuleSpecs = new APINodeList<AdCustomizationRuleSpec>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCustomizationRuleSpecs.add(AdCustomizationRuleSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCustomizationRuleSpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCustomizationRuleSpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCustomizationRuleSpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCustomizationRuleSpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCustomizationRuleSpecs.add(AdCustomizationRuleSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCustomizationRuleSpecs.add(AdCustomizationRuleSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCustomizationRuleSpecs.add(AdCustomizationRuleSpec.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCustomizationRuleSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCustomizationRuleSpecs.add(AdCustomizationRuleSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCustomizationRuleSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCustomizationRuleSpecs.add(AdCustomizationRuleSpec.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCustomizationRuleSpecs;
                }
                adCustomizationRuleSpecs.clear();
                adCustomizationRuleSpecs.add(AdCustomizationRuleSpec.loadJSON(json, context));
                return adCustomizationRuleSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCustomizationRuleSpec.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCaption() {
        return this.mCaption;
    }

    public Object getFieldCustomizationSpec() {
        return this.mCustomizationSpec;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Long getFieldPriority() {
        return this.mPriority;
    }

    public AdCreativeTemplateURLSpec getFieldTemplateUrlSpec() {
        if (this.mTemplateUrlSpec != null) {
            this.mTemplateUrlSpec.context = this.getContext();
        }
        return this.mTemplateUrlSpec;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCustomizationRuleSpec copyFrom(AdCustomizationRuleSpec instance) {
        this.mCaption = instance.mCaption;
        this.mCustomizationSpec = instance.mCustomizationSpec;
        this.mDescription = instance.mDescription;
        this.mLink = instance.mLink;
        this.mMessage = instance.mMessage;
        this.mName = instance.mName;
        this.mPriority = instance.mPriority;
        this.mTemplateUrlSpec = instance.mTemplateUrlSpec;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCustomizationRuleSpec> getParser() {
        return new APIRequest.ResponseParser<AdCustomizationRuleSpec>(){

            @Override
            public APINodeList<AdCustomizationRuleSpec> parseResponse(String response, APIContext context, APIRequest<AdCustomizationRuleSpec> request) throws APIException.MalformedResponseException {
                return AdCustomizationRuleSpec.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCustomizationRuleSpec> {
        AdCustomizationRuleSpec lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"caption", "customization_spec", "description", "link", "message", "name", "priority", "template_url_spec", "id"};

        @Override
        public AdCustomizationRuleSpec getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCustomizationRuleSpec parseResponse(String response) throws APIException {
            return AdCustomizationRuleSpec.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCustomizationRuleSpec execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCustomizationRuleSpec execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCustomizationRuleSpec> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCustomizationRuleSpec> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCustomizationRuleSpec>(){

                public AdCustomizationRuleSpec apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCaptionField() {
            return this.requestCaptionField(true);
        }

        public APIRequestGet requestCaptionField(boolean value) {
            this.requestField("caption", value);
            return this;
        }

        public APIRequestGet requestCustomizationSpecField() {
            return this.requestCustomizationSpecField(true);
        }

        public APIRequestGet requestCustomizationSpecField(boolean value) {
            this.requestField("customization_spec", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGet requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGet requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGet requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPriorityField() {
            return this.requestPriorityField(true);
        }

        public APIRequestGet requestPriorityField(boolean value) {
            this.requestField("priority", value);
            return this;
        }

        public APIRequestGet requestTemplateUrlSpecField() {
            return this.requestTemplateUrlSpecField(true);
        }

        public APIRequestGet requestTemplateUrlSpecField(boolean value) {
            this.requestField("template_url_spec", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

