/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCampaignLearningStageInfo
extends APINode {
    @SerializedName(value="attribution_windows")
    private List<String> mAttributionWindows = null;
    @SerializedName(value="conversions")
    private Object mConversions = null;
    @SerializedName(value="exit_reason")
    private String mExitReason = null;
    @SerializedName(value="last_sig_edit_ts")
    private Long mLastSigEditTs = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="types")
    private List<String> mTypes = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdCampaignLearningStageInfo() {
    }

    public AdCampaignLearningStageInfo(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCampaignLearningStageInfo(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCampaignLearningStageInfo fetch() throws APIException {
        AdCampaignLearningStageInfo newInstance = AdCampaignLearningStageInfo.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCampaignLearningStageInfo fetchById(Long id, APIContext context) throws APIException {
        return AdCampaignLearningStageInfo.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCampaignLearningStageInfo> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCampaignLearningStageInfo.fetchByIdAsync(id.toString(), context);
    }

    public static AdCampaignLearningStageInfo fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCampaignLearningStageInfo> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCampaignLearningStageInfo> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCampaignLearningStageInfo>(context, "", "/", "GET", AdCampaignLearningStageInfo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCampaignLearningStageInfo>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCampaignLearningStageInfo>(context, "", "/", "GET", AdCampaignLearningStageInfo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCampaignLearningStageInfo loadJSON(String json, APIContext context) {
        AdCampaignLearningStageInfo adCampaignLearningStageInfo = (AdCampaignLearningStageInfo)AdCampaignLearningStageInfo.getGson().fromJson(json, AdCampaignLearningStageInfo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCampaignLearningStageInfo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCampaignLearningStageInfo.context = context;
        adCampaignLearningStageInfo.rawValue = json;
        return adCampaignLearningStageInfo;
    }

    public static APINodeList<AdCampaignLearningStageInfo> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCampaignLearningStageInfo> adCampaignLearningStageInfos = new APINodeList<AdCampaignLearningStageInfo>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCampaignLearningStageInfos.add(AdCampaignLearningStageInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCampaignLearningStageInfos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCampaignLearningStageInfos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCampaignLearningStageInfos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCampaignLearningStageInfos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCampaignLearningStageInfos.add(AdCampaignLearningStageInfo.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCampaignLearningStageInfos.add(AdCampaignLearningStageInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCampaignLearningStageInfos.add(AdCampaignLearningStageInfo.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCampaignLearningStageInfos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCampaignLearningStageInfos.add(AdCampaignLearningStageInfo.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCampaignLearningStageInfos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCampaignLearningStageInfos.add(AdCampaignLearningStageInfo.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCampaignLearningStageInfos;
                }
                adCampaignLearningStageInfos.clear();
                adCampaignLearningStageInfos.add(AdCampaignLearningStageInfo.loadJSON(json, context));
                return adCampaignLearningStageInfos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCampaignLearningStageInfo.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldAttributionWindows() {
        return this.mAttributionWindows;
    }

    public Object getFieldConversions() {
        return this.mConversions;
    }

    public String getFieldExitReason() {
        return this.mExitReason;
    }

    public Long getFieldLastSigEditTs() {
        return this.mLastSigEditTs;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public List<String> getFieldTypes() {
        return this.mTypes;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCampaignLearningStageInfo copyFrom(AdCampaignLearningStageInfo instance) {
        this.mAttributionWindows = instance.mAttributionWindows;
        this.mConversions = instance.mConversions;
        this.mExitReason = instance.mExitReason;
        this.mLastSigEditTs = instance.mLastSigEditTs;
        this.mStatus = instance.mStatus;
        this.mTypes = instance.mTypes;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCampaignLearningStageInfo> getParser() {
        return new APIRequest.ResponseParser<AdCampaignLearningStageInfo>(){

            @Override
            public APINodeList<AdCampaignLearningStageInfo> parseResponse(String response, APIContext context, APIRequest<AdCampaignLearningStageInfo> request) throws APIException.MalformedResponseException {
                return AdCampaignLearningStageInfo.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCampaignLearningStageInfo> {
        AdCampaignLearningStageInfo lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"attribution_windows", "conversions", "exit_reason", "last_sig_edit_ts", "status", "types", "id"};

        @Override
        public AdCampaignLearningStageInfo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCampaignLearningStageInfo parseResponse(String response) throws APIException {
            return AdCampaignLearningStageInfo.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCampaignLearningStageInfo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCampaignLearningStageInfo execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCampaignLearningStageInfo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCampaignLearningStageInfo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCampaignLearningStageInfo>(){

                public AdCampaignLearningStageInfo apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAttributionWindowsField() {
            return this.requestAttributionWindowsField(true);
        }

        public APIRequestGet requestAttributionWindowsField(boolean value) {
            this.requestField("attribution_windows", value);
            return this;
        }

        public APIRequestGet requestConversionsField() {
            return this.requestConversionsField(true);
        }

        public APIRequestGet requestConversionsField(boolean value) {
            this.requestField("conversions", value);
            return this;
        }

        public APIRequestGet requestExitReasonField() {
            return this.requestExitReasonField(true);
        }

        public APIRequestGet requestExitReasonField(boolean value) {
            this.requestField("exit_reason", value);
            return this;
        }

        public APIRequestGet requestLastSigEditTsField() {
            return this.requestLastSigEditTsField(true);
        }

        public APIRequestGet requestLastSigEditTsField(boolean value) {
            this.requestField("last_sig_edit_ts", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestTypesField() {
            return this.requestTypesField(true);
        }

        public APIRequestGet requestTypesField(boolean value) {
            this.requestField("types", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

