/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAssetFeedSpecAssetLabel;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAssetFeedSpecLinkURL
extends APINode {
    @SerializedName(value="adlabels")
    private List<AdAssetFeedSpecAssetLabel> mAdlabels = null;
    @SerializedName(value="carousel_see_more_url")
    private String mCarouselSeeMoreUrl = null;
    @SerializedName(value="deeplink_url")
    private String mDeeplinkUrl = null;
    @SerializedName(value="display_url")
    private String mDisplayUrl = null;
    @SerializedName(value="url_tags")
    private String mUrlTags = null;
    @SerializedName(value="website_url")
    private String mWebsiteUrl = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdAssetFeedSpecLinkURL() {
    }

    public AdAssetFeedSpecLinkURL(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdAssetFeedSpecLinkURL(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdAssetFeedSpecLinkURL fetch() throws APIException {
        AdAssetFeedSpecLinkURL newInstance = AdAssetFeedSpecLinkURL.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdAssetFeedSpecLinkURL fetchById(Long id, APIContext context) throws APIException {
        return AdAssetFeedSpecLinkURL.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdAssetFeedSpecLinkURL> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdAssetFeedSpecLinkURL.fetchByIdAsync(id.toString(), context);
    }

    public static AdAssetFeedSpecLinkURL fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdAssetFeedSpecLinkURL> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdAssetFeedSpecLinkURL> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdAssetFeedSpecLinkURL>(context, "", "/", "GET", AdAssetFeedSpecLinkURL.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdAssetFeedSpecLinkURL>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdAssetFeedSpecLinkURL>(context, "", "/", "GET", AdAssetFeedSpecLinkURL.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAssetFeedSpecLinkURL loadJSON(String json, APIContext context) {
        AdAssetFeedSpecLinkURL adAssetFeedSpecLinkURL = (AdAssetFeedSpecLinkURL)AdAssetFeedSpecLinkURL.getGson().fromJson(json, AdAssetFeedSpecLinkURL.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAssetFeedSpecLinkURL.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAssetFeedSpecLinkURL.context = context;
        adAssetFeedSpecLinkURL.rawValue = json;
        return adAssetFeedSpecLinkURL;
    }

    public static APINodeList<AdAssetFeedSpecLinkURL> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAssetFeedSpecLinkURL> adAssetFeedSpecLinkURLs = new APINodeList<AdAssetFeedSpecLinkURL>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAssetFeedSpecLinkURLs.add(AdAssetFeedSpecLinkURL.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adAssetFeedSpecLinkURLs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAssetFeedSpecLinkURLs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAssetFeedSpecLinkURLs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAssetFeedSpecLinkURLs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAssetFeedSpecLinkURLs.add(AdAssetFeedSpecLinkURL.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAssetFeedSpecLinkURLs.add(AdAssetFeedSpecLinkURL.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAssetFeedSpecLinkURLs.add(AdAssetFeedSpecLinkURL.loadJSON(obj.toString(), context));
                        }
                    }
                    return adAssetFeedSpecLinkURLs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAssetFeedSpecLinkURLs.add(AdAssetFeedSpecLinkURL.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adAssetFeedSpecLinkURLs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAssetFeedSpecLinkURLs.add(AdAssetFeedSpecLinkURL.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAssetFeedSpecLinkURLs;
                }
                adAssetFeedSpecLinkURLs.clear();
                adAssetFeedSpecLinkURLs.add(AdAssetFeedSpecLinkURL.loadJSON(json, context));
                return adAssetFeedSpecLinkURLs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAssetFeedSpecLinkURL.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<AdAssetFeedSpecAssetLabel> getFieldAdlabels() {
        return this.mAdlabels;
    }

    public String getFieldCarouselSeeMoreUrl() {
        return this.mCarouselSeeMoreUrl;
    }

    public String getFieldDeeplinkUrl() {
        return this.mDeeplinkUrl;
    }

    public String getFieldDisplayUrl() {
        return this.mDisplayUrl;
    }

    public String getFieldUrlTags() {
        return this.mUrlTags;
    }

    public String getFieldWebsiteUrl() {
        return this.mWebsiteUrl;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAssetFeedSpecLinkURL copyFrom(AdAssetFeedSpecLinkURL instance) {
        this.mAdlabels = instance.mAdlabels;
        this.mCarouselSeeMoreUrl = instance.mCarouselSeeMoreUrl;
        this.mDeeplinkUrl = instance.mDeeplinkUrl;
        this.mDisplayUrl = instance.mDisplayUrl;
        this.mUrlTags = instance.mUrlTags;
        this.mWebsiteUrl = instance.mWebsiteUrl;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAssetFeedSpecLinkURL> getParser() {
        return new APIRequest.ResponseParser<AdAssetFeedSpecLinkURL>(){

            @Override
            public APINodeList<AdAssetFeedSpecLinkURL> parseResponse(String response, APIContext context, APIRequest<AdAssetFeedSpecLinkURL> request) throws APIException.MalformedResponseException {
                return AdAssetFeedSpecLinkURL.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdAssetFeedSpecLinkURL> {
        AdAssetFeedSpecLinkURL lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"adlabels", "carousel_see_more_url", "deeplink_url", "display_url", "url_tags", "website_url", "id"};

        @Override
        public AdAssetFeedSpecLinkURL getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAssetFeedSpecLinkURL parseResponse(String response) throws APIException {
            return AdAssetFeedSpecLinkURL.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAssetFeedSpecLinkURL execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAssetFeedSpecLinkURL execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAssetFeedSpecLinkURL> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAssetFeedSpecLinkURL> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAssetFeedSpecLinkURL>(){

                public AdAssetFeedSpecLinkURL apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdlabelsField() {
            return this.requestAdlabelsField(true);
        }

        public APIRequestGet requestAdlabelsField(boolean value) {
            this.requestField("adlabels", value);
            return this;
        }

        public APIRequestGet requestCarouselSeeMoreUrlField() {
            return this.requestCarouselSeeMoreUrlField(true);
        }

        public APIRequestGet requestCarouselSeeMoreUrlField(boolean value) {
            this.requestField("carousel_see_more_url", value);
            return this;
        }

        public APIRequestGet requestDeeplinkUrlField() {
            return this.requestDeeplinkUrlField(true);
        }

        public APIRequestGet requestDeeplinkUrlField(boolean value) {
            this.requestField("deeplink_url", value);
            return this;
        }

        public APIRequestGet requestDisplayUrlField() {
            return this.requestDisplayUrlField(true);
        }

        public APIRequestGet requestDisplayUrlField(boolean value) {
            this.requestField("display_url", value);
            return this;
        }

        public APIRequestGet requestUrlTagsField() {
            return this.requestUrlTagsField(true);
        }

        public APIRequestGet requestUrlTagsField(boolean value) {
            this.requestField("url_tags", value);
            return this;
        }

        public APIRequestGet requestWebsiteUrlField() {
            return this.requestWebsiteUrlField(true);
        }

        public APIRequestGet requestWebsiteUrlField(boolean value) {
            this.requestField("website_url", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

