/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAssetFeedSpecBody;
import com.facebook.ads.sdk.AdAssetFeedSpecCaption;
import com.facebook.ads.sdk.AdAssetFeedSpecDescription;
import com.facebook.ads.sdk.AdAssetFeedSpecGroupRule;
import com.facebook.ads.sdk.AdAssetFeedSpecImage;
import com.facebook.ads.sdk.AdAssetFeedSpecLinkURL;
import com.facebook.ads.sdk.AdAssetFeedSpecTitle;
import com.facebook.ads.sdk.AdAssetFeedSpecVideo;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAssetFeedSpec
extends APINode {
    @SerializedName(value="ad_formats")
    private List<String> mAdFormats = null;
    @SerializedName(value="additional_data")
    private Object mAdditionalData = null;
    @SerializedName(value="asset_customization_rules")
    private List<Object> mAssetCustomizationRules = null;
    @SerializedName(value="autotranslate")
    private List<String> mAutotranslate = null;
    @SerializedName(value="bodies")
    private List<AdAssetFeedSpecBody> mBodies = null;
    @SerializedName(value="call_to_action_types")
    private List<EnumCallToActionTypes> mCallToActionTypes = null;
    @SerializedName(value="captions")
    private List<AdAssetFeedSpecCaption> mCaptions = null;
    @SerializedName(value="descriptions")
    private List<AdAssetFeedSpecDescription> mDescriptions = null;
    @SerializedName(value="groups")
    private List<AdAssetFeedSpecGroupRule> mGroups = null;
    @SerializedName(value="images")
    private List<AdAssetFeedSpecImage> mImages = null;
    @SerializedName(value="link_urls")
    private List<AdAssetFeedSpecLinkURL> mLinkUrls = null;
    @SerializedName(value="optimization_type")
    private String mOptimizationType = null;
    @SerializedName(value="titles")
    private List<AdAssetFeedSpecTitle> mTitles = null;
    @SerializedName(value="videos")
    private List<AdAssetFeedSpecVideo> mVideos = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdAssetFeedSpec() {
    }

    public AdAssetFeedSpec(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdAssetFeedSpec(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdAssetFeedSpec fetch() throws APIException {
        AdAssetFeedSpec newInstance = AdAssetFeedSpec.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdAssetFeedSpec fetchById(Long id, APIContext context) throws APIException {
        return AdAssetFeedSpec.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdAssetFeedSpec> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdAssetFeedSpec.fetchByIdAsync(id.toString(), context);
    }

    public static AdAssetFeedSpec fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdAssetFeedSpec> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdAssetFeedSpec> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdAssetFeedSpec>(context, "", "/", "GET", AdAssetFeedSpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdAssetFeedSpec>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdAssetFeedSpec>(context, "", "/", "GET", AdAssetFeedSpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAssetFeedSpec loadJSON(String json, APIContext context) {
        AdAssetFeedSpec adAssetFeedSpec = (AdAssetFeedSpec)AdAssetFeedSpec.getGson().fromJson(json, AdAssetFeedSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAssetFeedSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAssetFeedSpec.context = context;
        adAssetFeedSpec.rawValue = json;
        return adAssetFeedSpec;
    }

    public static APINodeList<AdAssetFeedSpec> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAssetFeedSpec> adAssetFeedSpecs = new APINodeList<AdAssetFeedSpec>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAssetFeedSpecs.add(AdAssetFeedSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adAssetFeedSpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAssetFeedSpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAssetFeedSpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAssetFeedSpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAssetFeedSpecs.add(AdAssetFeedSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAssetFeedSpecs.add(AdAssetFeedSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAssetFeedSpecs.add(AdAssetFeedSpec.loadJSON(obj.toString(), context));
                        }
                    }
                    return adAssetFeedSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAssetFeedSpecs.add(AdAssetFeedSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adAssetFeedSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAssetFeedSpecs.add(AdAssetFeedSpec.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAssetFeedSpecs;
                }
                adAssetFeedSpecs.clear();
                adAssetFeedSpecs.add(AdAssetFeedSpec.loadJSON(json, context));
                return adAssetFeedSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAssetFeedSpec.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldAdFormats() {
        return this.mAdFormats;
    }

    public Object getFieldAdditionalData() {
        return this.mAdditionalData;
    }

    public List<Object> getFieldAssetCustomizationRules() {
        return this.mAssetCustomizationRules;
    }

    public List<String> getFieldAutotranslate() {
        return this.mAutotranslate;
    }

    public List<AdAssetFeedSpecBody> getFieldBodies() {
        return this.mBodies;
    }

    public List<EnumCallToActionTypes> getFieldCallToActionTypes() {
        return this.mCallToActionTypes;
    }

    public List<AdAssetFeedSpecCaption> getFieldCaptions() {
        return this.mCaptions;
    }

    public List<AdAssetFeedSpecDescription> getFieldDescriptions() {
        return this.mDescriptions;
    }

    public List<AdAssetFeedSpecGroupRule> getFieldGroups() {
        return this.mGroups;
    }

    public List<AdAssetFeedSpecImage> getFieldImages() {
        return this.mImages;
    }

    public List<AdAssetFeedSpecLinkURL> getFieldLinkUrls() {
        return this.mLinkUrls;
    }

    public String getFieldOptimizationType() {
        return this.mOptimizationType;
    }

    public List<AdAssetFeedSpecTitle> getFieldTitles() {
        return this.mTitles;
    }

    public List<AdAssetFeedSpecVideo> getFieldVideos() {
        return this.mVideos;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAssetFeedSpec copyFrom(AdAssetFeedSpec instance) {
        this.mAdFormats = instance.mAdFormats;
        this.mAdditionalData = instance.mAdditionalData;
        this.mAssetCustomizationRules = instance.mAssetCustomizationRules;
        this.mAutotranslate = instance.mAutotranslate;
        this.mBodies = instance.mBodies;
        this.mCallToActionTypes = instance.mCallToActionTypes;
        this.mCaptions = instance.mCaptions;
        this.mDescriptions = instance.mDescriptions;
        this.mGroups = instance.mGroups;
        this.mImages = instance.mImages;
        this.mLinkUrls = instance.mLinkUrls;
        this.mOptimizationType = instance.mOptimizationType;
        this.mTitles = instance.mTitles;
        this.mVideos = instance.mVideos;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAssetFeedSpec> getParser() {
        return new APIRequest.ResponseParser<AdAssetFeedSpec>(){

            @Override
            public APINodeList<AdAssetFeedSpec> parseResponse(String response, APIContext context, APIRequest<AdAssetFeedSpec> request) throws APIException.MalformedResponseException {
                return AdAssetFeedSpec.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumCallToActionTypes {
        VALUE_OPEN_LINK("OPEN_LINK"),
        VALUE_LIKE_PAGE("LIKE_PAGE"),
        VALUE_SHOP_NOW("SHOP_NOW"),
        VALUE_PLAY_GAME("PLAY_GAME"),
        VALUE_INSTALL_APP("INSTALL_APP"),
        VALUE_USE_APP("USE_APP"),
        VALUE_CALL("CALL"),
        VALUE_CALL_ME("CALL_ME"),
        VALUE_INSTALL_MOBILE_APP("INSTALL_MOBILE_APP"),
        VALUE_USE_MOBILE_APP("USE_MOBILE_APP"),
        VALUE_MOBILE_DOWNLOAD("MOBILE_DOWNLOAD"),
        VALUE_BOOK_TRAVEL("BOOK_TRAVEL"),
        VALUE_LISTEN_MUSIC("LISTEN_MUSIC"),
        VALUE_WATCH_VIDEO("WATCH_VIDEO"),
        VALUE_LEARN_MORE("LEARN_MORE"),
        VALUE_SIGN_UP("SIGN_UP"),
        VALUE_DOWNLOAD("DOWNLOAD"),
        VALUE_WATCH_MORE("WATCH_MORE"),
        VALUE_NO_BUTTON("NO_BUTTON"),
        VALUE_VISIT_PAGES_FEED("VISIT_PAGES_FEED"),
        VALUE_APPLY_NOW("APPLY_NOW"),
        VALUE_BUY_NOW("BUY_NOW"),
        VALUE_GET_OFFER("GET_OFFER"),
        VALUE_GET_OFFER_VIEW("GET_OFFER_VIEW"),
        VALUE_BUY_TICKETS("BUY_TICKETS"),
        VALUE_UPDATE_APP("UPDATE_APP"),
        VALUE_GET_DIRECTIONS("GET_DIRECTIONS"),
        VALUE_BUY("BUY"),
        VALUE_MESSAGE_PAGE("MESSAGE_PAGE"),
        VALUE_DONATE("DONATE"),
        VALUE_SUBSCRIBE("SUBSCRIBE"),
        VALUE_SAY_THANKS("SAY_THANKS"),
        VALUE_SELL_NOW("SELL_NOW"),
        VALUE_SHARE("SHARE"),
        VALUE_DONATE_NOW("DONATE_NOW"),
        VALUE_GET_QUOTE("GET_QUOTE"),
        VALUE_CONTACT_US("CONTACT_US"),
        VALUE_ORDER_NOW("ORDER_NOW"),
        VALUE_ADD_TO_CART("ADD_TO_CART"),
        VALUE_VIDEO_ANNOTATION("VIDEO_ANNOTATION"),
        VALUE_MOMENTS("MOMENTS"),
        VALUE_RECORD_NOW("RECORD_NOW"),
        VALUE_GET_SHOWTIMES("GET_SHOWTIMES"),
        VALUE_LISTEN_NOW("LISTEN_NOW"),
        VALUE_WOODHENGE_SUPPORT("WOODHENGE_SUPPORT"),
        VALUE_EVENT_RSVP("EVENT_RSVP"),
        VALUE_WHATSAPP_MESSAGE("WHATSAPP_MESSAGE"),
        VALUE_FOLLOW_NEWS_STORYLINE("FOLLOW_NEWS_STORYLINE"),
        NULL(null);

        private String value;

        private EnumCallToActionTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdAssetFeedSpec> {
        AdAssetFeedSpec lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_formats", "additional_data", "asset_customization_rules", "autotranslate", "bodies", "call_to_action_types", "captions", "descriptions", "groups", "images", "link_urls", "optimization_type", "titles", "videos", "id"};

        @Override
        public AdAssetFeedSpec getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAssetFeedSpec parseResponse(String response) throws APIException {
            return AdAssetFeedSpec.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAssetFeedSpec execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAssetFeedSpec execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAssetFeedSpec> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAssetFeedSpec> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAssetFeedSpec>(){

                public AdAssetFeedSpec apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdFormatsField() {
            return this.requestAdFormatsField(true);
        }

        public APIRequestGet requestAdFormatsField(boolean value) {
            this.requestField("ad_formats", value);
            return this;
        }

        public APIRequestGet requestAdditionalDataField() {
            return this.requestAdditionalDataField(true);
        }

        public APIRequestGet requestAdditionalDataField(boolean value) {
            this.requestField("additional_data", value);
            return this;
        }

        public APIRequestGet requestAssetCustomizationRulesField() {
            return this.requestAssetCustomizationRulesField(true);
        }

        public APIRequestGet requestAssetCustomizationRulesField(boolean value) {
            this.requestField("asset_customization_rules", value);
            return this;
        }

        public APIRequestGet requestAutotranslateField() {
            return this.requestAutotranslateField(true);
        }

        public APIRequestGet requestAutotranslateField(boolean value) {
            this.requestField("autotranslate", value);
            return this;
        }

        public APIRequestGet requestBodiesField() {
            return this.requestBodiesField(true);
        }

        public APIRequestGet requestBodiesField(boolean value) {
            this.requestField("bodies", value);
            return this;
        }

        public APIRequestGet requestCallToActionTypesField() {
            return this.requestCallToActionTypesField(true);
        }

        public APIRequestGet requestCallToActionTypesField(boolean value) {
            this.requestField("call_to_action_types", value);
            return this;
        }

        public APIRequestGet requestCaptionsField() {
            return this.requestCaptionsField(true);
        }

        public APIRequestGet requestCaptionsField(boolean value) {
            this.requestField("captions", value);
            return this;
        }

        public APIRequestGet requestDescriptionsField() {
            return this.requestDescriptionsField(true);
        }

        public APIRequestGet requestDescriptionsField(boolean value) {
            this.requestField("descriptions", value);
            return this;
        }

        public APIRequestGet requestGroupsField() {
            return this.requestGroupsField(true);
        }

        public APIRequestGet requestGroupsField(boolean value) {
            this.requestField("groups", value);
            return this;
        }

        public APIRequestGet requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGet requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGet requestLinkUrlsField() {
            return this.requestLinkUrlsField(true);
        }

        public APIRequestGet requestLinkUrlsField(boolean value) {
            this.requestField("link_urls", value);
            return this;
        }

        public APIRequestGet requestOptimizationTypeField() {
            return this.requestOptimizationTypeField(true);
        }

        public APIRequestGet requestOptimizationTypeField(boolean value) {
            this.requestField("optimization_type", value);
            return this;
        }

        public APIRequestGet requestTitlesField() {
            return this.requestTitlesField(true);
        }

        public APIRequestGet requestTitlesField(boolean value) {
            this.requestField("titles", value);
            return this;
        }

        public APIRequestGet requestVideosField() {
            return this.requestVideosField(true);
        }

        public APIRequestGet requestVideosField(boolean value) {
            this.requestField("videos", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

