/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdAccountCustomAudienceLimits
extends APINode {
    @SerializedName(value="audience_update_quota_in_total")
    private Long mAudienceUpdateQuotaInTotal = null;
    @SerializedName(value="audience_update_quota_left")
    private Double mAudienceUpdateQuotaLeft = null;
    @SerializedName(value="has_hit_audience_update_limit")
    private Boolean mHasHitAudienceUpdateLimit = null;
    @SerializedName(value="next_audience_update_available_time")
    private String mNextAudienceUpdateAvailableTime = null;
    @SerializedName(value="rate_limit_reset_time")
    private String mRateLimitResetTime = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdAccountCustomAudienceLimits() {
    }

    public AdAccountCustomAudienceLimits(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdAccountCustomAudienceLimits(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdAccountCustomAudienceLimits fetch() throws APIException {
        AdAccountCustomAudienceLimits newInstance = AdAccountCustomAudienceLimits.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdAccountCustomAudienceLimits fetchById(Long id, APIContext context) throws APIException {
        return AdAccountCustomAudienceLimits.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdAccountCustomAudienceLimits> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdAccountCustomAudienceLimits.fetchByIdAsync(id.toString(), context);
    }

    public static AdAccountCustomAudienceLimits fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdAccountCustomAudienceLimits> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdAccountCustomAudienceLimits> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdAccountCustomAudienceLimits>(context, "", "/", "GET", AdAccountCustomAudienceLimits.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdAccountCustomAudienceLimits>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdAccountCustomAudienceLimits>(context, "", "/", "GET", AdAccountCustomAudienceLimits.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAccountCustomAudienceLimits loadJSON(String json, APIContext context) {
        AdAccountCustomAudienceLimits adAccountCustomAudienceLimits = (AdAccountCustomAudienceLimits)AdAccountCustomAudienceLimits.getGson().fromJson(json, AdAccountCustomAudienceLimits.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAccountCustomAudienceLimits.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAccountCustomAudienceLimits.context = context;
        adAccountCustomAudienceLimits.rawValue = json;
        return adAccountCustomAudienceLimits;
    }

    public static APINodeList<AdAccountCustomAudienceLimits> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAccountCustomAudienceLimits> adAccountCustomAudienceLimitss = new APINodeList<AdAccountCustomAudienceLimits>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAccountCustomAudienceLimitss.add(AdAccountCustomAudienceLimits.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adAccountCustomAudienceLimitss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAccountCustomAudienceLimitss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAccountCustomAudienceLimitss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAccountCustomAudienceLimitss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAccountCustomAudienceLimitss.add(AdAccountCustomAudienceLimits.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAccountCustomAudienceLimitss.add(AdAccountCustomAudienceLimits.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAccountCustomAudienceLimitss.add(AdAccountCustomAudienceLimits.loadJSON(obj.toString(), context));
                        }
                    }
                    return adAccountCustomAudienceLimitss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAccountCustomAudienceLimitss.add(AdAccountCustomAudienceLimits.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adAccountCustomAudienceLimitss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAccountCustomAudienceLimitss.add(AdAccountCustomAudienceLimits.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAccountCustomAudienceLimitss;
                }
                adAccountCustomAudienceLimitss.clear();
                adAccountCustomAudienceLimitss.add(AdAccountCustomAudienceLimits.loadJSON(json, context));
                return adAccountCustomAudienceLimitss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAccountCustomAudienceLimits.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldAudienceUpdateQuotaInTotal() {
        return this.mAudienceUpdateQuotaInTotal;
    }

    public Double getFieldAudienceUpdateQuotaLeft() {
        return this.mAudienceUpdateQuotaLeft;
    }

    public Boolean getFieldHasHitAudienceUpdateLimit() {
        return this.mHasHitAudienceUpdateLimit;
    }

    public String getFieldNextAudienceUpdateAvailableTime() {
        return this.mNextAudienceUpdateAvailableTime;
    }

    public String getFieldRateLimitResetTime() {
        return this.mRateLimitResetTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAccountCustomAudienceLimits copyFrom(AdAccountCustomAudienceLimits instance) {
        this.mAudienceUpdateQuotaInTotal = instance.mAudienceUpdateQuotaInTotal;
        this.mAudienceUpdateQuotaLeft = instance.mAudienceUpdateQuotaLeft;
        this.mHasHitAudienceUpdateLimit = instance.mHasHitAudienceUpdateLimit;
        this.mNextAudienceUpdateAvailableTime = instance.mNextAudienceUpdateAvailableTime;
        this.mRateLimitResetTime = instance.mRateLimitResetTime;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAccountCustomAudienceLimits> getParser() {
        return new APIRequest.ResponseParser<AdAccountCustomAudienceLimits>(){

            @Override
            public APINodeList<AdAccountCustomAudienceLimits> parseResponse(String response, APIContext context, APIRequest<AdAccountCustomAudienceLimits> request) throws APIException.MalformedResponseException {
                return AdAccountCustomAudienceLimits.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdAccountCustomAudienceLimits> {
        AdAccountCustomAudienceLimits lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"audience_update_quota_in_total", "audience_update_quota_left", "has_hit_audience_update_limit", "next_audience_update_available_time", "rate_limit_reset_time", "id"};

        @Override
        public AdAccountCustomAudienceLimits getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdAccountCustomAudienceLimits parseResponse(String response) throws APIException {
            return AdAccountCustomAudienceLimits.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdAccountCustomAudienceLimits execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdAccountCustomAudienceLimits execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdAccountCustomAudienceLimits> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdAccountCustomAudienceLimits> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdAccountCustomAudienceLimits>(){

                public AdAccountCustomAudienceLimits apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAudienceUpdateQuotaInTotalField() {
            return this.requestAudienceUpdateQuotaInTotalField(true);
        }

        public APIRequestGet requestAudienceUpdateQuotaInTotalField(boolean value) {
            this.requestField("audience_update_quota_in_total", value);
            return this;
        }

        public APIRequestGet requestAudienceUpdateQuotaLeftField() {
            return this.requestAudienceUpdateQuotaLeftField(true);
        }

        public APIRequestGet requestAudienceUpdateQuotaLeftField(boolean value) {
            this.requestField("audience_update_quota_left", value);
            return this;
        }

        public APIRequestGet requestHasHitAudienceUpdateLimitField() {
            return this.requestHasHitAudienceUpdateLimitField(true);
        }

        public APIRequestGet requestHasHitAudienceUpdateLimitField(boolean value) {
            this.requestField("has_hit_audience_update_limit", value);
            return this;
        }

        public APIRequestGet requestNextAudienceUpdateAvailableTimeField() {
            return this.requestNextAudienceUpdateAvailableTimeField(true);
        }

        public APIRequestGet requestNextAudienceUpdateAvailableTimeField(boolean value) {
            this.requestField("next_audience_update_available_time", value);
            return this;
        }

        public APIRequestGet requestRateLimitResetTimeField() {
            return this.requestRateLimitResetTimeField(true);
        }

        public APIRequestGet requestRateLimitResetTimeField(boolean value) {
            this.requestField("rate_limit_reset_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

