/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductCatalogUserPermissions
extends APINode {
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="business_persona")
    private Object mBusinessPersona = null;
    @SerializedName(value="created_by")
    private User mCreatedBy = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="email")
    private String mEmail = null;
    @SerializedName(value="role")
    private String mRole = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="updated_by")
    private User mUpdatedBy = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="user")
    private User mUser = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    ProductCatalogUserPermissions() {
    }

    public ProductCatalogUserPermissions(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ProductCatalogUserPermissions(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ProductCatalogUserPermissions fetch() throws APIException {
        ProductCatalogUserPermissions newInstance = ProductCatalogUserPermissions.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ProductCatalogUserPermissions fetchById(Long id, APIContext context) throws APIException {
        return ProductCatalogUserPermissions.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ProductCatalogUserPermissions> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ProductCatalogUserPermissions.fetchByIdAsync(id.toString(), context);
    }

    public static ProductCatalogUserPermissions fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ProductCatalogUserPermissions> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ProductCatalogUserPermissions> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ProductCatalogUserPermissions>(context, "", "/", "GET", ProductCatalogUserPermissions.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ProductCatalogUserPermissions>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ProductCatalogUserPermissions>(context, "", "/", "GET", ProductCatalogUserPermissions.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductCatalogUserPermissions loadJSON(String json, APIContext context) {
        ProductCatalogUserPermissions productCatalogUserPermissions = (ProductCatalogUserPermissions)ProductCatalogUserPermissions.getGson().fromJson(json, ProductCatalogUserPermissions.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productCatalogUserPermissions.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productCatalogUserPermissions.context = context;
        productCatalogUserPermissions.rawValue = json;
        return productCatalogUserPermissions;
    }

    public static APINodeList<ProductCatalogUserPermissions> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductCatalogUserPermissions> productCatalogUserPermissionss = new APINodeList<ProductCatalogUserPermissions>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productCatalogUserPermissionss.add(ProductCatalogUserPermissions.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return productCatalogUserPermissionss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productCatalogUserPermissionss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productCatalogUserPermissionss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productCatalogUserPermissionss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productCatalogUserPermissionss.add(ProductCatalogUserPermissions.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productCatalogUserPermissionss.add(ProductCatalogUserPermissions.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productCatalogUserPermissionss.add(ProductCatalogUserPermissions.loadJSON(obj.toString(), context));
                        }
                    }
                    return productCatalogUserPermissionss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productCatalogUserPermissionss.add(ProductCatalogUserPermissions.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return productCatalogUserPermissionss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productCatalogUserPermissionss.add(ProductCatalogUserPermissions.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productCatalogUserPermissionss;
                }
                productCatalogUserPermissionss.clear();
                productCatalogUserPermissionss.add(ProductCatalogUserPermissions.loadJSON(json, context));
                return productCatalogUserPermissionss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductCatalogUserPermissions.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public Object getFieldBusinessPersona() {
        return this.mBusinessPersona;
    }

    public User getFieldCreatedBy() {
        if (this.mCreatedBy != null) {
            this.mCreatedBy.context = this.getContext();
        }
        return this.mCreatedBy;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldEmail() {
        return this.mEmail;
    }

    public String getFieldRole() {
        return this.mRole;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public User getFieldUpdatedBy() {
        if (this.mUpdatedBy != null) {
            this.mUpdatedBy.context = this.getContext();
        }
        return this.mUpdatedBy;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public User getFieldUser() {
        if (this.mUser != null) {
            this.mUser.context = this.getContext();
        }
        return this.mUser;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductCatalogUserPermissions copyFrom(ProductCatalogUserPermissions instance) {
        this.mBusiness = instance.mBusiness;
        this.mBusinessPersona = instance.mBusinessPersona;
        this.mCreatedBy = instance.mCreatedBy;
        this.mCreatedTime = instance.mCreatedTime;
        this.mEmail = instance.mEmail;
        this.mRole = instance.mRole;
        this.mStatus = instance.mStatus;
        this.mUpdatedBy = instance.mUpdatedBy;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mUser = instance.mUser;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductCatalogUserPermissions> getParser() {
        return new APIRequest.ResponseParser<ProductCatalogUserPermissions>(){

            @Override
            public APINodeList<ProductCatalogUserPermissions> parseResponse(String response, APIContext context, APIRequest<ProductCatalogUserPermissions> request) throws APIException.MalformedResponseException {
                return ProductCatalogUserPermissions.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ProductCatalogUserPermissions> {
        ProductCatalogUserPermissions lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "business_persona", "created_by", "created_time", "email", "role", "status", "updated_by", "updated_time", "user", "id"};

        @Override
        public ProductCatalogUserPermissions getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProductCatalogUserPermissions parseResponse(String response) throws APIException {
            return ProductCatalogUserPermissions.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ProductCatalogUserPermissions execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProductCatalogUserPermissions execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ProductCatalogUserPermissions> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ProductCatalogUserPermissions> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ProductCatalogUserPermissions>(){

                public ProductCatalogUserPermissions apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestBusinessPersonaField() {
            return this.requestBusinessPersonaField(true);
        }

        public APIRequestGet requestBusinessPersonaField(boolean value) {
            this.requestField("business_persona", value);
            return this;
        }

        public APIRequestGet requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGet requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestEmailField() {
            return this.requestEmailField(true);
        }

        public APIRequestGet requestEmailField(boolean value) {
            this.requestField("email", value);
            return this;
        }

        public APIRequestGet requestRoleField() {
            return this.requestRoleField(true);
        }

        public APIRequestGet requestRoleField(boolean value) {
            this.requestField("role", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGet requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGet requestUserField() {
            return this.requestUserField(true);
        }

        public APIRequestGet requestUserField(boolean value) {
            this.requestField("user", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

