/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.ProductCatalogImageSettingsOperation;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductCatalogImageSettings
extends APINode {
    @SerializedName(value="carousel_ad")
    private ProductCatalogImageSettingsOperation mCarouselAd = null;
    @SerializedName(value="single_ad")
    private ProductCatalogImageSettingsOperation mSingleAd = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    ProductCatalogImageSettings() {
    }

    public ProductCatalogImageSettings(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ProductCatalogImageSettings(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ProductCatalogImageSettings fetch() throws APIException {
        ProductCatalogImageSettings newInstance = ProductCatalogImageSettings.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ProductCatalogImageSettings fetchById(Long id, APIContext context) throws APIException {
        return ProductCatalogImageSettings.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ProductCatalogImageSettings> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ProductCatalogImageSettings.fetchByIdAsync(id.toString(), context);
    }

    public static ProductCatalogImageSettings fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ProductCatalogImageSettings> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ProductCatalogImageSettings> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ProductCatalogImageSettings>(context, "", "/", "GET", ProductCatalogImageSettings.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ProductCatalogImageSettings>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ProductCatalogImageSettings>(context, "", "/", "GET", ProductCatalogImageSettings.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ProductCatalogImageSettings loadJSON(String json, APIContext context) {
        ProductCatalogImageSettings productCatalogImageSettings = (ProductCatalogImageSettings)ProductCatalogImageSettings.getGson().fromJson(json, ProductCatalogImageSettings.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productCatalogImageSettings.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productCatalogImageSettings.context = context;
        productCatalogImageSettings.rawValue = json;
        return productCatalogImageSettings;
    }

    public static APINodeList<ProductCatalogImageSettings> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductCatalogImageSettings> productCatalogImageSettingss = new APINodeList<ProductCatalogImageSettings>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productCatalogImageSettingss.add(ProductCatalogImageSettings.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return productCatalogImageSettingss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productCatalogImageSettingss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productCatalogImageSettingss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productCatalogImageSettingss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productCatalogImageSettingss.add(ProductCatalogImageSettings.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productCatalogImageSettingss.add(ProductCatalogImageSettings.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productCatalogImageSettingss.add(ProductCatalogImageSettings.loadJSON(obj.toString(), context));
                        }
                    }
                    return productCatalogImageSettingss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productCatalogImageSettingss.add(ProductCatalogImageSettings.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return productCatalogImageSettingss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productCatalogImageSettingss.add(ProductCatalogImageSettings.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productCatalogImageSettingss;
                }
                productCatalogImageSettingss.clear();
                productCatalogImageSettingss.add(ProductCatalogImageSettings.loadJSON(json, context));
                return productCatalogImageSettingss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductCatalogImageSettings.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public ProductCatalogImageSettingsOperation getFieldCarouselAd() {
        if (this.mCarouselAd != null) {
            this.mCarouselAd.context = this.getContext();
        }
        return this.mCarouselAd;
    }

    public ProductCatalogImageSettingsOperation getFieldSingleAd() {
        if (this.mSingleAd != null) {
            this.mSingleAd.context = this.getContext();
        }
        return this.mSingleAd;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductCatalogImageSettings copyFrom(ProductCatalogImageSettings instance) {
        this.mCarouselAd = instance.mCarouselAd;
        this.mSingleAd = instance.mSingleAd;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductCatalogImageSettings> getParser() {
        return new APIRequest.ResponseParser<ProductCatalogImageSettings>(){

            @Override
            public APINodeList<ProductCatalogImageSettings> parseResponse(String response, APIContext context, APIRequest<ProductCatalogImageSettings> request) throws APIException.MalformedResponseException {
                return ProductCatalogImageSettings.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<ProductCatalogImageSettings> {
        ProductCatalogImageSettings lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"carousel_ad", "single_ad", "id"};

        @Override
        public ProductCatalogImageSettings getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProductCatalogImageSettings parseResponse(String response) throws APIException {
            return ProductCatalogImageSettings.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public ProductCatalogImageSettings execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProductCatalogImageSettings execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<ProductCatalogImageSettings> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ProductCatalogImageSettings> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, ProductCatalogImageSettings>(){

                public ProductCatalogImageSettings apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCarouselAdField() {
            return this.requestCarouselAdField(true);
        }

        public APIRequestGet requestCarouselAdField(boolean value) {
            this.requestField("carousel_ad", value);
            return this;
        }

        public APIRequestGet requestSingleAdField() {
            return this.requestSingleAdField(true);
        }

        public APIRequestGet requestSingleAdField(boolean value) {
            this.requestField("single_ad", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

