/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderIDAttributions
extends APINode {
    @SerializedName(value="app_id")
    private String mAppId = null;
    @SerializedName(value="attribution_type")
    private String mAttributionType = null;
    @SerializedName(value="attributions")
    private List<Object> mAttributions = null;
    @SerializedName(value="conversion_device")
    private String mConversionDevice = null;
    @SerializedName(value="dataset_id")
    private String mDatasetId = null;
    @SerializedName(value="holdout_status")
    private List<Object> mHoldoutStatus = null;
    @SerializedName(value="order_id")
    private String mOrderId = null;
    @SerializedName(value="order_timestamp")
    private String mOrderTimestamp = null;
    @SerializedName(value="pixel_id")
    private String mPixelId = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    OrderIDAttributions() {
    }

    public OrderIDAttributions(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public OrderIDAttributions(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public OrderIDAttributions fetch() throws APIException {
        OrderIDAttributions newInstance = OrderIDAttributions.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static OrderIDAttributions fetchById(Long id, APIContext context) throws APIException {
        return OrderIDAttributions.fetchById(id.toString(), context);
    }

    public static ListenableFuture<OrderIDAttributions> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return OrderIDAttributions.fetchByIdAsync(id.toString(), context);
    }

    public static OrderIDAttributions fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<OrderIDAttributions> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<OrderIDAttributions> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<OrderIDAttributions>(context, "", "/", "GET", OrderIDAttributions.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<OrderIDAttributions>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<OrderIDAttributions>(context, "", "/", "GET", OrderIDAttributions.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static OrderIDAttributions loadJSON(String json, APIContext context) {
        OrderIDAttributions orderIDAttributions = (OrderIDAttributions)OrderIDAttributions.getGson().fromJson(json, OrderIDAttributions.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(orderIDAttributions.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        orderIDAttributions.context = context;
        orderIDAttributions.rawValue = json;
        return orderIDAttributions;
    }

    public static APINodeList<OrderIDAttributions> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<OrderIDAttributions> orderIDAttributionss = new APINodeList<OrderIDAttributions>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        orderIDAttributionss.add(OrderIDAttributions.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return orderIDAttributionss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            orderIDAttributionss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        orderIDAttributionss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            orderIDAttributionss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            orderIDAttributionss.add(OrderIDAttributions.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                orderIDAttributionss.add(OrderIDAttributions.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            orderIDAttributionss.add(OrderIDAttributions.loadJSON(obj.toString(), context));
                        }
                    }
                    return orderIDAttributionss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        orderIDAttributionss.add(OrderIDAttributions.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return orderIDAttributionss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        orderIDAttributionss.add(OrderIDAttributions.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return orderIDAttributionss;
                }
                orderIDAttributionss.clear();
                orderIDAttributionss.add(OrderIDAttributions.loadJSON(json, context));
                return orderIDAttributionss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return OrderIDAttributions.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAppId() {
        return this.mAppId;
    }

    public String getFieldAttributionType() {
        return this.mAttributionType;
    }

    public List<Object> getFieldAttributions() {
        return this.mAttributions;
    }

    public String getFieldConversionDevice() {
        return this.mConversionDevice;
    }

    public String getFieldDatasetId() {
        return this.mDatasetId;
    }

    public List<Object> getFieldHoldoutStatus() {
        return this.mHoldoutStatus;
    }

    public String getFieldOrderId() {
        return this.mOrderId;
    }

    public String getFieldOrderTimestamp() {
        return this.mOrderTimestamp;
    }

    public String getFieldPixelId() {
        return this.mPixelId;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public OrderIDAttributions copyFrom(OrderIDAttributions instance) {
        this.mAppId = instance.mAppId;
        this.mAttributionType = instance.mAttributionType;
        this.mAttributions = instance.mAttributions;
        this.mConversionDevice = instance.mConversionDevice;
        this.mDatasetId = instance.mDatasetId;
        this.mHoldoutStatus = instance.mHoldoutStatus;
        this.mOrderId = instance.mOrderId;
        this.mOrderTimestamp = instance.mOrderTimestamp;
        this.mPixelId = instance.mPixelId;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<OrderIDAttributions> getParser() {
        return new APIRequest.ResponseParser<OrderIDAttributions>(){

            @Override
            public APINodeList<OrderIDAttributions> parseResponse(String response, APIContext context, APIRequest<OrderIDAttributions> request) throws APIException.MalformedResponseException {
                return OrderIDAttributions.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<OrderIDAttributions> {
        OrderIDAttributions lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"app_id", "attribution_type", "attributions", "conversion_device", "dataset_id", "holdout_status", "order_id", "order_timestamp", "pixel_id", "id"};

        @Override
        public OrderIDAttributions getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public OrderIDAttributions parseResponse(String response) throws APIException {
            return OrderIDAttributions.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public OrderIDAttributions execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public OrderIDAttributions execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<OrderIDAttributions> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<OrderIDAttributions> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, OrderIDAttributions>(){

                public OrderIDAttributions apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGet requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGet requestAttributionTypeField() {
            return this.requestAttributionTypeField(true);
        }

        public APIRequestGet requestAttributionTypeField(boolean value) {
            this.requestField("attribution_type", value);
            return this;
        }

        public APIRequestGet requestAttributionsField() {
            return this.requestAttributionsField(true);
        }

        public APIRequestGet requestAttributionsField(boolean value) {
            this.requestField("attributions", value);
            return this;
        }

        public APIRequestGet requestConversionDeviceField() {
            return this.requestConversionDeviceField(true);
        }

        public APIRequestGet requestConversionDeviceField(boolean value) {
            this.requestField("conversion_device", value);
            return this;
        }

        public APIRequestGet requestDatasetIdField() {
            return this.requestDatasetIdField(true);
        }

        public APIRequestGet requestDatasetIdField(boolean value) {
            this.requestField("dataset_id", value);
            return this;
        }

        public APIRequestGet requestHoldoutStatusField() {
            return this.requestHoldoutStatusField(true);
        }

        public APIRequestGet requestHoldoutStatusField(boolean value) {
            this.requestField("holdout_status", value);
            return this;
        }

        public APIRequestGet requestOrderIdField() {
            return this.requestOrderIdField(true);
        }

        public APIRequestGet requestOrderIdField(boolean value) {
            this.requestField("order_id", value);
            return this;
        }

        public APIRequestGet requestOrderTimestampField() {
            return this.requestOrderTimestampField(true);
        }

        public APIRequestGet requestOrderTimestampField(boolean value) {
            this.requestField("order_timestamp", value);
            return this;
        }

        public APIRequestGet requestPixelIdField() {
            return this.requestPixelIdField(true);
        }

        public APIRequestGet requestPixelIdField(boolean value) {
            this.requestField("pixel_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

