/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrencyAmount
extends APINode {
    @SerializedName(value="amount")
    private String mAmount = null;
    @SerializedName(value="amount_in_hundredths")
    private String mAmountInHundredths = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="offsetted_amount")
    private String mOffsettedAmount = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    CurrencyAmount() {
    }

    public CurrencyAmount(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CurrencyAmount(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CurrencyAmount fetch() throws APIException {
        CurrencyAmount newInstance = CurrencyAmount.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CurrencyAmount fetchById(Long id, APIContext context) throws APIException {
        return CurrencyAmount.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CurrencyAmount> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CurrencyAmount.fetchByIdAsync(id.toString(), context);
    }

    public static CurrencyAmount fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CurrencyAmount> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CurrencyAmount> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CurrencyAmount>(context, "", "/", "GET", CurrencyAmount.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CurrencyAmount>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CurrencyAmount>(context, "", "/", "GET", CurrencyAmount.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CurrencyAmount loadJSON(String json, APIContext context) {
        CurrencyAmount currencyAmount = (CurrencyAmount)CurrencyAmount.getGson().fromJson(json, CurrencyAmount.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(currencyAmount.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        currencyAmount.context = context;
        currencyAmount.rawValue = json;
        return currencyAmount;
    }

    public static APINodeList<CurrencyAmount> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CurrencyAmount> currencyAmounts = new APINodeList<CurrencyAmount>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        currencyAmounts.add(CurrencyAmount.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return currencyAmounts;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            currencyAmounts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        currencyAmounts.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            currencyAmounts.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            currencyAmounts.add(CurrencyAmount.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                currencyAmounts.add(CurrencyAmount.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            currencyAmounts.add(CurrencyAmount.loadJSON(obj.toString(), context));
                        }
                    }
                    return currencyAmounts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        currencyAmounts.add(CurrencyAmount.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return currencyAmounts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        currencyAmounts.add(CurrencyAmount.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return currencyAmounts;
                }
                currencyAmounts.clear();
                currencyAmounts.add(CurrencyAmount.loadJSON(json, context));
                return currencyAmounts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CurrencyAmount.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAmount() {
        return this.mAmount;
    }

    public String getFieldAmountInHundredths() {
        return this.mAmountInHundredths;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldOffsettedAmount() {
        return this.mOffsettedAmount;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CurrencyAmount copyFrom(CurrencyAmount instance) {
        this.mAmount = instance.mAmount;
        this.mAmountInHundredths = instance.mAmountInHundredths;
        this.mCurrency = instance.mCurrency;
        this.mOffsettedAmount = instance.mOffsettedAmount;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CurrencyAmount> getParser() {
        return new APIRequest.ResponseParser<CurrencyAmount>(){

            @Override
            public APINodeList<CurrencyAmount> parseResponse(String response, APIContext context, APIRequest<CurrencyAmount> request) throws APIException.MalformedResponseException {
                return CurrencyAmount.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<CurrencyAmount> {
        CurrencyAmount lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"amount", "amount_in_hundredths", "currency", "offsetted_amount", "id"};

        @Override
        public CurrencyAmount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CurrencyAmount parseResponse(String response) throws APIException {
            return CurrencyAmount.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public CurrencyAmount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CurrencyAmount execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<CurrencyAmount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CurrencyAmount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CurrencyAmount>(){

                public CurrencyAmount apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAmountField() {
            return this.requestAmountField(true);
        }

        public APIRequestGet requestAmountField(boolean value) {
            this.requestField("amount", value);
            return this;
        }

        public APIRequestGet requestAmountInHundredthsField() {
            return this.requestAmountInHundredthsField(true);
        }

        public APIRequestGet requestAmountInHundredthsField(boolean value) {
            this.requestField("amount_in_hundredths", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestOffsettedAmountField() {
            return this.requestOffsettedAmountField(true);
        }

        public APIRequestGet requestOffsettedAmountField(boolean value) {
            this.requestField("offsetted_amount", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

